import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface RecaptchaEnterpriseKeyConfig extends cdktf.TerraformMetaArguments {
    /**
    * Human-readable display name of this key. Modifiable by user.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/recaptcha_enterprise_key#display_name RecaptchaEnterpriseKey#display_name}
    */
    readonly displayName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/recaptcha_enterprise_key#id RecaptchaEnterpriseKey#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * See [Creating and managing labels](https://cloud.google.com/recaptcha-enterprise/docs/labels).
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/recaptcha_enterprise_key#labels RecaptchaEnterpriseKey#labels}
    */
    readonly labels?: {
        [key: string]: string;
    };
    /**
    * The project for the resource
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/recaptcha_enterprise_key#project RecaptchaEnterpriseKey#project}
    */
    readonly project?: string;
    /**
    * android_settings block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/recaptcha_enterprise_key#android_settings RecaptchaEnterpriseKey#android_settings}
    */
    readonly androidSettings?: RecaptchaEnterpriseKeyAndroidSettings;
    /**
    * ios_settings block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/recaptcha_enterprise_key#ios_settings RecaptchaEnterpriseKey#ios_settings}
    */
    readonly iosSettings?: RecaptchaEnterpriseKeyIosSettings;
    /**
    * testing_options block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/recaptcha_enterprise_key#testing_options RecaptchaEnterpriseKey#testing_options}
    */
    readonly testingOptions?: RecaptchaEnterpriseKeyTestingOptions;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/recaptcha_enterprise_key#timeouts RecaptchaEnterpriseKey#timeouts}
    */
    readonly timeouts?: RecaptchaEnterpriseKeyTimeouts;
    /**
    * web_settings block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/recaptcha_enterprise_key#web_settings RecaptchaEnterpriseKey#web_settings}
    */
    readonly webSettings?: RecaptchaEnterpriseKeyWebSettings;
}
export interface RecaptchaEnterpriseKeyAndroidSettings {
    /**
    * If set to true, it means allowed_package_names will not be enforced.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/recaptcha_enterprise_key#allow_all_package_names RecaptchaEnterpriseKey#allow_all_package_names}
    */
    readonly allowAllPackageNames?: boolean | cdktf.IResolvable;
    /**
    * Android package names of apps allowed to use the key. Example: 'com.companyname.appname'
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/recaptcha_enterprise_key#allowed_package_names RecaptchaEnterpriseKey#allowed_package_names}
    */
    readonly allowedPackageNames?: string[];
}
export declare function recaptchaEnterpriseKeyAndroidSettingsToTerraform(struct?: RecaptchaEnterpriseKeyAndroidSettingsOutputReference | RecaptchaEnterpriseKeyAndroidSettings): any;
export declare class RecaptchaEnterpriseKeyAndroidSettingsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): RecaptchaEnterpriseKeyAndroidSettings | undefined;
    set internalValue(value: RecaptchaEnterpriseKeyAndroidSettings | undefined);
    private _allowAllPackageNames?;
    get allowAllPackageNames(): boolean | cdktf.IResolvable;
    set allowAllPackageNames(value: boolean | cdktf.IResolvable);
    resetAllowAllPackageNames(): void;
    get allowAllPackageNamesInput(): boolean | cdktf.IResolvable | undefined;
    private _allowedPackageNames?;
    get allowedPackageNames(): string[];
    set allowedPackageNames(value: string[]);
    resetAllowedPackageNames(): void;
    get allowedPackageNamesInput(): string[] | undefined;
}
export interface RecaptchaEnterpriseKeyIosSettings {
    /**
    * If set to true, it means allowed_bundle_ids will not be enforced.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/recaptcha_enterprise_key#allow_all_bundle_ids RecaptchaEnterpriseKey#allow_all_bundle_ids}
    */
    readonly allowAllBundleIds?: boolean | cdktf.IResolvable;
    /**
    * iOS bundle ids of apps allowed to use the key. Example: 'com.companyname.productname.appname'
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/recaptcha_enterprise_key#allowed_bundle_ids RecaptchaEnterpriseKey#allowed_bundle_ids}
    */
    readonly allowedBundleIds?: string[];
}
export declare function recaptchaEnterpriseKeyIosSettingsToTerraform(struct?: RecaptchaEnterpriseKeyIosSettingsOutputReference | RecaptchaEnterpriseKeyIosSettings): any;
export declare class RecaptchaEnterpriseKeyIosSettingsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): RecaptchaEnterpriseKeyIosSettings | undefined;
    set internalValue(value: RecaptchaEnterpriseKeyIosSettings | undefined);
    private _allowAllBundleIds?;
    get allowAllBundleIds(): boolean | cdktf.IResolvable;
    set allowAllBundleIds(value: boolean | cdktf.IResolvable);
    resetAllowAllBundleIds(): void;
    get allowAllBundleIdsInput(): boolean | cdktf.IResolvable | undefined;
    private _allowedBundleIds?;
    get allowedBundleIds(): string[];
    set allowedBundleIds(value: string[]);
    resetAllowedBundleIds(): void;
    get allowedBundleIdsInput(): string[] | undefined;
}
export interface RecaptchaEnterpriseKeyTestingOptions {
    /**
    * For challenge-based keys only (CHECKBOX, INVISIBLE), all challenge requests for this site will return nocaptcha if NOCAPTCHA, or an unsolvable challenge if UNSOLVABLE_CHALLENGE. Possible values: TESTING_CHALLENGE_UNSPECIFIED, NOCAPTCHA, UNSOLVABLE_CHALLENGE
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/recaptcha_enterprise_key#testing_challenge RecaptchaEnterpriseKey#testing_challenge}
    */
    readonly testingChallenge?: string;
    /**
    * All assessments for this Key will return this score. Must be between 0 (likely not legitimate) and 1 (likely legitimate) inclusive.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/recaptcha_enterprise_key#testing_score RecaptchaEnterpriseKey#testing_score}
    */
    readonly testingScore?: number;
}
export declare function recaptchaEnterpriseKeyTestingOptionsToTerraform(struct?: RecaptchaEnterpriseKeyTestingOptionsOutputReference | RecaptchaEnterpriseKeyTestingOptions): any;
export declare class RecaptchaEnterpriseKeyTestingOptionsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): RecaptchaEnterpriseKeyTestingOptions | undefined;
    set internalValue(value: RecaptchaEnterpriseKeyTestingOptions | undefined);
    private _testingChallenge?;
    get testingChallenge(): string;
    set testingChallenge(value: string);
    resetTestingChallenge(): void;
    get testingChallengeInput(): string | undefined;
    private _testingScore?;
    get testingScore(): number;
    set testingScore(value: number);
    resetTestingScore(): void;
    get testingScoreInput(): number | undefined;
}
export interface RecaptchaEnterpriseKeyTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/recaptcha_enterprise_key#create RecaptchaEnterpriseKey#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/recaptcha_enterprise_key#delete RecaptchaEnterpriseKey#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/recaptcha_enterprise_key#update RecaptchaEnterpriseKey#update}
    */
    readonly update?: string;
}
export declare function recaptchaEnterpriseKeyTimeoutsToTerraform(struct?: RecaptchaEnterpriseKeyTimeoutsOutputReference | RecaptchaEnterpriseKeyTimeouts | cdktf.IResolvable): any;
export declare class RecaptchaEnterpriseKeyTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): RecaptchaEnterpriseKeyTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: RecaptchaEnterpriseKeyTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
export interface RecaptchaEnterpriseKeyWebSettings {
    /**
    * If set to true, it means allowed_domains will not be enforced.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/recaptcha_enterprise_key#allow_all_domains RecaptchaEnterpriseKey#allow_all_domains}
    */
    readonly allowAllDomains?: boolean | cdktf.IResolvable;
    /**
    * If set to true, the key can be used on AMP (Accelerated Mobile Pages) websites. This is supported only for the SCORE integration type.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/recaptcha_enterprise_key#allow_amp_traffic RecaptchaEnterpriseKey#allow_amp_traffic}
    */
    readonly allowAmpTraffic?: boolean | cdktf.IResolvable;
    /**
    * Domains or subdomains of websites allowed to use the key. All subdomains of an allowed domain are automatically allowed. A valid domain requires a host and must not include any path, port, query or fragment. Examples: 'example.com' or 'subdomain.example.com'
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/recaptcha_enterprise_key#allowed_domains RecaptchaEnterpriseKey#allowed_domains}
    */
    readonly allowedDomains?: string[];
    /**
    * Settings for the frequency and difficulty at which this key triggers captcha challenges. This should only be specified for IntegrationTypes CHECKBOX and INVISIBLE. Possible values: CHALLENGE_SECURITY_PREFERENCE_UNSPECIFIED, USABILITY, BALANCE, SECURITY
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/recaptcha_enterprise_key#challenge_security_preference RecaptchaEnterpriseKey#challenge_security_preference}
    */
    readonly challengeSecurityPreference?: string;
    /**
    * Required. Describes how this key is integrated with the website. Possible values: SCORE, CHECKBOX, INVISIBLE
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/recaptcha_enterprise_key#integration_type RecaptchaEnterpriseKey#integration_type}
    */
    readonly integrationType: string;
}
export declare function recaptchaEnterpriseKeyWebSettingsToTerraform(struct?: RecaptchaEnterpriseKeyWebSettingsOutputReference | RecaptchaEnterpriseKeyWebSettings): any;
export declare class RecaptchaEnterpriseKeyWebSettingsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): RecaptchaEnterpriseKeyWebSettings | undefined;
    set internalValue(value: RecaptchaEnterpriseKeyWebSettings | undefined);
    private _allowAllDomains?;
    get allowAllDomains(): boolean | cdktf.IResolvable;
    set allowAllDomains(value: boolean | cdktf.IResolvable);
    resetAllowAllDomains(): void;
    get allowAllDomainsInput(): boolean | cdktf.IResolvable | undefined;
    private _allowAmpTraffic?;
    get allowAmpTraffic(): boolean | cdktf.IResolvable;
    set allowAmpTraffic(value: boolean | cdktf.IResolvable);
    resetAllowAmpTraffic(): void;
    get allowAmpTrafficInput(): boolean | cdktf.IResolvable | undefined;
    private _allowedDomains?;
    get allowedDomains(): string[];
    set allowedDomains(value: string[]);
    resetAllowedDomains(): void;
    get allowedDomainsInput(): string[] | undefined;
    private _challengeSecurityPreference?;
    get challengeSecurityPreference(): string;
    set challengeSecurityPreference(value: string);
    resetChallengeSecurityPreference(): void;
    get challengeSecurityPreferenceInput(): string | undefined;
    private _integrationType?;
    get integrationType(): string;
    set integrationType(value: string);
    get integrationTypeInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/r/recaptcha_enterprise_key google_recaptcha_enterprise_key}
*/
export declare class RecaptchaEnterpriseKey extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_recaptcha_enterprise_key";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/r/recaptcha_enterprise_key google_recaptcha_enterprise_key} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options RecaptchaEnterpriseKeyConfig
    */
    constructor(scope: Construct, id: string, config: RecaptchaEnterpriseKeyConfig);
    get createTime(): string;
    private _displayName?;
    get displayName(): string;
    set displayName(value: string);
    get displayNameInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _labels?;
    get labels(): {
        [key: string]: string;
    };
    set labels(value: {
        [key: string]: string;
    });
    resetLabels(): void;
    get labelsInput(): {
        [key: string]: string;
    } | undefined;
    get name(): string;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _androidSettings;
    get androidSettings(): RecaptchaEnterpriseKeyAndroidSettingsOutputReference;
    putAndroidSettings(value: RecaptchaEnterpriseKeyAndroidSettings): void;
    resetAndroidSettings(): void;
    get androidSettingsInput(): RecaptchaEnterpriseKeyAndroidSettings | undefined;
    private _iosSettings;
    get iosSettings(): RecaptchaEnterpriseKeyIosSettingsOutputReference;
    putIosSettings(value: RecaptchaEnterpriseKeyIosSettings): void;
    resetIosSettings(): void;
    get iosSettingsInput(): RecaptchaEnterpriseKeyIosSettings | undefined;
    private _testingOptions;
    get testingOptions(): RecaptchaEnterpriseKeyTestingOptionsOutputReference;
    putTestingOptions(value: RecaptchaEnterpriseKeyTestingOptions): void;
    resetTestingOptions(): void;
    get testingOptionsInput(): RecaptchaEnterpriseKeyTestingOptions | undefined;
    private _timeouts;
    get timeouts(): RecaptchaEnterpriseKeyTimeoutsOutputReference;
    putTimeouts(value: RecaptchaEnterpriseKeyTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | RecaptchaEnterpriseKeyTimeouts | undefined;
    private _webSettings;
    get webSettings(): RecaptchaEnterpriseKeyWebSettingsOutputReference;
    putWebSettings(value: RecaptchaEnterpriseKeyWebSettings): void;
    resetWebSettings(): void;
    get webSettingsInput(): RecaptchaEnterpriseKeyWebSettings | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
