import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface SccSourceIamMemberConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/scc_source_iam_member#id SccSourceIamMember#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/scc_source_iam_member#member SccSourceIamMember#member}
    */
    readonly member: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/scc_source_iam_member#organization SccSourceIamMember#organization}
    */
    readonly organization: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/scc_source_iam_member#role SccSourceIamMember#role}
    */
    readonly role: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/scc_source_iam_member#source SccSourceIamMember#source}
    */
    readonly source: string;
    /**
    * condition block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/scc_source_iam_member#condition SccSourceIamMember#condition}
    */
    readonly condition?: SccSourceIamMemberCondition;
}
export interface SccSourceIamMemberCondition {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/scc_source_iam_member#description SccSourceIamMember#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/scc_source_iam_member#expression SccSourceIamMember#expression}
    */
    readonly expression: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/scc_source_iam_member#title SccSourceIamMember#title}
    */
    readonly title: string;
}
export declare function sccSourceIamMemberConditionToTerraform(struct?: SccSourceIamMemberConditionOutputReference | SccSourceIamMemberCondition): any;
export declare class SccSourceIamMemberConditionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): SccSourceIamMemberCondition | undefined;
    set internalValue(value: SccSourceIamMemberCondition | undefined);
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _expression?;
    get expression(): string;
    set expression(value: string);
    get expressionInput(): string | undefined;
    private _title?;
    get title(): string;
    set title(value: string);
    get titleInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/r/scc_source_iam_member google_scc_source_iam_member}
*/
export declare class SccSourceIamMember extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_scc_source_iam_member";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/r/scc_source_iam_member google_scc_source_iam_member} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options SccSourceIamMemberConfig
    */
    constructor(scope: Construct, id: string, config: SccSourceIamMemberConfig);
    get etag(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _member?;
    get member(): string;
    set member(value: string);
    get memberInput(): string | undefined;
    private _organization?;
    get organization(): string;
    set organization(value: string);
    get organizationInput(): string | undefined;
    private _role?;
    get role(): string;
    set role(value: string);
    get roleInput(): string | undefined;
    private _source?;
    get source(): string;
    set source(value: string);
    get sourceInput(): string | undefined;
    private _condition;
    get condition(): SccSourceIamMemberConditionOutputReference;
    putCondition(value: SccSourceIamMemberCondition): void;
    resetCondition(): void;
    get conditionInput(): SccSourceIamMemberCondition | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
