import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface SecretManagerSecretIamPolicyConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/secret_manager_secret_iam_policy#id SecretManagerSecretIamPolicy#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/secret_manager_secret_iam_policy#policy_data SecretManagerSecretIamPolicy#policy_data}
    */
    readonly policyData: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/secret_manager_secret_iam_policy#project SecretManagerSecretIamPolicy#project}
    */
    readonly project?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/secret_manager_secret_iam_policy#secret_id SecretManagerSecretIamPolicy#secret_id}
    */
    readonly secretId: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/r/secret_manager_secret_iam_policy google_secret_manager_secret_iam_policy}
*/
export declare class SecretManagerSecretIamPolicy extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_secret_manager_secret_iam_policy";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/r/secret_manager_secret_iam_policy google_secret_manager_secret_iam_policy} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options SecretManagerSecretIamPolicyConfig
    */
    constructor(scope: Construct, id: string, config: SecretManagerSecretIamPolicyConfig);
    get etag(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _policyData?;
    get policyData(): string;
    set policyData(value: string);
    get policyDataInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _secretId?;
    get secretId(): string;
    set secretId(value: string);
    get secretIdInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
