import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ServiceAccountConfig extends cdktf.TerraformMetaArguments {
    /**
    * The account id that is used to generate the service account email address and a stable unique id. It is unique within a project, must be 6-30 characters long, and match the regular expression [a-z]([-a-z0-9]*[a-z0-9]) to comply with RFC1035. Changing this forces a new service account to be created.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/service_account#account_id ServiceAccount#account_id}
    */
    readonly accountId: string;
    /**
    * A text description of the service account. Must be less than or equal to 256 UTF-8 bytes.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/service_account#description ServiceAccount#description}
    */
    readonly description?: string;
    /**
    * Whether the service account is disabled. Defaults to false
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/service_account#disabled ServiceAccount#disabled}
    */
    readonly disabled?: boolean | cdktf.IResolvable;
    /**
    * The display name for the service account. Can be updated without creating a new resource.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/service_account#display_name ServiceAccount#display_name}
    */
    readonly displayName?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/service_account#id ServiceAccount#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The ID of the project that the service account will be created in. Defaults to the provider project configuration.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/service_account#project ServiceAccount#project}
    */
    readonly project?: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/service_account#timeouts ServiceAccount#timeouts}
    */
    readonly timeouts?: ServiceAccountTimeouts;
}
export interface ServiceAccountTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/service_account#create ServiceAccount#create}
    */
    readonly create?: string;
}
export declare function serviceAccountTimeoutsToTerraform(struct?: ServiceAccountTimeoutsOutputReference | ServiceAccountTimeouts | cdktf.IResolvable): any;
export declare class ServiceAccountTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ServiceAccountTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: ServiceAccountTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/r/service_account google_service_account}
*/
export declare class ServiceAccount extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_service_account";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/r/service_account google_service_account} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ServiceAccountConfig
    */
    constructor(scope: Construct, id: string, config: ServiceAccountConfig);
    private _accountId?;
    get accountId(): string;
    set accountId(value: string);
    get accountIdInput(): string | undefined;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _disabled?;
    get disabled(): boolean | cdktf.IResolvable;
    set disabled(value: boolean | cdktf.IResolvable);
    resetDisabled(): void;
    get disabledInput(): boolean | cdktf.IResolvable | undefined;
    private _displayName?;
    get displayName(): string;
    set displayName(value: string);
    resetDisplayName(): void;
    get displayNameInput(): string | undefined;
    get email(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get member(): string;
    get name(): string;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    get uniqueId(): string;
    private _timeouts;
    get timeouts(): ServiceAccountTimeoutsOutputReference;
    putTimeouts(value: ServiceAccountTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | ServiceAccountTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
