import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface SpannerInstanceConfig extends cdktf.TerraformMetaArguments {
    /**
    * The name of the instance's configuration (similar but not
  quite the same as a region) which defines the geographic placement and
  replication of your databases in this instance. It determines where your data
  is stored. Values are typically of the form 'regional-europe-west1' , 'us-central' etc.
  In order to obtain a valid list please consult the
  [Configuration section of the docs](https://cloud.google.com/spanner/docs/instances).
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/spanner_instance#config SpannerInstance#config}
    */
    readonly config: string;
    /**
    * The descriptive name for this instance as it appears in UIs. Must be
  unique per project and between 4 and 30 characters in length.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/spanner_instance#display_name SpannerInstance#display_name}
    */
    readonly displayName: string;
    /**
    * When deleting a spanner instance, this boolean option will delete all backups of this instance.
  This must be set to true if you created a backup manually in the console.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/spanner_instance#force_destroy SpannerInstance#force_destroy}
    */
    readonly forceDestroy?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/spanner_instance#id SpannerInstance#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * An object containing a list of "key": value pairs.
  Example: { "name": "wrench", "mass": "1.3kg", "count": "3" }.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/spanner_instance#labels SpannerInstance#labels}
    */
    readonly labels?: {
        [key: string]: string;
    };
    /**
    * A unique identifier for the instance, which cannot be changed after
  the instance is created. The name must be between 6 and 30 characters
  in length.
  
  
  If not provided, a random string starting with 'tf-' will be selected.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/spanner_instance#name SpannerInstance#name}
    */
    readonly name?: string;
    /**
    * The number of nodes allocated to this instance. Exactly one of either node_count or processing_units
  must be present in terraform.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/spanner_instance#num_nodes SpannerInstance#num_nodes}
    */
    readonly numNodes?: number;
    /**
    * The number of processing units allocated to this instance. Exactly one of processing_units
  or node_count must be present in terraform.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/spanner_instance#processing_units SpannerInstance#processing_units}
    */
    readonly processingUnits?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/spanner_instance#project SpannerInstance#project}
    */
    readonly project?: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/spanner_instance#timeouts SpannerInstance#timeouts}
    */
    readonly timeouts?: SpannerInstanceTimeouts;
}
export interface SpannerInstanceTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/spanner_instance#create SpannerInstance#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/spanner_instance#delete SpannerInstance#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/spanner_instance#update SpannerInstance#update}
    */
    readonly update?: string;
}
export declare function spannerInstanceTimeoutsToTerraform(struct?: SpannerInstanceTimeoutsOutputReference | SpannerInstanceTimeouts | cdktf.IResolvable): any;
export declare class SpannerInstanceTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): SpannerInstanceTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: SpannerInstanceTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/r/spanner_instance google_spanner_instance}
*/
export declare class SpannerInstance extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_spanner_instance";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/r/spanner_instance google_spanner_instance} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options SpannerInstanceConfig
    */
    constructor(scope: Construct, id: string, config: SpannerInstanceConfig);
    private _config?;
    get config(): string;
    set config(value: string);
    get configInput(): string | undefined;
    private _displayName?;
    get displayName(): string;
    set displayName(value: string);
    get displayNameInput(): string | undefined;
    private _forceDestroy?;
    get forceDestroy(): boolean | cdktf.IResolvable;
    set forceDestroy(value: boolean | cdktf.IResolvable);
    resetForceDestroy(): void;
    get forceDestroyInput(): boolean | cdktf.IResolvable | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _labels?;
    get labels(): {
        [key: string]: string;
    };
    set labels(value: {
        [key: string]: string;
    });
    resetLabels(): void;
    get labelsInput(): {
        [key: string]: string;
    } | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _numNodes?;
    get numNodes(): number;
    set numNodes(value: number);
    resetNumNodes(): void;
    get numNodesInput(): number | undefined;
    private _processingUnits?;
    get processingUnits(): number;
    set processingUnits(value: number);
    resetProcessingUnits(): void;
    get processingUnitsInput(): number | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    get state(): string;
    private _timeouts;
    get timeouts(): SpannerInstanceTimeoutsOutputReference;
    putTimeouts(value: SpannerInstanceTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | SpannerInstanceTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
