import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface StorageDefaultObjectAclConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_default_object_acl#bucket StorageDefaultObjectAcl#bucket}
    */
    readonly bucket: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_default_object_acl#id StorageDefaultObjectAcl#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_default_object_acl#role_entity StorageDefaultObjectAcl#role_entity}
    */
    readonly roleEntity?: string[];
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/r/storage_default_object_acl google_storage_default_object_acl}
*/
export declare class StorageDefaultObjectAcl extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_storage_default_object_acl";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/r/storage_default_object_acl google_storage_default_object_acl} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options StorageDefaultObjectAclConfig
    */
    constructor(scope: Construct, id: string, config: StorageDefaultObjectAclConfig);
    private _bucket?;
    get bucket(): string;
    set bucket(value: string);
    get bucketInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _roleEntity?;
    get roleEntity(): string[];
    set roleEntity(value: string[]);
    resetRoleEntity(): void;
    get roleEntityInput(): string[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
