import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface StorageTransferAgentPoolConfig extends cdktf.TerraformMetaArguments {
    /**
    * Specifies the client-specified AgentPool description.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_transfer_agent_pool#display_name StorageTransferAgentPool#display_name}
    */
    readonly displayName?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_transfer_agent_pool#id StorageTransferAgentPool#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The ID of the agent pool to create.
  
  The agentPoolId must meet the following requirements:
  * Length of 128 characters or less.
  * Not start with the string goog.
  * Start with a lowercase ASCII character, followed by:
    * Zero or more: lowercase Latin alphabet characters, numerals, hyphens (-), periods (.), underscores (_), or tildes (~).
    * One or more numerals or lowercase ASCII characters.
  
  As expressed by the regular expression: ^(?!goog)[a-z]([a-z0-9-._~]*[a-z0-9])?$.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_transfer_agent_pool#name StorageTransferAgentPool#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_transfer_agent_pool#project StorageTransferAgentPool#project}
    */
    readonly project?: string;
    /**
    * bandwidth_limit block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_transfer_agent_pool#bandwidth_limit StorageTransferAgentPool#bandwidth_limit}
    */
    readonly bandwidthLimit?: StorageTransferAgentPoolBandwidthLimit;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_transfer_agent_pool#timeouts StorageTransferAgentPool#timeouts}
    */
    readonly timeouts?: StorageTransferAgentPoolTimeouts;
}
export interface StorageTransferAgentPoolBandwidthLimit {
    /**
    * Bandwidth rate in megabytes per second, distributed across all the agents in the pool.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_transfer_agent_pool#limit_mbps StorageTransferAgentPool#limit_mbps}
    */
    readonly limitMbps: string;
}
export declare function storageTransferAgentPoolBandwidthLimitToTerraform(struct?: StorageTransferAgentPoolBandwidthLimitOutputReference | StorageTransferAgentPoolBandwidthLimit): any;
export declare class StorageTransferAgentPoolBandwidthLimitOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): StorageTransferAgentPoolBandwidthLimit | undefined;
    set internalValue(value: StorageTransferAgentPoolBandwidthLimit | undefined);
    private _limitMbps?;
    get limitMbps(): string;
    set limitMbps(value: string);
    get limitMbpsInput(): string | undefined;
}
export interface StorageTransferAgentPoolTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_transfer_agent_pool#create StorageTransferAgentPool#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_transfer_agent_pool#delete StorageTransferAgentPool#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_transfer_agent_pool#update StorageTransferAgentPool#update}
    */
    readonly update?: string;
}
export declare function storageTransferAgentPoolTimeoutsToTerraform(struct?: StorageTransferAgentPoolTimeoutsOutputReference | StorageTransferAgentPoolTimeouts | cdktf.IResolvable): any;
export declare class StorageTransferAgentPoolTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): StorageTransferAgentPoolTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: StorageTransferAgentPoolTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/r/storage_transfer_agent_pool google_storage_transfer_agent_pool}
*/
export declare class StorageTransferAgentPool extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_storage_transfer_agent_pool";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/r/storage_transfer_agent_pool google_storage_transfer_agent_pool} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options StorageTransferAgentPoolConfig
    */
    constructor(scope: Construct, id: string, config: StorageTransferAgentPoolConfig);
    private _displayName?;
    get displayName(): string;
    set displayName(value: string);
    resetDisplayName(): void;
    get displayNameInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    get state(): string;
    private _bandwidthLimit;
    get bandwidthLimit(): StorageTransferAgentPoolBandwidthLimitOutputReference;
    putBandwidthLimit(value: StorageTransferAgentPoolBandwidthLimit): void;
    resetBandwidthLimit(): void;
    get bandwidthLimitInput(): StorageTransferAgentPoolBandwidthLimit | undefined;
    private _timeouts;
    get timeouts(): StorageTransferAgentPoolTimeoutsOutputReference;
    putTimeouts(value: StorageTransferAgentPoolTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | StorageTransferAgentPoolTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
