import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface TagsLocationTagBindingConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/tags_location_tag_binding#id TagsLocationTagBinding#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The geographic location where the transfer config should reside.
  Examples: US, EU, asia-northeast1. The default value is US.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/tags_location_tag_binding#location TagsLocationTagBinding#location}
    */
    readonly location?: string;
    /**
    * The full resource name of the resource the TagValue is bound to. E.g. //cloudresourcemanager.googleapis.com/projects/123
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/tags_location_tag_binding#parent TagsLocationTagBinding#parent}
    */
    readonly parent: string;
    /**
    * The TagValue of the TagBinding. Must be of the form tagValues/456.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/tags_location_tag_binding#tag_value TagsLocationTagBinding#tag_value}
    */
    readonly tagValue: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/tags_location_tag_binding#timeouts TagsLocationTagBinding#timeouts}
    */
    readonly timeouts?: TagsLocationTagBindingTimeouts;
}
export interface TagsLocationTagBindingTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/tags_location_tag_binding#create TagsLocationTagBinding#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/tags_location_tag_binding#delete TagsLocationTagBinding#delete}
    */
    readonly delete?: string;
}
export declare function tagsLocationTagBindingTimeoutsToTerraform(struct?: TagsLocationTagBindingTimeoutsOutputReference | TagsLocationTagBindingTimeouts | cdktf.IResolvable): any;
export declare class TagsLocationTagBindingTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): TagsLocationTagBindingTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: TagsLocationTagBindingTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/r/tags_location_tag_binding google_tags_location_tag_binding}
*/
export declare class TagsLocationTagBinding extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_tags_location_tag_binding";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/r/tags_location_tag_binding google_tags_location_tag_binding} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options TagsLocationTagBindingConfig
    */
    constructor(scope: Construct, id: string, config: TagsLocationTagBindingConfig);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    resetLocation(): void;
    get locationInput(): string | undefined;
    get name(): string;
    private _parent?;
    get parent(): string;
    set parent(value: string);
    get parentInput(): string | undefined;
    private _tagValue?;
    get tagValue(): string;
    set tagValue(value: string);
    get tagValueInput(): string | undefined;
    private _timeouts;
    get timeouts(): TagsLocationTagBindingTimeoutsOutputReference;
    putTimeouts(value: TagsLocationTagBindingTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | TagsLocationTagBindingTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
