import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface TagsTagKeyConfig extends cdktf.TerraformMetaArguments {
    /**
    * User-assigned description of the TagKey. Must not exceed 256 characters.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/tags_tag_key#description TagsTagKey#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/tags_tag_key#id TagsTagKey#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Input only. The resource name of the new TagKey's parent. Must be of the form organizations/{org_id}.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/tags_tag_key#parent TagsTagKey#parent}
    */
    readonly parent: string;
    /**
    * Optional. A purpose cannot be changed once set.
  
  A purpose denotes that this Tag is intended for use in policies of a specific policy engine, and will involve that policy engine in management operations involving this Tag. Possible values: ["GCE_FIREWALL"]
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/tags_tag_key#purpose TagsTagKey#purpose}
    */
    readonly purpose?: string;
    /**
    * Optional. Purpose data cannot be changed once set.
  
  Purpose data corresponds to the policy system that the tag is intended for. For example, the GCE_FIREWALL purpose expects data in the following format: 'network = "<project-name>/<vpc-name>"'.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/tags_tag_key#purpose_data TagsTagKey#purpose_data}
    */
    readonly purposeData?: {
        [key: string]: string;
    };
    /**
    * Input only. The user friendly name for a TagKey. The short name should be unique for TagKeys within the same tag namespace.
  
  The short name must be 1-63 characters, beginning and ending with an alphanumeric character ([a-z0-9A-Z]) with dashes (-), underscores (_), dots (.), and alphanumerics between.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/tags_tag_key#short_name TagsTagKey#short_name}
    */
    readonly shortName: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/tags_tag_key#timeouts TagsTagKey#timeouts}
    */
    readonly timeouts?: TagsTagKeyTimeouts;
}
export interface TagsTagKeyTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/tags_tag_key#create TagsTagKey#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/tags_tag_key#delete TagsTagKey#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/tags_tag_key#update TagsTagKey#update}
    */
    readonly update?: string;
}
export declare function tagsTagKeyTimeoutsToTerraform(struct?: TagsTagKeyTimeoutsOutputReference | TagsTagKeyTimeouts | cdktf.IResolvable): any;
export declare class TagsTagKeyTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): TagsTagKeyTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: TagsTagKeyTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/r/tags_tag_key google_tags_tag_key}
*/
export declare class TagsTagKey extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_tags_tag_key";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/r/tags_tag_key google_tags_tag_key} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options TagsTagKeyConfig
    */
    constructor(scope: Construct, id: string, config: TagsTagKeyConfig);
    get createTime(): string;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get name(): string;
    get namespacedName(): string;
    private _parent?;
    get parent(): string;
    set parent(value: string);
    get parentInput(): string | undefined;
    private _purpose?;
    get purpose(): string;
    set purpose(value: string);
    resetPurpose(): void;
    get purposeInput(): string | undefined;
    private _purposeData?;
    get purposeData(): {
        [key: string]: string;
    };
    set purposeData(value: {
        [key: string]: string;
    });
    resetPurposeData(): void;
    get purposeDataInput(): {
        [key: string]: string;
    } | undefined;
    private _shortName?;
    get shortName(): string;
    set shortName(value: string);
    get shortNameInput(): string | undefined;
    get updateTime(): string;
    private _timeouts;
    get timeouts(): TagsTagKeyTimeoutsOutputReference;
    putTimeouts(value: TagsTagKeyTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | TagsTagKeyTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
