import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface VertexAiFeaturestoreEntitytypeConfig extends cdktf.TerraformMetaArguments {
    /**
    * Optional. Description of the EntityType.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/vertex_ai_featurestore_entitytype#description VertexAiFeaturestoreEntitytype#description}
    */
    readonly description?: string;
    /**
    * The name of the Featurestore to use, in the format projects/{project}/locations/{location}/featurestores/{featurestore}.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/vertex_ai_featurestore_entitytype#featurestore VertexAiFeaturestoreEntitytype#featurestore}
    */
    readonly featurestore: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/vertex_ai_featurestore_entitytype#id VertexAiFeaturestoreEntitytype#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * A set of key/value label pairs to assign to this EntityType.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/vertex_ai_featurestore_entitytype#labels VertexAiFeaturestoreEntitytype#labels}
    */
    readonly labels?: {
        [key: string]: string;
    };
    /**
    * The name of the EntityType. This value may be up to 60 characters, and valid characters are [a-z0-9_]. The first character cannot be a number.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/vertex_ai_featurestore_entitytype#name VertexAiFeaturestoreEntitytype#name}
    */
    readonly name?: string;
    /**
    * monitoring_config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/vertex_ai_featurestore_entitytype#monitoring_config VertexAiFeaturestoreEntitytype#monitoring_config}
    */
    readonly monitoringConfig?: VertexAiFeaturestoreEntitytypeMonitoringConfig;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/vertex_ai_featurestore_entitytype#timeouts VertexAiFeaturestoreEntitytype#timeouts}
    */
    readonly timeouts?: VertexAiFeaturestoreEntitytypeTimeouts;
}
export interface VertexAiFeaturestoreEntitytypeMonitoringConfigCategoricalThresholdConfig {
    /**
    * Specify a threshold value that can trigger the alert. For categorical feature, the distribution distance is calculated by L-inifinity norm. Each feature must have a non-zero threshold if they need to be monitored. Otherwise no alert will be triggered for that feature. The default value is 0.3.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/vertex_ai_featurestore_entitytype#value VertexAiFeaturestoreEntitytype#value}
    */
    readonly value: number;
}
export declare function vertexAiFeaturestoreEntitytypeMonitoringConfigCategoricalThresholdConfigToTerraform(struct?: VertexAiFeaturestoreEntitytypeMonitoringConfigCategoricalThresholdConfigOutputReference | VertexAiFeaturestoreEntitytypeMonitoringConfigCategoricalThresholdConfig): any;
export declare class VertexAiFeaturestoreEntitytypeMonitoringConfigCategoricalThresholdConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): VertexAiFeaturestoreEntitytypeMonitoringConfigCategoricalThresholdConfig | undefined;
    set internalValue(value: VertexAiFeaturestoreEntitytypeMonitoringConfigCategoricalThresholdConfig | undefined);
    private _value?;
    get value(): number;
    set value(value: number);
    get valueInput(): number | undefined;
}
export interface VertexAiFeaturestoreEntitytypeMonitoringConfigImportFeaturesAnalysis {
    /**
    * Defines the baseline to do anomaly detection for feature values imported by each [entityTypes.importFeatureValues][] operation. The value must be one of the values below:
  * LATEST_STATS: Choose the later one statistics generated by either most recent snapshot analysis or previous import features analysis. If non of them exists, skip anomaly detection and only generate a statistics.
  * MOST_RECENT_SNAPSHOT_STATS: Use the statistics generated by the most recent snapshot analysis if exists.
  * PREVIOUS_IMPORT_FEATURES_STATS: Use the statistics generated by the previous import features analysis if exists.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/vertex_ai_featurestore_entitytype#anomaly_detection_baseline VertexAiFeaturestoreEntitytype#anomaly_detection_baseline}
    */
    readonly anomalyDetectionBaseline?: string;
    /**
    * Whether to enable / disable / inherite default hebavior for import features analysis. The value must be one of the values below:
  * DEFAULT: The default behavior of whether to enable the monitoring. EntityType-level config: disabled.
  * ENABLED: Explicitly enables import features analysis. EntityType-level config: by default enables import features analysis for all Features under it.
  * DISABLED: Explicitly disables import features analysis. EntityType-level config: by default disables import features analysis for all Features under it.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/vertex_ai_featurestore_entitytype#state VertexAiFeaturestoreEntitytype#state}
    */
    readonly state?: string;
}
export declare function vertexAiFeaturestoreEntitytypeMonitoringConfigImportFeaturesAnalysisToTerraform(struct?: VertexAiFeaturestoreEntitytypeMonitoringConfigImportFeaturesAnalysisOutputReference | VertexAiFeaturestoreEntitytypeMonitoringConfigImportFeaturesAnalysis): any;
export declare class VertexAiFeaturestoreEntitytypeMonitoringConfigImportFeaturesAnalysisOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): VertexAiFeaturestoreEntitytypeMonitoringConfigImportFeaturesAnalysis | undefined;
    set internalValue(value: VertexAiFeaturestoreEntitytypeMonitoringConfigImportFeaturesAnalysis | undefined);
    private _anomalyDetectionBaseline?;
    get anomalyDetectionBaseline(): string;
    set anomalyDetectionBaseline(value: string);
    resetAnomalyDetectionBaseline(): void;
    get anomalyDetectionBaselineInput(): string | undefined;
    private _state?;
    get state(): string;
    set state(value: string);
    resetState(): void;
    get stateInput(): string | undefined;
}
export interface VertexAiFeaturestoreEntitytypeMonitoringConfigNumericalThresholdConfig {
    /**
    * Specify a threshold value that can trigger the alert. For numerical feature, the distribution distance is calculated by Jensen–Shannon divergence. Each feature must have a non-zero threshold if they need to be monitored. Otherwise no alert will be triggered for that feature. The default value is 0.3.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/vertex_ai_featurestore_entitytype#value VertexAiFeaturestoreEntitytype#value}
    */
    readonly value: number;
}
export declare function vertexAiFeaturestoreEntitytypeMonitoringConfigNumericalThresholdConfigToTerraform(struct?: VertexAiFeaturestoreEntitytypeMonitoringConfigNumericalThresholdConfigOutputReference | VertexAiFeaturestoreEntitytypeMonitoringConfigNumericalThresholdConfig): any;
export declare class VertexAiFeaturestoreEntitytypeMonitoringConfigNumericalThresholdConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): VertexAiFeaturestoreEntitytypeMonitoringConfigNumericalThresholdConfig | undefined;
    set internalValue(value: VertexAiFeaturestoreEntitytypeMonitoringConfigNumericalThresholdConfig | undefined);
    private _value?;
    get value(): number;
    set value(value: number);
    get valueInput(): number | undefined;
}
export interface VertexAiFeaturestoreEntitytypeMonitoringConfigSnapshotAnalysis {
    /**
    * The monitoring schedule for snapshot analysis. For EntityType-level config: unset / disabled = true indicates disabled by default for Features under it; otherwise by default enable snapshot analysis monitoring with monitoringInterval for Features under it.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/vertex_ai_featurestore_entitytype#disabled VertexAiFeaturestoreEntitytype#disabled}
    */
    readonly disabled?: boolean | cdktf.IResolvable;
    /**
    * Configuration of the snapshot analysis based monitoring pipeline running interval. The value indicates number of days. The default value is 1.
  If both FeaturestoreMonitoringConfig.SnapshotAnalysis.monitoring_interval_days and [FeaturestoreMonitoringConfig.SnapshotAnalysis.monitoring_interval][] are set when creating/updating EntityTypes/Features, FeaturestoreMonitoringConfig.SnapshotAnalysis.monitoring_interval_days will be used.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/vertex_ai_featurestore_entitytype#monitoring_interval_days VertexAiFeaturestoreEntitytype#monitoring_interval_days}
    */
    readonly monitoringIntervalDays?: number;
    /**
    * Customized export features time window for snapshot analysis. Unit is one day. The default value is 21 days. Minimum value is 1 day. Maximum value is 4000 days.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/vertex_ai_featurestore_entitytype#staleness_days VertexAiFeaturestoreEntitytype#staleness_days}
    */
    readonly stalenessDays?: number;
}
export declare function vertexAiFeaturestoreEntitytypeMonitoringConfigSnapshotAnalysisToTerraform(struct?: VertexAiFeaturestoreEntitytypeMonitoringConfigSnapshotAnalysisOutputReference | VertexAiFeaturestoreEntitytypeMonitoringConfigSnapshotAnalysis): any;
export declare class VertexAiFeaturestoreEntitytypeMonitoringConfigSnapshotAnalysisOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): VertexAiFeaturestoreEntitytypeMonitoringConfigSnapshotAnalysis | undefined;
    set internalValue(value: VertexAiFeaturestoreEntitytypeMonitoringConfigSnapshotAnalysis | undefined);
    private _disabled?;
    get disabled(): boolean | cdktf.IResolvable;
    set disabled(value: boolean | cdktf.IResolvable);
    resetDisabled(): void;
    get disabledInput(): boolean | cdktf.IResolvable | undefined;
    private _monitoringIntervalDays?;
    get monitoringIntervalDays(): number;
    set monitoringIntervalDays(value: number);
    resetMonitoringIntervalDays(): void;
    get monitoringIntervalDaysInput(): number | undefined;
    private _stalenessDays?;
    get stalenessDays(): number;
    set stalenessDays(value: number);
    resetStalenessDays(): void;
    get stalenessDaysInput(): number | undefined;
}
export interface VertexAiFeaturestoreEntitytypeMonitoringConfig {
    /**
    * categorical_threshold_config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/vertex_ai_featurestore_entitytype#categorical_threshold_config VertexAiFeaturestoreEntitytype#categorical_threshold_config}
    */
    readonly categoricalThresholdConfig?: VertexAiFeaturestoreEntitytypeMonitoringConfigCategoricalThresholdConfig;
    /**
    * import_features_analysis block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/vertex_ai_featurestore_entitytype#import_features_analysis VertexAiFeaturestoreEntitytype#import_features_analysis}
    */
    readonly importFeaturesAnalysis?: VertexAiFeaturestoreEntitytypeMonitoringConfigImportFeaturesAnalysis;
    /**
    * numerical_threshold_config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/vertex_ai_featurestore_entitytype#numerical_threshold_config VertexAiFeaturestoreEntitytype#numerical_threshold_config}
    */
    readonly numericalThresholdConfig?: VertexAiFeaturestoreEntitytypeMonitoringConfigNumericalThresholdConfig;
    /**
    * snapshot_analysis block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/vertex_ai_featurestore_entitytype#snapshot_analysis VertexAiFeaturestoreEntitytype#snapshot_analysis}
    */
    readonly snapshotAnalysis?: VertexAiFeaturestoreEntitytypeMonitoringConfigSnapshotAnalysis;
}
export declare function vertexAiFeaturestoreEntitytypeMonitoringConfigToTerraform(struct?: VertexAiFeaturestoreEntitytypeMonitoringConfigOutputReference | VertexAiFeaturestoreEntitytypeMonitoringConfig): any;
export declare class VertexAiFeaturestoreEntitytypeMonitoringConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): VertexAiFeaturestoreEntitytypeMonitoringConfig | undefined;
    set internalValue(value: VertexAiFeaturestoreEntitytypeMonitoringConfig | undefined);
    private _categoricalThresholdConfig;
    get categoricalThresholdConfig(): VertexAiFeaturestoreEntitytypeMonitoringConfigCategoricalThresholdConfigOutputReference;
    putCategoricalThresholdConfig(value: VertexAiFeaturestoreEntitytypeMonitoringConfigCategoricalThresholdConfig): void;
    resetCategoricalThresholdConfig(): void;
    get categoricalThresholdConfigInput(): VertexAiFeaturestoreEntitytypeMonitoringConfigCategoricalThresholdConfig | undefined;
    private _importFeaturesAnalysis;
    get importFeaturesAnalysis(): VertexAiFeaturestoreEntitytypeMonitoringConfigImportFeaturesAnalysisOutputReference;
    putImportFeaturesAnalysis(value: VertexAiFeaturestoreEntitytypeMonitoringConfigImportFeaturesAnalysis): void;
    resetImportFeaturesAnalysis(): void;
    get importFeaturesAnalysisInput(): VertexAiFeaturestoreEntitytypeMonitoringConfigImportFeaturesAnalysis | undefined;
    private _numericalThresholdConfig;
    get numericalThresholdConfig(): VertexAiFeaturestoreEntitytypeMonitoringConfigNumericalThresholdConfigOutputReference;
    putNumericalThresholdConfig(value: VertexAiFeaturestoreEntitytypeMonitoringConfigNumericalThresholdConfig): void;
    resetNumericalThresholdConfig(): void;
    get numericalThresholdConfigInput(): VertexAiFeaturestoreEntitytypeMonitoringConfigNumericalThresholdConfig | undefined;
    private _snapshotAnalysis;
    get snapshotAnalysis(): VertexAiFeaturestoreEntitytypeMonitoringConfigSnapshotAnalysisOutputReference;
    putSnapshotAnalysis(value: VertexAiFeaturestoreEntitytypeMonitoringConfigSnapshotAnalysis): void;
    resetSnapshotAnalysis(): void;
    get snapshotAnalysisInput(): VertexAiFeaturestoreEntitytypeMonitoringConfigSnapshotAnalysis | undefined;
}
export interface VertexAiFeaturestoreEntitytypeTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/vertex_ai_featurestore_entitytype#create VertexAiFeaturestoreEntitytype#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/vertex_ai_featurestore_entitytype#delete VertexAiFeaturestoreEntitytype#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/vertex_ai_featurestore_entitytype#update VertexAiFeaturestoreEntitytype#update}
    */
    readonly update?: string;
}
export declare function vertexAiFeaturestoreEntitytypeTimeoutsToTerraform(struct?: VertexAiFeaturestoreEntitytypeTimeoutsOutputReference | VertexAiFeaturestoreEntitytypeTimeouts | cdktf.IResolvable): any;
export declare class VertexAiFeaturestoreEntitytypeTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): VertexAiFeaturestoreEntitytypeTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: VertexAiFeaturestoreEntitytypeTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/r/vertex_ai_featurestore_entitytype google_vertex_ai_featurestore_entitytype}
*/
export declare class VertexAiFeaturestoreEntitytype extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_vertex_ai_featurestore_entitytype";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/r/vertex_ai_featurestore_entitytype google_vertex_ai_featurestore_entitytype} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options VertexAiFeaturestoreEntitytypeConfig
    */
    constructor(scope: Construct, id: string, config: VertexAiFeaturestoreEntitytypeConfig);
    get createTime(): string;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    get etag(): string;
    private _featurestore?;
    get featurestore(): string;
    set featurestore(value: string);
    get featurestoreInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _labels?;
    get labels(): {
        [key: string]: string;
    };
    set labels(value: {
        [key: string]: string;
    });
    resetLabels(): void;
    get labelsInput(): {
        [key: string]: string;
    } | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    get region(): string;
    get updateTime(): string;
    private _monitoringConfig;
    get monitoringConfig(): VertexAiFeaturestoreEntitytypeMonitoringConfigOutputReference;
    putMonitoringConfig(value: VertexAiFeaturestoreEntitytypeMonitoringConfig): void;
    resetMonitoringConfig(): void;
    get monitoringConfigInput(): VertexAiFeaturestoreEntitytypeMonitoringConfig | undefined;
    private _timeouts;
    get timeouts(): VertexAiFeaturestoreEntitytypeTimeoutsOutputReference;
    putTimeouts(value: VertexAiFeaturestoreEntitytypeTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | VertexAiFeaturestoreEntitytypeTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
