import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface VertexAiFeaturestoreConfig extends cdktf.TerraformMetaArguments {
    /**
    * If set to true, any EntityTypes and Features for this Featurestore will also be deleted
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/vertex_ai_featurestore#force_destroy VertexAiFeaturestore#force_destroy}
    */
    readonly forceDestroy?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/vertex_ai_featurestore#id VertexAiFeaturestore#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * A set of key/value label pairs to assign to this Featurestore.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/vertex_ai_featurestore#labels VertexAiFeaturestore#labels}
    */
    readonly labels?: {
        [key: string]: string;
    };
    /**
    * The name of the Featurestore. This value may be up to 60 characters, and valid characters are [a-z0-9_]. The first character cannot be a number.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/vertex_ai_featurestore#name VertexAiFeaturestore#name}
    */
    readonly name?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/vertex_ai_featurestore#project VertexAiFeaturestore#project}
    */
    readonly project?: string;
    /**
    * The region of the dataset. eg us-central1
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/vertex_ai_featurestore#region VertexAiFeaturestore#region}
    */
    readonly region?: string;
    /**
    * encryption_spec block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/vertex_ai_featurestore#encryption_spec VertexAiFeaturestore#encryption_spec}
    */
    readonly encryptionSpec?: VertexAiFeaturestoreEncryptionSpec;
    /**
    * online_serving_config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/vertex_ai_featurestore#online_serving_config VertexAiFeaturestore#online_serving_config}
    */
    readonly onlineServingConfig?: VertexAiFeaturestoreOnlineServingConfig;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/vertex_ai_featurestore#timeouts VertexAiFeaturestore#timeouts}
    */
    readonly timeouts?: VertexAiFeaturestoreTimeouts;
}
export interface VertexAiFeaturestoreEncryptionSpec {
    /**
    * The Cloud KMS resource identifier of the customer managed encryption key used to protect a resource. Has the form: projects/my-project/locations/my-region/keyRings/my-kr/cryptoKeys/my-key. The key needs to be in the same region as where the compute resource is created.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/vertex_ai_featurestore#kms_key_name VertexAiFeaturestore#kms_key_name}
    */
    readonly kmsKeyName: string;
}
export declare function vertexAiFeaturestoreEncryptionSpecToTerraform(struct?: VertexAiFeaturestoreEncryptionSpecOutputReference | VertexAiFeaturestoreEncryptionSpec): any;
export declare class VertexAiFeaturestoreEncryptionSpecOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): VertexAiFeaturestoreEncryptionSpec | undefined;
    set internalValue(value: VertexAiFeaturestoreEncryptionSpec | undefined);
    private _kmsKeyName?;
    get kmsKeyName(): string;
    set kmsKeyName(value: string);
    get kmsKeyNameInput(): string | undefined;
}
export interface VertexAiFeaturestoreOnlineServingConfigScaling {
    /**
    * The maximum number of nodes to scale up to. Must be greater than minNodeCount, and less than or equal to 10 times of 'minNodeCount'.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/vertex_ai_featurestore#max_node_count VertexAiFeaturestore#max_node_count}
    */
    readonly maxNodeCount: number;
    /**
    * The minimum number of nodes to scale down to. Must be greater than or equal to 1.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/vertex_ai_featurestore#min_node_count VertexAiFeaturestore#min_node_count}
    */
    readonly minNodeCount: number;
}
export declare function vertexAiFeaturestoreOnlineServingConfigScalingToTerraform(struct?: VertexAiFeaturestoreOnlineServingConfigScalingOutputReference | VertexAiFeaturestoreOnlineServingConfigScaling): any;
export declare class VertexAiFeaturestoreOnlineServingConfigScalingOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): VertexAiFeaturestoreOnlineServingConfigScaling | undefined;
    set internalValue(value: VertexAiFeaturestoreOnlineServingConfigScaling | undefined);
    private _maxNodeCount?;
    get maxNodeCount(): number;
    set maxNodeCount(value: number);
    get maxNodeCountInput(): number | undefined;
    private _minNodeCount?;
    get minNodeCount(): number;
    set minNodeCount(value: number);
    get minNodeCountInput(): number | undefined;
}
export interface VertexAiFeaturestoreOnlineServingConfig {
    /**
    * The number of nodes for each cluster. The number of nodes will not scale automatically but can be scaled manually by providing different values when updating.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/vertex_ai_featurestore#fixed_node_count VertexAiFeaturestore#fixed_node_count}
    */
    readonly fixedNodeCount?: number;
    /**
    * scaling block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/vertex_ai_featurestore#scaling VertexAiFeaturestore#scaling}
    */
    readonly scaling?: VertexAiFeaturestoreOnlineServingConfigScaling;
}
export declare function vertexAiFeaturestoreOnlineServingConfigToTerraform(struct?: VertexAiFeaturestoreOnlineServingConfigOutputReference | VertexAiFeaturestoreOnlineServingConfig): any;
export declare class VertexAiFeaturestoreOnlineServingConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): VertexAiFeaturestoreOnlineServingConfig | undefined;
    set internalValue(value: VertexAiFeaturestoreOnlineServingConfig | undefined);
    private _fixedNodeCount?;
    get fixedNodeCount(): number;
    set fixedNodeCount(value: number);
    resetFixedNodeCount(): void;
    get fixedNodeCountInput(): number | undefined;
    private _scaling;
    get scaling(): VertexAiFeaturestoreOnlineServingConfigScalingOutputReference;
    putScaling(value: VertexAiFeaturestoreOnlineServingConfigScaling): void;
    resetScaling(): void;
    get scalingInput(): VertexAiFeaturestoreOnlineServingConfigScaling | undefined;
}
export interface VertexAiFeaturestoreTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/vertex_ai_featurestore#create VertexAiFeaturestore#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/vertex_ai_featurestore#delete VertexAiFeaturestore#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/vertex_ai_featurestore#update VertexAiFeaturestore#update}
    */
    readonly update?: string;
}
export declare function vertexAiFeaturestoreTimeoutsToTerraform(struct?: VertexAiFeaturestoreTimeoutsOutputReference | VertexAiFeaturestoreTimeouts | cdktf.IResolvable): any;
export declare class VertexAiFeaturestoreTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): VertexAiFeaturestoreTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: VertexAiFeaturestoreTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/r/vertex_ai_featurestore google_vertex_ai_featurestore}
*/
export declare class VertexAiFeaturestore extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_vertex_ai_featurestore";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/r/vertex_ai_featurestore google_vertex_ai_featurestore} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options VertexAiFeaturestoreConfig = {}
    */
    constructor(scope: Construct, id: string, config?: VertexAiFeaturestoreConfig);
    get createTime(): string;
    get etag(): string;
    private _forceDestroy?;
    get forceDestroy(): boolean | cdktf.IResolvable;
    set forceDestroy(value: boolean | cdktf.IResolvable);
    resetForceDestroy(): void;
    get forceDestroyInput(): boolean | cdktf.IResolvable | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _labels?;
    get labels(): {
        [key: string]: string;
    };
    set labels(value: {
        [key: string]: string;
    });
    resetLabels(): void;
    get labelsInput(): {
        [key: string]: string;
    } | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _region?;
    get region(): string;
    set region(value: string);
    resetRegion(): void;
    get regionInput(): string | undefined;
    get updateTime(): string;
    private _encryptionSpec;
    get encryptionSpec(): VertexAiFeaturestoreEncryptionSpecOutputReference;
    putEncryptionSpec(value: VertexAiFeaturestoreEncryptionSpec): void;
    resetEncryptionSpec(): void;
    get encryptionSpecInput(): VertexAiFeaturestoreEncryptionSpec | undefined;
    private _onlineServingConfig;
    get onlineServingConfig(): VertexAiFeaturestoreOnlineServingConfigOutputReference;
    putOnlineServingConfig(value: VertexAiFeaturestoreOnlineServingConfig): void;
    resetOnlineServingConfig(): void;
    get onlineServingConfigInput(): VertexAiFeaturestoreOnlineServingConfig | undefined;
    private _timeouts;
    get timeouts(): VertexAiFeaturestoreTimeoutsOutputReference;
    putTimeouts(value: VertexAiFeaturestoreTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | VertexAiFeaturestoreTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
