"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.LambdaToElasticachememcached = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const defaults = require("../../core");
const core_1 = require("@aws-cdk/core");
const core_2 = require("../../core");
const defaultEnvironmentVariableName = "CACHE_ENDPOINT";
/**
 * @summary The LambdaToElasticachememcached class.
 */
class LambdaToElasticachememcached extends core_1.Construct {
    /**
     * @summary Constructs a new instance of the LambdaToElasticachememcached class.
     * @param {cdk.App} scope - represents the scope for all the resources.
     * @param {string} id - this is a a scope-unique id.
     * @param {LambdaToElasticachememcachedProps} props - user provided props for the construct.
     * @access public
     */
    constructor(scope, id, props) {
        super(scope, id);
        defaults.CheckProps(props);
        if ((props.existingCache || props.existingLambdaObj) && (!props.existingVpc)) {
            throw Error('If providing an existing Cache or Lambda Function, you must also supply the associated existingVpc');
        }
        if (props.cacheProps &&
            props.cacheProps.engine &&
            props.cacheProps.engine !== "memcached") {
            throw Error("This construct can only launch memcached clusters");
        }
        if (props.cacheProps && props.existingCache) {
            throw Error("Cannot specify existingCache and cacheProps");
        }
        const cachePort = core_2.getCachePort(props.cacheProps, props.existingCache);
        this.vpc = defaults.buildVpc(scope, {
            defaultVpcProps: defaults.DefaultIsolatedVpcProps(),
            existingVpc: props.existingVpc,
            userVpcProps: props.vpcProps,
        });
        const lambdaToCacheSecurityGroup = core_2.CreateSelfReferencingSecurityGroup(this, id, this.vpc, cachePort);
        this.cache = core_2.obtainMemcachedCluster(this, id, {
            cacheSecurityGroupId: lambdaToCacheSecurityGroup.securityGroupId,
            cacheProps: props.cacheProps,
            existingCache: props.existingCache,
            vpc: this.vpc,
            cachePort,
        });
        // Add the self-referencing security group to the Lambda function props
        const lambdaFunctionProps = defaults.consolidateProps({}, props.lambdaFunctionProps, { securityGroups: [lambdaToCacheSecurityGroup] }, true);
        // Setup the Lambda function
        this.lambdaFunction = defaults.buildLambdaFunction(this, {
            existingLambdaObj: props.existingLambdaObj,
            lambdaFunctionProps,
            vpc: this.vpc,
        });
        AddLambdaEnvironmentVariable(this.lambdaFunction, `${this.cache.attrConfigurationEndpointAddress}:${this.cache.attrConfigurationEndpointPort}`, defaultEnvironmentVariableName, props.cacheEndpointEnvironmentVariableName);
    }
}
exports.LambdaToElasticachememcached = LambdaToElasticachememcached;
_a = JSII_RTTI_SYMBOL_1;
LambdaToElasticachememcached[_a] = { fqn: "@aws-solutions-constructs/aws-lambda-elasticachememcached.LambdaToElasticachememcached", version: "1.153.1" };
function AddLambdaEnvironmentVariable(targetFunction, value, defaultName, clientName) {
    const variableName = clientName || defaultName;
    targetFunction.addEnvironment(variableName, value);
}
//# sourceMappingURL=data:application/json;base64,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