# studio_wrapper.py

import enum
from typing import Any
import nanosurf.lib.spm.studio.wrapper as wrap

g_cmd_tree_hash = 'a389745a61cbb77caead166b24fc1af5'
g_compiler_version = '2.0'

class RootSession(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.session'

    def list(self, *args) -> Any:
        return self._context.call('root.session.list', *args)

    @property
    def name(self) -> str:
        return str(self._context.get('root.session.name'))

    @name.setter
    def name(self, new_val:str):
        self._context.set('root.session.name', str(new_val))

    def select_main(self, *args) -> Any:
        return self._context.call('root.session.select_main', *args)

    def select(self, *args) -> Any:
        return self._context.call('root.session.select', *args)

    @property
    def current_connection(self) -> str:
        return str(self._context.get('root.session.current_connection'))

    @current_connection.setter
    def current_connection(self, new_val:str):
        self._context.set('root.session.current_connection', str(new_val))


class RootLuDigi_user_ioInstanceTrigger(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.digi_user_io.instance.trigger'


class RootLuDigi_user_ioInstanceAttributeDigi_out1_pulseEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.digi_user_io.instance.attribute.digi_out1_pulse.enum'

    @property
    def t0_5_us(self) -> int:
        return int(self._context.get('root.lu.digi_user_io.instance.attribute.digi_out1_pulse.enum.t0_5_us'))

    @t0_5_us.setter
    def t0_5_us(self, new_val:int):
        self._context.set('root.lu.digi_user_io.instance.attribute.digi_out1_pulse.enum.t0_5_us', int(new_val))

    @property
    def t20_ms(self) -> int:
        return int(self._context.get('root.lu.digi_user_io.instance.attribute.digi_out1_pulse.enum.t20_ms'))

    @t20_ms.setter
    def t20_ms(self, new_val:int):
        self._context.set('root.lu.digi_user_io.instance.attribute.digi_out1_pulse.enum.t20_ms', int(new_val))

    @property
    def t500_us(self) -> int:
        return int(self._context.get('root.lu.digi_user_io.instance.attribute.digi_out1_pulse.enum.t500_us'))

    @t500_us.setter
    def t500_us(self, new_val:int):
        self._context.set('root.lu.digi_user_io.instance.attribute.digi_out1_pulse.enum.t500_us', int(new_val))

    @property
    def t50_us(self) -> int:
        return int(self._context.get('root.lu.digi_user_io.instance.attribute.digi_out1_pulse.enum.t50_us'))

    @t50_us.setter
    def t50_us(self, new_val:int):
        self._context.set('root.lu.digi_user_io.instance.attribute.digi_out1_pulse.enum.t50_us', int(new_val))

    @property
    def t5_ms(self) -> int:
        return int(self._context.get('root.lu.digi_user_io.instance.attribute.digi_out1_pulse.enum.t5_ms'))

    @t5_ms.setter
    def t5_ms(self, new_val:int):
        self._context.set('root.lu.digi_user_io.instance.attribute.digi_out1_pulse.enum.t5_ms', int(new_val))

    @property
    def t5_us(self) -> int:
        return int(self._context.get('root.lu.digi_user_io.instance.attribute.digi_out1_pulse.enum.t5_us'))

    @t5_us.setter
    def t5_us(self, new_val:int):
        self._context.set('root.lu.digi_user_io.instance.attribute.digi_out1_pulse.enum.t5_us', int(new_val))


class RootLuDigi_user_ioInstanceAttributeDigi_out1_pulse(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.digi_user_io.instance.attribute.digi_out1_pulse'
        self.enum = RootLuDigi_user_ioInstanceAttributeDigi_out1_pulseEnum(self._context)


class RootLuDigi_user_ioInstanceAttributeDigi_in2_levelEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.digi_user_io.instance.attribute.digi_in2_level.enum'

    @property
    def high(self) -> int:
        return int(self._context.get('root.lu.digi_user_io.instance.attribute.digi_in2_level.enum.high'))

    @high.setter
    def high(self, new_val:int):
        self._context.set('root.lu.digi_user_io.instance.attribute.digi_in2_level.enum.high', int(new_val))

    @property
    def low(self) -> int:
        return int(self._context.get('root.lu.digi_user_io.instance.attribute.digi_in2_level.enum.low'))

    @low.setter
    def low(self, new_val:int):
        self._context.set('root.lu.digi_user_io.instance.attribute.digi_in2_level.enum.low', int(new_val))


class RootLuDigi_user_ioInstanceAttributeDigi_in2_level(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.digi_user_io.instance.attribute.digi_in2_level'
        self.enum = RootLuDigi_user_ioInstanceAttributeDigi_in2_levelEnum(self._context)


class RootLuDigi_user_ioInstanceAttributeDigi_out1_event_sourceEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.digi_user_io.instance.attribute.digi_out1_event_source.enum'

    @property
    def and_mask0_true(self) -> int:
        return int(self._context.get('root.lu.digi_user_io.instance.attribute.digi_out1_event_source.enum.and_mask0_true'))

    @and_mask0_true.setter
    def and_mask0_true(self, new_val:int):
        self._context.set('root.lu.digi_user_io.instance.attribute.digi_out1_event_source.enum.and_mask0_true', int(new_val))

    @property
    def ext_event0_true(self) -> int:
        return int(self._context.get('root.lu.digi_user_io.instance.attribute.digi_out1_event_source.enum.ext_event0_true'))

    @ext_event0_true.setter
    def ext_event0_true(self, new_val:int):
        self._context.set('root.lu.digi_user_io.instance.attribute.digi_out1_event_source.enum.ext_event0_true', int(new_val))

    @property
    def z_ctrl_reached_min_z_true(self) -> int:
        return int(self._context.get('root.lu.digi_user_io.instance.attribute.digi_out1_event_source.enum.z_ctrl_reached_min_z_true'))

    @z_ctrl_reached_min_z_true.setter
    def z_ctrl_reached_min_z_true(self, new_val:int):
        self._context.set('root.lu.digi_user_io.instance.attribute.digi_out1_event_source.enum.z_ctrl_reached_min_z_true', int(new_val))

    @property
    def z_ctrl_reached_max_z_true(self) -> int:
        return int(self._context.get('root.lu.digi_user_io.instance.attribute.digi_out1_event_source.enum.z_ctrl_reached_max_z_true'))

    @z_ctrl_reached_max_z_true.setter
    def z_ctrl_reached_max_z_true(self, new_val:int):
        self._context.set('root.lu.digi_user_io.instance.attribute.digi_out1_event_source.enum.z_ctrl_reached_max_z_true', int(new_val))

    @property
    def timer_proc0_done(self) -> int:
        return int(self._context.get('root.lu.digi_user_io.instance.attribute.digi_out1_event_source.enum.timer_proc0_done'))

    @timer_proc0_done.setter
    def timer_proc0_done(self, new_val:int):
        self._context.set('root.lu.digi_user_io.instance.attribute.digi_out1_event_source.enum.timer_proc0_done', int(new_val))

    @property
    def soft_event0_true(self) -> int:
        return int(self._context.get('root.lu.digi_user_io.instance.attribute.digi_out1_event_source.enum.soft_event0_true'))

    @soft_event0_true.setter
    def soft_event0_true(self, new_val:int):
        self._context.set('root.lu.digi_user_io.instance.attribute.digi_out1_event_source.enum.soft_event0_true', int(new_val))

    @property
    def z_ctrl_reached_error_limit_true(self) -> int:
        return int(self._context.get('root.lu.digi_user_io.instance.attribute.digi_out1_event_source.enum.z_ctrl_reached_error_limit_true'))

    @z_ctrl_reached_error_limit_true.setter
    def z_ctrl_reached_error_limit_true(self, new_val:int):
        self._context.set('root.lu.digi_user_io.instance.attribute.digi_out1_event_source.enum.z_ctrl_reached_error_limit_true', int(new_val))

    @property
    def user_abort_event_true(self) -> int:
        return int(self._context.get('root.lu.digi_user_io.instance.attribute.digi_out1_event_source.enum.user_abort_event_true'))

    @user_abort_event_true.setter
    def user_abort_event_true(self, new_val:int):
        self._context.set('root.lu.digi_user_io.instance.attribute.digi_out1_event_source.enum.user_abort_event_true', int(new_val))

    @property
    def comparator3_true(self) -> int:
        return int(self._context.get('root.lu.digi_user_io.instance.attribute.digi_out1_event_source.enum.comparator3_true'))

    @comparator3_true.setter
    def comparator3_true(self, new_val:int):
        self._context.set('root.lu.digi_user_io.instance.attribute.digi_out1_event_source.enum.comparator3_true', int(new_val))

    @property
    def static_value(self) -> int:
        return int(self._context.get('root.lu.digi_user_io.instance.attribute.digi_out1_event_source.enum.static_value'))

    @static_value.setter
    def static_value(self, new_val:int):
        self._context.set('root.lu.digi_user_io.instance.attribute.digi_out1_event_source.enum.static_value', int(new_val))

    @property
    def soft_event2_true(self) -> int:
        return int(self._context.get('root.lu.digi_user_io.instance.attribute.digi_out1_event_source.enum.soft_event2_true'))

    @soft_event2_true.setter
    def soft_event2_true(self, new_val:int):
        self._context.set('root.lu.digi_user_io.instance.attribute.digi_out1_event_source.enum.soft_event2_true', int(new_val))

    @property
    def comparator1_true(self) -> int:
        return int(self._context.get('root.lu.digi_user_io.instance.attribute.digi_out1_event_source.enum.comparator1_true'))

    @comparator1_true.setter
    def comparator1_true(self, new_val:int):
        self._context.set('root.lu.digi_user_io.instance.attribute.digi_out1_event_source.enum.comparator1_true', int(new_val))

    @property
    def soft_event1_true(self) -> int:
        return int(self._context.get('root.lu.digi_user_io.instance.attribute.digi_out1_event_source.enum.soft_event1_true'))

    @soft_event1_true.setter
    def soft_event1_true(self, new_val:int):
        self._context.set('root.lu.digi_user_io.instance.attribute.digi_out1_event_source.enum.soft_event1_true', int(new_val))

    @property
    def comparator2_true(self) -> int:
        return int(self._context.get('root.lu.digi_user_io.instance.attribute.digi_out1_event_source.enum.comparator2_true'))

    @comparator2_true.setter
    def comparator2_true(self, new_val:int):
        self._context.set('root.lu.digi_user_io.instance.attribute.digi_out1_event_source.enum.comparator2_true', int(new_val))

    @property
    def ramp_gen_planez_done(self) -> int:
        return int(self._context.get('root.lu.digi_user_io.instance.attribute.digi_out1_event_source.enum.ramp_gen_planez_done'))

    @ramp_gen_planez_done.setter
    def ramp_gen_planez_done(self, new_val:int):
        self._context.set('root.lu.digi_user_io.instance.attribute.digi_out1_event_source.enum.ramp_gen_planez_done', int(new_val))

    @property
    def ramp_gen_ctrlz_done(self) -> int:
        return int(self._context.get('root.lu.digi_user_io.instance.attribute.digi_out1_event_source.enum.ramp_gen_ctrlz_done'))

    @ramp_gen_ctrlz_done.setter
    def ramp_gen_ctrlz_done(self, new_val:int):
        self._context.set('root.lu.digi_user_io.instance.attribute.digi_out1_event_source.enum.ramp_gen_ctrlz_done', int(new_val))

    @property
    def ramp_gen_approach_done(self) -> int:
        return int(self._context.get('root.lu.digi_user_io.instance.attribute.digi_out1_event_source.enum.ramp_gen_approach_done'))

    @ramp_gen_approach_done.setter
    def ramp_gen_approach_done(self, new_val:int):
        self._context.set('root.lu.digi_user_io.instance.attribute.digi_out1_event_source.enum.ramp_gen_approach_done', int(new_val))

    @property
    def ramp_gen_user4_done(self) -> int:
        return int(self._context.get('root.lu.digi_user_io.instance.attribute.digi_out1_event_source.enum.ramp_gen_user4_done'))

    @ramp_gen_user4_done.setter
    def ramp_gen_user4_done(self, new_val:int):
        self._context.set('root.lu.digi_user_io.instance.attribute.digi_out1_event_source.enum.ramp_gen_user4_done', int(new_val))

    @property
    def data_capture_done(self) -> int:
        return int(self._context.get('root.lu.digi_user_io.instance.attribute.digi_out1_event_source.enum.data_capture_done'))

    @data_capture_done.setter
    def data_capture_done(self, new_val:int):
        self._context.set('root.lu.digi_user_io.instance.attribute.digi_out1_event_source.enum.data_capture_done', int(new_val))

    @property
    def mem_sig_gen_done(self) -> int:
        return int(self._context.get('root.lu.digi_user_io.instance.attribute.digi_out1_event_source.enum.mem_sig_gen_done'))

    @mem_sig_gen_done.setter
    def mem_sig_gen_done(self, new_val:int):
        self._context.set('root.lu.digi_user_io.instance.attribute.digi_out1_event_source.enum.mem_sig_gen_done', int(new_val))

    @property
    def ramp_gen_positionx_done(self) -> int:
        return int(self._context.get('root.lu.digi_user_io.instance.attribute.digi_out1_event_source.enum.ramp_gen_positionx_done'))

    @ramp_gen_positionx_done.setter
    def ramp_gen_positionx_done(self, new_val:int):
        self._context.set('root.lu.digi_user_io.instance.attribute.digi_out1_event_source.enum.ramp_gen_positionx_done', int(new_val))

    @property
    def data_sampling_done(self) -> int:
        return int(self._context.get('root.lu.digi_user_io.instance.attribute.digi_out1_event_source.enum.data_sampling_done'))

    @data_sampling_done.setter
    def data_sampling_done(self, new_val:int):
        self._context.set('root.lu.digi_user_io.instance.attribute.digi_out1_event_source.enum.data_sampling_done', int(new_val))

    @property
    def ramp_gen_maxz_done(self) -> int:
        return int(self._context.get('root.lu.digi_user_io.instance.attribute.digi_out1_event_source.enum.ramp_gen_maxz_done'))

    @ramp_gen_maxz_done.setter
    def ramp_gen_maxz_done(self, new_val:int):
        self._context.set('root.lu.digi_user_io.instance.attribute.digi_out1_event_source.enum.ramp_gen_maxz_done', int(new_val))

    @property
    def ramp_gen_alternatez_done(self) -> int:
        return int(self._context.get('root.lu.digi_user_io.instance.attribute.digi_out1_event_source.enum.ramp_gen_alternatez_done'))

    @ramp_gen_alternatez_done.setter
    def ramp_gen_alternatez_done(self, new_val:int):
        self._context.set('root.lu.digi_user_io.instance.attribute.digi_out1_event_source.enum.ramp_gen_alternatez_done', int(new_val))

    @property
    def ramp_gen_tipvoltage_done(self) -> int:
        return int(self._context.get('root.lu.digi_user_io.instance.attribute.digi_out1_event_source.enum.ramp_gen_tipvoltage_done'))

    @ramp_gen_tipvoltage_done.setter
    def ramp_gen_tipvoltage_done(self, new_val:int):
        self._context.set('root.lu.digi_user_io.instance.attribute.digi_out1_event_source.enum.ramp_gen_tipvoltage_done', int(new_val))

    @property
    def ramp_gen_test_done(self) -> int:
        return int(self._context.get('root.lu.digi_user_io.instance.attribute.digi_out1_event_source.enum.ramp_gen_test_done'))

    @ramp_gen_test_done.setter
    def ramp_gen_test_done(self, new_val:int):
        self._context.set('root.lu.digi_user_io.instance.attribute.digi_out1_event_source.enum.ramp_gen_test_done', int(new_val))

    @property
    def ramp_gen_positiony_done(self) -> int:
        return int(self._context.get('root.lu.digi_user_io.instance.attribute.digi_out1_event_source.enum.ramp_gen_positiony_done'))

    @ramp_gen_positiony_done.setter
    def ramp_gen_positiony_done(self, new_val:int):
        self._context.set('root.lu.digi_user_io.instance.attribute.digi_out1_event_source.enum.ramp_gen_positiony_done', int(new_val))

    @property
    def event_manager_done(self) -> int:
        return int(self._context.get('root.lu.digi_user_io.instance.attribute.digi_out1_event_source.enum.event_manager_done'))

    @event_manager_done.setter
    def event_manager_done(self, new_val:int):
        self._context.set('root.lu.digi_user_io.instance.attribute.digi_out1_event_source.enum.event_manager_done', int(new_val))

    @property
    def ramp_gen_positionw_done(self) -> int:
        return int(self._context.get('root.lu.digi_user_io.instance.attribute.digi_out1_event_source.enum.ramp_gen_positionw_done'))

    @ramp_gen_positionw_done.setter
    def ramp_gen_positionw_done(self, new_val:int):
        self._context.set('root.lu.digi_user_io.instance.attribute.digi_out1_event_source.enum.ramp_gen_positionw_done', int(new_val))

    @property
    def timer_dbg1_done(self) -> int:
        return int(self._context.get('root.lu.digi_user_io.instance.attribute.digi_out1_event_source.enum.timer_dbg1_done'))

    @timer_dbg1_done.setter
    def timer_dbg1_done(self, new_val:int):
        self._context.set('root.lu.digi_user_io.instance.attribute.digi_out1_event_source.enum.timer_dbg1_done', int(new_val))

    @property
    def ext_event1_true(self) -> int:
        return int(self._context.get('root.lu.digi_user_io.instance.attribute.digi_out1_event_source.enum.ext_event1_true'))

    @ext_event1_true.setter
    def ext_event1_true(self, new_val:int):
        self._context.set('root.lu.digi_user_io.instance.attribute.digi_out1_event_source.enum.ext_event1_true', int(new_val))


class RootLuDigi_user_ioInstanceAttributeDigi_out1_event_source(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.digi_user_io.instance.attribute.digi_out1_event_source'
        self.enum = RootLuDigi_user_ioInstanceAttributeDigi_out1_event_sourceEnum(self._context)


class RootLuDigi_user_ioInstanceAttributeDigi_out2_enableEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.digi_user_io.instance.attribute.digi_out2_enable.enum'

    @property
    def disabled(self) -> int:
        return int(self._context.get('root.lu.digi_user_io.instance.attribute.digi_out2_enable.enum.disabled'))

    @disabled.setter
    def disabled(self, new_val:int):
        self._context.set('root.lu.digi_user_io.instance.attribute.digi_out2_enable.enum.disabled', int(new_val))

    @property
    def enabled(self) -> int:
        return int(self._context.get('root.lu.digi_user_io.instance.attribute.digi_out2_enable.enum.enabled'))

    @enabled.setter
    def enabled(self, new_val:int):
        self._context.set('root.lu.digi_user_io.instance.attribute.digi_out2_enable.enum.enabled', int(new_val))


class RootLuDigi_user_ioInstanceAttributeDigi_out2_enable(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.digi_user_io.instance.attribute.digi_out2_enable'
        self.enum = RootLuDigi_user_ioInstanceAttributeDigi_out2_enableEnum(self._context)


class RootLuDigi_user_ioInstanceAttributeDigi_out1_levelEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.digi_user_io.instance.attribute.digi_out1_level.enum'

    @property
    def high(self) -> int:
        return int(self._context.get('root.lu.digi_user_io.instance.attribute.digi_out1_level.enum.high'))

    @high.setter
    def high(self, new_val:int):
        self._context.set('root.lu.digi_user_io.instance.attribute.digi_out1_level.enum.high', int(new_val))

    @property
    def low(self) -> int:
        return int(self._context.get('root.lu.digi_user_io.instance.attribute.digi_out1_level.enum.low'))

    @low.setter
    def low(self, new_val:int):
        self._context.set('root.lu.digi_user_io.instance.attribute.digi_out1_level.enum.low', int(new_val))


class RootLuDigi_user_ioInstanceAttributeDigi_out1_level(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.digi_user_io.instance.attribute.digi_out1_level'
        self.enum = RootLuDigi_user_ioInstanceAttributeDigi_out1_levelEnum(self._context)


class RootLuDigi_user_ioInstanceAttributeDigi_out2_pulseEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.digi_user_io.instance.attribute.digi_out2_pulse.enum'

    @property
    def t0_5_us(self) -> int:
        return int(self._context.get('root.lu.digi_user_io.instance.attribute.digi_out2_pulse.enum.t0_5_us'))

    @t0_5_us.setter
    def t0_5_us(self, new_val:int):
        self._context.set('root.lu.digi_user_io.instance.attribute.digi_out2_pulse.enum.t0_5_us', int(new_val))

    @property
    def t20_ms(self) -> int:
        return int(self._context.get('root.lu.digi_user_io.instance.attribute.digi_out2_pulse.enum.t20_ms'))

    @t20_ms.setter
    def t20_ms(self, new_val:int):
        self._context.set('root.lu.digi_user_io.instance.attribute.digi_out2_pulse.enum.t20_ms', int(new_val))

    @property
    def t500_us(self) -> int:
        return int(self._context.get('root.lu.digi_user_io.instance.attribute.digi_out2_pulse.enum.t500_us'))

    @t500_us.setter
    def t500_us(self, new_val:int):
        self._context.set('root.lu.digi_user_io.instance.attribute.digi_out2_pulse.enum.t500_us', int(new_val))

    @property
    def t50_us(self) -> int:
        return int(self._context.get('root.lu.digi_user_io.instance.attribute.digi_out2_pulse.enum.t50_us'))

    @t50_us.setter
    def t50_us(self, new_val:int):
        self._context.set('root.lu.digi_user_io.instance.attribute.digi_out2_pulse.enum.t50_us', int(new_val))

    @property
    def t5_ms(self) -> int:
        return int(self._context.get('root.lu.digi_user_io.instance.attribute.digi_out2_pulse.enum.t5_ms'))

    @t5_ms.setter
    def t5_ms(self, new_val:int):
        self._context.set('root.lu.digi_user_io.instance.attribute.digi_out2_pulse.enum.t5_ms', int(new_val))

    @property
    def t5_us(self) -> int:
        return int(self._context.get('root.lu.digi_user_io.instance.attribute.digi_out2_pulse.enum.t5_us'))

    @t5_us.setter
    def t5_us(self, new_val:int):
        self._context.set('root.lu.digi_user_io.instance.attribute.digi_out2_pulse.enum.t5_us', int(new_val))


class RootLuDigi_user_ioInstanceAttributeDigi_out2_pulse(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.digi_user_io.instance.attribute.digi_out2_pulse'
        self.enum = RootLuDigi_user_ioInstanceAttributeDigi_out2_pulseEnum(self._context)


class RootLuDigi_user_ioInstanceAttributeDigi_out1_modeEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.digi_user_io.instance.attribute.digi_out1_mode.enum'

    @property
    def event_rising_edge_pulse(self) -> int:
        return int(self._context.get('root.lu.digi_user_io.instance.attribute.digi_out1_mode.enum.event_rising_edge_pulse'))

    @event_rising_edge_pulse.setter
    def event_rising_edge_pulse(self, new_val:int):
        self._context.set('root.lu.digi_user_io.instance.attribute.digi_out1_mode.enum.event_rising_edge_pulse', int(new_val))

    @property
    def event_rising_and_falling_edge_pulse(self) -> int:
        return int(self._context.get('root.lu.digi_user_io.instance.attribute.digi_out1_mode.enum.event_rising_and_falling_edge_pulse'))

    @event_rising_and_falling_edge_pulse.setter
    def event_rising_and_falling_edge_pulse(self, new_val:int):
        self._context.set('root.lu.digi_user_io.instance.attribute.digi_out1_mode.enum.event_rising_and_falling_edge_pulse', int(new_val))

    @property
    def event_falling_edge_pulse(self) -> int:
        return int(self._context.get('root.lu.digi_user_io.instance.attribute.digi_out1_mode.enum.event_falling_edge_pulse'))

    @event_falling_edge_pulse.setter
    def event_falling_edge_pulse(self, new_val:int):
        self._context.set('root.lu.digi_user_io.instance.attribute.digi_out1_mode.enum.event_falling_edge_pulse', int(new_val))

    @property
    def event_level(self) -> int:
        return int(self._context.get('root.lu.digi_user_io.instance.attribute.digi_out1_mode.enum.event_level'))

    @event_level.setter
    def event_level(self, new_val:int):
        self._context.set('root.lu.digi_user_io.instance.attribute.digi_out1_mode.enum.event_level', int(new_val))

    @property
    def static_level(self) -> int:
        return int(self._context.get('root.lu.digi_user_io.instance.attribute.digi_out1_mode.enum.static_level'))

    @static_level.setter
    def static_level(self, new_val:int):
        self._context.set('root.lu.digi_user_io.instance.attribute.digi_out1_mode.enum.static_level', int(new_val))


class RootLuDigi_user_ioInstanceAttributeDigi_out1_mode(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.digi_user_io.instance.attribute.digi_out1_mode'
        self.enum = RootLuDigi_user_ioInstanceAttributeDigi_out1_modeEnum(self._context)


class RootLuDigi_user_ioInstanceAttributeDigi_out2_modeEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.digi_user_io.instance.attribute.digi_out2_mode.enum'

    @property
    def event_rising_edge_pulse(self) -> int:
        return int(self._context.get('root.lu.digi_user_io.instance.attribute.digi_out2_mode.enum.event_rising_edge_pulse'))

    @event_rising_edge_pulse.setter
    def event_rising_edge_pulse(self, new_val:int):
        self._context.set('root.lu.digi_user_io.instance.attribute.digi_out2_mode.enum.event_rising_edge_pulse', int(new_val))

    @property
    def event_rising_and_falling_edge_pulse(self) -> int:
        return int(self._context.get('root.lu.digi_user_io.instance.attribute.digi_out2_mode.enum.event_rising_and_falling_edge_pulse'))

    @event_rising_and_falling_edge_pulse.setter
    def event_rising_and_falling_edge_pulse(self, new_val:int):
        self._context.set('root.lu.digi_user_io.instance.attribute.digi_out2_mode.enum.event_rising_and_falling_edge_pulse', int(new_val))

    @property
    def event_falling_edge_pulse(self) -> int:
        return int(self._context.get('root.lu.digi_user_io.instance.attribute.digi_out2_mode.enum.event_falling_edge_pulse'))

    @event_falling_edge_pulse.setter
    def event_falling_edge_pulse(self, new_val:int):
        self._context.set('root.lu.digi_user_io.instance.attribute.digi_out2_mode.enum.event_falling_edge_pulse', int(new_val))

    @property
    def event_level(self) -> int:
        return int(self._context.get('root.lu.digi_user_io.instance.attribute.digi_out2_mode.enum.event_level'))

    @event_level.setter
    def event_level(self, new_val:int):
        self._context.set('root.lu.digi_user_io.instance.attribute.digi_out2_mode.enum.event_level', int(new_val))

    @property
    def static_level(self) -> int:
        return int(self._context.get('root.lu.digi_user_io.instance.attribute.digi_out2_mode.enum.static_level'))

    @static_level.setter
    def static_level(self, new_val:int):
        self._context.set('root.lu.digi_user_io.instance.attribute.digi_out2_mode.enum.static_level', int(new_val))


class RootLuDigi_user_ioInstanceAttributeDigi_out2_mode(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.digi_user_io.instance.attribute.digi_out2_mode'
        self.enum = RootLuDigi_user_ioInstanceAttributeDigi_out2_modeEnum(self._context)


class RootLuDigi_user_ioInstanceAttributeDigi_in1_levelEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.digi_user_io.instance.attribute.digi_in1_level.enum'

    @property
    def high(self) -> int:
        return int(self._context.get('root.lu.digi_user_io.instance.attribute.digi_in1_level.enum.high'))

    @high.setter
    def high(self, new_val:int):
        self._context.set('root.lu.digi_user_io.instance.attribute.digi_in1_level.enum.high', int(new_val))

    @property
    def low(self) -> int:
        return int(self._context.get('root.lu.digi_user_io.instance.attribute.digi_in1_level.enum.low'))

    @low.setter
    def low(self, new_val:int):
        self._context.set('root.lu.digi_user_io.instance.attribute.digi_in1_level.enum.low', int(new_val))


class RootLuDigi_user_ioInstanceAttributeDigi_in1_level(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.digi_user_io.instance.attribute.digi_in1_level'
        self.enum = RootLuDigi_user_ioInstanceAttributeDigi_in1_levelEnum(self._context)


class RootLuDigi_user_ioInstanceAttributeDigi_out2_event_sourceEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.digi_user_io.instance.attribute.digi_out2_event_source.enum'

    @property
    def and_mask0_true(self) -> int:
        return int(self._context.get('root.lu.digi_user_io.instance.attribute.digi_out2_event_source.enum.and_mask0_true'))

    @and_mask0_true.setter
    def and_mask0_true(self, new_val:int):
        self._context.set('root.lu.digi_user_io.instance.attribute.digi_out2_event_source.enum.and_mask0_true', int(new_val))

    @property
    def ext_event0_true(self) -> int:
        return int(self._context.get('root.lu.digi_user_io.instance.attribute.digi_out2_event_source.enum.ext_event0_true'))

    @ext_event0_true.setter
    def ext_event0_true(self, new_val:int):
        self._context.set('root.lu.digi_user_io.instance.attribute.digi_out2_event_source.enum.ext_event0_true', int(new_val))

    @property
    def z_ctrl_reached_min_z_true(self) -> int:
        return int(self._context.get('root.lu.digi_user_io.instance.attribute.digi_out2_event_source.enum.z_ctrl_reached_min_z_true'))

    @z_ctrl_reached_min_z_true.setter
    def z_ctrl_reached_min_z_true(self, new_val:int):
        self._context.set('root.lu.digi_user_io.instance.attribute.digi_out2_event_source.enum.z_ctrl_reached_min_z_true', int(new_val))

    @property
    def z_ctrl_reached_max_z_true(self) -> int:
        return int(self._context.get('root.lu.digi_user_io.instance.attribute.digi_out2_event_source.enum.z_ctrl_reached_max_z_true'))

    @z_ctrl_reached_max_z_true.setter
    def z_ctrl_reached_max_z_true(self, new_val:int):
        self._context.set('root.lu.digi_user_io.instance.attribute.digi_out2_event_source.enum.z_ctrl_reached_max_z_true', int(new_val))

    @property
    def timer_proc0_done(self) -> int:
        return int(self._context.get('root.lu.digi_user_io.instance.attribute.digi_out2_event_source.enum.timer_proc0_done'))

    @timer_proc0_done.setter
    def timer_proc0_done(self, new_val:int):
        self._context.set('root.lu.digi_user_io.instance.attribute.digi_out2_event_source.enum.timer_proc0_done', int(new_val))

    @property
    def soft_event0_true(self) -> int:
        return int(self._context.get('root.lu.digi_user_io.instance.attribute.digi_out2_event_source.enum.soft_event0_true'))

    @soft_event0_true.setter
    def soft_event0_true(self, new_val:int):
        self._context.set('root.lu.digi_user_io.instance.attribute.digi_out2_event_source.enum.soft_event0_true', int(new_val))

    @property
    def z_ctrl_reached_error_limit_true(self) -> int:
        return int(self._context.get('root.lu.digi_user_io.instance.attribute.digi_out2_event_source.enum.z_ctrl_reached_error_limit_true'))

    @z_ctrl_reached_error_limit_true.setter
    def z_ctrl_reached_error_limit_true(self, new_val:int):
        self._context.set('root.lu.digi_user_io.instance.attribute.digi_out2_event_source.enum.z_ctrl_reached_error_limit_true', int(new_val))

    @property
    def user_abort_event_true(self) -> int:
        return int(self._context.get('root.lu.digi_user_io.instance.attribute.digi_out2_event_source.enum.user_abort_event_true'))

    @user_abort_event_true.setter
    def user_abort_event_true(self, new_val:int):
        self._context.set('root.lu.digi_user_io.instance.attribute.digi_out2_event_source.enum.user_abort_event_true', int(new_val))

    @property
    def comparator3_true(self) -> int:
        return int(self._context.get('root.lu.digi_user_io.instance.attribute.digi_out2_event_source.enum.comparator3_true'))

    @comparator3_true.setter
    def comparator3_true(self, new_val:int):
        self._context.set('root.lu.digi_user_io.instance.attribute.digi_out2_event_source.enum.comparator3_true', int(new_val))

    @property
    def static_value(self) -> int:
        return int(self._context.get('root.lu.digi_user_io.instance.attribute.digi_out2_event_source.enum.static_value'))

    @static_value.setter
    def static_value(self, new_val:int):
        self._context.set('root.lu.digi_user_io.instance.attribute.digi_out2_event_source.enum.static_value', int(new_val))

    @property
    def soft_event2_true(self) -> int:
        return int(self._context.get('root.lu.digi_user_io.instance.attribute.digi_out2_event_source.enum.soft_event2_true'))

    @soft_event2_true.setter
    def soft_event2_true(self, new_val:int):
        self._context.set('root.lu.digi_user_io.instance.attribute.digi_out2_event_source.enum.soft_event2_true', int(new_val))

    @property
    def comparator1_true(self) -> int:
        return int(self._context.get('root.lu.digi_user_io.instance.attribute.digi_out2_event_source.enum.comparator1_true'))

    @comparator1_true.setter
    def comparator1_true(self, new_val:int):
        self._context.set('root.lu.digi_user_io.instance.attribute.digi_out2_event_source.enum.comparator1_true', int(new_val))

    @property
    def soft_event1_true(self) -> int:
        return int(self._context.get('root.lu.digi_user_io.instance.attribute.digi_out2_event_source.enum.soft_event1_true'))

    @soft_event1_true.setter
    def soft_event1_true(self, new_val:int):
        self._context.set('root.lu.digi_user_io.instance.attribute.digi_out2_event_source.enum.soft_event1_true', int(new_val))

    @property
    def comparator2_true(self) -> int:
        return int(self._context.get('root.lu.digi_user_io.instance.attribute.digi_out2_event_source.enum.comparator2_true'))

    @comparator2_true.setter
    def comparator2_true(self, new_val:int):
        self._context.set('root.lu.digi_user_io.instance.attribute.digi_out2_event_source.enum.comparator2_true', int(new_val))

    @property
    def ramp_gen_planez_done(self) -> int:
        return int(self._context.get('root.lu.digi_user_io.instance.attribute.digi_out2_event_source.enum.ramp_gen_planez_done'))

    @ramp_gen_planez_done.setter
    def ramp_gen_planez_done(self, new_val:int):
        self._context.set('root.lu.digi_user_io.instance.attribute.digi_out2_event_source.enum.ramp_gen_planez_done', int(new_val))

    @property
    def ramp_gen_ctrlz_done(self) -> int:
        return int(self._context.get('root.lu.digi_user_io.instance.attribute.digi_out2_event_source.enum.ramp_gen_ctrlz_done'))

    @ramp_gen_ctrlz_done.setter
    def ramp_gen_ctrlz_done(self, new_val:int):
        self._context.set('root.lu.digi_user_io.instance.attribute.digi_out2_event_source.enum.ramp_gen_ctrlz_done', int(new_val))

    @property
    def ramp_gen_approach_done(self) -> int:
        return int(self._context.get('root.lu.digi_user_io.instance.attribute.digi_out2_event_source.enum.ramp_gen_approach_done'))

    @ramp_gen_approach_done.setter
    def ramp_gen_approach_done(self, new_val:int):
        self._context.set('root.lu.digi_user_io.instance.attribute.digi_out2_event_source.enum.ramp_gen_approach_done', int(new_val))

    @property
    def ramp_gen_user4_done(self) -> int:
        return int(self._context.get('root.lu.digi_user_io.instance.attribute.digi_out2_event_source.enum.ramp_gen_user4_done'))

    @ramp_gen_user4_done.setter
    def ramp_gen_user4_done(self, new_val:int):
        self._context.set('root.lu.digi_user_io.instance.attribute.digi_out2_event_source.enum.ramp_gen_user4_done', int(new_val))

    @property
    def data_capture_done(self) -> int:
        return int(self._context.get('root.lu.digi_user_io.instance.attribute.digi_out2_event_source.enum.data_capture_done'))

    @data_capture_done.setter
    def data_capture_done(self, new_val:int):
        self._context.set('root.lu.digi_user_io.instance.attribute.digi_out2_event_source.enum.data_capture_done', int(new_val))

    @property
    def mem_sig_gen_done(self) -> int:
        return int(self._context.get('root.lu.digi_user_io.instance.attribute.digi_out2_event_source.enum.mem_sig_gen_done'))

    @mem_sig_gen_done.setter
    def mem_sig_gen_done(self, new_val:int):
        self._context.set('root.lu.digi_user_io.instance.attribute.digi_out2_event_source.enum.mem_sig_gen_done', int(new_val))

    @property
    def ramp_gen_positionx_done(self) -> int:
        return int(self._context.get('root.lu.digi_user_io.instance.attribute.digi_out2_event_source.enum.ramp_gen_positionx_done'))

    @ramp_gen_positionx_done.setter
    def ramp_gen_positionx_done(self, new_val:int):
        self._context.set('root.lu.digi_user_io.instance.attribute.digi_out2_event_source.enum.ramp_gen_positionx_done', int(new_val))

    @property
    def data_sampling_done(self) -> int:
        return int(self._context.get('root.lu.digi_user_io.instance.attribute.digi_out2_event_source.enum.data_sampling_done'))

    @data_sampling_done.setter
    def data_sampling_done(self, new_val:int):
        self._context.set('root.lu.digi_user_io.instance.attribute.digi_out2_event_source.enum.data_sampling_done', int(new_val))

    @property
    def ramp_gen_maxz_done(self) -> int:
        return int(self._context.get('root.lu.digi_user_io.instance.attribute.digi_out2_event_source.enum.ramp_gen_maxz_done'))

    @ramp_gen_maxz_done.setter
    def ramp_gen_maxz_done(self, new_val:int):
        self._context.set('root.lu.digi_user_io.instance.attribute.digi_out2_event_source.enum.ramp_gen_maxz_done', int(new_val))

    @property
    def ramp_gen_alternatez_done(self) -> int:
        return int(self._context.get('root.lu.digi_user_io.instance.attribute.digi_out2_event_source.enum.ramp_gen_alternatez_done'))

    @ramp_gen_alternatez_done.setter
    def ramp_gen_alternatez_done(self, new_val:int):
        self._context.set('root.lu.digi_user_io.instance.attribute.digi_out2_event_source.enum.ramp_gen_alternatez_done', int(new_val))

    @property
    def ramp_gen_tipvoltage_done(self) -> int:
        return int(self._context.get('root.lu.digi_user_io.instance.attribute.digi_out2_event_source.enum.ramp_gen_tipvoltage_done'))

    @ramp_gen_tipvoltage_done.setter
    def ramp_gen_tipvoltage_done(self, new_val:int):
        self._context.set('root.lu.digi_user_io.instance.attribute.digi_out2_event_source.enum.ramp_gen_tipvoltage_done', int(new_val))

    @property
    def ramp_gen_test_done(self) -> int:
        return int(self._context.get('root.lu.digi_user_io.instance.attribute.digi_out2_event_source.enum.ramp_gen_test_done'))

    @ramp_gen_test_done.setter
    def ramp_gen_test_done(self, new_val:int):
        self._context.set('root.lu.digi_user_io.instance.attribute.digi_out2_event_source.enum.ramp_gen_test_done', int(new_val))

    @property
    def ramp_gen_positiony_done(self) -> int:
        return int(self._context.get('root.lu.digi_user_io.instance.attribute.digi_out2_event_source.enum.ramp_gen_positiony_done'))

    @ramp_gen_positiony_done.setter
    def ramp_gen_positiony_done(self, new_val:int):
        self._context.set('root.lu.digi_user_io.instance.attribute.digi_out2_event_source.enum.ramp_gen_positiony_done', int(new_val))

    @property
    def event_manager_done(self) -> int:
        return int(self._context.get('root.lu.digi_user_io.instance.attribute.digi_out2_event_source.enum.event_manager_done'))

    @event_manager_done.setter
    def event_manager_done(self, new_val:int):
        self._context.set('root.lu.digi_user_io.instance.attribute.digi_out2_event_source.enum.event_manager_done', int(new_val))

    @property
    def ramp_gen_positionw_done(self) -> int:
        return int(self._context.get('root.lu.digi_user_io.instance.attribute.digi_out2_event_source.enum.ramp_gen_positionw_done'))

    @ramp_gen_positionw_done.setter
    def ramp_gen_positionw_done(self, new_val:int):
        self._context.set('root.lu.digi_user_io.instance.attribute.digi_out2_event_source.enum.ramp_gen_positionw_done', int(new_val))

    @property
    def timer_dbg1_done(self) -> int:
        return int(self._context.get('root.lu.digi_user_io.instance.attribute.digi_out2_event_source.enum.timer_dbg1_done'))

    @timer_dbg1_done.setter
    def timer_dbg1_done(self, new_val:int):
        self._context.set('root.lu.digi_user_io.instance.attribute.digi_out2_event_source.enum.timer_dbg1_done', int(new_val))

    @property
    def ext_event1_true(self) -> int:
        return int(self._context.get('root.lu.digi_user_io.instance.attribute.digi_out2_event_source.enum.ext_event1_true'))

    @ext_event1_true.setter
    def ext_event1_true(self, new_val:int):
        self._context.set('root.lu.digi_user_io.instance.attribute.digi_out2_event_source.enum.ext_event1_true', int(new_val))


class RootLuDigi_user_ioInstanceAttributeDigi_out2_event_source(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.digi_user_io.instance.attribute.digi_out2_event_source'
        self.enum = RootLuDigi_user_ioInstanceAttributeDigi_out2_event_sourceEnum(self._context)


class RootLuDigi_user_ioInstanceAttributeDigi_out1_enableEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.digi_user_io.instance.attribute.digi_out1_enable.enum'

    @property
    def disabled(self) -> int:
        return int(self._context.get('root.lu.digi_user_io.instance.attribute.digi_out1_enable.enum.disabled'))

    @disabled.setter
    def disabled(self, new_val:int):
        self._context.set('root.lu.digi_user_io.instance.attribute.digi_out1_enable.enum.disabled', int(new_val))

    @property
    def enabled(self) -> int:
        return int(self._context.get('root.lu.digi_user_io.instance.attribute.digi_out1_enable.enum.enabled'))

    @enabled.setter
    def enabled(self, new_val:int):
        self._context.set('root.lu.digi_user_io.instance.attribute.digi_out1_enable.enum.enabled', int(new_val))


class RootLuDigi_user_ioInstanceAttributeDigi_out1_enable(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.digi_user_io.instance.attribute.digi_out1_enable'
        self.enum = RootLuDigi_user_ioInstanceAttributeDigi_out1_enableEnum(self._context)


class RootLuDigi_user_ioInstanceAttributeDigi_out2_levelEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.digi_user_io.instance.attribute.digi_out2_level.enum'

    @property
    def high(self) -> int:
        return int(self._context.get('root.lu.digi_user_io.instance.attribute.digi_out2_level.enum.high'))

    @high.setter
    def high(self, new_val:int):
        self._context.set('root.lu.digi_user_io.instance.attribute.digi_out2_level.enum.high', int(new_val))

    @property
    def low(self) -> int:
        return int(self._context.get('root.lu.digi_user_io.instance.attribute.digi_out2_level.enum.low'))

    @low.setter
    def low(self, new_val:int):
        self._context.set('root.lu.digi_user_io.instance.attribute.digi_out2_level.enum.low', int(new_val))


class RootLuDigi_user_ioInstanceAttributeDigi_out2_level(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.digi_user_io.instance.attribute.digi_out2_level'
        self.enum = RootLuDigi_user_ioInstanceAttributeDigi_out2_levelEnum(self._context)


class RootLuDigi_user_ioInstanceAttribute(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.digi_user_io.instance.attribute'
        self.digi_out2_level = RootLuDigi_user_ioInstanceAttributeDigi_out2_level(self._context)
        self.digi_out1_enable = RootLuDigi_user_ioInstanceAttributeDigi_out1_enable(self._context)
        self.digi_out2_event_source = RootLuDigi_user_ioInstanceAttributeDigi_out2_event_source(self._context)
        self.digi_in1_level = RootLuDigi_user_ioInstanceAttributeDigi_in1_level(self._context)
        self.digi_out2_mode = RootLuDigi_user_ioInstanceAttributeDigi_out2_mode(self._context)
        self.digi_out1_mode = RootLuDigi_user_ioInstanceAttributeDigi_out1_mode(self._context)
        self.digi_out2_pulse = RootLuDigi_user_ioInstanceAttributeDigi_out2_pulse(self._context)
        self.digi_out1_level = RootLuDigi_user_ioInstanceAttributeDigi_out1_level(self._context)
        self.digi_out2_enable = RootLuDigi_user_ioInstanceAttributeDigi_out2_enable(self._context)
        self.digi_out1_event_source = RootLuDigi_user_ioInstanceAttributeDigi_out1_event_source(self._context)
        self.digi_in2_level = RootLuDigi_user_ioInstanceAttributeDigi_in2_level(self._context)
        self.digi_out1_pulse = RootLuDigi_user_ioInstanceAttributeDigi_out1_pulse(self._context)


class RootLuDigi_user_ioInstance(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.digi_user_io.instance'
        self.attribute = RootLuDigi_user_ioInstanceAttribute(self._context)
        self.trigger = RootLuDigi_user_ioInstanceTrigger(self._context)


class RootLuDigi_user_io(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.digi_user_io'
        self.instance = RootLuDigi_user_ioInstance(self._context)


class RootLuDirect_motor_controlInstanceTriggerCommit_transaction(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.direct_motor_control.instance.trigger.commit_transaction'


class RootLuDirect_motor_controlInstanceTriggerSearch_reference(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.direct_motor_control.instance.trigger.search_reference'


class RootLuDirect_motor_controlInstanceTriggerReset_transaction(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.direct_motor_control.instance.trigger.reset_transaction'


class RootLuDirect_motor_controlInstanceTriggerUser_abort(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.direct_motor_control.instance.trigger.user_abort'


class RootLuDirect_motor_controlInstanceTriggerPosition_zero_axis(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.direct_motor_control.instance.trigger.position_zero_axis'


class RootLuDirect_motor_controlInstanceTriggerAdd_transaction_move(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.direct_motor_control.instance.trigger.add_transaction_move'


class RootLuDirect_motor_controlInstanceTrigger(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.direct_motor_control.instance.trigger'
        self.add_transaction_move = RootLuDirect_motor_controlInstanceTriggerAdd_transaction_move(self._context)
        self.position_zero_axis = RootLuDirect_motor_controlInstanceTriggerPosition_zero_axis(self._context)
        self.user_abort = RootLuDirect_motor_controlInstanceTriggerUser_abort(self._context)
        self.reset_transaction = RootLuDirect_motor_controlInstanceTriggerReset_transaction(self._context)
        self.search_reference = RootLuDirect_motor_controlInstanceTriggerSearch_reference(self._context)
        self.commit_transaction = RootLuDirect_motor_controlInstanceTriggerCommit_transaction(self._context)


class RootLuDirect_motor_controlInstanceAttributeTransaction_move_relativeEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.direct_motor_control.instance.attribute.transaction_move_relative.enum'

    @property
    def absolute(self) -> int:
        return int(self._context.get('root.lu.direct_motor_control.instance.attribute.transaction_move_relative.enum.absolute'))

    @absolute.setter
    def absolute(self, new_val:int):
        self._context.set('root.lu.direct_motor_control.instance.attribute.transaction_move_relative.enum.absolute', int(new_val))

    @property
    def relative(self) -> int:
        return int(self._context.get('root.lu.direct_motor_control.instance.attribute.transaction_move_relative.enum.relative'))

    @relative.setter
    def relative(self, new_val:int):
        self._context.set('root.lu.direct_motor_control.instance.attribute.transaction_move_relative.enum.relative', int(new_val))


class RootLuDirect_motor_controlInstanceAttributeTransaction_move_relative(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.direct_motor_control.instance.attribute.transaction_move_relative'
        self.enum = RootLuDirect_motor_controlInstanceAttributeTransaction_move_relativeEnum(self._context)


class RootLuDirect_motor_controlInstanceAttributeTransaction_move_destination(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.direct_motor_control.instance.attribute.transaction_move_destination'


class RootLuDirect_motor_controlInstanceAttributeAxis_speed_factor(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.direct_motor_control.instance.attribute.axis_speed_factor'


class RootLuDirect_motor_controlInstanceAttributeAxis_position(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.direct_motor_control.instance.attribute.axis_position'


class RootLuDirect_motor_controlInstanceAttributeAxis_max_speed(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.direct_motor_control.instance.attribute.axis_max_speed'


class RootLuDirect_motor_controlInstanceAttributeLayout_statusEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.direct_motor_control.instance.attribute.layout_status.enum'

    @property
    def not_loaded(self) -> int:
        return int(self._context.get('root.lu.direct_motor_control.instance.attribute.layout_status.enum.not_loaded'))

    @not_loaded.setter
    def not_loaded(self, new_val:int):
        self._context.set('root.lu.direct_motor_control.instance.attribute.layout_status.enum.not_loaded', int(new_val))

    @property
    def uninitialized(self) -> int:
        return int(self._context.get('root.lu.direct_motor_control.instance.attribute.layout_status.enum.uninitialized'))

    @uninitialized.setter
    def uninitialized(self, new_val:int):
        self._context.set('root.lu.direct_motor_control.instance.attribute.layout_status.enum.uninitialized', int(new_val))

    @property
    def initialized(self) -> int:
        return int(self._context.get('root.lu.direct_motor_control.instance.attribute.layout_status.enum.initialized'))

    @initialized.setter
    def initialized(self, new_val:int):
        self._context.set('root.lu.direct_motor_control.instance.attribute.layout_status.enum.initialized', int(new_val))


class RootLuDirect_motor_controlInstanceAttributeLayout_status(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.direct_motor_control.instance.attribute.layout_status'
        self.enum = RootLuDirect_motor_controlInstanceAttributeLayout_statusEnum(self._context)


class RootLuDirect_motor_controlInstanceAttributeAxis_statusEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.direct_motor_control.instance.attribute.axis_status.enum'

    @property
    def idle_unreferenced(self) -> int:
        return int(self._context.get('root.lu.direct_motor_control.instance.attribute.axis_status.enum.idle_unreferenced'))

    @idle_unreferenced.setter
    def idle_unreferenced(self, new_val:int):
        self._context.set('root.lu.direct_motor_control.instance.attribute.axis_status.enum.idle_unreferenced', int(new_val))

    @property
    def not_mapped(self) -> int:
        return int(self._context.get('root.lu.direct_motor_control.instance.attribute.axis_status.enum.not_mapped'))

    @not_mapped.setter
    def not_mapped(self, new_val:int):
        self._context.set('root.lu.direct_motor_control.instance.attribute.axis_status.enum.not_mapped', int(new_val))

    @property
    def idle_referenced(self) -> int:
        return int(self._context.get('root.lu.direct_motor_control.instance.attribute.axis_status.enum.idle_referenced'))

    @idle_referenced.setter
    def idle_referenced(self, new_val:int):
        self._context.set('root.lu.direct_motor_control.instance.attribute.axis_status.enum.idle_referenced', int(new_val))

    @property
    def moving(self) -> int:
        return int(self._context.get('root.lu.direct_motor_control.instance.attribute.axis_status.enum.moving'))

    @moving.setter
    def moving(self, new_val:int):
        self._context.set('root.lu.direct_motor_control.instance.attribute.axis_status.enum.moving', int(new_val))

    @property
    def referencing(self) -> int:
        return int(self._context.get('root.lu.direct_motor_control.instance.attribute.axis_status.enum.referencing'))

    @referencing.setter
    def referencing(self, new_val:int):
        self._context.set('root.lu.direct_motor_control.instance.attribute.axis_status.enum.referencing', int(new_val))


class RootLuDirect_motor_controlInstanceAttributeAxis_status(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.direct_motor_control.instance.attribute.axis_status'
        self.enum = RootLuDirect_motor_controlInstanceAttributeAxis_statusEnum(self._context)


class RootLuDirect_motor_controlInstanceAttributeCurrent_axisEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.direct_motor_control.instance.attribute.current_axis.enum'

    @property
    def approach_0(self) -> int:
        return int(self._context.get('root.lu.direct_motor_control.instance.attribute.current_axis.enum.approach_0'))

    @approach_0.setter
    def approach_0(self, new_val:int):
        self._context.set('root.lu.direct_motor_control.instance.attribute.current_axis.enum.approach_0', int(new_val))

    @property
    def y_axis(self) -> int:
        return int(self._context.get('root.lu.direct_motor_control.instance.attribute.current_axis.enum.y_axis'))

    @y_axis.setter
    def y_axis(self, new_val:int):
        self._context.set('root.lu.direct_motor_control.instance.attribute.current_axis.enum.y_axis', int(new_val))

    @property
    def beam_deflection_spot_horz(self) -> int:
        return int(self._context.get('root.lu.direct_motor_control.instance.attribute.current_axis.enum.beam_deflection_spot_horz'))

    @beam_deflection_spot_horz.setter
    def beam_deflection_spot_horz(self, new_val:int):
        self._context.set('root.lu.direct_motor_control.instance.attribute.current_axis.enum.beam_deflection_spot_horz', int(new_val))

    @property
    def all(self) -> int:
        return int(self._context.get('root.lu.direct_motor_control.instance.attribute.current_axis.enum.all'))

    @all.setter
    def all(self, new_val:int):
        self._context.set('root.lu.direct_motor_control.instance.attribute.current_axis.enum.all', int(new_val))

    @property
    def approach_2(self) -> int:
        return int(self._context.get('root.lu.direct_motor_control.instance.attribute.current_axis.enum.approach_2'))

    @approach_2.setter
    def approach_2(self, new_val:int):
        self._context.set('root.lu.direct_motor_control.instance.attribute.current_axis.enum.approach_2', int(new_val))

    @property
    def x_axis(self) -> int:
        return int(self._context.get('root.lu.direct_motor_control.instance.attribute.current_axis.enum.x_axis'))

    @x_axis.setter
    def x_axis(self, new_val:int):
        self._context.set('root.lu.direct_motor_control.instance.attribute.current_axis.enum.x_axis', int(new_val))

    @property
    def approach_1(self) -> int:
        return int(self._context.get('root.lu.direct_motor_control.instance.attribute.current_axis.enum.approach_1'))

    @approach_1.setter
    def approach_1(self, new_val:int):
        self._context.set('root.lu.direct_motor_control.instance.attribute.current_axis.enum.approach_1', int(new_val))

    @property
    def approach(self) -> int:
        return int(self._context.get('root.lu.direct_motor_control.instance.attribute.current_axis.enum.approach'))

    @approach.setter
    def approach(self, new_val:int):
        self._context.set('root.lu.direct_motor_control.instance.attribute.current_axis.enum.approach', int(new_val))

    @property
    def photothermal_excitation_spot_vert(self) -> int:
        return int(self._context.get('root.lu.direct_motor_control.instance.attribute.current_axis.enum.photothermal_excitation_spot_vert'))

    @photothermal_excitation_spot_vert.setter
    def photothermal_excitation_spot_vert(self, new_val:int):
        self._context.set('root.lu.direct_motor_control.instance.attribute.current_axis.enum.photothermal_excitation_spot_vert', int(new_val))

    @property
    def photothermal_excitation_spot_horz(self) -> int:
        return int(self._context.get('root.lu.direct_motor_control.instance.attribute.current_axis.enum.photothermal_excitation_spot_horz'))

    @photothermal_excitation_spot_horz.setter
    def photothermal_excitation_spot_horz(self, new_val:int):
        self._context.set('root.lu.direct_motor_control.instance.attribute.current_axis.enum.photothermal_excitation_spot_horz', int(new_val))

    @property
    def photodiode_detector_horz(self) -> int:
        return int(self._context.get('root.lu.direct_motor_control.instance.attribute.current_axis.enum.photodiode_detector_horz'))

    @photodiode_detector_horz.setter
    def photodiode_detector_horz(self, new_val:int):
        self._context.set('root.lu.direct_motor_control.instance.attribute.current_axis.enum.photodiode_detector_horz', int(new_val))

    @property
    def beam_deflection_spot_vert(self) -> int:
        return int(self._context.get('root.lu.direct_motor_control.instance.attribute.current_axis.enum.beam_deflection_spot_vert'))

    @beam_deflection_spot_vert.setter
    def beam_deflection_spot_vert(self, new_val:int):
        self._context.set('root.lu.direct_motor_control.instance.attribute.current_axis.enum.beam_deflection_spot_vert', int(new_val))

    @property
    def photodiode_detector_vert(self) -> int:
        return int(self._context.get('root.lu.direct_motor_control.instance.attribute.current_axis.enum.photodiode_detector_vert'))

    @photodiode_detector_vert.setter
    def photodiode_detector_vert(self, new_val:int):
        self._context.set('root.lu.direct_motor_control.instance.attribute.current_axis.enum.photodiode_detector_vert', int(new_val))

    @property
    def lens_gimbal(self) -> int:
        return int(self._context.get('root.lu.direct_motor_control.instance.attribute.current_axis.enum.lens_gimbal'))

    @lens_gimbal.setter
    def lens_gimbal(self, new_val:int):
        self._context.set('root.lu.direct_motor_control.instance.attribute.current_axis.enum.lens_gimbal', int(new_val))

    @property
    def focus_cantilever_light_source(self) -> int:
        return int(self._context.get('root.lu.direct_motor_control.instance.attribute.current_axis.enum.focus_cantilever_light_source'))

    @focus_cantilever_light_source.setter
    def focus_cantilever_light_source(self, new_val:int):
        self._context.set('root.lu.direct_motor_control.instance.attribute.current_axis.enum.focus_cantilever_light_source', int(new_val))


class RootLuDirect_motor_controlInstanceAttributeCurrent_axis(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.direct_motor_control.instance.attribute.current_axis'
        self.enum = RootLuDirect_motor_controlInstanceAttributeCurrent_axisEnum(self._context)


class RootLuDirect_motor_controlInstanceAttributeAxis_limit_statusEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.direct_motor_control.instance.attribute.axis_limit_status.enum'

    @property
    def in_both_limits(self) -> int:
        return int(self._context.get('root.lu.direct_motor_control.instance.attribute.axis_limit_status.enum.in_both_limits'))

    @in_both_limits.setter
    def in_both_limits(self, new_val:int):
        self._context.set('root.lu.direct_motor_control.instance.attribute.axis_limit_status.enum.in_both_limits', int(new_val))

    @property
    def in_no_limit(self) -> int:
        return int(self._context.get('root.lu.direct_motor_control.instance.attribute.axis_limit_status.enum.in_no_limit'))

    @in_no_limit.setter
    def in_no_limit(self, new_val:int):
        self._context.set('root.lu.direct_motor_control.instance.attribute.axis_limit_status.enum.in_no_limit', int(new_val))

    @property
    def in_upper_limit(self) -> int:
        return int(self._context.get('root.lu.direct_motor_control.instance.attribute.axis_limit_status.enum.in_upper_limit'))

    @in_upper_limit.setter
    def in_upper_limit(self, new_val:int):
        self._context.set('root.lu.direct_motor_control.instance.attribute.axis_limit_status.enum.in_upper_limit', int(new_val))

    @property
    def in_lower_limit(self) -> int:
        return int(self._context.get('root.lu.direct_motor_control.instance.attribute.axis_limit_status.enum.in_lower_limit'))

    @in_lower_limit.setter
    def in_lower_limit(self, new_val:int):
        self._context.set('root.lu.direct_motor_control.instance.attribute.axis_limit_status.enum.in_lower_limit', int(new_val))

    @property
    def in_limit(self) -> int:
        return int(self._context.get('root.lu.direct_motor_control.instance.attribute.axis_limit_status.enum.in_limit'))

    @in_limit.setter
    def in_limit(self, new_val:int):
        self._context.set('root.lu.direct_motor_control.instance.attribute.axis_limit_status.enum.in_limit', int(new_val))


class RootLuDirect_motor_controlInstanceAttributeAxis_limit_status(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.direct_motor_control.instance.attribute.axis_limit_status'
        self.enum = RootLuDirect_motor_controlInstanceAttributeAxis_limit_statusEnum(self._context)


class RootLuDirect_motor_controlInstanceAttributeAxis_last_reference_move_distance(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.direct_motor_control.instance.attribute.axis_last_reference_move_distance'


class RootLuDirect_motor_controlInstanceAttributeMove_adjust(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.direct_motor_control.instance.attribute.move_adjust'


class RootLuDirect_motor_controlInstanceAttributeCurrent_layoutEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.direct_motor_control.instance.attribute.current_layout.enum'

    @property
    def all(self) -> int:
        return int(self._context.get('root.lu.direct_motor_control.instance.attribute.current_layout.enum.all'))

    @all.setter
    def all(self, new_val:int):
        self._context.set('root.lu.direct_motor_control.instance.attribute.current_layout.enum.all', int(new_val))

    @property
    def dummy2(self) -> int:
        return int(self._context.get('root.lu.direct_motor_control.instance.attribute.current_layout.enum.dummy2'))

    @dummy2.setter
    def dummy2(self, new_val:int):
        self._context.set('root.lu.direct_motor_control.instance.attribute.current_layout.enum.dummy2', int(new_val))

    @property
    def core(self) -> int:
        return int(self._context.get('root.lu.direct_motor_control.instance.attribute.current_layout.enum.core'))

    @core.setter
    def core(self, new_val:int):
        self._context.set('root.lu.direct_motor_control.instance.attribute.current_layout.enum.core', int(new_val))

    @property
    def sim(self) -> int:
        return int(self._context.get('root.lu.direct_motor_control.instance.attribute.current_layout.enum.sim'))

    @sim.setter
    def sim(self, new_val:int):
        self._context.set('root.lu.direct_motor_control.instance.attribute.current_layout.enum.sim', int(new_val))

    @property
    def p6(self) -> int:
        return int(self._context.get('root.lu.direct_motor_control.instance.attribute.current_layout.enum.p6'))

    @p6.setter
    def p6(self, new_val:int):
        self._context.set('root.lu.direct_motor_control.instance.attribute.current_layout.enum.p6', int(new_val))

    @property
    def dummy4(self) -> int:
        return int(self._context.get('root.lu.direct_motor_control.instance.attribute.current_layout.enum.dummy4'))

    @dummy4.setter
    def dummy4(self, new_val:int):
        self._context.set('root.lu.direct_motor_control.instance.attribute.current_layout.enum.dummy4', int(new_val))

    @property
    def p6_mount(self) -> int:
        return int(self._context.get('root.lu.direct_motor_control.instance.attribute.current_layout.enum.p6_mount'))

    @p6_mount.setter
    def p6_mount(self, new_val:int):
        self._context.set('root.lu.direct_motor_control.instance.attribute.current_layout.enum.p6_mount', int(new_val))

    @property
    def arac(self) -> int:
        return int(self._context.get('root.lu.direct_motor_control.instance.attribute.current_layout.enum.arac'))

    @arac.setter
    def arac(self, new_val:int):
        self._context.set('root.lu.direct_motor_control.instance.attribute.current_layout.enum.arac', int(new_val))

    @property
    def dummy3(self) -> int:
        return int(self._context.get('root.lu.direct_motor_control.instance.attribute.current_layout.enum.dummy3'))

    @dummy3.setter
    def dummy3(self, new_val:int):
        self._context.set('root.lu.direct_motor_control.instance.attribute.current_layout.enum.dummy3', int(new_val))


class RootLuDirect_motor_controlInstanceAttributeCurrent_layout(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.direct_motor_control.instance.attribute.current_layout'
        self.enum = RootLuDirect_motor_controlInstanceAttributeCurrent_layoutEnum(self._context)


class RootLuDirect_motor_controlInstanceAttribute(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.direct_motor_control.instance.attribute'
        self.current_layout = RootLuDirect_motor_controlInstanceAttributeCurrent_layout(self._context)
        self.move_adjust = RootLuDirect_motor_controlInstanceAttributeMove_adjust(self._context)
        self.axis_last_reference_move_distance = RootLuDirect_motor_controlInstanceAttributeAxis_last_reference_move_distance(self._context)
        self.axis_limit_status = RootLuDirect_motor_controlInstanceAttributeAxis_limit_status(self._context)
        self.current_axis = RootLuDirect_motor_controlInstanceAttributeCurrent_axis(self._context)
        self.axis_status = RootLuDirect_motor_controlInstanceAttributeAxis_status(self._context)
        self.layout_status = RootLuDirect_motor_controlInstanceAttributeLayout_status(self._context)
        self.axis_max_speed = RootLuDirect_motor_controlInstanceAttributeAxis_max_speed(self._context)
        self.axis_position = RootLuDirect_motor_controlInstanceAttributeAxis_position(self._context)
        self.axis_speed_factor = RootLuDirect_motor_controlInstanceAttributeAxis_speed_factor(self._context)
        self.transaction_move_destination = RootLuDirect_motor_controlInstanceAttributeTransaction_move_destination(self._context)
        self.transaction_move_relative = RootLuDirect_motor_controlInstanceAttributeTransaction_move_relative(self._context)


class RootLuDirect_motor_controlInstance(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.direct_motor_control.instance'
        self.attribute = RootLuDirect_motor_controlInstanceAttribute(self._context)
        self.trigger = RootLuDirect_motor_controlInstanceTrigger(self._context)


class RootLuDirect_motor_control(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.direct_motor_control'
        self.instance = RootLuDirect_motor_controlInstance(self._context)


class RootLuOscilloscopeInstanceBusyIs_busy(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.oscilloscope.instance.busy.is_busy'


class RootLuOscilloscopeInstanceBusy(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.oscilloscope.instance.busy'
        self.is_busy = RootLuOscilloscopeInstanceBusyIs_busy(self._context)


class RootLuOscilloscopeInstanceAttributeCapture_duration(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.oscilloscope.instance.attribute.capture_duration'


class RootLuOscilloscopeInstanceAttributeCapture_period(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.oscilloscope.instance.attribute.capture_period'


class RootLuOscilloscopeInstanceAttribute(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.oscilloscope.instance.attribute'
        self.capture_period = RootLuOscilloscopeInstanceAttributeCapture_period(self._context)
        self.capture_duration = RootLuOscilloscopeInstanceAttributeCapture_duration(self._context)


class RootLuOscilloscopeInstanceTriggerStop(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.oscilloscope.instance.trigger.stop'


class RootLuOscilloscopeInstanceTriggerStart(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.oscilloscope.instance.trigger.start'


class RootLuOscilloscopeInstanceTrigger(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.oscilloscope.instance.trigger'
        self.start = RootLuOscilloscopeInstanceTriggerStart(self._context)
        self.stop = RootLuOscilloscopeInstanceTriggerStop(self._context)


class RootLuOscilloscopeInstance(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.oscilloscope.instance'
        self.trigger = RootLuOscilloscopeInstanceTrigger(self._context)
        self.attribute = RootLuOscilloscopeInstanceAttribute(self._context)
        self.busy = RootLuOscilloscopeInstanceBusy(self._context)


class RootLuOscilloscope(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.oscilloscope'
        self.instance = RootLuOscilloscopeInstance(self._context)


class RootLuCantilever_propertiesInstanceTrigger(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.cantilever_properties.instance.trigger'


class RootLuCantilever_propertiesInstanceAttributeDeflection_sensitivity(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.cantilever_properties.instance.attribute.deflection_sensitivity'


class RootLuCantilever_propertiesInstanceAttributeShapeEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.cantilever_properties.instance.attribute.shape.enum'

    @property
    def triangular(self) -> int:
        return int(self._context.get('root.lu.cantilever_properties.instance.attribute.shape.enum.triangular'))

    @triangular.setter
    def triangular(self, new_val:int):
        self._context.set('root.lu.cantilever_properties.instance.attribute.shape.enum.triangular', int(new_val))

    @property
    def rectangular(self) -> int:
        return int(self._context.get('root.lu.cantilever_properties.instance.attribute.shape.enum.rectangular'))

    @rectangular.setter
    def rectangular(self, new_val:int):
        self._context.set('root.lu.cantilever_properties.instance.attribute.shape.enum.rectangular', int(new_val))


class RootLuCantilever_propertiesInstanceAttributeShape(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.cantilever_properties.instance.attribute.shape'
        self.enum = RootLuCantilever_propertiesInstanceAttributeShapeEnum(self._context)


class RootLuCantilever_propertiesInstanceAttributeResonance_frequency(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.cantilever_properties.instance.attribute.resonance_frequency'


class RootLuCantilever_propertiesInstanceAttributeAlign_strategyEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.cantilever_properties.instance.attribute.align_strategy.enum'

    @property
    def search_for_reflecting_edges(self) -> int:
        return int(self._context.get('root.lu.cantilever_properties.instance.attribute.align_strategy.enum.search_for_reflecting_edges'))

    @search_for_reflecting_edges.setter
    def search_for_reflecting_edges(self, new_val:int):
        self._context.set('root.lu.cantilever_properties.instance.attribute.align_strategy.enum.search_for_reflecting_edges', int(new_val))

    @property
    def standard(self) -> int:
        return int(self._context.get('root.lu.cantilever_properties.instance.attribute.align_strategy.enum.standard'))

    @standard.setter
    def standard(self, new_val:int):
        self._context.set('root.lu.cantilever_properties.instance.attribute.align_strategy.enum.standard', int(new_val))


class RootLuCantilever_propertiesInstanceAttributeAlign_strategy(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.cantilever_properties.instance.attribute.align_strategy'
        self.enum = RootLuCantilever_propertiesInstanceAttributeAlign_strategyEnum(self._context)


class RootLuCantilever_propertiesInstanceAttributeTip_half_angle(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.cantilever_properties.instance.attribute.tip_half_angle'


class RootLuCantilever_propertiesInstanceAttributeTip_radius(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.cantilever_properties.instance.attribute.tip_radius'


class RootLuCantilever_propertiesInstanceAttributeWidth(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.cantilever_properties.instance.attribute.width'


class RootLuCantilever_propertiesInstanceAttributeQ_factor(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.cantilever_properties.instance.attribute.q_factor'


class RootLuCantilever_propertiesInstanceAttributeSpring_constant(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.cantilever_properties.instance.attribute.spring_constant'


class RootLuCantilever_propertiesInstanceAttributeLength(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.cantilever_properties.instance.attribute.length'


class RootLuCantilever_propertiesInstanceAttribute(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.cantilever_properties.instance.attribute'
        self.length = RootLuCantilever_propertiesInstanceAttributeLength(self._context)
        self.spring_constant = RootLuCantilever_propertiesInstanceAttributeSpring_constant(self._context)
        self.q_factor = RootLuCantilever_propertiesInstanceAttributeQ_factor(self._context)
        self.width = RootLuCantilever_propertiesInstanceAttributeWidth(self._context)
        self.tip_radius = RootLuCantilever_propertiesInstanceAttributeTip_radius(self._context)
        self.tip_half_angle = RootLuCantilever_propertiesInstanceAttributeTip_half_angle(self._context)
        self.align_strategy = RootLuCantilever_propertiesInstanceAttributeAlign_strategy(self._context)
        self.resonance_frequency = RootLuCantilever_propertiesInstanceAttributeResonance_frequency(self._context)
        self.shape = RootLuCantilever_propertiesInstanceAttributeShape(self._context)
        self.deflection_sensitivity = RootLuCantilever_propertiesInstanceAttributeDeflection_sensitivity(self._context)


class RootLuCantilever_propertiesInstance(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.cantilever_properties.instance'
        self.attribute = RootLuCantilever_propertiesInstanceAttribute(self._context)
        self.trigger = RootLuCantilever_propertiesInstanceTrigger(self._context)


class RootLuCantilever_properties(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.cantilever_properties'
        self.instance = RootLuCantilever_propertiesInstance(self._context)


class RootLuOrtInstanceBusyIs_averaging(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ort.instance.busy.is_averaging'


class RootLuOrtInstanceBusy(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ort.instance.busy'
        self.is_averaging = RootLuOrtInstanceBusyIs_averaging(self._context)


class RootLuOrtInstanceAttributeBaseline_frequency(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ort.instance.attribute.baseline_frequency'


class RootLuOrtInstanceAttributeBaseline_controller_state(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ort.instance.attribute.baseline_controller_state'


class RootLuOrtInstanceAttributeBaseline_window_end(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ort.instance.attribute.baseline_window_end'


class RootLuOrtInstanceAttributeCantilever_samples_per_periodEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ort.instance.attribute.cantilever_samples_per_period.enum'

    @property
    def disabled(self) -> int:
        return int(self._context.get('root.lu.ort.instance.attribute.cantilever_samples_per_period.enum.disabled'))

    @disabled.setter
    def disabled(self, new_val:int):
        self._context.set('root.lu.ort.instance.attribute.cantilever_samples_per_period.enum.disabled', int(new_val))

    @property
    def enabled(self) -> int:
        return int(self._context.get('root.lu.ort.instance.attribute.cantilever_samples_per_period.enum.enabled'))

    @enabled.setter
    def enabled(self, new_val:int):
        self._context.set('root.lu.ort.instance.attribute.cantilever_samples_per_period.enum.enabled', int(new_val))


class RootLuOrtInstanceAttributeCantilever_samples_per_period(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ort.instance.attribute.cantilever_samples_per_period'
        self.enum = RootLuOrtInstanceAttributeCantilever_samples_per_periodEnum(self._context)


class RootLuOrtInstanceAttributeBaseline_window_begin(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ort.instance.attribute.baseline_window_begin'


class RootLuOrtInstanceAttributeExcitation_amplitude(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ort.instance.attribute.excitation_amplitude'


class RootLuOrtInstanceAttributeAmplitude_reduction(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ort.instance.attribute.amplitude_reduction'


class RootLuOrtInstanceAttributeFree_wave_delay(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ort.instance.attribute.free_wave_delay'


class RootLuOrtInstanceAttributeAverage_periods(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ort.instance.attribute.average_periods'


class RootLuOrtInstanceAttributeFree_wave_output_stateEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ort.instance.attribute.free_wave_output_state.enum'

    @property
    def disabled(self) -> int:
        return int(self._context.get('root.lu.ort.instance.attribute.free_wave_output_state.enum.disabled'))

    @disabled.setter
    def disabled(self, new_val:int):
        self._context.set('root.lu.ort.instance.attribute.free_wave_output_state.enum.disabled', int(new_val))

    @property
    def enabled(self) -> int:
        return int(self._context.get('root.lu.ort.instance.attribute.free_wave_output_state.enum.enabled'))

    @enabled.setter
    def enabled(self, new_val:int):
        self._context.set('root.lu.ort.instance.attribute.free_wave_output_state.enum.enabled', int(new_val))


class RootLuOrtInstanceAttributeFree_wave_output_state(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ort.instance.attribute.free_wave_output_state'
        self.enum = RootLuOrtInstanceAttributeFree_wave_output_stateEnum(self._context)


class RootLuOrtInstanceAttributeMin_value(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ort.instance.attribute.min_value'


class RootLuOrtInstanceAttributeMin_position(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ort.instance.attribute.min_position'


class RootLuOrtInstanceAttributeSamples_per_period(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ort.instance.attribute.samples_per_period'


class RootLuOrtInstanceAttributeInput_selectEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ort.instance.attribute.input_select.enum'

    @property
    def fast_in_deflection(self) -> int:
        return int(self._context.get('root.lu.ort.instance.attribute.input_select.enum.fast_in_deflection'))

    @fast_in_deflection.setter
    def fast_in_deflection(self, new_val:int):
        self._context.set('root.lu.ort.instance.attribute.input_select.enum.fast_in_deflection', int(new_val))

    @property
    def hi_res_in_deflection(self) -> int:
        return int(self._context.get('root.lu.ort.instance.attribute.input_select.enum.hi_res_in_deflection'))

    @hi_res_in_deflection.setter
    def hi_res_in_deflection(self, new_val:int):
        self._context.set('root.lu.ort.instance.attribute.input_select.enum.hi_res_in_deflection', int(new_val))

    @property
    def fast_in_user(self) -> int:
        return int(self._context.get('root.lu.ort.instance.attribute.input_select.enum.fast_in_user'))

    @fast_in_user.setter
    def fast_in_user(self, new_val:int):
        self._context.set('root.lu.ort.instance.attribute.input_select.enum.fast_in_user', int(new_val))

    @property
    def hi_res_in_user1(self) -> int:
        return int(self._context.get('root.lu.ort.instance.attribute.input_select.enum.hi_res_in_user1'))

    @hi_res_in_user1.setter
    def hi_res_in_user1(self, new_val:int):
        self._context.set('root.lu.ort.instance.attribute.input_select.enum.hi_res_in_user1', int(new_val))


class RootLuOrtInstanceAttributeInput_select(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ort.instance.attribute.input_select'
        self.enum = RootLuOrtInstanceAttributeInput_selectEnum(self._context)


class RootLuOrtInstanceAttributeFeedback_amplitude_position(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ort.instance.attribute.feedback_amplitude_position'


class RootLuOrtInstanceAttribute(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ort.instance.attribute'
        self.feedback_amplitude_position = RootLuOrtInstanceAttributeFeedback_amplitude_position(self._context)
        self.input_select = RootLuOrtInstanceAttributeInput_select(self._context)
        self.samples_per_period = RootLuOrtInstanceAttributeSamples_per_period(self._context)
        self.min_position = RootLuOrtInstanceAttributeMin_position(self._context)
        self.min_value = RootLuOrtInstanceAttributeMin_value(self._context)
        self.free_wave_output_state = RootLuOrtInstanceAttributeFree_wave_output_state(self._context)
        self.average_periods = RootLuOrtInstanceAttributeAverage_periods(self._context)
        self.free_wave_delay = RootLuOrtInstanceAttributeFree_wave_delay(self._context)
        self.amplitude_reduction = RootLuOrtInstanceAttributeAmplitude_reduction(self._context)
        self.excitation_amplitude = RootLuOrtInstanceAttributeExcitation_amplitude(self._context)
        self.baseline_window_begin = RootLuOrtInstanceAttributeBaseline_window_begin(self._context)
        self.cantilever_samples_per_period = RootLuOrtInstanceAttributeCantilever_samples_per_period(self._context)
        self.baseline_window_end = RootLuOrtInstanceAttributeBaseline_window_end(self._context)
        self.baseline_controller_state = RootLuOrtInstanceAttributeBaseline_controller_state(self._context)
        self.baseline_frequency = RootLuOrtInstanceAttributeBaseline_frequency(self._context)


class RootLuOrtInstanceTriggerApply_samples_values(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ort.instance.trigger.apply_samples_values'


class RootLuOrtInstanceTriggerApply_samples_per_period(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ort.instance.trigger.apply_samples_per_period'


class RootLuOrtInstanceTriggerTransfer_free_wave_data(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ort.instance.trigger.transfer_free_wave_data'


class RootLuOrtInstanceTriggerUpdate_free_wave(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ort.instance.trigger.update_free_wave'


class RootLuOrtInstanceTrigger(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ort.instance.trigger'
        self.update_free_wave = RootLuOrtInstanceTriggerUpdate_free_wave(self._context)
        self.transfer_free_wave_data = RootLuOrtInstanceTriggerTransfer_free_wave_data(self._context)
        self.apply_samples_per_period = RootLuOrtInstanceTriggerApply_samples_per_period(self._context)
        self.apply_samples_values = RootLuOrtInstanceTriggerApply_samples_values(self._context)


class RootLuOrtInstance(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ort.instance'
        self.trigger = RootLuOrtInstanceTrigger(self._context)
        self.attribute = RootLuOrtInstanceAttribute(self._context)
        self.busy = RootLuOrtInstanceBusy(self._context)


class RootLuOrt(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ort'
        self.instance = RootLuOrtInstance(self._context)


class RootLuMainboard_relaysInstanceTrigger(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.mainboard_relays.instance.trigger'


class RootLuMainboard_relaysInstanceAttributeSet_state_maskEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.mainboard_relays.instance.attribute.set_state_mask.enum'

    @property
    def hires_out_user3(self) -> int:
        return int(self._context.get('root.lu.mainboard_relays.instance.attribute.set_state_mask.enum.hires_out_user3'))

    @hires_out_user3.setter
    def hires_out_user3(self, new_val:int):
        self._context.set('root.lu.mainboard_relays.instance.attribute.set_state_mask.enum.hires_out_user3', int(new_val))

    @property
    def hi_res_in6(self) -> int:
        return int(self._context.get('root.lu.mainboard_relays.instance.attribute.set_state_mask.enum.hi_res_in6'))

    @hi_res_in6.setter
    def hi_res_in6(self, new_val:int):
        self._context.set('root.lu.mainboard_relays.instance.attribute.set_state_mask.enum.hi_res_in6', int(new_val))

    @property
    def all(self) -> int:
        return int(self._context.get('root.lu.mainboard_relays.instance.attribute.set_state_mask.enum.all'))

    @all.setter
    def all(self, new_val:int):
        self._context.set('root.lu.mainboard_relays.instance.attribute.set_state_mask.enum.all', int(new_val))

    @property
    def hires_out_user4(self) -> int:
        return int(self._context.get('root.lu.mainboard_relays.instance.attribute.set_state_mask.enum.hires_out_user4'))

    @hires_out_user4.setter
    def hires_out_user4(self, new_val:int):
        self._context.set('root.lu.mainboard_relays.instance.attribute.set_state_mask.enum.hires_out_user4', int(new_val))

    @property
    def fast_in_user(self) -> int:
        return int(self._context.get('root.lu.mainboard_relays.instance.attribute.set_state_mask.enum.fast_in_user'))

    @fast_in_user.setter
    def fast_in_user(self, new_val:int):
        self._context.set('root.lu.mainboard_relays.instance.attribute.set_state_mask.enum.fast_in_user', int(new_val))

    @property
    def hires_in_user3(self) -> int:
        return int(self._context.get('root.lu.mainboard_relays.instance.attribute.set_state_mask.enum.hires_in_user3'))

    @hires_in_user3.setter
    def hires_in_user3(self, new_val:int):
        self._context.set('root.lu.mainboard_relays.instance.attribute.set_state_mask.enum.hires_in_user3', int(new_val))

    @property
    def hires_in_user2(self) -> int:
        return int(self._context.get('root.lu.mainboard_relays.instance.attribute.set_state_mask.enum.hires_in_user2'))

    @hires_in_user2.setter
    def hires_in_user2(self, new_val:int):
        self._context.set('root.lu.mainboard_relays.instance.attribute.set_state_mask.enum.hires_in_user2', int(new_val))

    @property
    def hires_in_user4(self) -> int:
        return int(self._context.get('root.lu.mainboard_relays.instance.attribute.set_state_mask.enum.hires_in_user4'))

    @hires_in_user4.setter
    def hires_in_user4(self, new_val:int):
        self._context.set('root.lu.mainboard_relays.instance.attribute.set_state_mask.enum.hires_in_user4', int(new_val))

    @property
    def hires_out_user1(self) -> int:
        return int(self._context.get('root.lu.mainboard_relays.instance.attribute.set_state_mask.enum.hires_out_user1'))

    @hires_out_user1.setter
    def hires_out_user1(self, new_val:int):
        self._context.set('root.lu.mainboard_relays.instance.attribute.set_state_mask.enum.hires_out_user1', int(new_val))

    @property
    def hires_out_user2(self) -> int:
        return int(self._context.get('root.lu.mainboard_relays.instance.attribute.set_state_mask.enum.hires_out_user2'))

    @hires_out_user2.setter
    def hires_out_user2(self, new_val:int):
        self._context.set('root.lu.mainboard_relays.instance.attribute.set_state_mask.enum.hires_out_user2', int(new_val))

    @property
    def dummy0(self) -> int:
        return int(self._context.get('root.lu.mainboard_relays.instance.attribute.set_state_mask.enum.dummy0'))

    @dummy0.setter
    def dummy0(self, new_val:int):
        self._context.set('root.lu.mainboard_relays.instance.attribute.set_state_mask.enum.dummy0', int(new_val))

    @property
    def fast_out_user(self) -> int:
        return int(self._context.get('root.lu.mainboard_relays.instance.attribute.set_state_mask.enum.fast_out_user'))

    @fast_out_user.setter
    def fast_out_user(self, new_val:int):
        self._context.set('root.lu.mainboard_relays.instance.attribute.set_state_mask.enum.fast_out_user', int(new_val))

    @property
    def none(self) -> int:
        return int(self._context.get('root.lu.mainboard_relays.instance.attribute.set_state_mask.enum.none'))

    @none.setter
    def none(self, new_val:int):
        self._context.set('root.lu.mainboard_relays.instance.attribute.set_state_mask.enum.none', int(new_val))

    @property
    def hires_in_user1(self) -> int:
        return int(self._context.get('root.lu.mainboard_relays.instance.attribute.set_state_mask.enum.hires_in_user1'))

    @hires_in_user1.setter
    def hires_in_user1(self, new_val:int):
        self._context.set('root.lu.mainboard_relays.instance.attribute.set_state_mask.enum.hires_in_user1', int(new_val))


class RootLuMainboard_relaysInstanceAttributeSet_state_mask(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.mainboard_relays.instance.attribute.set_state_mask'
        self.enum = RootLuMainboard_relaysInstanceAttributeSet_state_maskEnum(self._context)


class RootLuMainboard_relaysInstanceAttribute(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.mainboard_relays.instance.attribute'
        self.set_state_mask = RootLuMainboard_relaysInstanceAttributeSet_state_mask(self._context)


class RootLuMainboard_relaysInstance(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.mainboard_relays.instance'
        self.attribute = RootLuMainboard_relaysInstanceAttribute(self._context)
        self.trigger = RootLuMainboard_relaysInstanceTrigger(self._context)


class RootLuMainboard_relays(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.mainboard_relays'
        self.instance = RootLuMainboard_relaysInstance(self._context)


class RootLuPosition_controlInstanceBusyIs_range_switching(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.position_control.instance.busy.is_range_switching'


class RootLuPosition_controlInstanceBusyIs_tip_moving(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.position_control.instance.busy.is_tip_moving'


class RootLuPosition_controlInstanceBusyIs_calibrating(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.position_control.instance.busy.is_calibrating'


class RootLuPosition_controlInstanceBusyIs_busy(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.position_control.instance.busy.is_busy'


class RootLuPosition_controlInstanceBusy(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.position_control.instance.busy'
        self.is_busy = RootLuPosition_controlInstanceBusyIs_busy(self._context)
        self.is_calibrating = RootLuPosition_controlInstanceBusyIs_calibrating(self._context)
        self.is_tip_moving = RootLuPosition_controlInstanceBusyIs_tip_moving(self._context)
        self.is_range_switching = RootLuPosition_controlInstanceBusyIs_range_switching(self._context)


class RootLuPosition_controlInstanceAttributeCurrent_pos_z(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.position_control.instance.attribute.current_pos_z'


class RootLuPosition_controlInstanceAttributeRamp_count(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.position_control.instance.attribute.ramp_count'


class RootLuPosition_controlInstanceAttributeCurrent_pos_x(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.position_control.instance.attribute.current_pos_x'


class RootLuPosition_controlInstanceAttributeCurrent_pos_y(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.position_control.instance.attribute.current_pos_y'


class RootLuPosition_controlInstanceAttributeAxis_scale_z(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.position_control.instance.attribute.axis_scale_z'


class RootLuPosition_controlInstanceAttributeScan_correction_x_rotation(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.position_control.instance.attribute.scan_correction_x_rotation'


class RootLuPosition_controlInstanceAttributePid_controller_settings_xEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.position_control.instance.attribute.pid_controller_settings_x.enum'

    @property
    def i_gain(self) -> int:
        return int(self._context.get('root.lu.position_control.instance.attribute.pid_controller_settings_x.enum.i_gain'))

    @i_gain.setter
    def i_gain(self, new_val:int):
        self._context.set('root.lu.position_control.instance.attribute.pid_controller_settings_x.enum.i_gain', int(new_val))

    @property
    def p_gain(self) -> int:
        return int(self._context.get('root.lu.position_control.instance.attribute.pid_controller_settings_x.enum.p_gain'))

    @p_gain.setter
    def p_gain(self, new_val:int):
        self._context.set('root.lu.position_control.instance.attribute.pid_controller_settings_x.enum.p_gain', int(new_val))

    @property
    def d_gain(self) -> int:
        return int(self._context.get('root.lu.position_control.instance.attribute.pid_controller_settings_x.enum.d_gain'))

    @d_gain.setter
    def d_gain(self, new_val:int):
        self._context.set('root.lu.position_control.instance.attribute.pid_controller_settings_x.enum.d_gain', int(new_val))


class RootLuPosition_controlInstanceAttributePid_controller_settings_x(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.position_control.instance.attribute.pid_controller_settings_x'
        self.enum = RootLuPosition_controlInstanceAttributePid_controller_settings_xEnum(self._context)


class RootLuPosition_controlInstanceAttributeIs_xy_closed_loop_possibleEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.position_control.instance.attribute.is_xy_closed_loop_possible.enum'

    @property
    def not_possible_no_sensor(self) -> int:
        return int(self._context.get('root.lu.position_control.instance.attribute.is_xy_closed_loop_possible.enum.not_possible_no_sensor'))

    @not_possible_no_sensor.setter
    def not_possible_no_sensor(self, new_val:int):
        self._context.set('root.lu.position_control.instance.attribute.is_xy_closed_loop_possible.enum.not_possible_no_sensor', int(new_val))

    @property
    def not_possible(self) -> int:
        return int(self._context.get('root.lu.position_control.instance.attribute.is_xy_closed_loop_possible.enum.not_possible'))

    @not_possible.setter
    def not_possible(self, new_val:int):
        self._context.set('root.lu.position_control.instance.attribute.is_xy_closed_loop_possible.enum.not_possible', int(new_val))

    @property
    def not_possible_no_scan_head(self) -> int:
        return int(self._context.get('root.lu.position_control.instance.attribute.is_xy_closed_loop_possible.enum.not_possible_no_scan_head'))

    @not_possible_no_scan_head.setter
    def not_possible_no_scan_head(self, new_val:int):
        self._context.set('root.lu.position_control.instance.attribute.is_xy_closed_loop_possible.enum.not_possible_no_scan_head', int(new_val))

    @property
    def not_possible_wrong_scan_axis_range(self) -> int:
        return int(self._context.get('root.lu.position_control.instance.attribute.is_xy_closed_loop_possible.enum.not_possible_wrong_scan_axis_range'))

    @not_possible_wrong_scan_axis_range.setter
    def not_possible_wrong_scan_axis_range(self, new_val:int):
        self._context.set('root.lu.position_control.instance.attribute.is_xy_closed_loop_possible.enum.not_possible_wrong_scan_axis_range', int(new_val))

    @property
    def possible(self) -> int:
        return int(self._context.get('root.lu.position_control.instance.attribute.is_xy_closed_loop_possible.enum.possible'))

    @possible.setter
    def possible(self, new_val:int):
        self._context.set('root.lu.position_control.instance.attribute.is_xy_closed_loop_possible.enum.possible', int(new_val))


class RootLuPosition_controlInstanceAttributeIs_xy_closed_loop_possible(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.position_control.instance.attribute.is_xy_closed_loop_possible'
        self.enum = RootLuPosition_controlInstanceAttributeIs_xy_closed_loop_possibleEnum(self._context)


class RootLuPosition_controlInstanceAttributeTarget_move_pos_x(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.position_control.instance.attribute.target_move_pos_x'


class RootLuPosition_controlInstanceAttributeAxis_scale_xylv(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.position_control.instance.attribute.axis_scale_xylv'


class RootLuPosition_controlInstanceAttributeCurrent_scan_axis_range_selectEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.position_control.instance.attribute.current_scan_axis_range_select.enum'

    @property
    def off(self) -> int:
        return int(self._context.get('root.lu.position_control.instance.attribute.current_scan_axis_range_select.enum.off'))

    @off.setter
    def off(self, new_val:int):
        self._context.set('root.lu.position_control.instance.attribute.current_scan_axis_range_select.enum.off', int(new_val))

    @property
    def full_range(self) -> int:
        return int(self._context.get('root.lu.position_control.instance.attribute.current_scan_axis_range_select.enum.full_range'))

    @full_range.setter
    def full_range(self, new_val:int):
        self._context.set('root.lu.position_control.instance.attribute.current_scan_axis_range_select.enum.full_range', int(new_val))

    @property
    def reduced_range(self) -> int:
        return int(self._context.get('root.lu.position_control.instance.attribute.current_scan_axis_range_select.enum.reduced_range'))

    @reduced_range.setter
    def reduced_range(self, new_val:int):
        self._context.set('root.lu.position_control.instance.attribute.current_scan_axis_range_select.enum.reduced_range', int(new_val))


class RootLuPosition_controlInstanceAttributeCurrent_scan_axis_range_select(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.position_control.instance.attribute.current_scan_axis_range_select'
        self.enum = RootLuPosition_controlInstanceAttributeCurrent_scan_axis_range_selectEnum(self._context)


class RootLuPosition_controlInstanceAttributeEnable_xy_closed_loop(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.position_control.instance.attribute.enable_xy_closed_loop'


class RootLuPosition_controlInstanceAttributeLast_move_stop_eventEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.position_control.instance.attribute.last_move_stop_event.enum'

    @property
    def out_of_bound_lower_limit(self) -> int:
        return int(self._context.get('root.lu.position_control.instance.attribute.last_move_stop_event.enum.out_of_bound_lower_limit'))

    @out_of_bound_lower_limit.setter
    def out_of_bound_lower_limit(self, new_val:int):
        self._context.set('root.lu.position_control.instance.attribute.last_move_stop_event.enum.out_of_bound_lower_limit', int(new_val))

    @property
    def out_of_data(self) -> int:
        return int(self._context.get('root.lu.position_control.instance.attribute.last_move_stop_event.enum.out_of_data'))

    @out_of_data.setter
    def out_of_data(self, new_val:int):
        self._context.set('root.lu.position_control.instance.attribute.last_move_stop_event.enum.out_of_data', int(new_val))

    @property
    def out_of_bound_upper_limit(self) -> int:
        return int(self._context.get('root.lu.position_control.instance.attribute.last_move_stop_event.enum.out_of_bound_upper_limit'))

    @out_of_bound_upper_limit.setter
    def out_of_bound_upper_limit(self, new_val:int):
        self._context.set('root.lu.position_control.instance.attribute.last_move_stop_event.enum.out_of_bound_upper_limit', int(new_val))

    @property
    def finish(self) -> int:
        return int(self._context.get('root.lu.position_control.instance.attribute.last_move_stop_event.enum.finish'))

    @finish.setter
    def finish(self, new_val:int):
        self._context.set('root.lu.position_control.instance.attribute.last_move_stop_event.enum.finish', int(new_val))

    @property
    def out_of_bound_min(self) -> int:
        return int(self._context.get('root.lu.position_control.instance.attribute.last_move_stop_event.enum.out_of_bound_min'))

    @out_of_bound_min.setter
    def out_of_bound_min(self, new_val:int):
        self._context.set('root.lu.position_control.instance.attribute.last_move_stop_event.enum.out_of_bound_min', int(new_val))

    @property
    def out_of_bound_max(self) -> int:
        return int(self._context.get('root.lu.position_control.instance.attribute.last_move_stop_event.enum.out_of_bound_max'))

    @out_of_bound_max.setter
    def out_of_bound_max(self, new_val:int):
        self._context.set('root.lu.position_control.instance.attribute.last_move_stop_event.enum.out_of_bound_max', int(new_val))

    @property
    def setpoint_reached(self) -> int:
        return int(self._context.get('root.lu.position_control.instance.attribute.last_move_stop_event.enum.setpoint_reached'))

    @setpoint_reached.setter
    def setpoint_reached(self, new_val:int):
        self._context.set('root.lu.position_control.instance.attribute.last_move_stop_event.enum.setpoint_reached', int(new_val))

    @property
    def position_reached(self) -> int:
        return int(self._context.get('root.lu.position_control.instance.attribute.last_move_stop_event.enum.position_reached'))

    @position_reached.setter
    def position_reached(self, new_val:int):
        self._context.set('root.lu.position_control.instance.attribute.last_move_stop_event.enum.position_reached', int(new_val))

    @property
    def user_abort(self) -> int:
        return int(self._context.get('root.lu.position_control.instance.attribute.last_move_stop_event.enum.user_abort'))

    @user_abort.setter
    def user_abort(self, new_val:int):
        self._context.set('root.lu.position_control.instance.attribute.last_move_stop_event.enum.user_abort', int(new_val))

    @property
    def timer_expired(self) -> int:
        return int(self._context.get('root.lu.position_control.instance.attribute.last_move_stop_event.enum.timer_expired'))

    @timer_expired.setter
    def timer_expired(self, new_val:int):
        self._context.set('root.lu.position_control.instance.attribute.last_move_stop_event.enum.timer_expired', int(new_val))


class RootLuPosition_controlInstanceAttributeLast_move_stop_event(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.position_control.instance.attribute.last_move_stop_event'
        self.enum = RootLuPosition_controlInstanceAttributeLast_move_stop_eventEnum(self._context)


class RootLuPosition_controlInstanceAttributeTarget_move_pos_y(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.position_control.instance.attribute.target_move_pos_y'


class RootLuPosition_controlInstanceAttributeRamp_time(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.position_control.instance.attribute.ramp_time'


class RootLuPosition_controlInstanceAttributeTarget_move_pos_z(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.position_control.instance.attribute.target_move_pos_z'


class RootLuPosition_controlInstanceAttributeTarget_moving_speed(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.position_control.instance.attribute.target_moving_speed'


class RootLuPosition_controlInstanceAttributeTarget_moving_time(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.position_control.instance.attribute.target_moving_time'


class RootLuPosition_controlInstanceAttributeLast_scan_axis_range_select_switch_resultEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.position_control.instance.attribute.last_scan_axis_range_select_switch_result.enum'

    @property
    def off(self) -> int:
        return int(self._context.get('root.lu.position_control.instance.attribute.last_scan_axis_range_select_switch_result.enum.off'))

    @off.setter
    def off(self, new_val:int):
        self._context.set('root.lu.position_control.instance.attribute.last_scan_axis_range_select_switch_result.enum.off', int(new_val))

    @property
    def full_range(self) -> int:
        return int(self._context.get('root.lu.position_control.instance.attribute.last_scan_axis_range_select_switch_result.enum.full_range'))

    @full_range.setter
    def full_range(self, new_val:int):
        self._context.set('root.lu.position_control.instance.attribute.last_scan_axis_range_select_switch_result.enum.full_range', int(new_val))

    @property
    def reduced_range(self) -> int:
        return int(self._context.get('root.lu.position_control.instance.attribute.last_scan_axis_range_select_switch_result.enum.reduced_range'))

    @reduced_range.setter
    def reduced_range(self, new_val:int):
        self._context.set('root.lu.position_control.instance.attribute.last_scan_axis_range_select_switch_result.enum.reduced_range', int(new_val))


class RootLuPosition_controlInstanceAttributeLast_scan_axis_range_select_switch_result(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.position_control.instance.attribute.last_scan_axis_range_select_switch_result'
        self.enum = RootLuPosition_controlInstanceAttributeLast_scan_axis_range_select_switch_resultEnum(self._context)


class RootLuPosition_controlInstanceAttributeTarget_scan_axis_range_selectEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.position_control.instance.attribute.target_scan_axis_range_select.enum'

    @property
    def off(self) -> int:
        return int(self._context.get('root.lu.position_control.instance.attribute.target_scan_axis_range_select.enum.off'))

    @off.setter
    def off(self, new_val:int):
        self._context.set('root.lu.position_control.instance.attribute.target_scan_axis_range_select.enum.off', int(new_val))

    @property
    def full_range(self) -> int:
        return int(self._context.get('root.lu.position_control.instance.attribute.target_scan_axis_range_select.enum.full_range'))

    @full_range.setter
    def full_range(self, new_val:int):
        self._context.set('root.lu.position_control.instance.attribute.target_scan_axis_range_select.enum.full_range', int(new_val))

    @property
    def reduced_range(self) -> int:
        return int(self._context.get('root.lu.position_control.instance.attribute.target_scan_axis_range_select.enum.reduced_range'))

    @reduced_range.setter
    def reduced_range(self, new_val:int):
        self._context.set('root.lu.position_control.instance.attribute.target_scan_axis_range_select.enum.reduced_range', int(new_val))


class RootLuPosition_controlInstanceAttributeTarget_scan_axis_range_select(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.position_control.instance.attribute.target_scan_axis_range_select'
        self.enum = RootLuPosition_controlInstanceAttributeTarget_scan_axis_range_selectEnum(self._context)


class RootLuPosition_controlInstanceAttributePid_controller_settings_yEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.position_control.instance.attribute.pid_controller_settings_y.enum'

    @property
    def i_gain(self) -> int:
        return int(self._context.get('root.lu.position_control.instance.attribute.pid_controller_settings_y.enum.i_gain'))

    @i_gain.setter
    def i_gain(self, new_val:int):
        self._context.set('root.lu.position_control.instance.attribute.pid_controller_settings_y.enum.i_gain', int(new_val))

    @property
    def p_gain(self) -> int:
        return int(self._context.get('root.lu.position_control.instance.attribute.pid_controller_settings_y.enum.p_gain'))

    @p_gain.setter
    def p_gain(self, new_val:int):
        self._context.set('root.lu.position_control.instance.attribute.pid_controller_settings_y.enum.p_gain', int(new_val))

    @property
    def d_gain(self) -> int:
        return int(self._context.get('root.lu.position_control.instance.attribute.pid_controller_settings_y.enum.d_gain'))

    @d_gain.setter
    def d_gain(self, new_val:int):
        self._context.set('root.lu.position_control.instance.attribute.pid_controller_settings_y.enum.d_gain', int(new_val))


class RootLuPosition_controlInstanceAttributePid_controller_settings_y(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.position_control.instance.attribute.pid_controller_settings_y'
        self.enum = RootLuPosition_controlInstanceAttributePid_controller_settings_yEnum(self._context)


class RootLuPosition_controlInstanceAttributeXy_closed_loop_speed_keep_pos(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.position_control.instance.attribute.xy_closed_loop_speed_keep_pos'


class RootLuPosition_controlInstanceAttributeXy_closed_loop_speed_moving(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.position_control.instance.attribute.xy_closed_loop_speed_moving'


class RootLuPosition_controlInstanceAttributeXy_closed_loop_speed_modeEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.position_control.instance.attribute.xy_closed_loop_speed_mode.enum'

    @property
    def keep_position(self) -> int:
        return int(self._context.get('root.lu.position_control.instance.attribute.xy_closed_loop_speed_mode.enum.keep_position'))

    @keep_position.setter
    def keep_position(self, new_val:int):
        self._context.set('root.lu.position_control.instance.attribute.xy_closed_loop_speed_mode.enum.keep_position', int(new_val))

    @property
    def moving(self) -> int:
        return int(self._context.get('root.lu.position_control.instance.attribute.xy_closed_loop_speed_mode.enum.moving'))

    @moving.setter
    def moving(self, new_val:int):
        self._context.set('root.lu.position_control.instance.attribute.xy_closed_loop_speed_mode.enum.moving', int(new_val))


class RootLuPosition_controlInstanceAttributeXy_closed_loop_speed_mode(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.position_control.instance.attribute.xy_closed_loop_speed_mode'
        self.enum = RootLuPosition_controlInstanceAttributeXy_closed_loop_speed_modeEnum(self._context)


class RootLuPosition_controlInstanceAttributeAxis_scale_xy(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.position_control.instance.attribute.axis_scale_xy'


class RootLuPosition_controlInstanceAttributeScan_correction_y_rotation(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.position_control.instance.attribute.scan_correction_y_rotation'


class RootLuPosition_controlInstanceAttributeAxis_scale_zlv(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.position_control.instance.attribute.axis_scale_zlv'


class RootLuPosition_controlInstanceAttribute(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.position_control.instance.attribute'
        self.axis_scale_zlv = RootLuPosition_controlInstanceAttributeAxis_scale_zlv(self._context)
        self.scan_correction_y_rotation = RootLuPosition_controlInstanceAttributeScan_correction_y_rotation(self._context)
        self.axis_scale_xy = RootLuPosition_controlInstanceAttributeAxis_scale_xy(self._context)
        self.xy_closed_loop_speed_mode = RootLuPosition_controlInstanceAttributeXy_closed_loop_speed_mode(self._context)
        self.xy_closed_loop_speed_moving = RootLuPosition_controlInstanceAttributeXy_closed_loop_speed_moving(self._context)
        self.xy_closed_loop_speed_keep_pos = RootLuPosition_controlInstanceAttributeXy_closed_loop_speed_keep_pos(self._context)
        self.pid_controller_settings_y = RootLuPosition_controlInstanceAttributePid_controller_settings_y(self._context)
        self.target_scan_axis_range_select = RootLuPosition_controlInstanceAttributeTarget_scan_axis_range_select(self._context)
        self.last_scan_axis_range_select_switch_result = RootLuPosition_controlInstanceAttributeLast_scan_axis_range_select_switch_result(self._context)
        self.target_moving_time = RootLuPosition_controlInstanceAttributeTarget_moving_time(self._context)
        self.target_moving_speed = RootLuPosition_controlInstanceAttributeTarget_moving_speed(self._context)
        self.target_move_pos_z = RootLuPosition_controlInstanceAttributeTarget_move_pos_z(self._context)
        self.ramp_time = RootLuPosition_controlInstanceAttributeRamp_time(self._context)
        self.target_move_pos_y = RootLuPosition_controlInstanceAttributeTarget_move_pos_y(self._context)
        self.last_move_stop_event = RootLuPosition_controlInstanceAttributeLast_move_stop_event(self._context)
        self.enable_xy_closed_loop = RootLuPosition_controlInstanceAttributeEnable_xy_closed_loop(self._context)
        self.current_scan_axis_range_select = RootLuPosition_controlInstanceAttributeCurrent_scan_axis_range_select(self._context)
        self.axis_scale_xylv = RootLuPosition_controlInstanceAttributeAxis_scale_xylv(self._context)
        self.target_move_pos_x = RootLuPosition_controlInstanceAttributeTarget_move_pos_x(self._context)
        self.is_xy_closed_loop_possible = RootLuPosition_controlInstanceAttributeIs_xy_closed_loop_possible(self._context)
        self.pid_controller_settings_x = RootLuPosition_controlInstanceAttributePid_controller_settings_x(self._context)
        self.scan_correction_x_rotation = RootLuPosition_controlInstanceAttributeScan_correction_x_rotation(self._context)
        self.axis_scale_z = RootLuPosition_controlInstanceAttributeAxis_scale_z(self._context)
        self.current_pos_y = RootLuPosition_controlInstanceAttributeCurrent_pos_y(self._context)
        self.current_pos_x = RootLuPosition_controlInstanceAttributeCurrent_pos_x(self._context)
        self.ramp_count = RootLuPosition_controlInstanceAttributeRamp_count(self._context)
        self.current_pos_z = RootLuPosition_controlInstanceAttributeCurrent_pos_z(self._context)


class RootLuPosition_controlInstanceTriggerMove_to_target_fix_time_xy(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.position_control.instance.trigger.move_to_target_fix_time_xy'


class RootLuPosition_controlInstanceTriggerStart_move_to_target_fix_speed_xy(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.position_control.instance.trigger.start_move_to_target_fix_speed_xy'


class RootLuPosition_controlInstanceTriggerStart_switch_to_target_scan_axis_range_select(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.position_control.instance.trigger.start_switch_to_target_scan_axis_range_select'


class RootLuPosition_controlInstanceTriggerStart_move_to_target_fix_time_xyz(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.position_control.instance.trigger.start_move_to_target_fix_time_xyz'


class RootLuPosition_controlInstanceTriggerStart_move_to_target_fix_time_xy(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.position_control.instance.trigger.start_move_to_target_fix_time_xy'


class RootLuPosition_controlInstanceTriggerSwitch_to_target_scan_axis_range_select(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.position_control.instance.trigger.switch_to_target_scan_axis_range_select'


class RootLuPosition_controlInstanceTriggerStart_move_to_target_fix_speed_xyz(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.position_control.instance.trigger.start_move_to_target_fix_speed_xyz'


class RootLuPosition_controlInstanceTriggerMove_to_target_fix_speed_xy(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.position_control.instance.trigger.move_to_target_fix_speed_xy'


class RootLuPosition_controlInstanceTriggerStart_calib_xy_sensor_zero_to_center_of_ramp(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.position_control.instance.trigger.start_calib_xy_sensor_zero_to_center_of_ramp'


class RootLuPosition_controlInstanceTriggerMove_to_target_fix_speed_xyz(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.position_control.instance.trigger.move_to_target_fix_speed_xyz'


class RootLuPosition_controlInstanceTriggerCalib_xy_sensor_zero_to_center_of_ramp(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.position_control.instance.trigger.calib_xy_sensor_zero_to_center_of_ramp'


class RootLuPosition_controlInstanceTriggerMove_to_target_fix_time_xyz(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.position_control.instance.trigger.move_to_target_fix_time_xyz'


class RootLuPosition_controlInstanceTrigger(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.position_control.instance.trigger'
        self.move_to_target_fix_time_xyz = RootLuPosition_controlInstanceTriggerMove_to_target_fix_time_xyz(self._context)
        self.calib_xy_sensor_zero_to_center_of_ramp = RootLuPosition_controlInstanceTriggerCalib_xy_sensor_zero_to_center_of_ramp(self._context)
        self.move_to_target_fix_speed_xyz = RootLuPosition_controlInstanceTriggerMove_to_target_fix_speed_xyz(self._context)
        self.start_calib_xy_sensor_zero_to_center_of_ramp = RootLuPosition_controlInstanceTriggerStart_calib_xy_sensor_zero_to_center_of_ramp(self._context)
        self.move_to_target_fix_speed_xy = RootLuPosition_controlInstanceTriggerMove_to_target_fix_speed_xy(self._context)
        self.start_move_to_target_fix_speed_xyz = RootLuPosition_controlInstanceTriggerStart_move_to_target_fix_speed_xyz(self._context)
        self.switch_to_target_scan_axis_range_select = RootLuPosition_controlInstanceTriggerSwitch_to_target_scan_axis_range_select(self._context)
        self.start_move_to_target_fix_time_xy = RootLuPosition_controlInstanceTriggerStart_move_to_target_fix_time_xy(self._context)
        self.start_move_to_target_fix_time_xyz = RootLuPosition_controlInstanceTriggerStart_move_to_target_fix_time_xyz(self._context)
        self.start_switch_to_target_scan_axis_range_select = RootLuPosition_controlInstanceTriggerStart_switch_to_target_scan_axis_range_select(self._context)
        self.start_move_to_target_fix_speed_xy = RootLuPosition_controlInstanceTriggerStart_move_to_target_fix_speed_xy(self._context)
        self.move_to_target_fix_time_xy = RootLuPosition_controlInstanceTriggerMove_to_target_fix_time_xy(self._context)


class RootLuPosition_controlInstance(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.position_control.instance'
        self.trigger = RootLuPosition_controlInstanceTrigger(self._context)
        self.attribute = RootLuPosition_controlInstanceAttribute(self._context)
        self.busy = RootLuPosition_controlInstanceBusy(self._context)


class RootLuPosition_control(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.position_control'
        self.instance = RootLuPosition_controlInstance(self._context)


class RootLuApproachInstanceTriggerStart_approach_steps(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.approach.instance.trigger.start_approach_steps'


class RootLuApproachInstanceTriggerStart_pre_approach(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.approach.instance.trigger.start_pre_approach'


class RootLuApproachInstanceTriggerUser_abort(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.approach.instance.trigger.user_abort'


class RootLuApproachInstanceTriggerStart_adjust_tip_pos(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.approach.instance.trigger.start_adjust_tip_pos'


class RootLuApproachInstanceTriggerStart_approach_motor(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.approach.instance.trigger.start_approach_motor'


class RootLuApproachInstanceTriggerStart_approach_afm(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.approach.instance.trigger.start_approach_afm'


class RootLuApproachInstanceTriggerUser_done(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.approach.instance.trigger.user_done'


class RootLuApproachInstanceTrigger(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.approach.instance.trigger'
        self.user_done = RootLuApproachInstanceTriggerUser_done(self._context)
        self.start_approach_afm = RootLuApproachInstanceTriggerStart_approach_afm(self._context)
        self.start_approach_motor = RootLuApproachInstanceTriggerStart_approach_motor(self._context)
        self.start_adjust_tip_pos = RootLuApproachInstanceTriggerStart_adjust_tip_pos(self._context)
        self.user_abort = RootLuApproachInstanceTriggerUser_abort(self._context)
        self.start_pre_approach = RootLuApproachInstanceTriggerStart_pre_approach(self._context)
        self.start_approach_steps = RootLuApproachInstanceTriggerStart_approach_steps(self._context)


class RootLuApproachInstanceAttributeApproach_speed(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.approach.instance.attribute.approach_speed'


class RootLuApproachInstanceAttributeApproach_statusEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.approach.instance.attribute.approach_status.enum'

    @property
    def limit_failed(self) -> int:
        return int(self._context.get('root.lu.approach.instance.attribute.approach_status.enum.limit_failed'))

    @limit_failed.setter
    def limit_failed(self, new_val:int):
        self._context.set('root.lu.approach.instance.attribute.approach_status.enum.limit_failed', int(new_val))

    @property
    def calibration_failed(self) -> int:
        return int(self._context.get('root.lu.approach.instance.attribute.approach_status.enum.calibration_failed'))

    @calibration_failed.setter
    def calibration_failed(self, new_val:int):
        self._context.set('root.lu.approach.instance.attribute.approach_status.enum.calibration_failed', int(new_val))

    @property
    def adjusting_tip_pos(self) -> int:
        return int(self._context.get('root.lu.approach.instance.attribute.approach_status.enum.adjusting_tip_pos'))

    @adjusting_tip_pos.setter
    def adjusting_tip_pos(self, new_val:int):
        self._context.set('root.lu.approach.instance.attribute.approach_status.enum.adjusting_tip_pos', int(new_val))

    @property
    def home_position_reached(self) -> int:
        return int(self._context.get('root.lu.approach.instance.attribute.approach_status.enum.home_position_reached'))

    @home_position_reached.setter
    def home_position_reached(self, new_val:int):
        self._context.set('root.lu.approach.instance.attribute.approach_status.enum.home_position_reached', int(new_val))

    @property
    def approach_aborted(self) -> int:
        return int(self._context.get('root.lu.approach.instance.attribute.approach_status.enum.approach_aborted'))

    @approach_aborted.setter
    def approach_aborted(self, new_val:int):
        self._context.set('root.lu.approach.instance.attribute.approach_status.enum.approach_aborted', int(new_val))

    @property
    def approaching(self) -> int:
        return int(self._context.get('root.lu.approach.instance.attribute.approach_status.enum.approaching'))

    @approaching.setter
    def approaching(self, new_val:int):
        self._context.set('root.lu.approach.instance.attribute.approach_status.enum.approaching', int(new_val))

    @property
    def move_toward(self) -> int:
        return int(self._context.get('root.lu.approach.instance.attribute.approach_status.enum.move_toward'))

    @move_toward.setter
    def move_toward(self, new_val:int):
        self._context.set('root.lu.approach.instance.attribute.approach_status.enum.move_toward', int(new_val))

    @property
    def move_away(self) -> int:
        return int(self._context.get('root.lu.approach.instance.attribute.approach_status.enum.move_away'))

    @move_away.setter
    def move_away(self, new_val:int):
        self._context.set('root.lu.approach.instance.attribute.approach_status.enum.move_away', int(new_val))

    @property
    def idle(self) -> int:
        return int(self._context.get('root.lu.approach.instance.attribute.approach_status.enum.idle'))

    @idle.setter
    def idle(self, new_val:int):
        self._context.set('root.lu.approach.instance.attribute.approach_status.enum.idle', int(new_val))

    @property
    def max_out(self) -> int:
        return int(self._context.get('root.lu.approach.instance.attribute.approach_status.enum.max_out'))

    @max_out.setter
    def max_out(self, new_val:int):
        self._context.set('root.lu.approach.instance.attribute.approach_status.enum.max_out', int(new_val))

    @property
    def cancel_dialog(self) -> int:
        return int(self._context.get('root.lu.approach.instance.attribute.approach_status.enum.cancel_dialog'))

    @cancel_dialog.setter
    def cancel_dialog(self, new_val:int):
        self._context.set('root.lu.approach.instance.attribute.approach_status.enum.cancel_dialog', int(new_val))

    @property
    def user_abort(self) -> int:
        return int(self._context.get('root.lu.approach.instance.attribute.approach_status.enum.user_abort'))

    @user_abort.setter
    def user_abort(self, new_val:int):
        self._context.set('root.lu.approach.instance.attribute.approach_status.enum.user_abort', int(new_val))

    @property
    def initializing(self) -> int:
        return int(self._context.get('root.lu.approach.instance.attribute.approach_status.enum.initializing'))

    @initializing.setter
    def initializing(self, new_val:int):
        self._context.set('root.lu.approach.instance.attribute.approach_status.enum.initializing', int(new_val))

    @property
    def process_dialog(self) -> int:
        return int(self._context.get('root.lu.approach.instance.attribute.approach_status.enum.process_dialog'))

    @process_dialog.setter
    def process_dialog(self, new_val:int):
        self._context.set('root.lu.approach.instance.attribute.approach_status.enum.process_dialog', int(new_val))

    @property
    def sensor_failed(self) -> int:
        return int(self._context.get('root.lu.approach.instance.attribute.approach_status.enum.sensor_failed'))

    @sensor_failed.setter
    def sensor_failed(self, new_val:int):
        self._context.set('root.lu.approach.instance.attribute.approach_status.enum.sensor_failed', int(new_val))

    @property
    def timeout(self) -> int:
        return int(self._context.get('root.lu.approach.instance.attribute.approach_status.enum.timeout'))

    @timeout.setter
    def timeout(self, new_val:int):
        self._context.set('root.lu.approach.instance.attribute.approach_status.enum.timeout', int(new_val))

    @property
    def approach_done(self) -> int:
        return int(self._context.get('root.lu.approach.instance.attribute.approach_status.enum.approach_done'))

    @approach_done.setter
    def approach_done(self, new_val:int):
        self._context.set('root.lu.approach.instance.attribute.approach_status.enum.approach_done', int(new_val))

    @property
    def move_to_home_position(self) -> int:
        return int(self._context.get('root.lu.approach.instance.attribute.approach_status.enum.move_to_home_position'))

    @move_to_home_position.setter
    def move_to_home_position(self, new_val:int):
        self._context.set('root.lu.approach.instance.attribute.approach_status.enum.move_to_home_position', int(new_val))

    @property
    def init_done(self) -> int:
        return int(self._context.get('root.lu.approach.instance.attribute.approach_status.enum.init_done'))

    @init_done.setter
    def init_done(self, new_val:int):
        self._context.set('root.lu.approach.instance.attribute.approach_status.enum.init_done', int(new_val))


class RootLuApproachInstanceAttributeApproach_status(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.approach.instance.attribute.approach_status'
        self.enum = RootLuApproachInstanceAttributeApproach_statusEnum(self._context)


class RootLuApproachInstanceAttributeStepper_directionEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.approach.instance.attribute.stepper_direction.enum'

    @property
    def backward(self) -> int:
        return int(self._context.get('root.lu.approach.instance.attribute.stepper_direction.enum.backward'))

    @backward.setter
    def backward(self, new_val:int):
        self._context.set('root.lu.approach.instance.attribute.stepper_direction.enum.backward', int(new_val))

    @property
    def forward(self) -> int:
        return int(self._context.get('root.lu.approach.instance.attribute.stepper_direction.enum.forward'))

    @forward.setter
    def forward(self, new_val:int):
        self._context.set('root.lu.approach.instance.attribute.stepper_direction.enum.forward', int(new_val))


class RootLuApproachInstanceAttributeStepper_direction(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.approach.instance.attribute.stepper_direction'
        self.enum = RootLuApproachInstanceAttributeStepper_directionEnum(self._context)


class RootLuApproachInstanceAttributeCurrent_z_stage_pos(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.approach.instance.attribute.current_z_stage_pos'


class RootLuApproachInstanceAttributeMotor_sourceEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.approach.instance.attribute.motor_source.enum'

    @property
    def internal(self) -> int:
        return int(self._context.get('root.lu.approach.instance.attribute.motor_source.enum.internal'))

    @internal.setter
    def internal(self, new_val:int):
        self._context.set('root.lu.approach.instance.attribute.motor_source.enum.internal', int(new_val))

    @property
    def external(self) -> int:
        return int(self._context.get('root.lu.approach.instance.attribute.motor_source.enum.external'))

    @external.setter
    def external(self, new_val:int):
        self._context.set('root.lu.approach.instance.attribute.motor_source.enum.external', int(new_val))


class RootLuApproachInstanceAttributeMotor_source(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.approach.instance.attribute.motor_source'
        self.enum = RootLuApproachInstanceAttributeMotor_sourceEnum(self._context)


class RootLuApproachInstanceAttributeRelease_tip(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.approach.instance.attribute.release_tip'


class RootLuApproachInstanceAttributeApproach_pos_error(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.approach.instance.attribute.approach_pos_error'


class RootLuApproachInstanceAttributeStep_by_step_coarse_step_size_percentage(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.approach.instance.attribute.step_by_step_coarse_step_size_percentage'


class RootLuApproachInstanceAttributeStep_by_step_fine_step_size_percentage(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.approach.instance.attribute.step_by_step_fine_step_size_percentage'


class RootLuApproachInstanceAttributeStep_by_step_modeEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.approach.instance.attribute.step_by_step_mode.enum'

    @property
    def position_controlled(self) -> int:
        return int(self._context.get('root.lu.approach.instance.attribute.step_by_step_mode.enum.position_controlled'))

    @position_controlled.setter
    def position_controlled(self, new_val:int):
        self._context.set('root.lu.approach.instance.attribute.step_by_step_mode.enum.position_controlled', int(new_val))

    @property
    def tip_position_ignored(self) -> int:
        return int(self._context.get('root.lu.approach.instance.attribute.step_by_step_mode.enum.tip_position_ignored'))

    @tip_position_ignored.setter
    def tip_position_ignored(self, new_val:int):
        self._context.set('root.lu.approach.instance.attribute.step_by_step_mode.enum.tip_position_ignored', int(new_val))

    @property
    def not_controlled(self) -> int:
        return int(self._context.get('root.lu.approach.instance.attribute.step_by_step_mode.enum.not_controlled'))

    @not_controlled.setter
    def not_controlled(self, new_val:int):
        self._context.set('root.lu.approach.instance.attribute.step_by_step_mode.enum.not_controlled', int(new_val))


class RootLuApproachInstanceAttributeStep_by_step_mode(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.approach.instance.attribute.step_by_step_mode'
        self.enum = RootLuApproachInstanceAttributeStep_by_step_modeEnum(self._context)


class RootLuApproachInstanceAttributeApproach_steps(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.approach.instance.attribute.approach_steps'


class RootLuApproachInstanceAttributeWithdraw_steps(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.approach.instance.attribute.withdraw_steps'


class RootLuApproachInstanceAttributeEnable_pre_approach_xycl_calibration(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.approach.instance.attribute.enable_pre_approach_xycl_calibration'


class RootLuApproachInstanceAttributeStep_period(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.approach.instance.attribute.step_period'


class RootLuApproachInstanceAttributeStep_by_step_time(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.approach.instance.attribute.step_by_step_time'


class RootLuApproachInstanceAttributeApproach_pos(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.approach.instance.attribute.approach_pos'


class RootLuApproachInstanceAttributeStep_by_step_slope(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.approach.instance.attribute.step_by_step_slope'


class RootLuApproachInstanceAttributeRetract_tip(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.approach.instance.attribute.retract_tip'


class RootLuApproachInstanceAttributeAfm_approach_modeEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.approach.instance.attribute.afm_approach_mode.enum'

    @property
    def step_by_step(self) -> int:
        return int(self._context.get('root.lu.approach.instance.attribute.afm_approach_mode.enum.step_by_step'))

    @step_by_step.setter
    def step_by_step(self, new_val:int):
        self._context.set('root.lu.approach.instance.attribute.afm_approach_mode.enum.step_by_step', int(new_val))

    @property
    def continuous(self) -> int:
        return int(self._context.get('root.lu.approach.instance.attribute.afm_approach_mode.enum.continuous'))

    @continuous.setter
    def continuous(self, new_val:int):
        self._context.set('root.lu.approach.instance.attribute.afm_approach_mode.enum.continuous', int(new_val))


class RootLuApproachInstanceAttributeAfm_approach_mode(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.approach.instance.attribute.afm_approach_mode'
        self.enum = RootLuApproachInstanceAttributeAfm_approach_modeEnum(self._context)


class RootLuApproachInstanceAttributeApproach_resultEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.approach.instance.attribute.approach_result.enum'

    @property
    def end_of_travel(self) -> int:
        return int(self._context.get('root.lu.approach.instance.attribute.approach_result.enum.end_of_travel'))

    @end_of_travel.setter
    def end_of_travel(self, new_val:int):
        self._context.set('root.lu.approach.instance.attribute.approach_result.enum.end_of_travel', int(new_val))

    @property
    def sensor_error(self) -> int:
        return int(self._context.get('root.lu.approach.instance.attribute.approach_result.enum.sensor_error'))

    @sensor_error.setter
    def sensor_error(self, new_val:int):
        self._context.set('root.lu.approach.instance.attribute.approach_result.enum.sensor_error', int(new_val))

    @property
    def user_abort(self) -> int:
        return int(self._context.get('root.lu.approach.instance.attribute.approach_result.enum.user_abort'))

    @user_abort.setter
    def user_abort(self, new_val:int):
        self._context.set('root.lu.approach.instance.attribute.approach_result.enum.user_abort', int(new_val))

    @property
    def tip_pos_adjust_failed(self) -> int:
        return int(self._context.get('root.lu.approach.instance.attribute.approach_result.enum.tip_pos_adjust_failed'))

    @tip_pos_adjust_failed.setter
    def tip_pos_adjust_failed(self, new_val:int):
        self._context.set('root.lu.approach.instance.attribute.approach_result.enum.tip_pos_adjust_failed', int(new_val))

    @property
    def park_position(self) -> int:
        return int(self._context.get('root.lu.approach.instance.attribute.approach_result.enum.park_position'))

    @park_position.setter
    def park_position(self, new_val:int):
        self._context.set('root.lu.approach.instance.attribute.approach_result.enum.park_position', int(new_val))

    @property
    def timeout(self) -> int:
        return int(self._context.get('root.lu.approach.instance.attribute.approach_result.enum.timeout'))

    @timeout.setter
    def timeout(self, new_val:int):
        self._context.set('root.lu.approach.instance.attribute.approach_result.enum.timeout', int(new_val))

    @property
    def no_error(self) -> int:
        return int(self._context.get('root.lu.approach.instance.attribute.approach_result.enum.no_error'))

    @no_error.setter
    def no_error(self, new_val:int):
        self._context.set('root.lu.approach.instance.attribute.approach_result.enum.no_error', int(new_val))

    @property
    def approach_done(self) -> int:
        return int(self._context.get('root.lu.approach.instance.attribute.approach_result.enum.approach_done'))

    @approach_done.setter
    def approach_done(self, new_val:int):
        self._context.set('root.lu.approach.instance.attribute.approach_result.enum.approach_done', int(new_val))

    @property
    def tip_pos_adjust_done(self) -> int:
        return int(self._context.get('root.lu.approach.instance.attribute.approach_result.enum.tip_pos_adjust_done'))

    @tip_pos_adjust_done.setter
    def tip_pos_adjust_done(self, new_val:int):
        self._context.set('root.lu.approach.instance.attribute.approach_result.enum.tip_pos_adjust_done', int(new_val))

    @property
    def limit_switch_error(self) -> int:
        return int(self._context.get('root.lu.approach.instance.attribute.approach_result.enum.limit_switch_error'))

    @limit_switch_error.setter
    def limit_switch_error(self, new_val:int):
        self._context.set('root.lu.approach.instance.attribute.approach_result.enum.limit_switch_error', int(new_val))


class RootLuApproachInstanceAttributeApproach_result(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.approach.instance.attribute.approach_result'
        self.enum = RootLuApproachInstanceAttributeApproach_resultEnum(self._context)


class RootLuApproachInstanceAttribute(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.approach.instance.attribute'
        self.approach_result = RootLuApproachInstanceAttributeApproach_result(self._context)
        self.afm_approach_mode = RootLuApproachInstanceAttributeAfm_approach_mode(self._context)
        self.retract_tip = RootLuApproachInstanceAttributeRetract_tip(self._context)
        self.step_by_step_slope = RootLuApproachInstanceAttributeStep_by_step_slope(self._context)
        self.approach_pos = RootLuApproachInstanceAttributeApproach_pos(self._context)
        self.step_by_step_time = RootLuApproachInstanceAttributeStep_by_step_time(self._context)
        self.step_period = RootLuApproachInstanceAttributeStep_period(self._context)
        self.enable_pre_approach_xycl_calibration = RootLuApproachInstanceAttributeEnable_pre_approach_xycl_calibration(self._context)
        self.withdraw_steps = RootLuApproachInstanceAttributeWithdraw_steps(self._context)
        self.approach_steps = RootLuApproachInstanceAttributeApproach_steps(self._context)
        self.step_by_step_mode = RootLuApproachInstanceAttributeStep_by_step_mode(self._context)
        self.step_by_step_fine_step_size_percentage = RootLuApproachInstanceAttributeStep_by_step_fine_step_size_percentage(self._context)
        self.step_by_step_coarse_step_size_percentage = RootLuApproachInstanceAttributeStep_by_step_coarse_step_size_percentage(self._context)
        self.approach_pos_error = RootLuApproachInstanceAttributeApproach_pos_error(self._context)
        self.release_tip = RootLuApproachInstanceAttributeRelease_tip(self._context)
        self.motor_source = RootLuApproachInstanceAttributeMotor_source(self._context)
        self.current_z_stage_pos = RootLuApproachInstanceAttributeCurrent_z_stage_pos(self._context)
        self.stepper_direction = RootLuApproachInstanceAttributeStepper_direction(self._context)
        self.approach_status = RootLuApproachInstanceAttributeApproach_status(self._context)
        self.approach_speed = RootLuApproachInstanceAttributeApproach_speed(self._context)


class RootLuApproachInstance(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.approach.instance'
        self.attribute = RootLuApproachInstanceAttribute(self._context)
        self.trigger = RootLuApproachInstanceTrigger(self._context)


class RootLuApproach(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.approach'
        self.instance = RootLuApproachInstance(self._context)


class RootLuSensor_controlInstanceTriggerStart_detector_auto_adjustment(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.sensor_control.instance.trigger.start_detector_auto_adjustment'


class RootLuSensor_controlInstanceTriggerDeflection_offset_calibration_with_retract(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.sensor_control.instance.trigger.deflection_offset_calibration_with_retract'


class RootLuSensor_controlInstanceTriggerStart_update_laser_spot_on_detector_status(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.sensor_control.instance.trigger.start_update_laser_spot_on_detector_status'


class RootLuSensor_controlInstanceTriggerUpdate_laser_spot_on_detector_status(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.sensor_control.instance.trigger.update_laser_spot_on_detector_status'


class RootLuSensor_controlInstanceTriggerStart_sensor_calibration(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.sensor_control.instance.trigger.start_sensor_calibration'


class RootLuSensor_controlInstanceTriggerStart_set_dynamic_amplitude(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.sensor_control.instance.trigger.start_set_dynamic_amplitude'


class RootLuSensor_controlInstanceTriggerStart_deflection_offset_calibration(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.sensor_control.instance.trigger.start_deflection_offset_calibration'


class RootLuSensor_controlInstanceTriggerUser_abort(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.sensor_control.instance.trigger.user_abort'


class RootLuSensor_controlInstanceTriggerDeflection_offset_calibration(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.sensor_control.instance.trigger.deflection_offset_calibration'


class RootLuSensor_controlInstanceTrigger(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.sensor_control.instance.trigger'
        self.deflection_offset_calibration = RootLuSensor_controlInstanceTriggerDeflection_offset_calibration(self._context)
        self.user_abort = RootLuSensor_controlInstanceTriggerUser_abort(self._context)
        self.start_deflection_offset_calibration = RootLuSensor_controlInstanceTriggerStart_deflection_offset_calibration(self._context)
        self.start_set_dynamic_amplitude = RootLuSensor_controlInstanceTriggerStart_set_dynamic_amplitude(self._context)
        self.start_sensor_calibration = RootLuSensor_controlInstanceTriggerStart_sensor_calibration(self._context)
        self.update_laser_spot_on_detector_status = RootLuSensor_controlInstanceTriggerUpdate_laser_spot_on_detector_status(self._context)
        self.start_update_laser_spot_on_detector_status = RootLuSensor_controlInstanceTriggerStart_update_laser_spot_on_detector_status(self._context)
        self.deflection_offset_calibration_with_retract = RootLuSensor_controlInstanceTriggerDeflection_offset_calibration_with_retract(self._context)
        self.start_detector_auto_adjustment = RootLuSensor_controlInstanceTriggerStart_detector_auto_adjustment(self._context)


class RootLuSensor_controlInstanceAttributeDetector_adjustment_tolerance(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.sensor_control.instance.attribute.detector_adjustment_tolerance'


class RootLuSensor_controlInstanceAttributeOffset_calib_i_gain(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.sensor_control.instance.attribute.offset_calib_i_gain'


class RootLuSensor_controlInstanceAttributeDeflection_offset_calibration_statusEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.sensor_control.instance.attribute.deflection_offset_calibration_status.enum'

    @property
    def no_error(self) -> int:
        return int(self._context.get('root.lu.sensor_control.instance.attribute.deflection_offset_calibration_status.enum.no_error'))

    @no_error.setter
    def no_error(self, new_val:int):
        self._context.set('root.lu.sensor_control.instance.attribute.deflection_offset_calibration_status.enum.no_error', int(new_val))

    @property
    def calibration_error(self) -> int:
        return int(self._context.get('root.lu.sensor_control.instance.attribute.deflection_offset_calibration_status.enum.calibration_error'))

    @calibration_error.setter
    def calibration_error(self, new_val:int):
        self._context.set('root.lu.sensor_control.instance.attribute.deflection_offset_calibration_status.enum.calibration_error', int(new_val))

    @property
    def sensor_signal_failed(self) -> int:
        return int(self._context.get('root.lu.sensor_control.instance.attribute.deflection_offset_calibration_status.enum.sensor_signal_failed'))

    @sensor_signal_failed.setter
    def sensor_signal_failed(self, new_val:int):
        self._context.set('root.lu.sensor_control.instance.attribute.deflection_offset_calibration_status.enum.sensor_signal_failed', int(new_val))


class RootLuSensor_controlInstanceAttributeDeflection_offset_calibration_status(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.sensor_control.instance.attribute.deflection_offset_calibration_status'
        self.enum = RootLuSensor_controlInstanceAttributeDeflection_offset_calibration_statusEnum(self._context)


class RootLuSensor_controlInstanceAttributeDetector_auto_adjustment_statusEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.sensor_control.instance.attribute.detector_auto_adjustment_status.enum'

    @property
    def failed(self) -> int:
        return int(self._context.get('root.lu.sensor_control.instance.attribute.detector_auto_adjustment_status.enum.failed'))

    @failed.setter
    def failed(self, new_val:int):
        self._context.set('root.lu.sensor_control.instance.attribute.detector_auto_adjustment_status.enum.failed', int(new_val))

    @property
    def running(self) -> int:
        return int(self._context.get('root.lu.sensor_control.instance.attribute.detector_auto_adjustment_status.enum.running'))

    @running.setter
    def running(self, new_val:int):
        self._context.set('root.lu.sensor_control.instance.attribute.detector_auto_adjustment_status.enum.running', int(new_val))

    @property
    def idle(self) -> int:
        return int(self._context.get('root.lu.sensor_control.instance.attribute.detector_auto_adjustment_status.enum.idle'))

    @idle.setter
    def idle(self, new_val:int):
        self._context.set('root.lu.sensor_control.instance.attribute.detector_auto_adjustment_status.enum.idle', int(new_val))


class RootLuSensor_controlInstanceAttributeDetector_auto_adjustment_status(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.sensor_control.instance.attribute.detector_auto_adjustment_status'
        self.enum = RootLuSensor_controlInstanceAttributeDetector_auto_adjustment_statusEnum(self._context)


class RootLuSensor_controlInstanceAttributeSensor_amplitude(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.sensor_control.instance.attribute.sensor_amplitude'


class RootLuSensor_controlInstanceAttributeOffset_calib_i_gain_modeEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.sensor_control.instance.attribute.offset_calib_i_gain_mode.enum'

    @property
    def auto_from_head_typ(self) -> int:
        return int(self._context.get('root.lu.sensor_control.instance.attribute.offset_calib_i_gain_mode.enum.auto_from_head_typ'))

    @auto_from_head_typ.setter
    def auto_from_head_typ(self, new_val:int):
        self._context.set('root.lu.sensor_control.instance.attribute.offset_calib_i_gain_mode.enum.auto_from_head_typ', int(new_val))

    @property
    def fix_from_attr(self) -> int:
        return int(self._context.get('root.lu.sensor_control.instance.attribute.offset_calib_i_gain_mode.enum.fix_from_attr'))

    @fix_from_attr.setter
    def fix_from_attr(self, new_val:int):
        self._context.set('root.lu.sensor_control.instance.attribute.offset_calib_i_gain_mode.enum.fix_from_attr', int(new_val))


class RootLuSensor_controlInstanceAttributeOffset_calib_i_gain_mode(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.sensor_control.instance.attribute.offset_calib_i_gain_mode'
        self.enum = RootLuSensor_controlInstanceAttributeOffset_calib_i_gain_modeEnum(self._context)


class RootLuSensor_controlInstanceAttributeEnable10_hz_update_laser_spot_on_detector_status(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.sensor_control.instance.attribute.enable10_hz_update_laser_spot_on_detector_status'


class RootLuSensor_controlInstanceAttributeOffset_calib_modeEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.sensor_control.instance.attribute.offset_calib_mode.enum'

    @property
    def auto_calibrate_z_ctrl_input(self) -> int:
        return int(self._context.get('root.lu.sensor_control.instance.attribute.offset_calib_mode.enum.auto_calibrate_z_ctrl_input'))

    @auto_calibrate_z_ctrl_input.setter
    def auto_calibrate_z_ctrl_input(self, new_val:int):
        self._context.set('root.lu.sensor_control.instance.attribute.offset_calib_mode.enum.auto_calibrate_z_ctrl_input', int(new_val))

    @property
    def no_auto_calibration(self) -> int:
        return int(self._context.get('root.lu.sensor_control.instance.attribute.offset_calib_mode.enum.no_auto_calibration'))

    @no_auto_calibration.setter
    def no_auto_calibration(self, new_val:int):
        self._context.set('root.lu.sensor_control.instance.attribute.offset_calib_mode.enum.no_auto_calibration', int(new_val))

    @property
    def auto_calibrate_deflection(self) -> int:
        return int(self._context.get('root.lu.sensor_control.instance.attribute.offset_calib_mode.enum.auto_calibrate_deflection'))

    @auto_calibrate_deflection.setter
    def auto_calibrate_deflection(self, new_val:int):
        self._context.set('root.lu.sensor_control.instance.attribute.offset_calib_mode.enum.auto_calibrate_deflection', int(new_val))


class RootLuSensor_controlInstanceAttributeOffset_calib_mode(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.sensor_control.instance.attribute.offset_calib_mode'
        self.enum = RootLuSensor_controlInstanceAttributeOffset_calib_modeEnum(self._context)


class RootLuSensor_controlInstanceAttributeDetector_adjustment_duration_limit(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.sensor_control.instance.attribute.detector_adjustment_duration_limit'


class RootLuSensor_controlInstanceAttribute(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.sensor_control.instance.attribute'
        self.detector_adjustment_duration_limit = RootLuSensor_controlInstanceAttributeDetector_adjustment_duration_limit(self._context)
        self.offset_calib_mode = RootLuSensor_controlInstanceAttributeOffset_calib_mode(self._context)
        self.enable10_hz_update_laser_spot_on_detector_status = RootLuSensor_controlInstanceAttributeEnable10_hz_update_laser_spot_on_detector_status(self._context)
        self.offset_calib_i_gain_mode = RootLuSensor_controlInstanceAttributeOffset_calib_i_gain_mode(self._context)
        self.sensor_amplitude = RootLuSensor_controlInstanceAttributeSensor_amplitude(self._context)
        self.detector_auto_adjustment_status = RootLuSensor_controlInstanceAttributeDetector_auto_adjustment_status(self._context)
        self.deflection_offset_calibration_status = RootLuSensor_controlInstanceAttributeDeflection_offset_calibration_status(self._context)
        self.offset_calib_i_gain = RootLuSensor_controlInstanceAttributeOffset_calib_i_gain(self._context)
        self.detector_adjustment_tolerance = RootLuSensor_controlInstanceAttributeDetector_adjustment_tolerance(self._context)


class RootLuSensor_controlInstance(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.sensor_control.instance'
        self.attribute = RootLuSensor_controlInstanceAttribute(self._context)
        self.trigger = RootLuSensor_controlInstanceTrigger(self._context)


class RootLuSensor_control(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.sensor_control'
        self.instance = RootLuSensor_controlInstance(self._context)


class RootLuRamp_generatorPlane_zBusyIs_moving(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.plane_z.busy.is_moving'


class RootLuRamp_generatorPlane_zBusy(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.plane_z.busy'
        self.is_moving = RootLuRamp_generatorPlane_zBusyIs_moving(self._context)


class RootLuRamp_generatorPlane_zAttributeStatusEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.plane_z.attribute.status.enum'

    @property
    def reached_lower_limit(self) -> int:
        return int(self._context.get('root.lu.ramp_generator.plane_z.attribute.status.enum.reached_lower_limit'))

    @reached_lower_limit.setter
    def reached_lower_limit(self, new_val:int):
        self._context.set('root.lu.ramp_generator.plane_z.attribute.status.enum.reached_lower_limit', int(new_val))

    @property
    def is_moving(self) -> int:
        return int(self._context.get('root.lu.ramp_generator.plane_z.attribute.status.enum.is_moving'))

    @is_moving.setter
    def is_moving(self, new_val:int):
        self._context.set('root.lu.ramp_generator.plane_z.attribute.status.enum.is_moving', int(new_val))

    @property
    def reached_upper_limit(self) -> int:
        return int(self._context.get('root.lu.ramp_generator.plane_z.attribute.status.enum.reached_upper_limit'))

    @reached_upper_limit.setter
    def reached_upper_limit(self, new_val:int):
        self._context.set('root.lu.ramp_generator.plane_z.attribute.status.enum.reached_upper_limit', int(new_val))

    @property
    def reached_endposition(self) -> int:
        return int(self._context.get('root.lu.ramp_generator.plane_z.attribute.status.enum.reached_endposition'))

    @reached_endposition.setter
    def reached_endposition(self, new_val:int):
        self._context.set('root.lu.ramp_generator.plane_z.attribute.status.enum.reached_endposition', int(new_val))

    @property
    def stopped_by_external_event(self) -> int:
        return int(self._context.get('root.lu.ramp_generator.plane_z.attribute.status.enum.stopped_by_external_event'))

    @stopped_by_external_event.setter
    def stopped_by_external_event(self, new_val:int):
        self._context.set('root.lu.ramp_generator.plane_z.attribute.status.enum.stopped_by_external_event', int(new_val))


class RootLuRamp_generatorPlane_zAttributeStatus(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.plane_z.attribute.status'
        self.enum = RootLuRamp_generatorPlane_zAttributeStatusEnum(self._context)


class RootLuRamp_generatorPlane_zAttributeMoving_modeEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.plane_z.attribute.moving_mode.enum'

    @property
    def fix_time(self) -> int:
        return int(self._context.get('root.lu.ramp_generator.plane_z.attribute.moving_mode.enum.fix_time'))

    @fix_time.setter
    def fix_time(self, new_val:int):
        self._context.set('root.lu.ramp_generator.plane_z.attribute.moving_mode.enum.fix_time', int(new_val))

    @property
    def fix_speed(self) -> int:
        return int(self._context.get('root.lu.ramp_generator.plane_z.attribute.moving_mode.enum.fix_speed'))

    @fix_speed.setter
    def fix_speed(self, new_val:int):
        self._context.set('root.lu.ramp_generator.plane_z.attribute.moving_mode.enum.fix_speed', int(new_val))


class RootLuRamp_generatorPlane_zAttributeMoving_mode(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.plane_z.attribute.moving_mode'
        self.enum = RootLuRamp_generatorPlane_zAttributeMoving_modeEnum(self._context)


class RootLuRamp_generatorPlane_zAttributeEnd_value_relative(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.plane_z.attribute.end_value_relative'


class RootLuRamp_generatorPlane_zAttributeMoving_time(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.plane_z.attribute.moving_time'


class RootLuRamp_generatorPlane_zAttributeEnd_value_absolute(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.plane_z.attribute.end_value_absolute'


class RootLuRamp_generatorPlane_zAttributeUpper_limit(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.plane_z.attribute.upper_limit'


class RootLuRamp_generatorPlane_zAttributeLower_limit(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.plane_z.attribute.lower_limit'


class RootLuRamp_generatorPlane_zAttributeCurrent_value(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.plane_z.attribute.current_value'


class RootLuRamp_generatorPlane_zAttributeEnd_value_modeEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.plane_z.attribute.end_value_mode.enum'

    @property
    def move_relative(self) -> int:
        return int(self._context.get('root.lu.ramp_generator.plane_z.attribute.end_value_mode.enum.move_relative'))

    @move_relative.setter
    def move_relative(self, new_val:int):
        self._context.set('root.lu.ramp_generator.plane_z.attribute.end_value_mode.enum.move_relative', int(new_val))

    @property
    def move_to_absolute(self) -> int:
        return int(self._context.get('root.lu.ramp_generator.plane_z.attribute.end_value_mode.enum.move_to_absolute'))

    @move_to_absolute.setter
    def move_to_absolute(self, new_val:int):
        self._context.set('root.lu.ramp_generator.plane_z.attribute.end_value_mode.enum.move_to_absolute', int(new_val))


class RootLuRamp_generatorPlane_zAttributeEnd_value_mode(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.plane_z.attribute.end_value_mode'
        self.enum = RootLuRamp_generatorPlane_zAttributeEnd_value_modeEnum(self._context)


class RootLuRamp_generatorPlane_zAttributeMoving_speed(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.plane_z.attribute.moving_speed'


class RootLuRamp_generatorPlane_zAttribute(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.plane_z.attribute'
        self.moving_speed = RootLuRamp_generatorPlane_zAttributeMoving_speed(self._context)
        self.end_value_mode = RootLuRamp_generatorPlane_zAttributeEnd_value_mode(self._context)
        self.current_value = RootLuRamp_generatorPlane_zAttributeCurrent_value(self._context)
        self.lower_limit = RootLuRamp_generatorPlane_zAttributeLower_limit(self._context)
        self.upper_limit = RootLuRamp_generatorPlane_zAttributeUpper_limit(self._context)
        self.end_value_absolute = RootLuRamp_generatorPlane_zAttributeEnd_value_absolute(self._context)
        self.moving_time = RootLuRamp_generatorPlane_zAttributeMoving_time(self._context)
        self.end_value_relative = RootLuRamp_generatorPlane_zAttributeEnd_value_relative(self._context)
        self.moving_mode = RootLuRamp_generatorPlane_zAttributeMoving_mode(self._context)
        self.status = RootLuRamp_generatorPlane_zAttributeStatus(self._context)


class RootLuRamp_generatorPlane_zTriggerStart(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.plane_z.trigger.start'


class RootLuRamp_generatorPlane_zTriggerAbort(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.plane_z.trigger.abort'


class RootLuRamp_generatorPlane_zTriggerPrepare(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.plane_z.trigger.prepare'


class RootLuRamp_generatorPlane_zTriggerStop(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.plane_z.trigger.stop'


class RootLuRamp_generatorPlane_zTrigger(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.plane_z.trigger'
        self.stop = RootLuRamp_generatorPlane_zTriggerStop(self._context)
        self.prepare = RootLuRamp_generatorPlane_zTriggerPrepare(self._context)
        self.abort = RootLuRamp_generatorPlane_zTriggerAbort(self._context)
        self.start = RootLuRamp_generatorPlane_zTriggerStart(self._context)


class RootLuRamp_generatorPlane_z(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.plane_z'
        self.trigger = RootLuRamp_generatorPlane_zTrigger(self._context)
        self.attribute = RootLuRamp_generatorPlane_zAttribute(self._context)
        self.busy = RootLuRamp_generatorPlane_zBusy(self._context)


class RootLuRamp_generatorCtrl_zBusyIs_moving(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.ctrl_z.busy.is_moving'


class RootLuRamp_generatorCtrl_zBusy(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.ctrl_z.busy'
        self.is_moving = RootLuRamp_generatorCtrl_zBusyIs_moving(self._context)


class RootLuRamp_generatorCtrl_zAttributeStatusEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.ctrl_z.attribute.status.enum'

    @property
    def reached_lower_limit(self) -> int:
        return int(self._context.get('root.lu.ramp_generator.ctrl_z.attribute.status.enum.reached_lower_limit'))

    @reached_lower_limit.setter
    def reached_lower_limit(self, new_val:int):
        self._context.set('root.lu.ramp_generator.ctrl_z.attribute.status.enum.reached_lower_limit', int(new_val))

    @property
    def is_moving(self) -> int:
        return int(self._context.get('root.lu.ramp_generator.ctrl_z.attribute.status.enum.is_moving'))

    @is_moving.setter
    def is_moving(self, new_val:int):
        self._context.set('root.lu.ramp_generator.ctrl_z.attribute.status.enum.is_moving', int(new_val))

    @property
    def reached_upper_limit(self) -> int:
        return int(self._context.get('root.lu.ramp_generator.ctrl_z.attribute.status.enum.reached_upper_limit'))

    @reached_upper_limit.setter
    def reached_upper_limit(self, new_val:int):
        self._context.set('root.lu.ramp_generator.ctrl_z.attribute.status.enum.reached_upper_limit', int(new_val))

    @property
    def reached_endposition(self) -> int:
        return int(self._context.get('root.lu.ramp_generator.ctrl_z.attribute.status.enum.reached_endposition'))

    @reached_endposition.setter
    def reached_endposition(self, new_val:int):
        self._context.set('root.lu.ramp_generator.ctrl_z.attribute.status.enum.reached_endposition', int(new_val))

    @property
    def stopped_by_external_event(self) -> int:
        return int(self._context.get('root.lu.ramp_generator.ctrl_z.attribute.status.enum.stopped_by_external_event'))

    @stopped_by_external_event.setter
    def stopped_by_external_event(self, new_val:int):
        self._context.set('root.lu.ramp_generator.ctrl_z.attribute.status.enum.stopped_by_external_event', int(new_val))


class RootLuRamp_generatorCtrl_zAttributeStatus(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.ctrl_z.attribute.status'
        self.enum = RootLuRamp_generatorCtrl_zAttributeStatusEnum(self._context)


class RootLuRamp_generatorCtrl_zAttributeMoving_modeEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.ctrl_z.attribute.moving_mode.enum'

    @property
    def fix_time(self) -> int:
        return int(self._context.get('root.lu.ramp_generator.ctrl_z.attribute.moving_mode.enum.fix_time'))

    @fix_time.setter
    def fix_time(self, new_val:int):
        self._context.set('root.lu.ramp_generator.ctrl_z.attribute.moving_mode.enum.fix_time', int(new_val))

    @property
    def fix_speed(self) -> int:
        return int(self._context.get('root.lu.ramp_generator.ctrl_z.attribute.moving_mode.enum.fix_speed'))

    @fix_speed.setter
    def fix_speed(self, new_val:int):
        self._context.set('root.lu.ramp_generator.ctrl_z.attribute.moving_mode.enum.fix_speed', int(new_val))


class RootLuRamp_generatorCtrl_zAttributeMoving_mode(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.ctrl_z.attribute.moving_mode'
        self.enum = RootLuRamp_generatorCtrl_zAttributeMoving_modeEnum(self._context)


class RootLuRamp_generatorCtrl_zAttributeEnd_value_relative(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.ctrl_z.attribute.end_value_relative'


class RootLuRamp_generatorCtrl_zAttributeMoving_time(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.ctrl_z.attribute.moving_time'


class RootLuRamp_generatorCtrl_zAttributeEnd_value_absolute(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.ctrl_z.attribute.end_value_absolute'


class RootLuRamp_generatorCtrl_zAttributeUpper_limit(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.ctrl_z.attribute.upper_limit'


class RootLuRamp_generatorCtrl_zAttributeLower_limit(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.ctrl_z.attribute.lower_limit'


class RootLuRamp_generatorCtrl_zAttributeCurrent_value(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.ctrl_z.attribute.current_value'


class RootLuRamp_generatorCtrl_zAttributeEnd_value_modeEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.ctrl_z.attribute.end_value_mode.enum'

    @property
    def move_relative(self) -> int:
        return int(self._context.get('root.lu.ramp_generator.ctrl_z.attribute.end_value_mode.enum.move_relative'))

    @move_relative.setter
    def move_relative(self, new_val:int):
        self._context.set('root.lu.ramp_generator.ctrl_z.attribute.end_value_mode.enum.move_relative', int(new_val))

    @property
    def move_to_absolute(self) -> int:
        return int(self._context.get('root.lu.ramp_generator.ctrl_z.attribute.end_value_mode.enum.move_to_absolute'))

    @move_to_absolute.setter
    def move_to_absolute(self, new_val:int):
        self._context.set('root.lu.ramp_generator.ctrl_z.attribute.end_value_mode.enum.move_to_absolute', int(new_val))


class RootLuRamp_generatorCtrl_zAttributeEnd_value_mode(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.ctrl_z.attribute.end_value_mode'
        self.enum = RootLuRamp_generatorCtrl_zAttributeEnd_value_modeEnum(self._context)


class RootLuRamp_generatorCtrl_zAttributeMoving_speed(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.ctrl_z.attribute.moving_speed'


class RootLuRamp_generatorCtrl_zAttribute(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.ctrl_z.attribute'
        self.moving_speed = RootLuRamp_generatorCtrl_zAttributeMoving_speed(self._context)
        self.end_value_mode = RootLuRamp_generatorCtrl_zAttributeEnd_value_mode(self._context)
        self.current_value = RootLuRamp_generatorCtrl_zAttributeCurrent_value(self._context)
        self.lower_limit = RootLuRamp_generatorCtrl_zAttributeLower_limit(self._context)
        self.upper_limit = RootLuRamp_generatorCtrl_zAttributeUpper_limit(self._context)
        self.end_value_absolute = RootLuRamp_generatorCtrl_zAttributeEnd_value_absolute(self._context)
        self.moving_time = RootLuRamp_generatorCtrl_zAttributeMoving_time(self._context)
        self.end_value_relative = RootLuRamp_generatorCtrl_zAttributeEnd_value_relative(self._context)
        self.moving_mode = RootLuRamp_generatorCtrl_zAttributeMoving_mode(self._context)
        self.status = RootLuRamp_generatorCtrl_zAttributeStatus(self._context)


class RootLuRamp_generatorCtrl_zTriggerStart(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.ctrl_z.trigger.start'


class RootLuRamp_generatorCtrl_zTriggerAbort(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.ctrl_z.trigger.abort'


class RootLuRamp_generatorCtrl_zTriggerPrepare(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.ctrl_z.trigger.prepare'


class RootLuRamp_generatorCtrl_zTriggerStop(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.ctrl_z.trigger.stop'


class RootLuRamp_generatorCtrl_zTrigger(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.ctrl_z.trigger'
        self.stop = RootLuRamp_generatorCtrl_zTriggerStop(self._context)
        self.prepare = RootLuRamp_generatorCtrl_zTriggerPrepare(self._context)
        self.abort = RootLuRamp_generatorCtrl_zTriggerAbort(self._context)
        self.start = RootLuRamp_generatorCtrl_zTriggerStart(self._context)


class RootLuRamp_generatorCtrl_z(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.ctrl_z'
        self.trigger = RootLuRamp_generatorCtrl_zTrigger(self._context)
        self.attribute = RootLuRamp_generatorCtrl_zAttribute(self._context)
        self.busy = RootLuRamp_generatorCtrl_zBusy(self._context)


class RootLuRamp_generatorVirtual0BusyIs_moving(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.virtual0.busy.is_moving'


class RootLuRamp_generatorVirtual0Busy(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.virtual0.busy'
        self.is_moving = RootLuRamp_generatorVirtual0BusyIs_moving(self._context)


class RootLuRamp_generatorVirtual0AttributeStatusEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.virtual0.attribute.status.enum'

    @property
    def reached_lower_limit(self) -> int:
        return int(self._context.get('root.lu.ramp_generator.virtual0.attribute.status.enum.reached_lower_limit'))

    @reached_lower_limit.setter
    def reached_lower_limit(self, new_val:int):
        self._context.set('root.lu.ramp_generator.virtual0.attribute.status.enum.reached_lower_limit', int(new_val))

    @property
    def is_moving(self) -> int:
        return int(self._context.get('root.lu.ramp_generator.virtual0.attribute.status.enum.is_moving'))

    @is_moving.setter
    def is_moving(self, new_val:int):
        self._context.set('root.lu.ramp_generator.virtual0.attribute.status.enum.is_moving', int(new_val))

    @property
    def reached_upper_limit(self) -> int:
        return int(self._context.get('root.lu.ramp_generator.virtual0.attribute.status.enum.reached_upper_limit'))

    @reached_upper_limit.setter
    def reached_upper_limit(self, new_val:int):
        self._context.set('root.lu.ramp_generator.virtual0.attribute.status.enum.reached_upper_limit', int(new_val))

    @property
    def reached_endposition(self) -> int:
        return int(self._context.get('root.lu.ramp_generator.virtual0.attribute.status.enum.reached_endposition'))

    @reached_endposition.setter
    def reached_endposition(self, new_val:int):
        self._context.set('root.lu.ramp_generator.virtual0.attribute.status.enum.reached_endposition', int(new_val))

    @property
    def stopped_by_external_event(self) -> int:
        return int(self._context.get('root.lu.ramp_generator.virtual0.attribute.status.enum.stopped_by_external_event'))

    @stopped_by_external_event.setter
    def stopped_by_external_event(self, new_val:int):
        self._context.set('root.lu.ramp_generator.virtual0.attribute.status.enum.stopped_by_external_event', int(new_val))


class RootLuRamp_generatorVirtual0AttributeStatus(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.virtual0.attribute.status'
        self.enum = RootLuRamp_generatorVirtual0AttributeStatusEnum(self._context)


class RootLuRamp_generatorVirtual0AttributeMoving_modeEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.virtual0.attribute.moving_mode.enum'

    @property
    def fix_time(self) -> int:
        return int(self._context.get('root.lu.ramp_generator.virtual0.attribute.moving_mode.enum.fix_time'))

    @fix_time.setter
    def fix_time(self, new_val:int):
        self._context.set('root.lu.ramp_generator.virtual0.attribute.moving_mode.enum.fix_time', int(new_val))

    @property
    def fix_speed(self) -> int:
        return int(self._context.get('root.lu.ramp_generator.virtual0.attribute.moving_mode.enum.fix_speed'))

    @fix_speed.setter
    def fix_speed(self, new_val:int):
        self._context.set('root.lu.ramp_generator.virtual0.attribute.moving_mode.enum.fix_speed', int(new_val))


class RootLuRamp_generatorVirtual0AttributeMoving_mode(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.virtual0.attribute.moving_mode'
        self.enum = RootLuRamp_generatorVirtual0AttributeMoving_modeEnum(self._context)


class RootLuRamp_generatorVirtual0AttributeEnd_value_relative(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.virtual0.attribute.end_value_relative'


class RootLuRamp_generatorVirtual0AttributeMoving_time(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.virtual0.attribute.moving_time'


class RootLuRamp_generatorVirtual0AttributeEnd_value_absolute(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.virtual0.attribute.end_value_absolute'


class RootLuRamp_generatorVirtual0AttributeUpper_limit(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.virtual0.attribute.upper_limit'


class RootLuRamp_generatorVirtual0AttributeLower_limit(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.virtual0.attribute.lower_limit'


class RootLuRamp_generatorVirtual0AttributeCurrent_value(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.virtual0.attribute.current_value'


class RootLuRamp_generatorVirtual0AttributeEnd_value_modeEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.virtual0.attribute.end_value_mode.enum'

    @property
    def move_relative(self) -> int:
        return int(self._context.get('root.lu.ramp_generator.virtual0.attribute.end_value_mode.enum.move_relative'))

    @move_relative.setter
    def move_relative(self, new_val:int):
        self._context.set('root.lu.ramp_generator.virtual0.attribute.end_value_mode.enum.move_relative', int(new_val))

    @property
    def move_to_absolute(self) -> int:
        return int(self._context.get('root.lu.ramp_generator.virtual0.attribute.end_value_mode.enum.move_to_absolute'))

    @move_to_absolute.setter
    def move_to_absolute(self, new_val:int):
        self._context.set('root.lu.ramp_generator.virtual0.attribute.end_value_mode.enum.move_to_absolute', int(new_val))


class RootLuRamp_generatorVirtual0AttributeEnd_value_mode(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.virtual0.attribute.end_value_mode'
        self.enum = RootLuRamp_generatorVirtual0AttributeEnd_value_modeEnum(self._context)


class RootLuRamp_generatorVirtual0AttributeMoving_speed(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.virtual0.attribute.moving_speed'


class RootLuRamp_generatorVirtual0Attribute(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.virtual0.attribute'
        self.moving_speed = RootLuRamp_generatorVirtual0AttributeMoving_speed(self._context)
        self.end_value_mode = RootLuRamp_generatorVirtual0AttributeEnd_value_mode(self._context)
        self.current_value = RootLuRamp_generatorVirtual0AttributeCurrent_value(self._context)
        self.lower_limit = RootLuRamp_generatorVirtual0AttributeLower_limit(self._context)
        self.upper_limit = RootLuRamp_generatorVirtual0AttributeUpper_limit(self._context)
        self.end_value_absolute = RootLuRamp_generatorVirtual0AttributeEnd_value_absolute(self._context)
        self.moving_time = RootLuRamp_generatorVirtual0AttributeMoving_time(self._context)
        self.end_value_relative = RootLuRamp_generatorVirtual0AttributeEnd_value_relative(self._context)
        self.moving_mode = RootLuRamp_generatorVirtual0AttributeMoving_mode(self._context)
        self.status = RootLuRamp_generatorVirtual0AttributeStatus(self._context)


class RootLuRamp_generatorVirtual0TriggerStart(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.virtual0.trigger.start'


class RootLuRamp_generatorVirtual0TriggerAbort(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.virtual0.trigger.abort'


class RootLuRamp_generatorVirtual0TriggerPrepare(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.virtual0.trigger.prepare'


class RootLuRamp_generatorVirtual0TriggerStop(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.virtual0.trigger.stop'


class RootLuRamp_generatorVirtual0Trigger(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.virtual0.trigger'
        self.stop = RootLuRamp_generatorVirtual0TriggerStop(self._context)
        self.prepare = RootLuRamp_generatorVirtual0TriggerPrepare(self._context)
        self.abort = RootLuRamp_generatorVirtual0TriggerAbort(self._context)
        self.start = RootLuRamp_generatorVirtual0TriggerStart(self._context)


class RootLuRamp_generatorVirtual0(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.virtual0'
        self.trigger = RootLuRamp_generatorVirtual0Trigger(self._context)
        self.attribute = RootLuRamp_generatorVirtual0Attribute(self._context)
        self.busy = RootLuRamp_generatorVirtual0Busy(self._context)


class RootLuRamp_generatorTip_voltageBusyIs_moving(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.tip_voltage.busy.is_moving'


class RootLuRamp_generatorTip_voltageBusy(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.tip_voltage.busy'
        self.is_moving = RootLuRamp_generatorTip_voltageBusyIs_moving(self._context)


class RootLuRamp_generatorTip_voltageAttributeStatusEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.tip_voltage.attribute.status.enum'

    @property
    def reached_lower_limit(self) -> int:
        return int(self._context.get('root.lu.ramp_generator.tip_voltage.attribute.status.enum.reached_lower_limit'))

    @reached_lower_limit.setter
    def reached_lower_limit(self, new_val:int):
        self._context.set('root.lu.ramp_generator.tip_voltage.attribute.status.enum.reached_lower_limit', int(new_val))

    @property
    def is_moving(self) -> int:
        return int(self._context.get('root.lu.ramp_generator.tip_voltage.attribute.status.enum.is_moving'))

    @is_moving.setter
    def is_moving(self, new_val:int):
        self._context.set('root.lu.ramp_generator.tip_voltage.attribute.status.enum.is_moving', int(new_val))

    @property
    def reached_upper_limit(self) -> int:
        return int(self._context.get('root.lu.ramp_generator.tip_voltage.attribute.status.enum.reached_upper_limit'))

    @reached_upper_limit.setter
    def reached_upper_limit(self, new_val:int):
        self._context.set('root.lu.ramp_generator.tip_voltage.attribute.status.enum.reached_upper_limit', int(new_val))

    @property
    def reached_endposition(self) -> int:
        return int(self._context.get('root.lu.ramp_generator.tip_voltage.attribute.status.enum.reached_endposition'))

    @reached_endposition.setter
    def reached_endposition(self, new_val:int):
        self._context.set('root.lu.ramp_generator.tip_voltage.attribute.status.enum.reached_endposition', int(new_val))

    @property
    def stopped_by_external_event(self) -> int:
        return int(self._context.get('root.lu.ramp_generator.tip_voltage.attribute.status.enum.stopped_by_external_event'))

    @stopped_by_external_event.setter
    def stopped_by_external_event(self, new_val:int):
        self._context.set('root.lu.ramp_generator.tip_voltage.attribute.status.enum.stopped_by_external_event', int(new_val))


class RootLuRamp_generatorTip_voltageAttributeStatus(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.tip_voltage.attribute.status'
        self.enum = RootLuRamp_generatorTip_voltageAttributeStatusEnum(self._context)


class RootLuRamp_generatorTip_voltageAttributeMoving_modeEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.tip_voltage.attribute.moving_mode.enum'

    @property
    def fix_time(self) -> int:
        return int(self._context.get('root.lu.ramp_generator.tip_voltage.attribute.moving_mode.enum.fix_time'))

    @fix_time.setter
    def fix_time(self, new_val:int):
        self._context.set('root.lu.ramp_generator.tip_voltage.attribute.moving_mode.enum.fix_time', int(new_val))

    @property
    def fix_speed(self) -> int:
        return int(self._context.get('root.lu.ramp_generator.tip_voltage.attribute.moving_mode.enum.fix_speed'))

    @fix_speed.setter
    def fix_speed(self, new_val:int):
        self._context.set('root.lu.ramp_generator.tip_voltage.attribute.moving_mode.enum.fix_speed', int(new_val))


class RootLuRamp_generatorTip_voltageAttributeMoving_mode(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.tip_voltage.attribute.moving_mode'
        self.enum = RootLuRamp_generatorTip_voltageAttributeMoving_modeEnum(self._context)


class RootLuRamp_generatorTip_voltageAttributeEnd_value_relative(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.tip_voltage.attribute.end_value_relative'


class RootLuRamp_generatorTip_voltageAttributeMoving_time(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.tip_voltage.attribute.moving_time'


class RootLuRamp_generatorTip_voltageAttributeEnd_value_absolute(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.tip_voltage.attribute.end_value_absolute'


class RootLuRamp_generatorTip_voltageAttributeUpper_limit(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.tip_voltage.attribute.upper_limit'


class RootLuRamp_generatorTip_voltageAttributeLower_limit(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.tip_voltage.attribute.lower_limit'


class RootLuRamp_generatorTip_voltageAttributeCurrent_value(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.tip_voltage.attribute.current_value'


class RootLuRamp_generatorTip_voltageAttributeEnd_value_modeEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.tip_voltage.attribute.end_value_mode.enum'

    @property
    def move_relative(self) -> int:
        return int(self._context.get('root.lu.ramp_generator.tip_voltage.attribute.end_value_mode.enum.move_relative'))

    @move_relative.setter
    def move_relative(self, new_val:int):
        self._context.set('root.lu.ramp_generator.tip_voltage.attribute.end_value_mode.enum.move_relative', int(new_val))

    @property
    def move_to_absolute(self) -> int:
        return int(self._context.get('root.lu.ramp_generator.tip_voltage.attribute.end_value_mode.enum.move_to_absolute'))

    @move_to_absolute.setter
    def move_to_absolute(self, new_val:int):
        self._context.set('root.lu.ramp_generator.tip_voltage.attribute.end_value_mode.enum.move_to_absolute', int(new_val))


class RootLuRamp_generatorTip_voltageAttributeEnd_value_mode(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.tip_voltage.attribute.end_value_mode'
        self.enum = RootLuRamp_generatorTip_voltageAttributeEnd_value_modeEnum(self._context)


class RootLuRamp_generatorTip_voltageAttributeMoving_speed(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.tip_voltage.attribute.moving_speed'


class RootLuRamp_generatorTip_voltageAttribute(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.tip_voltage.attribute'
        self.moving_speed = RootLuRamp_generatorTip_voltageAttributeMoving_speed(self._context)
        self.end_value_mode = RootLuRamp_generatorTip_voltageAttributeEnd_value_mode(self._context)
        self.current_value = RootLuRamp_generatorTip_voltageAttributeCurrent_value(self._context)
        self.lower_limit = RootLuRamp_generatorTip_voltageAttributeLower_limit(self._context)
        self.upper_limit = RootLuRamp_generatorTip_voltageAttributeUpper_limit(self._context)
        self.end_value_absolute = RootLuRamp_generatorTip_voltageAttributeEnd_value_absolute(self._context)
        self.moving_time = RootLuRamp_generatorTip_voltageAttributeMoving_time(self._context)
        self.end_value_relative = RootLuRamp_generatorTip_voltageAttributeEnd_value_relative(self._context)
        self.moving_mode = RootLuRamp_generatorTip_voltageAttributeMoving_mode(self._context)
        self.status = RootLuRamp_generatorTip_voltageAttributeStatus(self._context)


class RootLuRamp_generatorTip_voltageTriggerStart(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.tip_voltage.trigger.start'


class RootLuRamp_generatorTip_voltageTriggerAbort(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.tip_voltage.trigger.abort'


class RootLuRamp_generatorTip_voltageTriggerPrepare(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.tip_voltage.trigger.prepare'


class RootLuRamp_generatorTip_voltageTriggerStop(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.tip_voltage.trigger.stop'


class RootLuRamp_generatorTip_voltageTrigger(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.tip_voltage.trigger'
        self.stop = RootLuRamp_generatorTip_voltageTriggerStop(self._context)
        self.prepare = RootLuRamp_generatorTip_voltageTriggerPrepare(self._context)
        self.abort = RootLuRamp_generatorTip_voltageTriggerAbort(self._context)
        self.start = RootLuRamp_generatorTip_voltageTriggerStart(self._context)


class RootLuRamp_generatorTip_voltage(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.tip_voltage'
        self.trigger = RootLuRamp_generatorTip_voltageTrigger(self._context)
        self.attribute = RootLuRamp_generatorTip_voltageAttribute(self._context)
        self.busy = RootLuRamp_generatorTip_voltageBusy(self._context)


class RootLuRamp_generatorAlternate_zBusyIs_moving(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.alternate_z.busy.is_moving'


class RootLuRamp_generatorAlternate_zBusy(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.alternate_z.busy'
        self.is_moving = RootLuRamp_generatorAlternate_zBusyIs_moving(self._context)


class RootLuRamp_generatorAlternate_zAttributeStatusEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.alternate_z.attribute.status.enum'

    @property
    def reached_lower_limit(self) -> int:
        return int(self._context.get('root.lu.ramp_generator.alternate_z.attribute.status.enum.reached_lower_limit'))

    @reached_lower_limit.setter
    def reached_lower_limit(self, new_val:int):
        self._context.set('root.lu.ramp_generator.alternate_z.attribute.status.enum.reached_lower_limit', int(new_val))

    @property
    def is_moving(self) -> int:
        return int(self._context.get('root.lu.ramp_generator.alternate_z.attribute.status.enum.is_moving'))

    @is_moving.setter
    def is_moving(self, new_val:int):
        self._context.set('root.lu.ramp_generator.alternate_z.attribute.status.enum.is_moving', int(new_val))

    @property
    def reached_upper_limit(self) -> int:
        return int(self._context.get('root.lu.ramp_generator.alternate_z.attribute.status.enum.reached_upper_limit'))

    @reached_upper_limit.setter
    def reached_upper_limit(self, new_val:int):
        self._context.set('root.lu.ramp_generator.alternate_z.attribute.status.enum.reached_upper_limit', int(new_val))

    @property
    def reached_endposition(self) -> int:
        return int(self._context.get('root.lu.ramp_generator.alternate_z.attribute.status.enum.reached_endposition'))

    @reached_endposition.setter
    def reached_endposition(self, new_val:int):
        self._context.set('root.lu.ramp_generator.alternate_z.attribute.status.enum.reached_endposition', int(new_val))

    @property
    def stopped_by_external_event(self) -> int:
        return int(self._context.get('root.lu.ramp_generator.alternate_z.attribute.status.enum.stopped_by_external_event'))

    @stopped_by_external_event.setter
    def stopped_by_external_event(self, new_val:int):
        self._context.set('root.lu.ramp_generator.alternate_z.attribute.status.enum.stopped_by_external_event', int(new_val))


class RootLuRamp_generatorAlternate_zAttributeStatus(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.alternate_z.attribute.status'
        self.enum = RootLuRamp_generatorAlternate_zAttributeStatusEnum(self._context)


class RootLuRamp_generatorAlternate_zAttributeMoving_modeEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.alternate_z.attribute.moving_mode.enum'

    @property
    def fix_time(self) -> int:
        return int(self._context.get('root.lu.ramp_generator.alternate_z.attribute.moving_mode.enum.fix_time'))

    @fix_time.setter
    def fix_time(self, new_val:int):
        self._context.set('root.lu.ramp_generator.alternate_z.attribute.moving_mode.enum.fix_time', int(new_val))

    @property
    def fix_speed(self) -> int:
        return int(self._context.get('root.lu.ramp_generator.alternate_z.attribute.moving_mode.enum.fix_speed'))

    @fix_speed.setter
    def fix_speed(self, new_val:int):
        self._context.set('root.lu.ramp_generator.alternate_z.attribute.moving_mode.enum.fix_speed', int(new_val))


class RootLuRamp_generatorAlternate_zAttributeMoving_mode(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.alternate_z.attribute.moving_mode'
        self.enum = RootLuRamp_generatorAlternate_zAttributeMoving_modeEnum(self._context)


class RootLuRamp_generatorAlternate_zAttributeEnd_value_relative(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.alternate_z.attribute.end_value_relative'


class RootLuRamp_generatorAlternate_zAttributeMoving_time(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.alternate_z.attribute.moving_time'


class RootLuRamp_generatorAlternate_zAttributeEnd_value_absolute(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.alternate_z.attribute.end_value_absolute'


class RootLuRamp_generatorAlternate_zAttributeUpper_limit(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.alternate_z.attribute.upper_limit'


class RootLuRamp_generatorAlternate_zAttributeLower_limit(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.alternate_z.attribute.lower_limit'


class RootLuRamp_generatorAlternate_zAttributeCurrent_value(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.alternate_z.attribute.current_value'


class RootLuRamp_generatorAlternate_zAttributeEnd_value_modeEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.alternate_z.attribute.end_value_mode.enum'

    @property
    def move_relative(self) -> int:
        return int(self._context.get('root.lu.ramp_generator.alternate_z.attribute.end_value_mode.enum.move_relative'))

    @move_relative.setter
    def move_relative(self, new_val:int):
        self._context.set('root.lu.ramp_generator.alternate_z.attribute.end_value_mode.enum.move_relative', int(new_val))

    @property
    def move_to_absolute(self) -> int:
        return int(self._context.get('root.lu.ramp_generator.alternate_z.attribute.end_value_mode.enum.move_to_absolute'))

    @move_to_absolute.setter
    def move_to_absolute(self, new_val:int):
        self._context.set('root.lu.ramp_generator.alternate_z.attribute.end_value_mode.enum.move_to_absolute', int(new_val))


class RootLuRamp_generatorAlternate_zAttributeEnd_value_mode(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.alternate_z.attribute.end_value_mode'
        self.enum = RootLuRamp_generatorAlternate_zAttributeEnd_value_modeEnum(self._context)


class RootLuRamp_generatorAlternate_zAttributeMoving_speed(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.alternate_z.attribute.moving_speed'


class RootLuRamp_generatorAlternate_zAttribute(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.alternate_z.attribute'
        self.moving_speed = RootLuRamp_generatorAlternate_zAttributeMoving_speed(self._context)
        self.end_value_mode = RootLuRamp_generatorAlternate_zAttributeEnd_value_mode(self._context)
        self.current_value = RootLuRamp_generatorAlternate_zAttributeCurrent_value(self._context)
        self.lower_limit = RootLuRamp_generatorAlternate_zAttributeLower_limit(self._context)
        self.upper_limit = RootLuRamp_generatorAlternate_zAttributeUpper_limit(self._context)
        self.end_value_absolute = RootLuRamp_generatorAlternate_zAttributeEnd_value_absolute(self._context)
        self.moving_time = RootLuRamp_generatorAlternate_zAttributeMoving_time(self._context)
        self.end_value_relative = RootLuRamp_generatorAlternate_zAttributeEnd_value_relative(self._context)
        self.moving_mode = RootLuRamp_generatorAlternate_zAttributeMoving_mode(self._context)
        self.status = RootLuRamp_generatorAlternate_zAttributeStatus(self._context)


class RootLuRamp_generatorAlternate_zTriggerStart(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.alternate_z.trigger.start'


class RootLuRamp_generatorAlternate_zTriggerAbort(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.alternate_z.trigger.abort'


class RootLuRamp_generatorAlternate_zTriggerPrepare(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.alternate_z.trigger.prepare'


class RootLuRamp_generatorAlternate_zTriggerStop(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.alternate_z.trigger.stop'


class RootLuRamp_generatorAlternate_zTrigger(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.alternate_z.trigger'
        self.stop = RootLuRamp_generatorAlternate_zTriggerStop(self._context)
        self.prepare = RootLuRamp_generatorAlternate_zTriggerPrepare(self._context)
        self.abort = RootLuRamp_generatorAlternate_zTriggerAbort(self._context)
        self.start = RootLuRamp_generatorAlternate_zTriggerStart(self._context)


class RootLuRamp_generatorAlternate_z(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.alternate_z'
        self.trigger = RootLuRamp_generatorAlternate_zTrigger(self._context)
        self.attribute = RootLuRamp_generatorAlternate_zAttribute(self._context)
        self.busy = RootLuRamp_generatorAlternate_zBusy(self._context)


class RootLuRamp_generatorUser1BusyIs_moving(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.user1.busy.is_moving'


class RootLuRamp_generatorUser1Busy(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.user1.busy'
        self.is_moving = RootLuRamp_generatorUser1BusyIs_moving(self._context)


class RootLuRamp_generatorUser1AttributeStatusEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.user1.attribute.status.enum'

    @property
    def reached_lower_limit(self) -> int:
        return int(self._context.get('root.lu.ramp_generator.user1.attribute.status.enum.reached_lower_limit'))

    @reached_lower_limit.setter
    def reached_lower_limit(self, new_val:int):
        self._context.set('root.lu.ramp_generator.user1.attribute.status.enum.reached_lower_limit', int(new_val))

    @property
    def is_moving(self) -> int:
        return int(self._context.get('root.lu.ramp_generator.user1.attribute.status.enum.is_moving'))

    @is_moving.setter
    def is_moving(self, new_val:int):
        self._context.set('root.lu.ramp_generator.user1.attribute.status.enum.is_moving', int(new_val))

    @property
    def reached_upper_limit(self) -> int:
        return int(self._context.get('root.lu.ramp_generator.user1.attribute.status.enum.reached_upper_limit'))

    @reached_upper_limit.setter
    def reached_upper_limit(self, new_val:int):
        self._context.set('root.lu.ramp_generator.user1.attribute.status.enum.reached_upper_limit', int(new_val))

    @property
    def reached_endposition(self) -> int:
        return int(self._context.get('root.lu.ramp_generator.user1.attribute.status.enum.reached_endposition'))

    @reached_endposition.setter
    def reached_endposition(self, new_val:int):
        self._context.set('root.lu.ramp_generator.user1.attribute.status.enum.reached_endposition', int(new_val))

    @property
    def stopped_by_external_event(self) -> int:
        return int(self._context.get('root.lu.ramp_generator.user1.attribute.status.enum.stopped_by_external_event'))

    @stopped_by_external_event.setter
    def stopped_by_external_event(self, new_val:int):
        self._context.set('root.lu.ramp_generator.user1.attribute.status.enum.stopped_by_external_event', int(new_val))


class RootLuRamp_generatorUser1AttributeStatus(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.user1.attribute.status'
        self.enum = RootLuRamp_generatorUser1AttributeStatusEnum(self._context)


class RootLuRamp_generatorUser1AttributeMoving_modeEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.user1.attribute.moving_mode.enum'

    @property
    def fix_time(self) -> int:
        return int(self._context.get('root.lu.ramp_generator.user1.attribute.moving_mode.enum.fix_time'))

    @fix_time.setter
    def fix_time(self, new_val:int):
        self._context.set('root.lu.ramp_generator.user1.attribute.moving_mode.enum.fix_time', int(new_val))

    @property
    def fix_speed(self) -> int:
        return int(self._context.get('root.lu.ramp_generator.user1.attribute.moving_mode.enum.fix_speed'))

    @fix_speed.setter
    def fix_speed(self, new_val:int):
        self._context.set('root.lu.ramp_generator.user1.attribute.moving_mode.enum.fix_speed', int(new_val))


class RootLuRamp_generatorUser1AttributeMoving_mode(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.user1.attribute.moving_mode'
        self.enum = RootLuRamp_generatorUser1AttributeMoving_modeEnum(self._context)


class RootLuRamp_generatorUser1AttributeEnd_value_relative(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.user1.attribute.end_value_relative'


class RootLuRamp_generatorUser1AttributeMoving_time(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.user1.attribute.moving_time'


class RootLuRamp_generatorUser1AttributeEnd_value_absolute(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.user1.attribute.end_value_absolute'


class RootLuRamp_generatorUser1AttributeUpper_limit(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.user1.attribute.upper_limit'


class RootLuRamp_generatorUser1AttributeLower_limit(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.user1.attribute.lower_limit'


class RootLuRamp_generatorUser1AttributeCurrent_value(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.user1.attribute.current_value'


class RootLuRamp_generatorUser1AttributeEnd_value_modeEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.user1.attribute.end_value_mode.enum'

    @property
    def move_relative(self) -> int:
        return int(self._context.get('root.lu.ramp_generator.user1.attribute.end_value_mode.enum.move_relative'))

    @move_relative.setter
    def move_relative(self, new_val:int):
        self._context.set('root.lu.ramp_generator.user1.attribute.end_value_mode.enum.move_relative', int(new_val))

    @property
    def move_to_absolute(self) -> int:
        return int(self._context.get('root.lu.ramp_generator.user1.attribute.end_value_mode.enum.move_to_absolute'))

    @move_to_absolute.setter
    def move_to_absolute(self, new_val:int):
        self._context.set('root.lu.ramp_generator.user1.attribute.end_value_mode.enum.move_to_absolute', int(new_val))


class RootLuRamp_generatorUser1AttributeEnd_value_mode(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.user1.attribute.end_value_mode'
        self.enum = RootLuRamp_generatorUser1AttributeEnd_value_modeEnum(self._context)


class RootLuRamp_generatorUser1AttributeMoving_speed(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.user1.attribute.moving_speed'


class RootLuRamp_generatorUser1Attribute(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.user1.attribute'
        self.moving_speed = RootLuRamp_generatorUser1AttributeMoving_speed(self._context)
        self.end_value_mode = RootLuRamp_generatorUser1AttributeEnd_value_mode(self._context)
        self.current_value = RootLuRamp_generatorUser1AttributeCurrent_value(self._context)
        self.lower_limit = RootLuRamp_generatorUser1AttributeLower_limit(self._context)
        self.upper_limit = RootLuRamp_generatorUser1AttributeUpper_limit(self._context)
        self.end_value_absolute = RootLuRamp_generatorUser1AttributeEnd_value_absolute(self._context)
        self.moving_time = RootLuRamp_generatorUser1AttributeMoving_time(self._context)
        self.end_value_relative = RootLuRamp_generatorUser1AttributeEnd_value_relative(self._context)
        self.moving_mode = RootLuRamp_generatorUser1AttributeMoving_mode(self._context)
        self.status = RootLuRamp_generatorUser1AttributeStatus(self._context)


class RootLuRamp_generatorUser1TriggerStart(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.user1.trigger.start'


class RootLuRamp_generatorUser1TriggerAbort(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.user1.trigger.abort'


class RootLuRamp_generatorUser1TriggerPrepare(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.user1.trigger.prepare'


class RootLuRamp_generatorUser1TriggerStop(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.user1.trigger.stop'


class RootLuRamp_generatorUser1Trigger(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.user1.trigger'
        self.stop = RootLuRamp_generatorUser1TriggerStop(self._context)
        self.prepare = RootLuRamp_generatorUser1TriggerPrepare(self._context)
        self.abort = RootLuRamp_generatorUser1TriggerAbort(self._context)
        self.start = RootLuRamp_generatorUser1TriggerStart(self._context)


class RootLuRamp_generatorUser1(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.user1'
        self.trigger = RootLuRamp_generatorUser1Trigger(self._context)
        self.attribute = RootLuRamp_generatorUser1Attribute(self._context)
        self.busy = RootLuRamp_generatorUser1Busy(self._context)


class RootLuRamp_generatorVirtual1BusyIs_moving(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.virtual1.busy.is_moving'


class RootLuRamp_generatorVirtual1Busy(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.virtual1.busy'
        self.is_moving = RootLuRamp_generatorVirtual1BusyIs_moving(self._context)


class RootLuRamp_generatorVirtual1AttributeStatusEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.virtual1.attribute.status.enum'

    @property
    def reached_lower_limit(self) -> int:
        return int(self._context.get('root.lu.ramp_generator.virtual1.attribute.status.enum.reached_lower_limit'))

    @reached_lower_limit.setter
    def reached_lower_limit(self, new_val:int):
        self._context.set('root.lu.ramp_generator.virtual1.attribute.status.enum.reached_lower_limit', int(new_val))

    @property
    def is_moving(self) -> int:
        return int(self._context.get('root.lu.ramp_generator.virtual1.attribute.status.enum.is_moving'))

    @is_moving.setter
    def is_moving(self, new_val:int):
        self._context.set('root.lu.ramp_generator.virtual1.attribute.status.enum.is_moving', int(new_val))

    @property
    def reached_upper_limit(self) -> int:
        return int(self._context.get('root.lu.ramp_generator.virtual1.attribute.status.enum.reached_upper_limit'))

    @reached_upper_limit.setter
    def reached_upper_limit(self, new_val:int):
        self._context.set('root.lu.ramp_generator.virtual1.attribute.status.enum.reached_upper_limit', int(new_val))

    @property
    def reached_endposition(self) -> int:
        return int(self._context.get('root.lu.ramp_generator.virtual1.attribute.status.enum.reached_endposition'))

    @reached_endposition.setter
    def reached_endposition(self, new_val:int):
        self._context.set('root.lu.ramp_generator.virtual1.attribute.status.enum.reached_endposition', int(new_val))

    @property
    def stopped_by_external_event(self) -> int:
        return int(self._context.get('root.lu.ramp_generator.virtual1.attribute.status.enum.stopped_by_external_event'))

    @stopped_by_external_event.setter
    def stopped_by_external_event(self, new_val:int):
        self._context.set('root.lu.ramp_generator.virtual1.attribute.status.enum.stopped_by_external_event', int(new_val))


class RootLuRamp_generatorVirtual1AttributeStatus(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.virtual1.attribute.status'
        self.enum = RootLuRamp_generatorVirtual1AttributeStatusEnum(self._context)


class RootLuRamp_generatorVirtual1AttributeMoving_modeEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.virtual1.attribute.moving_mode.enum'

    @property
    def fix_time(self) -> int:
        return int(self._context.get('root.lu.ramp_generator.virtual1.attribute.moving_mode.enum.fix_time'))

    @fix_time.setter
    def fix_time(self, new_val:int):
        self._context.set('root.lu.ramp_generator.virtual1.attribute.moving_mode.enum.fix_time', int(new_val))

    @property
    def fix_speed(self) -> int:
        return int(self._context.get('root.lu.ramp_generator.virtual1.attribute.moving_mode.enum.fix_speed'))

    @fix_speed.setter
    def fix_speed(self, new_val:int):
        self._context.set('root.lu.ramp_generator.virtual1.attribute.moving_mode.enum.fix_speed', int(new_val))


class RootLuRamp_generatorVirtual1AttributeMoving_mode(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.virtual1.attribute.moving_mode'
        self.enum = RootLuRamp_generatorVirtual1AttributeMoving_modeEnum(self._context)


class RootLuRamp_generatorVirtual1AttributeEnd_value_relative(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.virtual1.attribute.end_value_relative'


class RootLuRamp_generatorVirtual1AttributeMoving_time(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.virtual1.attribute.moving_time'


class RootLuRamp_generatorVirtual1AttributeEnd_value_absolute(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.virtual1.attribute.end_value_absolute'


class RootLuRamp_generatorVirtual1AttributeUpper_limit(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.virtual1.attribute.upper_limit'


class RootLuRamp_generatorVirtual1AttributeLower_limit(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.virtual1.attribute.lower_limit'


class RootLuRamp_generatorVirtual1AttributeCurrent_value(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.virtual1.attribute.current_value'


class RootLuRamp_generatorVirtual1AttributeEnd_value_modeEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.virtual1.attribute.end_value_mode.enum'

    @property
    def move_relative(self) -> int:
        return int(self._context.get('root.lu.ramp_generator.virtual1.attribute.end_value_mode.enum.move_relative'))

    @move_relative.setter
    def move_relative(self, new_val:int):
        self._context.set('root.lu.ramp_generator.virtual1.attribute.end_value_mode.enum.move_relative', int(new_val))

    @property
    def move_to_absolute(self) -> int:
        return int(self._context.get('root.lu.ramp_generator.virtual1.attribute.end_value_mode.enum.move_to_absolute'))

    @move_to_absolute.setter
    def move_to_absolute(self, new_val:int):
        self._context.set('root.lu.ramp_generator.virtual1.attribute.end_value_mode.enum.move_to_absolute', int(new_val))


class RootLuRamp_generatorVirtual1AttributeEnd_value_mode(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.virtual1.attribute.end_value_mode'
        self.enum = RootLuRamp_generatorVirtual1AttributeEnd_value_modeEnum(self._context)


class RootLuRamp_generatorVirtual1AttributeMoving_speed(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.virtual1.attribute.moving_speed'


class RootLuRamp_generatorVirtual1Attribute(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.virtual1.attribute'
        self.moving_speed = RootLuRamp_generatorVirtual1AttributeMoving_speed(self._context)
        self.end_value_mode = RootLuRamp_generatorVirtual1AttributeEnd_value_mode(self._context)
        self.current_value = RootLuRamp_generatorVirtual1AttributeCurrent_value(self._context)
        self.lower_limit = RootLuRamp_generatorVirtual1AttributeLower_limit(self._context)
        self.upper_limit = RootLuRamp_generatorVirtual1AttributeUpper_limit(self._context)
        self.end_value_absolute = RootLuRamp_generatorVirtual1AttributeEnd_value_absolute(self._context)
        self.moving_time = RootLuRamp_generatorVirtual1AttributeMoving_time(self._context)
        self.end_value_relative = RootLuRamp_generatorVirtual1AttributeEnd_value_relative(self._context)
        self.moving_mode = RootLuRamp_generatorVirtual1AttributeMoving_mode(self._context)
        self.status = RootLuRamp_generatorVirtual1AttributeStatus(self._context)


class RootLuRamp_generatorVirtual1TriggerStart(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.virtual1.trigger.start'


class RootLuRamp_generatorVirtual1TriggerAbort(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.virtual1.trigger.abort'


class RootLuRamp_generatorVirtual1TriggerPrepare(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.virtual1.trigger.prepare'


class RootLuRamp_generatorVirtual1TriggerStop(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.virtual1.trigger.stop'


class RootLuRamp_generatorVirtual1Trigger(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.virtual1.trigger'
        self.stop = RootLuRamp_generatorVirtual1TriggerStop(self._context)
        self.prepare = RootLuRamp_generatorVirtual1TriggerPrepare(self._context)
        self.abort = RootLuRamp_generatorVirtual1TriggerAbort(self._context)
        self.start = RootLuRamp_generatorVirtual1TriggerStart(self._context)


class RootLuRamp_generatorVirtual1(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.virtual1'
        self.trigger = RootLuRamp_generatorVirtual1Trigger(self._context)
        self.attribute = RootLuRamp_generatorVirtual1Attribute(self._context)
        self.busy = RootLuRamp_generatorVirtual1Busy(self._context)


class RootLuRamp_generatorApproachBusyIs_moving(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.approach.busy.is_moving'


class RootLuRamp_generatorApproachBusy(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.approach.busy'
        self.is_moving = RootLuRamp_generatorApproachBusyIs_moving(self._context)


class RootLuRamp_generatorApproachAttributeStatusEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.approach.attribute.status.enum'

    @property
    def reached_lower_limit(self) -> int:
        return int(self._context.get('root.lu.ramp_generator.approach.attribute.status.enum.reached_lower_limit'))

    @reached_lower_limit.setter
    def reached_lower_limit(self, new_val:int):
        self._context.set('root.lu.ramp_generator.approach.attribute.status.enum.reached_lower_limit', int(new_val))

    @property
    def is_moving(self) -> int:
        return int(self._context.get('root.lu.ramp_generator.approach.attribute.status.enum.is_moving'))

    @is_moving.setter
    def is_moving(self, new_val:int):
        self._context.set('root.lu.ramp_generator.approach.attribute.status.enum.is_moving', int(new_val))

    @property
    def reached_upper_limit(self) -> int:
        return int(self._context.get('root.lu.ramp_generator.approach.attribute.status.enum.reached_upper_limit'))

    @reached_upper_limit.setter
    def reached_upper_limit(self, new_val:int):
        self._context.set('root.lu.ramp_generator.approach.attribute.status.enum.reached_upper_limit', int(new_val))

    @property
    def reached_endposition(self) -> int:
        return int(self._context.get('root.lu.ramp_generator.approach.attribute.status.enum.reached_endposition'))

    @reached_endposition.setter
    def reached_endposition(self, new_val:int):
        self._context.set('root.lu.ramp_generator.approach.attribute.status.enum.reached_endposition', int(new_val))

    @property
    def stopped_by_external_event(self) -> int:
        return int(self._context.get('root.lu.ramp_generator.approach.attribute.status.enum.stopped_by_external_event'))

    @stopped_by_external_event.setter
    def stopped_by_external_event(self, new_val:int):
        self._context.set('root.lu.ramp_generator.approach.attribute.status.enum.stopped_by_external_event', int(new_val))


class RootLuRamp_generatorApproachAttributeStatus(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.approach.attribute.status'
        self.enum = RootLuRamp_generatorApproachAttributeStatusEnum(self._context)


class RootLuRamp_generatorApproachAttributeMoving_modeEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.approach.attribute.moving_mode.enum'

    @property
    def fix_time(self) -> int:
        return int(self._context.get('root.lu.ramp_generator.approach.attribute.moving_mode.enum.fix_time'))

    @fix_time.setter
    def fix_time(self, new_val:int):
        self._context.set('root.lu.ramp_generator.approach.attribute.moving_mode.enum.fix_time', int(new_val))

    @property
    def fix_speed(self) -> int:
        return int(self._context.get('root.lu.ramp_generator.approach.attribute.moving_mode.enum.fix_speed'))

    @fix_speed.setter
    def fix_speed(self, new_val:int):
        self._context.set('root.lu.ramp_generator.approach.attribute.moving_mode.enum.fix_speed', int(new_val))


class RootLuRamp_generatorApproachAttributeMoving_mode(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.approach.attribute.moving_mode'
        self.enum = RootLuRamp_generatorApproachAttributeMoving_modeEnum(self._context)


class RootLuRamp_generatorApproachAttributeEnd_value_relative(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.approach.attribute.end_value_relative'


class RootLuRamp_generatorApproachAttributeMoving_time(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.approach.attribute.moving_time'


class RootLuRamp_generatorApproachAttributeEnd_value_absolute(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.approach.attribute.end_value_absolute'


class RootLuRamp_generatorApproachAttributeUpper_limit(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.approach.attribute.upper_limit'


class RootLuRamp_generatorApproachAttributeLower_limit(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.approach.attribute.lower_limit'


class RootLuRamp_generatorApproachAttributeCurrent_value(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.approach.attribute.current_value'


class RootLuRamp_generatorApproachAttributeEnd_value_modeEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.approach.attribute.end_value_mode.enum'

    @property
    def move_relative(self) -> int:
        return int(self._context.get('root.lu.ramp_generator.approach.attribute.end_value_mode.enum.move_relative'))

    @move_relative.setter
    def move_relative(self, new_val:int):
        self._context.set('root.lu.ramp_generator.approach.attribute.end_value_mode.enum.move_relative', int(new_val))

    @property
    def move_to_absolute(self) -> int:
        return int(self._context.get('root.lu.ramp_generator.approach.attribute.end_value_mode.enum.move_to_absolute'))

    @move_to_absolute.setter
    def move_to_absolute(self, new_val:int):
        self._context.set('root.lu.ramp_generator.approach.attribute.end_value_mode.enum.move_to_absolute', int(new_val))


class RootLuRamp_generatorApproachAttributeEnd_value_mode(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.approach.attribute.end_value_mode'
        self.enum = RootLuRamp_generatorApproachAttributeEnd_value_modeEnum(self._context)


class RootLuRamp_generatorApproachAttributeMoving_speed(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.approach.attribute.moving_speed'


class RootLuRamp_generatorApproachAttribute(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.approach.attribute'
        self.moving_speed = RootLuRamp_generatorApproachAttributeMoving_speed(self._context)
        self.end_value_mode = RootLuRamp_generatorApproachAttributeEnd_value_mode(self._context)
        self.current_value = RootLuRamp_generatorApproachAttributeCurrent_value(self._context)
        self.lower_limit = RootLuRamp_generatorApproachAttributeLower_limit(self._context)
        self.upper_limit = RootLuRamp_generatorApproachAttributeUpper_limit(self._context)
        self.end_value_absolute = RootLuRamp_generatorApproachAttributeEnd_value_absolute(self._context)
        self.moving_time = RootLuRamp_generatorApproachAttributeMoving_time(self._context)
        self.end_value_relative = RootLuRamp_generatorApproachAttributeEnd_value_relative(self._context)
        self.moving_mode = RootLuRamp_generatorApproachAttributeMoving_mode(self._context)
        self.status = RootLuRamp_generatorApproachAttributeStatus(self._context)


class RootLuRamp_generatorApproachTriggerStart(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.approach.trigger.start'


class RootLuRamp_generatorApproachTriggerAbort(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.approach.trigger.abort'


class RootLuRamp_generatorApproachTriggerPrepare(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.approach.trigger.prepare'


class RootLuRamp_generatorApproachTriggerStop(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.approach.trigger.stop'


class RootLuRamp_generatorApproachTrigger(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.approach.trigger'
        self.stop = RootLuRamp_generatorApproachTriggerStop(self._context)
        self.prepare = RootLuRamp_generatorApproachTriggerPrepare(self._context)
        self.abort = RootLuRamp_generatorApproachTriggerAbort(self._context)
        self.start = RootLuRamp_generatorApproachTriggerStart(self._context)


class RootLuRamp_generatorApproach(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.approach'
        self.trigger = RootLuRamp_generatorApproachTrigger(self._context)
        self.attribute = RootLuRamp_generatorApproachAttribute(self._context)
        self.busy = RootLuRamp_generatorApproachBusy(self._context)


class RootLuRamp_generatorUser4BusyIs_moving(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.user4.busy.is_moving'


class RootLuRamp_generatorUser4Busy(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.user4.busy'
        self.is_moving = RootLuRamp_generatorUser4BusyIs_moving(self._context)


class RootLuRamp_generatorUser4AttributeStatusEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.user4.attribute.status.enum'

    @property
    def reached_lower_limit(self) -> int:
        return int(self._context.get('root.lu.ramp_generator.user4.attribute.status.enum.reached_lower_limit'))

    @reached_lower_limit.setter
    def reached_lower_limit(self, new_val:int):
        self._context.set('root.lu.ramp_generator.user4.attribute.status.enum.reached_lower_limit', int(new_val))

    @property
    def is_moving(self) -> int:
        return int(self._context.get('root.lu.ramp_generator.user4.attribute.status.enum.is_moving'))

    @is_moving.setter
    def is_moving(self, new_val:int):
        self._context.set('root.lu.ramp_generator.user4.attribute.status.enum.is_moving', int(new_val))

    @property
    def reached_upper_limit(self) -> int:
        return int(self._context.get('root.lu.ramp_generator.user4.attribute.status.enum.reached_upper_limit'))

    @reached_upper_limit.setter
    def reached_upper_limit(self, new_val:int):
        self._context.set('root.lu.ramp_generator.user4.attribute.status.enum.reached_upper_limit', int(new_val))

    @property
    def reached_endposition(self) -> int:
        return int(self._context.get('root.lu.ramp_generator.user4.attribute.status.enum.reached_endposition'))

    @reached_endposition.setter
    def reached_endposition(self, new_val:int):
        self._context.set('root.lu.ramp_generator.user4.attribute.status.enum.reached_endposition', int(new_val))

    @property
    def stopped_by_external_event(self) -> int:
        return int(self._context.get('root.lu.ramp_generator.user4.attribute.status.enum.stopped_by_external_event'))

    @stopped_by_external_event.setter
    def stopped_by_external_event(self, new_val:int):
        self._context.set('root.lu.ramp_generator.user4.attribute.status.enum.stopped_by_external_event', int(new_val))


class RootLuRamp_generatorUser4AttributeStatus(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.user4.attribute.status'
        self.enum = RootLuRamp_generatorUser4AttributeStatusEnum(self._context)


class RootLuRamp_generatorUser4AttributeMoving_modeEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.user4.attribute.moving_mode.enum'

    @property
    def fix_time(self) -> int:
        return int(self._context.get('root.lu.ramp_generator.user4.attribute.moving_mode.enum.fix_time'))

    @fix_time.setter
    def fix_time(self, new_val:int):
        self._context.set('root.lu.ramp_generator.user4.attribute.moving_mode.enum.fix_time', int(new_val))

    @property
    def fix_speed(self) -> int:
        return int(self._context.get('root.lu.ramp_generator.user4.attribute.moving_mode.enum.fix_speed'))

    @fix_speed.setter
    def fix_speed(self, new_val:int):
        self._context.set('root.lu.ramp_generator.user4.attribute.moving_mode.enum.fix_speed', int(new_val))


class RootLuRamp_generatorUser4AttributeMoving_mode(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.user4.attribute.moving_mode'
        self.enum = RootLuRamp_generatorUser4AttributeMoving_modeEnum(self._context)


class RootLuRamp_generatorUser4AttributeEnd_value_relative(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.user4.attribute.end_value_relative'


class RootLuRamp_generatorUser4AttributeMoving_time(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.user4.attribute.moving_time'


class RootLuRamp_generatorUser4AttributeEnd_value_absolute(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.user4.attribute.end_value_absolute'


class RootLuRamp_generatorUser4AttributeUpper_limit(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.user4.attribute.upper_limit'


class RootLuRamp_generatorUser4AttributeLower_limit(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.user4.attribute.lower_limit'


class RootLuRamp_generatorUser4AttributeCurrent_value(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.user4.attribute.current_value'


class RootLuRamp_generatorUser4AttributeEnd_value_modeEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.user4.attribute.end_value_mode.enum'

    @property
    def move_relative(self) -> int:
        return int(self._context.get('root.lu.ramp_generator.user4.attribute.end_value_mode.enum.move_relative'))

    @move_relative.setter
    def move_relative(self, new_val:int):
        self._context.set('root.lu.ramp_generator.user4.attribute.end_value_mode.enum.move_relative', int(new_val))

    @property
    def move_to_absolute(self) -> int:
        return int(self._context.get('root.lu.ramp_generator.user4.attribute.end_value_mode.enum.move_to_absolute'))

    @move_to_absolute.setter
    def move_to_absolute(self, new_val:int):
        self._context.set('root.lu.ramp_generator.user4.attribute.end_value_mode.enum.move_to_absolute', int(new_val))


class RootLuRamp_generatorUser4AttributeEnd_value_mode(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.user4.attribute.end_value_mode'
        self.enum = RootLuRamp_generatorUser4AttributeEnd_value_modeEnum(self._context)


class RootLuRamp_generatorUser4AttributeMoving_speed(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.user4.attribute.moving_speed'


class RootLuRamp_generatorUser4Attribute(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.user4.attribute'
        self.moving_speed = RootLuRamp_generatorUser4AttributeMoving_speed(self._context)
        self.end_value_mode = RootLuRamp_generatorUser4AttributeEnd_value_mode(self._context)
        self.current_value = RootLuRamp_generatorUser4AttributeCurrent_value(self._context)
        self.lower_limit = RootLuRamp_generatorUser4AttributeLower_limit(self._context)
        self.upper_limit = RootLuRamp_generatorUser4AttributeUpper_limit(self._context)
        self.end_value_absolute = RootLuRamp_generatorUser4AttributeEnd_value_absolute(self._context)
        self.moving_time = RootLuRamp_generatorUser4AttributeMoving_time(self._context)
        self.end_value_relative = RootLuRamp_generatorUser4AttributeEnd_value_relative(self._context)
        self.moving_mode = RootLuRamp_generatorUser4AttributeMoving_mode(self._context)
        self.status = RootLuRamp_generatorUser4AttributeStatus(self._context)


class RootLuRamp_generatorUser4TriggerStart(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.user4.trigger.start'


class RootLuRamp_generatorUser4TriggerAbort(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.user4.trigger.abort'


class RootLuRamp_generatorUser4TriggerPrepare(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.user4.trigger.prepare'


class RootLuRamp_generatorUser4TriggerStop(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.user4.trigger.stop'


class RootLuRamp_generatorUser4Trigger(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.user4.trigger'
        self.stop = RootLuRamp_generatorUser4TriggerStop(self._context)
        self.prepare = RootLuRamp_generatorUser4TriggerPrepare(self._context)
        self.abort = RootLuRamp_generatorUser4TriggerAbort(self._context)
        self.start = RootLuRamp_generatorUser4TriggerStart(self._context)


class RootLuRamp_generatorUser4(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.user4'
        self.trigger = RootLuRamp_generatorUser4Trigger(self._context)
        self.attribute = RootLuRamp_generatorUser4Attribute(self._context)
        self.busy = RootLuRamp_generatorUser4Busy(self._context)


class RootLuRamp_generatorPosition_yBusyIs_moving(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.position_y.busy.is_moving'


class RootLuRamp_generatorPosition_yBusy(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.position_y.busy'
        self.is_moving = RootLuRamp_generatorPosition_yBusyIs_moving(self._context)


class RootLuRamp_generatorPosition_yAttributeStatusEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.position_y.attribute.status.enum'

    @property
    def reached_lower_limit(self) -> int:
        return int(self._context.get('root.lu.ramp_generator.position_y.attribute.status.enum.reached_lower_limit'))

    @reached_lower_limit.setter
    def reached_lower_limit(self, new_val:int):
        self._context.set('root.lu.ramp_generator.position_y.attribute.status.enum.reached_lower_limit', int(new_val))

    @property
    def is_moving(self) -> int:
        return int(self._context.get('root.lu.ramp_generator.position_y.attribute.status.enum.is_moving'))

    @is_moving.setter
    def is_moving(self, new_val:int):
        self._context.set('root.lu.ramp_generator.position_y.attribute.status.enum.is_moving', int(new_val))

    @property
    def reached_upper_limit(self) -> int:
        return int(self._context.get('root.lu.ramp_generator.position_y.attribute.status.enum.reached_upper_limit'))

    @reached_upper_limit.setter
    def reached_upper_limit(self, new_val:int):
        self._context.set('root.lu.ramp_generator.position_y.attribute.status.enum.reached_upper_limit', int(new_val))

    @property
    def reached_endposition(self) -> int:
        return int(self._context.get('root.lu.ramp_generator.position_y.attribute.status.enum.reached_endposition'))

    @reached_endposition.setter
    def reached_endposition(self, new_val:int):
        self._context.set('root.lu.ramp_generator.position_y.attribute.status.enum.reached_endposition', int(new_val))

    @property
    def stopped_by_external_event(self) -> int:
        return int(self._context.get('root.lu.ramp_generator.position_y.attribute.status.enum.stopped_by_external_event'))

    @stopped_by_external_event.setter
    def stopped_by_external_event(self, new_val:int):
        self._context.set('root.lu.ramp_generator.position_y.attribute.status.enum.stopped_by_external_event', int(new_val))


class RootLuRamp_generatorPosition_yAttributeStatus(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.position_y.attribute.status'
        self.enum = RootLuRamp_generatorPosition_yAttributeStatusEnum(self._context)


class RootLuRamp_generatorPosition_yAttributeMoving_modeEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.position_y.attribute.moving_mode.enum'

    @property
    def fix_time(self) -> int:
        return int(self._context.get('root.lu.ramp_generator.position_y.attribute.moving_mode.enum.fix_time'))

    @fix_time.setter
    def fix_time(self, new_val:int):
        self._context.set('root.lu.ramp_generator.position_y.attribute.moving_mode.enum.fix_time', int(new_val))

    @property
    def fix_speed(self) -> int:
        return int(self._context.get('root.lu.ramp_generator.position_y.attribute.moving_mode.enum.fix_speed'))

    @fix_speed.setter
    def fix_speed(self, new_val:int):
        self._context.set('root.lu.ramp_generator.position_y.attribute.moving_mode.enum.fix_speed', int(new_val))


class RootLuRamp_generatorPosition_yAttributeMoving_mode(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.position_y.attribute.moving_mode'
        self.enum = RootLuRamp_generatorPosition_yAttributeMoving_modeEnum(self._context)


class RootLuRamp_generatorPosition_yAttributeEnd_value_relative(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.position_y.attribute.end_value_relative'


class RootLuRamp_generatorPosition_yAttributeMoving_time(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.position_y.attribute.moving_time'


class RootLuRamp_generatorPosition_yAttributeEnd_value_absolute(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.position_y.attribute.end_value_absolute'


class RootLuRamp_generatorPosition_yAttributeUpper_limit(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.position_y.attribute.upper_limit'


class RootLuRamp_generatorPosition_yAttributeLower_limit(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.position_y.attribute.lower_limit'


class RootLuRamp_generatorPosition_yAttributeCurrent_value(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.position_y.attribute.current_value'


class RootLuRamp_generatorPosition_yAttributeEnd_value_modeEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.position_y.attribute.end_value_mode.enum'

    @property
    def move_relative(self) -> int:
        return int(self._context.get('root.lu.ramp_generator.position_y.attribute.end_value_mode.enum.move_relative'))

    @move_relative.setter
    def move_relative(self, new_val:int):
        self._context.set('root.lu.ramp_generator.position_y.attribute.end_value_mode.enum.move_relative', int(new_val))

    @property
    def move_to_absolute(self) -> int:
        return int(self._context.get('root.lu.ramp_generator.position_y.attribute.end_value_mode.enum.move_to_absolute'))

    @move_to_absolute.setter
    def move_to_absolute(self, new_val:int):
        self._context.set('root.lu.ramp_generator.position_y.attribute.end_value_mode.enum.move_to_absolute', int(new_val))


class RootLuRamp_generatorPosition_yAttributeEnd_value_mode(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.position_y.attribute.end_value_mode'
        self.enum = RootLuRamp_generatorPosition_yAttributeEnd_value_modeEnum(self._context)


class RootLuRamp_generatorPosition_yAttributeMoving_speed(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.position_y.attribute.moving_speed'


class RootLuRamp_generatorPosition_yAttribute(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.position_y.attribute'
        self.moving_speed = RootLuRamp_generatorPosition_yAttributeMoving_speed(self._context)
        self.end_value_mode = RootLuRamp_generatorPosition_yAttributeEnd_value_mode(self._context)
        self.current_value = RootLuRamp_generatorPosition_yAttributeCurrent_value(self._context)
        self.lower_limit = RootLuRamp_generatorPosition_yAttributeLower_limit(self._context)
        self.upper_limit = RootLuRamp_generatorPosition_yAttributeUpper_limit(self._context)
        self.end_value_absolute = RootLuRamp_generatorPosition_yAttributeEnd_value_absolute(self._context)
        self.moving_time = RootLuRamp_generatorPosition_yAttributeMoving_time(self._context)
        self.end_value_relative = RootLuRamp_generatorPosition_yAttributeEnd_value_relative(self._context)
        self.moving_mode = RootLuRamp_generatorPosition_yAttributeMoving_mode(self._context)
        self.status = RootLuRamp_generatorPosition_yAttributeStatus(self._context)


class RootLuRamp_generatorPosition_yTriggerStart(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.position_y.trigger.start'


class RootLuRamp_generatorPosition_yTriggerAbort(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.position_y.trigger.abort'


class RootLuRamp_generatorPosition_yTriggerPrepare(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.position_y.trigger.prepare'


class RootLuRamp_generatorPosition_yTriggerStop(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.position_y.trigger.stop'


class RootLuRamp_generatorPosition_yTrigger(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.position_y.trigger'
        self.stop = RootLuRamp_generatorPosition_yTriggerStop(self._context)
        self.prepare = RootLuRamp_generatorPosition_yTriggerPrepare(self._context)
        self.abort = RootLuRamp_generatorPosition_yTriggerAbort(self._context)
        self.start = RootLuRamp_generatorPosition_yTriggerStart(self._context)


class RootLuRamp_generatorPosition_y(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.position_y'
        self.trigger = RootLuRamp_generatorPosition_yTrigger(self._context)
        self.attribute = RootLuRamp_generatorPosition_yAttribute(self._context)
        self.busy = RootLuRamp_generatorPosition_yBusy(self._context)


class RootLuRamp_generatorTestBusyIs_moving(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.test.busy.is_moving'


class RootLuRamp_generatorTestBusy(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.test.busy'
        self.is_moving = RootLuRamp_generatorTestBusyIs_moving(self._context)


class RootLuRamp_generatorTestAttributeStatusEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.test.attribute.status.enum'

    @property
    def reached_lower_limit(self) -> int:
        return int(self._context.get('root.lu.ramp_generator.test.attribute.status.enum.reached_lower_limit'))

    @reached_lower_limit.setter
    def reached_lower_limit(self, new_val:int):
        self._context.set('root.lu.ramp_generator.test.attribute.status.enum.reached_lower_limit', int(new_val))

    @property
    def is_moving(self) -> int:
        return int(self._context.get('root.lu.ramp_generator.test.attribute.status.enum.is_moving'))

    @is_moving.setter
    def is_moving(self, new_val:int):
        self._context.set('root.lu.ramp_generator.test.attribute.status.enum.is_moving', int(new_val))

    @property
    def reached_upper_limit(self) -> int:
        return int(self._context.get('root.lu.ramp_generator.test.attribute.status.enum.reached_upper_limit'))

    @reached_upper_limit.setter
    def reached_upper_limit(self, new_val:int):
        self._context.set('root.lu.ramp_generator.test.attribute.status.enum.reached_upper_limit', int(new_val))

    @property
    def reached_endposition(self) -> int:
        return int(self._context.get('root.lu.ramp_generator.test.attribute.status.enum.reached_endposition'))

    @reached_endposition.setter
    def reached_endposition(self, new_val:int):
        self._context.set('root.lu.ramp_generator.test.attribute.status.enum.reached_endposition', int(new_val))

    @property
    def stopped_by_external_event(self) -> int:
        return int(self._context.get('root.lu.ramp_generator.test.attribute.status.enum.stopped_by_external_event'))

    @stopped_by_external_event.setter
    def stopped_by_external_event(self, new_val:int):
        self._context.set('root.lu.ramp_generator.test.attribute.status.enum.stopped_by_external_event', int(new_val))


class RootLuRamp_generatorTestAttributeStatus(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.test.attribute.status'
        self.enum = RootLuRamp_generatorTestAttributeStatusEnum(self._context)


class RootLuRamp_generatorTestAttributeMoving_modeEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.test.attribute.moving_mode.enum'

    @property
    def fix_time(self) -> int:
        return int(self._context.get('root.lu.ramp_generator.test.attribute.moving_mode.enum.fix_time'))

    @fix_time.setter
    def fix_time(self, new_val:int):
        self._context.set('root.lu.ramp_generator.test.attribute.moving_mode.enum.fix_time', int(new_val))

    @property
    def fix_speed(self) -> int:
        return int(self._context.get('root.lu.ramp_generator.test.attribute.moving_mode.enum.fix_speed'))

    @fix_speed.setter
    def fix_speed(self, new_val:int):
        self._context.set('root.lu.ramp_generator.test.attribute.moving_mode.enum.fix_speed', int(new_val))


class RootLuRamp_generatorTestAttributeMoving_mode(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.test.attribute.moving_mode'
        self.enum = RootLuRamp_generatorTestAttributeMoving_modeEnum(self._context)


class RootLuRamp_generatorTestAttributeEnd_value_relative(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.test.attribute.end_value_relative'


class RootLuRamp_generatorTestAttributeMoving_time(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.test.attribute.moving_time'


class RootLuRamp_generatorTestAttributeEnd_value_absolute(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.test.attribute.end_value_absolute'


class RootLuRamp_generatorTestAttributeUpper_limit(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.test.attribute.upper_limit'


class RootLuRamp_generatorTestAttributeLower_limit(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.test.attribute.lower_limit'


class RootLuRamp_generatorTestAttributeCurrent_value(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.test.attribute.current_value'


class RootLuRamp_generatorTestAttributeEnd_value_modeEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.test.attribute.end_value_mode.enum'

    @property
    def move_relative(self) -> int:
        return int(self._context.get('root.lu.ramp_generator.test.attribute.end_value_mode.enum.move_relative'))

    @move_relative.setter
    def move_relative(self, new_val:int):
        self._context.set('root.lu.ramp_generator.test.attribute.end_value_mode.enum.move_relative', int(new_val))

    @property
    def move_to_absolute(self) -> int:
        return int(self._context.get('root.lu.ramp_generator.test.attribute.end_value_mode.enum.move_to_absolute'))

    @move_to_absolute.setter
    def move_to_absolute(self, new_val:int):
        self._context.set('root.lu.ramp_generator.test.attribute.end_value_mode.enum.move_to_absolute', int(new_val))


class RootLuRamp_generatorTestAttributeEnd_value_mode(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.test.attribute.end_value_mode'
        self.enum = RootLuRamp_generatorTestAttributeEnd_value_modeEnum(self._context)


class RootLuRamp_generatorTestAttributeMoving_speed(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.test.attribute.moving_speed'


class RootLuRamp_generatorTestAttribute(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.test.attribute'
        self.moving_speed = RootLuRamp_generatorTestAttributeMoving_speed(self._context)
        self.end_value_mode = RootLuRamp_generatorTestAttributeEnd_value_mode(self._context)
        self.current_value = RootLuRamp_generatorTestAttributeCurrent_value(self._context)
        self.lower_limit = RootLuRamp_generatorTestAttributeLower_limit(self._context)
        self.upper_limit = RootLuRamp_generatorTestAttributeUpper_limit(self._context)
        self.end_value_absolute = RootLuRamp_generatorTestAttributeEnd_value_absolute(self._context)
        self.moving_time = RootLuRamp_generatorTestAttributeMoving_time(self._context)
        self.end_value_relative = RootLuRamp_generatorTestAttributeEnd_value_relative(self._context)
        self.moving_mode = RootLuRamp_generatorTestAttributeMoving_mode(self._context)
        self.status = RootLuRamp_generatorTestAttributeStatus(self._context)


class RootLuRamp_generatorTestTriggerStart(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.test.trigger.start'


class RootLuRamp_generatorTestTriggerAbort(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.test.trigger.abort'


class RootLuRamp_generatorTestTriggerPrepare(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.test.trigger.prepare'


class RootLuRamp_generatorTestTriggerStop(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.test.trigger.stop'


class RootLuRamp_generatorTestTrigger(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.test.trigger'
        self.stop = RootLuRamp_generatorTestTriggerStop(self._context)
        self.prepare = RootLuRamp_generatorTestTriggerPrepare(self._context)
        self.abort = RootLuRamp_generatorTestTriggerAbort(self._context)
        self.start = RootLuRamp_generatorTestTriggerStart(self._context)


class RootLuRamp_generatorTest(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.test'
        self.trigger = RootLuRamp_generatorTestTrigger(self._context)
        self.attribute = RootLuRamp_generatorTestAttribute(self._context)
        self.busy = RootLuRamp_generatorTestBusy(self._context)


class RootLuRamp_generatorPosition_wBusyIs_moving(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.position_w.busy.is_moving'


class RootLuRamp_generatorPosition_wBusy(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.position_w.busy'
        self.is_moving = RootLuRamp_generatorPosition_wBusyIs_moving(self._context)


class RootLuRamp_generatorPosition_wAttributeStatusEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.position_w.attribute.status.enum'

    @property
    def reached_lower_limit(self) -> int:
        return int(self._context.get('root.lu.ramp_generator.position_w.attribute.status.enum.reached_lower_limit'))

    @reached_lower_limit.setter
    def reached_lower_limit(self, new_val:int):
        self._context.set('root.lu.ramp_generator.position_w.attribute.status.enum.reached_lower_limit', int(new_val))

    @property
    def is_moving(self) -> int:
        return int(self._context.get('root.lu.ramp_generator.position_w.attribute.status.enum.is_moving'))

    @is_moving.setter
    def is_moving(self, new_val:int):
        self._context.set('root.lu.ramp_generator.position_w.attribute.status.enum.is_moving', int(new_val))

    @property
    def reached_upper_limit(self) -> int:
        return int(self._context.get('root.lu.ramp_generator.position_w.attribute.status.enum.reached_upper_limit'))

    @reached_upper_limit.setter
    def reached_upper_limit(self, new_val:int):
        self._context.set('root.lu.ramp_generator.position_w.attribute.status.enum.reached_upper_limit', int(new_val))

    @property
    def reached_endposition(self) -> int:
        return int(self._context.get('root.lu.ramp_generator.position_w.attribute.status.enum.reached_endposition'))

    @reached_endposition.setter
    def reached_endposition(self, new_val:int):
        self._context.set('root.lu.ramp_generator.position_w.attribute.status.enum.reached_endposition', int(new_val))

    @property
    def stopped_by_external_event(self) -> int:
        return int(self._context.get('root.lu.ramp_generator.position_w.attribute.status.enum.stopped_by_external_event'))

    @stopped_by_external_event.setter
    def stopped_by_external_event(self, new_val:int):
        self._context.set('root.lu.ramp_generator.position_w.attribute.status.enum.stopped_by_external_event', int(new_val))


class RootLuRamp_generatorPosition_wAttributeStatus(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.position_w.attribute.status'
        self.enum = RootLuRamp_generatorPosition_wAttributeStatusEnum(self._context)


class RootLuRamp_generatorPosition_wAttributeMoving_modeEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.position_w.attribute.moving_mode.enum'

    @property
    def fix_time(self) -> int:
        return int(self._context.get('root.lu.ramp_generator.position_w.attribute.moving_mode.enum.fix_time'))

    @fix_time.setter
    def fix_time(self, new_val:int):
        self._context.set('root.lu.ramp_generator.position_w.attribute.moving_mode.enum.fix_time', int(new_val))

    @property
    def fix_speed(self) -> int:
        return int(self._context.get('root.lu.ramp_generator.position_w.attribute.moving_mode.enum.fix_speed'))

    @fix_speed.setter
    def fix_speed(self, new_val:int):
        self._context.set('root.lu.ramp_generator.position_w.attribute.moving_mode.enum.fix_speed', int(new_val))


class RootLuRamp_generatorPosition_wAttributeMoving_mode(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.position_w.attribute.moving_mode'
        self.enum = RootLuRamp_generatorPosition_wAttributeMoving_modeEnum(self._context)


class RootLuRamp_generatorPosition_wAttributeEnd_value_relative(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.position_w.attribute.end_value_relative'


class RootLuRamp_generatorPosition_wAttributeMoving_time(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.position_w.attribute.moving_time'


class RootLuRamp_generatorPosition_wAttributeEnd_value_absolute(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.position_w.attribute.end_value_absolute'


class RootLuRamp_generatorPosition_wAttributeUpper_limit(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.position_w.attribute.upper_limit'


class RootLuRamp_generatorPosition_wAttributeLower_limit(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.position_w.attribute.lower_limit'


class RootLuRamp_generatorPosition_wAttributeCurrent_value(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.position_w.attribute.current_value'


class RootLuRamp_generatorPosition_wAttributeEnd_value_modeEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.position_w.attribute.end_value_mode.enum'

    @property
    def move_relative(self) -> int:
        return int(self._context.get('root.lu.ramp_generator.position_w.attribute.end_value_mode.enum.move_relative'))

    @move_relative.setter
    def move_relative(self, new_val:int):
        self._context.set('root.lu.ramp_generator.position_w.attribute.end_value_mode.enum.move_relative', int(new_val))

    @property
    def move_to_absolute(self) -> int:
        return int(self._context.get('root.lu.ramp_generator.position_w.attribute.end_value_mode.enum.move_to_absolute'))

    @move_to_absolute.setter
    def move_to_absolute(self, new_val:int):
        self._context.set('root.lu.ramp_generator.position_w.attribute.end_value_mode.enum.move_to_absolute', int(new_val))


class RootLuRamp_generatorPosition_wAttributeEnd_value_mode(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.position_w.attribute.end_value_mode'
        self.enum = RootLuRamp_generatorPosition_wAttributeEnd_value_modeEnum(self._context)


class RootLuRamp_generatorPosition_wAttributeMoving_speed(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.position_w.attribute.moving_speed'


class RootLuRamp_generatorPosition_wAttribute(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.position_w.attribute'
        self.moving_speed = RootLuRamp_generatorPosition_wAttributeMoving_speed(self._context)
        self.end_value_mode = RootLuRamp_generatorPosition_wAttributeEnd_value_mode(self._context)
        self.current_value = RootLuRamp_generatorPosition_wAttributeCurrent_value(self._context)
        self.lower_limit = RootLuRamp_generatorPosition_wAttributeLower_limit(self._context)
        self.upper_limit = RootLuRamp_generatorPosition_wAttributeUpper_limit(self._context)
        self.end_value_absolute = RootLuRamp_generatorPosition_wAttributeEnd_value_absolute(self._context)
        self.moving_time = RootLuRamp_generatorPosition_wAttributeMoving_time(self._context)
        self.end_value_relative = RootLuRamp_generatorPosition_wAttributeEnd_value_relative(self._context)
        self.moving_mode = RootLuRamp_generatorPosition_wAttributeMoving_mode(self._context)
        self.status = RootLuRamp_generatorPosition_wAttributeStatus(self._context)


class RootLuRamp_generatorPosition_wTriggerStart(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.position_w.trigger.start'


class RootLuRamp_generatorPosition_wTriggerAbort(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.position_w.trigger.abort'


class RootLuRamp_generatorPosition_wTriggerPrepare(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.position_w.trigger.prepare'


class RootLuRamp_generatorPosition_wTriggerStop(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.position_w.trigger.stop'


class RootLuRamp_generatorPosition_wTrigger(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.position_w.trigger'
        self.stop = RootLuRamp_generatorPosition_wTriggerStop(self._context)
        self.prepare = RootLuRamp_generatorPosition_wTriggerPrepare(self._context)
        self.abort = RootLuRamp_generatorPosition_wTriggerAbort(self._context)
        self.start = RootLuRamp_generatorPosition_wTriggerStart(self._context)


class RootLuRamp_generatorPosition_w(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.position_w'
        self.trigger = RootLuRamp_generatorPosition_wTrigger(self._context)
        self.attribute = RootLuRamp_generatorPosition_wAttribute(self._context)
        self.busy = RootLuRamp_generatorPosition_wBusy(self._context)


class RootLuRamp_generatorUser2BusyIs_moving(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.user2.busy.is_moving'


class RootLuRamp_generatorUser2Busy(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.user2.busy'
        self.is_moving = RootLuRamp_generatorUser2BusyIs_moving(self._context)


class RootLuRamp_generatorUser2AttributeStatusEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.user2.attribute.status.enum'

    @property
    def reached_lower_limit(self) -> int:
        return int(self._context.get('root.lu.ramp_generator.user2.attribute.status.enum.reached_lower_limit'))

    @reached_lower_limit.setter
    def reached_lower_limit(self, new_val:int):
        self._context.set('root.lu.ramp_generator.user2.attribute.status.enum.reached_lower_limit', int(new_val))

    @property
    def is_moving(self) -> int:
        return int(self._context.get('root.lu.ramp_generator.user2.attribute.status.enum.is_moving'))

    @is_moving.setter
    def is_moving(self, new_val:int):
        self._context.set('root.lu.ramp_generator.user2.attribute.status.enum.is_moving', int(new_val))

    @property
    def reached_upper_limit(self) -> int:
        return int(self._context.get('root.lu.ramp_generator.user2.attribute.status.enum.reached_upper_limit'))

    @reached_upper_limit.setter
    def reached_upper_limit(self, new_val:int):
        self._context.set('root.lu.ramp_generator.user2.attribute.status.enum.reached_upper_limit', int(new_val))

    @property
    def reached_endposition(self) -> int:
        return int(self._context.get('root.lu.ramp_generator.user2.attribute.status.enum.reached_endposition'))

    @reached_endposition.setter
    def reached_endposition(self, new_val:int):
        self._context.set('root.lu.ramp_generator.user2.attribute.status.enum.reached_endposition', int(new_val))

    @property
    def stopped_by_external_event(self) -> int:
        return int(self._context.get('root.lu.ramp_generator.user2.attribute.status.enum.stopped_by_external_event'))

    @stopped_by_external_event.setter
    def stopped_by_external_event(self, new_val:int):
        self._context.set('root.lu.ramp_generator.user2.attribute.status.enum.stopped_by_external_event', int(new_val))


class RootLuRamp_generatorUser2AttributeStatus(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.user2.attribute.status'
        self.enum = RootLuRamp_generatorUser2AttributeStatusEnum(self._context)


class RootLuRamp_generatorUser2AttributeMoving_modeEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.user2.attribute.moving_mode.enum'

    @property
    def fix_time(self) -> int:
        return int(self._context.get('root.lu.ramp_generator.user2.attribute.moving_mode.enum.fix_time'))

    @fix_time.setter
    def fix_time(self, new_val:int):
        self._context.set('root.lu.ramp_generator.user2.attribute.moving_mode.enum.fix_time', int(new_val))

    @property
    def fix_speed(self) -> int:
        return int(self._context.get('root.lu.ramp_generator.user2.attribute.moving_mode.enum.fix_speed'))

    @fix_speed.setter
    def fix_speed(self, new_val:int):
        self._context.set('root.lu.ramp_generator.user2.attribute.moving_mode.enum.fix_speed', int(new_val))


class RootLuRamp_generatorUser2AttributeMoving_mode(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.user2.attribute.moving_mode'
        self.enum = RootLuRamp_generatorUser2AttributeMoving_modeEnum(self._context)


class RootLuRamp_generatorUser2AttributeEnd_value_relative(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.user2.attribute.end_value_relative'


class RootLuRamp_generatorUser2AttributeMoving_time(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.user2.attribute.moving_time'


class RootLuRamp_generatorUser2AttributeEnd_value_absolute(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.user2.attribute.end_value_absolute'


class RootLuRamp_generatorUser2AttributeUpper_limit(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.user2.attribute.upper_limit'


class RootLuRamp_generatorUser2AttributeLower_limit(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.user2.attribute.lower_limit'


class RootLuRamp_generatorUser2AttributeCurrent_value(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.user2.attribute.current_value'


class RootLuRamp_generatorUser2AttributeEnd_value_modeEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.user2.attribute.end_value_mode.enum'

    @property
    def move_relative(self) -> int:
        return int(self._context.get('root.lu.ramp_generator.user2.attribute.end_value_mode.enum.move_relative'))

    @move_relative.setter
    def move_relative(self, new_val:int):
        self._context.set('root.lu.ramp_generator.user2.attribute.end_value_mode.enum.move_relative', int(new_val))

    @property
    def move_to_absolute(self) -> int:
        return int(self._context.get('root.lu.ramp_generator.user2.attribute.end_value_mode.enum.move_to_absolute'))

    @move_to_absolute.setter
    def move_to_absolute(self, new_val:int):
        self._context.set('root.lu.ramp_generator.user2.attribute.end_value_mode.enum.move_to_absolute', int(new_val))


class RootLuRamp_generatorUser2AttributeEnd_value_mode(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.user2.attribute.end_value_mode'
        self.enum = RootLuRamp_generatorUser2AttributeEnd_value_modeEnum(self._context)


class RootLuRamp_generatorUser2AttributeMoving_speed(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.user2.attribute.moving_speed'


class RootLuRamp_generatorUser2Attribute(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.user2.attribute'
        self.moving_speed = RootLuRamp_generatorUser2AttributeMoving_speed(self._context)
        self.end_value_mode = RootLuRamp_generatorUser2AttributeEnd_value_mode(self._context)
        self.current_value = RootLuRamp_generatorUser2AttributeCurrent_value(self._context)
        self.lower_limit = RootLuRamp_generatorUser2AttributeLower_limit(self._context)
        self.upper_limit = RootLuRamp_generatorUser2AttributeUpper_limit(self._context)
        self.end_value_absolute = RootLuRamp_generatorUser2AttributeEnd_value_absolute(self._context)
        self.moving_time = RootLuRamp_generatorUser2AttributeMoving_time(self._context)
        self.end_value_relative = RootLuRamp_generatorUser2AttributeEnd_value_relative(self._context)
        self.moving_mode = RootLuRamp_generatorUser2AttributeMoving_mode(self._context)
        self.status = RootLuRamp_generatorUser2AttributeStatus(self._context)


class RootLuRamp_generatorUser2TriggerStart(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.user2.trigger.start'


class RootLuRamp_generatorUser2TriggerAbort(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.user2.trigger.abort'


class RootLuRamp_generatorUser2TriggerPrepare(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.user2.trigger.prepare'


class RootLuRamp_generatorUser2TriggerStop(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.user2.trigger.stop'


class RootLuRamp_generatorUser2Trigger(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.user2.trigger'
        self.stop = RootLuRamp_generatorUser2TriggerStop(self._context)
        self.prepare = RootLuRamp_generatorUser2TriggerPrepare(self._context)
        self.abort = RootLuRamp_generatorUser2TriggerAbort(self._context)
        self.start = RootLuRamp_generatorUser2TriggerStart(self._context)


class RootLuRamp_generatorUser2(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.user2'
        self.trigger = RootLuRamp_generatorUser2Trigger(self._context)
        self.attribute = RootLuRamp_generatorUser2Attribute(self._context)
        self.busy = RootLuRamp_generatorUser2Busy(self._context)


class RootLuRamp_generatorVirtual2BusyIs_moving(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.virtual2.busy.is_moving'


class RootLuRamp_generatorVirtual2Busy(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.virtual2.busy'
        self.is_moving = RootLuRamp_generatorVirtual2BusyIs_moving(self._context)


class RootLuRamp_generatorVirtual2AttributeStatusEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.virtual2.attribute.status.enum'

    @property
    def reached_lower_limit(self) -> int:
        return int(self._context.get('root.lu.ramp_generator.virtual2.attribute.status.enum.reached_lower_limit'))

    @reached_lower_limit.setter
    def reached_lower_limit(self, new_val:int):
        self._context.set('root.lu.ramp_generator.virtual2.attribute.status.enum.reached_lower_limit', int(new_val))

    @property
    def is_moving(self) -> int:
        return int(self._context.get('root.lu.ramp_generator.virtual2.attribute.status.enum.is_moving'))

    @is_moving.setter
    def is_moving(self, new_val:int):
        self._context.set('root.lu.ramp_generator.virtual2.attribute.status.enum.is_moving', int(new_val))

    @property
    def reached_upper_limit(self) -> int:
        return int(self._context.get('root.lu.ramp_generator.virtual2.attribute.status.enum.reached_upper_limit'))

    @reached_upper_limit.setter
    def reached_upper_limit(self, new_val:int):
        self._context.set('root.lu.ramp_generator.virtual2.attribute.status.enum.reached_upper_limit', int(new_val))

    @property
    def reached_endposition(self) -> int:
        return int(self._context.get('root.lu.ramp_generator.virtual2.attribute.status.enum.reached_endposition'))

    @reached_endposition.setter
    def reached_endposition(self, new_val:int):
        self._context.set('root.lu.ramp_generator.virtual2.attribute.status.enum.reached_endposition', int(new_val))

    @property
    def stopped_by_external_event(self) -> int:
        return int(self._context.get('root.lu.ramp_generator.virtual2.attribute.status.enum.stopped_by_external_event'))

    @stopped_by_external_event.setter
    def stopped_by_external_event(self, new_val:int):
        self._context.set('root.lu.ramp_generator.virtual2.attribute.status.enum.stopped_by_external_event', int(new_val))


class RootLuRamp_generatorVirtual2AttributeStatus(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.virtual2.attribute.status'
        self.enum = RootLuRamp_generatorVirtual2AttributeStatusEnum(self._context)


class RootLuRamp_generatorVirtual2AttributeMoving_modeEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.virtual2.attribute.moving_mode.enum'

    @property
    def fix_time(self) -> int:
        return int(self._context.get('root.lu.ramp_generator.virtual2.attribute.moving_mode.enum.fix_time'))

    @fix_time.setter
    def fix_time(self, new_val:int):
        self._context.set('root.lu.ramp_generator.virtual2.attribute.moving_mode.enum.fix_time', int(new_val))

    @property
    def fix_speed(self) -> int:
        return int(self._context.get('root.lu.ramp_generator.virtual2.attribute.moving_mode.enum.fix_speed'))

    @fix_speed.setter
    def fix_speed(self, new_val:int):
        self._context.set('root.lu.ramp_generator.virtual2.attribute.moving_mode.enum.fix_speed', int(new_val))


class RootLuRamp_generatorVirtual2AttributeMoving_mode(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.virtual2.attribute.moving_mode'
        self.enum = RootLuRamp_generatorVirtual2AttributeMoving_modeEnum(self._context)


class RootLuRamp_generatorVirtual2AttributeEnd_value_relative(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.virtual2.attribute.end_value_relative'


class RootLuRamp_generatorVirtual2AttributeMoving_time(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.virtual2.attribute.moving_time'


class RootLuRamp_generatorVirtual2AttributeEnd_value_absolute(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.virtual2.attribute.end_value_absolute'


class RootLuRamp_generatorVirtual2AttributeUpper_limit(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.virtual2.attribute.upper_limit'


class RootLuRamp_generatorVirtual2AttributeLower_limit(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.virtual2.attribute.lower_limit'


class RootLuRamp_generatorVirtual2AttributeCurrent_value(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.virtual2.attribute.current_value'


class RootLuRamp_generatorVirtual2AttributeEnd_value_modeEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.virtual2.attribute.end_value_mode.enum'

    @property
    def move_relative(self) -> int:
        return int(self._context.get('root.lu.ramp_generator.virtual2.attribute.end_value_mode.enum.move_relative'))

    @move_relative.setter
    def move_relative(self, new_val:int):
        self._context.set('root.lu.ramp_generator.virtual2.attribute.end_value_mode.enum.move_relative', int(new_val))

    @property
    def move_to_absolute(self) -> int:
        return int(self._context.get('root.lu.ramp_generator.virtual2.attribute.end_value_mode.enum.move_to_absolute'))

    @move_to_absolute.setter
    def move_to_absolute(self, new_val:int):
        self._context.set('root.lu.ramp_generator.virtual2.attribute.end_value_mode.enum.move_to_absolute', int(new_val))


class RootLuRamp_generatorVirtual2AttributeEnd_value_mode(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.virtual2.attribute.end_value_mode'
        self.enum = RootLuRamp_generatorVirtual2AttributeEnd_value_modeEnum(self._context)


class RootLuRamp_generatorVirtual2AttributeMoving_speed(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.virtual2.attribute.moving_speed'


class RootLuRamp_generatorVirtual2Attribute(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.virtual2.attribute'
        self.moving_speed = RootLuRamp_generatorVirtual2AttributeMoving_speed(self._context)
        self.end_value_mode = RootLuRamp_generatorVirtual2AttributeEnd_value_mode(self._context)
        self.current_value = RootLuRamp_generatorVirtual2AttributeCurrent_value(self._context)
        self.lower_limit = RootLuRamp_generatorVirtual2AttributeLower_limit(self._context)
        self.upper_limit = RootLuRamp_generatorVirtual2AttributeUpper_limit(self._context)
        self.end_value_absolute = RootLuRamp_generatorVirtual2AttributeEnd_value_absolute(self._context)
        self.moving_time = RootLuRamp_generatorVirtual2AttributeMoving_time(self._context)
        self.end_value_relative = RootLuRamp_generatorVirtual2AttributeEnd_value_relative(self._context)
        self.moving_mode = RootLuRamp_generatorVirtual2AttributeMoving_mode(self._context)
        self.status = RootLuRamp_generatorVirtual2AttributeStatus(self._context)


class RootLuRamp_generatorVirtual2TriggerStart(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.virtual2.trigger.start'


class RootLuRamp_generatorVirtual2TriggerAbort(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.virtual2.trigger.abort'


class RootLuRamp_generatorVirtual2TriggerPrepare(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.virtual2.trigger.prepare'


class RootLuRamp_generatorVirtual2TriggerStop(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.virtual2.trigger.stop'


class RootLuRamp_generatorVirtual2Trigger(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.virtual2.trigger'
        self.stop = RootLuRamp_generatorVirtual2TriggerStop(self._context)
        self.prepare = RootLuRamp_generatorVirtual2TriggerPrepare(self._context)
        self.abort = RootLuRamp_generatorVirtual2TriggerAbort(self._context)
        self.start = RootLuRamp_generatorVirtual2TriggerStart(self._context)


class RootLuRamp_generatorVirtual2(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.virtual2'
        self.trigger = RootLuRamp_generatorVirtual2Trigger(self._context)
        self.attribute = RootLuRamp_generatorVirtual2Attribute(self._context)
        self.busy = RootLuRamp_generatorVirtual2Busy(self._context)


class RootLuRamp_generatorPosition_xBusyIs_moving(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.position_x.busy.is_moving'


class RootLuRamp_generatorPosition_xBusy(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.position_x.busy'
        self.is_moving = RootLuRamp_generatorPosition_xBusyIs_moving(self._context)


class RootLuRamp_generatorPosition_xAttributeStatusEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.position_x.attribute.status.enum'

    @property
    def reached_lower_limit(self) -> int:
        return int(self._context.get('root.lu.ramp_generator.position_x.attribute.status.enum.reached_lower_limit'))

    @reached_lower_limit.setter
    def reached_lower_limit(self, new_val:int):
        self._context.set('root.lu.ramp_generator.position_x.attribute.status.enum.reached_lower_limit', int(new_val))

    @property
    def is_moving(self) -> int:
        return int(self._context.get('root.lu.ramp_generator.position_x.attribute.status.enum.is_moving'))

    @is_moving.setter
    def is_moving(self, new_val:int):
        self._context.set('root.lu.ramp_generator.position_x.attribute.status.enum.is_moving', int(new_val))

    @property
    def reached_upper_limit(self) -> int:
        return int(self._context.get('root.lu.ramp_generator.position_x.attribute.status.enum.reached_upper_limit'))

    @reached_upper_limit.setter
    def reached_upper_limit(self, new_val:int):
        self._context.set('root.lu.ramp_generator.position_x.attribute.status.enum.reached_upper_limit', int(new_val))

    @property
    def reached_endposition(self) -> int:
        return int(self._context.get('root.lu.ramp_generator.position_x.attribute.status.enum.reached_endposition'))

    @reached_endposition.setter
    def reached_endposition(self, new_val:int):
        self._context.set('root.lu.ramp_generator.position_x.attribute.status.enum.reached_endposition', int(new_val))

    @property
    def stopped_by_external_event(self) -> int:
        return int(self._context.get('root.lu.ramp_generator.position_x.attribute.status.enum.stopped_by_external_event'))

    @stopped_by_external_event.setter
    def stopped_by_external_event(self, new_val:int):
        self._context.set('root.lu.ramp_generator.position_x.attribute.status.enum.stopped_by_external_event', int(new_val))


class RootLuRamp_generatorPosition_xAttributeStatus(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.position_x.attribute.status'
        self.enum = RootLuRamp_generatorPosition_xAttributeStatusEnum(self._context)


class RootLuRamp_generatorPosition_xAttributeMoving_modeEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.position_x.attribute.moving_mode.enum'

    @property
    def fix_time(self) -> int:
        return int(self._context.get('root.lu.ramp_generator.position_x.attribute.moving_mode.enum.fix_time'))

    @fix_time.setter
    def fix_time(self, new_val:int):
        self._context.set('root.lu.ramp_generator.position_x.attribute.moving_mode.enum.fix_time', int(new_val))

    @property
    def fix_speed(self) -> int:
        return int(self._context.get('root.lu.ramp_generator.position_x.attribute.moving_mode.enum.fix_speed'))

    @fix_speed.setter
    def fix_speed(self, new_val:int):
        self._context.set('root.lu.ramp_generator.position_x.attribute.moving_mode.enum.fix_speed', int(new_val))


class RootLuRamp_generatorPosition_xAttributeMoving_mode(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.position_x.attribute.moving_mode'
        self.enum = RootLuRamp_generatorPosition_xAttributeMoving_modeEnum(self._context)


class RootLuRamp_generatorPosition_xAttributeEnd_value_relative(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.position_x.attribute.end_value_relative'


class RootLuRamp_generatorPosition_xAttributeMoving_time(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.position_x.attribute.moving_time'


class RootLuRamp_generatorPosition_xAttributeEnd_value_absolute(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.position_x.attribute.end_value_absolute'


class RootLuRamp_generatorPosition_xAttributeUpper_limit(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.position_x.attribute.upper_limit'


class RootLuRamp_generatorPosition_xAttributeLower_limit(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.position_x.attribute.lower_limit'


class RootLuRamp_generatorPosition_xAttributeCurrent_value(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.position_x.attribute.current_value'


class RootLuRamp_generatorPosition_xAttributeEnd_value_modeEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.position_x.attribute.end_value_mode.enum'

    @property
    def move_relative(self) -> int:
        return int(self._context.get('root.lu.ramp_generator.position_x.attribute.end_value_mode.enum.move_relative'))

    @move_relative.setter
    def move_relative(self, new_val:int):
        self._context.set('root.lu.ramp_generator.position_x.attribute.end_value_mode.enum.move_relative', int(new_val))

    @property
    def move_to_absolute(self) -> int:
        return int(self._context.get('root.lu.ramp_generator.position_x.attribute.end_value_mode.enum.move_to_absolute'))

    @move_to_absolute.setter
    def move_to_absolute(self, new_val:int):
        self._context.set('root.lu.ramp_generator.position_x.attribute.end_value_mode.enum.move_to_absolute', int(new_val))


class RootLuRamp_generatorPosition_xAttributeEnd_value_mode(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.position_x.attribute.end_value_mode'
        self.enum = RootLuRamp_generatorPosition_xAttributeEnd_value_modeEnum(self._context)


class RootLuRamp_generatorPosition_xAttributeMoving_speed(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.position_x.attribute.moving_speed'


class RootLuRamp_generatorPosition_xAttribute(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.position_x.attribute'
        self.moving_speed = RootLuRamp_generatorPosition_xAttributeMoving_speed(self._context)
        self.end_value_mode = RootLuRamp_generatorPosition_xAttributeEnd_value_mode(self._context)
        self.current_value = RootLuRamp_generatorPosition_xAttributeCurrent_value(self._context)
        self.lower_limit = RootLuRamp_generatorPosition_xAttributeLower_limit(self._context)
        self.upper_limit = RootLuRamp_generatorPosition_xAttributeUpper_limit(self._context)
        self.end_value_absolute = RootLuRamp_generatorPosition_xAttributeEnd_value_absolute(self._context)
        self.moving_time = RootLuRamp_generatorPosition_xAttributeMoving_time(self._context)
        self.end_value_relative = RootLuRamp_generatorPosition_xAttributeEnd_value_relative(self._context)
        self.moving_mode = RootLuRamp_generatorPosition_xAttributeMoving_mode(self._context)
        self.status = RootLuRamp_generatorPosition_xAttributeStatus(self._context)


class RootLuRamp_generatorPosition_xTriggerStart(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.position_x.trigger.start'


class RootLuRamp_generatorPosition_xTriggerAbort(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.position_x.trigger.abort'


class RootLuRamp_generatorPosition_xTriggerPrepare(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.position_x.trigger.prepare'


class RootLuRamp_generatorPosition_xTriggerStop(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.position_x.trigger.stop'


class RootLuRamp_generatorPosition_xTrigger(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.position_x.trigger'
        self.stop = RootLuRamp_generatorPosition_xTriggerStop(self._context)
        self.prepare = RootLuRamp_generatorPosition_xTriggerPrepare(self._context)
        self.abort = RootLuRamp_generatorPosition_xTriggerAbort(self._context)
        self.start = RootLuRamp_generatorPosition_xTriggerStart(self._context)


class RootLuRamp_generatorPosition_x(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.position_x'
        self.trigger = RootLuRamp_generatorPosition_xTrigger(self._context)
        self.attribute = RootLuRamp_generatorPosition_xAttribute(self._context)
        self.busy = RootLuRamp_generatorPosition_xBusy(self._context)


class RootLuRamp_generator(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator'
        self.position_x = RootLuRamp_generatorPosition_x(self._context)
        self.virtual2 = RootLuRamp_generatorVirtual2(self._context)
        self.user2 = RootLuRamp_generatorUser2(self._context)
        self.position_w = RootLuRamp_generatorPosition_w(self._context)
        self.test = RootLuRamp_generatorTest(self._context)
        self.position_y = RootLuRamp_generatorPosition_y(self._context)
        self.user4 = RootLuRamp_generatorUser4(self._context)
        self.approach = RootLuRamp_generatorApproach(self._context)
        self.virtual1 = RootLuRamp_generatorVirtual1(self._context)
        self.user1 = RootLuRamp_generatorUser1(self._context)
        self.alternate_z = RootLuRamp_generatorAlternate_z(self._context)
        self.tip_voltage = RootLuRamp_generatorTip_voltage(self._context)
        self.virtual0 = RootLuRamp_generatorVirtual0(self._context)
        self.ctrl_z = RootLuRamp_generatorCtrl_z(self._context)
        self.plane_z = RootLuRamp_generatorPlane_z(self._context)


class RootLuScanheadInstanceTriggerEnable_piezo_electric_excitation(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.scanhead.instance.trigger.enable_piezo_electric_excitation'


class RootLuScanheadInstanceTriggerDisable_pte_laser(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.scanhead.instance.trigger.disable_pte_laser'


class RootLuScanheadInstanceTriggerEnable_pte_laser(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.scanhead.instance.trigger.enable_pte_laser'


class RootLuScanheadInstanceTriggerDisable_electro_thermal_excitation(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.scanhead.instance.trigger.disable_electro_thermal_excitation'


class RootLuScanheadInstanceTriggerDisable_piezo_electric_excitation(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.scanhead.instance.trigger.disable_piezo_electric_excitation'


class RootLuScanheadInstanceTriggerDisable_readout_laser(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.scanhead.instance.trigger.disable_readout_laser'


class RootLuScanheadInstanceTriggerApply_tilt_mode(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.scanhead.instance.trigger.apply_tilt_mode'


class RootLuScanheadInstanceTriggerEnable_electro_thermal_excitation(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.scanhead.instance.trigger.enable_electro_thermal_excitation'


class RootLuScanheadInstanceTriggerEnable_readout_laser(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.scanhead.instance.trigger.enable_readout_laser'


class RootLuScanheadInstanceTrigger(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.scanhead.instance.trigger'
        self.enable_readout_laser = RootLuScanheadInstanceTriggerEnable_readout_laser(self._context)
        self.enable_electro_thermal_excitation = RootLuScanheadInstanceTriggerEnable_electro_thermal_excitation(self._context)
        self.apply_tilt_mode = RootLuScanheadInstanceTriggerApply_tilt_mode(self._context)
        self.disable_readout_laser = RootLuScanheadInstanceTriggerDisable_readout_laser(self._context)
        self.disable_piezo_electric_excitation = RootLuScanheadInstanceTriggerDisable_piezo_electric_excitation(self._context)
        self.disable_electro_thermal_excitation = RootLuScanheadInstanceTriggerDisable_electro_thermal_excitation(self._context)
        self.enable_pte_laser = RootLuScanheadInstanceTriggerEnable_pte_laser(self._context)
        self.disable_pte_laser = RootLuScanheadInstanceTriggerDisable_pte_laser(self._context)
        self.enable_piezo_electric_excitation = RootLuScanheadInstanceTriggerEnable_piezo_electric_excitation(self._context)


class RootLuScanheadInstanceAttributeReadout_laser_setpoint(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.scanhead.instance.attribute.readout_laser_setpoint'


class RootLuScanheadInstanceAttributeHas_xy_sensorEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.scanhead.instance.attribute.has_xy_sensor.enum'

    @property
    def no(self) -> int:
        return int(self._context.get('root.lu.scanhead.instance.attribute.has_xy_sensor.enum.no'))

    @no.setter
    def no(self, new_val:int):
        self._context.set('root.lu.scanhead.instance.attribute.has_xy_sensor.enum.no', int(new_val))

    @property
    def yes(self) -> int:
        return int(self._context.get('root.lu.scanhead.instance.attribute.has_xy_sensor.enum.yes'))

    @yes.setter
    def yes(self, new_val:int):
        self._context.set('root.lu.scanhead.instance.attribute.has_xy_sensor.enum.yes', int(new_val))


class RootLuScanheadInstanceAttributeHas_xy_sensor(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.scanhead.instance.attribute.has_xy_sensor'
        self.enum = RootLuScanheadInstanceAttributeHas_xy_sensorEnum(self._context)


class RootLuScanheadInstanceAttributeFast_in2_channelEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.scanhead.instance.attribute.fast_in2_channel.enum'

    @property
    def friction_channel(self) -> int:
        return int(self._context.get('root.lu.scanhead.instance.attribute.fast_in2_channel.enum.friction_channel'))

    @friction_channel.setter
    def friction_channel(self, new_val:int):
        self._context.set('root.lu.scanhead.instance.attribute.fast_in2_channel.enum.friction_channel', int(new_val))

    @property
    def addon_in(self) -> int:
        return int(self._context.get('root.lu.scanhead.instance.attribute.fast_in2_channel.enum.addon_in'))

    @addon_in.setter
    def addon_in(self, new_val:int):
        self._context.set('root.lu.scanhead.instance.attribute.fast_in2_channel.enum.addon_in', int(new_val))

    @property
    def pte_monitor(self) -> int:
        return int(self._context.get('root.lu.scanhead.instance.attribute.fast_in2_channel.enum.pte_monitor'))

    @pte_monitor.setter
    def pte_monitor(self, new_val:int):
        self._context.set('root.lu.scanhead.instance.attribute.fast_in2_channel.enum.pte_monitor', int(new_val))


class RootLuScanheadInstanceAttributeFast_in2_channel(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.scanhead.instance.attribute.fast_in2_channel'
        self.enum = RootLuScanheadInstanceAttributeFast_in2_channelEnum(self._context)


class RootLuScanheadInstanceAttributeTilt_angle_y(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.scanhead.instance.attribute.tilt_angle_y'


class RootLuScanheadInstanceAttributeTilt_modeEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.scanhead.instance.attribute.tilt_mode.enum'

    @property
    def override(self) -> int:
        return int(self._context.get('root.lu.scanhead.instance.attribute.tilt_mode.enum.override'))

    @override.setter
    def override(self, new_val:int):
        self._context.set('root.lu.scanhead.instance.attribute.tilt_mode.enum.override', int(new_val))

    @property
    def measured(self) -> int:
        return int(self._context.get('root.lu.scanhead.instance.attribute.tilt_mode.enum.measured'))

    @measured.setter
    def measured(self, new_val:int):
        self._context.set('root.lu.scanhead.instance.attribute.tilt_mode.enum.measured', int(new_val))


class RootLuScanheadInstanceAttributeTilt_mode(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.scanhead.instance.attribute.tilt_mode'
        self.enum = RootLuScanheadInstanceAttributeTilt_modeEnum(self._context)


class RootLuScanheadInstanceAttributeHas_z_sensorEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.scanhead.instance.attribute.has_z_sensor.enum'

    @property
    def no(self) -> int:
        return int(self._context.get('root.lu.scanhead.instance.attribute.has_z_sensor.enum.no'))

    @no.setter
    def no(self, new_val:int):
        self._context.set('root.lu.scanhead.instance.attribute.has_z_sensor.enum.no', int(new_val))

    @property
    def yes(self) -> int:
        return int(self._context.get('root.lu.scanhead.instance.attribute.has_z_sensor.enum.yes'))

    @yes.setter
    def yes(self, new_val:int):
        self._context.set('root.lu.scanhead.instance.attribute.has_z_sensor.enum.yes', int(new_val))


class RootLuScanheadInstanceAttributeHas_z_sensor(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.scanhead.instance.attribute.has_z_sensor'
        self.enum = RootLuScanheadInstanceAttributeHas_z_sensorEnum(self._context)


class RootLuScanheadInstanceAttributeTypeEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.scanhead.instance.attribute.type.enum'

    @property
    def e_stm(self) -> int:
        return int(self._context.get('root.lu.scanhead.instance.attribute.type.enum.e_stm'))

    @e_stm.setter
    def e_stm(self, new_val:int):
        self._context.set('root.lu.scanhead.instance.attribute.type.enum.e_stm', int(new_val))

    @property
    def dummy7(self) -> int:
        return int(self._context.get('root.lu.scanhead.instance.attribute.type.enum.dummy7'))

    @dummy7.setter
    def dummy7(self, new_val:int):
        self._context.set('root.lu.scanhead.instance.attribute.type.enum.dummy7', int(new_val))

    @property
    def afsem(self) -> int:
        return int(self._context.get('root.lu.scanhead.instance.attribute.type.enum.afsem'))

    @afsem.setter
    def afsem(self, new_val:int):
        self._context.set('root.lu.scanhead.instance.attribute.type.enum.afsem', int(new_val))

    @property
    def lens_afm(self) -> int:
        return int(self._context.get('root.lu.scanhead.instance.attribute.type.enum.lens_afm'))

    @lens_afm.setter
    def lens_afm(self, new_val:int):
        self._context.set('root.lu.scanhead.instance.attribute.type.enum.lens_afm', int(new_val))

    @property
    def dummy4(self) -> int:
        return int(self._context.get('root.lu.scanhead.instance.attribute.type.enum.dummy4'))

    @dummy4.setter
    def dummy4(self, new_val:int):
        self._context.set('root.lu.scanhead.instance.attribute.type.enum.dummy4', int(new_val))

    @property
    def core_afm(self) -> int:
        return int(self._context.get('root.lu.scanhead.instance.attribute.type.enum.core_afm'))

    @core_afm.setter
    def core_afm(self, new_val:int):
        self._context.set('root.lu.scanhead.instance.attribute.type.enum.core_afm', int(new_val))

    @property
    def dummy6(self) -> int:
        return int(self._context.get('root.lu.scanhead.instance.attribute.type.enum.dummy6'))

    @dummy6.setter
    def dummy6(self, new_val:int):
        self._context.set('root.lu.scanhead.instance.attribute.type.enum.dummy6', int(new_val))

    @property
    def dummy8(self) -> int:
        return int(self._context.get('root.lu.scanhead.instance.attribute.type.enum.dummy8'))

    @dummy8.setter
    def dummy8(self, new_val:int):
        self._context.set('root.lu.scanhead.instance.attribute.type.enum.dummy8', int(new_val))

    @property
    def dummy3(self) -> int:
        return int(self._context.get('root.lu.scanhead.instance.attribute.type.enum.dummy3'))

    @dummy3.setter
    def dummy3(self, new_val:int):
        self._context.set('root.lu.scanhead.instance.attribute.type.enum.dummy3', int(new_val))

    @property
    def unknown(self) -> int:
        return int(self._context.get('root.lu.scanhead.instance.attribute.type.enum.unknown'))

    @unknown.setter
    def unknown(self, new_val:int):
        self._context.set('root.lu.scanhead.instance.attribute.type.enum.unknown', int(new_val))

    @property
    def arac(self) -> int:
        return int(self._context.get('root.lu.scanhead.instance.attribute.type.enum.arac'))

    @arac.setter
    def arac(self, new_val:int):
        self._context.set('root.lu.scanhead.instance.attribute.type.enum.arac', int(new_val))

    @property
    def dummy5(self) -> int:
        return int(self._context.get('root.lu.scanhead.instance.attribute.type.enum.dummy5'))

    @dummy5.setter
    def dummy5(self, new_val:int):
        self._context.set('root.lu.scanhead.instance.attribute.type.enum.dummy5', int(new_val))

    @property
    def nanite_afm(self) -> int:
        return int(self._context.get('root.lu.scanhead.instance.attribute.type.enum.nanite_afm'))

    @nanite_afm.setter
    def nanite_afm(self, new_val:int):
        self._context.set('root.lu.scanhead.instance.attribute.type.enum.nanite_afm', int(new_val))

    @property
    def semafm(self) -> int:
        return int(self._context.get('root.lu.scanhead.instance.attribute.type.enum.semafm'))

    @semafm.setter
    def semafm(self, new_val:int):
        self._context.set('root.lu.scanhead.instance.attribute.type.enum.semafm', int(new_val))

    @property
    def cytomass(self) -> int:
        return int(self._context.get('root.lu.scanhead.instance.attribute.type.enum.cytomass'))

    @cytomass.setter
    def cytomass(self, new_val:int):
        self._context.set('root.lu.scanhead.instance.attribute.type.enum.cytomass', int(new_val))

    @property
    def e_afm(self) -> int:
        return int(self._context.get('root.lu.scanhead.instance.attribute.type.enum.e_afm'))

    @e_afm.setter
    def e_afm(self, new_val:int):
        self._context.set('root.lu.scanhead.instance.attribute.type.enum.e_afm', int(new_val))

    @property
    def not_connected(self) -> int:
        return int(self._context.get('root.lu.scanhead.instance.attribute.type.enum.not_connected'))

    @not_connected.setter
    def not_connected(self, new_val:int):
        self._context.set('root.lu.scanhead.instance.attribute.type.enum.not_connected', int(new_val))

    @property
    def p6(self) -> int:
        return int(self._context.get('root.lu.scanhead.instance.attribute.type.enum.p6'))

    @p6.setter
    def p6(self, new_val:int):
        self._context.set('root.lu.scanhead.instance.attribute.type.enum.p6', int(new_val))

    @property
    def flex_afm(self) -> int:
        return int(self._context.get('root.lu.scanhead.instance.attribute.type.enum.flex_afm'))

    @flex_afm.setter
    def flex_afm(self, new_val:int):
        self._context.set('root.lu.scanhead.instance.attribute.type.enum.flex_afm', int(new_val))

    @property
    def p6_mount(self) -> int:
        return int(self._context.get('root.lu.scanhead.instance.attribute.type.enum.p6_mount'))

    @p6_mount.setter
    def p6_mount(self, new_val:int):
        self._context.set('root.lu.scanhead.instance.attribute.type.enum.p6_mount', int(new_val))

    @property
    def dummy11(self) -> int:
        return int(self._context.get('root.lu.scanhead.instance.attribute.type.enum.dummy11'))

    @dummy11.setter
    def dummy11(self, new_val:int):
        self._context.set('root.lu.scanhead.instance.attribute.type.enum.dummy11', int(new_val))

    @property
    def dummy10(self) -> int:
        return int(self._context.get('root.lu.scanhead.instance.attribute.type.enum.dummy10'))

    @dummy10.setter
    def dummy10(self, new_val:int):
        self._context.set('root.lu.scanhead.instance.attribute.type.enum.dummy10', int(new_val))


class RootLuScanheadInstanceAttributeType(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.scanhead.instance.attribute.type'
        self.enum = RootLuScanheadInstanceAttributeTypeEnum(self._context)


class RootLuScanheadInstanceAttributeTilt_angle_x(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.scanhead.instance.attribute.tilt_angle_x'


class RootLuScanheadInstanceAttributePte_laser_power_monitor(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.scanhead.instance.attribute.pte_laser_power_monitor'


class RootLuScanheadInstanceAttributePte_laser_setpoint(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.scanhead.instance.attribute.pte_laser_setpoint'


class RootLuScanheadInstanceAttributeReadout_laser_power_monitor(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.scanhead.instance.attribute.readout_laser_power_monitor'


class RootLuScanheadInstanceAttribute(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.scanhead.instance.attribute'
        self.readout_laser_power_monitor = RootLuScanheadInstanceAttributeReadout_laser_power_monitor(self._context)
        self.pte_laser_setpoint = RootLuScanheadInstanceAttributePte_laser_setpoint(self._context)
        self.pte_laser_power_monitor = RootLuScanheadInstanceAttributePte_laser_power_monitor(self._context)
        self.tilt_angle_x = RootLuScanheadInstanceAttributeTilt_angle_x(self._context)
        self.type = RootLuScanheadInstanceAttributeType(self._context)
        self.has_z_sensor = RootLuScanheadInstanceAttributeHas_z_sensor(self._context)
        self.tilt_mode = RootLuScanheadInstanceAttributeTilt_mode(self._context)
        self.tilt_angle_y = RootLuScanheadInstanceAttributeTilt_angle_y(self._context)
        self.fast_in2_channel = RootLuScanheadInstanceAttributeFast_in2_channel(self._context)
        self.has_xy_sensor = RootLuScanheadInstanceAttributeHas_xy_sensor(self._context)
        self.readout_laser_setpoint = RootLuScanheadInstanceAttributeReadout_laser_setpoint(self._context)


class RootLuScanheadInstance(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.scanhead.instance'
        self.attribute = RootLuScanheadInstanceAttribute(self._context)
        self.trigger = RootLuScanheadInstanceTrigger(self._context)


class RootLuScanhead(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.scanhead'
        self.instance = RootLuScanheadInstance(self._context)


class RootLuHv_amplifierInstanceTriggerSwitch_to_target_mode(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.hv_amplifier.instance.trigger.switch_to_target_mode'


class RootLuHv_amplifierInstanceTriggerStart_switch_to_target_mode(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.hv_amplifier.instance.trigger.start_switch_to_target_mode'


class RootLuHv_amplifierInstanceTriggerEnable_z_modulation(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.hv_amplifier.instance.trigger.enable_z_modulation'


class RootLuHv_amplifierInstanceTriggerDisable_power(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.hv_amplifier.instance.trigger.disable_power'


class RootLuHv_amplifierInstanceTriggerEnable_power(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.hv_amplifier.instance.trigger.enable_power'


class RootLuHv_amplifierInstanceTriggerDisable_z_modulation(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.hv_amplifier.instance.trigger.disable_z_modulation'


class RootLuHv_amplifierInstanceTriggerDepreciated_6(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.hv_amplifier.instance.trigger.depreciated_6'


class RootLuHv_amplifierInstanceTriggerEnable_module(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.hv_amplifier.instance.trigger.enable_module'


class RootLuHv_amplifierInstanceTriggerDisable_module(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.hv_amplifier.instance.trigger.disable_module'


class RootLuHv_amplifierInstanceTrigger(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.hv_amplifier.instance.trigger'
        self.disable_module = RootLuHv_amplifierInstanceTriggerDisable_module(self._context)
        self.enable_module = RootLuHv_amplifierInstanceTriggerEnable_module(self._context)
        self.depreciated_6 = RootLuHv_amplifierInstanceTriggerDepreciated_6(self._context)
        self.disable_z_modulation = RootLuHv_amplifierInstanceTriggerDisable_z_modulation(self._context)
        self.enable_power = RootLuHv_amplifierInstanceTriggerEnable_power(self._context)
        self.disable_power = RootLuHv_amplifierInstanceTriggerDisable_power(self._context)
        self.enable_z_modulation = RootLuHv_amplifierInstanceTriggerEnable_z_modulation(self._context)
        self.start_switch_to_target_mode = RootLuHv_amplifierInstanceTriggerStart_switch_to_target_mode(self._context)
        self.switch_to_target_mode = RootLuHv_amplifierInstanceTriggerSwitch_to_target_mode(self._context)


class RootLuHv_amplifierInstanceAttributeOutput_discharge_delay(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.hv_amplifier.instance.attribute.output_discharge_delay'


class RootLuHv_amplifierInstanceAttributePower_enabled(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.hv_amplifier.instance.attribute.power_enabled'


class RootLuHv_amplifierInstanceAttributeTemperature(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.hv_amplifier.instance.attribute.temperature'


class RootLuHv_amplifierInstanceAttributeZ_modulation_enabled(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.hv_amplifier.instance.attribute.z_modulation_enabled'


class RootLuHv_amplifierInstanceAttributeInterlock_open_cx_cable(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.hv_amplifier.instance.attribute.interlock_open_cx_cable'


class RootLuHv_amplifierInstanceAttributeInterlock_open_user(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.hv_amplifier.instance.attribute.interlock_open_user'


class RootLuHv_amplifierInstanceAttributeTypeEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.hv_amplifier.instance.attribute.type.enum'

    @property
    def hv180(self) -> int:
        return int(self._context.get('root.lu.hv_amplifier.instance.attribute.type.enum.hv180'))

    @hv180.setter
    def hv180(self, new_val:int):
        self._context.set('root.lu.hv_amplifier.instance.attribute.type.enum.hv180', int(new_val))

    @property
    def hv500(self) -> int:
        return int(self._context.get('root.lu.hv_amplifier.instance.attribute.type.enum.hv500'))

    @hv500.setter
    def hv500(self, new_val:int):
        self._context.set('root.lu.hv_amplifier.instance.attribute.type.enum.hv500', int(new_val))

    @property
    def unknown(self) -> int:
        return int(self._context.get('root.lu.hv_amplifier.instance.attribute.type.enum.unknown'))

    @unknown.setter
    def unknown(self, new_val:int):
        self._context.set('root.lu.hv_amplifier.instance.attribute.type.enum.unknown', int(new_val))

    @property
    def not_connected(self) -> int:
        return int(self._context.get('root.lu.hv_amplifier.instance.attribute.type.enum.not_connected'))

    @not_connected.setter
    def not_connected(self, new_val:int):
        self._context.set('root.lu.hv_amplifier.instance.attribute.type.enum.not_connected', int(new_val))

    @property
    def a201(self) -> int:
        return int(self._context.get('root.lu.hv_amplifier.instance.attribute.type.enum.a201'))

    @a201.setter
    def a201(self, new_val:int):
        self._context.set('root.lu.hv_amplifier.instance.attribute.type.enum.a201', int(new_val))


class RootLuHv_amplifierInstanceAttributeType(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.hv_amplifier.instance.attribute.type'
        self.enum = RootLuHv_amplifierInstanceAttributeTypeEnum(self._context)


class RootLuHv_amplifierInstanceAttributeInterlock_open_hv_cable(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.hv_amplifier.instance.attribute.interlock_open_hv_cable'


class RootLuHv_amplifierInstanceAttributeHv_module_enabled(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.hv_amplifier.instance.attribute.hv_module_enabled'


class RootLuHv_amplifierInstanceAttributeMode_currentEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.hv_amplifier.instance.attribute.mode_current.enum'

    @property
    def off(self) -> int:
        return int(self._context.get('root.lu.hv_amplifier.instance.attribute.mode_current.enum.off'))

    @off.setter
    def off(self, new_val:int):
        self._context.set('root.lu.hv_amplifier.instance.attribute.mode_current.enum.off', int(new_val))

    @property
    def lv(self) -> int:
        return int(self._context.get('root.lu.hv_amplifier.instance.attribute.mode_current.enum.lv'))

    @lv.setter
    def lv(self, new_val:int):
        self._context.set('root.lu.hv_amplifier.instance.attribute.mode_current.enum.lv', int(new_val))

    @property
    def hv(self) -> int:
        return int(self._context.get('root.lu.hv_amplifier.instance.attribute.mode_current.enum.hv'))

    @hv.setter
    def hv(self, new_val:int):
        self._context.set('root.lu.hv_amplifier.instance.attribute.mode_current.enum.hv', int(new_val))


class RootLuHv_amplifierInstanceAttributeMode_current(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.hv_amplifier.instance.attribute.mode_current'
        self.enum = RootLuHv_amplifierInstanceAttributeMode_currentEnum(self._context)


class RootLuHv_amplifierInstanceAttributeMode_targetEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.hv_amplifier.instance.attribute.mode_target.enum'

    @property
    def off(self) -> int:
        return int(self._context.get('root.lu.hv_amplifier.instance.attribute.mode_target.enum.off'))

    @off.setter
    def off(self, new_val:int):
        self._context.set('root.lu.hv_amplifier.instance.attribute.mode_target.enum.off', int(new_val))

    @property
    def lv(self) -> int:
        return int(self._context.get('root.lu.hv_amplifier.instance.attribute.mode_target.enum.lv'))

    @lv.setter
    def lv(self, new_val:int):
        self._context.set('root.lu.hv_amplifier.instance.attribute.mode_target.enum.lv', int(new_val))

    @property
    def hv(self) -> int:
        return int(self._context.get('root.lu.hv_amplifier.instance.attribute.mode_target.enum.hv'))

    @hv.setter
    def hv(self, new_val:int):
        self._context.set('root.lu.hv_amplifier.instance.attribute.mode_target.enum.hv', int(new_val))


class RootLuHv_amplifierInstanceAttributeMode_target(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.hv_amplifier.instance.attribute.mode_target'
        self.enum = RootLuHv_amplifierInstanceAttributeMode_targetEnum(self._context)


class RootLuHv_amplifierInstanceAttributeLast_mode_switch_retvalEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.hv_amplifier.instance.attribute.last_mode_switch_retval.enum'

    @property
    def interlock_open(self) -> int:
        return int(self._context.get('root.lu.hv_amplifier.instance.attribute.last_mode_switch_retval.enum.interlock_open'))

    @interlock_open.setter
    def interlock_open(self, new_val:int):
        self._context.set('root.lu.hv_amplifier.instance.attribute.last_mode_switch_retval.enum.interlock_open', int(new_val))

    @property
    def mode_not_supported(self) -> int:
        return int(self._context.get('root.lu.hv_amplifier.instance.attribute.last_mode_switch_retval.enum.mode_not_supported'))

    @mode_not_supported.setter
    def mode_not_supported(self, new_val:int):
        self._context.set('root.lu.hv_amplifier.instance.attribute.last_mode_switch_retval.enum.mode_not_supported', int(new_val))

    @property
    def ok(self) -> int:
        return int(self._context.get('root.lu.hv_amplifier.instance.attribute.last_mode_switch_retval.enum.ok'))

    @ok.setter
    def ok(self, new_val:int):
        self._context.set('root.lu.hv_amplifier.instance.attribute.last_mode_switch_retval.enum.ok', int(new_val))


class RootLuHv_amplifierInstanceAttributeLast_mode_switch_retval(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.hv_amplifier.instance.attribute.last_mode_switch_retval'
        self.enum = RootLuHv_amplifierInstanceAttributeLast_mode_switch_retvalEnum(self._context)


class RootLuHv_amplifierInstanceAttribute(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.hv_amplifier.instance.attribute'
        self.last_mode_switch_retval = RootLuHv_amplifierInstanceAttributeLast_mode_switch_retval(self._context)
        self.mode_target = RootLuHv_amplifierInstanceAttributeMode_target(self._context)
        self.mode_current = RootLuHv_amplifierInstanceAttributeMode_current(self._context)
        self.hv_module_enabled = RootLuHv_amplifierInstanceAttributeHv_module_enabled(self._context)
        self.interlock_open_hv_cable = RootLuHv_amplifierInstanceAttributeInterlock_open_hv_cable(self._context)
        self.type = RootLuHv_amplifierInstanceAttributeType(self._context)
        self.interlock_open_user = RootLuHv_amplifierInstanceAttributeInterlock_open_user(self._context)
        self.interlock_open_cx_cable = RootLuHv_amplifierInstanceAttributeInterlock_open_cx_cable(self._context)
        self.z_modulation_enabled = RootLuHv_amplifierInstanceAttributeZ_modulation_enabled(self._context)
        self.temperature = RootLuHv_amplifierInstanceAttributeTemperature(self._context)
        self.power_enabled = RootLuHv_amplifierInstanceAttributePower_enabled(self._context)
        self.output_discharge_delay = RootLuHv_amplifierInstanceAttributeOutput_discharge_delay(self._context)


class RootLuHv_amplifierInstance(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.hv_amplifier.instance'
        self.attribute = RootLuHv_amplifierInstanceAttribute(self._context)
        self.trigger = RootLuHv_amplifierInstanceTrigger(self._context)


class RootLuHv_amplifier(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.hv_amplifier'
        self.instance = RootLuHv_amplifierInstance(self._context)


class RootLuComp_dcInstanceTriggerApply_new_nonlinear_configuration(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.comp_dc.instance.trigger.apply_new_nonlinear_configuration'


class RootLuComp_dcInstanceTriggerRead_current_configuration(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.comp_dc.instance.trigger.read_current_configuration'


class RootLuComp_dcInstanceTriggerApply_new_configuration(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.comp_dc.instance.trigger.apply_new_configuration'


class RootLuComp_dcInstanceTriggerUser_abort(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.comp_dc.instance.trigger.user_abort'


class RootLuComp_dcInstanceTriggerStart_comp_dc_calibration(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.comp_dc.instance.trigger.start_comp_dc_calibration'


class RootLuComp_dcInstanceTrigger(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.comp_dc.instance.trigger'
        self.start_comp_dc_calibration = RootLuComp_dcInstanceTriggerStart_comp_dc_calibration(self._context)
        self.user_abort = RootLuComp_dcInstanceTriggerUser_abort(self._context)
        self.apply_new_configuration = RootLuComp_dcInstanceTriggerApply_new_configuration(self._context)
        self.read_current_configuration = RootLuComp_dcInstanceTriggerRead_current_configuration(self._context)
        self.apply_new_nonlinear_configuration = RootLuComp_dcInstanceTriggerApply_new_nonlinear_configuration(self._context)


class RootLuComp_dcInstanceAttributeComp_dc_gain_x(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.comp_dc.instance.attribute.comp_dc_gain_x'


class RootLuComp_dcInstanceAttributeCoefficient_index(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.comp_dc.instance.attribute.coefficient_index'


class RootLuComp_dcInstanceAttributeComp_dc_gain_z(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.comp_dc.instance.attribute.comp_dc_gain_z'


class RootLuComp_dcInstanceAttributeComp_dc_gain_y(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.comp_dc.instance.attribute.comp_dc_gain_y'


class RootLuComp_dcInstanceAttributeComp_dc_gain_w(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.comp_dc.instance.attribute.comp_dc_gain_w'


class RootLuComp_dcInstanceAttribute(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.comp_dc.instance.attribute'
        self.comp_dc_gain_w = RootLuComp_dcInstanceAttributeComp_dc_gain_w(self._context)
        self.comp_dc_gain_y = RootLuComp_dcInstanceAttributeComp_dc_gain_y(self._context)
        self.comp_dc_gain_z = RootLuComp_dcInstanceAttributeComp_dc_gain_z(self._context)
        self.coefficient_index = RootLuComp_dcInstanceAttributeCoefficient_index(self._context)
        self.comp_dc_gain_x = RootLuComp_dcInstanceAttributeComp_dc_gain_x(self._context)


class RootLuComp_dcInstance(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.comp_dc.instance'
        self.attribute = RootLuComp_dcInstanceAttribute(self._context)
        self.trigger = RootLuComp_dcInstanceTrigger(self._context)


class RootLuComp_dc(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.comp_dc'
        self.instance = RootLuComp_dcInstance(self._context)


class RootLuIsostageInstanceTriggerUpdate_settings(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.isostage.instance.trigger.update_settings'


class RootLuIsostageInstanceTriggerSetup_event_counter(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.isostage.instance.trigger.setup_event_counter'


class RootLuIsostageInstanceTriggerClear_event_counter(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.isostage.instance.trigger.clear_event_counter'


class RootLuIsostageInstanceTriggerTest_connection(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.isostage.instance.trigger.test_connection'


class RootLuIsostageInstanceTrigger(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.isostage.instance.trigger'
        self.test_connection = RootLuIsostageInstanceTriggerTest_connection(self._context)
        self.clear_event_counter = RootLuIsostageInstanceTriggerClear_event_counter(self._context)
        self.setup_event_counter = RootLuIsostageInstanceTriggerSetup_event_counter(self._context)
        self.update_settings = RootLuIsostageInstanceTriggerUpdate_settings(self._context)


class RootLuIsostageInstanceAttributeEvent_counter(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.isostage.instance.attribute.event_counter'


class RootLuIsostageInstanceAttributeIs_connected(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.isostage.instance.attribute.is_connected'


class RootLuIsostageInstanceAttributeIsolation_modeEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.isostage.instance.attribute.isolation_mode.enum'

    @property
    def active(self) -> int:
        return int(self._context.get('root.lu.isostage.instance.attribute.isolation_mode.enum.active'))

    @active.setter
    def active(self, new_val:int):
        self._context.set('root.lu.isostage.instance.attribute.isolation_mode.enum.active', int(new_val))

    @property
    def off_or_defined_by_user_switch(self) -> int:
        return int(self._context.get('root.lu.isostage.instance.attribute.isolation_mode.enum.off_or_defined_by_user_switch'))

    @off_or_defined_by_user_switch.setter
    def off_or_defined_by_user_switch(self, new_val:int):
        self._context.set('root.lu.isostage.instance.attribute.isolation_mode.enum.off_or_defined_by_user_switch', int(new_val))


class RootLuIsostageInstanceAttributeIsolation_mode(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.isostage.instance.attribute.isolation_mode'
        self.enum = RootLuIsostageInstanceAttributeIsolation_modeEnum(self._context)


class RootLuIsostageInstanceAttributeOverload_sensitivity(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.isostage.instance.attribute.overload_sensitivity'


class RootLuIsostageInstanceAttribute(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.isostage.instance.attribute'
        self.overload_sensitivity = RootLuIsostageInstanceAttributeOverload_sensitivity(self._context)
        self.isolation_mode = RootLuIsostageInstanceAttributeIsolation_mode(self._context)
        self.is_connected = RootLuIsostageInstanceAttributeIs_connected(self._context)
        self.event_counter = RootLuIsostageInstanceAttributeEvent_counter(self._context)


class RootLuIsostageInstance(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.isostage.instance'
        self.attribute = RootLuIsostageInstanceAttribute(self._context)
        self.trigger = RootLuIsostageInstanceTrigger(self._context)


class RootLuIsostage(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.isostage'
        self.instance = RootLuIsostageInstance(self._context)


class RootLuComparatorComparator3Trigger(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.comparator.comparator3.trigger'


class RootLuComparatorComparator3AttributeFilter_enableEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.comparator.comparator3.attribute.filter_enable.enum'

    @property
    def disabled(self) -> int:
        return int(self._context.get('root.lu.comparator.comparator3.attribute.filter_enable.enum.disabled'))

    @disabled.setter
    def disabled(self, new_val:int):
        self._context.set('root.lu.comparator.comparator3.attribute.filter_enable.enum.disabled', int(new_val))

    @property
    def enabled(self) -> int:
        return int(self._context.get('root.lu.comparator.comparator3.attribute.filter_enable.enum.enabled'))

    @enabled.setter
    def enabled(self, new_val:int):
        self._context.set('root.lu.comparator.comparator3.attribute.filter_enable.enum.enabled', int(new_val))


class RootLuComparatorComparator3AttributeFilter_enable(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.comparator.comparator3.attribute.filter_enable'
        self.enum = RootLuComparatorComparator3AttributeFilter_enableEnum(self._context)


class RootLuComparatorComparator3AttributeSourceEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.comparator.comparator3.attribute.source.enum'

    @property
    def ort_adhesion_position(self) -> int:
        return int(self._context.get('root.lu.comparator.comparator3.attribute.source.enum.ort_adhesion_position'))

    @ort_adhesion_position.setter
    def ort_adhesion_position(self, new_val:int):
        self._context.set('root.lu.comparator.comparator3.attribute.source.enum.ort_adhesion_position', int(new_val))

    @property
    def ctrl_z_pid_command(self) -> int:
        return int(self._context.get('root.lu.comparator.comparator3.attribute.source.enum.ctrl_z_pid_command'))

    @ctrl_z_pid_command.setter
    def ctrl_z_pid_command(self, new_val:int):
        self._context.set('root.lu.comparator.comparator3.attribute.source.enum.ctrl_z_pid_command', int(new_val))

    @property
    def in6(self) -> int:
        return int(self._context.get('root.lu.comparator.comparator3.attribute.source.enum.in6'))

    @in6.setter
    def in6(self, new_val:int):
        self._context.set('root.lu.comparator.comparator3.attribute.source.enum.in6', int(new_val))

    @property
    def ctrl_z_nominal(self) -> int:
        return int(self._context.get('root.lu.comparator.comparator3.attribute.source.enum.ctrl_z_nominal'))

    @ctrl_z_nominal.setter
    def ctrl_z_nominal(self, new_val:int):
        self._context.set('root.lu.comparator.comparator3.attribute.source.enum.ctrl_z_nominal', int(new_val))

    @property
    def ctrl_x_out(self) -> int:
        return int(self._context.get('root.lu.comparator.comparator3.attribute.source.enum.ctrl_x_out'))

    @ctrl_x_out.setter
    def ctrl_x_out(self, new_val:int):
        self._context.set('root.lu.comparator.comparator3.attribute.source.enum.ctrl_x_out', int(new_val))

    @property
    def memory_gen_drive_y(self) -> int:
        return int(self._context.get('root.lu.comparator.comparator3.attribute.source.enum.memory_gen_drive_y'))

    @memory_gen_drive_y.setter
    def memory_gen_drive_y(self, new_val:int):
        self._context.set('root.lu.comparator.comparator3.attribute.source.enum.memory_gen_drive_y', int(new_val))

    @property
    def ctrl_user2_out(self) -> int:
        return int(self._context.get('root.lu.comparator.comparator3.attribute.source.enum.ctrl_user2_out'))

    @ctrl_user2_out.setter
    def ctrl_user2_out(self, new_val:int):
        self._context.set('root.lu.comparator.comparator3.attribute.source.enum.ctrl_user2_out', int(new_val))

    @property
    def analyzer2_phase(self) -> int:
        return int(self._context.get('root.lu.comparator.comparator3.attribute.source.enum.analyzer2_phase'))

    @analyzer2_phase.setter
    def analyzer2_phase(self, new_val:int):
        self._context.set('root.lu.comparator.comparator3.attribute.source.enum.analyzer2_phase', int(new_val))

    @property
    def fast_in_deflection(self) -> int:
        return int(self._context.get('root.lu.comparator.comparator3.attribute.source.enum.fast_in_deflection'))

    @fast_in_deflection.setter
    def fast_in_deflection(self, new_val:int):
        self._context.set('root.lu.comparator.comparator3.attribute.source.enum.fast_in_deflection', int(new_val))

    @property
    def in_user2(self) -> int:
        return int(self._context.get('root.lu.comparator.comparator3.attribute.source.enum.in_user2'))

    @in_user2.setter
    def in_user2(self, new_val:int):
        self._context.set('root.lu.comparator.comparator3.attribute.source.enum.in_user2', int(new_val))

    @property
    def ramp_gen_position_x(self) -> int:
        return int(self._context.get('root.lu.comparator.comparator3.attribute.source.enum.ramp_gen_position_x'))

    @ramp_gen_position_x.setter
    def ramp_gen_position_x(self, new_val:int):
        self._context.set('root.lu.comparator.comparator3.attribute.source.enum.ramp_gen_position_x', int(new_val))

    @property
    def in_deflection(self) -> int:
        return int(self._context.get('root.lu.comparator.comparator3.attribute.source.enum.in_deflection'))

    @in_deflection.setter
    def in_deflection(self, new_val:int):
        self._context.set('root.lu.comparator.comparator3.attribute.source.enum.in_deflection', int(new_val))

    @property
    def ort_amplitude_reduction(self) -> int:
        return int(self._context.get('root.lu.comparator.comparator3.attribute.source.enum.ort_amplitude_reduction'))

    @ort_amplitude_reduction.setter
    def ort_amplitude_reduction(self, new_val:int):
        self._context.set('root.lu.comparator.comparator3.attribute.source.enum.ort_amplitude_reduction', int(new_val))

    @property
    def analyzer2_ctrl_amplitude(self) -> int:
        return int(self._context.get('root.lu.comparator.comparator3.attribute.source.enum.analyzer2_ctrl_amplitude'))

    @analyzer2_ctrl_amplitude.setter
    def analyzer2_ctrl_amplitude(self, new_val:int):
        self._context.set('root.lu.comparator.comparator3.attribute.source.enum.analyzer2_ctrl_amplitude', int(new_val))

    @property
    def memory_gen_drive_x(self) -> int:
        return int(self._context.get('root.lu.comparator.comparator3.attribute.source.enum.memory_gen_drive_x'))

    @memory_gen_drive_x.setter
    def memory_gen_drive_x(self, new_val:int):
        self._context.set('root.lu.comparator.comparator3.attribute.source.enum.memory_gen_drive_x', int(new_val))

    @property
    def ramp_gen_alternate_z(self) -> int:
        return int(self._context.get('root.lu.comparator.comparator3.attribute.source.enum.ramp_gen_alternate_z'))

    @ramp_gen_alternate_z.setter
    def ramp_gen_alternate_z(self, new_val:int):
        self._context.set('root.lu.comparator.comparator3.attribute.source.enum.ramp_gen_alternate_z', int(new_val))

    @property
    def analyzer2_ctrl_delta_f(self) -> int:
        return int(self._context.get('root.lu.comparator.comparator3.attribute.source.enum.analyzer2_ctrl_delta_f'))

    @analyzer2_ctrl_delta_f.setter
    def analyzer2_ctrl_delta_f(self, new_val:int):
        self._context.set('root.lu.comparator.comparator3.attribute.source.enum.analyzer2_ctrl_delta_f', int(new_val))

    @property
    def ort_excitation(self) -> int:
        return int(self._context.get('root.lu.comparator.comparator3.attribute.source.enum.ort_excitation'))

    @ort_excitation.setter
    def ort_excitation(self, new_val:int):
        self._context.set('root.lu.comparator.comparator3.attribute.source.enum.ort_excitation', int(new_val))

    @property
    def analyzer1_y(self) -> int:
        return int(self._context.get('root.lu.comparator.comparator3.attribute.source.enum.analyzer1_y'))

    @analyzer1_y.setter
    def analyzer1_y(self, new_val:int):
        self._context.set('root.lu.comparator.comparator3.attribute.source.enum.analyzer1_y', int(new_val))

    @property
    def ort_adhesion_value(self) -> int:
        return int(self._context.get('root.lu.comparator.comparator3.attribute.source.enum.ort_adhesion_value'))

    @ort_adhesion_value.setter
    def ort_adhesion_value(self, new_val:int):
        self._context.set('root.lu.comparator.comparator3.attribute.source.enum.ort_adhesion_value', int(new_val))

    @property
    def ctrl_y_out(self) -> int:
        return int(self._context.get('root.lu.comparator.comparator3.attribute.source.enum.ctrl_y_out'))

    @ctrl_y_out.setter
    def ctrl_y_out(self, new_val:int):
        self._context.set('root.lu.comparator.comparator3.attribute.source.enum.ctrl_y_out', int(new_val))

    @property
    def analyzer1_phase(self) -> int:
        return int(self._context.get('root.lu.comparator.comparator3.attribute.source.enum.analyzer1_phase'))

    @analyzer1_phase.setter
    def analyzer1_phase(self, new_val:int):
        self._context.set('root.lu.comparator.comparator3.attribute.source.enum.analyzer1_phase', int(new_val))

    @property
    def ctrl_z_out(self) -> int:
        return int(self._context.get('root.lu.comparator.comparator3.attribute.source.enum.ctrl_z_out'))

    @ctrl_z_out.setter
    def ctrl_z_out(self, new_val:int):
        self._context.set('root.lu.comparator.comparator3.attribute.source.enum.ctrl_z_out', int(new_val))

    @property
    def ctrl_w_out(self) -> int:
        return int(self._context.get('root.lu.comparator.comparator3.attribute.source.enum.ctrl_w_out'))

    @ctrl_w_out.setter
    def ctrl_w_out(self, new_val:int):
        self._context.set('root.lu.comparator.comparator3.attribute.source.enum.ctrl_w_out', int(new_val))

    @property
    def analyzer1_ctrl_amplitude(self) -> int:
        return int(self._context.get('root.lu.comparator.comparator3.attribute.source.enum.analyzer1_ctrl_amplitude'))

    @analyzer1_ctrl_amplitude.setter
    def analyzer1_ctrl_amplitude(self, new_val:int):
        self._context.set('root.lu.comparator.comparator3.attribute.source.enum.analyzer1_ctrl_amplitude', int(new_val))

    @property
    def in_user1(self) -> int:
        return int(self._context.get('root.lu.comparator.comparator3.attribute.source.enum.in_user1'))

    @in_user1.setter
    def in_user1(self, new_val:int):
        self._context.set('root.lu.comparator.comparator3.attribute.source.enum.in_user1', int(new_val))

    @property
    def ramp_gen_approach(self) -> int:
        return int(self._context.get('root.lu.comparator.comparator3.attribute.source.enum.ramp_gen_approach'))

    @ramp_gen_approach.setter
    def ramp_gen_approach(self, new_val:int):
        self._context.set('root.lu.comparator.comparator3.attribute.source.enum.ramp_gen_approach', int(new_val))

    @property
    def ramp_gen_test(self) -> int:
        return int(self._context.get('root.lu.comparator.comparator3.attribute.source.enum.ramp_gen_test'))

    @ramp_gen_test.setter
    def ramp_gen_test(self, new_val:int):
        self._context.set('root.lu.comparator.comparator3.attribute.source.enum.ramp_gen_test', int(new_val))

    @property
    def in_position_x(self) -> int:
        return int(self._context.get('root.lu.comparator.comparator3.attribute.source.enum.in_position_x'))

    @in_position_x.setter
    def in_position_x(self, new_val:int):
        self._context.set('root.lu.comparator.comparator3.attribute.source.enum.in_position_x', int(new_val))

    @property
    def analyzer1_reference(self) -> int:
        return int(self._context.get('root.lu.comparator.comparator3.attribute.source.enum.analyzer1_reference'))

    @analyzer1_reference.setter
    def analyzer1_reference(self, new_val:int):
        self._context.set('root.lu.comparator.comparator3.attribute.source.enum.analyzer1_reference', int(new_val))

    @property
    def ramp_gen_plane_z(self) -> int:
        return int(self._context.get('root.lu.comparator.comparator3.attribute.source.enum.ramp_gen_plane_z'))

    @ramp_gen_plane_z.setter
    def ramp_gen_plane_z(self, new_val:int):
        self._context.set('root.lu.comparator.comparator3.attribute.source.enum.ramp_gen_plane_z', int(new_val))

    @property
    def memory_gen_out7(self) -> int:
        return int(self._context.get('root.lu.comparator.comparator3.attribute.source.enum.memory_gen_out7'))

    @memory_gen_out7.setter
    def memory_gen_out7(self, new_val:int):
        self._context.set('root.lu.comparator.comparator3.attribute.source.enum.memory_gen_out7', int(new_val))

    @property
    def analyzer2_y(self) -> int:
        return int(self._context.get('root.lu.comparator.comparator3.attribute.source.enum.analyzer2_y'))

    @analyzer2_y.setter
    def analyzer2_y(self, new_val:int):
        self._context.set('root.lu.comparator.comparator3.attribute.source.enum.analyzer2_y', int(new_val))

    @property
    def gen_test_dynamic(self) -> int:
        return int(self._context.get('root.lu.comparator.comparator3.attribute.source.enum.gen_test_dynamic'))

    @gen_test_dynamic.setter
    def gen_test_dynamic(self, new_val:int):
        self._context.set('root.lu.comparator.comparator3.attribute.source.enum.gen_test_dynamic', int(new_val))

    @property
    def in_tip_current(self) -> int:
        return int(self._context.get('root.lu.comparator.comparator3.attribute.source.enum.in_tip_current'))

    @in_tip_current.setter
    def in_tip_current(self, new_val:int):
        self._context.set('root.lu.comparator.comparator3.attribute.source.enum.in_tip_current', int(new_val))

    @property
    def analyzer1_x(self) -> int:
        return int(self._context.get('root.lu.comparator.comparator3.attribute.source.enum.analyzer1_x'))

    @analyzer1_x.setter
    def analyzer1_x(self, new_val:int):
        self._context.set('root.lu.comparator.comparator3.attribute.source.enum.analyzer1_x', int(new_val))

    @property
    def ctrl_z_sum(self) -> int:
        return int(self._context.get('root.lu.comparator.comparator3.attribute.source.enum.ctrl_z_sum'))

    @ctrl_z_sum.setter
    def ctrl_z_sum(self, new_val:int):
        self._context.set('root.lu.comparator.comparator3.attribute.source.enum.ctrl_z_sum', int(new_val))

    @property
    def analyzer2_reference(self) -> int:
        return int(self._context.get('root.lu.comparator.comparator3.attribute.source.enum.analyzer2_reference'))

    @analyzer2_reference.setter
    def analyzer2_reference(self, new_val:int):
        self._context.set('root.lu.comparator.comparator3.attribute.source.enum.analyzer2_reference', int(new_val))

    @property
    def analyzer1_ctrl_delta_f(self) -> int:
        return int(self._context.get('root.lu.comparator.comparator3.attribute.source.enum.analyzer1_ctrl_delta_f'))

    @analyzer1_ctrl_delta_f.setter
    def analyzer1_ctrl_delta_f(self, new_val:int):
        self._context.set('root.lu.comparator.comparator3.attribute.source.enum.analyzer1_ctrl_delta_f', int(new_val))

    @property
    def in_position_z(self) -> int:
        return int(self._context.get('root.lu.comparator.comparator3.attribute.source.enum.in_position_z'))

    @in_position_z.setter
    def in_position_z(self, new_val:int):
        self._context.set('root.lu.comparator.comparator3.attribute.source.enum.in_position_z', int(new_val))

    @property
    def analyzer2_x(self) -> int:
        return int(self._context.get('root.lu.comparator.comparator3.attribute.source.enum.analyzer2_x'))

    @analyzer2_x.setter
    def analyzer2_x(self, new_val:int):
        self._context.set('root.lu.comparator.comparator3.attribute.source.enum.analyzer2_x', int(new_val))

    @property
    def static(self) -> int:
        return int(self._context.get('root.lu.comparator.comparator3.attribute.source.enum.static'))

    @static.setter
    def static(self, new_val:int):
        self._context.set('root.lu.comparator.comparator3.attribute.source.enum.static', int(new_val))

    @property
    def in_lateral(self) -> int:
        return int(self._context.get('root.lu.comparator.comparator3.attribute.source.enum.in_lateral'))

    @in_lateral.setter
    def in_lateral(self, new_val:int):
        self._context.set('root.lu.comparator.comparator3.attribute.source.enum.in_lateral', int(new_val))

    @property
    def ramp_gen_tip_voltage(self) -> int:
        return int(self._context.get('root.lu.comparator.comparator3.attribute.source.enum.ramp_gen_tip_voltage'))

    @ramp_gen_tip_voltage.setter
    def ramp_gen_tip_voltage(self, new_val:int):
        self._context.set('root.lu.comparator.comparator3.attribute.source.enum.ramp_gen_tip_voltage', int(new_val))

    @property
    def ramp_gen_position_y(self) -> int:
        return int(self._context.get('root.lu.comparator.comparator3.attribute.source.enum.ramp_gen_position_y'))

    @ramp_gen_position_y.setter
    def ramp_gen_position_y(self, new_val:int):
        self._context.set('root.lu.comparator.comparator3.attribute.source.enum.ramp_gen_position_y', int(new_val))

    @property
    def ramp_gen_position_w(self) -> int:
        return int(self._context.get('root.lu.comparator.comparator3.attribute.source.enum.ramp_gen_position_w'))

    @ramp_gen_position_w.setter
    def ramp_gen_position_w(self, new_val:int):
        self._context.set('root.lu.comparator.comparator3.attribute.source.enum.ramp_gen_position_w', int(new_val))

    @property
    def ramp_gen_ctrl_z(self) -> int:
        return int(self._context.get('root.lu.comparator.comparator3.attribute.source.enum.ramp_gen_ctrl_z'))

    @ramp_gen_ctrl_z.setter
    def ramp_gen_ctrl_z(self, new_val:int):
        self._context.set('root.lu.comparator.comparator3.attribute.source.enum.ramp_gen_ctrl_z', int(new_val))

    @property
    def memory_gen_position_x(self) -> int:
        return int(self._context.get('root.lu.comparator.comparator3.attribute.source.enum.memory_gen_position_x'))

    @memory_gen_position_x.setter
    def memory_gen_position_x(self, new_val:int):
        self._context.set('root.lu.comparator.comparator3.attribute.source.enum.memory_gen_position_x', int(new_val))

    @property
    def in_user3(self) -> int:
        return int(self._context.get('root.lu.comparator.comparator3.attribute.source.enum.in_user3'))

    @in_user3.setter
    def in_user3(self, new_val:int):
        self._context.set('root.lu.comparator.comparator3.attribute.source.enum.in_user3', int(new_val))

    @property
    def in_position_y(self) -> int:
        return int(self._context.get('root.lu.comparator.comparator3.attribute.source.enum.in_position_y'))

    @in_position_y.setter
    def in_position_y(self, new_val:int):
        self._context.set('root.lu.comparator.comparator3.attribute.source.enum.in_position_y', int(new_val))

    @property
    def in_user4(self) -> int:
        return int(self._context.get('root.lu.comparator.comparator3.attribute.source.enum.in_user4'))

    @in_user4.setter
    def in_user4(self, new_val:int):
        self._context.set('root.lu.comparator.comparator3.attribute.source.enum.in_user4', int(new_val))

    @property
    def ramp_gen_max_z(self) -> int:
        return int(self._context.get('root.lu.comparator.comparator3.attribute.source.enum.ramp_gen_max_z'))

    @ramp_gen_max_z.setter
    def ramp_gen_max_z(self, new_val:int):
        self._context.set('root.lu.comparator.comparator3.attribute.source.enum.ramp_gen_max_z', int(new_val))

    @property
    def ort_free_wave(self) -> int:
        return int(self._context.get('root.lu.comparator.comparator3.attribute.source.enum.ort_free_wave'))

    @ort_free_wave.setter
    def ort_free_wave(self, new_val:int):
        self._context.set('root.lu.comparator.comparator3.attribute.source.enum.ort_free_wave', int(new_val))

    @property
    def ort_baseline_corrected(self) -> int:
        return int(self._context.get('root.lu.comparator.comparator3.attribute.source.enum.ort_baseline_corrected'))

    @ort_baseline_corrected.setter
    def ort_baseline_corrected(self, new_val:int):
        self._context.set('root.lu.comparator.comparator3.attribute.source.enum.ort_baseline_corrected', int(new_val))

    @property
    def ort_baseline(self) -> int:
        return int(self._context.get('root.lu.comparator.comparator3.attribute.source.enum.ort_baseline'))

    @ort_baseline.setter
    def ort_baseline(self, new_val:int):
        self._context.set('root.lu.comparator.comparator3.attribute.source.enum.ort_baseline', int(new_val))

    @property
    def fast_in2(self) -> int:
        return int(self._context.get('root.lu.comparator.comparator3.attribute.source.enum.fast_in2'))

    @fast_in2.setter
    def fast_in2(self, new_val:int):
        self._context.set('root.lu.comparator.comparator3.attribute.source.enum.fast_in2', int(new_val))

    @property
    def ctrl_z_error(self) -> int:
        return int(self._context.get('root.lu.comparator.comparator3.attribute.source.enum.ctrl_z_error'))

    @ctrl_z_error.setter
    def ctrl_z_error(self, new_val:int):
        self._context.set('root.lu.comparator.comparator3.attribute.source.enum.ctrl_z_error', int(new_val))

    @property
    def memory_gen_position_z(self) -> int:
        return int(self._context.get('root.lu.comparator.comparator3.attribute.source.enum.memory_gen_position_z'))

    @memory_gen_position_z.setter
    def memory_gen_position_z(self, new_val:int):
        self._context.set('root.lu.comparator.comparator3.attribute.source.enum.memory_gen_position_z', int(new_val))

    @property
    def fast_in_user(self) -> int:
        return int(self._context.get('root.lu.comparator.comparator3.attribute.source.enum.fast_in_user'))

    @fast_in_user.setter
    def fast_in_user(self, new_val:int):
        self._context.set('root.lu.comparator.comparator3.attribute.source.enum.fast_in_user', int(new_val))

    @property
    def memory_gen_position_y(self) -> int:
        return int(self._context.get('root.lu.comparator.comparator3.attribute.source.enum.memory_gen_position_y'))

    @memory_gen_position_y.setter
    def memory_gen_position_y(self, new_val:int):
        self._context.set('root.lu.comparator.comparator3.attribute.source.enum.memory_gen_position_y', int(new_val))

    @property
    def analyzer2_amplitude(self) -> int:
        return int(self._context.get('root.lu.comparator.comparator3.attribute.source.enum.analyzer2_amplitude'))

    @analyzer2_amplitude.setter
    def analyzer2_amplitude(self, new_val:int):
        self._context.set('root.lu.comparator.comparator3.attribute.source.enum.analyzer2_amplitude', int(new_val))

    @property
    def memory_gen_out8(self) -> int:
        return int(self._context.get('root.lu.comparator.comparator3.attribute.source.enum.memory_gen_out8'))

    @memory_gen_out8.setter
    def memory_gen_out8(self, new_val:int):
        self._context.set('root.lu.comparator.comparator3.attribute.source.enum.memory_gen_out8', int(new_val))

    @property
    def memory_gen_drive_z(self) -> int:
        return int(self._context.get('root.lu.comparator.comparator3.attribute.source.enum.memory_gen_drive_z'))

    @memory_gen_drive_z.setter
    def memory_gen_drive_z(self, new_val:int):
        self._context.set('root.lu.comparator.comparator3.attribute.source.enum.memory_gen_drive_z', int(new_val))

    @property
    def ramp_gen_user4(self) -> int:
        return int(self._context.get('root.lu.comparator.comparator3.attribute.source.enum.ramp_gen_user4'))

    @ramp_gen_user4.setter
    def ramp_gen_user4(self, new_val:int):
        self._context.set('root.lu.comparator.comparator3.attribute.source.enum.ramp_gen_user4', int(new_val))

    @property
    def analyzer1_amplitude(self) -> int:
        return int(self._context.get('root.lu.comparator.comparator3.attribute.source.enum.analyzer1_amplitude'))

    @analyzer1_amplitude.setter
    def analyzer1_amplitude(self, new_val:int):
        self._context.set('root.lu.comparator.comparator3.attribute.source.enum.analyzer1_amplitude', int(new_val))

    @property
    def in_detector_sum(self) -> int:
        return int(self._context.get('root.lu.comparator.comparator3.attribute.source.enum.in_detector_sum'))

    @in_detector_sum.setter
    def in_detector_sum(self, new_val:int):
        self._context.set('root.lu.comparator.comparator3.attribute.source.enum.in_detector_sum', int(new_val))

    @property
    def ctrl_z_in(self) -> int:
        return int(self._context.get('root.lu.comparator.comparator3.attribute.source.enum.ctrl_z_in'))

    @ctrl_z_in.setter
    def ctrl_z_in(self, new_val:int):
        self._context.set('root.lu.comparator.comparator3.attribute.source.enum.ctrl_z_in', int(new_val))

    @property
    def ctrl_user1_out(self) -> int:
        return int(self._context.get('root.lu.comparator.comparator3.attribute.source.enum.ctrl_user1_out'))

    @ctrl_user1_out.setter
    def ctrl_user1_out(self, new_val:int):
        self._context.set('root.lu.comparator.comparator3.attribute.source.enum.ctrl_user1_out', int(new_val))


class RootLuComparatorComparator3AttributeSource(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.comparator.comparator3.attribute.source'
        self.enum = RootLuComparatorComparator3AttributeSourceEnum(self._context)


class RootLuComparatorComparator3AttributeFilter_coeff_vec(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.comparator.comparator3.attribute.filter_coeff_vec'


class RootLuComparatorComparator3AttributeLevel(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.comparator.comparator3.attribute.level'


class RootLuComparatorComparator3AttributePolarityEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.comparator.comparator3.attribute.polarity.enum'

    @property
    def equal_or_lower_than(self) -> int:
        return int(self._context.get('root.lu.comparator.comparator3.attribute.polarity.enum.equal_or_lower_than'))

    @equal_or_lower_than.setter
    def equal_or_lower_than(self, new_val:int):
        self._context.set('root.lu.comparator.comparator3.attribute.polarity.enum.equal_or_lower_than', int(new_val))

    @property
    def equal_or_higher_than(self) -> int:
        return int(self._context.get('root.lu.comparator.comparator3.attribute.polarity.enum.equal_or_higher_than'))

    @equal_or_higher_than.setter
    def equal_or_higher_than(self, new_val:int):
        self._context.set('root.lu.comparator.comparator3.attribute.polarity.enum.equal_or_higher_than', int(new_val))


class RootLuComparatorComparator3AttributePolarity(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.comparator.comparator3.attribute.polarity'
        self.enum = RootLuComparatorComparator3AttributePolarityEnum(self._context)


class RootLuComparatorComparator3Attribute(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.comparator.comparator3.attribute'
        self.polarity = RootLuComparatorComparator3AttributePolarity(self._context)
        self.level = RootLuComparatorComparator3AttributeLevel(self._context)
        self.filter_coeff_vec = RootLuComparatorComparator3AttributeFilter_coeff_vec(self._context)
        self.source = RootLuComparatorComparator3AttributeSource(self._context)
        self.filter_enable = RootLuComparatorComparator3AttributeFilter_enable(self._context)


class RootLuComparatorComparator3(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.comparator.comparator3'
        self.attribute = RootLuComparatorComparator3Attribute(self._context)
        self.trigger = RootLuComparatorComparator3Trigger(self._context)


class RootLuComparatorComparator2Trigger(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.comparator.comparator2.trigger'


class RootLuComparatorComparator2AttributeFilter_enableEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.comparator.comparator2.attribute.filter_enable.enum'

    @property
    def disabled(self) -> int:
        return int(self._context.get('root.lu.comparator.comparator2.attribute.filter_enable.enum.disabled'))

    @disabled.setter
    def disabled(self, new_val:int):
        self._context.set('root.lu.comparator.comparator2.attribute.filter_enable.enum.disabled', int(new_val))

    @property
    def enabled(self) -> int:
        return int(self._context.get('root.lu.comparator.comparator2.attribute.filter_enable.enum.enabled'))

    @enabled.setter
    def enabled(self, new_val:int):
        self._context.set('root.lu.comparator.comparator2.attribute.filter_enable.enum.enabled', int(new_val))


class RootLuComparatorComparator2AttributeFilter_enable(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.comparator.comparator2.attribute.filter_enable'
        self.enum = RootLuComparatorComparator2AttributeFilter_enableEnum(self._context)


class RootLuComparatorComparator2AttributeSourceEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.comparator.comparator2.attribute.source.enum'

    @property
    def ort_adhesion_position(self) -> int:
        return int(self._context.get('root.lu.comparator.comparator2.attribute.source.enum.ort_adhesion_position'))

    @ort_adhesion_position.setter
    def ort_adhesion_position(self, new_val:int):
        self._context.set('root.lu.comparator.comparator2.attribute.source.enum.ort_adhesion_position', int(new_val))

    @property
    def ctrl_z_pid_command(self) -> int:
        return int(self._context.get('root.lu.comparator.comparator2.attribute.source.enum.ctrl_z_pid_command'))

    @ctrl_z_pid_command.setter
    def ctrl_z_pid_command(self, new_val:int):
        self._context.set('root.lu.comparator.comparator2.attribute.source.enum.ctrl_z_pid_command', int(new_val))

    @property
    def in6(self) -> int:
        return int(self._context.get('root.lu.comparator.comparator2.attribute.source.enum.in6'))

    @in6.setter
    def in6(self, new_val:int):
        self._context.set('root.lu.comparator.comparator2.attribute.source.enum.in6', int(new_val))

    @property
    def ctrl_z_nominal(self) -> int:
        return int(self._context.get('root.lu.comparator.comparator2.attribute.source.enum.ctrl_z_nominal'))

    @ctrl_z_nominal.setter
    def ctrl_z_nominal(self, new_val:int):
        self._context.set('root.lu.comparator.comparator2.attribute.source.enum.ctrl_z_nominal', int(new_val))

    @property
    def ctrl_x_out(self) -> int:
        return int(self._context.get('root.lu.comparator.comparator2.attribute.source.enum.ctrl_x_out'))

    @ctrl_x_out.setter
    def ctrl_x_out(self, new_val:int):
        self._context.set('root.lu.comparator.comparator2.attribute.source.enum.ctrl_x_out', int(new_val))

    @property
    def memory_gen_drive_y(self) -> int:
        return int(self._context.get('root.lu.comparator.comparator2.attribute.source.enum.memory_gen_drive_y'))

    @memory_gen_drive_y.setter
    def memory_gen_drive_y(self, new_val:int):
        self._context.set('root.lu.comparator.comparator2.attribute.source.enum.memory_gen_drive_y', int(new_val))

    @property
    def ctrl_user2_out(self) -> int:
        return int(self._context.get('root.lu.comparator.comparator2.attribute.source.enum.ctrl_user2_out'))

    @ctrl_user2_out.setter
    def ctrl_user2_out(self, new_val:int):
        self._context.set('root.lu.comparator.comparator2.attribute.source.enum.ctrl_user2_out', int(new_val))

    @property
    def analyzer2_phase(self) -> int:
        return int(self._context.get('root.lu.comparator.comparator2.attribute.source.enum.analyzer2_phase'))

    @analyzer2_phase.setter
    def analyzer2_phase(self, new_val:int):
        self._context.set('root.lu.comparator.comparator2.attribute.source.enum.analyzer2_phase', int(new_val))

    @property
    def fast_in_deflection(self) -> int:
        return int(self._context.get('root.lu.comparator.comparator2.attribute.source.enum.fast_in_deflection'))

    @fast_in_deflection.setter
    def fast_in_deflection(self, new_val:int):
        self._context.set('root.lu.comparator.comparator2.attribute.source.enum.fast_in_deflection', int(new_val))

    @property
    def in_user2(self) -> int:
        return int(self._context.get('root.lu.comparator.comparator2.attribute.source.enum.in_user2'))

    @in_user2.setter
    def in_user2(self, new_val:int):
        self._context.set('root.lu.comparator.comparator2.attribute.source.enum.in_user2', int(new_val))

    @property
    def ramp_gen_position_x(self) -> int:
        return int(self._context.get('root.lu.comparator.comparator2.attribute.source.enum.ramp_gen_position_x'))

    @ramp_gen_position_x.setter
    def ramp_gen_position_x(self, new_val:int):
        self._context.set('root.lu.comparator.comparator2.attribute.source.enum.ramp_gen_position_x', int(new_val))

    @property
    def in_deflection(self) -> int:
        return int(self._context.get('root.lu.comparator.comparator2.attribute.source.enum.in_deflection'))

    @in_deflection.setter
    def in_deflection(self, new_val:int):
        self._context.set('root.lu.comparator.comparator2.attribute.source.enum.in_deflection', int(new_val))

    @property
    def ort_amplitude_reduction(self) -> int:
        return int(self._context.get('root.lu.comparator.comparator2.attribute.source.enum.ort_amplitude_reduction'))

    @ort_amplitude_reduction.setter
    def ort_amplitude_reduction(self, new_val:int):
        self._context.set('root.lu.comparator.comparator2.attribute.source.enum.ort_amplitude_reduction', int(new_val))

    @property
    def analyzer2_ctrl_amplitude(self) -> int:
        return int(self._context.get('root.lu.comparator.comparator2.attribute.source.enum.analyzer2_ctrl_amplitude'))

    @analyzer2_ctrl_amplitude.setter
    def analyzer2_ctrl_amplitude(self, new_val:int):
        self._context.set('root.lu.comparator.comparator2.attribute.source.enum.analyzer2_ctrl_amplitude', int(new_val))

    @property
    def memory_gen_drive_x(self) -> int:
        return int(self._context.get('root.lu.comparator.comparator2.attribute.source.enum.memory_gen_drive_x'))

    @memory_gen_drive_x.setter
    def memory_gen_drive_x(self, new_val:int):
        self._context.set('root.lu.comparator.comparator2.attribute.source.enum.memory_gen_drive_x', int(new_val))

    @property
    def ramp_gen_alternate_z(self) -> int:
        return int(self._context.get('root.lu.comparator.comparator2.attribute.source.enum.ramp_gen_alternate_z'))

    @ramp_gen_alternate_z.setter
    def ramp_gen_alternate_z(self, new_val:int):
        self._context.set('root.lu.comparator.comparator2.attribute.source.enum.ramp_gen_alternate_z', int(new_val))

    @property
    def analyzer2_ctrl_delta_f(self) -> int:
        return int(self._context.get('root.lu.comparator.comparator2.attribute.source.enum.analyzer2_ctrl_delta_f'))

    @analyzer2_ctrl_delta_f.setter
    def analyzer2_ctrl_delta_f(self, new_val:int):
        self._context.set('root.lu.comparator.comparator2.attribute.source.enum.analyzer2_ctrl_delta_f', int(new_val))

    @property
    def ort_excitation(self) -> int:
        return int(self._context.get('root.lu.comparator.comparator2.attribute.source.enum.ort_excitation'))

    @ort_excitation.setter
    def ort_excitation(self, new_val:int):
        self._context.set('root.lu.comparator.comparator2.attribute.source.enum.ort_excitation', int(new_val))

    @property
    def analyzer1_y(self) -> int:
        return int(self._context.get('root.lu.comparator.comparator2.attribute.source.enum.analyzer1_y'))

    @analyzer1_y.setter
    def analyzer1_y(self, new_val:int):
        self._context.set('root.lu.comparator.comparator2.attribute.source.enum.analyzer1_y', int(new_val))

    @property
    def ort_adhesion_value(self) -> int:
        return int(self._context.get('root.lu.comparator.comparator2.attribute.source.enum.ort_adhesion_value'))

    @ort_adhesion_value.setter
    def ort_adhesion_value(self, new_val:int):
        self._context.set('root.lu.comparator.comparator2.attribute.source.enum.ort_adhesion_value', int(new_val))

    @property
    def ctrl_y_out(self) -> int:
        return int(self._context.get('root.lu.comparator.comparator2.attribute.source.enum.ctrl_y_out'))

    @ctrl_y_out.setter
    def ctrl_y_out(self, new_val:int):
        self._context.set('root.lu.comparator.comparator2.attribute.source.enum.ctrl_y_out', int(new_val))

    @property
    def analyzer1_phase(self) -> int:
        return int(self._context.get('root.lu.comparator.comparator2.attribute.source.enum.analyzer1_phase'))

    @analyzer1_phase.setter
    def analyzer1_phase(self, new_val:int):
        self._context.set('root.lu.comparator.comparator2.attribute.source.enum.analyzer1_phase', int(new_val))

    @property
    def ctrl_z_out(self) -> int:
        return int(self._context.get('root.lu.comparator.comparator2.attribute.source.enum.ctrl_z_out'))

    @ctrl_z_out.setter
    def ctrl_z_out(self, new_val:int):
        self._context.set('root.lu.comparator.comparator2.attribute.source.enum.ctrl_z_out', int(new_val))

    @property
    def ctrl_w_out(self) -> int:
        return int(self._context.get('root.lu.comparator.comparator2.attribute.source.enum.ctrl_w_out'))

    @ctrl_w_out.setter
    def ctrl_w_out(self, new_val:int):
        self._context.set('root.lu.comparator.comparator2.attribute.source.enum.ctrl_w_out', int(new_val))

    @property
    def analyzer1_ctrl_amplitude(self) -> int:
        return int(self._context.get('root.lu.comparator.comparator2.attribute.source.enum.analyzer1_ctrl_amplitude'))

    @analyzer1_ctrl_amplitude.setter
    def analyzer1_ctrl_amplitude(self, new_val:int):
        self._context.set('root.lu.comparator.comparator2.attribute.source.enum.analyzer1_ctrl_amplitude', int(new_val))

    @property
    def in_user1(self) -> int:
        return int(self._context.get('root.lu.comparator.comparator2.attribute.source.enum.in_user1'))

    @in_user1.setter
    def in_user1(self, new_val:int):
        self._context.set('root.lu.comparator.comparator2.attribute.source.enum.in_user1', int(new_val))

    @property
    def ramp_gen_approach(self) -> int:
        return int(self._context.get('root.lu.comparator.comparator2.attribute.source.enum.ramp_gen_approach'))

    @ramp_gen_approach.setter
    def ramp_gen_approach(self, new_val:int):
        self._context.set('root.lu.comparator.comparator2.attribute.source.enum.ramp_gen_approach', int(new_val))

    @property
    def ramp_gen_test(self) -> int:
        return int(self._context.get('root.lu.comparator.comparator2.attribute.source.enum.ramp_gen_test'))

    @ramp_gen_test.setter
    def ramp_gen_test(self, new_val:int):
        self._context.set('root.lu.comparator.comparator2.attribute.source.enum.ramp_gen_test', int(new_val))

    @property
    def in_position_x(self) -> int:
        return int(self._context.get('root.lu.comparator.comparator2.attribute.source.enum.in_position_x'))

    @in_position_x.setter
    def in_position_x(self, new_val:int):
        self._context.set('root.lu.comparator.comparator2.attribute.source.enum.in_position_x', int(new_val))

    @property
    def analyzer1_reference(self) -> int:
        return int(self._context.get('root.lu.comparator.comparator2.attribute.source.enum.analyzer1_reference'))

    @analyzer1_reference.setter
    def analyzer1_reference(self, new_val:int):
        self._context.set('root.lu.comparator.comparator2.attribute.source.enum.analyzer1_reference', int(new_val))

    @property
    def ramp_gen_plane_z(self) -> int:
        return int(self._context.get('root.lu.comparator.comparator2.attribute.source.enum.ramp_gen_plane_z'))

    @ramp_gen_plane_z.setter
    def ramp_gen_plane_z(self, new_val:int):
        self._context.set('root.lu.comparator.comparator2.attribute.source.enum.ramp_gen_plane_z', int(new_val))

    @property
    def memory_gen_out7(self) -> int:
        return int(self._context.get('root.lu.comparator.comparator2.attribute.source.enum.memory_gen_out7'))

    @memory_gen_out7.setter
    def memory_gen_out7(self, new_val:int):
        self._context.set('root.lu.comparator.comparator2.attribute.source.enum.memory_gen_out7', int(new_val))

    @property
    def analyzer2_y(self) -> int:
        return int(self._context.get('root.lu.comparator.comparator2.attribute.source.enum.analyzer2_y'))

    @analyzer2_y.setter
    def analyzer2_y(self, new_val:int):
        self._context.set('root.lu.comparator.comparator2.attribute.source.enum.analyzer2_y', int(new_val))

    @property
    def gen_test_dynamic(self) -> int:
        return int(self._context.get('root.lu.comparator.comparator2.attribute.source.enum.gen_test_dynamic'))

    @gen_test_dynamic.setter
    def gen_test_dynamic(self, new_val:int):
        self._context.set('root.lu.comparator.comparator2.attribute.source.enum.gen_test_dynamic', int(new_val))

    @property
    def in_tip_current(self) -> int:
        return int(self._context.get('root.lu.comparator.comparator2.attribute.source.enum.in_tip_current'))

    @in_tip_current.setter
    def in_tip_current(self, new_val:int):
        self._context.set('root.lu.comparator.comparator2.attribute.source.enum.in_tip_current', int(new_val))

    @property
    def analyzer1_x(self) -> int:
        return int(self._context.get('root.lu.comparator.comparator2.attribute.source.enum.analyzer1_x'))

    @analyzer1_x.setter
    def analyzer1_x(self, new_val:int):
        self._context.set('root.lu.comparator.comparator2.attribute.source.enum.analyzer1_x', int(new_val))

    @property
    def ctrl_z_sum(self) -> int:
        return int(self._context.get('root.lu.comparator.comparator2.attribute.source.enum.ctrl_z_sum'))

    @ctrl_z_sum.setter
    def ctrl_z_sum(self, new_val:int):
        self._context.set('root.lu.comparator.comparator2.attribute.source.enum.ctrl_z_sum', int(new_val))

    @property
    def analyzer2_reference(self) -> int:
        return int(self._context.get('root.lu.comparator.comparator2.attribute.source.enum.analyzer2_reference'))

    @analyzer2_reference.setter
    def analyzer2_reference(self, new_val:int):
        self._context.set('root.lu.comparator.comparator2.attribute.source.enum.analyzer2_reference', int(new_val))

    @property
    def analyzer1_ctrl_delta_f(self) -> int:
        return int(self._context.get('root.lu.comparator.comparator2.attribute.source.enum.analyzer1_ctrl_delta_f'))

    @analyzer1_ctrl_delta_f.setter
    def analyzer1_ctrl_delta_f(self, new_val:int):
        self._context.set('root.lu.comparator.comparator2.attribute.source.enum.analyzer1_ctrl_delta_f', int(new_val))

    @property
    def in_position_z(self) -> int:
        return int(self._context.get('root.lu.comparator.comparator2.attribute.source.enum.in_position_z'))

    @in_position_z.setter
    def in_position_z(self, new_val:int):
        self._context.set('root.lu.comparator.comparator2.attribute.source.enum.in_position_z', int(new_val))

    @property
    def analyzer2_x(self) -> int:
        return int(self._context.get('root.lu.comparator.comparator2.attribute.source.enum.analyzer2_x'))

    @analyzer2_x.setter
    def analyzer2_x(self, new_val:int):
        self._context.set('root.lu.comparator.comparator2.attribute.source.enum.analyzer2_x', int(new_val))

    @property
    def static(self) -> int:
        return int(self._context.get('root.lu.comparator.comparator2.attribute.source.enum.static'))

    @static.setter
    def static(self, new_val:int):
        self._context.set('root.lu.comparator.comparator2.attribute.source.enum.static', int(new_val))

    @property
    def in_lateral(self) -> int:
        return int(self._context.get('root.lu.comparator.comparator2.attribute.source.enum.in_lateral'))

    @in_lateral.setter
    def in_lateral(self, new_val:int):
        self._context.set('root.lu.comparator.comparator2.attribute.source.enum.in_lateral', int(new_val))

    @property
    def ramp_gen_tip_voltage(self) -> int:
        return int(self._context.get('root.lu.comparator.comparator2.attribute.source.enum.ramp_gen_tip_voltage'))

    @ramp_gen_tip_voltage.setter
    def ramp_gen_tip_voltage(self, new_val:int):
        self._context.set('root.lu.comparator.comparator2.attribute.source.enum.ramp_gen_tip_voltage', int(new_val))

    @property
    def ramp_gen_position_y(self) -> int:
        return int(self._context.get('root.lu.comparator.comparator2.attribute.source.enum.ramp_gen_position_y'))

    @ramp_gen_position_y.setter
    def ramp_gen_position_y(self, new_val:int):
        self._context.set('root.lu.comparator.comparator2.attribute.source.enum.ramp_gen_position_y', int(new_val))

    @property
    def ramp_gen_position_w(self) -> int:
        return int(self._context.get('root.lu.comparator.comparator2.attribute.source.enum.ramp_gen_position_w'))

    @ramp_gen_position_w.setter
    def ramp_gen_position_w(self, new_val:int):
        self._context.set('root.lu.comparator.comparator2.attribute.source.enum.ramp_gen_position_w', int(new_val))

    @property
    def ramp_gen_ctrl_z(self) -> int:
        return int(self._context.get('root.lu.comparator.comparator2.attribute.source.enum.ramp_gen_ctrl_z'))

    @ramp_gen_ctrl_z.setter
    def ramp_gen_ctrl_z(self, new_val:int):
        self._context.set('root.lu.comparator.comparator2.attribute.source.enum.ramp_gen_ctrl_z', int(new_val))

    @property
    def memory_gen_position_x(self) -> int:
        return int(self._context.get('root.lu.comparator.comparator2.attribute.source.enum.memory_gen_position_x'))

    @memory_gen_position_x.setter
    def memory_gen_position_x(self, new_val:int):
        self._context.set('root.lu.comparator.comparator2.attribute.source.enum.memory_gen_position_x', int(new_val))

    @property
    def in_user3(self) -> int:
        return int(self._context.get('root.lu.comparator.comparator2.attribute.source.enum.in_user3'))

    @in_user3.setter
    def in_user3(self, new_val:int):
        self._context.set('root.lu.comparator.comparator2.attribute.source.enum.in_user3', int(new_val))

    @property
    def in_position_y(self) -> int:
        return int(self._context.get('root.lu.comparator.comparator2.attribute.source.enum.in_position_y'))

    @in_position_y.setter
    def in_position_y(self, new_val:int):
        self._context.set('root.lu.comparator.comparator2.attribute.source.enum.in_position_y', int(new_val))

    @property
    def in_user4(self) -> int:
        return int(self._context.get('root.lu.comparator.comparator2.attribute.source.enum.in_user4'))

    @in_user4.setter
    def in_user4(self, new_val:int):
        self._context.set('root.lu.comparator.comparator2.attribute.source.enum.in_user4', int(new_val))

    @property
    def ramp_gen_max_z(self) -> int:
        return int(self._context.get('root.lu.comparator.comparator2.attribute.source.enum.ramp_gen_max_z'))

    @ramp_gen_max_z.setter
    def ramp_gen_max_z(self, new_val:int):
        self._context.set('root.lu.comparator.comparator2.attribute.source.enum.ramp_gen_max_z', int(new_val))

    @property
    def ort_free_wave(self) -> int:
        return int(self._context.get('root.lu.comparator.comparator2.attribute.source.enum.ort_free_wave'))

    @ort_free_wave.setter
    def ort_free_wave(self, new_val:int):
        self._context.set('root.lu.comparator.comparator2.attribute.source.enum.ort_free_wave', int(new_val))

    @property
    def ort_baseline_corrected(self) -> int:
        return int(self._context.get('root.lu.comparator.comparator2.attribute.source.enum.ort_baseline_corrected'))

    @ort_baseline_corrected.setter
    def ort_baseline_corrected(self, new_val:int):
        self._context.set('root.lu.comparator.comparator2.attribute.source.enum.ort_baseline_corrected', int(new_val))

    @property
    def ort_baseline(self) -> int:
        return int(self._context.get('root.lu.comparator.comparator2.attribute.source.enum.ort_baseline'))

    @ort_baseline.setter
    def ort_baseline(self, new_val:int):
        self._context.set('root.lu.comparator.comparator2.attribute.source.enum.ort_baseline', int(new_val))

    @property
    def fast_in2(self) -> int:
        return int(self._context.get('root.lu.comparator.comparator2.attribute.source.enum.fast_in2'))

    @fast_in2.setter
    def fast_in2(self, new_val:int):
        self._context.set('root.lu.comparator.comparator2.attribute.source.enum.fast_in2', int(new_val))

    @property
    def ctrl_z_error(self) -> int:
        return int(self._context.get('root.lu.comparator.comparator2.attribute.source.enum.ctrl_z_error'))

    @ctrl_z_error.setter
    def ctrl_z_error(self, new_val:int):
        self._context.set('root.lu.comparator.comparator2.attribute.source.enum.ctrl_z_error', int(new_val))

    @property
    def memory_gen_position_z(self) -> int:
        return int(self._context.get('root.lu.comparator.comparator2.attribute.source.enum.memory_gen_position_z'))

    @memory_gen_position_z.setter
    def memory_gen_position_z(self, new_val:int):
        self._context.set('root.lu.comparator.comparator2.attribute.source.enum.memory_gen_position_z', int(new_val))

    @property
    def fast_in_user(self) -> int:
        return int(self._context.get('root.lu.comparator.comparator2.attribute.source.enum.fast_in_user'))

    @fast_in_user.setter
    def fast_in_user(self, new_val:int):
        self._context.set('root.lu.comparator.comparator2.attribute.source.enum.fast_in_user', int(new_val))

    @property
    def memory_gen_position_y(self) -> int:
        return int(self._context.get('root.lu.comparator.comparator2.attribute.source.enum.memory_gen_position_y'))

    @memory_gen_position_y.setter
    def memory_gen_position_y(self, new_val:int):
        self._context.set('root.lu.comparator.comparator2.attribute.source.enum.memory_gen_position_y', int(new_val))

    @property
    def analyzer2_amplitude(self) -> int:
        return int(self._context.get('root.lu.comparator.comparator2.attribute.source.enum.analyzer2_amplitude'))

    @analyzer2_amplitude.setter
    def analyzer2_amplitude(self, new_val:int):
        self._context.set('root.lu.comparator.comparator2.attribute.source.enum.analyzer2_amplitude', int(new_val))

    @property
    def memory_gen_out8(self) -> int:
        return int(self._context.get('root.lu.comparator.comparator2.attribute.source.enum.memory_gen_out8'))

    @memory_gen_out8.setter
    def memory_gen_out8(self, new_val:int):
        self._context.set('root.lu.comparator.comparator2.attribute.source.enum.memory_gen_out8', int(new_val))

    @property
    def memory_gen_drive_z(self) -> int:
        return int(self._context.get('root.lu.comparator.comparator2.attribute.source.enum.memory_gen_drive_z'))

    @memory_gen_drive_z.setter
    def memory_gen_drive_z(self, new_val:int):
        self._context.set('root.lu.comparator.comparator2.attribute.source.enum.memory_gen_drive_z', int(new_val))

    @property
    def ramp_gen_user4(self) -> int:
        return int(self._context.get('root.lu.comparator.comparator2.attribute.source.enum.ramp_gen_user4'))

    @ramp_gen_user4.setter
    def ramp_gen_user4(self, new_val:int):
        self._context.set('root.lu.comparator.comparator2.attribute.source.enum.ramp_gen_user4', int(new_val))

    @property
    def analyzer1_amplitude(self) -> int:
        return int(self._context.get('root.lu.comparator.comparator2.attribute.source.enum.analyzer1_amplitude'))

    @analyzer1_amplitude.setter
    def analyzer1_amplitude(self, new_val:int):
        self._context.set('root.lu.comparator.comparator2.attribute.source.enum.analyzer1_amplitude', int(new_val))

    @property
    def in_detector_sum(self) -> int:
        return int(self._context.get('root.lu.comparator.comparator2.attribute.source.enum.in_detector_sum'))

    @in_detector_sum.setter
    def in_detector_sum(self, new_val:int):
        self._context.set('root.lu.comparator.comparator2.attribute.source.enum.in_detector_sum', int(new_val))

    @property
    def ctrl_z_in(self) -> int:
        return int(self._context.get('root.lu.comparator.comparator2.attribute.source.enum.ctrl_z_in'))

    @ctrl_z_in.setter
    def ctrl_z_in(self, new_val:int):
        self._context.set('root.lu.comparator.comparator2.attribute.source.enum.ctrl_z_in', int(new_val))

    @property
    def ctrl_user1_out(self) -> int:
        return int(self._context.get('root.lu.comparator.comparator2.attribute.source.enum.ctrl_user1_out'))

    @ctrl_user1_out.setter
    def ctrl_user1_out(self, new_val:int):
        self._context.set('root.lu.comparator.comparator2.attribute.source.enum.ctrl_user1_out', int(new_val))


class RootLuComparatorComparator2AttributeSource(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.comparator.comparator2.attribute.source'
        self.enum = RootLuComparatorComparator2AttributeSourceEnum(self._context)


class RootLuComparatorComparator2AttributeFilter_coeff_vec(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.comparator.comparator2.attribute.filter_coeff_vec'


class RootLuComparatorComparator2AttributeLevel(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.comparator.comparator2.attribute.level'


class RootLuComparatorComparator2AttributePolarityEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.comparator.comparator2.attribute.polarity.enum'

    @property
    def equal_or_lower_than(self) -> int:
        return int(self._context.get('root.lu.comparator.comparator2.attribute.polarity.enum.equal_or_lower_than'))

    @equal_or_lower_than.setter
    def equal_or_lower_than(self, new_val:int):
        self._context.set('root.lu.comparator.comparator2.attribute.polarity.enum.equal_or_lower_than', int(new_val))

    @property
    def equal_or_higher_than(self) -> int:
        return int(self._context.get('root.lu.comparator.comparator2.attribute.polarity.enum.equal_or_higher_than'))

    @equal_or_higher_than.setter
    def equal_or_higher_than(self, new_val:int):
        self._context.set('root.lu.comparator.comparator2.attribute.polarity.enum.equal_or_higher_than', int(new_val))


class RootLuComparatorComparator2AttributePolarity(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.comparator.comparator2.attribute.polarity'
        self.enum = RootLuComparatorComparator2AttributePolarityEnum(self._context)


class RootLuComparatorComparator2Attribute(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.comparator.comparator2.attribute'
        self.polarity = RootLuComparatorComparator2AttributePolarity(self._context)
        self.level = RootLuComparatorComparator2AttributeLevel(self._context)
        self.filter_coeff_vec = RootLuComparatorComparator2AttributeFilter_coeff_vec(self._context)
        self.source = RootLuComparatorComparator2AttributeSource(self._context)
        self.filter_enable = RootLuComparatorComparator2AttributeFilter_enable(self._context)


class RootLuComparatorComparator2(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.comparator.comparator2'
        self.attribute = RootLuComparatorComparator2Attribute(self._context)
        self.trigger = RootLuComparatorComparator2Trigger(self._context)


class RootLuComparatorComparator1Trigger(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.comparator.comparator1.trigger'


class RootLuComparatorComparator1AttributeFilter_enableEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.comparator.comparator1.attribute.filter_enable.enum'

    @property
    def disabled(self) -> int:
        return int(self._context.get('root.lu.comparator.comparator1.attribute.filter_enable.enum.disabled'))

    @disabled.setter
    def disabled(self, new_val:int):
        self._context.set('root.lu.comparator.comparator1.attribute.filter_enable.enum.disabled', int(new_val))

    @property
    def enabled(self) -> int:
        return int(self._context.get('root.lu.comparator.comparator1.attribute.filter_enable.enum.enabled'))

    @enabled.setter
    def enabled(self, new_val:int):
        self._context.set('root.lu.comparator.comparator1.attribute.filter_enable.enum.enabled', int(new_val))


class RootLuComparatorComparator1AttributeFilter_enable(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.comparator.comparator1.attribute.filter_enable'
        self.enum = RootLuComparatorComparator1AttributeFilter_enableEnum(self._context)


class RootLuComparatorComparator1AttributeSourceEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.comparator.comparator1.attribute.source.enum'

    @property
    def ort_adhesion_position(self) -> int:
        return int(self._context.get('root.lu.comparator.comparator1.attribute.source.enum.ort_adhesion_position'))

    @ort_adhesion_position.setter
    def ort_adhesion_position(self, new_val:int):
        self._context.set('root.lu.comparator.comparator1.attribute.source.enum.ort_adhesion_position', int(new_val))

    @property
    def ctrl_z_pid_command(self) -> int:
        return int(self._context.get('root.lu.comparator.comparator1.attribute.source.enum.ctrl_z_pid_command'))

    @ctrl_z_pid_command.setter
    def ctrl_z_pid_command(self, new_val:int):
        self._context.set('root.lu.comparator.comparator1.attribute.source.enum.ctrl_z_pid_command', int(new_val))

    @property
    def in6(self) -> int:
        return int(self._context.get('root.lu.comparator.comparator1.attribute.source.enum.in6'))

    @in6.setter
    def in6(self, new_val:int):
        self._context.set('root.lu.comparator.comparator1.attribute.source.enum.in6', int(new_val))

    @property
    def ctrl_z_nominal(self) -> int:
        return int(self._context.get('root.lu.comparator.comparator1.attribute.source.enum.ctrl_z_nominal'))

    @ctrl_z_nominal.setter
    def ctrl_z_nominal(self, new_val:int):
        self._context.set('root.lu.comparator.comparator1.attribute.source.enum.ctrl_z_nominal', int(new_val))

    @property
    def ctrl_x_out(self) -> int:
        return int(self._context.get('root.lu.comparator.comparator1.attribute.source.enum.ctrl_x_out'))

    @ctrl_x_out.setter
    def ctrl_x_out(self, new_val:int):
        self._context.set('root.lu.comparator.comparator1.attribute.source.enum.ctrl_x_out', int(new_val))

    @property
    def memory_gen_drive_y(self) -> int:
        return int(self._context.get('root.lu.comparator.comparator1.attribute.source.enum.memory_gen_drive_y'))

    @memory_gen_drive_y.setter
    def memory_gen_drive_y(self, new_val:int):
        self._context.set('root.lu.comparator.comparator1.attribute.source.enum.memory_gen_drive_y', int(new_val))

    @property
    def ctrl_user2_out(self) -> int:
        return int(self._context.get('root.lu.comparator.comparator1.attribute.source.enum.ctrl_user2_out'))

    @ctrl_user2_out.setter
    def ctrl_user2_out(self, new_val:int):
        self._context.set('root.lu.comparator.comparator1.attribute.source.enum.ctrl_user2_out', int(new_val))

    @property
    def analyzer2_phase(self) -> int:
        return int(self._context.get('root.lu.comparator.comparator1.attribute.source.enum.analyzer2_phase'))

    @analyzer2_phase.setter
    def analyzer2_phase(self, new_val:int):
        self._context.set('root.lu.comparator.comparator1.attribute.source.enum.analyzer2_phase', int(new_val))

    @property
    def fast_in_deflection(self) -> int:
        return int(self._context.get('root.lu.comparator.comparator1.attribute.source.enum.fast_in_deflection'))

    @fast_in_deflection.setter
    def fast_in_deflection(self, new_val:int):
        self._context.set('root.lu.comparator.comparator1.attribute.source.enum.fast_in_deflection', int(new_val))

    @property
    def in_user2(self) -> int:
        return int(self._context.get('root.lu.comparator.comparator1.attribute.source.enum.in_user2'))

    @in_user2.setter
    def in_user2(self, new_val:int):
        self._context.set('root.lu.comparator.comparator1.attribute.source.enum.in_user2', int(new_val))

    @property
    def ramp_gen_position_x(self) -> int:
        return int(self._context.get('root.lu.comparator.comparator1.attribute.source.enum.ramp_gen_position_x'))

    @ramp_gen_position_x.setter
    def ramp_gen_position_x(self, new_val:int):
        self._context.set('root.lu.comparator.comparator1.attribute.source.enum.ramp_gen_position_x', int(new_val))

    @property
    def in_deflection(self) -> int:
        return int(self._context.get('root.lu.comparator.comparator1.attribute.source.enum.in_deflection'))

    @in_deflection.setter
    def in_deflection(self, new_val:int):
        self._context.set('root.lu.comparator.comparator1.attribute.source.enum.in_deflection', int(new_val))

    @property
    def ort_amplitude_reduction(self) -> int:
        return int(self._context.get('root.lu.comparator.comparator1.attribute.source.enum.ort_amplitude_reduction'))

    @ort_amplitude_reduction.setter
    def ort_amplitude_reduction(self, new_val:int):
        self._context.set('root.lu.comparator.comparator1.attribute.source.enum.ort_amplitude_reduction', int(new_val))

    @property
    def analyzer2_ctrl_amplitude(self) -> int:
        return int(self._context.get('root.lu.comparator.comparator1.attribute.source.enum.analyzer2_ctrl_amplitude'))

    @analyzer2_ctrl_amplitude.setter
    def analyzer2_ctrl_amplitude(self, new_val:int):
        self._context.set('root.lu.comparator.comparator1.attribute.source.enum.analyzer2_ctrl_amplitude', int(new_val))

    @property
    def memory_gen_drive_x(self) -> int:
        return int(self._context.get('root.lu.comparator.comparator1.attribute.source.enum.memory_gen_drive_x'))

    @memory_gen_drive_x.setter
    def memory_gen_drive_x(self, new_val:int):
        self._context.set('root.lu.comparator.comparator1.attribute.source.enum.memory_gen_drive_x', int(new_val))

    @property
    def ramp_gen_alternate_z(self) -> int:
        return int(self._context.get('root.lu.comparator.comparator1.attribute.source.enum.ramp_gen_alternate_z'))

    @ramp_gen_alternate_z.setter
    def ramp_gen_alternate_z(self, new_val:int):
        self._context.set('root.lu.comparator.comparator1.attribute.source.enum.ramp_gen_alternate_z', int(new_val))

    @property
    def analyzer2_ctrl_delta_f(self) -> int:
        return int(self._context.get('root.lu.comparator.comparator1.attribute.source.enum.analyzer2_ctrl_delta_f'))

    @analyzer2_ctrl_delta_f.setter
    def analyzer2_ctrl_delta_f(self, new_val:int):
        self._context.set('root.lu.comparator.comparator1.attribute.source.enum.analyzer2_ctrl_delta_f', int(new_val))

    @property
    def ort_excitation(self) -> int:
        return int(self._context.get('root.lu.comparator.comparator1.attribute.source.enum.ort_excitation'))

    @ort_excitation.setter
    def ort_excitation(self, new_val:int):
        self._context.set('root.lu.comparator.comparator1.attribute.source.enum.ort_excitation', int(new_val))

    @property
    def analyzer1_y(self) -> int:
        return int(self._context.get('root.lu.comparator.comparator1.attribute.source.enum.analyzer1_y'))

    @analyzer1_y.setter
    def analyzer1_y(self, new_val:int):
        self._context.set('root.lu.comparator.comparator1.attribute.source.enum.analyzer1_y', int(new_val))

    @property
    def ort_adhesion_value(self) -> int:
        return int(self._context.get('root.lu.comparator.comparator1.attribute.source.enum.ort_adhesion_value'))

    @ort_adhesion_value.setter
    def ort_adhesion_value(self, new_val:int):
        self._context.set('root.lu.comparator.comparator1.attribute.source.enum.ort_adhesion_value', int(new_val))

    @property
    def ctrl_y_out(self) -> int:
        return int(self._context.get('root.lu.comparator.comparator1.attribute.source.enum.ctrl_y_out'))

    @ctrl_y_out.setter
    def ctrl_y_out(self, new_val:int):
        self._context.set('root.lu.comparator.comparator1.attribute.source.enum.ctrl_y_out', int(new_val))

    @property
    def analyzer1_phase(self) -> int:
        return int(self._context.get('root.lu.comparator.comparator1.attribute.source.enum.analyzer1_phase'))

    @analyzer1_phase.setter
    def analyzer1_phase(self, new_val:int):
        self._context.set('root.lu.comparator.comparator1.attribute.source.enum.analyzer1_phase', int(new_val))

    @property
    def ctrl_z_out(self) -> int:
        return int(self._context.get('root.lu.comparator.comparator1.attribute.source.enum.ctrl_z_out'))

    @ctrl_z_out.setter
    def ctrl_z_out(self, new_val:int):
        self._context.set('root.lu.comparator.comparator1.attribute.source.enum.ctrl_z_out', int(new_val))

    @property
    def ctrl_w_out(self) -> int:
        return int(self._context.get('root.lu.comparator.comparator1.attribute.source.enum.ctrl_w_out'))

    @ctrl_w_out.setter
    def ctrl_w_out(self, new_val:int):
        self._context.set('root.lu.comparator.comparator1.attribute.source.enum.ctrl_w_out', int(new_val))

    @property
    def analyzer1_ctrl_amplitude(self) -> int:
        return int(self._context.get('root.lu.comparator.comparator1.attribute.source.enum.analyzer1_ctrl_amplitude'))

    @analyzer1_ctrl_amplitude.setter
    def analyzer1_ctrl_amplitude(self, new_val:int):
        self._context.set('root.lu.comparator.comparator1.attribute.source.enum.analyzer1_ctrl_amplitude', int(new_val))

    @property
    def in_user1(self) -> int:
        return int(self._context.get('root.lu.comparator.comparator1.attribute.source.enum.in_user1'))

    @in_user1.setter
    def in_user1(self, new_val:int):
        self._context.set('root.lu.comparator.comparator1.attribute.source.enum.in_user1', int(new_val))

    @property
    def ramp_gen_approach(self) -> int:
        return int(self._context.get('root.lu.comparator.comparator1.attribute.source.enum.ramp_gen_approach'))

    @ramp_gen_approach.setter
    def ramp_gen_approach(self, new_val:int):
        self._context.set('root.lu.comparator.comparator1.attribute.source.enum.ramp_gen_approach', int(new_val))

    @property
    def ramp_gen_test(self) -> int:
        return int(self._context.get('root.lu.comparator.comparator1.attribute.source.enum.ramp_gen_test'))

    @ramp_gen_test.setter
    def ramp_gen_test(self, new_val:int):
        self._context.set('root.lu.comparator.comparator1.attribute.source.enum.ramp_gen_test', int(new_val))

    @property
    def in_position_x(self) -> int:
        return int(self._context.get('root.lu.comparator.comparator1.attribute.source.enum.in_position_x'))

    @in_position_x.setter
    def in_position_x(self, new_val:int):
        self._context.set('root.lu.comparator.comparator1.attribute.source.enum.in_position_x', int(new_val))

    @property
    def analyzer1_reference(self) -> int:
        return int(self._context.get('root.lu.comparator.comparator1.attribute.source.enum.analyzer1_reference'))

    @analyzer1_reference.setter
    def analyzer1_reference(self, new_val:int):
        self._context.set('root.lu.comparator.comparator1.attribute.source.enum.analyzer1_reference', int(new_val))

    @property
    def ramp_gen_plane_z(self) -> int:
        return int(self._context.get('root.lu.comparator.comparator1.attribute.source.enum.ramp_gen_plane_z'))

    @ramp_gen_plane_z.setter
    def ramp_gen_plane_z(self, new_val:int):
        self._context.set('root.lu.comparator.comparator1.attribute.source.enum.ramp_gen_plane_z', int(new_val))

    @property
    def memory_gen_out7(self) -> int:
        return int(self._context.get('root.lu.comparator.comparator1.attribute.source.enum.memory_gen_out7'))

    @memory_gen_out7.setter
    def memory_gen_out7(self, new_val:int):
        self._context.set('root.lu.comparator.comparator1.attribute.source.enum.memory_gen_out7', int(new_val))

    @property
    def analyzer2_y(self) -> int:
        return int(self._context.get('root.lu.comparator.comparator1.attribute.source.enum.analyzer2_y'))

    @analyzer2_y.setter
    def analyzer2_y(self, new_val:int):
        self._context.set('root.lu.comparator.comparator1.attribute.source.enum.analyzer2_y', int(new_val))

    @property
    def gen_test_dynamic(self) -> int:
        return int(self._context.get('root.lu.comparator.comparator1.attribute.source.enum.gen_test_dynamic'))

    @gen_test_dynamic.setter
    def gen_test_dynamic(self, new_val:int):
        self._context.set('root.lu.comparator.comparator1.attribute.source.enum.gen_test_dynamic', int(new_val))

    @property
    def in_tip_current(self) -> int:
        return int(self._context.get('root.lu.comparator.comparator1.attribute.source.enum.in_tip_current'))

    @in_tip_current.setter
    def in_tip_current(self, new_val:int):
        self._context.set('root.lu.comparator.comparator1.attribute.source.enum.in_tip_current', int(new_val))

    @property
    def analyzer1_x(self) -> int:
        return int(self._context.get('root.lu.comparator.comparator1.attribute.source.enum.analyzer1_x'))

    @analyzer1_x.setter
    def analyzer1_x(self, new_val:int):
        self._context.set('root.lu.comparator.comparator1.attribute.source.enum.analyzer1_x', int(new_val))

    @property
    def ctrl_z_sum(self) -> int:
        return int(self._context.get('root.lu.comparator.comparator1.attribute.source.enum.ctrl_z_sum'))

    @ctrl_z_sum.setter
    def ctrl_z_sum(self, new_val:int):
        self._context.set('root.lu.comparator.comparator1.attribute.source.enum.ctrl_z_sum', int(new_val))

    @property
    def analyzer2_reference(self) -> int:
        return int(self._context.get('root.lu.comparator.comparator1.attribute.source.enum.analyzer2_reference'))

    @analyzer2_reference.setter
    def analyzer2_reference(self, new_val:int):
        self._context.set('root.lu.comparator.comparator1.attribute.source.enum.analyzer2_reference', int(new_val))

    @property
    def analyzer1_ctrl_delta_f(self) -> int:
        return int(self._context.get('root.lu.comparator.comparator1.attribute.source.enum.analyzer1_ctrl_delta_f'))

    @analyzer1_ctrl_delta_f.setter
    def analyzer1_ctrl_delta_f(self, new_val:int):
        self._context.set('root.lu.comparator.comparator1.attribute.source.enum.analyzer1_ctrl_delta_f', int(new_val))

    @property
    def in_position_z(self) -> int:
        return int(self._context.get('root.lu.comparator.comparator1.attribute.source.enum.in_position_z'))

    @in_position_z.setter
    def in_position_z(self, new_val:int):
        self._context.set('root.lu.comparator.comparator1.attribute.source.enum.in_position_z', int(new_val))

    @property
    def analyzer2_x(self) -> int:
        return int(self._context.get('root.lu.comparator.comparator1.attribute.source.enum.analyzer2_x'))

    @analyzer2_x.setter
    def analyzer2_x(self, new_val:int):
        self._context.set('root.lu.comparator.comparator1.attribute.source.enum.analyzer2_x', int(new_val))

    @property
    def static(self) -> int:
        return int(self._context.get('root.lu.comparator.comparator1.attribute.source.enum.static'))

    @static.setter
    def static(self, new_val:int):
        self._context.set('root.lu.comparator.comparator1.attribute.source.enum.static', int(new_val))

    @property
    def in_lateral(self) -> int:
        return int(self._context.get('root.lu.comparator.comparator1.attribute.source.enum.in_lateral'))

    @in_lateral.setter
    def in_lateral(self, new_val:int):
        self._context.set('root.lu.comparator.comparator1.attribute.source.enum.in_lateral', int(new_val))

    @property
    def ramp_gen_tip_voltage(self) -> int:
        return int(self._context.get('root.lu.comparator.comparator1.attribute.source.enum.ramp_gen_tip_voltage'))

    @ramp_gen_tip_voltage.setter
    def ramp_gen_tip_voltage(self, new_val:int):
        self._context.set('root.lu.comparator.comparator1.attribute.source.enum.ramp_gen_tip_voltage', int(new_val))

    @property
    def ramp_gen_position_y(self) -> int:
        return int(self._context.get('root.lu.comparator.comparator1.attribute.source.enum.ramp_gen_position_y'))

    @ramp_gen_position_y.setter
    def ramp_gen_position_y(self, new_val:int):
        self._context.set('root.lu.comparator.comparator1.attribute.source.enum.ramp_gen_position_y', int(new_val))

    @property
    def ramp_gen_position_w(self) -> int:
        return int(self._context.get('root.lu.comparator.comparator1.attribute.source.enum.ramp_gen_position_w'))

    @ramp_gen_position_w.setter
    def ramp_gen_position_w(self, new_val:int):
        self._context.set('root.lu.comparator.comparator1.attribute.source.enum.ramp_gen_position_w', int(new_val))

    @property
    def ramp_gen_ctrl_z(self) -> int:
        return int(self._context.get('root.lu.comparator.comparator1.attribute.source.enum.ramp_gen_ctrl_z'))

    @ramp_gen_ctrl_z.setter
    def ramp_gen_ctrl_z(self, new_val:int):
        self._context.set('root.lu.comparator.comparator1.attribute.source.enum.ramp_gen_ctrl_z', int(new_val))

    @property
    def memory_gen_position_x(self) -> int:
        return int(self._context.get('root.lu.comparator.comparator1.attribute.source.enum.memory_gen_position_x'))

    @memory_gen_position_x.setter
    def memory_gen_position_x(self, new_val:int):
        self._context.set('root.lu.comparator.comparator1.attribute.source.enum.memory_gen_position_x', int(new_val))

    @property
    def in_user3(self) -> int:
        return int(self._context.get('root.lu.comparator.comparator1.attribute.source.enum.in_user3'))

    @in_user3.setter
    def in_user3(self, new_val:int):
        self._context.set('root.lu.comparator.comparator1.attribute.source.enum.in_user3', int(new_val))

    @property
    def in_position_y(self) -> int:
        return int(self._context.get('root.lu.comparator.comparator1.attribute.source.enum.in_position_y'))

    @in_position_y.setter
    def in_position_y(self, new_val:int):
        self._context.set('root.lu.comparator.comparator1.attribute.source.enum.in_position_y', int(new_val))

    @property
    def in_user4(self) -> int:
        return int(self._context.get('root.lu.comparator.comparator1.attribute.source.enum.in_user4'))

    @in_user4.setter
    def in_user4(self, new_val:int):
        self._context.set('root.lu.comparator.comparator1.attribute.source.enum.in_user4', int(new_val))

    @property
    def ramp_gen_max_z(self) -> int:
        return int(self._context.get('root.lu.comparator.comparator1.attribute.source.enum.ramp_gen_max_z'))

    @ramp_gen_max_z.setter
    def ramp_gen_max_z(self, new_val:int):
        self._context.set('root.lu.comparator.comparator1.attribute.source.enum.ramp_gen_max_z', int(new_val))

    @property
    def ort_free_wave(self) -> int:
        return int(self._context.get('root.lu.comparator.comparator1.attribute.source.enum.ort_free_wave'))

    @ort_free_wave.setter
    def ort_free_wave(self, new_val:int):
        self._context.set('root.lu.comparator.comparator1.attribute.source.enum.ort_free_wave', int(new_val))

    @property
    def ort_baseline_corrected(self) -> int:
        return int(self._context.get('root.lu.comparator.comparator1.attribute.source.enum.ort_baseline_corrected'))

    @ort_baseline_corrected.setter
    def ort_baseline_corrected(self, new_val:int):
        self._context.set('root.lu.comparator.comparator1.attribute.source.enum.ort_baseline_corrected', int(new_val))

    @property
    def ort_baseline(self) -> int:
        return int(self._context.get('root.lu.comparator.comparator1.attribute.source.enum.ort_baseline'))

    @ort_baseline.setter
    def ort_baseline(self, new_val:int):
        self._context.set('root.lu.comparator.comparator1.attribute.source.enum.ort_baseline', int(new_val))

    @property
    def fast_in2(self) -> int:
        return int(self._context.get('root.lu.comparator.comparator1.attribute.source.enum.fast_in2'))

    @fast_in2.setter
    def fast_in2(self, new_val:int):
        self._context.set('root.lu.comparator.comparator1.attribute.source.enum.fast_in2', int(new_val))

    @property
    def ctrl_z_error(self) -> int:
        return int(self._context.get('root.lu.comparator.comparator1.attribute.source.enum.ctrl_z_error'))

    @ctrl_z_error.setter
    def ctrl_z_error(self, new_val:int):
        self._context.set('root.lu.comparator.comparator1.attribute.source.enum.ctrl_z_error', int(new_val))

    @property
    def memory_gen_position_z(self) -> int:
        return int(self._context.get('root.lu.comparator.comparator1.attribute.source.enum.memory_gen_position_z'))

    @memory_gen_position_z.setter
    def memory_gen_position_z(self, new_val:int):
        self._context.set('root.lu.comparator.comparator1.attribute.source.enum.memory_gen_position_z', int(new_val))

    @property
    def fast_in_user(self) -> int:
        return int(self._context.get('root.lu.comparator.comparator1.attribute.source.enum.fast_in_user'))

    @fast_in_user.setter
    def fast_in_user(self, new_val:int):
        self._context.set('root.lu.comparator.comparator1.attribute.source.enum.fast_in_user', int(new_val))

    @property
    def memory_gen_position_y(self) -> int:
        return int(self._context.get('root.lu.comparator.comparator1.attribute.source.enum.memory_gen_position_y'))

    @memory_gen_position_y.setter
    def memory_gen_position_y(self, new_val:int):
        self._context.set('root.lu.comparator.comparator1.attribute.source.enum.memory_gen_position_y', int(new_val))

    @property
    def analyzer2_amplitude(self) -> int:
        return int(self._context.get('root.lu.comparator.comparator1.attribute.source.enum.analyzer2_amplitude'))

    @analyzer2_amplitude.setter
    def analyzer2_amplitude(self, new_val:int):
        self._context.set('root.lu.comparator.comparator1.attribute.source.enum.analyzer2_amplitude', int(new_val))

    @property
    def memory_gen_out8(self) -> int:
        return int(self._context.get('root.lu.comparator.comparator1.attribute.source.enum.memory_gen_out8'))

    @memory_gen_out8.setter
    def memory_gen_out8(self, new_val:int):
        self._context.set('root.lu.comparator.comparator1.attribute.source.enum.memory_gen_out8', int(new_val))

    @property
    def memory_gen_drive_z(self) -> int:
        return int(self._context.get('root.lu.comparator.comparator1.attribute.source.enum.memory_gen_drive_z'))

    @memory_gen_drive_z.setter
    def memory_gen_drive_z(self, new_val:int):
        self._context.set('root.lu.comparator.comparator1.attribute.source.enum.memory_gen_drive_z', int(new_val))

    @property
    def ramp_gen_user4(self) -> int:
        return int(self._context.get('root.lu.comparator.comparator1.attribute.source.enum.ramp_gen_user4'))

    @ramp_gen_user4.setter
    def ramp_gen_user4(self, new_val:int):
        self._context.set('root.lu.comparator.comparator1.attribute.source.enum.ramp_gen_user4', int(new_val))

    @property
    def analyzer1_amplitude(self) -> int:
        return int(self._context.get('root.lu.comparator.comparator1.attribute.source.enum.analyzer1_amplitude'))

    @analyzer1_amplitude.setter
    def analyzer1_amplitude(self, new_val:int):
        self._context.set('root.lu.comparator.comparator1.attribute.source.enum.analyzer1_amplitude', int(new_val))

    @property
    def in_detector_sum(self) -> int:
        return int(self._context.get('root.lu.comparator.comparator1.attribute.source.enum.in_detector_sum'))

    @in_detector_sum.setter
    def in_detector_sum(self, new_val:int):
        self._context.set('root.lu.comparator.comparator1.attribute.source.enum.in_detector_sum', int(new_val))

    @property
    def ctrl_z_in(self) -> int:
        return int(self._context.get('root.lu.comparator.comparator1.attribute.source.enum.ctrl_z_in'))

    @ctrl_z_in.setter
    def ctrl_z_in(self, new_val:int):
        self._context.set('root.lu.comparator.comparator1.attribute.source.enum.ctrl_z_in', int(new_val))

    @property
    def ctrl_user1_out(self) -> int:
        return int(self._context.get('root.lu.comparator.comparator1.attribute.source.enum.ctrl_user1_out'))

    @ctrl_user1_out.setter
    def ctrl_user1_out(self, new_val:int):
        self._context.set('root.lu.comparator.comparator1.attribute.source.enum.ctrl_user1_out', int(new_val))


class RootLuComparatorComparator1AttributeSource(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.comparator.comparator1.attribute.source'
        self.enum = RootLuComparatorComparator1AttributeSourceEnum(self._context)


class RootLuComparatorComparator1AttributeFilter_coeff_vec(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.comparator.comparator1.attribute.filter_coeff_vec'


class RootLuComparatorComparator1AttributeLevel(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.comparator.comparator1.attribute.level'


class RootLuComparatorComparator1AttributePolarityEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.comparator.comparator1.attribute.polarity.enum'

    @property
    def equal_or_lower_than(self) -> int:
        return int(self._context.get('root.lu.comparator.comparator1.attribute.polarity.enum.equal_or_lower_than'))

    @equal_or_lower_than.setter
    def equal_or_lower_than(self, new_val:int):
        self._context.set('root.lu.comparator.comparator1.attribute.polarity.enum.equal_or_lower_than', int(new_val))

    @property
    def equal_or_higher_than(self) -> int:
        return int(self._context.get('root.lu.comparator.comparator1.attribute.polarity.enum.equal_or_higher_than'))

    @equal_or_higher_than.setter
    def equal_or_higher_than(self, new_val:int):
        self._context.set('root.lu.comparator.comparator1.attribute.polarity.enum.equal_or_higher_than', int(new_val))


class RootLuComparatorComparator1AttributePolarity(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.comparator.comparator1.attribute.polarity'
        self.enum = RootLuComparatorComparator1AttributePolarityEnum(self._context)


class RootLuComparatorComparator1Attribute(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.comparator.comparator1.attribute'
        self.polarity = RootLuComparatorComparator1AttributePolarity(self._context)
        self.level = RootLuComparatorComparator1AttributeLevel(self._context)
        self.filter_coeff_vec = RootLuComparatorComparator1AttributeFilter_coeff_vec(self._context)
        self.source = RootLuComparatorComparator1AttributeSource(self._context)
        self.filter_enable = RootLuComparatorComparator1AttributeFilter_enable(self._context)


class RootLuComparatorComparator1(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.comparator.comparator1'
        self.attribute = RootLuComparatorComparator1Attribute(self._context)
        self.trigger = RootLuComparatorComparator1Trigger(self._context)


class RootLuComparator(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.comparator'
        self.comparator1 = RootLuComparatorComparator1(self._context)
        self.comparator2 = RootLuComparatorComparator2(self._context)
        self.comparator3 = RootLuComparatorComparator3(self._context)


class RootLuData_acquisitionInstanceBusyIs_capturing(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.data_acquisition.instance.busy.is_capturing'


class RootLuData_acquisitionInstanceBusyIs_sampling(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.data_acquisition.instance.busy.is_sampling'


class RootLuData_acquisitionInstanceBusy(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.data_acquisition.instance.busy'
        self.is_sampling = RootLuData_acquisitionInstanceBusyIs_sampling(self._context)
        self.is_capturing = RootLuData_acquisitionInstanceBusyIs_capturing(self._context)


class RootLuData_acquisitionInstanceAttributeCapture_hi_res_datapoints(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.data_acquisition.instance.attribute.capture_hi_res_datapoints'


class RootLuData_acquisitionInstanceAttributeCapture_hi_res_ch1_inputEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.data_acquisition.instance.attribute.capture_hi_res_ch1_input.enum'

    @property
    def ort_adhesion_position(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch1_input.enum.ort_adhesion_position'))

    @ort_adhesion_position.setter
    def ort_adhesion_position(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch1_input.enum.ort_adhesion_position', int(new_val))

    @property
    def ctrl_z_pid_command(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch1_input.enum.ctrl_z_pid_command'))

    @ctrl_z_pid_command.setter
    def ctrl_z_pid_command(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch1_input.enum.ctrl_z_pid_command', int(new_val))

    @property
    def in6(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch1_input.enum.in6'))

    @in6.setter
    def in6(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch1_input.enum.in6', int(new_val))

    @property
    def ctrl_z_nominal(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch1_input.enum.ctrl_z_nominal'))

    @ctrl_z_nominal.setter
    def ctrl_z_nominal(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch1_input.enum.ctrl_z_nominal', int(new_val))

    @property
    def ctrl_x_out(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch1_input.enum.ctrl_x_out'))

    @ctrl_x_out.setter
    def ctrl_x_out(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch1_input.enum.ctrl_x_out', int(new_val))

    @property
    def memory_gen_drive_y(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch1_input.enum.memory_gen_drive_y'))

    @memory_gen_drive_y.setter
    def memory_gen_drive_y(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch1_input.enum.memory_gen_drive_y', int(new_val))

    @property
    def ctrl_user2_out(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch1_input.enum.ctrl_user2_out'))

    @ctrl_user2_out.setter
    def ctrl_user2_out(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch1_input.enum.ctrl_user2_out', int(new_val))

    @property
    def analyzer2_phase(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch1_input.enum.analyzer2_phase'))

    @analyzer2_phase.setter
    def analyzer2_phase(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch1_input.enum.analyzer2_phase', int(new_val))

    @property
    def fast_in_deflection(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch1_input.enum.fast_in_deflection'))

    @fast_in_deflection.setter
    def fast_in_deflection(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch1_input.enum.fast_in_deflection', int(new_val))

    @property
    def in_user2(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch1_input.enum.in_user2'))

    @in_user2.setter
    def in_user2(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch1_input.enum.in_user2', int(new_val))

    @property
    def ramp_gen_position_x(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch1_input.enum.ramp_gen_position_x'))

    @ramp_gen_position_x.setter
    def ramp_gen_position_x(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch1_input.enum.ramp_gen_position_x', int(new_val))

    @property
    def in_deflection(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch1_input.enum.in_deflection'))

    @in_deflection.setter
    def in_deflection(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch1_input.enum.in_deflection', int(new_val))

    @property
    def ort_amplitude_reduction(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch1_input.enum.ort_amplitude_reduction'))

    @ort_amplitude_reduction.setter
    def ort_amplitude_reduction(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch1_input.enum.ort_amplitude_reduction', int(new_val))

    @property
    def analyzer2_ctrl_amplitude(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch1_input.enum.analyzer2_ctrl_amplitude'))

    @analyzer2_ctrl_amplitude.setter
    def analyzer2_ctrl_amplitude(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch1_input.enum.analyzer2_ctrl_amplitude', int(new_val))

    @property
    def memory_gen_drive_x(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch1_input.enum.memory_gen_drive_x'))

    @memory_gen_drive_x.setter
    def memory_gen_drive_x(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch1_input.enum.memory_gen_drive_x', int(new_val))

    @property
    def ramp_gen_alternate_z(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch1_input.enum.ramp_gen_alternate_z'))

    @ramp_gen_alternate_z.setter
    def ramp_gen_alternate_z(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch1_input.enum.ramp_gen_alternate_z', int(new_val))

    @property
    def analyzer2_ctrl_delta_f(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch1_input.enum.analyzer2_ctrl_delta_f'))

    @analyzer2_ctrl_delta_f.setter
    def analyzer2_ctrl_delta_f(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch1_input.enum.analyzer2_ctrl_delta_f', int(new_val))

    @property
    def ort_excitation(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch1_input.enum.ort_excitation'))

    @ort_excitation.setter
    def ort_excitation(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch1_input.enum.ort_excitation', int(new_val))

    @property
    def analyzer1_y(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch1_input.enum.analyzer1_y'))

    @analyzer1_y.setter
    def analyzer1_y(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch1_input.enum.analyzer1_y', int(new_val))

    @property
    def ort_adhesion_value(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch1_input.enum.ort_adhesion_value'))

    @ort_adhesion_value.setter
    def ort_adhesion_value(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch1_input.enum.ort_adhesion_value', int(new_val))

    @property
    def ctrl_y_out(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch1_input.enum.ctrl_y_out'))

    @ctrl_y_out.setter
    def ctrl_y_out(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch1_input.enum.ctrl_y_out', int(new_val))

    @property
    def analyzer1_phase(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch1_input.enum.analyzer1_phase'))

    @analyzer1_phase.setter
    def analyzer1_phase(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch1_input.enum.analyzer1_phase', int(new_val))

    @property
    def ctrl_z_out(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch1_input.enum.ctrl_z_out'))

    @ctrl_z_out.setter
    def ctrl_z_out(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch1_input.enum.ctrl_z_out', int(new_val))

    @property
    def ctrl_w_out(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch1_input.enum.ctrl_w_out'))

    @ctrl_w_out.setter
    def ctrl_w_out(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch1_input.enum.ctrl_w_out', int(new_val))

    @property
    def analyzer1_ctrl_amplitude(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch1_input.enum.analyzer1_ctrl_amplitude'))

    @analyzer1_ctrl_amplitude.setter
    def analyzer1_ctrl_amplitude(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch1_input.enum.analyzer1_ctrl_amplitude', int(new_val))

    @property
    def in_user1(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch1_input.enum.in_user1'))

    @in_user1.setter
    def in_user1(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch1_input.enum.in_user1', int(new_val))

    @property
    def ramp_gen_approach(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch1_input.enum.ramp_gen_approach'))

    @ramp_gen_approach.setter
    def ramp_gen_approach(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch1_input.enum.ramp_gen_approach', int(new_val))

    @property
    def ramp_gen_test(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch1_input.enum.ramp_gen_test'))

    @ramp_gen_test.setter
    def ramp_gen_test(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch1_input.enum.ramp_gen_test', int(new_val))

    @property
    def in_position_x(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch1_input.enum.in_position_x'))

    @in_position_x.setter
    def in_position_x(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch1_input.enum.in_position_x', int(new_val))

    @property
    def analyzer1_reference(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch1_input.enum.analyzer1_reference'))

    @analyzer1_reference.setter
    def analyzer1_reference(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch1_input.enum.analyzer1_reference', int(new_val))

    @property
    def ramp_gen_plane_z(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch1_input.enum.ramp_gen_plane_z'))

    @ramp_gen_plane_z.setter
    def ramp_gen_plane_z(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch1_input.enum.ramp_gen_plane_z', int(new_val))

    @property
    def memory_gen_out7(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch1_input.enum.memory_gen_out7'))

    @memory_gen_out7.setter
    def memory_gen_out7(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch1_input.enum.memory_gen_out7', int(new_val))

    @property
    def analyzer2_y(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch1_input.enum.analyzer2_y'))

    @analyzer2_y.setter
    def analyzer2_y(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch1_input.enum.analyzer2_y', int(new_val))

    @property
    def gen_test_dynamic(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch1_input.enum.gen_test_dynamic'))

    @gen_test_dynamic.setter
    def gen_test_dynamic(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch1_input.enum.gen_test_dynamic', int(new_val))

    @property
    def in_tip_current(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch1_input.enum.in_tip_current'))

    @in_tip_current.setter
    def in_tip_current(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch1_input.enum.in_tip_current', int(new_val))

    @property
    def analyzer1_x(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch1_input.enum.analyzer1_x'))

    @analyzer1_x.setter
    def analyzer1_x(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch1_input.enum.analyzer1_x', int(new_val))

    @property
    def ctrl_z_sum(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch1_input.enum.ctrl_z_sum'))

    @ctrl_z_sum.setter
    def ctrl_z_sum(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch1_input.enum.ctrl_z_sum', int(new_val))

    @property
    def analyzer2_reference(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch1_input.enum.analyzer2_reference'))

    @analyzer2_reference.setter
    def analyzer2_reference(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch1_input.enum.analyzer2_reference', int(new_val))

    @property
    def analyzer1_ctrl_delta_f(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch1_input.enum.analyzer1_ctrl_delta_f'))

    @analyzer1_ctrl_delta_f.setter
    def analyzer1_ctrl_delta_f(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch1_input.enum.analyzer1_ctrl_delta_f', int(new_val))

    @property
    def in_position_z(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch1_input.enum.in_position_z'))

    @in_position_z.setter
    def in_position_z(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch1_input.enum.in_position_z', int(new_val))

    @property
    def analyzer2_x(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch1_input.enum.analyzer2_x'))

    @analyzer2_x.setter
    def analyzer2_x(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch1_input.enum.analyzer2_x', int(new_val))

    @property
    def static(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch1_input.enum.static'))

    @static.setter
    def static(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch1_input.enum.static', int(new_val))

    @property
    def in_lateral(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch1_input.enum.in_lateral'))

    @in_lateral.setter
    def in_lateral(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch1_input.enum.in_lateral', int(new_val))

    @property
    def ramp_gen_tip_voltage(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch1_input.enum.ramp_gen_tip_voltage'))

    @ramp_gen_tip_voltage.setter
    def ramp_gen_tip_voltage(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch1_input.enum.ramp_gen_tip_voltage', int(new_val))

    @property
    def ramp_gen_position_y(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch1_input.enum.ramp_gen_position_y'))

    @ramp_gen_position_y.setter
    def ramp_gen_position_y(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch1_input.enum.ramp_gen_position_y', int(new_val))

    @property
    def ramp_gen_position_w(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch1_input.enum.ramp_gen_position_w'))

    @ramp_gen_position_w.setter
    def ramp_gen_position_w(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch1_input.enum.ramp_gen_position_w', int(new_val))

    @property
    def ramp_gen_ctrl_z(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch1_input.enum.ramp_gen_ctrl_z'))

    @ramp_gen_ctrl_z.setter
    def ramp_gen_ctrl_z(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch1_input.enum.ramp_gen_ctrl_z', int(new_val))

    @property
    def memory_gen_position_x(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch1_input.enum.memory_gen_position_x'))

    @memory_gen_position_x.setter
    def memory_gen_position_x(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch1_input.enum.memory_gen_position_x', int(new_val))

    @property
    def in_user3(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch1_input.enum.in_user3'))

    @in_user3.setter
    def in_user3(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch1_input.enum.in_user3', int(new_val))

    @property
    def in_position_y(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch1_input.enum.in_position_y'))

    @in_position_y.setter
    def in_position_y(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch1_input.enum.in_position_y', int(new_val))

    @property
    def in_user4(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch1_input.enum.in_user4'))

    @in_user4.setter
    def in_user4(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch1_input.enum.in_user4', int(new_val))

    @property
    def ramp_gen_max_z(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch1_input.enum.ramp_gen_max_z'))

    @ramp_gen_max_z.setter
    def ramp_gen_max_z(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch1_input.enum.ramp_gen_max_z', int(new_val))

    @property
    def ort_free_wave(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch1_input.enum.ort_free_wave'))

    @ort_free_wave.setter
    def ort_free_wave(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch1_input.enum.ort_free_wave', int(new_val))

    @property
    def ort_baseline_corrected(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch1_input.enum.ort_baseline_corrected'))

    @ort_baseline_corrected.setter
    def ort_baseline_corrected(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch1_input.enum.ort_baseline_corrected', int(new_val))

    @property
    def ort_baseline(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch1_input.enum.ort_baseline'))

    @ort_baseline.setter
    def ort_baseline(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch1_input.enum.ort_baseline', int(new_val))

    @property
    def fast_in2(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch1_input.enum.fast_in2'))

    @fast_in2.setter
    def fast_in2(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch1_input.enum.fast_in2', int(new_val))

    @property
    def ctrl_z_error(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch1_input.enum.ctrl_z_error'))

    @ctrl_z_error.setter
    def ctrl_z_error(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch1_input.enum.ctrl_z_error', int(new_val))

    @property
    def memory_gen_position_z(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch1_input.enum.memory_gen_position_z'))

    @memory_gen_position_z.setter
    def memory_gen_position_z(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch1_input.enum.memory_gen_position_z', int(new_val))

    @property
    def fast_in_user(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch1_input.enum.fast_in_user'))

    @fast_in_user.setter
    def fast_in_user(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch1_input.enum.fast_in_user', int(new_val))

    @property
    def memory_gen_position_y(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch1_input.enum.memory_gen_position_y'))

    @memory_gen_position_y.setter
    def memory_gen_position_y(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch1_input.enum.memory_gen_position_y', int(new_val))

    @property
    def analyzer2_amplitude(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch1_input.enum.analyzer2_amplitude'))

    @analyzer2_amplitude.setter
    def analyzer2_amplitude(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch1_input.enum.analyzer2_amplitude', int(new_val))

    @property
    def memory_gen_out8(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch1_input.enum.memory_gen_out8'))

    @memory_gen_out8.setter
    def memory_gen_out8(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch1_input.enum.memory_gen_out8', int(new_val))

    @property
    def memory_gen_drive_z(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch1_input.enum.memory_gen_drive_z'))

    @memory_gen_drive_z.setter
    def memory_gen_drive_z(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch1_input.enum.memory_gen_drive_z', int(new_val))

    @property
    def ramp_gen_user4(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch1_input.enum.ramp_gen_user4'))

    @ramp_gen_user4.setter
    def ramp_gen_user4(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch1_input.enum.ramp_gen_user4', int(new_val))

    @property
    def analyzer1_amplitude(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch1_input.enum.analyzer1_amplitude'))

    @analyzer1_amplitude.setter
    def analyzer1_amplitude(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch1_input.enum.analyzer1_amplitude', int(new_val))

    @property
    def in_detector_sum(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch1_input.enum.in_detector_sum'))

    @in_detector_sum.setter
    def in_detector_sum(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch1_input.enum.in_detector_sum', int(new_val))

    @property
    def ctrl_z_in(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch1_input.enum.ctrl_z_in'))

    @ctrl_z_in.setter
    def ctrl_z_in(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch1_input.enum.ctrl_z_in', int(new_val))

    @property
    def ctrl_user1_out(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch1_input.enum.ctrl_user1_out'))

    @ctrl_user1_out.setter
    def ctrl_user1_out(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch1_input.enum.ctrl_user1_out', int(new_val))


class RootLuData_acquisitionInstanceAttributeCapture_hi_res_ch1_input(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.data_acquisition.instance.attribute.capture_hi_res_ch1_input'
        self.enum = RootLuData_acquisitionInstanceAttributeCapture_hi_res_ch1_inputEnum(self._context)


class RootLuData_acquisitionInstanceAttributeSampler_hi_res_ch0_inputEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch0_input.enum'

    @property
    def ort_adhesion_position(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch0_input.enum.ort_adhesion_position'))

    @ort_adhesion_position.setter
    def ort_adhesion_position(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch0_input.enum.ort_adhesion_position', int(new_val))

    @property
    def ctrl_z_pid_command(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch0_input.enum.ctrl_z_pid_command'))

    @ctrl_z_pid_command.setter
    def ctrl_z_pid_command(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch0_input.enum.ctrl_z_pid_command', int(new_val))

    @property
    def in6(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch0_input.enum.in6'))

    @in6.setter
    def in6(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch0_input.enum.in6', int(new_val))

    @property
    def ctrl_z_nominal(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch0_input.enum.ctrl_z_nominal'))

    @ctrl_z_nominal.setter
    def ctrl_z_nominal(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch0_input.enum.ctrl_z_nominal', int(new_val))

    @property
    def ctrl_x_out(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch0_input.enum.ctrl_x_out'))

    @ctrl_x_out.setter
    def ctrl_x_out(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch0_input.enum.ctrl_x_out', int(new_val))

    @property
    def memory_gen_drive_y(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch0_input.enum.memory_gen_drive_y'))

    @memory_gen_drive_y.setter
    def memory_gen_drive_y(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch0_input.enum.memory_gen_drive_y', int(new_val))

    @property
    def ctrl_user2_out(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch0_input.enum.ctrl_user2_out'))

    @ctrl_user2_out.setter
    def ctrl_user2_out(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch0_input.enum.ctrl_user2_out', int(new_val))

    @property
    def analyzer2_phase(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch0_input.enum.analyzer2_phase'))

    @analyzer2_phase.setter
    def analyzer2_phase(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch0_input.enum.analyzer2_phase', int(new_val))

    @property
    def fast_in_deflection(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch0_input.enum.fast_in_deflection'))

    @fast_in_deflection.setter
    def fast_in_deflection(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch0_input.enum.fast_in_deflection', int(new_val))

    @property
    def in_user2(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch0_input.enum.in_user2'))

    @in_user2.setter
    def in_user2(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch0_input.enum.in_user2', int(new_val))

    @property
    def ramp_gen_position_x(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch0_input.enum.ramp_gen_position_x'))

    @ramp_gen_position_x.setter
    def ramp_gen_position_x(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch0_input.enum.ramp_gen_position_x', int(new_val))

    @property
    def in_deflection(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch0_input.enum.in_deflection'))

    @in_deflection.setter
    def in_deflection(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch0_input.enum.in_deflection', int(new_val))

    @property
    def ort_amplitude_reduction(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch0_input.enum.ort_amplitude_reduction'))

    @ort_amplitude_reduction.setter
    def ort_amplitude_reduction(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch0_input.enum.ort_amplitude_reduction', int(new_val))

    @property
    def analyzer2_ctrl_amplitude(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch0_input.enum.analyzer2_ctrl_amplitude'))

    @analyzer2_ctrl_amplitude.setter
    def analyzer2_ctrl_amplitude(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch0_input.enum.analyzer2_ctrl_amplitude', int(new_val))

    @property
    def memory_gen_drive_x(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch0_input.enum.memory_gen_drive_x'))

    @memory_gen_drive_x.setter
    def memory_gen_drive_x(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch0_input.enum.memory_gen_drive_x', int(new_val))

    @property
    def ramp_gen_alternate_z(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch0_input.enum.ramp_gen_alternate_z'))

    @ramp_gen_alternate_z.setter
    def ramp_gen_alternate_z(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch0_input.enum.ramp_gen_alternate_z', int(new_val))

    @property
    def analyzer2_ctrl_delta_f(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch0_input.enum.analyzer2_ctrl_delta_f'))

    @analyzer2_ctrl_delta_f.setter
    def analyzer2_ctrl_delta_f(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch0_input.enum.analyzer2_ctrl_delta_f', int(new_val))

    @property
    def ort_excitation(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch0_input.enum.ort_excitation'))

    @ort_excitation.setter
    def ort_excitation(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch0_input.enum.ort_excitation', int(new_val))

    @property
    def analyzer1_y(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch0_input.enum.analyzer1_y'))

    @analyzer1_y.setter
    def analyzer1_y(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch0_input.enum.analyzer1_y', int(new_val))

    @property
    def ort_adhesion_value(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch0_input.enum.ort_adhesion_value'))

    @ort_adhesion_value.setter
    def ort_adhesion_value(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch0_input.enum.ort_adhesion_value', int(new_val))

    @property
    def ctrl_y_out(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch0_input.enum.ctrl_y_out'))

    @ctrl_y_out.setter
    def ctrl_y_out(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch0_input.enum.ctrl_y_out', int(new_val))

    @property
    def analyzer1_phase(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch0_input.enum.analyzer1_phase'))

    @analyzer1_phase.setter
    def analyzer1_phase(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch0_input.enum.analyzer1_phase', int(new_val))

    @property
    def ctrl_z_out(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch0_input.enum.ctrl_z_out'))

    @ctrl_z_out.setter
    def ctrl_z_out(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch0_input.enum.ctrl_z_out', int(new_val))

    @property
    def ctrl_w_out(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch0_input.enum.ctrl_w_out'))

    @ctrl_w_out.setter
    def ctrl_w_out(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch0_input.enum.ctrl_w_out', int(new_val))

    @property
    def analyzer1_ctrl_amplitude(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch0_input.enum.analyzer1_ctrl_amplitude'))

    @analyzer1_ctrl_amplitude.setter
    def analyzer1_ctrl_amplitude(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch0_input.enum.analyzer1_ctrl_amplitude', int(new_val))

    @property
    def in_user1(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch0_input.enum.in_user1'))

    @in_user1.setter
    def in_user1(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch0_input.enum.in_user1', int(new_val))

    @property
    def ramp_gen_approach(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch0_input.enum.ramp_gen_approach'))

    @ramp_gen_approach.setter
    def ramp_gen_approach(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch0_input.enum.ramp_gen_approach', int(new_val))

    @property
    def ramp_gen_test(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch0_input.enum.ramp_gen_test'))

    @ramp_gen_test.setter
    def ramp_gen_test(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch0_input.enum.ramp_gen_test', int(new_val))

    @property
    def in_position_x(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch0_input.enum.in_position_x'))

    @in_position_x.setter
    def in_position_x(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch0_input.enum.in_position_x', int(new_val))

    @property
    def analyzer1_reference(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch0_input.enum.analyzer1_reference'))

    @analyzer1_reference.setter
    def analyzer1_reference(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch0_input.enum.analyzer1_reference', int(new_val))

    @property
    def ramp_gen_plane_z(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch0_input.enum.ramp_gen_plane_z'))

    @ramp_gen_plane_z.setter
    def ramp_gen_plane_z(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch0_input.enum.ramp_gen_plane_z', int(new_val))

    @property
    def memory_gen_out7(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch0_input.enum.memory_gen_out7'))

    @memory_gen_out7.setter
    def memory_gen_out7(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch0_input.enum.memory_gen_out7', int(new_val))

    @property
    def analyzer2_y(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch0_input.enum.analyzer2_y'))

    @analyzer2_y.setter
    def analyzer2_y(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch0_input.enum.analyzer2_y', int(new_val))

    @property
    def gen_test_dynamic(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch0_input.enum.gen_test_dynamic'))

    @gen_test_dynamic.setter
    def gen_test_dynamic(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch0_input.enum.gen_test_dynamic', int(new_val))

    @property
    def in_tip_current(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch0_input.enum.in_tip_current'))

    @in_tip_current.setter
    def in_tip_current(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch0_input.enum.in_tip_current', int(new_val))

    @property
    def analyzer1_x(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch0_input.enum.analyzer1_x'))

    @analyzer1_x.setter
    def analyzer1_x(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch0_input.enum.analyzer1_x', int(new_val))

    @property
    def ctrl_z_sum(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch0_input.enum.ctrl_z_sum'))

    @ctrl_z_sum.setter
    def ctrl_z_sum(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch0_input.enum.ctrl_z_sum', int(new_val))

    @property
    def analyzer2_reference(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch0_input.enum.analyzer2_reference'))

    @analyzer2_reference.setter
    def analyzer2_reference(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch0_input.enum.analyzer2_reference', int(new_val))

    @property
    def analyzer1_ctrl_delta_f(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch0_input.enum.analyzer1_ctrl_delta_f'))

    @analyzer1_ctrl_delta_f.setter
    def analyzer1_ctrl_delta_f(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch0_input.enum.analyzer1_ctrl_delta_f', int(new_val))

    @property
    def in_position_z(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch0_input.enum.in_position_z'))

    @in_position_z.setter
    def in_position_z(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch0_input.enum.in_position_z', int(new_val))

    @property
    def analyzer2_x(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch0_input.enum.analyzer2_x'))

    @analyzer2_x.setter
    def analyzer2_x(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch0_input.enum.analyzer2_x', int(new_val))

    @property
    def static(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch0_input.enum.static'))

    @static.setter
    def static(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch0_input.enum.static', int(new_val))

    @property
    def in_lateral(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch0_input.enum.in_lateral'))

    @in_lateral.setter
    def in_lateral(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch0_input.enum.in_lateral', int(new_val))

    @property
    def ramp_gen_tip_voltage(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch0_input.enum.ramp_gen_tip_voltage'))

    @ramp_gen_tip_voltage.setter
    def ramp_gen_tip_voltage(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch0_input.enum.ramp_gen_tip_voltage', int(new_val))

    @property
    def ramp_gen_position_y(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch0_input.enum.ramp_gen_position_y'))

    @ramp_gen_position_y.setter
    def ramp_gen_position_y(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch0_input.enum.ramp_gen_position_y', int(new_val))

    @property
    def ramp_gen_position_w(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch0_input.enum.ramp_gen_position_w'))

    @ramp_gen_position_w.setter
    def ramp_gen_position_w(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch0_input.enum.ramp_gen_position_w', int(new_val))

    @property
    def ramp_gen_ctrl_z(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch0_input.enum.ramp_gen_ctrl_z'))

    @ramp_gen_ctrl_z.setter
    def ramp_gen_ctrl_z(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch0_input.enum.ramp_gen_ctrl_z', int(new_val))

    @property
    def memory_gen_position_x(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch0_input.enum.memory_gen_position_x'))

    @memory_gen_position_x.setter
    def memory_gen_position_x(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch0_input.enum.memory_gen_position_x', int(new_val))

    @property
    def in_user3(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch0_input.enum.in_user3'))

    @in_user3.setter
    def in_user3(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch0_input.enum.in_user3', int(new_val))

    @property
    def in_position_y(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch0_input.enum.in_position_y'))

    @in_position_y.setter
    def in_position_y(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch0_input.enum.in_position_y', int(new_val))

    @property
    def in_user4(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch0_input.enum.in_user4'))

    @in_user4.setter
    def in_user4(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch0_input.enum.in_user4', int(new_val))

    @property
    def ramp_gen_max_z(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch0_input.enum.ramp_gen_max_z'))

    @ramp_gen_max_z.setter
    def ramp_gen_max_z(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch0_input.enum.ramp_gen_max_z', int(new_val))

    @property
    def ort_free_wave(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch0_input.enum.ort_free_wave'))

    @ort_free_wave.setter
    def ort_free_wave(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch0_input.enum.ort_free_wave', int(new_val))

    @property
    def ort_baseline_corrected(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch0_input.enum.ort_baseline_corrected'))

    @ort_baseline_corrected.setter
    def ort_baseline_corrected(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch0_input.enum.ort_baseline_corrected', int(new_val))

    @property
    def ort_baseline(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch0_input.enum.ort_baseline'))

    @ort_baseline.setter
    def ort_baseline(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch0_input.enum.ort_baseline', int(new_val))

    @property
    def fast_in2(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch0_input.enum.fast_in2'))

    @fast_in2.setter
    def fast_in2(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch0_input.enum.fast_in2', int(new_val))

    @property
    def ctrl_z_error(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch0_input.enum.ctrl_z_error'))

    @ctrl_z_error.setter
    def ctrl_z_error(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch0_input.enum.ctrl_z_error', int(new_val))

    @property
    def memory_gen_position_z(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch0_input.enum.memory_gen_position_z'))

    @memory_gen_position_z.setter
    def memory_gen_position_z(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch0_input.enum.memory_gen_position_z', int(new_val))

    @property
    def fast_in_user(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch0_input.enum.fast_in_user'))

    @fast_in_user.setter
    def fast_in_user(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch0_input.enum.fast_in_user', int(new_val))

    @property
    def memory_gen_position_y(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch0_input.enum.memory_gen_position_y'))

    @memory_gen_position_y.setter
    def memory_gen_position_y(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch0_input.enum.memory_gen_position_y', int(new_val))

    @property
    def analyzer2_amplitude(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch0_input.enum.analyzer2_amplitude'))

    @analyzer2_amplitude.setter
    def analyzer2_amplitude(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch0_input.enum.analyzer2_amplitude', int(new_val))

    @property
    def memory_gen_out8(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch0_input.enum.memory_gen_out8'))

    @memory_gen_out8.setter
    def memory_gen_out8(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch0_input.enum.memory_gen_out8', int(new_val))

    @property
    def memory_gen_drive_z(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch0_input.enum.memory_gen_drive_z'))

    @memory_gen_drive_z.setter
    def memory_gen_drive_z(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch0_input.enum.memory_gen_drive_z', int(new_val))

    @property
    def ramp_gen_user4(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch0_input.enum.ramp_gen_user4'))

    @ramp_gen_user4.setter
    def ramp_gen_user4(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch0_input.enum.ramp_gen_user4', int(new_val))

    @property
    def analyzer1_amplitude(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch0_input.enum.analyzer1_amplitude'))

    @analyzer1_amplitude.setter
    def analyzer1_amplitude(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch0_input.enum.analyzer1_amplitude', int(new_val))

    @property
    def in_detector_sum(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch0_input.enum.in_detector_sum'))

    @in_detector_sum.setter
    def in_detector_sum(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch0_input.enum.in_detector_sum', int(new_val))

    @property
    def ctrl_z_in(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch0_input.enum.ctrl_z_in'))

    @ctrl_z_in.setter
    def ctrl_z_in(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch0_input.enum.ctrl_z_in', int(new_val))

    @property
    def ctrl_user1_out(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch0_input.enum.ctrl_user1_out'))

    @ctrl_user1_out.setter
    def ctrl_user1_out(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch0_input.enum.ctrl_user1_out', int(new_val))


class RootLuData_acquisitionInstanceAttributeSampler_hi_res_ch0_input(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch0_input'
        self.enum = RootLuData_acquisitionInstanceAttributeSampler_hi_res_ch0_inputEnum(self._context)


class RootLuData_acquisitionInstanceAttributeSampler_channel_mask(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.data_acquisition.instance.attribute.sampler_channel_mask'


class RootLuData_acquisitionInstanceAttributePhase_sampler_data_rate_vec(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.data_acquisition.instance.attribute.phase_sampler_data_rate_vec'


class RootLuData_acquisitionInstanceAttributeCapture_hi_res_ch7_inputEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.data_acquisition.instance.attribute.capture_hi_res_ch7_input.enum'

    @property
    def ort_adhesion_position(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch7_input.enum.ort_adhesion_position'))

    @ort_adhesion_position.setter
    def ort_adhesion_position(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch7_input.enum.ort_adhesion_position', int(new_val))

    @property
    def ctrl_z_pid_command(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch7_input.enum.ctrl_z_pid_command'))

    @ctrl_z_pid_command.setter
    def ctrl_z_pid_command(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch7_input.enum.ctrl_z_pid_command', int(new_val))

    @property
    def in6(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch7_input.enum.in6'))

    @in6.setter
    def in6(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch7_input.enum.in6', int(new_val))

    @property
    def ctrl_z_nominal(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch7_input.enum.ctrl_z_nominal'))

    @ctrl_z_nominal.setter
    def ctrl_z_nominal(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch7_input.enum.ctrl_z_nominal', int(new_val))

    @property
    def ctrl_x_out(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch7_input.enum.ctrl_x_out'))

    @ctrl_x_out.setter
    def ctrl_x_out(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch7_input.enum.ctrl_x_out', int(new_val))

    @property
    def memory_gen_drive_y(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch7_input.enum.memory_gen_drive_y'))

    @memory_gen_drive_y.setter
    def memory_gen_drive_y(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch7_input.enum.memory_gen_drive_y', int(new_val))

    @property
    def ctrl_user2_out(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch7_input.enum.ctrl_user2_out'))

    @ctrl_user2_out.setter
    def ctrl_user2_out(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch7_input.enum.ctrl_user2_out', int(new_val))

    @property
    def analyzer2_phase(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch7_input.enum.analyzer2_phase'))

    @analyzer2_phase.setter
    def analyzer2_phase(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch7_input.enum.analyzer2_phase', int(new_val))

    @property
    def fast_in_deflection(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch7_input.enum.fast_in_deflection'))

    @fast_in_deflection.setter
    def fast_in_deflection(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch7_input.enum.fast_in_deflection', int(new_val))

    @property
    def in_user2(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch7_input.enum.in_user2'))

    @in_user2.setter
    def in_user2(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch7_input.enum.in_user2', int(new_val))

    @property
    def ramp_gen_position_x(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch7_input.enum.ramp_gen_position_x'))

    @ramp_gen_position_x.setter
    def ramp_gen_position_x(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch7_input.enum.ramp_gen_position_x', int(new_val))

    @property
    def in_deflection(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch7_input.enum.in_deflection'))

    @in_deflection.setter
    def in_deflection(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch7_input.enum.in_deflection', int(new_val))

    @property
    def ort_amplitude_reduction(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch7_input.enum.ort_amplitude_reduction'))

    @ort_amplitude_reduction.setter
    def ort_amplitude_reduction(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch7_input.enum.ort_amplitude_reduction', int(new_val))

    @property
    def analyzer2_ctrl_amplitude(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch7_input.enum.analyzer2_ctrl_amplitude'))

    @analyzer2_ctrl_amplitude.setter
    def analyzer2_ctrl_amplitude(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch7_input.enum.analyzer2_ctrl_amplitude', int(new_val))

    @property
    def memory_gen_drive_x(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch7_input.enum.memory_gen_drive_x'))

    @memory_gen_drive_x.setter
    def memory_gen_drive_x(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch7_input.enum.memory_gen_drive_x', int(new_val))

    @property
    def ramp_gen_alternate_z(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch7_input.enum.ramp_gen_alternate_z'))

    @ramp_gen_alternate_z.setter
    def ramp_gen_alternate_z(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch7_input.enum.ramp_gen_alternate_z', int(new_val))

    @property
    def analyzer2_ctrl_delta_f(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch7_input.enum.analyzer2_ctrl_delta_f'))

    @analyzer2_ctrl_delta_f.setter
    def analyzer2_ctrl_delta_f(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch7_input.enum.analyzer2_ctrl_delta_f', int(new_val))

    @property
    def ort_excitation(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch7_input.enum.ort_excitation'))

    @ort_excitation.setter
    def ort_excitation(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch7_input.enum.ort_excitation', int(new_val))

    @property
    def analyzer1_y(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch7_input.enum.analyzer1_y'))

    @analyzer1_y.setter
    def analyzer1_y(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch7_input.enum.analyzer1_y', int(new_val))

    @property
    def ort_adhesion_value(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch7_input.enum.ort_adhesion_value'))

    @ort_adhesion_value.setter
    def ort_adhesion_value(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch7_input.enum.ort_adhesion_value', int(new_val))

    @property
    def ctrl_y_out(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch7_input.enum.ctrl_y_out'))

    @ctrl_y_out.setter
    def ctrl_y_out(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch7_input.enum.ctrl_y_out', int(new_val))

    @property
    def analyzer1_phase(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch7_input.enum.analyzer1_phase'))

    @analyzer1_phase.setter
    def analyzer1_phase(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch7_input.enum.analyzer1_phase', int(new_val))

    @property
    def ctrl_z_out(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch7_input.enum.ctrl_z_out'))

    @ctrl_z_out.setter
    def ctrl_z_out(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch7_input.enum.ctrl_z_out', int(new_val))

    @property
    def ctrl_w_out(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch7_input.enum.ctrl_w_out'))

    @ctrl_w_out.setter
    def ctrl_w_out(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch7_input.enum.ctrl_w_out', int(new_val))

    @property
    def analyzer1_ctrl_amplitude(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch7_input.enum.analyzer1_ctrl_amplitude'))

    @analyzer1_ctrl_amplitude.setter
    def analyzer1_ctrl_amplitude(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch7_input.enum.analyzer1_ctrl_amplitude', int(new_val))

    @property
    def in_user1(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch7_input.enum.in_user1'))

    @in_user1.setter
    def in_user1(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch7_input.enum.in_user1', int(new_val))

    @property
    def ramp_gen_approach(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch7_input.enum.ramp_gen_approach'))

    @ramp_gen_approach.setter
    def ramp_gen_approach(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch7_input.enum.ramp_gen_approach', int(new_val))

    @property
    def ramp_gen_test(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch7_input.enum.ramp_gen_test'))

    @ramp_gen_test.setter
    def ramp_gen_test(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch7_input.enum.ramp_gen_test', int(new_val))

    @property
    def in_position_x(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch7_input.enum.in_position_x'))

    @in_position_x.setter
    def in_position_x(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch7_input.enum.in_position_x', int(new_val))

    @property
    def analyzer1_reference(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch7_input.enum.analyzer1_reference'))

    @analyzer1_reference.setter
    def analyzer1_reference(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch7_input.enum.analyzer1_reference', int(new_val))

    @property
    def ramp_gen_plane_z(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch7_input.enum.ramp_gen_plane_z'))

    @ramp_gen_plane_z.setter
    def ramp_gen_plane_z(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch7_input.enum.ramp_gen_plane_z', int(new_val))

    @property
    def memory_gen_out7(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch7_input.enum.memory_gen_out7'))

    @memory_gen_out7.setter
    def memory_gen_out7(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch7_input.enum.memory_gen_out7', int(new_val))

    @property
    def analyzer2_y(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch7_input.enum.analyzer2_y'))

    @analyzer2_y.setter
    def analyzer2_y(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch7_input.enum.analyzer2_y', int(new_val))

    @property
    def gen_test_dynamic(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch7_input.enum.gen_test_dynamic'))

    @gen_test_dynamic.setter
    def gen_test_dynamic(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch7_input.enum.gen_test_dynamic', int(new_val))

    @property
    def in_tip_current(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch7_input.enum.in_tip_current'))

    @in_tip_current.setter
    def in_tip_current(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch7_input.enum.in_tip_current', int(new_val))

    @property
    def analyzer1_x(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch7_input.enum.analyzer1_x'))

    @analyzer1_x.setter
    def analyzer1_x(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch7_input.enum.analyzer1_x', int(new_val))

    @property
    def ctrl_z_sum(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch7_input.enum.ctrl_z_sum'))

    @ctrl_z_sum.setter
    def ctrl_z_sum(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch7_input.enum.ctrl_z_sum', int(new_val))

    @property
    def analyzer2_reference(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch7_input.enum.analyzer2_reference'))

    @analyzer2_reference.setter
    def analyzer2_reference(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch7_input.enum.analyzer2_reference', int(new_val))

    @property
    def analyzer1_ctrl_delta_f(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch7_input.enum.analyzer1_ctrl_delta_f'))

    @analyzer1_ctrl_delta_f.setter
    def analyzer1_ctrl_delta_f(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch7_input.enum.analyzer1_ctrl_delta_f', int(new_val))

    @property
    def in_position_z(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch7_input.enum.in_position_z'))

    @in_position_z.setter
    def in_position_z(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch7_input.enum.in_position_z', int(new_val))

    @property
    def analyzer2_x(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch7_input.enum.analyzer2_x'))

    @analyzer2_x.setter
    def analyzer2_x(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch7_input.enum.analyzer2_x', int(new_val))

    @property
    def static(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch7_input.enum.static'))

    @static.setter
    def static(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch7_input.enum.static', int(new_val))

    @property
    def in_lateral(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch7_input.enum.in_lateral'))

    @in_lateral.setter
    def in_lateral(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch7_input.enum.in_lateral', int(new_val))

    @property
    def ramp_gen_tip_voltage(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch7_input.enum.ramp_gen_tip_voltage'))

    @ramp_gen_tip_voltage.setter
    def ramp_gen_tip_voltage(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch7_input.enum.ramp_gen_tip_voltage', int(new_val))

    @property
    def ramp_gen_position_y(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch7_input.enum.ramp_gen_position_y'))

    @ramp_gen_position_y.setter
    def ramp_gen_position_y(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch7_input.enum.ramp_gen_position_y', int(new_val))

    @property
    def ramp_gen_position_w(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch7_input.enum.ramp_gen_position_w'))

    @ramp_gen_position_w.setter
    def ramp_gen_position_w(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch7_input.enum.ramp_gen_position_w', int(new_val))

    @property
    def ramp_gen_ctrl_z(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch7_input.enum.ramp_gen_ctrl_z'))

    @ramp_gen_ctrl_z.setter
    def ramp_gen_ctrl_z(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch7_input.enum.ramp_gen_ctrl_z', int(new_val))

    @property
    def memory_gen_position_x(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch7_input.enum.memory_gen_position_x'))

    @memory_gen_position_x.setter
    def memory_gen_position_x(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch7_input.enum.memory_gen_position_x', int(new_val))

    @property
    def in_user3(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch7_input.enum.in_user3'))

    @in_user3.setter
    def in_user3(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch7_input.enum.in_user3', int(new_val))

    @property
    def in_position_y(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch7_input.enum.in_position_y'))

    @in_position_y.setter
    def in_position_y(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch7_input.enum.in_position_y', int(new_val))

    @property
    def in_user4(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch7_input.enum.in_user4'))

    @in_user4.setter
    def in_user4(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch7_input.enum.in_user4', int(new_val))

    @property
    def ramp_gen_max_z(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch7_input.enum.ramp_gen_max_z'))

    @ramp_gen_max_z.setter
    def ramp_gen_max_z(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch7_input.enum.ramp_gen_max_z', int(new_val))

    @property
    def ort_free_wave(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch7_input.enum.ort_free_wave'))

    @ort_free_wave.setter
    def ort_free_wave(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch7_input.enum.ort_free_wave', int(new_val))

    @property
    def ort_baseline_corrected(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch7_input.enum.ort_baseline_corrected'))

    @ort_baseline_corrected.setter
    def ort_baseline_corrected(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch7_input.enum.ort_baseline_corrected', int(new_val))

    @property
    def ort_baseline(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch7_input.enum.ort_baseline'))

    @ort_baseline.setter
    def ort_baseline(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch7_input.enum.ort_baseline', int(new_val))

    @property
    def fast_in2(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch7_input.enum.fast_in2'))

    @fast_in2.setter
    def fast_in2(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch7_input.enum.fast_in2', int(new_val))

    @property
    def ctrl_z_error(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch7_input.enum.ctrl_z_error'))

    @ctrl_z_error.setter
    def ctrl_z_error(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch7_input.enum.ctrl_z_error', int(new_val))

    @property
    def memory_gen_position_z(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch7_input.enum.memory_gen_position_z'))

    @memory_gen_position_z.setter
    def memory_gen_position_z(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch7_input.enum.memory_gen_position_z', int(new_val))

    @property
    def fast_in_user(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch7_input.enum.fast_in_user'))

    @fast_in_user.setter
    def fast_in_user(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch7_input.enum.fast_in_user', int(new_val))

    @property
    def memory_gen_position_y(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch7_input.enum.memory_gen_position_y'))

    @memory_gen_position_y.setter
    def memory_gen_position_y(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch7_input.enum.memory_gen_position_y', int(new_val))

    @property
    def analyzer2_amplitude(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch7_input.enum.analyzer2_amplitude'))

    @analyzer2_amplitude.setter
    def analyzer2_amplitude(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch7_input.enum.analyzer2_amplitude', int(new_val))

    @property
    def memory_gen_out8(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch7_input.enum.memory_gen_out8'))

    @memory_gen_out8.setter
    def memory_gen_out8(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch7_input.enum.memory_gen_out8', int(new_val))

    @property
    def memory_gen_drive_z(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch7_input.enum.memory_gen_drive_z'))

    @memory_gen_drive_z.setter
    def memory_gen_drive_z(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch7_input.enum.memory_gen_drive_z', int(new_val))

    @property
    def ramp_gen_user4(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch7_input.enum.ramp_gen_user4'))

    @ramp_gen_user4.setter
    def ramp_gen_user4(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch7_input.enum.ramp_gen_user4', int(new_val))

    @property
    def analyzer1_amplitude(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch7_input.enum.analyzer1_amplitude'))

    @analyzer1_amplitude.setter
    def analyzer1_amplitude(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch7_input.enum.analyzer1_amplitude', int(new_val))

    @property
    def in_detector_sum(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch7_input.enum.in_detector_sum'))

    @in_detector_sum.setter
    def in_detector_sum(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch7_input.enum.in_detector_sum', int(new_val))

    @property
    def ctrl_z_in(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch7_input.enum.ctrl_z_in'))

    @ctrl_z_in.setter
    def ctrl_z_in(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch7_input.enum.ctrl_z_in', int(new_val))

    @property
    def ctrl_user1_out(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch7_input.enum.ctrl_user1_out'))

    @ctrl_user1_out.setter
    def ctrl_user1_out(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch7_input.enum.ctrl_user1_out', int(new_val))


class RootLuData_acquisitionInstanceAttributeCapture_hi_res_ch7_input(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.data_acquisition.instance.attribute.capture_hi_res_ch7_input'
        self.enum = RootLuData_acquisitionInstanceAttributeCapture_hi_res_ch7_inputEnum(self._context)


class RootLuData_acquisitionInstanceAttributePhase_sampler_end_datapoint_vec(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.data_acquisition.instance.attribute.phase_sampler_end_datapoint_vec'


class RootLuData_acquisitionInstanceAttributeCapture_fast_group_id(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.data_acquisition.instance.attribute.capture_fast_group_id'


class RootLuData_acquisitionInstanceAttributeSampler_datapoints(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.data_acquisition.instance.attribute.sampler_datapoints'


class RootLuData_acquisitionInstanceAttributeSampler_trigger_modeEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.data_acquisition.instance.attribute.sampler_trigger_mode.enum'

    @property
    def internal_timer(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_trigger_mode.enum.internal_timer'))

    @internal_timer.setter
    def internal_timer(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_trigger_mode.enum.internal_timer', int(new_val))

    @property
    def num_trigger_modes(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_trigger_mode.enum.num_trigger_modes'))

    @num_trigger_modes.setter
    def num_trigger_modes(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_trigger_mode.enum.num_trigger_modes', int(new_val))

    @property
    def external_trigger(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_trigger_mode.enum.external_trigger'))

    @external_trigger.setter
    def external_trigger(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_trigger_mode.enum.external_trigger', int(new_val))


class RootLuData_acquisitionInstanceAttributeSampler_trigger_mode(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.data_acquisition.instance.attribute.sampler_trigger_mode'
        self.enum = RootLuData_acquisitionInstanceAttributeSampler_trigger_modeEnum(self._context)


class RootLuData_acquisitionInstanceAttributeCapture_hi_res_ch6_inputEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.data_acquisition.instance.attribute.capture_hi_res_ch6_input.enum'

    @property
    def ort_adhesion_position(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch6_input.enum.ort_adhesion_position'))

    @ort_adhesion_position.setter
    def ort_adhesion_position(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch6_input.enum.ort_adhesion_position', int(new_val))

    @property
    def ctrl_z_pid_command(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch6_input.enum.ctrl_z_pid_command'))

    @ctrl_z_pid_command.setter
    def ctrl_z_pid_command(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch6_input.enum.ctrl_z_pid_command', int(new_val))

    @property
    def in6(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch6_input.enum.in6'))

    @in6.setter
    def in6(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch6_input.enum.in6', int(new_val))

    @property
    def ctrl_z_nominal(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch6_input.enum.ctrl_z_nominal'))

    @ctrl_z_nominal.setter
    def ctrl_z_nominal(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch6_input.enum.ctrl_z_nominal', int(new_val))

    @property
    def ctrl_x_out(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch6_input.enum.ctrl_x_out'))

    @ctrl_x_out.setter
    def ctrl_x_out(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch6_input.enum.ctrl_x_out', int(new_val))

    @property
    def memory_gen_drive_y(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch6_input.enum.memory_gen_drive_y'))

    @memory_gen_drive_y.setter
    def memory_gen_drive_y(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch6_input.enum.memory_gen_drive_y', int(new_val))

    @property
    def ctrl_user2_out(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch6_input.enum.ctrl_user2_out'))

    @ctrl_user2_out.setter
    def ctrl_user2_out(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch6_input.enum.ctrl_user2_out', int(new_val))

    @property
    def analyzer2_phase(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch6_input.enum.analyzer2_phase'))

    @analyzer2_phase.setter
    def analyzer2_phase(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch6_input.enum.analyzer2_phase', int(new_val))

    @property
    def fast_in_deflection(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch6_input.enum.fast_in_deflection'))

    @fast_in_deflection.setter
    def fast_in_deflection(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch6_input.enum.fast_in_deflection', int(new_val))

    @property
    def in_user2(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch6_input.enum.in_user2'))

    @in_user2.setter
    def in_user2(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch6_input.enum.in_user2', int(new_val))

    @property
    def ramp_gen_position_x(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch6_input.enum.ramp_gen_position_x'))

    @ramp_gen_position_x.setter
    def ramp_gen_position_x(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch6_input.enum.ramp_gen_position_x', int(new_val))

    @property
    def in_deflection(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch6_input.enum.in_deflection'))

    @in_deflection.setter
    def in_deflection(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch6_input.enum.in_deflection', int(new_val))

    @property
    def ort_amplitude_reduction(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch6_input.enum.ort_amplitude_reduction'))

    @ort_amplitude_reduction.setter
    def ort_amplitude_reduction(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch6_input.enum.ort_amplitude_reduction', int(new_val))

    @property
    def analyzer2_ctrl_amplitude(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch6_input.enum.analyzer2_ctrl_amplitude'))

    @analyzer2_ctrl_amplitude.setter
    def analyzer2_ctrl_amplitude(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch6_input.enum.analyzer2_ctrl_amplitude', int(new_val))

    @property
    def memory_gen_drive_x(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch6_input.enum.memory_gen_drive_x'))

    @memory_gen_drive_x.setter
    def memory_gen_drive_x(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch6_input.enum.memory_gen_drive_x', int(new_val))

    @property
    def ramp_gen_alternate_z(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch6_input.enum.ramp_gen_alternate_z'))

    @ramp_gen_alternate_z.setter
    def ramp_gen_alternate_z(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch6_input.enum.ramp_gen_alternate_z', int(new_val))

    @property
    def analyzer2_ctrl_delta_f(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch6_input.enum.analyzer2_ctrl_delta_f'))

    @analyzer2_ctrl_delta_f.setter
    def analyzer2_ctrl_delta_f(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch6_input.enum.analyzer2_ctrl_delta_f', int(new_val))

    @property
    def ort_excitation(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch6_input.enum.ort_excitation'))

    @ort_excitation.setter
    def ort_excitation(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch6_input.enum.ort_excitation', int(new_val))

    @property
    def analyzer1_y(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch6_input.enum.analyzer1_y'))

    @analyzer1_y.setter
    def analyzer1_y(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch6_input.enum.analyzer1_y', int(new_val))

    @property
    def ort_adhesion_value(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch6_input.enum.ort_adhesion_value'))

    @ort_adhesion_value.setter
    def ort_adhesion_value(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch6_input.enum.ort_adhesion_value', int(new_val))

    @property
    def ctrl_y_out(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch6_input.enum.ctrl_y_out'))

    @ctrl_y_out.setter
    def ctrl_y_out(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch6_input.enum.ctrl_y_out', int(new_val))

    @property
    def analyzer1_phase(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch6_input.enum.analyzer1_phase'))

    @analyzer1_phase.setter
    def analyzer1_phase(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch6_input.enum.analyzer1_phase', int(new_val))

    @property
    def ctrl_z_out(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch6_input.enum.ctrl_z_out'))

    @ctrl_z_out.setter
    def ctrl_z_out(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch6_input.enum.ctrl_z_out', int(new_val))

    @property
    def ctrl_w_out(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch6_input.enum.ctrl_w_out'))

    @ctrl_w_out.setter
    def ctrl_w_out(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch6_input.enum.ctrl_w_out', int(new_val))

    @property
    def analyzer1_ctrl_amplitude(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch6_input.enum.analyzer1_ctrl_amplitude'))

    @analyzer1_ctrl_amplitude.setter
    def analyzer1_ctrl_amplitude(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch6_input.enum.analyzer1_ctrl_amplitude', int(new_val))

    @property
    def in_user1(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch6_input.enum.in_user1'))

    @in_user1.setter
    def in_user1(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch6_input.enum.in_user1', int(new_val))

    @property
    def ramp_gen_approach(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch6_input.enum.ramp_gen_approach'))

    @ramp_gen_approach.setter
    def ramp_gen_approach(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch6_input.enum.ramp_gen_approach', int(new_val))

    @property
    def ramp_gen_test(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch6_input.enum.ramp_gen_test'))

    @ramp_gen_test.setter
    def ramp_gen_test(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch6_input.enum.ramp_gen_test', int(new_val))

    @property
    def in_position_x(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch6_input.enum.in_position_x'))

    @in_position_x.setter
    def in_position_x(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch6_input.enum.in_position_x', int(new_val))

    @property
    def analyzer1_reference(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch6_input.enum.analyzer1_reference'))

    @analyzer1_reference.setter
    def analyzer1_reference(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch6_input.enum.analyzer1_reference', int(new_val))

    @property
    def ramp_gen_plane_z(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch6_input.enum.ramp_gen_plane_z'))

    @ramp_gen_plane_z.setter
    def ramp_gen_plane_z(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch6_input.enum.ramp_gen_plane_z', int(new_val))

    @property
    def memory_gen_out7(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch6_input.enum.memory_gen_out7'))

    @memory_gen_out7.setter
    def memory_gen_out7(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch6_input.enum.memory_gen_out7', int(new_val))

    @property
    def analyzer2_y(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch6_input.enum.analyzer2_y'))

    @analyzer2_y.setter
    def analyzer2_y(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch6_input.enum.analyzer2_y', int(new_val))

    @property
    def gen_test_dynamic(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch6_input.enum.gen_test_dynamic'))

    @gen_test_dynamic.setter
    def gen_test_dynamic(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch6_input.enum.gen_test_dynamic', int(new_val))

    @property
    def in_tip_current(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch6_input.enum.in_tip_current'))

    @in_tip_current.setter
    def in_tip_current(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch6_input.enum.in_tip_current', int(new_val))

    @property
    def analyzer1_x(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch6_input.enum.analyzer1_x'))

    @analyzer1_x.setter
    def analyzer1_x(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch6_input.enum.analyzer1_x', int(new_val))

    @property
    def ctrl_z_sum(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch6_input.enum.ctrl_z_sum'))

    @ctrl_z_sum.setter
    def ctrl_z_sum(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch6_input.enum.ctrl_z_sum', int(new_val))

    @property
    def analyzer2_reference(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch6_input.enum.analyzer2_reference'))

    @analyzer2_reference.setter
    def analyzer2_reference(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch6_input.enum.analyzer2_reference', int(new_val))

    @property
    def analyzer1_ctrl_delta_f(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch6_input.enum.analyzer1_ctrl_delta_f'))

    @analyzer1_ctrl_delta_f.setter
    def analyzer1_ctrl_delta_f(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch6_input.enum.analyzer1_ctrl_delta_f', int(new_val))

    @property
    def in_position_z(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch6_input.enum.in_position_z'))

    @in_position_z.setter
    def in_position_z(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch6_input.enum.in_position_z', int(new_val))

    @property
    def analyzer2_x(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch6_input.enum.analyzer2_x'))

    @analyzer2_x.setter
    def analyzer2_x(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch6_input.enum.analyzer2_x', int(new_val))

    @property
    def static(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch6_input.enum.static'))

    @static.setter
    def static(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch6_input.enum.static', int(new_val))

    @property
    def in_lateral(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch6_input.enum.in_lateral'))

    @in_lateral.setter
    def in_lateral(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch6_input.enum.in_lateral', int(new_val))

    @property
    def ramp_gen_tip_voltage(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch6_input.enum.ramp_gen_tip_voltage'))

    @ramp_gen_tip_voltage.setter
    def ramp_gen_tip_voltage(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch6_input.enum.ramp_gen_tip_voltage', int(new_val))

    @property
    def ramp_gen_position_y(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch6_input.enum.ramp_gen_position_y'))

    @ramp_gen_position_y.setter
    def ramp_gen_position_y(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch6_input.enum.ramp_gen_position_y', int(new_val))

    @property
    def ramp_gen_position_w(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch6_input.enum.ramp_gen_position_w'))

    @ramp_gen_position_w.setter
    def ramp_gen_position_w(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch6_input.enum.ramp_gen_position_w', int(new_val))

    @property
    def ramp_gen_ctrl_z(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch6_input.enum.ramp_gen_ctrl_z'))

    @ramp_gen_ctrl_z.setter
    def ramp_gen_ctrl_z(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch6_input.enum.ramp_gen_ctrl_z', int(new_val))

    @property
    def memory_gen_position_x(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch6_input.enum.memory_gen_position_x'))

    @memory_gen_position_x.setter
    def memory_gen_position_x(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch6_input.enum.memory_gen_position_x', int(new_val))

    @property
    def in_user3(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch6_input.enum.in_user3'))

    @in_user3.setter
    def in_user3(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch6_input.enum.in_user3', int(new_val))

    @property
    def in_position_y(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch6_input.enum.in_position_y'))

    @in_position_y.setter
    def in_position_y(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch6_input.enum.in_position_y', int(new_val))

    @property
    def in_user4(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch6_input.enum.in_user4'))

    @in_user4.setter
    def in_user4(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch6_input.enum.in_user4', int(new_val))

    @property
    def ramp_gen_max_z(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch6_input.enum.ramp_gen_max_z'))

    @ramp_gen_max_z.setter
    def ramp_gen_max_z(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch6_input.enum.ramp_gen_max_z', int(new_val))

    @property
    def ort_free_wave(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch6_input.enum.ort_free_wave'))

    @ort_free_wave.setter
    def ort_free_wave(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch6_input.enum.ort_free_wave', int(new_val))

    @property
    def ort_baseline_corrected(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch6_input.enum.ort_baseline_corrected'))

    @ort_baseline_corrected.setter
    def ort_baseline_corrected(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch6_input.enum.ort_baseline_corrected', int(new_val))

    @property
    def ort_baseline(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch6_input.enum.ort_baseline'))

    @ort_baseline.setter
    def ort_baseline(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch6_input.enum.ort_baseline', int(new_val))

    @property
    def fast_in2(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch6_input.enum.fast_in2'))

    @fast_in2.setter
    def fast_in2(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch6_input.enum.fast_in2', int(new_val))

    @property
    def ctrl_z_error(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch6_input.enum.ctrl_z_error'))

    @ctrl_z_error.setter
    def ctrl_z_error(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch6_input.enum.ctrl_z_error', int(new_val))

    @property
    def memory_gen_position_z(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch6_input.enum.memory_gen_position_z'))

    @memory_gen_position_z.setter
    def memory_gen_position_z(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch6_input.enum.memory_gen_position_z', int(new_val))

    @property
    def fast_in_user(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch6_input.enum.fast_in_user'))

    @fast_in_user.setter
    def fast_in_user(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch6_input.enum.fast_in_user', int(new_val))

    @property
    def memory_gen_position_y(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch6_input.enum.memory_gen_position_y'))

    @memory_gen_position_y.setter
    def memory_gen_position_y(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch6_input.enum.memory_gen_position_y', int(new_val))

    @property
    def analyzer2_amplitude(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch6_input.enum.analyzer2_amplitude'))

    @analyzer2_amplitude.setter
    def analyzer2_amplitude(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch6_input.enum.analyzer2_amplitude', int(new_val))

    @property
    def memory_gen_out8(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch6_input.enum.memory_gen_out8'))

    @memory_gen_out8.setter
    def memory_gen_out8(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch6_input.enum.memory_gen_out8', int(new_val))

    @property
    def memory_gen_drive_z(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch6_input.enum.memory_gen_drive_z'))

    @memory_gen_drive_z.setter
    def memory_gen_drive_z(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch6_input.enum.memory_gen_drive_z', int(new_val))

    @property
    def ramp_gen_user4(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch6_input.enum.ramp_gen_user4'))

    @ramp_gen_user4.setter
    def ramp_gen_user4(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch6_input.enum.ramp_gen_user4', int(new_val))

    @property
    def analyzer1_amplitude(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch6_input.enum.analyzer1_amplitude'))

    @analyzer1_amplitude.setter
    def analyzer1_amplitude(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch6_input.enum.analyzer1_amplitude', int(new_val))

    @property
    def in_detector_sum(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch6_input.enum.in_detector_sum'))

    @in_detector_sum.setter
    def in_detector_sum(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch6_input.enum.in_detector_sum', int(new_val))

    @property
    def ctrl_z_in(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch6_input.enum.ctrl_z_in'))

    @ctrl_z_in.setter
    def ctrl_z_in(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch6_input.enum.ctrl_z_in', int(new_val))

    @property
    def ctrl_user1_out(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch6_input.enum.ctrl_user1_out'))

    @ctrl_user1_out.setter
    def ctrl_user1_out(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch6_input.enum.ctrl_user1_out', int(new_val))


class RootLuData_acquisitionInstanceAttributeCapture_hi_res_ch6_input(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.data_acquisition.instance.attribute.capture_hi_res_ch6_input'
        self.enum = RootLuData_acquisitionInstanceAttributeCapture_hi_res_ch6_inputEnum(self._context)


class RootLuData_acquisitionInstanceAttributeSampler_data_rate(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.data_acquisition.instance.attribute.sampler_data_rate'


class RootLuData_acquisitionInstanceAttributePhase_sampler_group_id(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.data_acquisition.instance.attribute.phase_sampler_group_id'


class RootLuData_acquisitionInstanceAttributeSampler_filter_modeEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.data_acquisition.instance.attribute.sampler_filter_mode.enum'

    @property
    def low_pass_5_k_hz(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_filter_mode.enum.low_pass_5_k_hz'))

    @low_pass_5_k_hz.setter
    def low_pass_5_k_hz(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_filter_mode.enum.low_pass_5_k_hz', int(new_val))

    @property
    def filter_userdefined(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_filter_mode.enum.filter_userdefined'))

    @filter_userdefined.setter
    def filter_userdefined(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_filter_mode.enum.filter_userdefined', int(new_val))

    @property
    def low_pass_2_k_hz(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_filter_mode.enum.low_pass_2_k_hz'))

    @low_pass_2_k_hz.setter
    def low_pass_2_k_hz(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_filter_mode.enum.low_pass_2_k_hz', int(new_val))

    @property
    def low_pass_50_hz(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_filter_mode.enum.low_pass_50_hz'))

    @low_pass_50_hz.setter
    def low_pass_50_hz(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_filter_mode.enum.low_pass_50_hz', int(new_val))

    @property
    def low_pass_500_hz(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_filter_mode.enum.low_pass_500_hz'))

    @low_pass_500_hz.setter
    def low_pass_500_hz(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_filter_mode.enum.low_pass_500_hz', int(new_val))

    @property
    def low_pass_100_hz(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_filter_mode.enum.low_pass_100_hz'))

    @low_pass_100_hz.setter
    def low_pass_100_hz(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_filter_mode.enum.low_pass_100_hz', int(new_val))

    @property
    def low_pass_200_hz(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_filter_mode.enum.low_pass_200_hz'))

    @low_pass_200_hz.setter
    def low_pass_200_hz(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_filter_mode.enum.low_pass_200_hz', int(new_val))

    @property
    def low_pass_1_k_hz(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_filter_mode.enum.low_pass_1_k_hz'))

    @low_pass_1_k_hz.setter
    def low_pass_1_k_hz(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_filter_mode.enum.low_pass_1_k_hz', int(new_val))

    @property
    def low_pass_100_k_hz(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_filter_mode.enum.low_pass_100_k_hz'))

    @low_pass_100_k_hz.setter
    def low_pass_100_k_hz(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_filter_mode.enum.low_pass_100_k_hz', int(new_val))

    @property
    def low_pass_10_hz(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_filter_mode.enum.low_pass_10_hz'))

    @low_pass_10_hz.setter
    def low_pass_10_hz(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_filter_mode.enum.low_pass_10_hz', int(new_val))

    @property
    def low_pass_50_k_hz(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_filter_mode.enum.low_pass_50_k_hz'))

    @low_pass_50_k_hz.setter
    def low_pass_50_k_hz(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_filter_mode.enum.low_pass_50_k_hz', int(new_val))

    @property
    def low_pass_20_hz(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_filter_mode.enum.low_pass_20_hz'))

    @low_pass_20_hz.setter
    def low_pass_20_hz(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_filter_mode.enum.low_pass_20_hz', int(new_val))

    @property
    def low_pass_10_k_hz(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_filter_mode.enum.low_pass_10_k_hz'))

    @low_pass_10_k_hz.setter
    def low_pass_10_k_hz(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_filter_mode.enum.low_pass_10_k_hz', int(new_val))

    @property
    def low_pass_20_k_hz(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_filter_mode.enum.low_pass_20_k_hz'))

    @low_pass_20_k_hz.setter
    def low_pass_20_k_hz(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_filter_mode.enum.low_pass_20_k_hz', int(new_val))

    @property
    def low_pass_5_hz(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_filter_mode.enum.low_pass_5_hz'))

    @low_pass_5_hz.setter
    def low_pass_5_hz(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_filter_mode.enum.low_pass_5_hz', int(new_val))


class RootLuData_acquisitionInstanceAttributeSampler_filter_mode(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.data_acquisition.instance.attribute.sampler_filter_mode'
        self.enum = RootLuData_acquisitionInstanceAttributeSampler_filter_modeEnum(self._context)


class RootLuData_acquisitionInstanceAttributeSampler_filter_size(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.data_acquisition.instance.attribute.sampler_filter_size'


class RootLuData_acquisitionInstanceAttributeSampler_filter_typeEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.data_acquisition.instance.attribute.sampler_filter_type.enum'

    @property
    def window_hamming(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_filter_type.enum.window_hamming'))

    @window_hamming.setter
    def window_hamming(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_filter_type.enum.window_hamming', int(new_val))

    @property
    def window_rectangular(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_filter_type.enum.window_rectangular'))

    @window_rectangular.setter
    def window_rectangular(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_filter_type.enum.window_rectangular', int(new_val))

    @property
    def window_nuttall(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_filter_type.enum.window_nuttall'))

    @window_nuttall.setter
    def window_nuttall(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_filter_type.enum.window_nuttall', int(new_val))


class RootLuData_acquisitionInstanceAttributeSampler_filter_type(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.data_acquisition.instance.attribute.sampler_filter_type'
        self.enum = RootLuData_acquisitionInstanceAttributeSampler_filter_typeEnum(self._context)


class RootLuData_acquisitionInstanceAttributePhase_mode_enabled(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.data_acquisition.instance.attribute.phase_mode_enabled'


class RootLuData_acquisitionInstanceAttributeSampler_group_id(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.data_acquisition.instance.attribute.sampler_group_id'


class RootLuData_acquisitionInstanceAttributeCapture_hi_res_channel_mask(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.data_acquisition.instance.attribute.capture_hi_res_channel_mask'


class RootLuData_acquisitionInstanceAttributeCapture_hi_res_ch4_inputEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.data_acquisition.instance.attribute.capture_hi_res_ch4_input.enum'

    @property
    def ort_adhesion_position(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch4_input.enum.ort_adhesion_position'))

    @ort_adhesion_position.setter
    def ort_adhesion_position(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch4_input.enum.ort_adhesion_position', int(new_val))

    @property
    def ctrl_z_pid_command(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch4_input.enum.ctrl_z_pid_command'))

    @ctrl_z_pid_command.setter
    def ctrl_z_pid_command(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch4_input.enum.ctrl_z_pid_command', int(new_val))

    @property
    def in6(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch4_input.enum.in6'))

    @in6.setter
    def in6(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch4_input.enum.in6', int(new_val))

    @property
    def ctrl_z_nominal(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch4_input.enum.ctrl_z_nominal'))

    @ctrl_z_nominal.setter
    def ctrl_z_nominal(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch4_input.enum.ctrl_z_nominal', int(new_val))

    @property
    def ctrl_x_out(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch4_input.enum.ctrl_x_out'))

    @ctrl_x_out.setter
    def ctrl_x_out(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch4_input.enum.ctrl_x_out', int(new_val))

    @property
    def memory_gen_drive_y(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch4_input.enum.memory_gen_drive_y'))

    @memory_gen_drive_y.setter
    def memory_gen_drive_y(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch4_input.enum.memory_gen_drive_y', int(new_val))

    @property
    def ctrl_user2_out(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch4_input.enum.ctrl_user2_out'))

    @ctrl_user2_out.setter
    def ctrl_user2_out(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch4_input.enum.ctrl_user2_out', int(new_val))

    @property
    def analyzer2_phase(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch4_input.enum.analyzer2_phase'))

    @analyzer2_phase.setter
    def analyzer2_phase(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch4_input.enum.analyzer2_phase', int(new_val))

    @property
    def fast_in_deflection(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch4_input.enum.fast_in_deflection'))

    @fast_in_deflection.setter
    def fast_in_deflection(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch4_input.enum.fast_in_deflection', int(new_val))

    @property
    def in_user2(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch4_input.enum.in_user2'))

    @in_user2.setter
    def in_user2(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch4_input.enum.in_user2', int(new_val))

    @property
    def ramp_gen_position_x(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch4_input.enum.ramp_gen_position_x'))

    @ramp_gen_position_x.setter
    def ramp_gen_position_x(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch4_input.enum.ramp_gen_position_x', int(new_val))

    @property
    def in_deflection(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch4_input.enum.in_deflection'))

    @in_deflection.setter
    def in_deflection(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch4_input.enum.in_deflection', int(new_val))

    @property
    def ort_amplitude_reduction(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch4_input.enum.ort_amplitude_reduction'))

    @ort_amplitude_reduction.setter
    def ort_amplitude_reduction(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch4_input.enum.ort_amplitude_reduction', int(new_val))

    @property
    def analyzer2_ctrl_amplitude(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch4_input.enum.analyzer2_ctrl_amplitude'))

    @analyzer2_ctrl_amplitude.setter
    def analyzer2_ctrl_amplitude(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch4_input.enum.analyzer2_ctrl_amplitude', int(new_val))

    @property
    def memory_gen_drive_x(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch4_input.enum.memory_gen_drive_x'))

    @memory_gen_drive_x.setter
    def memory_gen_drive_x(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch4_input.enum.memory_gen_drive_x', int(new_val))

    @property
    def ramp_gen_alternate_z(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch4_input.enum.ramp_gen_alternate_z'))

    @ramp_gen_alternate_z.setter
    def ramp_gen_alternate_z(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch4_input.enum.ramp_gen_alternate_z', int(new_val))

    @property
    def analyzer2_ctrl_delta_f(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch4_input.enum.analyzer2_ctrl_delta_f'))

    @analyzer2_ctrl_delta_f.setter
    def analyzer2_ctrl_delta_f(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch4_input.enum.analyzer2_ctrl_delta_f', int(new_val))

    @property
    def ort_excitation(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch4_input.enum.ort_excitation'))

    @ort_excitation.setter
    def ort_excitation(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch4_input.enum.ort_excitation', int(new_val))

    @property
    def analyzer1_y(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch4_input.enum.analyzer1_y'))

    @analyzer1_y.setter
    def analyzer1_y(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch4_input.enum.analyzer1_y', int(new_val))

    @property
    def ort_adhesion_value(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch4_input.enum.ort_adhesion_value'))

    @ort_adhesion_value.setter
    def ort_adhesion_value(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch4_input.enum.ort_adhesion_value', int(new_val))

    @property
    def ctrl_y_out(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch4_input.enum.ctrl_y_out'))

    @ctrl_y_out.setter
    def ctrl_y_out(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch4_input.enum.ctrl_y_out', int(new_val))

    @property
    def analyzer1_phase(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch4_input.enum.analyzer1_phase'))

    @analyzer1_phase.setter
    def analyzer1_phase(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch4_input.enum.analyzer1_phase', int(new_val))

    @property
    def ctrl_z_out(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch4_input.enum.ctrl_z_out'))

    @ctrl_z_out.setter
    def ctrl_z_out(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch4_input.enum.ctrl_z_out', int(new_val))

    @property
    def ctrl_w_out(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch4_input.enum.ctrl_w_out'))

    @ctrl_w_out.setter
    def ctrl_w_out(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch4_input.enum.ctrl_w_out', int(new_val))

    @property
    def analyzer1_ctrl_amplitude(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch4_input.enum.analyzer1_ctrl_amplitude'))

    @analyzer1_ctrl_amplitude.setter
    def analyzer1_ctrl_amplitude(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch4_input.enum.analyzer1_ctrl_amplitude', int(new_val))

    @property
    def in_user1(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch4_input.enum.in_user1'))

    @in_user1.setter
    def in_user1(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch4_input.enum.in_user1', int(new_val))

    @property
    def ramp_gen_approach(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch4_input.enum.ramp_gen_approach'))

    @ramp_gen_approach.setter
    def ramp_gen_approach(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch4_input.enum.ramp_gen_approach', int(new_val))

    @property
    def ramp_gen_test(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch4_input.enum.ramp_gen_test'))

    @ramp_gen_test.setter
    def ramp_gen_test(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch4_input.enum.ramp_gen_test', int(new_val))

    @property
    def in_position_x(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch4_input.enum.in_position_x'))

    @in_position_x.setter
    def in_position_x(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch4_input.enum.in_position_x', int(new_val))

    @property
    def analyzer1_reference(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch4_input.enum.analyzer1_reference'))

    @analyzer1_reference.setter
    def analyzer1_reference(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch4_input.enum.analyzer1_reference', int(new_val))

    @property
    def ramp_gen_plane_z(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch4_input.enum.ramp_gen_plane_z'))

    @ramp_gen_plane_z.setter
    def ramp_gen_plane_z(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch4_input.enum.ramp_gen_plane_z', int(new_val))

    @property
    def memory_gen_out7(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch4_input.enum.memory_gen_out7'))

    @memory_gen_out7.setter
    def memory_gen_out7(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch4_input.enum.memory_gen_out7', int(new_val))

    @property
    def analyzer2_y(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch4_input.enum.analyzer2_y'))

    @analyzer2_y.setter
    def analyzer2_y(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch4_input.enum.analyzer2_y', int(new_val))

    @property
    def gen_test_dynamic(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch4_input.enum.gen_test_dynamic'))

    @gen_test_dynamic.setter
    def gen_test_dynamic(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch4_input.enum.gen_test_dynamic', int(new_val))

    @property
    def in_tip_current(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch4_input.enum.in_tip_current'))

    @in_tip_current.setter
    def in_tip_current(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch4_input.enum.in_tip_current', int(new_val))

    @property
    def analyzer1_x(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch4_input.enum.analyzer1_x'))

    @analyzer1_x.setter
    def analyzer1_x(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch4_input.enum.analyzer1_x', int(new_val))

    @property
    def ctrl_z_sum(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch4_input.enum.ctrl_z_sum'))

    @ctrl_z_sum.setter
    def ctrl_z_sum(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch4_input.enum.ctrl_z_sum', int(new_val))

    @property
    def analyzer2_reference(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch4_input.enum.analyzer2_reference'))

    @analyzer2_reference.setter
    def analyzer2_reference(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch4_input.enum.analyzer2_reference', int(new_val))

    @property
    def analyzer1_ctrl_delta_f(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch4_input.enum.analyzer1_ctrl_delta_f'))

    @analyzer1_ctrl_delta_f.setter
    def analyzer1_ctrl_delta_f(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch4_input.enum.analyzer1_ctrl_delta_f', int(new_val))

    @property
    def in_position_z(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch4_input.enum.in_position_z'))

    @in_position_z.setter
    def in_position_z(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch4_input.enum.in_position_z', int(new_val))

    @property
    def analyzer2_x(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch4_input.enum.analyzer2_x'))

    @analyzer2_x.setter
    def analyzer2_x(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch4_input.enum.analyzer2_x', int(new_val))

    @property
    def static(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch4_input.enum.static'))

    @static.setter
    def static(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch4_input.enum.static', int(new_val))

    @property
    def in_lateral(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch4_input.enum.in_lateral'))

    @in_lateral.setter
    def in_lateral(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch4_input.enum.in_lateral', int(new_val))

    @property
    def ramp_gen_tip_voltage(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch4_input.enum.ramp_gen_tip_voltage'))

    @ramp_gen_tip_voltage.setter
    def ramp_gen_tip_voltage(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch4_input.enum.ramp_gen_tip_voltage', int(new_val))

    @property
    def ramp_gen_position_y(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch4_input.enum.ramp_gen_position_y'))

    @ramp_gen_position_y.setter
    def ramp_gen_position_y(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch4_input.enum.ramp_gen_position_y', int(new_val))

    @property
    def ramp_gen_position_w(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch4_input.enum.ramp_gen_position_w'))

    @ramp_gen_position_w.setter
    def ramp_gen_position_w(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch4_input.enum.ramp_gen_position_w', int(new_val))

    @property
    def ramp_gen_ctrl_z(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch4_input.enum.ramp_gen_ctrl_z'))

    @ramp_gen_ctrl_z.setter
    def ramp_gen_ctrl_z(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch4_input.enum.ramp_gen_ctrl_z', int(new_val))

    @property
    def memory_gen_position_x(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch4_input.enum.memory_gen_position_x'))

    @memory_gen_position_x.setter
    def memory_gen_position_x(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch4_input.enum.memory_gen_position_x', int(new_val))

    @property
    def in_user3(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch4_input.enum.in_user3'))

    @in_user3.setter
    def in_user3(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch4_input.enum.in_user3', int(new_val))

    @property
    def in_position_y(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch4_input.enum.in_position_y'))

    @in_position_y.setter
    def in_position_y(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch4_input.enum.in_position_y', int(new_val))

    @property
    def in_user4(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch4_input.enum.in_user4'))

    @in_user4.setter
    def in_user4(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch4_input.enum.in_user4', int(new_val))

    @property
    def ramp_gen_max_z(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch4_input.enum.ramp_gen_max_z'))

    @ramp_gen_max_z.setter
    def ramp_gen_max_z(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch4_input.enum.ramp_gen_max_z', int(new_val))

    @property
    def ort_free_wave(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch4_input.enum.ort_free_wave'))

    @ort_free_wave.setter
    def ort_free_wave(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch4_input.enum.ort_free_wave', int(new_val))

    @property
    def ort_baseline_corrected(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch4_input.enum.ort_baseline_corrected'))

    @ort_baseline_corrected.setter
    def ort_baseline_corrected(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch4_input.enum.ort_baseline_corrected', int(new_val))

    @property
    def ort_baseline(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch4_input.enum.ort_baseline'))

    @ort_baseline.setter
    def ort_baseline(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch4_input.enum.ort_baseline', int(new_val))

    @property
    def fast_in2(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch4_input.enum.fast_in2'))

    @fast_in2.setter
    def fast_in2(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch4_input.enum.fast_in2', int(new_val))

    @property
    def ctrl_z_error(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch4_input.enum.ctrl_z_error'))

    @ctrl_z_error.setter
    def ctrl_z_error(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch4_input.enum.ctrl_z_error', int(new_val))

    @property
    def memory_gen_position_z(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch4_input.enum.memory_gen_position_z'))

    @memory_gen_position_z.setter
    def memory_gen_position_z(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch4_input.enum.memory_gen_position_z', int(new_val))

    @property
    def fast_in_user(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch4_input.enum.fast_in_user'))

    @fast_in_user.setter
    def fast_in_user(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch4_input.enum.fast_in_user', int(new_val))

    @property
    def memory_gen_position_y(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch4_input.enum.memory_gen_position_y'))

    @memory_gen_position_y.setter
    def memory_gen_position_y(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch4_input.enum.memory_gen_position_y', int(new_val))

    @property
    def analyzer2_amplitude(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch4_input.enum.analyzer2_amplitude'))

    @analyzer2_amplitude.setter
    def analyzer2_amplitude(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch4_input.enum.analyzer2_amplitude', int(new_val))

    @property
    def memory_gen_out8(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch4_input.enum.memory_gen_out8'))

    @memory_gen_out8.setter
    def memory_gen_out8(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch4_input.enum.memory_gen_out8', int(new_val))

    @property
    def memory_gen_drive_z(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch4_input.enum.memory_gen_drive_z'))

    @memory_gen_drive_z.setter
    def memory_gen_drive_z(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch4_input.enum.memory_gen_drive_z', int(new_val))

    @property
    def ramp_gen_user4(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch4_input.enum.ramp_gen_user4'))

    @ramp_gen_user4.setter
    def ramp_gen_user4(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch4_input.enum.ramp_gen_user4', int(new_val))

    @property
    def analyzer1_amplitude(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch4_input.enum.analyzer1_amplitude'))

    @analyzer1_amplitude.setter
    def analyzer1_amplitude(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch4_input.enum.analyzer1_amplitude', int(new_val))

    @property
    def in_detector_sum(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch4_input.enum.in_detector_sum'))

    @in_detector_sum.setter
    def in_detector_sum(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch4_input.enum.in_detector_sum', int(new_val))

    @property
    def ctrl_z_in(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch4_input.enum.ctrl_z_in'))

    @ctrl_z_in.setter
    def ctrl_z_in(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch4_input.enum.ctrl_z_in', int(new_val))

    @property
    def ctrl_user1_out(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch4_input.enum.ctrl_user1_out'))

    @ctrl_user1_out.setter
    def ctrl_user1_out(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch4_input.enum.ctrl_user1_out', int(new_val))


class RootLuData_acquisitionInstanceAttributeCapture_hi_res_ch4_input(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.data_acquisition.instance.attribute.capture_hi_res_ch4_input'
        self.enum = RootLuData_acquisitionInstanceAttributeCapture_hi_res_ch4_inputEnum(self._context)


class RootLuData_acquisitionInstanceAttributeCapture_fast_sampling_rate(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.data_acquisition.instance.attribute.capture_fast_sampling_rate'


class RootLuData_acquisitionInstanceAttributeSampler_hi_res_ch2_inputEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch2_input.enum'

    @property
    def ort_adhesion_position(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch2_input.enum.ort_adhesion_position'))

    @ort_adhesion_position.setter
    def ort_adhesion_position(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch2_input.enum.ort_adhesion_position', int(new_val))

    @property
    def ctrl_z_pid_command(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch2_input.enum.ctrl_z_pid_command'))

    @ctrl_z_pid_command.setter
    def ctrl_z_pid_command(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch2_input.enum.ctrl_z_pid_command', int(new_val))

    @property
    def in6(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch2_input.enum.in6'))

    @in6.setter
    def in6(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch2_input.enum.in6', int(new_val))

    @property
    def ctrl_z_nominal(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch2_input.enum.ctrl_z_nominal'))

    @ctrl_z_nominal.setter
    def ctrl_z_nominal(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch2_input.enum.ctrl_z_nominal', int(new_val))

    @property
    def ctrl_x_out(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch2_input.enum.ctrl_x_out'))

    @ctrl_x_out.setter
    def ctrl_x_out(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch2_input.enum.ctrl_x_out', int(new_val))

    @property
    def memory_gen_drive_y(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch2_input.enum.memory_gen_drive_y'))

    @memory_gen_drive_y.setter
    def memory_gen_drive_y(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch2_input.enum.memory_gen_drive_y', int(new_val))

    @property
    def ctrl_user2_out(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch2_input.enum.ctrl_user2_out'))

    @ctrl_user2_out.setter
    def ctrl_user2_out(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch2_input.enum.ctrl_user2_out', int(new_val))

    @property
    def analyzer2_phase(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch2_input.enum.analyzer2_phase'))

    @analyzer2_phase.setter
    def analyzer2_phase(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch2_input.enum.analyzer2_phase', int(new_val))

    @property
    def fast_in_deflection(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch2_input.enum.fast_in_deflection'))

    @fast_in_deflection.setter
    def fast_in_deflection(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch2_input.enum.fast_in_deflection', int(new_val))

    @property
    def in_user2(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch2_input.enum.in_user2'))

    @in_user2.setter
    def in_user2(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch2_input.enum.in_user2', int(new_val))

    @property
    def ramp_gen_position_x(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch2_input.enum.ramp_gen_position_x'))

    @ramp_gen_position_x.setter
    def ramp_gen_position_x(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch2_input.enum.ramp_gen_position_x', int(new_val))

    @property
    def in_deflection(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch2_input.enum.in_deflection'))

    @in_deflection.setter
    def in_deflection(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch2_input.enum.in_deflection', int(new_val))

    @property
    def ort_amplitude_reduction(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch2_input.enum.ort_amplitude_reduction'))

    @ort_amplitude_reduction.setter
    def ort_amplitude_reduction(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch2_input.enum.ort_amplitude_reduction', int(new_val))

    @property
    def analyzer2_ctrl_amplitude(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch2_input.enum.analyzer2_ctrl_amplitude'))

    @analyzer2_ctrl_amplitude.setter
    def analyzer2_ctrl_amplitude(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch2_input.enum.analyzer2_ctrl_amplitude', int(new_val))

    @property
    def memory_gen_drive_x(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch2_input.enum.memory_gen_drive_x'))

    @memory_gen_drive_x.setter
    def memory_gen_drive_x(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch2_input.enum.memory_gen_drive_x', int(new_val))

    @property
    def ramp_gen_alternate_z(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch2_input.enum.ramp_gen_alternate_z'))

    @ramp_gen_alternate_z.setter
    def ramp_gen_alternate_z(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch2_input.enum.ramp_gen_alternate_z', int(new_val))

    @property
    def analyzer2_ctrl_delta_f(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch2_input.enum.analyzer2_ctrl_delta_f'))

    @analyzer2_ctrl_delta_f.setter
    def analyzer2_ctrl_delta_f(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch2_input.enum.analyzer2_ctrl_delta_f', int(new_val))

    @property
    def ort_excitation(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch2_input.enum.ort_excitation'))

    @ort_excitation.setter
    def ort_excitation(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch2_input.enum.ort_excitation', int(new_val))

    @property
    def analyzer1_y(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch2_input.enum.analyzer1_y'))

    @analyzer1_y.setter
    def analyzer1_y(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch2_input.enum.analyzer1_y', int(new_val))

    @property
    def ort_adhesion_value(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch2_input.enum.ort_adhesion_value'))

    @ort_adhesion_value.setter
    def ort_adhesion_value(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch2_input.enum.ort_adhesion_value', int(new_val))

    @property
    def ctrl_y_out(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch2_input.enum.ctrl_y_out'))

    @ctrl_y_out.setter
    def ctrl_y_out(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch2_input.enum.ctrl_y_out', int(new_val))

    @property
    def analyzer1_phase(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch2_input.enum.analyzer1_phase'))

    @analyzer1_phase.setter
    def analyzer1_phase(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch2_input.enum.analyzer1_phase', int(new_val))

    @property
    def ctrl_z_out(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch2_input.enum.ctrl_z_out'))

    @ctrl_z_out.setter
    def ctrl_z_out(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch2_input.enum.ctrl_z_out', int(new_val))

    @property
    def ctrl_w_out(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch2_input.enum.ctrl_w_out'))

    @ctrl_w_out.setter
    def ctrl_w_out(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch2_input.enum.ctrl_w_out', int(new_val))

    @property
    def analyzer1_ctrl_amplitude(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch2_input.enum.analyzer1_ctrl_amplitude'))

    @analyzer1_ctrl_amplitude.setter
    def analyzer1_ctrl_amplitude(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch2_input.enum.analyzer1_ctrl_amplitude', int(new_val))

    @property
    def in_user1(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch2_input.enum.in_user1'))

    @in_user1.setter
    def in_user1(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch2_input.enum.in_user1', int(new_val))

    @property
    def ramp_gen_approach(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch2_input.enum.ramp_gen_approach'))

    @ramp_gen_approach.setter
    def ramp_gen_approach(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch2_input.enum.ramp_gen_approach', int(new_val))

    @property
    def ramp_gen_test(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch2_input.enum.ramp_gen_test'))

    @ramp_gen_test.setter
    def ramp_gen_test(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch2_input.enum.ramp_gen_test', int(new_val))

    @property
    def in_position_x(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch2_input.enum.in_position_x'))

    @in_position_x.setter
    def in_position_x(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch2_input.enum.in_position_x', int(new_val))

    @property
    def analyzer1_reference(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch2_input.enum.analyzer1_reference'))

    @analyzer1_reference.setter
    def analyzer1_reference(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch2_input.enum.analyzer1_reference', int(new_val))

    @property
    def ramp_gen_plane_z(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch2_input.enum.ramp_gen_plane_z'))

    @ramp_gen_plane_z.setter
    def ramp_gen_plane_z(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch2_input.enum.ramp_gen_plane_z', int(new_val))

    @property
    def memory_gen_out7(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch2_input.enum.memory_gen_out7'))

    @memory_gen_out7.setter
    def memory_gen_out7(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch2_input.enum.memory_gen_out7', int(new_val))

    @property
    def analyzer2_y(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch2_input.enum.analyzer2_y'))

    @analyzer2_y.setter
    def analyzer2_y(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch2_input.enum.analyzer2_y', int(new_val))

    @property
    def gen_test_dynamic(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch2_input.enum.gen_test_dynamic'))

    @gen_test_dynamic.setter
    def gen_test_dynamic(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch2_input.enum.gen_test_dynamic', int(new_val))

    @property
    def in_tip_current(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch2_input.enum.in_tip_current'))

    @in_tip_current.setter
    def in_tip_current(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch2_input.enum.in_tip_current', int(new_val))

    @property
    def analyzer1_x(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch2_input.enum.analyzer1_x'))

    @analyzer1_x.setter
    def analyzer1_x(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch2_input.enum.analyzer1_x', int(new_val))

    @property
    def ctrl_z_sum(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch2_input.enum.ctrl_z_sum'))

    @ctrl_z_sum.setter
    def ctrl_z_sum(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch2_input.enum.ctrl_z_sum', int(new_val))

    @property
    def analyzer2_reference(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch2_input.enum.analyzer2_reference'))

    @analyzer2_reference.setter
    def analyzer2_reference(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch2_input.enum.analyzer2_reference', int(new_val))

    @property
    def analyzer1_ctrl_delta_f(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch2_input.enum.analyzer1_ctrl_delta_f'))

    @analyzer1_ctrl_delta_f.setter
    def analyzer1_ctrl_delta_f(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch2_input.enum.analyzer1_ctrl_delta_f', int(new_val))

    @property
    def in_position_z(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch2_input.enum.in_position_z'))

    @in_position_z.setter
    def in_position_z(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch2_input.enum.in_position_z', int(new_val))

    @property
    def analyzer2_x(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch2_input.enum.analyzer2_x'))

    @analyzer2_x.setter
    def analyzer2_x(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch2_input.enum.analyzer2_x', int(new_val))

    @property
    def static(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch2_input.enum.static'))

    @static.setter
    def static(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch2_input.enum.static', int(new_val))

    @property
    def in_lateral(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch2_input.enum.in_lateral'))

    @in_lateral.setter
    def in_lateral(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch2_input.enum.in_lateral', int(new_val))

    @property
    def ramp_gen_tip_voltage(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch2_input.enum.ramp_gen_tip_voltage'))

    @ramp_gen_tip_voltage.setter
    def ramp_gen_tip_voltage(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch2_input.enum.ramp_gen_tip_voltage', int(new_val))

    @property
    def ramp_gen_position_y(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch2_input.enum.ramp_gen_position_y'))

    @ramp_gen_position_y.setter
    def ramp_gen_position_y(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch2_input.enum.ramp_gen_position_y', int(new_val))

    @property
    def ramp_gen_position_w(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch2_input.enum.ramp_gen_position_w'))

    @ramp_gen_position_w.setter
    def ramp_gen_position_w(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch2_input.enum.ramp_gen_position_w', int(new_val))

    @property
    def ramp_gen_ctrl_z(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch2_input.enum.ramp_gen_ctrl_z'))

    @ramp_gen_ctrl_z.setter
    def ramp_gen_ctrl_z(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch2_input.enum.ramp_gen_ctrl_z', int(new_val))

    @property
    def memory_gen_position_x(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch2_input.enum.memory_gen_position_x'))

    @memory_gen_position_x.setter
    def memory_gen_position_x(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch2_input.enum.memory_gen_position_x', int(new_val))

    @property
    def in_user3(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch2_input.enum.in_user3'))

    @in_user3.setter
    def in_user3(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch2_input.enum.in_user3', int(new_val))

    @property
    def in_position_y(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch2_input.enum.in_position_y'))

    @in_position_y.setter
    def in_position_y(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch2_input.enum.in_position_y', int(new_val))

    @property
    def in_user4(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch2_input.enum.in_user4'))

    @in_user4.setter
    def in_user4(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch2_input.enum.in_user4', int(new_val))

    @property
    def ramp_gen_max_z(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch2_input.enum.ramp_gen_max_z'))

    @ramp_gen_max_z.setter
    def ramp_gen_max_z(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch2_input.enum.ramp_gen_max_z', int(new_val))

    @property
    def ort_free_wave(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch2_input.enum.ort_free_wave'))

    @ort_free_wave.setter
    def ort_free_wave(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch2_input.enum.ort_free_wave', int(new_val))

    @property
    def ort_baseline_corrected(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch2_input.enum.ort_baseline_corrected'))

    @ort_baseline_corrected.setter
    def ort_baseline_corrected(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch2_input.enum.ort_baseline_corrected', int(new_val))

    @property
    def ort_baseline(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch2_input.enum.ort_baseline'))

    @ort_baseline.setter
    def ort_baseline(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch2_input.enum.ort_baseline', int(new_val))

    @property
    def fast_in2(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch2_input.enum.fast_in2'))

    @fast_in2.setter
    def fast_in2(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch2_input.enum.fast_in2', int(new_val))

    @property
    def ctrl_z_error(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch2_input.enum.ctrl_z_error'))

    @ctrl_z_error.setter
    def ctrl_z_error(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch2_input.enum.ctrl_z_error', int(new_val))

    @property
    def memory_gen_position_z(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch2_input.enum.memory_gen_position_z'))

    @memory_gen_position_z.setter
    def memory_gen_position_z(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch2_input.enum.memory_gen_position_z', int(new_val))

    @property
    def fast_in_user(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch2_input.enum.fast_in_user'))

    @fast_in_user.setter
    def fast_in_user(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch2_input.enum.fast_in_user', int(new_val))

    @property
    def memory_gen_position_y(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch2_input.enum.memory_gen_position_y'))

    @memory_gen_position_y.setter
    def memory_gen_position_y(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch2_input.enum.memory_gen_position_y', int(new_val))

    @property
    def analyzer2_amplitude(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch2_input.enum.analyzer2_amplitude'))

    @analyzer2_amplitude.setter
    def analyzer2_amplitude(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch2_input.enum.analyzer2_amplitude', int(new_val))

    @property
    def memory_gen_out8(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch2_input.enum.memory_gen_out8'))

    @memory_gen_out8.setter
    def memory_gen_out8(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch2_input.enum.memory_gen_out8', int(new_val))

    @property
    def memory_gen_drive_z(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch2_input.enum.memory_gen_drive_z'))

    @memory_gen_drive_z.setter
    def memory_gen_drive_z(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch2_input.enum.memory_gen_drive_z', int(new_val))

    @property
    def ramp_gen_user4(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch2_input.enum.ramp_gen_user4'))

    @ramp_gen_user4.setter
    def ramp_gen_user4(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch2_input.enum.ramp_gen_user4', int(new_val))

    @property
    def analyzer1_amplitude(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch2_input.enum.analyzer1_amplitude'))

    @analyzer1_amplitude.setter
    def analyzer1_amplitude(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch2_input.enum.analyzer1_amplitude', int(new_val))

    @property
    def in_detector_sum(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch2_input.enum.in_detector_sum'))

    @in_detector_sum.setter
    def in_detector_sum(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch2_input.enum.in_detector_sum', int(new_val))

    @property
    def ctrl_z_in(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch2_input.enum.ctrl_z_in'))

    @ctrl_z_in.setter
    def ctrl_z_in(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch2_input.enum.ctrl_z_in', int(new_val))

    @property
    def ctrl_user1_out(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch2_input.enum.ctrl_user1_out'))

    @ctrl_user1_out.setter
    def ctrl_user1_out(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch2_input.enum.ctrl_user1_out', int(new_val))


class RootLuData_acquisitionInstanceAttributeSampler_hi_res_ch2_input(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch2_input'
        self.enum = RootLuData_acquisitionInstanceAttributeSampler_hi_res_ch2_inputEnum(self._context)


class RootLuData_acquisitionInstanceAttributeCapture_hi_res_ch5_inputEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.data_acquisition.instance.attribute.capture_hi_res_ch5_input.enum'

    @property
    def ort_adhesion_position(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch5_input.enum.ort_adhesion_position'))

    @ort_adhesion_position.setter
    def ort_adhesion_position(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch5_input.enum.ort_adhesion_position', int(new_val))

    @property
    def ctrl_z_pid_command(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch5_input.enum.ctrl_z_pid_command'))

    @ctrl_z_pid_command.setter
    def ctrl_z_pid_command(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch5_input.enum.ctrl_z_pid_command', int(new_val))

    @property
    def in6(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch5_input.enum.in6'))

    @in6.setter
    def in6(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch5_input.enum.in6', int(new_val))

    @property
    def ctrl_z_nominal(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch5_input.enum.ctrl_z_nominal'))

    @ctrl_z_nominal.setter
    def ctrl_z_nominal(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch5_input.enum.ctrl_z_nominal', int(new_val))

    @property
    def ctrl_x_out(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch5_input.enum.ctrl_x_out'))

    @ctrl_x_out.setter
    def ctrl_x_out(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch5_input.enum.ctrl_x_out', int(new_val))

    @property
    def memory_gen_drive_y(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch5_input.enum.memory_gen_drive_y'))

    @memory_gen_drive_y.setter
    def memory_gen_drive_y(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch5_input.enum.memory_gen_drive_y', int(new_val))

    @property
    def ctrl_user2_out(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch5_input.enum.ctrl_user2_out'))

    @ctrl_user2_out.setter
    def ctrl_user2_out(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch5_input.enum.ctrl_user2_out', int(new_val))

    @property
    def analyzer2_phase(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch5_input.enum.analyzer2_phase'))

    @analyzer2_phase.setter
    def analyzer2_phase(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch5_input.enum.analyzer2_phase', int(new_val))

    @property
    def fast_in_deflection(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch5_input.enum.fast_in_deflection'))

    @fast_in_deflection.setter
    def fast_in_deflection(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch5_input.enum.fast_in_deflection', int(new_val))

    @property
    def in_user2(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch5_input.enum.in_user2'))

    @in_user2.setter
    def in_user2(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch5_input.enum.in_user2', int(new_val))

    @property
    def ramp_gen_position_x(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch5_input.enum.ramp_gen_position_x'))

    @ramp_gen_position_x.setter
    def ramp_gen_position_x(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch5_input.enum.ramp_gen_position_x', int(new_val))

    @property
    def in_deflection(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch5_input.enum.in_deflection'))

    @in_deflection.setter
    def in_deflection(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch5_input.enum.in_deflection', int(new_val))

    @property
    def ort_amplitude_reduction(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch5_input.enum.ort_amplitude_reduction'))

    @ort_amplitude_reduction.setter
    def ort_amplitude_reduction(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch5_input.enum.ort_amplitude_reduction', int(new_val))

    @property
    def analyzer2_ctrl_amplitude(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch5_input.enum.analyzer2_ctrl_amplitude'))

    @analyzer2_ctrl_amplitude.setter
    def analyzer2_ctrl_amplitude(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch5_input.enum.analyzer2_ctrl_amplitude', int(new_val))

    @property
    def memory_gen_drive_x(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch5_input.enum.memory_gen_drive_x'))

    @memory_gen_drive_x.setter
    def memory_gen_drive_x(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch5_input.enum.memory_gen_drive_x', int(new_val))

    @property
    def ramp_gen_alternate_z(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch5_input.enum.ramp_gen_alternate_z'))

    @ramp_gen_alternate_z.setter
    def ramp_gen_alternate_z(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch5_input.enum.ramp_gen_alternate_z', int(new_val))

    @property
    def analyzer2_ctrl_delta_f(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch5_input.enum.analyzer2_ctrl_delta_f'))

    @analyzer2_ctrl_delta_f.setter
    def analyzer2_ctrl_delta_f(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch5_input.enum.analyzer2_ctrl_delta_f', int(new_val))

    @property
    def ort_excitation(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch5_input.enum.ort_excitation'))

    @ort_excitation.setter
    def ort_excitation(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch5_input.enum.ort_excitation', int(new_val))

    @property
    def analyzer1_y(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch5_input.enum.analyzer1_y'))

    @analyzer1_y.setter
    def analyzer1_y(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch5_input.enum.analyzer1_y', int(new_val))

    @property
    def ort_adhesion_value(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch5_input.enum.ort_adhesion_value'))

    @ort_adhesion_value.setter
    def ort_adhesion_value(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch5_input.enum.ort_adhesion_value', int(new_val))

    @property
    def ctrl_y_out(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch5_input.enum.ctrl_y_out'))

    @ctrl_y_out.setter
    def ctrl_y_out(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch5_input.enum.ctrl_y_out', int(new_val))

    @property
    def analyzer1_phase(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch5_input.enum.analyzer1_phase'))

    @analyzer1_phase.setter
    def analyzer1_phase(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch5_input.enum.analyzer1_phase', int(new_val))

    @property
    def ctrl_z_out(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch5_input.enum.ctrl_z_out'))

    @ctrl_z_out.setter
    def ctrl_z_out(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch5_input.enum.ctrl_z_out', int(new_val))

    @property
    def ctrl_w_out(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch5_input.enum.ctrl_w_out'))

    @ctrl_w_out.setter
    def ctrl_w_out(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch5_input.enum.ctrl_w_out', int(new_val))

    @property
    def analyzer1_ctrl_amplitude(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch5_input.enum.analyzer1_ctrl_amplitude'))

    @analyzer1_ctrl_amplitude.setter
    def analyzer1_ctrl_amplitude(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch5_input.enum.analyzer1_ctrl_amplitude', int(new_val))

    @property
    def in_user1(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch5_input.enum.in_user1'))

    @in_user1.setter
    def in_user1(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch5_input.enum.in_user1', int(new_val))

    @property
    def ramp_gen_approach(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch5_input.enum.ramp_gen_approach'))

    @ramp_gen_approach.setter
    def ramp_gen_approach(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch5_input.enum.ramp_gen_approach', int(new_val))

    @property
    def ramp_gen_test(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch5_input.enum.ramp_gen_test'))

    @ramp_gen_test.setter
    def ramp_gen_test(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch5_input.enum.ramp_gen_test', int(new_val))

    @property
    def in_position_x(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch5_input.enum.in_position_x'))

    @in_position_x.setter
    def in_position_x(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch5_input.enum.in_position_x', int(new_val))

    @property
    def analyzer1_reference(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch5_input.enum.analyzer1_reference'))

    @analyzer1_reference.setter
    def analyzer1_reference(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch5_input.enum.analyzer1_reference', int(new_val))

    @property
    def ramp_gen_plane_z(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch5_input.enum.ramp_gen_plane_z'))

    @ramp_gen_plane_z.setter
    def ramp_gen_plane_z(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch5_input.enum.ramp_gen_plane_z', int(new_val))

    @property
    def memory_gen_out7(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch5_input.enum.memory_gen_out7'))

    @memory_gen_out7.setter
    def memory_gen_out7(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch5_input.enum.memory_gen_out7', int(new_val))

    @property
    def analyzer2_y(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch5_input.enum.analyzer2_y'))

    @analyzer2_y.setter
    def analyzer2_y(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch5_input.enum.analyzer2_y', int(new_val))

    @property
    def gen_test_dynamic(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch5_input.enum.gen_test_dynamic'))

    @gen_test_dynamic.setter
    def gen_test_dynamic(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch5_input.enum.gen_test_dynamic', int(new_val))

    @property
    def in_tip_current(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch5_input.enum.in_tip_current'))

    @in_tip_current.setter
    def in_tip_current(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch5_input.enum.in_tip_current', int(new_val))

    @property
    def analyzer1_x(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch5_input.enum.analyzer1_x'))

    @analyzer1_x.setter
    def analyzer1_x(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch5_input.enum.analyzer1_x', int(new_val))

    @property
    def ctrl_z_sum(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch5_input.enum.ctrl_z_sum'))

    @ctrl_z_sum.setter
    def ctrl_z_sum(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch5_input.enum.ctrl_z_sum', int(new_val))

    @property
    def analyzer2_reference(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch5_input.enum.analyzer2_reference'))

    @analyzer2_reference.setter
    def analyzer2_reference(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch5_input.enum.analyzer2_reference', int(new_val))

    @property
    def analyzer1_ctrl_delta_f(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch5_input.enum.analyzer1_ctrl_delta_f'))

    @analyzer1_ctrl_delta_f.setter
    def analyzer1_ctrl_delta_f(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch5_input.enum.analyzer1_ctrl_delta_f', int(new_val))

    @property
    def in_position_z(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch5_input.enum.in_position_z'))

    @in_position_z.setter
    def in_position_z(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch5_input.enum.in_position_z', int(new_val))

    @property
    def analyzer2_x(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch5_input.enum.analyzer2_x'))

    @analyzer2_x.setter
    def analyzer2_x(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch5_input.enum.analyzer2_x', int(new_val))

    @property
    def static(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch5_input.enum.static'))

    @static.setter
    def static(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch5_input.enum.static', int(new_val))

    @property
    def in_lateral(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch5_input.enum.in_lateral'))

    @in_lateral.setter
    def in_lateral(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch5_input.enum.in_lateral', int(new_val))

    @property
    def ramp_gen_tip_voltage(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch5_input.enum.ramp_gen_tip_voltage'))

    @ramp_gen_tip_voltage.setter
    def ramp_gen_tip_voltage(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch5_input.enum.ramp_gen_tip_voltage', int(new_val))

    @property
    def ramp_gen_position_y(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch5_input.enum.ramp_gen_position_y'))

    @ramp_gen_position_y.setter
    def ramp_gen_position_y(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch5_input.enum.ramp_gen_position_y', int(new_val))

    @property
    def ramp_gen_position_w(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch5_input.enum.ramp_gen_position_w'))

    @ramp_gen_position_w.setter
    def ramp_gen_position_w(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch5_input.enum.ramp_gen_position_w', int(new_val))

    @property
    def ramp_gen_ctrl_z(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch5_input.enum.ramp_gen_ctrl_z'))

    @ramp_gen_ctrl_z.setter
    def ramp_gen_ctrl_z(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch5_input.enum.ramp_gen_ctrl_z', int(new_val))

    @property
    def memory_gen_position_x(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch5_input.enum.memory_gen_position_x'))

    @memory_gen_position_x.setter
    def memory_gen_position_x(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch5_input.enum.memory_gen_position_x', int(new_val))

    @property
    def in_user3(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch5_input.enum.in_user3'))

    @in_user3.setter
    def in_user3(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch5_input.enum.in_user3', int(new_val))

    @property
    def in_position_y(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch5_input.enum.in_position_y'))

    @in_position_y.setter
    def in_position_y(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch5_input.enum.in_position_y', int(new_val))

    @property
    def in_user4(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch5_input.enum.in_user4'))

    @in_user4.setter
    def in_user4(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch5_input.enum.in_user4', int(new_val))

    @property
    def ramp_gen_max_z(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch5_input.enum.ramp_gen_max_z'))

    @ramp_gen_max_z.setter
    def ramp_gen_max_z(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch5_input.enum.ramp_gen_max_z', int(new_val))

    @property
    def ort_free_wave(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch5_input.enum.ort_free_wave'))

    @ort_free_wave.setter
    def ort_free_wave(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch5_input.enum.ort_free_wave', int(new_val))

    @property
    def ort_baseline_corrected(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch5_input.enum.ort_baseline_corrected'))

    @ort_baseline_corrected.setter
    def ort_baseline_corrected(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch5_input.enum.ort_baseline_corrected', int(new_val))

    @property
    def ort_baseline(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch5_input.enum.ort_baseline'))

    @ort_baseline.setter
    def ort_baseline(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch5_input.enum.ort_baseline', int(new_val))

    @property
    def fast_in2(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch5_input.enum.fast_in2'))

    @fast_in2.setter
    def fast_in2(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch5_input.enum.fast_in2', int(new_val))

    @property
    def ctrl_z_error(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch5_input.enum.ctrl_z_error'))

    @ctrl_z_error.setter
    def ctrl_z_error(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch5_input.enum.ctrl_z_error', int(new_val))

    @property
    def memory_gen_position_z(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch5_input.enum.memory_gen_position_z'))

    @memory_gen_position_z.setter
    def memory_gen_position_z(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch5_input.enum.memory_gen_position_z', int(new_val))

    @property
    def fast_in_user(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch5_input.enum.fast_in_user'))

    @fast_in_user.setter
    def fast_in_user(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch5_input.enum.fast_in_user', int(new_val))

    @property
    def memory_gen_position_y(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch5_input.enum.memory_gen_position_y'))

    @memory_gen_position_y.setter
    def memory_gen_position_y(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch5_input.enum.memory_gen_position_y', int(new_val))

    @property
    def analyzer2_amplitude(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch5_input.enum.analyzer2_amplitude'))

    @analyzer2_amplitude.setter
    def analyzer2_amplitude(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch5_input.enum.analyzer2_amplitude', int(new_val))

    @property
    def memory_gen_out8(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch5_input.enum.memory_gen_out8'))

    @memory_gen_out8.setter
    def memory_gen_out8(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch5_input.enum.memory_gen_out8', int(new_val))

    @property
    def memory_gen_drive_z(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch5_input.enum.memory_gen_drive_z'))

    @memory_gen_drive_z.setter
    def memory_gen_drive_z(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch5_input.enum.memory_gen_drive_z', int(new_val))

    @property
    def ramp_gen_user4(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch5_input.enum.ramp_gen_user4'))

    @ramp_gen_user4.setter
    def ramp_gen_user4(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch5_input.enum.ramp_gen_user4', int(new_val))

    @property
    def analyzer1_amplitude(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch5_input.enum.analyzer1_amplitude'))

    @analyzer1_amplitude.setter
    def analyzer1_amplitude(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch5_input.enum.analyzer1_amplitude', int(new_val))

    @property
    def in_detector_sum(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch5_input.enum.in_detector_sum'))

    @in_detector_sum.setter
    def in_detector_sum(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch5_input.enum.in_detector_sum', int(new_val))

    @property
    def ctrl_z_in(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch5_input.enum.ctrl_z_in'))

    @ctrl_z_in.setter
    def ctrl_z_in(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch5_input.enum.ctrl_z_in', int(new_val))

    @property
    def ctrl_user1_out(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch5_input.enum.ctrl_user1_out'))

    @ctrl_user1_out.setter
    def ctrl_user1_out(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch5_input.enum.ctrl_user1_out', int(new_val))


class RootLuData_acquisitionInstanceAttributeCapture_hi_res_ch5_input(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.data_acquisition.instance.attribute.capture_hi_res_ch5_input'
        self.enum = RootLuData_acquisitionInstanceAttributeCapture_hi_res_ch5_inputEnum(self._context)


class RootLuData_acquisitionInstanceAttributeCapture_hi_res_ch_input_vecEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.data_acquisition.instance.attribute.capture_hi_res_ch_input_vec.enum'

    @property
    def ort_adhesion_position(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch_input_vec.enum.ort_adhesion_position'))

    @ort_adhesion_position.setter
    def ort_adhesion_position(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch_input_vec.enum.ort_adhesion_position', int(new_val))

    @property
    def ctrl_z_pid_command(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch_input_vec.enum.ctrl_z_pid_command'))

    @ctrl_z_pid_command.setter
    def ctrl_z_pid_command(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch_input_vec.enum.ctrl_z_pid_command', int(new_val))

    @property
    def in6(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch_input_vec.enum.in6'))

    @in6.setter
    def in6(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch_input_vec.enum.in6', int(new_val))

    @property
    def ctrl_z_nominal(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch_input_vec.enum.ctrl_z_nominal'))

    @ctrl_z_nominal.setter
    def ctrl_z_nominal(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch_input_vec.enum.ctrl_z_nominal', int(new_val))

    @property
    def ctrl_x_out(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch_input_vec.enum.ctrl_x_out'))

    @ctrl_x_out.setter
    def ctrl_x_out(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch_input_vec.enum.ctrl_x_out', int(new_val))

    @property
    def memory_gen_drive_y(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch_input_vec.enum.memory_gen_drive_y'))

    @memory_gen_drive_y.setter
    def memory_gen_drive_y(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch_input_vec.enum.memory_gen_drive_y', int(new_val))

    @property
    def ctrl_user2_out(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch_input_vec.enum.ctrl_user2_out'))

    @ctrl_user2_out.setter
    def ctrl_user2_out(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch_input_vec.enum.ctrl_user2_out', int(new_val))

    @property
    def analyzer2_phase(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch_input_vec.enum.analyzer2_phase'))

    @analyzer2_phase.setter
    def analyzer2_phase(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch_input_vec.enum.analyzer2_phase', int(new_val))

    @property
    def fast_in_deflection(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch_input_vec.enum.fast_in_deflection'))

    @fast_in_deflection.setter
    def fast_in_deflection(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch_input_vec.enum.fast_in_deflection', int(new_val))

    @property
    def in_user2(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch_input_vec.enum.in_user2'))

    @in_user2.setter
    def in_user2(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch_input_vec.enum.in_user2', int(new_val))

    @property
    def ramp_gen_position_x(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch_input_vec.enum.ramp_gen_position_x'))

    @ramp_gen_position_x.setter
    def ramp_gen_position_x(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch_input_vec.enum.ramp_gen_position_x', int(new_val))

    @property
    def in_deflection(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch_input_vec.enum.in_deflection'))

    @in_deflection.setter
    def in_deflection(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch_input_vec.enum.in_deflection', int(new_val))

    @property
    def ort_amplitude_reduction(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch_input_vec.enum.ort_amplitude_reduction'))

    @ort_amplitude_reduction.setter
    def ort_amplitude_reduction(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch_input_vec.enum.ort_amplitude_reduction', int(new_val))

    @property
    def analyzer2_ctrl_amplitude(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch_input_vec.enum.analyzer2_ctrl_amplitude'))

    @analyzer2_ctrl_amplitude.setter
    def analyzer2_ctrl_amplitude(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch_input_vec.enum.analyzer2_ctrl_amplitude', int(new_val))

    @property
    def memory_gen_drive_x(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch_input_vec.enum.memory_gen_drive_x'))

    @memory_gen_drive_x.setter
    def memory_gen_drive_x(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch_input_vec.enum.memory_gen_drive_x', int(new_val))

    @property
    def ramp_gen_alternate_z(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch_input_vec.enum.ramp_gen_alternate_z'))

    @ramp_gen_alternate_z.setter
    def ramp_gen_alternate_z(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch_input_vec.enum.ramp_gen_alternate_z', int(new_val))

    @property
    def analyzer2_ctrl_delta_f(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch_input_vec.enum.analyzer2_ctrl_delta_f'))

    @analyzer2_ctrl_delta_f.setter
    def analyzer2_ctrl_delta_f(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch_input_vec.enum.analyzer2_ctrl_delta_f', int(new_val))

    @property
    def ort_excitation(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch_input_vec.enum.ort_excitation'))

    @ort_excitation.setter
    def ort_excitation(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch_input_vec.enum.ort_excitation', int(new_val))

    @property
    def analyzer1_y(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch_input_vec.enum.analyzer1_y'))

    @analyzer1_y.setter
    def analyzer1_y(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch_input_vec.enum.analyzer1_y', int(new_val))

    @property
    def ort_adhesion_value(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch_input_vec.enum.ort_adhesion_value'))

    @ort_adhesion_value.setter
    def ort_adhesion_value(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch_input_vec.enum.ort_adhesion_value', int(new_val))

    @property
    def ctrl_y_out(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch_input_vec.enum.ctrl_y_out'))

    @ctrl_y_out.setter
    def ctrl_y_out(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch_input_vec.enum.ctrl_y_out', int(new_val))

    @property
    def analyzer1_phase(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch_input_vec.enum.analyzer1_phase'))

    @analyzer1_phase.setter
    def analyzer1_phase(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch_input_vec.enum.analyzer1_phase', int(new_val))

    @property
    def ctrl_z_out(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch_input_vec.enum.ctrl_z_out'))

    @ctrl_z_out.setter
    def ctrl_z_out(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch_input_vec.enum.ctrl_z_out', int(new_val))

    @property
    def ctrl_w_out(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch_input_vec.enum.ctrl_w_out'))

    @ctrl_w_out.setter
    def ctrl_w_out(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch_input_vec.enum.ctrl_w_out', int(new_val))

    @property
    def analyzer1_ctrl_amplitude(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch_input_vec.enum.analyzer1_ctrl_amplitude'))

    @analyzer1_ctrl_amplitude.setter
    def analyzer1_ctrl_amplitude(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch_input_vec.enum.analyzer1_ctrl_amplitude', int(new_val))

    @property
    def in_user1(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch_input_vec.enum.in_user1'))

    @in_user1.setter
    def in_user1(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch_input_vec.enum.in_user1', int(new_val))

    @property
    def ramp_gen_approach(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch_input_vec.enum.ramp_gen_approach'))

    @ramp_gen_approach.setter
    def ramp_gen_approach(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch_input_vec.enum.ramp_gen_approach', int(new_val))

    @property
    def ramp_gen_test(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch_input_vec.enum.ramp_gen_test'))

    @ramp_gen_test.setter
    def ramp_gen_test(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch_input_vec.enum.ramp_gen_test', int(new_val))

    @property
    def in_position_x(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch_input_vec.enum.in_position_x'))

    @in_position_x.setter
    def in_position_x(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch_input_vec.enum.in_position_x', int(new_val))

    @property
    def analyzer1_reference(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch_input_vec.enum.analyzer1_reference'))

    @analyzer1_reference.setter
    def analyzer1_reference(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch_input_vec.enum.analyzer1_reference', int(new_val))

    @property
    def ramp_gen_plane_z(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch_input_vec.enum.ramp_gen_plane_z'))

    @ramp_gen_plane_z.setter
    def ramp_gen_plane_z(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch_input_vec.enum.ramp_gen_plane_z', int(new_val))

    @property
    def memory_gen_out7(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch_input_vec.enum.memory_gen_out7'))

    @memory_gen_out7.setter
    def memory_gen_out7(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch_input_vec.enum.memory_gen_out7', int(new_val))

    @property
    def analyzer2_y(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch_input_vec.enum.analyzer2_y'))

    @analyzer2_y.setter
    def analyzer2_y(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch_input_vec.enum.analyzer2_y', int(new_val))

    @property
    def gen_test_dynamic(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch_input_vec.enum.gen_test_dynamic'))

    @gen_test_dynamic.setter
    def gen_test_dynamic(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch_input_vec.enum.gen_test_dynamic', int(new_val))

    @property
    def in_tip_current(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch_input_vec.enum.in_tip_current'))

    @in_tip_current.setter
    def in_tip_current(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch_input_vec.enum.in_tip_current', int(new_val))

    @property
    def analyzer1_x(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch_input_vec.enum.analyzer1_x'))

    @analyzer1_x.setter
    def analyzer1_x(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch_input_vec.enum.analyzer1_x', int(new_val))

    @property
    def ctrl_z_sum(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch_input_vec.enum.ctrl_z_sum'))

    @ctrl_z_sum.setter
    def ctrl_z_sum(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch_input_vec.enum.ctrl_z_sum', int(new_val))

    @property
    def analyzer2_reference(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch_input_vec.enum.analyzer2_reference'))

    @analyzer2_reference.setter
    def analyzer2_reference(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch_input_vec.enum.analyzer2_reference', int(new_val))

    @property
    def analyzer1_ctrl_delta_f(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch_input_vec.enum.analyzer1_ctrl_delta_f'))

    @analyzer1_ctrl_delta_f.setter
    def analyzer1_ctrl_delta_f(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch_input_vec.enum.analyzer1_ctrl_delta_f', int(new_val))

    @property
    def in_position_z(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch_input_vec.enum.in_position_z'))

    @in_position_z.setter
    def in_position_z(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch_input_vec.enum.in_position_z', int(new_val))

    @property
    def analyzer2_x(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch_input_vec.enum.analyzer2_x'))

    @analyzer2_x.setter
    def analyzer2_x(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch_input_vec.enum.analyzer2_x', int(new_val))

    @property
    def static(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch_input_vec.enum.static'))

    @static.setter
    def static(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch_input_vec.enum.static', int(new_val))

    @property
    def in_lateral(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch_input_vec.enum.in_lateral'))

    @in_lateral.setter
    def in_lateral(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch_input_vec.enum.in_lateral', int(new_val))

    @property
    def ramp_gen_tip_voltage(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch_input_vec.enum.ramp_gen_tip_voltage'))

    @ramp_gen_tip_voltage.setter
    def ramp_gen_tip_voltage(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch_input_vec.enum.ramp_gen_tip_voltage', int(new_val))

    @property
    def ramp_gen_position_y(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch_input_vec.enum.ramp_gen_position_y'))

    @ramp_gen_position_y.setter
    def ramp_gen_position_y(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch_input_vec.enum.ramp_gen_position_y', int(new_val))

    @property
    def ramp_gen_position_w(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch_input_vec.enum.ramp_gen_position_w'))

    @ramp_gen_position_w.setter
    def ramp_gen_position_w(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch_input_vec.enum.ramp_gen_position_w', int(new_val))

    @property
    def ramp_gen_ctrl_z(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch_input_vec.enum.ramp_gen_ctrl_z'))

    @ramp_gen_ctrl_z.setter
    def ramp_gen_ctrl_z(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch_input_vec.enum.ramp_gen_ctrl_z', int(new_val))

    @property
    def memory_gen_position_x(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch_input_vec.enum.memory_gen_position_x'))

    @memory_gen_position_x.setter
    def memory_gen_position_x(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch_input_vec.enum.memory_gen_position_x', int(new_val))

    @property
    def in_user3(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch_input_vec.enum.in_user3'))

    @in_user3.setter
    def in_user3(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch_input_vec.enum.in_user3', int(new_val))

    @property
    def in_position_y(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch_input_vec.enum.in_position_y'))

    @in_position_y.setter
    def in_position_y(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch_input_vec.enum.in_position_y', int(new_val))

    @property
    def in_user4(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch_input_vec.enum.in_user4'))

    @in_user4.setter
    def in_user4(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch_input_vec.enum.in_user4', int(new_val))

    @property
    def ramp_gen_max_z(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch_input_vec.enum.ramp_gen_max_z'))

    @ramp_gen_max_z.setter
    def ramp_gen_max_z(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch_input_vec.enum.ramp_gen_max_z', int(new_val))

    @property
    def ort_free_wave(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch_input_vec.enum.ort_free_wave'))

    @ort_free_wave.setter
    def ort_free_wave(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch_input_vec.enum.ort_free_wave', int(new_val))

    @property
    def ort_baseline_corrected(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch_input_vec.enum.ort_baseline_corrected'))

    @ort_baseline_corrected.setter
    def ort_baseline_corrected(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch_input_vec.enum.ort_baseline_corrected', int(new_val))

    @property
    def ort_baseline(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch_input_vec.enum.ort_baseline'))

    @ort_baseline.setter
    def ort_baseline(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch_input_vec.enum.ort_baseline', int(new_val))

    @property
    def fast_in2(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch_input_vec.enum.fast_in2'))

    @fast_in2.setter
    def fast_in2(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch_input_vec.enum.fast_in2', int(new_val))

    @property
    def ctrl_z_error(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch_input_vec.enum.ctrl_z_error'))

    @ctrl_z_error.setter
    def ctrl_z_error(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch_input_vec.enum.ctrl_z_error', int(new_val))

    @property
    def memory_gen_position_z(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch_input_vec.enum.memory_gen_position_z'))

    @memory_gen_position_z.setter
    def memory_gen_position_z(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch_input_vec.enum.memory_gen_position_z', int(new_val))

    @property
    def fast_in_user(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch_input_vec.enum.fast_in_user'))

    @fast_in_user.setter
    def fast_in_user(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch_input_vec.enum.fast_in_user', int(new_val))

    @property
    def memory_gen_position_y(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch_input_vec.enum.memory_gen_position_y'))

    @memory_gen_position_y.setter
    def memory_gen_position_y(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch_input_vec.enum.memory_gen_position_y', int(new_val))

    @property
    def analyzer2_amplitude(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch_input_vec.enum.analyzer2_amplitude'))

    @analyzer2_amplitude.setter
    def analyzer2_amplitude(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch_input_vec.enum.analyzer2_amplitude', int(new_val))

    @property
    def memory_gen_out8(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch_input_vec.enum.memory_gen_out8'))

    @memory_gen_out8.setter
    def memory_gen_out8(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch_input_vec.enum.memory_gen_out8', int(new_val))

    @property
    def memory_gen_drive_z(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch_input_vec.enum.memory_gen_drive_z'))

    @memory_gen_drive_z.setter
    def memory_gen_drive_z(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch_input_vec.enum.memory_gen_drive_z', int(new_val))

    @property
    def ramp_gen_user4(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch_input_vec.enum.ramp_gen_user4'))

    @ramp_gen_user4.setter
    def ramp_gen_user4(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch_input_vec.enum.ramp_gen_user4', int(new_val))

    @property
    def analyzer1_amplitude(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch_input_vec.enum.analyzer1_amplitude'))

    @analyzer1_amplitude.setter
    def analyzer1_amplitude(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch_input_vec.enum.analyzer1_amplitude', int(new_val))

    @property
    def in_detector_sum(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch_input_vec.enum.in_detector_sum'))

    @in_detector_sum.setter
    def in_detector_sum(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch_input_vec.enum.in_detector_sum', int(new_val))

    @property
    def ctrl_z_in(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch_input_vec.enum.ctrl_z_in'))

    @ctrl_z_in.setter
    def ctrl_z_in(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch_input_vec.enum.ctrl_z_in', int(new_val))

    @property
    def ctrl_user1_out(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch_input_vec.enum.ctrl_user1_out'))

    @ctrl_user1_out.setter
    def ctrl_user1_out(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch_input_vec.enum.ctrl_user1_out', int(new_val))


class RootLuData_acquisitionInstanceAttributeCapture_hi_res_ch_input_vec(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.data_acquisition.instance.attribute.capture_hi_res_ch_input_vec'
        self.enum = RootLuData_acquisitionInstanceAttributeCapture_hi_res_ch_input_vecEnum(self._context)


class RootLuData_acquisitionInstanceAttributeSampler_hi_res_ch3_inputEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch3_input.enum'

    @property
    def ort_adhesion_position(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch3_input.enum.ort_adhesion_position'))

    @ort_adhesion_position.setter
    def ort_adhesion_position(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch3_input.enum.ort_adhesion_position', int(new_val))

    @property
    def ctrl_z_pid_command(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch3_input.enum.ctrl_z_pid_command'))

    @ctrl_z_pid_command.setter
    def ctrl_z_pid_command(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch3_input.enum.ctrl_z_pid_command', int(new_val))

    @property
    def in6(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch3_input.enum.in6'))

    @in6.setter
    def in6(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch3_input.enum.in6', int(new_val))

    @property
    def ctrl_z_nominal(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch3_input.enum.ctrl_z_nominal'))

    @ctrl_z_nominal.setter
    def ctrl_z_nominal(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch3_input.enum.ctrl_z_nominal', int(new_val))

    @property
    def ctrl_x_out(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch3_input.enum.ctrl_x_out'))

    @ctrl_x_out.setter
    def ctrl_x_out(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch3_input.enum.ctrl_x_out', int(new_val))

    @property
    def memory_gen_drive_y(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch3_input.enum.memory_gen_drive_y'))

    @memory_gen_drive_y.setter
    def memory_gen_drive_y(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch3_input.enum.memory_gen_drive_y', int(new_val))

    @property
    def ctrl_user2_out(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch3_input.enum.ctrl_user2_out'))

    @ctrl_user2_out.setter
    def ctrl_user2_out(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch3_input.enum.ctrl_user2_out', int(new_val))

    @property
    def analyzer2_phase(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch3_input.enum.analyzer2_phase'))

    @analyzer2_phase.setter
    def analyzer2_phase(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch3_input.enum.analyzer2_phase', int(new_val))

    @property
    def fast_in_deflection(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch3_input.enum.fast_in_deflection'))

    @fast_in_deflection.setter
    def fast_in_deflection(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch3_input.enum.fast_in_deflection', int(new_val))

    @property
    def in_user2(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch3_input.enum.in_user2'))

    @in_user2.setter
    def in_user2(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch3_input.enum.in_user2', int(new_val))

    @property
    def ramp_gen_position_x(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch3_input.enum.ramp_gen_position_x'))

    @ramp_gen_position_x.setter
    def ramp_gen_position_x(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch3_input.enum.ramp_gen_position_x', int(new_val))

    @property
    def in_deflection(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch3_input.enum.in_deflection'))

    @in_deflection.setter
    def in_deflection(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch3_input.enum.in_deflection', int(new_val))

    @property
    def ort_amplitude_reduction(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch3_input.enum.ort_amplitude_reduction'))

    @ort_amplitude_reduction.setter
    def ort_amplitude_reduction(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch3_input.enum.ort_amplitude_reduction', int(new_val))

    @property
    def analyzer2_ctrl_amplitude(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch3_input.enum.analyzer2_ctrl_amplitude'))

    @analyzer2_ctrl_amplitude.setter
    def analyzer2_ctrl_amplitude(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch3_input.enum.analyzer2_ctrl_amplitude', int(new_val))

    @property
    def memory_gen_drive_x(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch3_input.enum.memory_gen_drive_x'))

    @memory_gen_drive_x.setter
    def memory_gen_drive_x(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch3_input.enum.memory_gen_drive_x', int(new_val))

    @property
    def ramp_gen_alternate_z(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch3_input.enum.ramp_gen_alternate_z'))

    @ramp_gen_alternate_z.setter
    def ramp_gen_alternate_z(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch3_input.enum.ramp_gen_alternate_z', int(new_val))

    @property
    def analyzer2_ctrl_delta_f(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch3_input.enum.analyzer2_ctrl_delta_f'))

    @analyzer2_ctrl_delta_f.setter
    def analyzer2_ctrl_delta_f(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch3_input.enum.analyzer2_ctrl_delta_f', int(new_val))

    @property
    def ort_excitation(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch3_input.enum.ort_excitation'))

    @ort_excitation.setter
    def ort_excitation(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch3_input.enum.ort_excitation', int(new_val))

    @property
    def analyzer1_y(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch3_input.enum.analyzer1_y'))

    @analyzer1_y.setter
    def analyzer1_y(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch3_input.enum.analyzer1_y', int(new_val))

    @property
    def ort_adhesion_value(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch3_input.enum.ort_adhesion_value'))

    @ort_adhesion_value.setter
    def ort_adhesion_value(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch3_input.enum.ort_adhesion_value', int(new_val))

    @property
    def ctrl_y_out(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch3_input.enum.ctrl_y_out'))

    @ctrl_y_out.setter
    def ctrl_y_out(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch3_input.enum.ctrl_y_out', int(new_val))

    @property
    def analyzer1_phase(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch3_input.enum.analyzer1_phase'))

    @analyzer1_phase.setter
    def analyzer1_phase(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch3_input.enum.analyzer1_phase', int(new_val))

    @property
    def ctrl_z_out(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch3_input.enum.ctrl_z_out'))

    @ctrl_z_out.setter
    def ctrl_z_out(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch3_input.enum.ctrl_z_out', int(new_val))

    @property
    def ctrl_w_out(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch3_input.enum.ctrl_w_out'))

    @ctrl_w_out.setter
    def ctrl_w_out(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch3_input.enum.ctrl_w_out', int(new_val))

    @property
    def analyzer1_ctrl_amplitude(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch3_input.enum.analyzer1_ctrl_amplitude'))

    @analyzer1_ctrl_amplitude.setter
    def analyzer1_ctrl_amplitude(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch3_input.enum.analyzer1_ctrl_amplitude', int(new_val))

    @property
    def in_user1(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch3_input.enum.in_user1'))

    @in_user1.setter
    def in_user1(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch3_input.enum.in_user1', int(new_val))

    @property
    def ramp_gen_approach(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch3_input.enum.ramp_gen_approach'))

    @ramp_gen_approach.setter
    def ramp_gen_approach(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch3_input.enum.ramp_gen_approach', int(new_val))

    @property
    def ramp_gen_test(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch3_input.enum.ramp_gen_test'))

    @ramp_gen_test.setter
    def ramp_gen_test(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch3_input.enum.ramp_gen_test', int(new_val))

    @property
    def in_position_x(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch3_input.enum.in_position_x'))

    @in_position_x.setter
    def in_position_x(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch3_input.enum.in_position_x', int(new_val))

    @property
    def analyzer1_reference(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch3_input.enum.analyzer1_reference'))

    @analyzer1_reference.setter
    def analyzer1_reference(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch3_input.enum.analyzer1_reference', int(new_val))

    @property
    def ramp_gen_plane_z(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch3_input.enum.ramp_gen_plane_z'))

    @ramp_gen_plane_z.setter
    def ramp_gen_plane_z(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch3_input.enum.ramp_gen_plane_z', int(new_val))

    @property
    def memory_gen_out7(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch3_input.enum.memory_gen_out7'))

    @memory_gen_out7.setter
    def memory_gen_out7(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch3_input.enum.memory_gen_out7', int(new_val))

    @property
    def analyzer2_y(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch3_input.enum.analyzer2_y'))

    @analyzer2_y.setter
    def analyzer2_y(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch3_input.enum.analyzer2_y', int(new_val))

    @property
    def gen_test_dynamic(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch3_input.enum.gen_test_dynamic'))

    @gen_test_dynamic.setter
    def gen_test_dynamic(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch3_input.enum.gen_test_dynamic', int(new_val))

    @property
    def in_tip_current(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch3_input.enum.in_tip_current'))

    @in_tip_current.setter
    def in_tip_current(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch3_input.enum.in_tip_current', int(new_val))

    @property
    def analyzer1_x(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch3_input.enum.analyzer1_x'))

    @analyzer1_x.setter
    def analyzer1_x(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch3_input.enum.analyzer1_x', int(new_val))

    @property
    def ctrl_z_sum(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch3_input.enum.ctrl_z_sum'))

    @ctrl_z_sum.setter
    def ctrl_z_sum(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch3_input.enum.ctrl_z_sum', int(new_val))

    @property
    def analyzer2_reference(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch3_input.enum.analyzer2_reference'))

    @analyzer2_reference.setter
    def analyzer2_reference(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch3_input.enum.analyzer2_reference', int(new_val))

    @property
    def analyzer1_ctrl_delta_f(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch3_input.enum.analyzer1_ctrl_delta_f'))

    @analyzer1_ctrl_delta_f.setter
    def analyzer1_ctrl_delta_f(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch3_input.enum.analyzer1_ctrl_delta_f', int(new_val))

    @property
    def in_position_z(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch3_input.enum.in_position_z'))

    @in_position_z.setter
    def in_position_z(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch3_input.enum.in_position_z', int(new_val))

    @property
    def analyzer2_x(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch3_input.enum.analyzer2_x'))

    @analyzer2_x.setter
    def analyzer2_x(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch3_input.enum.analyzer2_x', int(new_val))

    @property
    def static(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch3_input.enum.static'))

    @static.setter
    def static(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch3_input.enum.static', int(new_val))

    @property
    def in_lateral(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch3_input.enum.in_lateral'))

    @in_lateral.setter
    def in_lateral(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch3_input.enum.in_lateral', int(new_val))

    @property
    def ramp_gen_tip_voltage(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch3_input.enum.ramp_gen_tip_voltage'))

    @ramp_gen_tip_voltage.setter
    def ramp_gen_tip_voltage(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch3_input.enum.ramp_gen_tip_voltage', int(new_val))

    @property
    def ramp_gen_position_y(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch3_input.enum.ramp_gen_position_y'))

    @ramp_gen_position_y.setter
    def ramp_gen_position_y(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch3_input.enum.ramp_gen_position_y', int(new_val))

    @property
    def ramp_gen_position_w(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch3_input.enum.ramp_gen_position_w'))

    @ramp_gen_position_w.setter
    def ramp_gen_position_w(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch3_input.enum.ramp_gen_position_w', int(new_val))

    @property
    def ramp_gen_ctrl_z(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch3_input.enum.ramp_gen_ctrl_z'))

    @ramp_gen_ctrl_z.setter
    def ramp_gen_ctrl_z(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch3_input.enum.ramp_gen_ctrl_z', int(new_val))

    @property
    def memory_gen_position_x(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch3_input.enum.memory_gen_position_x'))

    @memory_gen_position_x.setter
    def memory_gen_position_x(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch3_input.enum.memory_gen_position_x', int(new_val))

    @property
    def in_user3(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch3_input.enum.in_user3'))

    @in_user3.setter
    def in_user3(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch3_input.enum.in_user3', int(new_val))

    @property
    def in_position_y(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch3_input.enum.in_position_y'))

    @in_position_y.setter
    def in_position_y(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch3_input.enum.in_position_y', int(new_val))

    @property
    def in_user4(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch3_input.enum.in_user4'))

    @in_user4.setter
    def in_user4(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch3_input.enum.in_user4', int(new_val))

    @property
    def ramp_gen_max_z(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch3_input.enum.ramp_gen_max_z'))

    @ramp_gen_max_z.setter
    def ramp_gen_max_z(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch3_input.enum.ramp_gen_max_z', int(new_val))

    @property
    def ort_free_wave(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch3_input.enum.ort_free_wave'))

    @ort_free_wave.setter
    def ort_free_wave(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch3_input.enum.ort_free_wave', int(new_val))

    @property
    def ort_baseline_corrected(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch3_input.enum.ort_baseline_corrected'))

    @ort_baseline_corrected.setter
    def ort_baseline_corrected(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch3_input.enum.ort_baseline_corrected', int(new_val))

    @property
    def ort_baseline(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch3_input.enum.ort_baseline'))

    @ort_baseline.setter
    def ort_baseline(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch3_input.enum.ort_baseline', int(new_val))

    @property
    def fast_in2(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch3_input.enum.fast_in2'))

    @fast_in2.setter
    def fast_in2(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch3_input.enum.fast_in2', int(new_val))

    @property
    def ctrl_z_error(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch3_input.enum.ctrl_z_error'))

    @ctrl_z_error.setter
    def ctrl_z_error(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch3_input.enum.ctrl_z_error', int(new_val))

    @property
    def memory_gen_position_z(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch3_input.enum.memory_gen_position_z'))

    @memory_gen_position_z.setter
    def memory_gen_position_z(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch3_input.enum.memory_gen_position_z', int(new_val))

    @property
    def fast_in_user(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch3_input.enum.fast_in_user'))

    @fast_in_user.setter
    def fast_in_user(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch3_input.enum.fast_in_user', int(new_val))

    @property
    def memory_gen_position_y(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch3_input.enum.memory_gen_position_y'))

    @memory_gen_position_y.setter
    def memory_gen_position_y(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch3_input.enum.memory_gen_position_y', int(new_val))

    @property
    def analyzer2_amplitude(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch3_input.enum.analyzer2_amplitude'))

    @analyzer2_amplitude.setter
    def analyzer2_amplitude(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch3_input.enum.analyzer2_amplitude', int(new_val))

    @property
    def memory_gen_out8(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch3_input.enum.memory_gen_out8'))

    @memory_gen_out8.setter
    def memory_gen_out8(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch3_input.enum.memory_gen_out8', int(new_val))

    @property
    def memory_gen_drive_z(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch3_input.enum.memory_gen_drive_z'))

    @memory_gen_drive_z.setter
    def memory_gen_drive_z(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch3_input.enum.memory_gen_drive_z', int(new_val))

    @property
    def ramp_gen_user4(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch3_input.enum.ramp_gen_user4'))

    @ramp_gen_user4.setter
    def ramp_gen_user4(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch3_input.enum.ramp_gen_user4', int(new_val))

    @property
    def analyzer1_amplitude(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch3_input.enum.analyzer1_amplitude'))

    @analyzer1_amplitude.setter
    def analyzer1_amplitude(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch3_input.enum.analyzer1_amplitude', int(new_val))

    @property
    def in_detector_sum(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch3_input.enum.in_detector_sum'))

    @in_detector_sum.setter
    def in_detector_sum(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch3_input.enum.in_detector_sum', int(new_val))

    @property
    def ctrl_z_in(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch3_input.enum.ctrl_z_in'))

    @ctrl_z_in.setter
    def ctrl_z_in(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch3_input.enum.ctrl_z_in', int(new_val))

    @property
    def ctrl_user1_out(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch3_input.enum.ctrl_user1_out'))

    @ctrl_user1_out.setter
    def ctrl_user1_out(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch3_input.enum.ctrl_user1_out', int(new_val))


class RootLuData_acquisitionInstanceAttributeSampler_hi_res_ch3_input(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch3_input'
        self.enum = RootLuData_acquisitionInstanceAttributeSampler_hi_res_ch3_inputEnum(self._context)


class RootLuData_acquisitionInstanceAttributeSampler_hi_res_ch7_inputEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch7_input.enum'

    @property
    def ort_adhesion_position(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch7_input.enum.ort_adhesion_position'))

    @ort_adhesion_position.setter
    def ort_adhesion_position(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch7_input.enum.ort_adhesion_position', int(new_val))

    @property
    def ctrl_z_pid_command(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch7_input.enum.ctrl_z_pid_command'))

    @ctrl_z_pid_command.setter
    def ctrl_z_pid_command(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch7_input.enum.ctrl_z_pid_command', int(new_val))

    @property
    def in6(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch7_input.enum.in6'))

    @in6.setter
    def in6(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch7_input.enum.in6', int(new_val))

    @property
    def ctrl_z_nominal(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch7_input.enum.ctrl_z_nominal'))

    @ctrl_z_nominal.setter
    def ctrl_z_nominal(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch7_input.enum.ctrl_z_nominal', int(new_val))

    @property
    def ctrl_x_out(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch7_input.enum.ctrl_x_out'))

    @ctrl_x_out.setter
    def ctrl_x_out(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch7_input.enum.ctrl_x_out', int(new_val))

    @property
    def memory_gen_drive_y(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch7_input.enum.memory_gen_drive_y'))

    @memory_gen_drive_y.setter
    def memory_gen_drive_y(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch7_input.enum.memory_gen_drive_y', int(new_val))

    @property
    def ctrl_user2_out(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch7_input.enum.ctrl_user2_out'))

    @ctrl_user2_out.setter
    def ctrl_user2_out(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch7_input.enum.ctrl_user2_out', int(new_val))

    @property
    def analyzer2_phase(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch7_input.enum.analyzer2_phase'))

    @analyzer2_phase.setter
    def analyzer2_phase(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch7_input.enum.analyzer2_phase', int(new_val))

    @property
    def fast_in_deflection(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch7_input.enum.fast_in_deflection'))

    @fast_in_deflection.setter
    def fast_in_deflection(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch7_input.enum.fast_in_deflection', int(new_val))

    @property
    def in_user2(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch7_input.enum.in_user2'))

    @in_user2.setter
    def in_user2(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch7_input.enum.in_user2', int(new_val))

    @property
    def ramp_gen_position_x(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch7_input.enum.ramp_gen_position_x'))

    @ramp_gen_position_x.setter
    def ramp_gen_position_x(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch7_input.enum.ramp_gen_position_x', int(new_val))

    @property
    def in_deflection(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch7_input.enum.in_deflection'))

    @in_deflection.setter
    def in_deflection(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch7_input.enum.in_deflection', int(new_val))

    @property
    def ort_amplitude_reduction(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch7_input.enum.ort_amplitude_reduction'))

    @ort_amplitude_reduction.setter
    def ort_amplitude_reduction(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch7_input.enum.ort_amplitude_reduction', int(new_val))

    @property
    def analyzer2_ctrl_amplitude(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch7_input.enum.analyzer2_ctrl_amplitude'))

    @analyzer2_ctrl_amplitude.setter
    def analyzer2_ctrl_amplitude(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch7_input.enum.analyzer2_ctrl_amplitude', int(new_val))

    @property
    def memory_gen_drive_x(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch7_input.enum.memory_gen_drive_x'))

    @memory_gen_drive_x.setter
    def memory_gen_drive_x(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch7_input.enum.memory_gen_drive_x', int(new_val))

    @property
    def ramp_gen_alternate_z(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch7_input.enum.ramp_gen_alternate_z'))

    @ramp_gen_alternate_z.setter
    def ramp_gen_alternate_z(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch7_input.enum.ramp_gen_alternate_z', int(new_val))

    @property
    def analyzer2_ctrl_delta_f(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch7_input.enum.analyzer2_ctrl_delta_f'))

    @analyzer2_ctrl_delta_f.setter
    def analyzer2_ctrl_delta_f(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch7_input.enum.analyzer2_ctrl_delta_f', int(new_val))

    @property
    def ort_excitation(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch7_input.enum.ort_excitation'))

    @ort_excitation.setter
    def ort_excitation(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch7_input.enum.ort_excitation', int(new_val))

    @property
    def analyzer1_y(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch7_input.enum.analyzer1_y'))

    @analyzer1_y.setter
    def analyzer1_y(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch7_input.enum.analyzer1_y', int(new_val))

    @property
    def ort_adhesion_value(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch7_input.enum.ort_adhesion_value'))

    @ort_adhesion_value.setter
    def ort_adhesion_value(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch7_input.enum.ort_adhesion_value', int(new_val))

    @property
    def ctrl_y_out(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch7_input.enum.ctrl_y_out'))

    @ctrl_y_out.setter
    def ctrl_y_out(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch7_input.enum.ctrl_y_out', int(new_val))

    @property
    def analyzer1_phase(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch7_input.enum.analyzer1_phase'))

    @analyzer1_phase.setter
    def analyzer1_phase(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch7_input.enum.analyzer1_phase', int(new_val))

    @property
    def ctrl_z_out(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch7_input.enum.ctrl_z_out'))

    @ctrl_z_out.setter
    def ctrl_z_out(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch7_input.enum.ctrl_z_out', int(new_val))

    @property
    def ctrl_w_out(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch7_input.enum.ctrl_w_out'))

    @ctrl_w_out.setter
    def ctrl_w_out(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch7_input.enum.ctrl_w_out', int(new_val))

    @property
    def analyzer1_ctrl_amplitude(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch7_input.enum.analyzer1_ctrl_amplitude'))

    @analyzer1_ctrl_amplitude.setter
    def analyzer1_ctrl_amplitude(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch7_input.enum.analyzer1_ctrl_amplitude', int(new_val))

    @property
    def in_user1(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch7_input.enum.in_user1'))

    @in_user1.setter
    def in_user1(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch7_input.enum.in_user1', int(new_val))

    @property
    def ramp_gen_approach(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch7_input.enum.ramp_gen_approach'))

    @ramp_gen_approach.setter
    def ramp_gen_approach(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch7_input.enum.ramp_gen_approach', int(new_val))

    @property
    def ramp_gen_test(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch7_input.enum.ramp_gen_test'))

    @ramp_gen_test.setter
    def ramp_gen_test(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch7_input.enum.ramp_gen_test', int(new_val))

    @property
    def in_position_x(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch7_input.enum.in_position_x'))

    @in_position_x.setter
    def in_position_x(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch7_input.enum.in_position_x', int(new_val))

    @property
    def analyzer1_reference(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch7_input.enum.analyzer1_reference'))

    @analyzer1_reference.setter
    def analyzer1_reference(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch7_input.enum.analyzer1_reference', int(new_val))

    @property
    def ramp_gen_plane_z(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch7_input.enum.ramp_gen_plane_z'))

    @ramp_gen_plane_z.setter
    def ramp_gen_plane_z(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch7_input.enum.ramp_gen_plane_z', int(new_val))

    @property
    def memory_gen_out7(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch7_input.enum.memory_gen_out7'))

    @memory_gen_out7.setter
    def memory_gen_out7(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch7_input.enum.memory_gen_out7', int(new_val))

    @property
    def analyzer2_y(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch7_input.enum.analyzer2_y'))

    @analyzer2_y.setter
    def analyzer2_y(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch7_input.enum.analyzer2_y', int(new_val))

    @property
    def gen_test_dynamic(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch7_input.enum.gen_test_dynamic'))

    @gen_test_dynamic.setter
    def gen_test_dynamic(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch7_input.enum.gen_test_dynamic', int(new_val))

    @property
    def in_tip_current(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch7_input.enum.in_tip_current'))

    @in_tip_current.setter
    def in_tip_current(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch7_input.enum.in_tip_current', int(new_val))

    @property
    def analyzer1_x(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch7_input.enum.analyzer1_x'))

    @analyzer1_x.setter
    def analyzer1_x(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch7_input.enum.analyzer1_x', int(new_val))

    @property
    def ctrl_z_sum(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch7_input.enum.ctrl_z_sum'))

    @ctrl_z_sum.setter
    def ctrl_z_sum(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch7_input.enum.ctrl_z_sum', int(new_val))

    @property
    def analyzer2_reference(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch7_input.enum.analyzer2_reference'))

    @analyzer2_reference.setter
    def analyzer2_reference(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch7_input.enum.analyzer2_reference', int(new_val))

    @property
    def analyzer1_ctrl_delta_f(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch7_input.enum.analyzer1_ctrl_delta_f'))

    @analyzer1_ctrl_delta_f.setter
    def analyzer1_ctrl_delta_f(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch7_input.enum.analyzer1_ctrl_delta_f', int(new_val))

    @property
    def in_position_z(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch7_input.enum.in_position_z'))

    @in_position_z.setter
    def in_position_z(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch7_input.enum.in_position_z', int(new_val))

    @property
    def analyzer2_x(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch7_input.enum.analyzer2_x'))

    @analyzer2_x.setter
    def analyzer2_x(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch7_input.enum.analyzer2_x', int(new_val))

    @property
    def static(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch7_input.enum.static'))

    @static.setter
    def static(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch7_input.enum.static', int(new_val))

    @property
    def in_lateral(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch7_input.enum.in_lateral'))

    @in_lateral.setter
    def in_lateral(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch7_input.enum.in_lateral', int(new_val))

    @property
    def ramp_gen_tip_voltage(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch7_input.enum.ramp_gen_tip_voltage'))

    @ramp_gen_tip_voltage.setter
    def ramp_gen_tip_voltage(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch7_input.enum.ramp_gen_tip_voltage', int(new_val))

    @property
    def ramp_gen_position_y(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch7_input.enum.ramp_gen_position_y'))

    @ramp_gen_position_y.setter
    def ramp_gen_position_y(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch7_input.enum.ramp_gen_position_y', int(new_val))

    @property
    def ramp_gen_position_w(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch7_input.enum.ramp_gen_position_w'))

    @ramp_gen_position_w.setter
    def ramp_gen_position_w(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch7_input.enum.ramp_gen_position_w', int(new_val))

    @property
    def ramp_gen_ctrl_z(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch7_input.enum.ramp_gen_ctrl_z'))

    @ramp_gen_ctrl_z.setter
    def ramp_gen_ctrl_z(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch7_input.enum.ramp_gen_ctrl_z', int(new_val))

    @property
    def memory_gen_position_x(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch7_input.enum.memory_gen_position_x'))

    @memory_gen_position_x.setter
    def memory_gen_position_x(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch7_input.enum.memory_gen_position_x', int(new_val))

    @property
    def in_user3(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch7_input.enum.in_user3'))

    @in_user3.setter
    def in_user3(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch7_input.enum.in_user3', int(new_val))

    @property
    def in_position_y(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch7_input.enum.in_position_y'))

    @in_position_y.setter
    def in_position_y(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch7_input.enum.in_position_y', int(new_val))

    @property
    def in_user4(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch7_input.enum.in_user4'))

    @in_user4.setter
    def in_user4(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch7_input.enum.in_user4', int(new_val))

    @property
    def ramp_gen_max_z(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch7_input.enum.ramp_gen_max_z'))

    @ramp_gen_max_z.setter
    def ramp_gen_max_z(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch7_input.enum.ramp_gen_max_z', int(new_val))

    @property
    def ort_free_wave(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch7_input.enum.ort_free_wave'))

    @ort_free_wave.setter
    def ort_free_wave(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch7_input.enum.ort_free_wave', int(new_val))

    @property
    def ort_baseline_corrected(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch7_input.enum.ort_baseline_corrected'))

    @ort_baseline_corrected.setter
    def ort_baseline_corrected(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch7_input.enum.ort_baseline_corrected', int(new_val))

    @property
    def ort_baseline(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch7_input.enum.ort_baseline'))

    @ort_baseline.setter
    def ort_baseline(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch7_input.enum.ort_baseline', int(new_val))

    @property
    def fast_in2(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch7_input.enum.fast_in2'))

    @fast_in2.setter
    def fast_in2(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch7_input.enum.fast_in2', int(new_val))

    @property
    def ctrl_z_error(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch7_input.enum.ctrl_z_error'))

    @ctrl_z_error.setter
    def ctrl_z_error(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch7_input.enum.ctrl_z_error', int(new_val))

    @property
    def memory_gen_position_z(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch7_input.enum.memory_gen_position_z'))

    @memory_gen_position_z.setter
    def memory_gen_position_z(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch7_input.enum.memory_gen_position_z', int(new_val))

    @property
    def fast_in_user(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch7_input.enum.fast_in_user'))

    @fast_in_user.setter
    def fast_in_user(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch7_input.enum.fast_in_user', int(new_val))

    @property
    def memory_gen_position_y(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch7_input.enum.memory_gen_position_y'))

    @memory_gen_position_y.setter
    def memory_gen_position_y(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch7_input.enum.memory_gen_position_y', int(new_val))

    @property
    def analyzer2_amplitude(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch7_input.enum.analyzer2_amplitude'))

    @analyzer2_amplitude.setter
    def analyzer2_amplitude(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch7_input.enum.analyzer2_amplitude', int(new_val))

    @property
    def memory_gen_out8(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch7_input.enum.memory_gen_out8'))

    @memory_gen_out8.setter
    def memory_gen_out8(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch7_input.enum.memory_gen_out8', int(new_val))

    @property
    def memory_gen_drive_z(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch7_input.enum.memory_gen_drive_z'))

    @memory_gen_drive_z.setter
    def memory_gen_drive_z(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch7_input.enum.memory_gen_drive_z', int(new_val))

    @property
    def ramp_gen_user4(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch7_input.enum.ramp_gen_user4'))

    @ramp_gen_user4.setter
    def ramp_gen_user4(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch7_input.enum.ramp_gen_user4', int(new_val))

    @property
    def analyzer1_amplitude(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch7_input.enum.analyzer1_amplitude'))

    @analyzer1_amplitude.setter
    def analyzer1_amplitude(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch7_input.enum.analyzer1_amplitude', int(new_val))

    @property
    def in_detector_sum(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch7_input.enum.in_detector_sum'))

    @in_detector_sum.setter
    def in_detector_sum(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch7_input.enum.in_detector_sum', int(new_val))

    @property
    def ctrl_z_in(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch7_input.enum.ctrl_z_in'))

    @ctrl_z_in.setter
    def ctrl_z_in(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch7_input.enum.ctrl_z_in', int(new_val))

    @property
    def ctrl_user1_out(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch7_input.enum.ctrl_user1_out'))

    @ctrl_user1_out.setter
    def ctrl_user1_out(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch7_input.enum.ctrl_user1_out', int(new_val))


class RootLuData_acquisitionInstanceAttributeSampler_hi_res_ch7_input(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch7_input'
        self.enum = RootLuData_acquisitionInstanceAttributeSampler_hi_res_ch7_inputEnum(self._context)


class RootLuData_acquisitionInstanceAttributeActive_sampler_set(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.data_acquisition.instance.attribute.active_sampler_set'


class RootLuData_acquisitionInstanceAttributeSampler_hi_res_ch1_inputEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch1_input.enum'

    @property
    def ort_adhesion_position(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch1_input.enum.ort_adhesion_position'))

    @ort_adhesion_position.setter
    def ort_adhesion_position(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch1_input.enum.ort_adhesion_position', int(new_val))

    @property
    def ctrl_z_pid_command(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch1_input.enum.ctrl_z_pid_command'))

    @ctrl_z_pid_command.setter
    def ctrl_z_pid_command(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch1_input.enum.ctrl_z_pid_command', int(new_val))

    @property
    def in6(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch1_input.enum.in6'))

    @in6.setter
    def in6(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch1_input.enum.in6', int(new_val))

    @property
    def ctrl_z_nominal(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch1_input.enum.ctrl_z_nominal'))

    @ctrl_z_nominal.setter
    def ctrl_z_nominal(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch1_input.enum.ctrl_z_nominal', int(new_val))

    @property
    def ctrl_x_out(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch1_input.enum.ctrl_x_out'))

    @ctrl_x_out.setter
    def ctrl_x_out(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch1_input.enum.ctrl_x_out', int(new_val))

    @property
    def memory_gen_drive_y(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch1_input.enum.memory_gen_drive_y'))

    @memory_gen_drive_y.setter
    def memory_gen_drive_y(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch1_input.enum.memory_gen_drive_y', int(new_val))

    @property
    def ctrl_user2_out(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch1_input.enum.ctrl_user2_out'))

    @ctrl_user2_out.setter
    def ctrl_user2_out(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch1_input.enum.ctrl_user2_out', int(new_val))

    @property
    def analyzer2_phase(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch1_input.enum.analyzer2_phase'))

    @analyzer2_phase.setter
    def analyzer2_phase(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch1_input.enum.analyzer2_phase', int(new_val))

    @property
    def fast_in_deflection(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch1_input.enum.fast_in_deflection'))

    @fast_in_deflection.setter
    def fast_in_deflection(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch1_input.enum.fast_in_deflection', int(new_val))

    @property
    def in_user2(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch1_input.enum.in_user2'))

    @in_user2.setter
    def in_user2(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch1_input.enum.in_user2', int(new_val))

    @property
    def ramp_gen_position_x(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch1_input.enum.ramp_gen_position_x'))

    @ramp_gen_position_x.setter
    def ramp_gen_position_x(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch1_input.enum.ramp_gen_position_x', int(new_val))

    @property
    def in_deflection(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch1_input.enum.in_deflection'))

    @in_deflection.setter
    def in_deflection(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch1_input.enum.in_deflection', int(new_val))

    @property
    def ort_amplitude_reduction(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch1_input.enum.ort_amplitude_reduction'))

    @ort_amplitude_reduction.setter
    def ort_amplitude_reduction(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch1_input.enum.ort_amplitude_reduction', int(new_val))

    @property
    def analyzer2_ctrl_amplitude(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch1_input.enum.analyzer2_ctrl_amplitude'))

    @analyzer2_ctrl_amplitude.setter
    def analyzer2_ctrl_amplitude(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch1_input.enum.analyzer2_ctrl_amplitude', int(new_val))

    @property
    def memory_gen_drive_x(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch1_input.enum.memory_gen_drive_x'))

    @memory_gen_drive_x.setter
    def memory_gen_drive_x(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch1_input.enum.memory_gen_drive_x', int(new_val))

    @property
    def ramp_gen_alternate_z(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch1_input.enum.ramp_gen_alternate_z'))

    @ramp_gen_alternate_z.setter
    def ramp_gen_alternate_z(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch1_input.enum.ramp_gen_alternate_z', int(new_val))

    @property
    def analyzer2_ctrl_delta_f(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch1_input.enum.analyzer2_ctrl_delta_f'))

    @analyzer2_ctrl_delta_f.setter
    def analyzer2_ctrl_delta_f(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch1_input.enum.analyzer2_ctrl_delta_f', int(new_val))

    @property
    def ort_excitation(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch1_input.enum.ort_excitation'))

    @ort_excitation.setter
    def ort_excitation(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch1_input.enum.ort_excitation', int(new_val))

    @property
    def analyzer1_y(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch1_input.enum.analyzer1_y'))

    @analyzer1_y.setter
    def analyzer1_y(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch1_input.enum.analyzer1_y', int(new_val))

    @property
    def ort_adhesion_value(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch1_input.enum.ort_adhesion_value'))

    @ort_adhesion_value.setter
    def ort_adhesion_value(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch1_input.enum.ort_adhesion_value', int(new_val))

    @property
    def ctrl_y_out(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch1_input.enum.ctrl_y_out'))

    @ctrl_y_out.setter
    def ctrl_y_out(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch1_input.enum.ctrl_y_out', int(new_val))

    @property
    def analyzer1_phase(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch1_input.enum.analyzer1_phase'))

    @analyzer1_phase.setter
    def analyzer1_phase(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch1_input.enum.analyzer1_phase', int(new_val))

    @property
    def ctrl_z_out(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch1_input.enum.ctrl_z_out'))

    @ctrl_z_out.setter
    def ctrl_z_out(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch1_input.enum.ctrl_z_out', int(new_val))

    @property
    def ctrl_w_out(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch1_input.enum.ctrl_w_out'))

    @ctrl_w_out.setter
    def ctrl_w_out(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch1_input.enum.ctrl_w_out', int(new_val))

    @property
    def analyzer1_ctrl_amplitude(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch1_input.enum.analyzer1_ctrl_amplitude'))

    @analyzer1_ctrl_amplitude.setter
    def analyzer1_ctrl_amplitude(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch1_input.enum.analyzer1_ctrl_amplitude', int(new_val))

    @property
    def in_user1(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch1_input.enum.in_user1'))

    @in_user1.setter
    def in_user1(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch1_input.enum.in_user1', int(new_val))

    @property
    def ramp_gen_approach(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch1_input.enum.ramp_gen_approach'))

    @ramp_gen_approach.setter
    def ramp_gen_approach(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch1_input.enum.ramp_gen_approach', int(new_val))

    @property
    def ramp_gen_test(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch1_input.enum.ramp_gen_test'))

    @ramp_gen_test.setter
    def ramp_gen_test(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch1_input.enum.ramp_gen_test', int(new_val))

    @property
    def in_position_x(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch1_input.enum.in_position_x'))

    @in_position_x.setter
    def in_position_x(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch1_input.enum.in_position_x', int(new_val))

    @property
    def analyzer1_reference(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch1_input.enum.analyzer1_reference'))

    @analyzer1_reference.setter
    def analyzer1_reference(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch1_input.enum.analyzer1_reference', int(new_val))

    @property
    def ramp_gen_plane_z(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch1_input.enum.ramp_gen_plane_z'))

    @ramp_gen_plane_z.setter
    def ramp_gen_plane_z(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch1_input.enum.ramp_gen_plane_z', int(new_val))

    @property
    def memory_gen_out7(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch1_input.enum.memory_gen_out7'))

    @memory_gen_out7.setter
    def memory_gen_out7(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch1_input.enum.memory_gen_out7', int(new_val))

    @property
    def analyzer2_y(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch1_input.enum.analyzer2_y'))

    @analyzer2_y.setter
    def analyzer2_y(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch1_input.enum.analyzer2_y', int(new_val))

    @property
    def gen_test_dynamic(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch1_input.enum.gen_test_dynamic'))

    @gen_test_dynamic.setter
    def gen_test_dynamic(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch1_input.enum.gen_test_dynamic', int(new_val))

    @property
    def in_tip_current(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch1_input.enum.in_tip_current'))

    @in_tip_current.setter
    def in_tip_current(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch1_input.enum.in_tip_current', int(new_val))

    @property
    def analyzer1_x(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch1_input.enum.analyzer1_x'))

    @analyzer1_x.setter
    def analyzer1_x(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch1_input.enum.analyzer1_x', int(new_val))

    @property
    def ctrl_z_sum(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch1_input.enum.ctrl_z_sum'))

    @ctrl_z_sum.setter
    def ctrl_z_sum(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch1_input.enum.ctrl_z_sum', int(new_val))

    @property
    def analyzer2_reference(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch1_input.enum.analyzer2_reference'))

    @analyzer2_reference.setter
    def analyzer2_reference(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch1_input.enum.analyzer2_reference', int(new_val))

    @property
    def analyzer1_ctrl_delta_f(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch1_input.enum.analyzer1_ctrl_delta_f'))

    @analyzer1_ctrl_delta_f.setter
    def analyzer1_ctrl_delta_f(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch1_input.enum.analyzer1_ctrl_delta_f', int(new_val))

    @property
    def in_position_z(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch1_input.enum.in_position_z'))

    @in_position_z.setter
    def in_position_z(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch1_input.enum.in_position_z', int(new_val))

    @property
    def analyzer2_x(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch1_input.enum.analyzer2_x'))

    @analyzer2_x.setter
    def analyzer2_x(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch1_input.enum.analyzer2_x', int(new_val))

    @property
    def static(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch1_input.enum.static'))

    @static.setter
    def static(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch1_input.enum.static', int(new_val))

    @property
    def in_lateral(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch1_input.enum.in_lateral'))

    @in_lateral.setter
    def in_lateral(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch1_input.enum.in_lateral', int(new_val))

    @property
    def ramp_gen_tip_voltage(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch1_input.enum.ramp_gen_tip_voltage'))

    @ramp_gen_tip_voltage.setter
    def ramp_gen_tip_voltage(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch1_input.enum.ramp_gen_tip_voltage', int(new_val))

    @property
    def ramp_gen_position_y(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch1_input.enum.ramp_gen_position_y'))

    @ramp_gen_position_y.setter
    def ramp_gen_position_y(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch1_input.enum.ramp_gen_position_y', int(new_val))

    @property
    def ramp_gen_position_w(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch1_input.enum.ramp_gen_position_w'))

    @ramp_gen_position_w.setter
    def ramp_gen_position_w(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch1_input.enum.ramp_gen_position_w', int(new_val))

    @property
    def ramp_gen_ctrl_z(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch1_input.enum.ramp_gen_ctrl_z'))

    @ramp_gen_ctrl_z.setter
    def ramp_gen_ctrl_z(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch1_input.enum.ramp_gen_ctrl_z', int(new_val))

    @property
    def memory_gen_position_x(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch1_input.enum.memory_gen_position_x'))

    @memory_gen_position_x.setter
    def memory_gen_position_x(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch1_input.enum.memory_gen_position_x', int(new_val))

    @property
    def in_user3(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch1_input.enum.in_user3'))

    @in_user3.setter
    def in_user3(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch1_input.enum.in_user3', int(new_val))

    @property
    def in_position_y(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch1_input.enum.in_position_y'))

    @in_position_y.setter
    def in_position_y(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch1_input.enum.in_position_y', int(new_val))

    @property
    def in_user4(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch1_input.enum.in_user4'))

    @in_user4.setter
    def in_user4(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch1_input.enum.in_user4', int(new_val))

    @property
    def ramp_gen_max_z(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch1_input.enum.ramp_gen_max_z'))

    @ramp_gen_max_z.setter
    def ramp_gen_max_z(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch1_input.enum.ramp_gen_max_z', int(new_val))

    @property
    def ort_free_wave(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch1_input.enum.ort_free_wave'))

    @ort_free_wave.setter
    def ort_free_wave(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch1_input.enum.ort_free_wave', int(new_val))

    @property
    def ort_baseline_corrected(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch1_input.enum.ort_baseline_corrected'))

    @ort_baseline_corrected.setter
    def ort_baseline_corrected(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch1_input.enum.ort_baseline_corrected', int(new_val))

    @property
    def ort_baseline(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch1_input.enum.ort_baseline'))

    @ort_baseline.setter
    def ort_baseline(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch1_input.enum.ort_baseline', int(new_val))

    @property
    def fast_in2(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch1_input.enum.fast_in2'))

    @fast_in2.setter
    def fast_in2(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch1_input.enum.fast_in2', int(new_val))

    @property
    def ctrl_z_error(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch1_input.enum.ctrl_z_error'))

    @ctrl_z_error.setter
    def ctrl_z_error(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch1_input.enum.ctrl_z_error', int(new_val))

    @property
    def memory_gen_position_z(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch1_input.enum.memory_gen_position_z'))

    @memory_gen_position_z.setter
    def memory_gen_position_z(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch1_input.enum.memory_gen_position_z', int(new_val))

    @property
    def fast_in_user(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch1_input.enum.fast_in_user'))

    @fast_in_user.setter
    def fast_in_user(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch1_input.enum.fast_in_user', int(new_val))

    @property
    def memory_gen_position_y(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch1_input.enum.memory_gen_position_y'))

    @memory_gen_position_y.setter
    def memory_gen_position_y(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch1_input.enum.memory_gen_position_y', int(new_val))

    @property
    def analyzer2_amplitude(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch1_input.enum.analyzer2_amplitude'))

    @analyzer2_amplitude.setter
    def analyzer2_amplitude(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch1_input.enum.analyzer2_amplitude', int(new_val))

    @property
    def memory_gen_out8(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch1_input.enum.memory_gen_out8'))

    @memory_gen_out8.setter
    def memory_gen_out8(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch1_input.enum.memory_gen_out8', int(new_val))

    @property
    def memory_gen_drive_z(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch1_input.enum.memory_gen_drive_z'))

    @memory_gen_drive_z.setter
    def memory_gen_drive_z(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch1_input.enum.memory_gen_drive_z', int(new_val))

    @property
    def ramp_gen_user4(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch1_input.enum.ramp_gen_user4'))

    @ramp_gen_user4.setter
    def ramp_gen_user4(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch1_input.enum.ramp_gen_user4', int(new_val))

    @property
    def analyzer1_amplitude(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch1_input.enum.analyzer1_amplitude'))

    @analyzer1_amplitude.setter
    def analyzer1_amplitude(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch1_input.enum.analyzer1_amplitude', int(new_val))

    @property
    def in_detector_sum(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch1_input.enum.in_detector_sum'))

    @in_detector_sum.setter
    def in_detector_sum(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch1_input.enum.in_detector_sum', int(new_val))

    @property
    def ctrl_z_in(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch1_input.enum.ctrl_z_in'))

    @ctrl_z_in.setter
    def ctrl_z_in(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch1_input.enum.ctrl_z_in', int(new_val))

    @property
    def ctrl_user1_out(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch1_input.enum.ctrl_user1_out'))

    @ctrl_user1_out.setter
    def ctrl_user1_out(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch1_input.enum.ctrl_user1_out', int(new_val))


class RootLuData_acquisitionInstanceAttributeSampler_hi_res_ch1_input(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch1_input'
        self.enum = RootLuData_acquisitionInstanceAttributeSampler_hi_res_ch1_inputEnum(self._context)


class RootLuData_acquisitionInstanceAttributeSampler_hi_res_ch5_inputEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch5_input.enum'

    @property
    def ort_adhesion_position(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch5_input.enum.ort_adhesion_position'))

    @ort_adhesion_position.setter
    def ort_adhesion_position(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch5_input.enum.ort_adhesion_position', int(new_val))

    @property
    def ctrl_z_pid_command(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch5_input.enum.ctrl_z_pid_command'))

    @ctrl_z_pid_command.setter
    def ctrl_z_pid_command(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch5_input.enum.ctrl_z_pid_command', int(new_val))

    @property
    def in6(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch5_input.enum.in6'))

    @in6.setter
    def in6(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch5_input.enum.in6', int(new_val))

    @property
    def ctrl_z_nominal(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch5_input.enum.ctrl_z_nominal'))

    @ctrl_z_nominal.setter
    def ctrl_z_nominal(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch5_input.enum.ctrl_z_nominal', int(new_val))

    @property
    def ctrl_x_out(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch5_input.enum.ctrl_x_out'))

    @ctrl_x_out.setter
    def ctrl_x_out(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch5_input.enum.ctrl_x_out', int(new_val))

    @property
    def memory_gen_drive_y(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch5_input.enum.memory_gen_drive_y'))

    @memory_gen_drive_y.setter
    def memory_gen_drive_y(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch5_input.enum.memory_gen_drive_y', int(new_val))

    @property
    def ctrl_user2_out(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch5_input.enum.ctrl_user2_out'))

    @ctrl_user2_out.setter
    def ctrl_user2_out(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch5_input.enum.ctrl_user2_out', int(new_val))

    @property
    def analyzer2_phase(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch5_input.enum.analyzer2_phase'))

    @analyzer2_phase.setter
    def analyzer2_phase(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch5_input.enum.analyzer2_phase', int(new_val))

    @property
    def fast_in_deflection(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch5_input.enum.fast_in_deflection'))

    @fast_in_deflection.setter
    def fast_in_deflection(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch5_input.enum.fast_in_deflection', int(new_val))

    @property
    def in_user2(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch5_input.enum.in_user2'))

    @in_user2.setter
    def in_user2(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch5_input.enum.in_user2', int(new_val))

    @property
    def ramp_gen_position_x(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch5_input.enum.ramp_gen_position_x'))

    @ramp_gen_position_x.setter
    def ramp_gen_position_x(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch5_input.enum.ramp_gen_position_x', int(new_val))

    @property
    def in_deflection(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch5_input.enum.in_deflection'))

    @in_deflection.setter
    def in_deflection(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch5_input.enum.in_deflection', int(new_val))

    @property
    def ort_amplitude_reduction(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch5_input.enum.ort_amplitude_reduction'))

    @ort_amplitude_reduction.setter
    def ort_amplitude_reduction(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch5_input.enum.ort_amplitude_reduction', int(new_val))

    @property
    def analyzer2_ctrl_amplitude(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch5_input.enum.analyzer2_ctrl_amplitude'))

    @analyzer2_ctrl_amplitude.setter
    def analyzer2_ctrl_amplitude(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch5_input.enum.analyzer2_ctrl_amplitude', int(new_val))

    @property
    def memory_gen_drive_x(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch5_input.enum.memory_gen_drive_x'))

    @memory_gen_drive_x.setter
    def memory_gen_drive_x(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch5_input.enum.memory_gen_drive_x', int(new_val))

    @property
    def ramp_gen_alternate_z(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch5_input.enum.ramp_gen_alternate_z'))

    @ramp_gen_alternate_z.setter
    def ramp_gen_alternate_z(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch5_input.enum.ramp_gen_alternate_z', int(new_val))

    @property
    def analyzer2_ctrl_delta_f(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch5_input.enum.analyzer2_ctrl_delta_f'))

    @analyzer2_ctrl_delta_f.setter
    def analyzer2_ctrl_delta_f(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch5_input.enum.analyzer2_ctrl_delta_f', int(new_val))

    @property
    def ort_excitation(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch5_input.enum.ort_excitation'))

    @ort_excitation.setter
    def ort_excitation(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch5_input.enum.ort_excitation', int(new_val))

    @property
    def analyzer1_y(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch5_input.enum.analyzer1_y'))

    @analyzer1_y.setter
    def analyzer1_y(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch5_input.enum.analyzer1_y', int(new_val))

    @property
    def ort_adhesion_value(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch5_input.enum.ort_adhesion_value'))

    @ort_adhesion_value.setter
    def ort_adhesion_value(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch5_input.enum.ort_adhesion_value', int(new_val))

    @property
    def ctrl_y_out(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch5_input.enum.ctrl_y_out'))

    @ctrl_y_out.setter
    def ctrl_y_out(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch5_input.enum.ctrl_y_out', int(new_val))

    @property
    def analyzer1_phase(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch5_input.enum.analyzer1_phase'))

    @analyzer1_phase.setter
    def analyzer1_phase(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch5_input.enum.analyzer1_phase', int(new_val))

    @property
    def ctrl_z_out(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch5_input.enum.ctrl_z_out'))

    @ctrl_z_out.setter
    def ctrl_z_out(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch5_input.enum.ctrl_z_out', int(new_val))

    @property
    def ctrl_w_out(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch5_input.enum.ctrl_w_out'))

    @ctrl_w_out.setter
    def ctrl_w_out(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch5_input.enum.ctrl_w_out', int(new_val))

    @property
    def analyzer1_ctrl_amplitude(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch5_input.enum.analyzer1_ctrl_amplitude'))

    @analyzer1_ctrl_amplitude.setter
    def analyzer1_ctrl_amplitude(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch5_input.enum.analyzer1_ctrl_amplitude', int(new_val))

    @property
    def in_user1(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch5_input.enum.in_user1'))

    @in_user1.setter
    def in_user1(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch5_input.enum.in_user1', int(new_val))

    @property
    def ramp_gen_approach(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch5_input.enum.ramp_gen_approach'))

    @ramp_gen_approach.setter
    def ramp_gen_approach(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch5_input.enum.ramp_gen_approach', int(new_val))

    @property
    def ramp_gen_test(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch5_input.enum.ramp_gen_test'))

    @ramp_gen_test.setter
    def ramp_gen_test(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch5_input.enum.ramp_gen_test', int(new_val))

    @property
    def in_position_x(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch5_input.enum.in_position_x'))

    @in_position_x.setter
    def in_position_x(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch5_input.enum.in_position_x', int(new_val))

    @property
    def analyzer1_reference(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch5_input.enum.analyzer1_reference'))

    @analyzer1_reference.setter
    def analyzer1_reference(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch5_input.enum.analyzer1_reference', int(new_val))

    @property
    def ramp_gen_plane_z(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch5_input.enum.ramp_gen_plane_z'))

    @ramp_gen_plane_z.setter
    def ramp_gen_plane_z(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch5_input.enum.ramp_gen_plane_z', int(new_val))

    @property
    def memory_gen_out7(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch5_input.enum.memory_gen_out7'))

    @memory_gen_out7.setter
    def memory_gen_out7(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch5_input.enum.memory_gen_out7', int(new_val))

    @property
    def analyzer2_y(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch5_input.enum.analyzer2_y'))

    @analyzer2_y.setter
    def analyzer2_y(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch5_input.enum.analyzer2_y', int(new_val))

    @property
    def gen_test_dynamic(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch5_input.enum.gen_test_dynamic'))

    @gen_test_dynamic.setter
    def gen_test_dynamic(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch5_input.enum.gen_test_dynamic', int(new_val))

    @property
    def in_tip_current(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch5_input.enum.in_tip_current'))

    @in_tip_current.setter
    def in_tip_current(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch5_input.enum.in_tip_current', int(new_val))

    @property
    def analyzer1_x(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch5_input.enum.analyzer1_x'))

    @analyzer1_x.setter
    def analyzer1_x(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch5_input.enum.analyzer1_x', int(new_val))

    @property
    def ctrl_z_sum(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch5_input.enum.ctrl_z_sum'))

    @ctrl_z_sum.setter
    def ctrl_z_sum(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch5_input.enum.ctrl_z_sum', int(new_val))

    @property
    def analyzer2_reference(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch5_input.enum.analyzer2_reference'))

    @analyzer2_reference.setter
    def analyzer2_reference(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch5_input.enum.analyzer2_reference', int(new_val))

    @property
    def analyzer1_ctrl_delta_f(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch5_input.enum.analyzer1_ctrl_delta_f'))

    @analyzer1_ctrl_delta_f.setter
    def analyzer1_ctrl_delta_f(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch5_input.enum.analyzer1_ctrl_delta_f', int(new_val))

    @property
    def in_position_z(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch5_input.enum.in_position_z'))

    @in_position_z.setter
    def in_position_z(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch5_input.enum.in_position_z', int(new_val))

    @property
    def analyzer2_x(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch5_input.enum.analyzer2_x'))

    @analyzer2_x.setter
    def analyzer2_x(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch5_input.enum.analyzer2_x', int(new_val))

    @property
    def static(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch5_input.enum.static'))

    @static.setter
    def static(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch5_input.enum.static', int(new_val))

    @property
    def in_lateral(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch5_input.enum.in_lateral'))

    @in_lateral.setter
    def in_lateral(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch5_input.enum.in_lateral', int(new_val))

    @property
    def ramp_gen_tip_voltage(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch5_input.enum.ramp_gen_tip_voltage'))

    @ramp_gen_tip_voltage.setter
    def ramp_gen_tip_voltage(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch5_input.enum.ramp_gen_tip_voltage', int(new_val))

    @property
    def ramp_gen_position_y(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch5_input.enum.ramp_gen_position_y'))

    @ramp_gen_position_y.setter
    def ramp_gen_position_y(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch5_input.enum.ramp_gen_position_y', int(new_val))

    @property
    def ramp_gen_position_w(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch5_input.enum.ramp_gen_position_w'))

    @ramp_gen_position_w.setter
    def ramp_gen_position_w(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch5_input.enum.ramp_gen_position_w', int(new_val))

    @property
    def ramp_gen_ctrl_z(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch5_input.enum.ramp_gen_ctrl_z'))

    @ramp_gen_ctrl_z.setter
    def ramp_gen_ctrl_z(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch5_input.enum.ramp_gen_ctrl_z', int(new_val))

    @property
    def memory_gen_position_x(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch5_input.enum.memory_gen_position_x'))

    @memory_gen_position_x.setter
    def memory_gen_position_x(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch5_input.enum.memory_gen_position_x', int(new_val))

    @property
    def in_user3(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch5_input.enum.in_user3'))

    @in_user3.setter
    def in_user3(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch5_input.enum.in_user3', int(new_val))

    @property
    def in_position_y(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch5_input.enum.in_position_y'))

    @in_position_y.setter
    def in_position_y(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch5_input.enum.in_position_y', int(new_val))

    @property
    def in_user4(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch5_input.enum.in_user4'))

    @in_user4.setter
    def in_user4(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch5_input.enum.in_user4', int(new_val))

    @property
    def ramp_gen_max_z(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch5_input.enum.ramp_gen_max_z'))

    @ramp_gen_max_z.setter
    def ramp_gen_max_z(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch5_input.enum.ramp_gen_max_z', int(new_val))

    @property
    def ort_free_wave(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch5_input.enum.ort_free_wave'))

    @ort_free_wave.setter
    def ort_free_wave(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch5_input.enum.ort_free_wave', int(new_val))

    @property
    def ort_baseline_corrected(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch5_input.enum.ort_baseline_corrected'))

    @ort_baseline_corrected.setter
    def ort_baseline_corrected(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch5_input.enum.ort_baseline_corrected', int(new_val))

    @property
    def ort_baseline(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch5_input.enum.ort_baseline'))

    @ort_baseline.setter
    def ort_baseline(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch5_input.enum.ort_baseline', int(new_val))

    @property
    def fast_in2(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch5_input.enum.fast_in2'))

    @fast_in2.setter
    def fast_in2(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch5_input.enum.fast_in2', int(new_val))

    @property
    def ctrl_z_error(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch5_input.enum.ctrl_z_error'))

    @ctrl_z_error.setter
    def ctrl_z_error(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch5_input.enum.ctrl_z_error', int(new_val))

    @property
    def memory_gen_position_z(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch5_input.enum.memory_gen_position_z'))

    @memory_gen_position_z.setter
    def memory_gen_position_z(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch5_input.enum.memory_gen_position_z', int(new_val))

    @property
    def fast_in_user(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch5_input.enum.fast_in_user'))

    @fast_in_user.setter
    def fast_in_user(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch5_input.enum.fast_in_user', int(new_val))

    @property
    def memory_gen_position_y(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch5_input.enum.memory_gen_position_y'))

    @memory_gen_position_y.setter
    def memory_gen_position_y(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch5_input.enum.memory_gen_position_y', int(new_val))

    @property
    def analyzer2_amplitude(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch5_input.enum.analyzer2_amplitude'))

    @analyzer2_amplitude.setter
    def analyzer2_amplitude(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch5_input.enum.analyzer2_amplitude', int(new_val))

    @property
    def memory_gen_out8(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch5_input.enum.memory_gen_out8'))

    @memory_gen_out8.setter
    def memory_gen_out8(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch5_input.enum.memory_gen_out8', int(new_val))

    @property
    def memory_gen_drive_z(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch5_input.enum.memory_gen_drive_z'))

    @memory_gen_drive_z.setter
    def memory_gen_drive_z(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch5_input.enum.memory_gen_drive_z', int(new_val))

    @property
    def ramp_gen_user4(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch5_input.enum.ramp_gen_user4'))

    @ramp_gen_user4.setter
    def ramp_gen_user4(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch5_input.enum.ramp_gen_user4', int(new_val))

    @property
    def analyzer1_amplitude(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch5_input.enum.analyzer1_amplitude'))

    @analyzer1_amplitude.setter
    def analyzer1_amplitude(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch5_input.enum.analyzer1_amplitude', int(new_val))

    @property
    def in_detector_sum(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch5_input.enum.in_detector_sum'))

    @in_detector_sum.setter
    def in_detector_sum(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch5_input.enum.in_detector_sum', int(new_val))

    @property
    def ctrl_z_in(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch5_input.enum.ctrl_z_in'))

    @ctrl_z_in.setter
    def ctrl_z_in(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch5_input.enum.ctrl_z_in', int(new_val))

    @property
    def ctrl_user1_out(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch5_input.enum.ctrl_user1_out'))

    @ctrl_user1_out.setter
    def ctrl_user1_out(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch5_input.enum.ctrl_user1_out', int(new_val))


class RootLuData_acquisitionInstanceAttributeSampler_hi_res_ch5_input(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch5_input'
        self.enum = RootLuData_acquisitionInstanceAttributeSampler_hi_res_ch5_inputEnum(self._context)


class RootLuData_acquisitionInstanceAttributeSampler_hi_res_ch6_inputEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch6_input.enum'

    @property
    def ort_adhesion_position(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch6_input.enum.ort_adhesion_position'))

    @ort_adhesion_position.setter
    def ort_adhesion_position(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch6_input.enum.ort_adhesion_position', int(new_val))

    @property
    def ctrl_z_pid_command(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch6_input.enum.ctrl_z_pid_command'))

    @ctrl_z_pid_command.setter
    def ctrl_z_pid_command(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch6_input.enum.ctrl_z_pid_command', int(new_val))

    @property
    def in6(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch6_input.enum.in6'))

    @in6.setter
    def in6(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch6_input.enum.in6', int(new_val))

    @property
    def ctrl_z_nominal(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch6_input.enum.ctrl_z_nominal'))

    @ctrl_z_nominal.setter
    def ctrl_z_nominal(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch6_input.enum.ctrl_z_nominal', int(new_val))

    @property
    def ctrl_x_out(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch6_input.enum.ctrl_x_out'))

    @ctrl_x_out.setter
    def ctrl_x_out(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch6_input.enum.ctrl_x_out', int(new_val))

    @property
    def memory_gen_drive_y(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch6_input.enum.memory_gen_drive_y'))

    @memory_gen_drive_y.setter
    def memory_gen_drive_y(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch6_input.enum.memory_gen_drive_y', int(new_val))

    @property
    def ctrl_user2_out(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch6_input.enum.ctrl_user2_out'))

    @ctrl_user2_out.setter
    def ctrl_user2_out(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch6_input.enum.ctrl_user2_out', int(new_val))

    @property
    def analyzer2_phase(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch6_input.enum.analyzer2_phase'))

    @analyzer2_phase.setter
    def analyzer2_phase(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch6_input.enum.analyzer2_phase', int(new_val))

    @property
    def fast_in_deflection(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch6_input.enum.fast_in_deflection'))

    @fast_in_deflection.setter
    def fast_in_deflection(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch6_input.enum.fast_in_deflection', int(new_val))

    @property
    def in_user2(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch6_input.enum.in_user2'))

    @in_user2.setter
    def in_user2(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch6_input.enum.in_user2', int(new_val))

    @property
    def ramp_gen_position_x(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch6_input.enum.ramp_gen_position_x'))

    @ramp_gen_position_x.setter
    def ramp_gen_position_x(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch6_input.enum.ramp_gen_position_x', int(new_val))

    @property
    def in_deflection(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch6_input.enum.in_deflection'))

    @in_deflection.setter
    def in_deflection(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch6_input.enum.in_deflection', int(new_val))

    @property
    def ort_amplitude_reduction(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch6_input.enum.ort_amplitude_reduction'))

    @ort_amplitude_reduction.setter
    def ort_amplitude_reduction(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch6_input.enum.ort_amplitude_reduction', int(new_val))

    @property
    def analyzer2_ctrl_amplitude(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch6_input.enum.analyzer2_ctrl_amplitude'))

    @analyzer2_ctrl_amplitude.setter
    def analyzer2_ctrl_amplitude(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch6_input.enum.analyzer2_ctrl_amplitude', int(new_val))

    @property
    def memory_gen_drive_x(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch6_input.enum.memory_gen_drive_x'))

    @memory_gen_drive_x.setter
    def memory_gen_drive_x(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch6_input.enum.memory_gen_drive_x', int(new_val))

    @property
    def ramp_gen_alternate_z(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch6_input.enum.ramp_gen_alternate_z'))

    @ramp_gen_alternate_z.setter
    def ramp_gen_alternate_z(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch6_input.enum.ramp_gen_alternate_z', int(new_val))

    @property
    def analyzer2_ctrl_delta_f(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch6_input.enum.analyzer2_ctrl_delta_f'))

    @analyzer2_ctrl_delta_f.setter
    def analyzer2_ctrl_delta_f(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch6_input.enum.analyzer2_ctrl_delta_f', int(new_val))

    @property
    def ort_excitation(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch6_input.enum.ort_excitation'))

    @ort_excitation.setter
    def ort_excitation(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch6_input.enum.ort_excitation', int(new_val))

    @property
    def analyzer1_y(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch6_input.enum.analyzer1_y'))

    @analyzer1_y.setter
    def analyzer1_y(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch6_input.enum.analyzer1_y', int(new_val))

    @property
    def ort_adhesion_value(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch6_input.enum.ort_adhesion_value'))

    @ort_adhesion_value.setter
    def ort_adhesion_value(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch6_input.enum.ort_adhesion_value', int(new_val))

    @property
    def ctrl_y_out(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch6_input.enum.ctrl_y_out'))

    @ctrl_y_out.setter
    def ctrl_y_out(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch6_input.enum.ctrl_y_out', int(new_val))

    @property
    def analyzer1_phase(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch6_input.enum.analyzer1_phase'))

    @analyzer1_phase.setter
    def analyzer1_phase(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch6_input.enum.analyzer1_phase', int(new_val))

    @property
    def ctrl_z_out(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch6_input.enum.ctrl_z_out'))

    @ctrl_z_out.setter
    def ctrl_z_out(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch6_input.enum.ctrl_z_out', int(new_val))

    @property
    def ctrl_w_out(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch6_input.enum.ctrl_w_out'))

    @ctrl_w_out.setter
    def ctrl_w_out(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch6_input.enum.ctrl_w_out', int(new_val))

    @property
    def analyzer1_ctrl_amplitude(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch6_input.enum.analyzer1_ctrl_amplitude'))

    @analyzer1_ctrl_amplitude.setter
    def analyzer1_ctrl_amplitude(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch6_input.enum.analyzer1_ctrl_amplitude', int(new_val))

    @property
    def in_user1(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch6_input.enum.in_user1'))

    @in_user1.setter
    def in_user1(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch6_input.enum.in_user1', int(new_val))

    @property
    def ramp_gen_approach(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch6_input.enum.ramp_gen_approach'))

    @ramp_gen_approach.setter
    def ramp_gen_approach(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch6_input.enum.ramp_gen_approach', int(new_val))

    @property
    def ramp_gen_test(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch6_input.enum.ramp_gen_test'))

    @ramp_gen_test.setter
    def ramp_gen_test(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch6_input.enum.ramp_gen_test', int(new_val))

    @property
    def in_position_x(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch6_input.enum.in_position_x'))

    @in_position_x.setter
    def in_position_x(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch6_input.enum.in_position_x', int(new_val))

    @property
    def analyzer1_reference(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch6_input.enum.analyzer1_reference'))

    @analyzer1_reference.setter
    def analyzer1_reference(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch6_input.enum.analyzer1_reference', int(new_val))

    @property
    def ramp_gen_plane_z(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch6_input.enum.ramp_gen_plane_z'))

    @ramp_gen_plane_z.setter
    def ramp_gen_plane_z(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch6_input.enum.ramp_gen_plane_z', int(new_val))

    @property
    def memory_gen_out7(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch6_input.enum.memory_gen_out7'))

    @memory_gen_out7.setter
    def memory_gen_out7(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch6_input.enum.memory_gen_out7', int(new_val))

    @property
    def analyzer2_y(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch6_input.enum.analyzer2_y'))

    @analyzer2_y.setter
    def analyzer2_y(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch6_input.enum.analyzer2_y', int(new_val))

    @property
    def gen_test_dynamic(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch6_input.enum.gen_test_dynamic'))

    @gen_test_dynamic.setter
    def gen_test_dynamic(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch6_input.enum.gen_test_dynamic', int(new_val))

    @property
    def in_tip_current(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch6_input.enum.in_tip_current'))

    @in_tip_current.setter
    def in_tip_current(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch6_input.enum.in_tip_current', int(new_val))

    @property
    def analyzer1_x(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch6_input.enum.analyzer1_x'))

    @analyzer1_x.setter
    def analyzer1_x(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch6_input.enum.analyzer1_x', int(new_val))

    @property
    def ctrl_z_sum(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch6_input.enum.ctrl_z_sum'))

    @ctrl_z_sum.setter
    def ctrl_z_sum(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch6_input.enum.ctrl_z_sum', int(new_val))

    @property
    def analyzer2_reference(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch6_input.enum.analyzer2_reference'))

    @analyzer2_reference.setter
    def analyzer2_reference(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch6_input.enum.analyzer2_reference', int(new_val))

    @property
    def analyzer1_ctrl_delta_f(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch6_input.enum.analyzer1_ctrl_delta_f'))

    @analyzer1_ctrl_delta_f.setter
    def analyzer1_ctrl_delta_f(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch6_input.enum.analyzer1_ctrl_delta_f', int(new_val))

    @property
    def in_position_z(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch6_input.enum.in_position_z'))

    @in_position_z.setter
    def in_position_z(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch6_input.enum.in_position_z', int(new_val))

    @property
    def analyzer2_x(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch6_input.enum.analyzer2_x'))

    @analyzer2_x.setter
    def analyzer2_x(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch6_input.enum.analyzer2_x', int(new_val))

    @property
    def static(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch6_input.enum.static'))

    @static.setter
    def static(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch6_input.enum.static', int(new_val))

    @property
    def in_lateral(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch6_input.enum.in_lateral'))

    @in_lateral.setter
    def in_lateral(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch6_input.enum.in_lateral', int(new_val))

    @property
    def ramp_gen_tip_voltage(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch6_input.enum.ramp_gen_tip_voltage'))

    @ramp_gen_tip_voltage.setter
    def ramp_gen_tip_voltage(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch6_input.enum.ramp_gen_tip_voltage', int(new_val))

    @property
    def ramp_gen_position_y(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch6_input.enum.ramp_gen_position_y'))

    @ramp_gen_position_y.setter
    def ramp_gen_position_y(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch6_input.enum.ramp_gen_position_y', int(new_val))

    @property
    def ramp_gen_position_w(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch6_input.enum.ramp_gen_position_w'))

    @ramp_gen_position_w.setter
    def ramp_gen_position_w(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch6_input.enum.ramp_gen_position_w', int(new_val))

    @property
    def ramp_gen_ctrl_z(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch6_input.enum.ramp_gen_ctrl_z'))

    @ramp_gen_ctrl_z.setter
    def ramp_gen_ctrl_z(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch6_input.enum.ramp_gen_ctrl_z', int(new_val))

    @property
    def memory_gen_position_x(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch6_input.enum.memory_gen_position_x'))

    @memory_gen_position_x.setter
    def memory_gen_position_x(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch6_input.enum.memory_gen_position_x', int(new_val))

    @property
    def in_user3(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch6_input.enum.in_user3'))

    @in_user3.setter
    def in_user3(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch6_input.enum.in_user3', int(new_val))

    @property
    def in_position_y(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch6_input.enum.in_position_y'))

    @in_position_y.setter
    def in_position_y(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch6_input.enum.in_position_y', int(new_val))

    @property
    def in_user4(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch6_input.enum.in_user4'))

    @in_user4.setter
    def in_user4(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch6_input.enum.in_user4', int(new_val))

    @property
    def ramp_gen_max_z(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch6_input.enum.ramp_gen_max_z'))

    @ramp_gen_max_z.setter
    def ramp_gen_max_z(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch6_input.enum.ramp_gen_max_z', int(new_val))

    @property
    def ort_free_wave(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch6_input.enum.ort_free_wave'))

    @ort_free_wave.setter
    def ort_free_wave(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch6_input.enum.ort_free_wave', int(new_val))

    @property
    def ort_baseline_corrected(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch6_input.enum.ort_baseline_corrected'))

    @ort_baseline_corrected.setter
    def ort_baseline_corrected(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch6_input.enum.ort_baseline_corrected', int(new_val))

    @property
    def ort_baseline(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch6_input.enum.ort_baseline'))

    @ort_baseline.setter
    def ort_baseline(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch6_input.enum.ort_baseline', int(new_val))

    @property
    def fast_in2(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch6_input.enum.fast_in2'))

    @fast_in2.setter
    def fast_in2(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch6_input.enum.fast_in2', int(new_val))

    @property
    def ctrl_z_error(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch6_input.enum.ctrl_z_error'))

    @ctrl_z_error.setter
    def ctrl_z_error(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch6_input.enum.ctrl_z_error', int(new_val))

    @property
    def memory_gen_position_z(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch6_input.enum.memory_gen_position_z'))

    @memory_gen_position_z.setter
    def memory_gen_position_z(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch6_input.enum.memory_gen_position_z', int(new_val))

    @property
    def fast_in_user(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch6_input.enum.fast_in_user'))

    @fast_in_user.setter
    def fast_in_user(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch6_input.enum.fast_in_user', int(new_val))

    @property
    def memory_gen_position_y(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch6_input.enum.memory_gen_position_y'))

    @memory_gen_position_y.setter
    def memory_gen_position_y(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch6_input.enum.memory_gen_position_y', int(new_val))

    @property
    def analyzer2_amplitude(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch6_input.enum.analyzer2_amplitude'))

    @analyzer2_amplitude.setter
    def analyzer2_amplitude(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch6_input.enum.analyzer2_amplitude', int(new_val))

    @property
    def memory_gen_out8(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch6_input.enum.memory_gen_out8'))

    @memory_gen_out8.setter
    def memory_gen_out8(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch6_input.enum.memory_gen_out8', int(new_val))

    @property
    def memory_gen_drive_z(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch6_input.enum.memory_gen_drive_z'))

    @memory_gen_drive_z.setter
    def memory_gen_drive_z(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch6_input.enum.memory_gen_drive_z', int(new_val))

    @property
    def ramp_gen_user4(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch6_input.enum.ramp_gen_user4'))

    @ramp_gen_user4.setter
    def ramp_gen_user4(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch6_input.enum.ramp_gen_user4', int(new_val))

    @property
    def analyzer1_amplitude(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch6_input.enum.analyzer1_amplitude'))

    @analyzer1_amplitude.setter
    def analyzer1_amplitude(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch6_input.enum.analyzer1_amplitude', int(new_val))

    @property
    def in_detector_sum(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch6_input.enum.in_detector_sum'))

    @in_detector_sum.setter
    def in_detector_sum(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch6_input.enum.in_detector_sum', int(new_val))

    @property
    def ctrl_z_in(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch6_input.enum.ctrl_z_in'))

    @ctrl_z_in.setter
    def ctrl_z_in(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch6_input.enum.ctrl_z_in', int(new_val))

    @property
    def ctrl_user1_out(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch6_input.enum.ctrl_user1_out'))

    @ctrl_user1_out.setter
    def ctrl_user1_out(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch6_input.enum.ctrl_user1_out', int(new_val))


class RootLuData_acquisitionInstanceAttributeSampler_hi_res_ch6_input(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch6_input'
        self.enum = RootLuData_acquisitionInstanceAttributeSampler_hi_res_ch6_inputEnum(self._context)


class RootLuData_acquisitionInstanceAttributeSampler_hi_res_ch4_inputEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch4_input.enum'

    @property
    def ort_adhesion_position(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch4_input.enum.ort_adhesion_position'))

    @ort_adhesion_position.setter
    def ort_adhesion_position(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch4_input.enum.ort_adhesion_position', int(new_val))

    @property
    def ctrl_z_pid_command(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch4_input.enum.ctrl_z_pid_command'))

    @ctrl_z_pid_command.setter
    def ctrl_z_pid_command(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch4_input.enum.ctrl_z_pid_command', int(new_val))

    @property
    def in6(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch4_input.enum.in6'))

    @in6.setter
    def in6(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch4_input.enum.in6', int(new_val))

    @property
    def ctrl_z_nominal(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch4_input.enum.ctrl_z_nominal'))

    @ctrl_z_nominal.setter
    def ctrl_z_nominal(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch4_input.enum.ctrl_z_nominal', int(new_val))

    @property
    def ctrl_x_out(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch4_input.enum.ctrl_x_out'))

    @ctrl_x_out.setter
    def ctrl_x_out(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch4_input.enum.ctrl_x_out', int(new_val))

    @property
    def memory_gen_drive_y(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch4_input.enum.memory_gen_drive_y'))

    @memory_gen_drive_y.setter
    def memory_gen_drive_y(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch4_input.enum.memory_gen_drive_y', int(new_val))

    @property
    def ctrl_user2_out(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch4_input.enum.ctrl_user2_out'))

    @ctrl_user2_out.setter
    def ctrl_user2_out(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch4_input.enum.ctrl_user2_out', int(new_val))

    @property
    def analyzer2_phase(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch4_input.enum.analyzer2_phase'))

    @analyzer2_phase.setter
    def analyzer2_phase(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch4_input.enum.analyzer2_phase', int(new_val))

    @property
    def fast_in_deflection(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch4_input.enum.fast_in_deflection'))

    @fast_in_deflection.setter
    def fast_in_deflection(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch4_input.enum.fast_in_deflection', int(new_val))

    @property
    def in_user2(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch4_input.enum.in_user2'))

    @in_user2.setter
    def in_user2(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch4_input.enum.in_user2', int(new_val))

    @property
    def ramp_gen_position_x(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch4_input.enum.ramp_gen_position_x'))

    @ramp_gen_position_x.setter
    def ramp_gen_position_x(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch4_input.enum.ramp_gen_position_x', int(new_val))

    @property
    def in_deflection(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch4_input.enum.in_deflection'))

    @in_deflection.setter
    def in_deflection(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch4_input.enum.in_deflection', int(new_val))

    @property
    def ort_amplitude_reduction(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch4_input.enum.ort_amplitude_reduction'))

    @ort_amplitude_reduction.setter
    def ort_amplitude_reduction(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch4_input.enum.ort_amplitude_reduction', int(new_val))

    @property
    def analyzer2_ctrl_amplitude(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch4_input.enum.analyzer2_ctrl_amplitude'))

    @analyzer2_ctrl_amplitude.setter
    def analyzer2_ctrl_amplitude(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch4_input.enum.analyzer2_ctrl_amplitude', int(new_val))

    @property
    def memory_gen_drive_x(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch4_input.enum.memory_gen_drive_x'))

    @memory_gen_drive_x.setter
    def memory_gen_drive_x(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch4_input.enum.memory_gen_drive_x', int(new_val))

    @property
    def ramp_gen_alternate_z(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch4_input.enum.ramp_gen_alternate_z'))

    @ramp_gen_alternate_z.setter
    def ramp_gen_alternate_z(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch4_input.enum.ramp_gen_alternate_z', int(new_val))

    @property
    def analyzer2_ctrl_delta_f(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch4_input.enum.analyzer2_ctrl_delta_f'))

    @analyzer2_ctrl_delta_f.setter
    def analyzer2_ctrl_delta_f(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch4_input.enum.analyzer2_ctrl_delta_f', int(new_val))

    @property
    def ort_excitation(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch4_input.enum.ort_excitation'))

    @ort_excitation.setter
    def ort_excitation(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch4_input.enum.ort_excitation', int(new_val))

    @property
    def analyzer1_y(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch4_input.enum.analyzer1_y'))

    @analyzer1_y.setter
    def analyzer1_y(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch4_input.enum.analyzer1_y', int(new_val))

    @property
    def ort_adhesion_value(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch4_input.enum.ort_adhesion_value'))

    @ort_adhesion_value.setter
    def ort_adhesion_value(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch4_input.enum.ort_adhesion_value', int(new_val))

    @property
    def ctrl_y_out(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch4_input.enum.ctrl_y_out'))

    @ctrl_y_out.setter
    def ctrl_y_out(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch4_input.enum.ctrl_y_out', int(new_val))

    @property
    def analyzer1_phase(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch4_input.enum.analyzer1_phase'))

    @analyzer1_phase.setter
    def analyzer1_phase(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch4_input.enum.analyzer1_phase', int(new_val))

    @property
    def ctrl_z_out(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch4_input.enum.ctrl_z_out'))

    @ctrl_z_out.setter
    def ctrl_z_out(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch4_input.enum.ctrl_z_out', int(new_val))

    @property
    def ctrl_w_out(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch4_input.enum.ctrl_w_out'))

    @ctrl_w_out.setter
    def ctrl_w_out(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch4_input.enum.ctrl_w_out', int(new_val))

    @property
    def analyzer1_ctrl_amplitude(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch4_input.enum.analyzer1_ctrl_amplitude'))

    @analyzer1_ctrl_amplitude.setter
    def analyzer1_ctrl_amplitude(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch4_input.enum.analyzer1_ctrl_amplitude', int(new_val))

    @property
    def in_user1(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch4_input.enum.in_user1'))

    @in_user1.setter
    def in_user1(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch4_input.enum.in_user1', int(new_val))

    @property
    def ramp_gen_approach(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch4_input.enum.ramp_gen_approach'))

    @ramp_gen_approach.setter
    def ramp_gen_approach(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch4_input.enum.ramp_gen_approach', int(new_val))

    @property
    def ramp_gen_test(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch4_input.enum.ramp_gen_test'))

    @ramp_gen_test.setter
    def ramp_gen_test(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch4_input.enum.ramp_gen_test', int(new_val))

    @property
    def in_position_x(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch4_input.enum.in_position_x'))

    @in_position_x.setter
    def in_position_x(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch4_input.enum.in_position_x', int(new_val))

    @property
    def analyzer1_reference(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch4_input.enum.analyzer1_reference'))

    @analyzer1_reference.setter
    def analyzer1_reference(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch4_input.enum.analyzer1_reference', int(new_val))

    @property
    def ramp_gen_plane_z(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch4_input.enum.ramp_gen_plane_z'))

    @ramp_gen_plane_z.setter
    def ramp_gen_plane_z(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch4_input.enum.ramp_gen_plane_z', int(new_val))

    @property
    def memory_gen_out7(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch4_input.enum.memory_gen_out7'))

    @memory_gen_out7.setter
    def memory_gen_out7(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch4_input.enum.memory_gen_out7', int(new_val))

    @property
    def analyzer2_y(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch4_input.enum.analyzer2_y'))

    @analyzer2_y.setter
    def analyzer2_y(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch4_input.enum.analyzer2_y', int(new_val))

    @property
    def gen_test_dynamic(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch4_input.enum.gen_test_dynamic'))

    @gen_test_dynamic.setter
    def gen_test_dynamic(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch4_input.enum.gen_test_dynamic', int(new_val))

    @property
    def in_tip_current(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch4_input.enum.in_tip_current'))

    @in_tip_current.setter
    def in_tip_current(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch4_input.enum.in_tip_current', int(new_val))

    @property
    def analyzer1_x(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch4_input.enum.analyzer1_x'))

    @analyzer1_x.setter
    def analyzer1_x(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch4_input.enum.analyzer1_x', int(new_val))

    @property
    def ctrl_z_sum(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch4_input.enum.ctrl_z_sum'))

    @ctrl_z_sum.setter
    def ctrl_z_sum(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch4_input.enum.ctrl_z_sum', int(new_val))

    @property
    def analyzer2_reference(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch4_input.enum.analyzer2_reference'))

    @analyzer2_reference.setter
    def analyzer2_reference(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch4_input.enum.analyzer2_reference', int(new_val))

    @property
    def analyzer1_ctrl_delta_f(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch4_input.enum.analyzer1_ctrl_delta_f'))

    @analyzer1_ctrl_delta_f.setter
    def analyzer1_ctrl_delta_f(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch4_input.enum.analyzer1_ctrl_delta_f', int(new_val))

    @property
    def in_position_z(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch4_input.enum.in_position_z'))

    @in_position_z.setter
    def in_position_z(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch4_input.enum.in_position_z', int(new_val))

    @property
    def analyzer2_x(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch4_input.enum.analyzer2_x'))

    @analyzer2_x.setter
    def analyzer2_x(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch4_input.enum.analyzer2_x', int(new_val))

    @property
    def static(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch4_input.enum.static'))

    @static.setter
    def static(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch4_input.enum.static', int(new_val))

    @property
    def in_lateral(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch4_input.enum.in_lateral'))

    @in_lateral.setter
    def in_lateral(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch4_input.enum.in_lateral', int(new_val))

    @property
    def ramp_gen_tip_voltage(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch4_input.enum.ramp_gen_tip_voltage'))

    @ramp_gen_tip_voltage.setter
    def ramp_gen_tip_voltage(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch4_input.enum.ramp_gen_tip_voltage', int(new_val))

    @property
    def ramp_gen_position_y(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch4_input.enum.ramp_gen_position_y'))

    @ramp_gen_position_y.setter
    def ramp_gen_position_y(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch4_input.enum.ramp_gen_position_y', int(new_val))

    @property
    def ramp_gen_position_w(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch4_input.enum.ramp_gen_position_w'))

    @ramp_gen_position_w.setter
    def ramp_gen_position_w(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch4_input.enum.ramp_gen_position_w', int(new_val))

    @property
    def ramp_gen_ctrl_z(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch4_input.enum.ramp_gen_ctrl_z'))

    @ramp_gen_ctrl_z.setter
    def ramp_gen_ctrl_z(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch4_input.enum.ramp_gen_ctrl_z', int(new_val))

    @property
    def memory_gen_position_x(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch4_input.enum.memory_gen_position_x'))

    @memory_gen_position_x.setter
    def memory_gen_position_x(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch4_input.enum.memory_gen_position_x', int(new_val))

    @property
    def in_user3(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch4_input.enum.in_user3'))

    @in_user3.setter
    def in_user3(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch4_input.enum.in_user3', int(new_val))

    @property
    def in_position_y(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch4_input.enum.in_position_y'))

    @in_position_y.setter
    def in_position_y(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch4_input.enum.in_position_y', int(new_val))

    @property
    def in_user4(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch4_input.enum.in_user4'))

    @in_user4.setter
    def in_user4(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch4_input.enum.in_user4', int(new_val))

    @property
    def ramp_gen_max_z(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch4_input.enum.ramp_gen_max_z'))

    @ramp_gen_max_z.setter
    def ramp_gen_max_z(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch4_input.enum.ramp_gen_max_z', int(new_val))

    @property
    def ort_free_wave(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch4_input.enum.ort_free_wave'))

    @ort_free_wave.setter
    def ort_free_wave(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch4_input.enum.ort_free_wave', int(new_val))

    @property
    def ort_baseline_corrected(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch4_input.enum.ort_baseline_corrected'))

    @ort_baseline_corrected.setter
    def ort_baseline_corrected(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch4_input.enum.ort_baseline_corrected', int(new_val))

    @property
    def ort_baseline(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch4_input.enum.ort_baseline'))

    @ort_baseline.setter
    def ort_baseline(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch4_input.enum.ort_baseline', int(new_val))

    @property
    def fast_in2(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch4_input.enum.fast_in2'))

    @fast_in2.setter
    def fast_in2(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch4_input.enum.fast_in2', int(new_val))

    @property
    def ctrl_z_error(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch4_input.enum.ctrl_z_error'))

    @ctrl_z_error.setter
    def ctrl_z_error(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch4_input.enum.ctrl_z_error', int(new_val))

    @property
    def memory_gen_position_z(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch4_input.enum.memory_gen_position_z'))

    @memory_gen_position_z.setter
    def memory_gen_position_z(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch4_input.enum.memory_gen_position_z', int(new_val))

    @property
    def fast_in_user(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch4_input.enum.fast_in_user'))

    @fast_in_user.setter
    def fast_in_user(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch4_input.enum.fast_in_user', int(new_val))

    @property
    def memory_gen_position_y(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch4_input.enum.memory_gen_position_y'))

    @memory_gen_position_y.setter
    def memory_gen_position_y(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch4_input.enum.memory_gen_position_y', int(new_val))

    @property
    def analyzer2_amplitude(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch4_input.enum.analyzer2_amplitude'))

    @analyzer2_amplitude.setter
    def analyzer2_amplitude(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch4_input.enum.analyzer2_amplitude', int(new_val))

    @property
    def memory_gen_out8(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch4_input.enum.memory_gen_out8'))

    @memory_gen_out8.setter
    def memory_gen_out8(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch4_input.enum.memory_gen_out8', int(new_val))

    @property
    def memory_gen_drive_z(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch4_input.enum.memory_gen_drive_z'))

    @memory_gen_drive_z.setter
    def memory_gen_drive_z(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch4_input.enum.memory_gen_drive_z', int(new_val))

    @property
    def ramp_gen_user4(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch4_input.enum.ramp_gen_user4'))

    @ramp_gen_user4.setter
    def ramp_gen_user4(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch4_input.enum.ramp_gen_user4', int(new_val))

    @property
    def analyzer1_amplitude(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch4_input.enum.analyzer1_amplitude'))

    @analyzer1_amplitude.setter
    def analyzer1_amplitude(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch4_input.enum.analyzer1_amplitude', int(new_val))

    @property
    def in_detector_sum(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch4_input.enum.in_detector_sum'))

    @in_detector_sum.setter
    def in_detector_sum(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch4_input.enum.in_detector_sum', int(new_val))

    @property
    def ctrl_z_in(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch4_input.enum.ctrl_z_in'))

    @ctrl_z_in.setter
    def ctrl_z_in(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch4_input.enum.ctrl_z_in', int(new_val))

    @property
    def ctrl_user1_out(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch4_input.enum.ctrl_user1_out'))

    @ctrl_user1_out.setter
    def ctrl_user1_out(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch4_input.enum.ctrl_user1_out', int(new_val))


class RootLuData_acquisitionInstanceAttributeSampler_hi_res_ch4_input(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch4_input'
        self.enum = RootLuData_acquisitionInstanceAttributeSampler_hi_res_ch4_inputEnum(self._context)


class RootLuData_acquisitionInstanceAttributeSampler_filter_cutoff(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.data_acquisition.instance.attribute.sampler_filter_cutoff'


class RootLuData_acquisitionInstanceAttributeCapture_hi_res_ch2_inputEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.data_acquisition.instance.attribute.capture_hi_res_ch2_input.enum'

    @property
    def ort_adhesion_position(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch2_input.enum.ort_adhesion_position'))

    @ort_adhesion_position.setter
    def ort_adhesion_position(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch2_input.enum.ort_adhesion_position', int(new_val))

    @property
    def ctrl_z_pid_command(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch2_input.enum.ctrl_z_pid_command'))

    @ctrl_z_pid_command.setter
    def ctrl_z_pid_command(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch2_input.enum.ctrl_z_pid_command', int(new_val))

    @property
    def in6(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch2_input.enum.in6'))

    @in6.setter
    def in6(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch2_input.enum.in6', int(new_val))

    @property
    def ctrl_z_nominal(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch2_input.enum.ctrl_z_nominal'))

    @ctrl_z_nominal.setter
    def ctrl_z_nominal(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch2_input.enum.ctrl_z_nominal', int(new_val))

    @property
    def ctrl_x_out(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch2_input.enum.ctrl_x_out'))

    @ctrl_x_out.setter
    def ctrl_x_out(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch2_input.enum.ctrl_x_out', int(new_val))

    @property
    def memory_gen_drive_y(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch2_input.enum.memory_gen_drive_y'))

    @memory_gen_drive_y.setter
    def memory_gen_drive_y(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch2_input.enum.memory_gen_drive_y', int(new_val))

    @property
    def ctrl_user2_out(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch2_input.enum.ctrl_user2_out'))

    @ctrl_user2_out.setter
    def ctrl_user2_out(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch2_input.enum.ctrl_user2_out', int(new_val))

    @property
    def analyzer2_phase(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch2_input.enum.analyzer2_phase'))

    @analyzer2_phase.setter
    def analyzer2_phase(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch2_input.enum.analyzer2_phase', int(new_val))

    @property
    def fast_in_deflection(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch2_input.enum.fast_in_deflection'))

    @fast_in_deflection.setter
    def fast_in_deflection(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch2_input.enum.fast_in_deflection', int(new_val))

    @property
    def in_user2(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch2_input.enum.in_user2'))

    @in_user2.setter
    def in_user2(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch2_input.enum.in_user2', int(new_val))

    @property
    def ramp_gen_position_x(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch2_input.enum.ramp_gen_position_x'))

    @ramp_gen_position_x.setter
    def ramp_gen_position_x(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch2_input.enum.ramp_gen_position_x', int(new_val))

    @property
    def in_deflection(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch2_input.enum.in_deflection'))

    @in_deflection.setter
    def in_deflection(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch2_input.enum.in_deflection', int(new_val))

    @property
    def ort_amplitude_reduction(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch2_input.enum.ort_amplitude_reduction'))

    @ort_amplitude_reduction.setter
    def ort_amplitude_reduction(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch2_input.enum.ort_amplitude_reduction', int(new_val))

    @property
    def analyzer2_ctrl_amplitude(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch2_input.enum.analyzer2_ctrl_amplitude'))

    @analyzer2_ctrl_amplitude.setter
    def analyzer2_ctrl_amplitude(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch2_input.enum.analyzer2_ctrl_amplitude', int(new_val))

    @property
    def memory_gen_drive_x(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch2_input.enum.memory_gen_drive_x'))

    @memory_gen_drive_x.setter
    def memory_gen_drive_x(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch2_input.enum.memory_gen_drive_x', int(new_val))

    @property
    def ramp_gen_alternate_z(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch2_input.enum.ramp_gen_alternate_z'))

    @ramp_gen_alternate_z.setter
    def ramp_gen_alternate_z(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch2_input.enum.ramp_gen_alternate_z', int(new_val))

    @property
    def analyzer2_ctrl_delta_f(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch2_input.enum.analyzer2_ctrl_delta_f'))

    @analyzer2_ctrl_delta_f.setter
    def analyzer2_ctrl_delta_f(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch2_input.enum.analyzer2_ctrl_delta_f', int(new_val))

    @property
    def ort_excitation(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch2_input.enum.ort_excitation'))

    @ort_excitation.setter
    def ort_excitation(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch2_input.enum.ort_excitation', int(new_val))

    @property
    def analyzer1_y(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch2_input.enum.analyzer1_y'))

    @analyzer1_y.setter
    def analyzer1_y(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch2_input.enum.analyzer1_y', int(new_val))

    @property
    def ort_adhesion_value(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch2_input.enum.ort_adhesion_value'))

    @ort_adhesion_value.setter
    def ort_adhesion_value(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch2_input.enum.ort_adhesion_value', int(new_val))

    @property
    def ctrl_y_out(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch2_input.enum.ctrl_y_out'))

    @ctrl_y_out.setter
    def ctrl_y_out(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch2_input.enum.ctrl_y_out', int(new_val))

    @property
    def analyzer1_phase(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch2_input.enum.analyzer1_phase'))

    @analyzer1_phase.setter
    def analyzer1_phase(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch2_input.enum.analyzer1_phase', int(new_val))

    @property
    def ctrl_z_out(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch2_input.enum.ctrl_z_out'))

    @ctrl_z_out.setter
    def ctrl_z_out(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch2_input.enum.ctrl_z_out', int(new_val))

    @property
    def ctrl_w_out(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch2_input.enum.ctrl_w_out'))

    @ctrl_w_out.setter
    def ctrl_w_out(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch2_input.enum.ctrl_w_out', int(new_val))

    @property
    def analyzer1_ctrl_amplitude(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch2_input.enum.analyzer1_ctrl_amplitude'))

    @analyzer1_ctrl_amplitude.setter
    def analyzer1_ctrl_amplitude(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch2_input.enum.analyzer1_ctrl_amplitude', int(new_val))

    @property
    def in_user1(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch2_input.enum.in_user1'))

    @in_user1.setter
    def in_user1(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch2_input.enum.in_user1', int(new_val))

    @property
    def ramp_gen_approach(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch2_input.enum.ramp_gen_approach'))

    @ramp_gen_approach.setter
    def ramp_gen_approach(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch2_input.enum.ramp_gen_approach', int(new_val))

    @property
    def ramp_gen_test(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch2_input.enum.ramp_gen_test'))

    @ramp_gen_test.setter
    def ramp_gen_test(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch2_input.enum.ramp_gen_test', int(new_val))

    @property
    def in_position_x(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch2_input.enum.in_position_x'))

    @in_position_x.setter
    def in_position_x(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch2_input.enum.in_position_x', int(new_val))

    @property
    def analyzer1_reference(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch2_input.enum.analyzer1_reference'))

    @analyzer1_reference.setter
    def analyzer1_reference(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch2_input.enum.analyzer1_reference', int(new_val))

    @property
    def ramp_gen_plane_z(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch2_input.enum.ramp_gen_plane_z'))

    @ramp_gen_plane_z.setter
    def ramp_gen_plane_z(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch2_input.enum.ramp_gen_plane_z', int(new_val))

    @property
    def memory_gen_out7(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch2_input.enum.memory_gen_out7'))

    @memory_gen_out7.setter
    def memory_gen_out7(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch2_input.enum.memory_gen_out7', int(new_val))

    @property
    def analyzer2_y(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch2_input.enum.analyzer2_y'))

    @analyzer2_y.setter
    def analyzer2_y(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch2_input.enum.analyzer2_y', int(new_val))

    @property
    def gen_test_dynamic(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch2_input.enum.gen_test_dynamic'))

    @gen_test_dynamic.setter
    def gen_test_dynamic(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch2_input.enum.gen_test_dynamic', int(new_val))

    @property
    def in_tip_current(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch2_input.enum.in_tip_current'))

    @in_tip_current.setter
    def in_tip_current(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch2_input.enum.in_tip_current', int(new_val))

    @property
    def analyzer1_x(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch2_input.enum.analyzer1_x'))

    @analyzer1_x.setter
    def analyzer1_x(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch2_input.enum.analyzer1_x', int(new_val))

    @property
    def ctrl_z_sum(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch2_input.enum.ctrl_z_sum'))

    @ctrl_z_sum.setter
    def ctrl_z_sum(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch2_input.enum.ctrl_z_sum', int(new_val))

    @property
    def analyzer2_reference(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch2_input.enum.analyzer2_reference'))

    @analyzer2_reference.setter
    def analyzer2_reference(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch2_input.enum.analyzer2_reference', int(new_val))

    @property
    def analyzer1_ctrl_delta_f(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch2_input.enum.analyzer1_ctrl_delta_f'))

    @analyzer1_ctrl_delta_f.setter
    def analyzer1_ctrl_delta_f(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch2_input.enum.analyzer1_ctrl_delta_f', int(new_val))

    @property
    def in_position_z(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch2_input.enum.in_position_z'))

    @in_position_z.setter
    def in_position_z(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch2_input.enum.in_position_z', int(new_val))

    @property
    def analyzer2_x(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch2_input.enum.analyzer2_x'))

    @analyzer2_x.setter
    def analyzer2_x(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch2_input.enum.analyzer2_x', int(new_val))

    @property
    def static(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch2_input.enum.static'))

    @static.setter
    def static(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch2_input.enum.static', int(new_val))

    @property
    def in_lateral(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch2_input.enum.in_lateral'))

    @in_lateral.setter
    def in_lateral(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch2_input.enum.in_lateral', int(new_val))

    @property
    def ramp_gen_tip_voltage(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch2_input.enum.ramp_gen_tip_voltage'))

    @ramp_gen_tip_voltage.setter
    def ramp_gen_tip_voltage(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch2_input.enum.ramp_gen_tip_voltage', int(new_val))

    @property
    def ramp_gen_position_y(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch2_input.enum.ramp_gen_position_y'))

    @ramp_gen_position_y.setter
    def ramp_gen_position_y(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch2_input.enum.ramp_gen_position_y', int(new_val))

    @property
    def ramp_gen_position_w(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch2_input.enum.ramp_gen_position_w'))

    @ramp_gen_position_w.setter
    def ramp_gen_position_w(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch2_input.enum.ramp_gen_position_w', int(new_val))

    @property
    def ramp_gen_ctrl_z(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch2_input.enum.ramp_gen_ctrl_z'))

    @ramp_gen_ctrl_z.setter
    def ramp_gen_ctrl_z(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch2_input.enum.ramp_gen_ctrl_z', int(new_val))

    @property
    def memory_gen_position_x(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch2_input.enum.memory_gen_position_x'))

    @memory_gen_position_x.setter
    def memory_gen_position_x(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch2_input.enum.memory_gen_position_x', int(new_val))

    @property
    def in_user3(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch2_input.enum.in_user3'))

    @in_user3.setter
    def in_user3(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch2_input.enum.in_user3', int(new_val))

    @property
    def in_position_y(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch2_input.enum.in_position_y'))

    @in_position_y.setter
    def in_position_y(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch2_input.enum.in_position_y', int(new_val))

    @property
    def in_user4(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch2_input.enum.in_user4'))

    @in_user4.setter
    def in_user4(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch2_input.enum.in_user4', int(new_val))

    @property
    def ramp_gen_max_z(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch2_input.enum.ramp_gen_max_z'))

    @ramp_gen_max_z.setter
    def ramp_gen_max_z(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch2_input.enum.ramp_gen_max_z', int(new_val))

    @property
    def ort_free_wave(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch2_input.enum.ort_free_wave'))

    @ort_free_wave.setter
    def ort_free_wave(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch2_input.enum.ort_free_wave', int(new_val))

    @property
    def ort_baseline_corrected(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch2_input.enum.ort_baseline_corrected'))

    @ort_baseline_corrected.setter
    def ort_baseline_corrected(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch2_input.enum.ort_baseline_corrected', int(new_val))

    @property
    def ort_baseline(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch2_input.enum.ort_baseline'))

    @ort_baseline.setter
    def ort_baseline(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch2_input.enum.ort_baseline', int(new_val))

    @property
    def fast_in2(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch2_input.enum.fast_in2'))

    @fast_in2.setter
    def fast_in2(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch2_input.enum.fast_in2', int(new_val))

    @property
    def ctrl_z_error(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch2_input.enum.ctrl_z_error'))

    @ctrl_z_error.setter
    def ctrl_z_error(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch2_input.enum.ctrl_z_error', int(new_val))

    @property
    def memory_gen_position_z(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch2_input.enum.memory_gen_position_z'))

    @memory_gen_position_z.setter
    def memory_gen_position_z(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch2_input.enum.memory_gen_position_z', int(new_val))

    @property
    def fast_in_user(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch2_input.enum.fast_in_user'))

    @fast_in_user.setter
    def fast_in_user(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch2_input.enum.fast_in_user', int(new_val))

    @property
    def memory_gen_position_y(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch2_input.enum.memory_gen_position_y'))

    @memory_gen_position_y.setter
    def memory_gen_position_y(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch2_input.enum.memory_gen_position_y', int(new_val))

    @property
    def analyzer2_amplitude(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch2_input.enum.analyzer2_amplitude'))

    @analyzer2_amplitude.setter
    def analyzer2_amplitude(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch2_input.enum.analyzer2_amplitude', int(new_val))

    @property
    def memory_gen_out8(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch2_input.enum.memory_gen_out8'))

    @memory_gen_out8.setter
    def memory_gen_out8(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch2_input.enum.memory_gen_out8', int(new_val))

    @property
    def memory_gen_drive_z(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch2_input.enum.memory_gen_drive_z'))

    @memory_gen_drive_z.setter
    def memory_gen_drive_z(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch2_input.enum.memory_gen_drive_z', int(new_val))

    @property
    def ramp_gen_user4(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch2_input.enum.ramp_gen_user4'))

    @ramp_gen_user4.setter
    def ramp_gen_user4(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch2_input.enum.ramp_gen_user4', int(new_val))

    @property
    def analyzer1_amplitude(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch2_input.enum.analyzer1_amplitude'))

    @analyzer1_amplitude.setter
    def analyzer1_amplitude(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch2_input.enum.analyzer1_amplitude', int(new_val))

    @property
    def in_detector_sum(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch2_input.enum.in_detector_sum'))

    @in_detector_sum.setter
    def in_detector_sum(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch2_input.enum.in_detector_sum', int(new_val))

    @property
    def ctrl_z_in(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch2_input.enum.ctrl_z_in'))

    @ctrl_z_in.setter
    def ctrl_z_in(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch2_input.enum.ctrl_z_in', int(new_val))

    @property
    def ctrl_user1_out(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch2_input.enum.ctrl_user1_out'))

    @ctrl_user1_out.setter
    def ctrl_user1_out(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch2_input.enum.ctrl_user1_out', int(new_val))


class RootLuData_acquisitionInstanceAttributeCapture_hi_res_ch2_input(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.data_acquisition.instance.attribute.capture_hi_res_ch2_input'
        self.enum = RootLuData_acquisitionInstanceAttributeCapture_hi_res_ch2_inputEnum(self._context)


class RootLuData_acquisitionInstanceAttributeNumber_of_sampler_sets(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.data_acquisition.instance.attribute.number_of_sampler_sets'


class RootLuData_acquisitionInstanceAttributeSampler_hi_res_ch_input_vecEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch_input_vec.enum'

    @property
    def ort_adhesion_position(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch_input_vec.enum.ort_adhesion_position'))

    @ort_adhesion_position.setter
    def ort_adhesion_position(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch_input_vec.enum.ort_adhesion_position', int(new_val))

    @property
    def ctrl_z_pid_command(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch_input_vec.enum.ctrl_z_pid_command'))

    @ctrl_z_pid_command.setter
    def ctrl_z_pid_command(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch_input_vec.enum.ctrl_z_pid_command', int(new_val))

    @property
    def in6(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch_input_vec.enum.in6'))

    @in6.setter
    def in6(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch_input_vec.enum.in6', int(new_val))

    @property
    def ctrl_z_nominal(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch_input_vec.enum.ctrl_z_nominal'))

    @ctrl_z_nominal.setter
    def ctrl_z_nominal(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch_input_vec.enum.ctrl_z_nominal', int(new_val))

    @property
    def ctrl_x_out(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch_input_vec.enum.ctrl_x_out'))

    @ctrl_x_out.setter
    def ctrl_x_out(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch_input_vec.enum.ctrl_x_out', int(new_val))

    @property
    def memory_gen_drive_y(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch_input_vec.enum.memory_gen_drive_y'))

    @memory_gen_drive_y.setter
    def memory_gen_drive_y(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch_input_vec.enum.memory_gen_drive_y', int(new_val))

    @property
    def ctrl_user2_out(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch_input_vec.enum.ctrl_user2_out'))

    @ctrl_user2_out.setter
    def ctrl_user2_out(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch_input_vec.enum.ctrl_user2_out', int(new_val))

    @property
    def analyzer2_phase(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch_input_vec.enum.analyzer2_phase'))

    @analyzer2_phase.setter
    def analyzer2_phase(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch_input_vec.enum.analyzer2_phase', int(new_val))

    @property
    def fast_in_deflection(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch_input_vec.enum.fast_in_deflection'))

    @fast_in_deflection.setter
    def fast_in_deflection(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch_input_vec.enum.fast_in_deflection', int(new_val))

    @property
    def in_user2(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch_input_vec.enum.in_user2'))

    @in_user2.setter
    def in_user2(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch_input_vec.enum.in_user2', int(new_val))

    @property
    def ramp_gen_position_x(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch_input_vec.enum.ramp_gen_position_x'))

    @ramp_gen_position_x.setter
    def ramp_gen_position_x(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch_input_vec.enum.ramp_gen_position_x', int(new_val))

    @property
    def in_deflection(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch_input_vec.enum.in_deflection'))

    @in_deflection.setter
    def in_deflection(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch_input_vec.enum.in_deflection', int(new_val))

    @property
    def ort_amplitude_reduction(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch_input_vec.enum.ort_amplitude_reduction'))

    @ort_amplitude_reduction.setter
    def ort_amplitude_reduction(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch_input_vec.enum.ort_amplitude_reduction', int(new_val))

    @property
    def analyzer2_ctrl_amplitude(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch_input_vec.enum.analyzer2_ctrl_amplitude'))

    @analyzer2_ctrl_amplitude.setter
    def analyzer2_ctrl_amplitude(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch_input_vec.enum.analyzer2_ctrl_amplitude', int(new_val))

    @property
    def memory_gen_drive_x(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch_input_vec.enum.memory_gen_drive_x'))

    @memory_gen_drive_x.setter
    def memory_gen_drive_x(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch_input_vec.enum.memory_gen_drive_x', int(new_val))

    @property
    def ramp_gen_alternate_z(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch_input_vec.enum.ramp_gen_alternate_z'))

    @ramp_gen_alternate_z.setter
    def ramp_gen_alternate_z(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch_input_vec.enum.ramp_gen_alternate_z', int(new_val))

    @property
    def analyzer2_ctrl_delta_f(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch_input_vec.enum.analyzer2_ctrl_delta_f'))

    @analyzer2_ctrl_delta_f.setter
    def analyzer2_ctrl_delta_f(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch_input_vec.enum.analyzer2_ctrl_delta_f', int(new_val))

    @property
    def ort_excitation(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch_input_vec.enum.ort_excitation'))

    @ort_excitation.setter
    def ort_excitation(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch_input_vec.enum.ort_excitation', int(new_val))

    @property
    def analyzer1_y(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch_input_vec.enum.analyzer1_y'))

    @analyzer1_y.setter
    def analyzer1_y(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch_input_vec.enum.analyzer1_y', int(new_val))

    @property
    def ort_adhesion_value(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch_input_vec.enum.ort_adhesion_value'))

    @ort_adhesion_value.setter
    def ort_adhesion_value(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch_input_vec.enum.ort_adhesion_value', int(new_val))

    @property
    def ctrl_y_out(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch_input_vec.enum.ctrl_y_out'))

    @ctrl_y_out.setter
    def ctrl_y_out(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch_input_vec.enum.ctrl_y_out', int(new_val))

    @property
    def analyzer1_phase(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch_input_vec.enum.analyzer1_phase'))

    @analyzer1_phase.setter
    def analyzer1_phase(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch_input_vec.enum.analyzer1_phase', int(new_val))

    @property
    def ctrl_z_out(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch_input_vec.enum.ctrl_z_out'))

    @ctrl_z_out.setter
    def ctrl_z_out(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch_input_vec.enum.ctrl_z_out', int(new_val))

    @property
    def ctrl_w_out(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch_input_vec.enum.ctrl_w_out'))

    @ctrl_w_out.setter
    def ctrl_w_out(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch_input_vec.enum.ctrl_w_out', int(new_val))

    @property
    def analyzer1_ctrl_amplitude(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch_input_vec.enum.analyzer1_ctrl_amplitude'))

    @analyzer1_ctrl_amplitude.setter
    def analyzer1_ctrl_amplitude(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch_input_vec.enum.analyzer1_ctrl_amplitude', int(new_val))

    @property
    def in_user1(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch_input_vec.enum.in_user1'))

    @in_user1.setter
    def in_user1(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch_input_vec.enum.in_user1', int(new_val))

    @property
    def ramp_gen_approach(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch_input_vec.enum.ramp_gen_approach'))

    @ramp_gen_approach.setter
    def ramp_gen_approach(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch_input_vec.enum.ramp_gen_approach', int(new_val))

    @property
    def ramp_gen_test(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch_input_vec.enum.ramp_gen_test'))

    @ramp_gen_test.setter
    def ramp_gen_test(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch_input_vec.enum.ramp_gen_test', int(new_val))

    @property
    def in_position_x(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch_input_vec.enum.in_position_x'))

    @in_position_x.setter
    def in_position_x(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch_input_vec.enum.in_position_x', int(new_val))

    @property
    def analyzer1_reference(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch_input_vec.enum.analyzer1_reference'))

    @analyzer1_reference.setter
    def analyzer1_reference(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch_input_vec.enum.analyzer1_reference', int(new_val))

    @property
    def ramp_gen_plane_z(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch_input_vec.enum.ramp_gen_plane_z'))

    @ramp_gen_plane_z.setter
    def ramp_gen_plane_z(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch_input_vec.enum.ramp_gen_plane_z', int(new_val))

    @property
    def memory_gen_out7(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch_input_vec.enum.memory_gen_out7'))

    @memory_gen_out7.setter
    def memory_gen_out7(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch_input_vec.enum.memory_gen_out7', int(new_val))

    @property
    def analyzer2_y(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch_input_vec.enum.analyzer2_y'))

    @analyzer2_y.setter
    def analyzer2_y(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch_input_vec.enum.analyzer2_y', int(new_val))

    @property
    def gen_test_dynamic(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch_input_vec.enum.gen_test_dynamic'))

    @gen_test_dynamic.setter
    def gen_test_dynamic(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch_input_vec.enum.gen_test_dynamic', int(new_val))

    @property
    def in_tip_current(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch_input_vec.enum.in_tip_current'))

    @in_tip_current.setter
    def in_tip_current(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch_input_vec.enum.in_tip_current', int(new_val))

    @property
    def analyzer1_x(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch_input_vec.enum.analyzer1_x'))

    @analyzer1_x.setter
    def analyzer1_x(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch_input_vec.enum.analyzer1_x', int(new_val))

    @property
    def ctrl_z_sum(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch_input_vec.enum.ctrl_z_sum'))

    @ctrl_z_sum.setter
    def ctrl_z_sum(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch_input_vec.enum.ctrl_z_sum', int(new_val))

    @property
    def analyzer2_reference(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch_input_vec.enum.analyzer2_reference'))

    @analyzer2_reference.setter
    def analyzer2_reference(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch_input_vec.enum.analyzer2_reference', int(new_val))

    @property
    def analyzer1_ctrl_delta_f(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch_input_vec.enum.analyzer1_ctrl_delta_f'))

    @analyzer1_ctrl_delta_f.setter
    def analyzer1_ctrl_delta_f(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch_input_vec.enum.analyzer1_ctrl_delta_f', int(new_val))

    @property
    def in_position_z(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch_input_vec.enum.in_position_z'))

    @in_position_z.setter
    def in_position_z(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch_input_vec.enum.in_position_z', int(new_val))

    @property
    def analyzer2_x(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch_input_vec.enum.analyzer2_x'))

    @analyzer2_x.setter
    def analyzer2_x(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch_input_vec.enum.analyzer2_x', int(new_val))

    @property
    def static(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch_input_vec.enum.static'))

    @static.setter
    def static(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch_input_vec.enum.static', int(new_val))

    @property
    def in_lateral(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch_input_vec.enum.in_lateral'))

    @in_lateral.setter
    def in_lateral(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch_input_vec.enum.in_lateral', int(new_val))

    @property
    def ramp_gen_tip_voltage(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch_input_vec.enum.ramp_gen_tip_voltage'))

    @ramp_gen_tip_voltage.setter
    def ramp_gen_tip_voltage(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch_input_vec.enum.ramp_gen_tip_voltage', int(new_val))

    @property
    def ramp_gen_position_y(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch_input_vec.enum.ramp_gen_position_y'))

    @ramp_gen_position_y.setter
    def ramp_gen_position_y(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch_input_vec.enum.ramp_gen_position_y', int(new_val))

    @property
    def ramp_gen_position_w(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch_input_vec.enum.ramp_gen_position_w'))

    @ramp_gen_position_w.setter
    def ramp_gen_position_w(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch_input_vec.enum.ramp_gen_position_w', int(new_val))

    @property
    def ramp_gen_ctrl_z(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch_input_vec.enum.ramp_gen_ctrl_z'))

    @ramp_gen_ctrl_z.setter
    def ramp_gen_ctrl_z(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch_input_vec.enum.ramp_gen_ctrl_z', int(new_val))

    @property
    def memory_gen_position_x(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch_input_vec.enum.memory_gen_position_x'))

    @memory_gen_position_x.setter
    def memory_gen_position_x(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch_input_vec.enum.memory_gen_position_x', int(new_val))

    @property
    def in_user3(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch_input_vec.enum.in_user3'))

    @in_user3.setter
    def in_user3(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch_input_vec.enum.in_user3', int(new_val))

    @property
    def in_position_y(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch_input_vec.enum.in_position_y'))

    @in_position_y.setter
    def in_position_y(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch_input_vec.enum.in_position_y', int(new_val))

    @property
    def in_user4(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch_input_vec.enum.in_user4'))

    @in_user4.setter
    def in_user4(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch_input_vec.enum.in_user4', int(new_val))

    @property
    def ramp_gen_max_z(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch_input_vec.enum.ramp_gen_max_z'))

    @ramp_gen_max_z.setter
    def ramp_gen_max_z(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch_input_vec.enum.ramp_gen_max_z', int(new_val))

    @property
    def ort_free_wave(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch_input_vec.enum.ort_free_wave'))

    @ort_free_wave.setter
    def ort_free_wave(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch_input_vec.enum.ort_free_wave', int(new_val))

    @property
    def ort_baseline_corrected(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch_input_vec.enum.ort_baseline_corrected'))

    @ort_baseline_corrected.setter
    def ort_baseline_corrected(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch_input_vec.enum.ort_baseline_corrected', int(new_val))

    @property
    def ort_baseline(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch_input_vec.enum.ort_baseline'))

    @ort_baseline.setter
    def ort_baseline(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch_input_vec.enum.ort_baseline', int(new_val))

    @property
    def fast_in2(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch_input_vec.enum.fast_in2'))

    @fast_in2.setter
    def fast_in2(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch_input_vec.enum.fast_in2', int(new_val))

    @property
    def ctrl_z_error(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch_input_vec.enum.ctrl_z_error'))

    @ctrl_z_error.setter
    def ctrl_z_error(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch_input_vec.enum.ctrl_z_error', int(new_val))

    @property
    def memory_gen_position_z(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch_input_vec.enum.memory_gen_position_z'))

    @memory_gen_position_z.setter
    def memory_gen_position_z(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch_input_vec.enum.memory_gen_position_z', int(new_val))

    @property
    def fast_in_user(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch_input_vec.enum.fast_in_user'))

    @fast_in_user.setter
    def fast_in_user(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch_input_vec.enum.fast_in_user', int(new_val))

    @property
    def memory_gen_position_y(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch_input_vec.enum.memory_gen_position_y'))

    @memory_gen_position_y.setter
    def memory_gen_position_y(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch_input_vec.enum.memory_gen_position_y', int(new_val))

    @property
    def analyzer2_amplitude(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch_input_vec.enum.analyzer2_amplitude'))

    @analyzer2_amplitude.setter
    def analyzer2_amplitude(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch_input_vec.enum.analyzer2_amplitude', int(new_val))

    @property
    def memory_gen_out8(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch_input_vec.enum.memory_gen_out8'))

    @memory_gen_out8.setter
    def memory_gen_out8(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch_input_vec.enum.memory_gen_out8', int(new_val))

    @property
    def memory_gen_drive_z(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch_input_vec.enum.memory_gen_drive_z'))

    @memory_gen_drive_z.setter
    def memory_gen_drive_z(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch_input_vec.enum.memory_gen_drive_z', int(new_val))

    @property
    def ramp_gen_user4(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch_input_vec.enum.ramp_gen_user4'))

    @ramp_gen_user4.setter
    def ramp_gen_user4(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch_input_vec.enum.ramp_gen_user4', int(new_val))

    @property
    def analyzer1_amplitude(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch_input_vec.enum.analyzer1_amplitude'))

    @analyzer1_amplitude.setter
    def analyzer1_amplitude(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch_input_vec.enum.analyzer1_amplitude', int(new_val))

    @property
    def in_detector_sum(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch_input_vec.enum.in_detector_sum'))

    @in_detector_sum.setter
    def in_detector_sum(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch_input_vec.enum.in_detector_sum', int(new_val))

    @property
    def ctrl_z_in(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch_input_vec.enum.ctrl_z_in'))

    @ctrl_z_in.setter
    def ctrl_z_in(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch_input_vec.enum.ctrl_z_in', int(new_val))

    @property
    def ctrl_user1_out(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch_input_vec.enum.ctrl_user1_out'))

    @ctrl_user1_out.setter
    def ctrl_user1_out(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch_input_vec.enum.ctrl_user1_out', int(new_val))


class RootLuData_acquisitionInstanceAttributeSampler_hi_res_ch_input_vec(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch_input_vec'
        self.enum = RootLuData_acquisitionInstanceAttributeSampler_hi_res_ch_input_vecEnum(self._context)


class RootLuData_acquisitionInstanceAttributeNumber_of_capture_sets(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.data_acquisition.instance.attribute.number_of_capture_sets'


class RootLuData_acquisitionInstanceAttributeCapture_fast_ch0_inputEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.data_acquisition.instance.attribute.capture_fast_ch0_input.enum'

    @property
    def in2(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_fast_ch0_input.enum.in2'))

    @in2.setter
    def in2(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_fast_ch0_input.enum.in2', int(new_val))

    @property
    def in_deflection(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_fast_ch0_input.enum.in_deflection'))

    @in_deflection.setter
    def in_deflection(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_fast_ch0_input.enum.in_deflection', int(new_val))

    @property
    def ctrl_z_out(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_fast_ch0_input.enum.ctrl_z_out'))

    @ctrl_z_out.setter
    def ctrl_z_out(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_fast_ch0_input.enum.ctrl_z_out', int(new_val))

    @property
    def analyzer1_reference(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_fast_ch0_input.enum.analyzer1_reference'))

    @analyzer1_reference.setter
    def analyzer1_reference(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_fast_ch0_input.enum.analyzer1_reference', int(new_val))

    @property
    def ort_free_wave(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_fast_ch0_input.enum.ort_free_wave'))

    @ort_free_wave.setter
    def ort_free_wave(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_fast_ch0_input.enum.ort_free_wave', int(new_val))

    @property
    def ctrl_w_out(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_fast_ch0_input.enum.ctrl_w_out'))

    @ctrl_w_out.setter
    def ctrl_w_out(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_fast_ch0_input.enum.ctrl_w_out', int(new_val))

    @property
    def in_user(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_fast_ch0_input.enum.in_user'))

    @in_user.setter
    def in_user(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_fast_ch0_input.enum.in_user', int(new_val))

    @property
    def ort_excitation(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_fast_ch0_input.enum.ort_excitation'))

    @ort_excitation.setter
    def ort_excitation(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_fast_ch0_input.enum.ort_excitation', int(new_val))

    @property
    def analyzer2_reference(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_fast_ch0_input.enum.analyzer2_reference'))

    @analyzer2_reference.setter
    def analyzer2_reference(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_fast_ch0_input.enum.analyzer2_reference', int(new_val))


class RootLuData_acquisitionInstanceAttributeCapture_fast_ch0_input(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.data_acquisition.instance.attribute.capture_fast_ch0_input'
        self.enum = RootLuData_acquisitionInstanceAttributeCapture_fast_ch0_inputEnum(self._context)


class RootLuData_acquisitionInstanceAttributeCapture_hi_res_ch0_inputEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.data_acquisition.instance.attribute.capture_hi_res_ch0_input.enum'

    @property
    def ort_adhesion_position(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch0_input.enum.ort_adhesion_position'))

    @ort_adhesion_position.setter
    def ort_adhesion_position(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch0_input.enum.ort_adhesion_position', int(new_val))

    @property
    def ctrl_z_pid_command(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch0_input.enum.ctrl_z_pid_command'))

    @ctrl_z_pid_command.setter
    def ctrl_z_pid_command(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch0_input.enum.ctrl_z_pid_command', int(new_val))

    @property
    def in6(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch0_input.enum.in6'))

    @in6.setter
    def in6(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch0_input.enum.in6', int(new_val))

    @property
    def ctrl_z_nominal(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch0_input.enum.ctrl_z_nominal'))

    @ctrl_z_nominal.setter
    def ctrl_z_nominal(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch0_input.enum.ctrl_z_nominal', int(new_val))

    @property
    def ctrl_x_out(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch0_input.enum.ctrl_x_out'))

    @ctrl_x_out.setter
    def ctrl_x_out(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch0_input.enum.ctrl_x_out', int(new_val))

    @property
    def memory_gen_drive_y(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch0_input.enum.memory_gen_drive_y'))

    @memory_gen_drive_y.setter
    def memory_gen_drive_y(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch0_input.enum.memory_gen_drive_y', int(new_val))

    @property
    def ctrl_user2_out(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch0_input.enum.ctrl_user2_out'))

    @ctrl_user2_out.setter
    def ctrl_user2_out(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch0_input.enum.ctrl_user2_out', int(new_val))

    @property
    def analyzer2_phase(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch0_input.enum.analyzer2_phase'))

    @analyzer2_phase.setter
    def analyzer2_phase(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch0_input.enum.analyzer2_phase', int(new_val))

    @property
    def fast_in_deflection(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch0_input.enum.fast_in_deflection'))

    @fast_in_deflection.setter
    def fast_in_deflection(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch0_input.enum.fast_in_deflection', int(new_val))

    @property
    def in_user2(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch0_input.enum.in_user2'))

    @in_user2.setter
    def in_user2(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch0_input.enum.in_user2', int(new_val))

    @property
    def ramp_gen_position_x(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch0_input.enum.ramp_gen_position_x'))

    @ramp_gen_position_x.setter
    def ramp_gen_position_x(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch0_input.enum.ramp_gen_position_x', int(new_val))

    @property
    def in_deflection(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch0_input.enum.in_deflection'))

    @in_deflection.setter
    def in_deflection(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch0_input.enum.in_deflection', int(new_val))

    @property
    def ort_amplitude_reduction(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch0_input.enum.ort_amplitude_reduction'))

    @ort_amplitude_reduction.setter
    def ort_amplitude_reduction(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch0_input.enum.ort_amplitude_reduction', int(new_val))

    @property
    def analyzer2_ctrl_amplitude(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch0_input.enum.analyzer2_ctrl_amplitude'))

    @analyzer2_ctrl_amplitude.setter
    def analyzer2_ctrl_amplitude(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch0_input.enum.analyzer2_ctrl_amplitude', int(new_val))

    @property
    def memory_gen_drive_x(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch0_input.enum.memory_gen_drive_x'))

    @memory_gen_drive_x.setter
    def memory_gen_drive_x(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch0_input.enum.memory_gen_drive_x', int(new_val))

    @property
    def ramp_gen_alternate_z(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch0_input.enum.ramp_gen_alternate_z'))

    @ramp_gen_alternate_z.setter
    def ramp_gen_alternate_z(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch0_input.enum.ramp_gen_alternate_z', int(new_val))

    @property
    def analyzer2_ctrl_delta_f(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch0_input.enum.analyzer2_ctrl_delta_f'))

    @analyzer2_ctrl_delta_f.setter
    def analyzer2_ctrl_delta_f(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch0_input.enum.analyzer2_ctrl_delta_f', int(new_val))

    @property
    def ort_excitation(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch0_input.enum.ort_excitation'))

    @ort_excitation.setter
    def ort_excitation(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch0_input.enum.ort_excitation', int(new_val))

    @property
    def analyzer1_y(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch0_input.enum.analyzer1_y'))

    @analyzer1_y.setter
    def analyzer1_y(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch0_input.enum.analyzer1_y', int(new_val))

    @property
    def ort_adhesion_value(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch0_input.enum.ort_adhesion_value'))

    @ort_adhesion_value.setter
    def ort_adhesion_value(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch0_input.enum.ort_adhesion_value', int(new_val))

    @property
    def ctrl_y_out(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch0_input.enum.ctrl_y_out'))

    @ctrl_y_out.setter
    def ctrl_y_out(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch0_input.enum.ctrl_y_out', int(new_val))

    @property
    def analyzer1_phase(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch0_input.enum.analyzer1_phase'))

    @analyzer1_phase.setter
    def analyzer1_phase(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch0_input.enum.analyzer1_phase', int(new_val))

    @property
    def ctrl_z_out(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch0_input.enum.ctrl_z_out'))

    @ctrl_z_out.setter
    def ctrl_z_out(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch0_input.enum.ctrl_z_out', int(new_val))

    @property
    def ctrl_w_out(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch0_input.enum.ctrl_w_out'))

    @ctrl_w_out.setter
    def ctrl_w_out(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch0_input.enum.ctrl_w_out', int(new_val))

    @property
    def analyzer1_ctrl_amplitude(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch0_input.enum.analyzer1_ctrl_amplitude'))

    @analyzer1_ctrl_amplitude.setter
    def analyzer1_ctrl_amplitude(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch0_input.enum.analyzer1_ctrl_amplitude', int(new_val))

    @property
    def in_user1(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch0_input.enum.in_user1'))

    @in_user1.setter
    def in_user1(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch0_input.enum.in_user1', int(new_val))

    @property
    def ramp_gen_approach(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch0_input.enum.ramp_gen_approach'))

    @ramp_gen_approach.setter
    def ramp_gen_approach(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch0_input.enum.ramp_gen_approach', int(new_val))

    @property
    def ramp_gen_test(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch0_input.enum.ramp_gen_test'))

    @ramp_gen_test.setter
    def ramp_gen_test(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch0_input.enum.ramp_gen_test', int(new_val))

    @property
    def in_position_x(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch0_input.enum.in_position_x'))

    @in_position_x.setter
    def in_position_x(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch0_input.enum.in_position_x', int(new_val))

    @property
    def analyzer1_reference(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch0_input.enum.analyzer1_reference'))

    @analyzer1_reference.setter
    def analyzer1_reference(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch0_input.enum.analyzer1_reference', int(new_val))

    @property
    def ramp_gen_plane_z(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch0_input.enum.ramp_gen_plane_z'))

    @ramp_gen_plane_z.setter
    def ramp_gen_plane_z(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch0_input.enum.ramp_gen_plane_z', int(new_val))

    @property
    def memory_gen_out7(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch0_input.enum.memory_gen_out7'))

    @memory_gen_out7.setter
    def memory_gen_out7(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch0_input.enum.memory_gen_out7', int(new_val))

    @property
    def analyzer2_y(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch0_input.enum.analyzer2_y'))

    @analyzer2_y.setter
    def analyzer2_y(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch0_input.enum.analyzer2_y', int(new_val))

    @property
    def gen_test_dynamic(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch0_input.enum.gen_test_dynamic'))

    @gen_test_dynamic.setter
    def gen_test_dynamic(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch0_input.enum.gen_test_dynamic', int(new_val))

    @property
    def in_tip_current(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch0_input.enum.in_tip_current'))

    @in_tip_current.setter
    def in_tip_current(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch0_input.enum.in_tip_current', int(new_val))

    @property
    def analyzer1_x(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch0_input.enum.analyzer1_x'))

    @analyzer1_x.setter
    def analyzer1_x(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch0_input.enum.analyzer1_x', int(new_val))

    @property
    def ctrl_z_sum(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch0_input.enum.ctrl_z_sum'))

    @ctrl_z_sum.setter
    def ctrl_z_sum(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch0_input.enum.ctrl_z_sum', int(new_val))

    @property
    def analyzer2_reference(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch0_input.enum.analyzer2_reference'))

    @analyzer2_reference.setter
    def analyzer2_reference(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch0_input.enum.analyzer2_reference', int(new_val))

    @property
    def analyzer1_ctrl_delta_f(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch0_input.enum.analyzer1_ctrl_delta_f'))

    @analyzer1_ctrl_delta_f.setter
    def analyzer1_ctrl_delta_f(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch0_input.enum.analyzer1_ctrl_delta_f', int(new_val))

    @property
    def in_position_z(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch0_input.enum.in_position_z'))

    @in_position_z.setter
    def in_position_z(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch0_input.enum.in_position_z', int(new_val))

    @property
    def analyzer2_x(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch0_input.enum.analyzer2_x'))

    @analyzer2_x.setter
    def analyzer2_x(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch0_input.enum.analyzer2_x', int(new_val))

    @property
    def static(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch0_input.enum.static'))

    @static.setter
    def static(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch0_input.enum.static', int(new_val))

    @property
    def in_lateral(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch0_input.enum.in_lateral'))

    @in_lateral.setter
    def in_lateral(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch0_input.enum.in_lateral', int(new_val))

    @property
    def ramp_gen_tip_voltage(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch0_input.enum.ramp_gen_tip_voltage'))

    @ramp_gen_tip_voltage.setter
    def ramp_gen_tip_voltage(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch0_input.enum.ramp_gen_tip_voltage', int(new_val))

    @property
    def ramp_gen_position_y(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch0_input.enum.ramp_gen_position_y'))

    @ramp_gen_position_y.setter
    def ramp_gen_position_y(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch0_input.enum.ramp_gen_position_y', int(new_val))

    @property
    def ramp_gen_position_w(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch0_input.enum.ramp_gen_position_w'))

    @ramp_gen_position_w.setter
    def ramp_gen_position_w(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch0_input.enum.ramp_gen_position_w', int(new_val))

    @property
    def ramp_gen_ctrl_z(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch0_input.enum.ramp_gen_ctrl_z'))

    @ramp_gen_ctrl_z.setter
    def ramp_gen_ctrl_z(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch0_input.enum.ramp_gen_ctrl_z', int(new_val))

    @property
    def memory_gen_position_x(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch0_input.enum.memory_gen_position_x'))

    @memory_gen_position_x.setter
    def memory_gen_position_x(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch0_input.enum.memory_gen_position_x', int(new_val))

    @property
    def in_user3(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch0_input.enum.in_user3'))

    @in_user3.setter
    def in_user3(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch0_input.enum.in_user3', int(new_val))

    @property
    def in_position_y(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch0_input.enum.in_position_y'))

    @in_position_y.setter
    def in_position_y(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch0_input.enum.in_position_y', int(new_val))

    @property
    def in_user4(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch0_input.enum.in_user4'))

    @in_user4.setter
    def in_user4(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch0_input.enum.in_user4', int(new_val))

    @property
    def ramp_gen_max_z(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch0_input.enum.ramp_gen_max_z'))

    @ramp_gen_max_z.setter
    def ramp_gen_max_z(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch0_input.enum.ramp_gen_max_z', int(new_val))

    @property
    def ort_free_wave(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch0_input.enum.ort_free_wave'))

    @ort_free_wave.setter
    def ort_free_wave(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch0_input.enum.ort_free_wave', int(new_val))

    @property
    def ort_baseline_corrected(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch0_input.enum.ort_baseline_corrected'))

    @ort_baseline_corrected.setter
    def ort_baseline_corrected(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch0_input.enum.ort_baseline_corrected', int(new_val))

    @property
    def ort_baseline(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch0_input.enum.ort_baseline'))

    @ort_baseline.setter
    def ort_baseline(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch0_input.enum.ort_baseline', int(new_val))

    @property
    def fast_in2(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch0_input.enum.fast_in2'))

    @fast_in2.setter
    def fast_in2(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch0_input.enum.fast_in2', int(new_val))

    @property
    def ctrl_z_error(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch0_input.enum.ctrl_z_error'))

    @ctrl_z_error.setter
    def ctrl_z_error(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch0_input.enum.ctrl_z_error', int(new_val))

    @property
    def memory_gen_position_z(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch0_input.enum.memory_gen_position_z'))

    @memory_gen_position_z.setter
    def memory_gen_position_z(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch0_input.enum.memory_gen_position_z', int(new_val))

    @property
    def fast_in_user(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch0_input.enum.fast_in_user'))

    @fast_in_user.setter
    def fast_in_user(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch0_input.enum.fast_in_user', int(new_val))

    @property
    def memory_gen_position_y(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch0_input.enum.memory_gen_position_y'))

    @memory_gen_position_y.setter
    def memory_gen_position_y(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch0_input.enum.memory_gen_position_y', int(new_val))

    @property
    def analyzer2_amplitude(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch0_input.enum.analyzer2_amplitude'))

    @analyzer2_amplitude.setter
    def analyzer2_amplitude(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch0_input.enum.analyzer2_amplitude', int(new_val))

    @property
    def memory_gen_out8(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch0_input.enum.memory_gen_out8'))

    @memory_gen_out8.setter
    def memory_gen_out8(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch0_input.enum.memory_gen_out8', int(new_val))

    @property
    def memory_gen_drive_z(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch0_input.enum.memory_gen_drive_z'))

    @memory_gen_drive_z.setter
    def memory_gen_drive_z(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch0_input.enum.memory_gen_drive_z', int(new_val))

    @property
    def ramp_gen_user4(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch0_input.enum.ramp_gen_user4'))

    @ramp_gen_user4.setter
    def ramp_gen_user4(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch0_input.enum.ramp_gen_user4', int(new_val))

    @property
    def analyzer1_amplitude(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch0_input.enum.analyzer1_amplitude'))

    @analyzer1_amplitude.setter
    def analyzer1_amplitude(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch0_input.enum.analyzer1_amplitude', int(new_val))

    @property
    def in_detector_sum(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch0_input.enum.in_detector_sum'))

    @in_detector_sum.setter
    def in_detector_sum(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch0_input.enum.in_detector_sum', int(new_val))

    @property
    def ctrl_z_in(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch0_input.enum.ctrl_z_in'))

    @ctrl_z_in.setter
    def ctrl_z_in(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch0_input.enum.ctrl_z_in', int(new_val))

    @property
    def ctrl_user1_out(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch0_input.enum.ctrl_user1_out'))

    @ctrl_user1_out.setter
    def ctrl_user1_out(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch0_input.enum.ctrl_user1_out', int(new_val))


class RootLuData_acquisitionInstanceAttributeCapture_hi_res_ch0_input(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.data_acquisition.instance.attribute.capture_hi_res_ch0_input'
        self.enum = RootLuData_acquisitionInstanceAttributeCapture_hi_res_ch0_inputEnum(self._context)


class RootLuData_acquisitionInstanceAttributeCapture_hi_res_group_id(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.data_acquisition.instance.attribute.capture_hi_res_group_id'


class RootLuData_acquisitionInstanceAttributeCapture_hi_res_ch3_inputEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.data_acquisition.instance.attribute.capture_hi_res_ch3_input.enum'

    @property
    def ort_adhesion_position(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch3_input.enum.ort_adhesion_position'))

    @ort_adhesion_position.setter
    def ort_adhesion_position(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch3_input.enum.ort_adhesion_position', int(new_val))

    @property
    def ctrl_z_pid_command(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch3_input.enum.ctrl_z_pid_command'))

    @ctrl_z_pid_command.setter
    def ctrl_z_pid_command(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch3_input.enum.ctrl_z_pid_command', int(new_val))

    @property
    def in6(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch3_input.enum.in6'))

    @in6.setter
    def in6(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch3_input.enum.in6', int(new_val))

    @property
    def ctrl_z_nominal(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch3_input.enum.ctrl_z_nominal'))

    @ctrl_z_nominal.setter
    def ctrl_z_nominal(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch3_input.enum.ctrl_z_nominal', int(new_val))

    @property
    def ctrl_x_out(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch3_input.enum.ctrl_x_out'))

    @ctrl_x_out.setter
    def ctrl_x_out(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch3_input.enum.ctrl_x_out', int(new_val))

    @property
    def memory_gen_drive_y(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch3_input.enum.memory_gen_drive_y'))

    @memory_gen_drive_y.setter
    def memory_gen_drive_y(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch3_input.enum.memory_gen_drive_y', int(new_val))

    @property
    def ctrl_user2_out(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch3_input.enum.ctrl_user2_out'))

    @ctrl_user2_out.setter
    def ctrl_user2_out(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch3_input.enum.ctrl_user2_out', int(new_val))

    @property
    def analyzer2_phase(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch3_input.enum.analyzer2_phase'))

    @analyzer2_phase.setter
    def analyzer2_phase(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch3_input.enum.analyzer2_phase', int(new_val))

    @property
    def fast_in_deflection(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch3_input.enum.fast_in_deflection'))

    @fast_in_deflection.setter
    def fast_in_deflection(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch3_input.enum.fast_in_deflection', int(new_val))

    @property
    def in_user2(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch3_input.enum.in_user2'))

    @in_user2.setter
    def in_user2(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch3_input.enum.in_user2', int(new_val))

    @property
    def ramp_gen_position_x(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch3_input.enum.ramp_gen_position_x'))

    @ramp_gen_position_x.setter
    def ramp_gen_position_x(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch3_input.enum.ramp_gen_position_x', int(new_val))

    @property
    def in_deflection(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch3_input.enum.in_deflection'))

    @in_deflection.setter
    def in_deflection(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch3_input.enum.in_deflection', int(new_val))

    @property
    def ort_amplitude_reduction(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch3_input.enum.ort_amplitude_reduction'))

    @ort_amplitude_reduction.setter
    def ort_amplitude_reduction(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch3_input.enum.ort_amplitude_reduction', int(new_val))

    @property
    def analyzer2_ctrl_amplitude(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch3_input.enum.analyzer2_ctrl_amplitude'))

    @analyzer2_ctrl_amplitude.setter
    def analyzer2_ctrl_amplitude(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch3_input.enum.analyzer2_ctrl_amplitude', int(new_val))

    @property
    def memory_gen_drive_x(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch3_input.enum.memory_gen_drive_x'))

    @memory_gen_drive_x.setter
    def memory_gen_drive_x(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch3_input.enum.memory_gen_drive_x', int(new_val))

    @property
    def ramp_gen_alternate_z(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch3_input.enum.ramp_gen_alternate_z'))

    @ramp_gen_alternate_z.setter
    def ramp_gen_alternate_z(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch3_input.enum.ramp_gen_alternate_z', int(new_val))

    @property
    def analyzer2_ctrl_delta_f(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch3_input.enum.analyzer2_ctrl_delta_f'))

    @analyzer2_ctrl_delta_f.setter
    def analyzer2_ctrl_delta_f(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch3_input.enum.analyzer2_ctrl_delta_f', int(new_val))

    @property
    def ort_excitation(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch3_input.enum.ort_excitation'))

    @ort_excitation.setter
    def ort_excitation(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch3_input.enum.ort_excitation', int(new_val))

    @property
    def analyzer1_y(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch3_input.enum.analyzer1_y'))

    @analyzer1_y.setter
    def analyzer1_y(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch3_input.enum.analyzer1_y', int(new_val))

    @property
    def ort_adhesion_value(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch3_input.enum.ort_adhesion_value'))

    @ort_adhesion_value.setter
    def ort_adhesion_value(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch3_input.enum.ort_adhesion_value', int(new_val))

    @property
    def ctrl_y_out(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch3_input.enum.ctrl_y_out'))

    @ctrl_y_out.setter
    def ctrl_y_out(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch3_input.enum.ctrl_y_out', int(new_val))

    @property
    def analyzer1_phase(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch3_input.enum.analyzer1_phase'))

    @analyzer1_phase.setter
    def analyzer1_phase(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch3_input.enum.analyzer1_phase', int(new_val))

    @property
    def ctrl_z_out(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch3_input.enum.ctrl_z_out'))

    @ctrl_z_out.setter
    def ctrl_z_out(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch3_input.enum.ctrl_z_out', int(new_val))

    @property
    def ctrl_w_out(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch3_input.enum.ctrl_w_out'))

    @ctrl_w_out.setter
    def ctrl_w_out(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch3_input.enum.ctrl_w_out', int(new_val))

    @property
    def analyzer1_ctrl_amplitude(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch3_input.enum.analyzer1_ctrl_amplitude'))

    @analyzer1_ctrl_amplitude.setter
    def analyzer1_ctrl_amplitude(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch3_input.enum.analyzer1_ctrl_amplitude', int(new_val))

    @property
    def in_user1(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch3_input.enum.in_user1'))

    @in_user1.setter
    def in_user1(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch3_input.enum.in_user1', int(new_val))

    @property
    def ramp_gen_approach(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch3_input.enum.ramp_gen_approach'))

    @ramp_gen_approach.setter
    def ramp_gen_approach(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch3_input.enum.ramp_gen_approach', int(new_val))

    @property
    def ramp_gen_test(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch3_input.enum.ramp_gen_test'))

    @ramp_gen_test.setter
    def ramp_gen_test(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch3_input.enum.ramp_gen_test', int(new_val))

    @property
    def in_position_x(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch3_input.enum.in_position_x'))

    @in_position_x.setter
    def in_position_x(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch3_input.enum.in_position_x', int(new_val))

    @property
    def analyzer1_reference(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch3_input.enum.analyzer1_reference'))

    @analyzer1_reference.setter
    def analyzer1_reference(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch3_input.enum.analyzer1_reference', int(new_val))

    @property
    def ramp_gen_plane_z(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch3_input.enum.ramp_gen_plane_z'))

    @ramp_gen_plane_z.setter
    def ramp_gen_plane_z(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch3_input.enum.ramp_gen_plane_z', int(new_val))

    @property
    def memory_gen_out7(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch3_input.enum.memory_gen_out7'))

    @memory_gen_out7.setter
    def memory_gen_out7(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch3_input.enum.memory_gen_out7', int(new_val))

    @property
    def analyzer2_y(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch3_input.enum.analyzer2_y'))

    @analyzer2_y.setter
    def analyzer2_y(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch3_input.enum.analyzer2_y', int(new_val))

    @property
    def gen_test_dynamic(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch3_input.enum.gen_test_dynamic'))

    @gen_test_dynamic.setter
    def gen_test_dynamic(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch3_input.enum.gen_test_dynamic', int(new_val))

    @property
    def in_tip_current(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch3_input.enum.in_tip_current'))

    @in_tip_current.setter
    def in_tip_current(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch3_input.enum.in_tip_current', int(new_val))

    @property
    def analyzer1_x(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch3_input.enum.analyzer1_x'))

    @analyzer1_x.setter
    def analyzer1_x(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch3_input.enum.analyzer1_x', int(new_val))

    @property
    def ctrl_z_sum(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch3_input.enum.ctrl_z_sum'))

    @ctrl_z_sum.setter
    def ctrl_z_sum(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch3_input.enum.ctrl_z_sum', int(new_val))

    @property
    def analyzer2_reference(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch3_input.enum.analyzer2_reference'))

    @analyzer2_reference.setter
    def analyzer2_reference(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch3_input.enum.analyzer2_reference', int(new_val))

    @property
    def analyzer1_ctrl_delta_f(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch3_input.enum.analyzer1_ctrl_delta_f'))

    @analyzer1_ctrl_delta_f.setter
    def analyzer1_ctrl_delta_f(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch3_input.enum.analyzer1_ctrl_delta_f', int(new_val))

    @property
    def in_position_z(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch3_input.enum.in_position_z'))

    @in_position_z.setter
    def in_position_z(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch3_input.enum.in_position_z', int(new_val))

    @property
    def analyzer2_x(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch3_input.enum.analyzer2_x'))

    @analyzer2_x.setter
    def analyzer2_x(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch3_input.enum.analyzer2_x', int(new_val))

    @property
    def static(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch3_input.enum.static'))

    @static.setter
    def static(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch3_input.enum.static', int(new_val))

    @property
    def in_lateral(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch3_input.enum.in_lateral'))

    @in_lateral.setter
    def in_lateral(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch3_input.enum.in_lateral', int(new_val))

    @property
    def ramp_gen_tip_voltage(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch3_input.enum.ramp_gen_tip_voltage'))

    @ramp_gen_tip_voltage.setter
    def ramp_gen_tip_voltage(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch3_input.enum.ramp_gen_tip_voltage', int(new_val))

    @property
    def ramp_gen_position_y(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch3_input.enum.ramp_gen_position_y'))

    @ramp_gen_position_y.setter
    def ramp_gen_position_y(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch3_input.enum.ramp_gen_position_y', int(new_val))

    @property
    def ramp_gen_position_w(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch3_input.enum.ramp_gen_position_w'))

    @ramp_gen_position_w.setter
    def ramp_gen_position_w(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch3_input.enum.ramp_gen_position_w', int(new_val))

    @property
    def ramp_gen_ctrl_z(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch3_input.enum.ramp_gen_ctrl_z'))

    @ramp_gen_ctrl_z.setter
    def ramp_gen_ctrl_z(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch3_input.enum.ramp_gen_ctrl_z', int(new_val))

    @property
    def memory_gen_position_x(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch3_input.enum.memory_gen_position_x'))

    @memory_gen_position_x.setter
    def memory_gen_position_x(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch3_input.enum.memory_gen_position_x', int(new_val))

    @property
    def in_user3(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch3_input.enum.in_user3'))

    @in_user3.setter
    def in_user3(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch3_input.enum.in_user3', int(new_val))

    @property
    def in_position_y(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch3_input.enum.in_position_y'))

    @in_position_y.setter
    def in_position_y(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch3_input.enum.in_position_y', int(new_val))

    @property
    def in_user4(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch3_input.enum.in_user4'))

    @in_user4.setter
    def in_user4(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch3_input.enum.in_user4', int(new_val))

    @property
    def ramp_gen_max_z(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch3_input.enum.ramp_gen_max_z'))

    @ramp_gen_max_z.setter
    def ramp_gen_max_z(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch3_input.enum.ramp_gen_max_z', int(new_val))

    @property
    def ort_free_wave(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch3_input.enum.ort_free_wave'))

    @ort_free_wave.setter
    def ort_free_wave(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch3_input.enum.ort_free_wave', int(new_val))

    @property
    def ort_baseline_corrected(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch3_input.enum.ort_baseline_corrected'))

    @ort_baseline_corrected.setter
    def ort_baseline_corrected(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch3_input.enum.ort_baseline_corrected', int(new_val))

    @property
    def ort_baseline(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch3_input.enum.ort_baseline'))

    @ort_baseline.setter
    def ort_baseline(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch3_input.enum.ort_baseline', int(new_val))

    @property
    def fast_in2(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch3_input.enum.fast_in2'))

    @fast_in2.setter
    def fast_in2(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch3_input.enum.fast_in2', int(new_val))

    @property
    def ctrl_z_error(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch3_input.enum.ctrl_z_error'))

    @ctrl_z_error.setter
    def ctrl_z_error(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch3_input.enum.ctrl_z_error', int(new_val))

    @property
    def memory_gen_position_z(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch3_input.enum.memory_gen_position_z'))

    @memory_gen_position_z.setter
    def memory_gen_position_z(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch3_input.enum.memory_gen_position_z', int(new_val))

    @property
    def fast_in_user(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch3_input.enum.fast_in_user'))

    @fast_in_user.setter
    def fast_in_user(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch3_input.enum.fast_in_user', int(new_val))

    @property
    def memory_gen_position_y(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch3_input.enum.memory_gen_position_y'))

    @memory_gen_position_y.setter
    def memory_gen_position_y(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch3_input.enum.memory_gen_position_y', int(new_val))

    @property
    def analyzer2_amplitude(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch3_input.enum.analyzer2_amplitude'))

    @analyzer2_amplitude.setter
    def analyzer2_amplitude(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch3_input.enum.analyzer2_amplitude', int(new_val))

    @property
    def memory_gen_out8(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch3_input.enum.memory_gen_out8'))

    @memory_gen_out8.setter
    def memory_gen_out8(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch3_input.enum.memory_gen_out8', int(new_val))

    @property
    def memory_gen_drive_z(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch3_input.enum.memory_gen_drive_z'))

    @memory_gen_drive_z.setter
    def memory_gen_drive_z(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch3_input.enum.memory_gen_drive_z', int(new_val))

    @property
    def ramp_gen_user4(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch3_input.enum.ramp_gen_user4'))

    @ramp_gen_user4.setter
    def ramp_gen_user4(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch3_input.enum.ramp_gen_user4', int(new_val))

    @property
    def analyzer1_amplitude(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch3_input.enum.analyzer1_amplitude'))

    @analyzer1_amplitude.setter
    def analyzer1_amplitude(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch3_input.enum.analyzer1_amplitude', int(new_val))

    @property
    def in_detector_sum(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch3_input.enum.in_detector_sum'))

    @in_detector_sum.setter
    def in_detector_sum(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch3_input.enum.in_detector_sum', int(new_val))

    @property
    def ctrl_z_in(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch3_input.enum.ctrl_z_in'))

    @ctrl_z_in.setter
    def ctrl_z_in(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch3_input.enum.ctrl_z_in', int(new_val))

    @property
    def ctrl_user1_out(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch3_input.enum.ctrl_user1_out'))

    @ctrl_user1_out.setter
    def ctrl_user1_out(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch3_input.enum.ctrl_user1_out', int(new_val))


class RootLuData_acquisitionInstanceAttributeCapture_hi_res_ch3_input(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.data_acquisition.instance.attribute.capture_hi_res_ch3_input'
        self.enum = RootLuData_acquisitionInstanceAttributeCapture_hi_res_ch3_inputEnum(self._context)


class RootLuData_acquisitionInstanceAttributeCapture_fast_channel_mask(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.data_acquisition.instance.attribute.capture_fast_channel_mask'


class RootLuData_acquisitionInstanceAttributeSampler_auto_set_filter_mode(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.data_acquisition.instance.attribute.sampler_auto_set_filter_mode'


class RootLuData_acquisitionInstanceAttributePhase_count(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.data_acquisition.instance.attribute.phase_count'


class RootLuData_acquisitionInstanceAttributeCapture_fast_datapoints(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.data_acquisition.instance.attribute.capture_fast_datapoints'


class RootLuData_acquisitionInstanceAttributeCapture_fast_ch1_inputEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.data_acquisition.instance.attribute.capture_fast_ch1_input.enum'

    @property
    def in2(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_fast_ch1_input.enum.in2'))

    @in2.setter
    def in2(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_fast_ch1_input.enum.in2', int(new_val))

    @property
    def in_deflection(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_fast_ch1_input.enum.in_deflection'))

    @in_deflection.setter
    def in_deflection(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_fast_ch1_input.enum.in_deflection', int(new_val))

    @property
    def ctrl_z_out(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_fast_ch1_input.enum.ctrl_z_out'))

    @ctrl_z_out.setter
    def ctrl_z_out(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_fast_ch1_input.enum.ctrl_z_out', int(new_val))

    @property
    def analyzer1_reference(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_fast_ch1_input.enum.analyzer1_reference'))

    @analyzer1_reference.setter
    def analyzer1_reference(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_fast_ch1_input.enum.analyzer1_reference', int(new_val))

    @property
    def ort_free_wave(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_fast_ch1_input.enum.ort_free_wave'))

    @ort_free_wave.setter
    def ort_free_wave(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_fast_ch1_input.enum.ort_free_wave', int(new_val))

    @property
    def ctrl_w_out(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_fast_ch1_input.enum.ctrl_w_out'))

    @ctrl_w_out.setter
    def ctrl_w_out(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_fast_ch1_input.enum.ctrl_w_out', int(new_val))

    @property
    def in_user(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_fast_ch1_input.enum.in_user'))

    @in_user.setter
    def in_user(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_fast_ch1_input.enum.in_user', int(new_val))

    @property
    def ort_excitation(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_fast_ch1_input.enum.ort_excitation'))

    @ort_excitation.setter
    def ort_excitation(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_fast_ch1_input.enum.ort_excitation', int(new_val))

    @property
    def analyzer2_reference(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_fast_ch1_input.enum.analyzer2_reference'))

    @analyzer2_reference.setter
    def analyzer2_reference(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_fast_ch1_input.enum.analyzer2_reference', int(new_val))


class RootLuData_acquisitionInstanceAttributeCapture_fast_ch1_input(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.data_acquisition.instance.attribute.capture_fast_ch1_input'
        self.enum = RootLuData_acquisitionInstanceAttributeCapture_fast_ch1_inputEnum(self._context)


class RootLuData_acquisitionInstanceAttributeCapture_fast_ch_input_vecEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.data_acquisition.instance.attribute.capture_fast_ch_input_vec.enum'

    @property
    def in2(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_fast_ch_input_vec.enum.in2'))

    @in2.setter
    def in2(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_fast_ch_input_vec.enum.in2', int(new_val))

    @property
    def in_deflection(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_fast_ch_input_vec.enum.in_deflection'))

    @in_deflection.setter
    def in_deflection(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_fast_ch_input_vec.enum.in_deflection', int(new_val))

    @property
    def ctrl_z_out(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_fast_ch_input_vec.enum.ctrl_z_out'))

    @ctrl_z_out.setter
    def ctrl_z_out(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_fast_ch_input_vec.enum.ctrl_z_out', int(new_val))

    @property
    def analyzer1_reference(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_fast_ch_input_vec.enum.analyzer1_reference'))

    @analyzer1_reference.setter
    def analyzer1_reference(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_fast_ch_input_vec.enum.analyzer1_reference', int(new_val))

    @property
    def ort_free_wave(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_fast_ch_input_vec.enum.ort_free_wave'))

    @ort_free_wave.setter
    def ort_free_wave(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_fast_ch_input_vec.enum.ort_free_wave', int(new_val))

    @property
    def ctrl_w_out(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_fast_ch_input_vec.enum.ctrl_w_out'))

    @ctrl_w_out.setter
    def ctrl_w_out(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_fast_ch_input_vec.enum.ctrl_w_out', int(new_val))

    @property
    def in_user(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_fast_ch_input_vec.enum.in_user'))

    @in_user.setter
    def in_user(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_fast_ch_input_vec.enum.in_user', int(new_val))

    @property
    def ort_excitation(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_fast_ch_input_vec.enum.ort_excitation'))

    @ort_excitation.setter
    def ort_excitation(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_fast_ch_input_vec.enum.ort_excitation', int(new_val))

    @property
    def analyzer2_reference(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_fast_ch_input_vec.enum.analyzer2_reference'))

    @analyzer2_reference.setter
    def analyzer2_reference(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_fast_ch_input_vec.enum.analyzer2_reference', int(new_val))


class RootLuData_acquisitionInstanceAttributeCapture_fast_ch_input_vec(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.data_acquisition.instance.attribute.capture_fast_ch_input_vec'
        self.enum = RootLuData_acquisitionInstanceAttributeCapture_fast_ch_input_vecEnum(self._context)


class RootLuData_acquisitionInstanceAttributeActive_capture_set(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.data_acquisition.instance.attribute.active_capture_set'


class RootLuData_acquisitionInstanceAttribute(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.data_acquisition.instance.attribute'
        self.active_capture_set = RootLuData_acquisitionInstanceAttributeActive_capture_set(self._context)
        self.capture_fast_ch_input_vec = RootLuData_acquisitionInstanceAttributeCapture_fast_ch_input_vec(self._context)
        self.capture_fast_ch1_input = RootLuData_acquisitionInstanceAttributeCapture_fast_ch1_input(self._context)
        self.capture_fast_datapoints = RootLuData_acquisitionInstanceAttributeCapture_fast_datapoints(self._context)
        self.phase_count = RootLuData_acquisitionInstanceAttributePhase_count(self._context)
        self.sampler_auto_set_filter_mode = RootLuData_acquisitionInstanceAttributeSampler_auto_set_filter_mode(self._context)
        self.capture_fast_channel_mask = RootLuData_acquisitionInstanceAttributeCapture_fast_channel_mask(self._context)
        self.capture_hi_res_ch3_input = RootLuData_acquisitionInstanceAttributeCapture_hi_res_ch3_input(self._context)
        self.capture_hi_res_group_id = RootLuData_acquisitionInstanceAttributeCapture_hi_res_group_id(self._context)
        self.capture_hi_res_ch0_input = RootLuData_acquisitionInstanceAttributeCapture_hi_res_ch0_input(self._context)
        self.capture_fast_ch0_input = RootLuData_acquisitionInstanceAttributeCapture_fast_ch0_input(self._context)
        self.number_of_capture_sets = RootLuData_acquisitionInstanceAttributeNumber_of_capture_sets(self._context)
        self.sampler_hi_res_ch_input_vec = RootLuData_acquisitionInstanceAttributeSampler_hi_res_ch_input_vec(self._context)
        self.number_of_sampler_sets = RootLuData_acquisitionInstanceAttributeNumber_of_sampler_sets(self._context)
        self.capture_hi_res_ch2_input = RootLuData_acquisitionInstanceAttributeCapture_hi_res_ch2_input(self._context)
        self.sampler_filter_cutoff = RootLuData_acquisitionInstanceAttributeSampler_filter_cutoff(self._context)
        self.sampler_hi_res_ch4_input = Ro