# studio_wrapper.py

import enum
from typing import Any
import nanosurf.lib.spm.studio.wrapper as wrap

g_cmd_tree_hash = 'ac8089a51c2c5c53df9ae0a06fb2eaaa'
g_compiler_version = '2.0'

class RootTestTabel(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.test.tabel'


class RootTest(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.test'
        self.tabel = RootTestTabel(self._context)

    @property
    def num_f(self) -> float:
        return float(self._context.get('root.test.num_f'))

    @num_f.setter
    def num_f(self, new_val:float):
        self._context.set('root.test.num_f', float(new_val))

    @property
    def num_i(self) -> int:
        return int(self._context.get('root.test.num_i'))

    @num_i.setter
    def num_i(self, new_val:int):
        self._context.set('root.test.num_i', int(new_val))

    def func(self, *args) -> Any:
        return self._context.call('root.test.func', *args)

    @property
    def bool(self) -> bool:
        return bool(self._context.get('root.test.bool'))

    @bool.setter
    def bool(self, new_val:bool):
        self._context.set('root.test.bool', bool(new_val))

    @property
    def str(self) -> str:
        return str(self._context.get('root.test.str'))

    @str.setter
    def str(self, new_val:str):
        self._context.set('root.test.str', str(new_val))


class RootCoreConverter_channel_correction(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.converter_channel_correction'


class RootCoreScan_head_calibration(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.scan_head_calibration'


class RootCorePosition_control(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.position_control'


class RootCoreOrtPropertyBaseline_frequency(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.ort.property.baseline_frequency'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def unit(self) -> str:
        return str(self._context.get('root.core.ort.property.baseline_frequency.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.core.ort.property.baseline_frequency.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.core.ort.property.baseline_frequency.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.core.ort.property.baseline_frequency.value', float(new_val))


class RootCoreOrtPropertyBaseline_value(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.ort.property.baseline_value'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def unit(self) -> str:
        return str(self._context.get('root.core.ort.property.baseline_value.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.core.ort.property.baseline_value.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.core.ort.property.baseline_value.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.core.ort.property.baseline_value.value', float(new_val))


class RootCoreOrtPropertyBaseline_window_end(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.ort.property.baseline_window_end'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.core.ort.property.baseline_window_end.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.core.ort.property.baseline_window_end.value', float(new_val))


class RootCoreOrtPropertyAdhesion_value(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.ort.property.adhesion_value'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def unit(self) -> str:
        return str(self._context.get('root.core.ort.property.adhesion_value.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.core.ort.property.adhesion_value.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.core.ort.property.adhesion_value.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.core.ort.property.adhesion_value.value', float(new_val))


class RootCoreOrtPropertyInput_select(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        Fast_In_User = 2
        Hi_Res_In_User1 = 3
        Fast_In_Deflection = 0
        Hi_Res_In_Deflection = 1

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.ort.property.input_select'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value(self) -> ValueEnum:
        return RootCoreOrtPropertyInput_select.ValueEnum(self._context.get('root.core.ort.property.input_select.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.core.ort.property.input_select.value_raw', new_val.value)

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.core.ort.property.input_select.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.core.ort.property.input_select.value_raw', int(new_val))

    @property
    def enum(self) -> list:
        return list(self._context.get('root.core.ort.property.input_select.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.core.ort.property.input_select.enum', list(new_val))


class RootCoreOrtPropertyExcitation_enabled(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.ort.property.excitation_enabled'
        self._lua_value_type = wrap.LuaType('bool')

    @property
    def value(self) -> bool:
        return bool(self._context.get('root.core.ort.property.excitation_enabled.value'))

    @value.setter
    def value(self, new_val:bool):
        self._context.set('root.core.ort.property.excitation_enabled.value', bool(new_val))


class RootCoreOrtPropertyFeedback_amplitude_position(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.ort.property.feedback_amplitude_position'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.core.ort.property.feedback_amplitude_position.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.core.ort.property.feedback_amplitude_position.value', float(new_val))


class RootCoreOrtPropertyAmplitude_reduction(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.ort.property.amplitude_reduction'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def unit(self) -> str:
        return str(self._context.get('root.core.ort.property.amplitude_reduction.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.core.ort.property.amplitude_reduction.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.core.ort.property.amplitude_reduction.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.core.ort.property.amplitude_reduction.value', float(new_val))


class RootCoreOrtPropertyBaseline_window_begin(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.ort.property.baseline_window_begin'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.core.ort.property.baseline_window_begin.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.core.ort.property.baseline_window_begin.value', float(new_val))


class RootCoreOrtPropertySamples_per_period(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.ort.property.samples_per_period'
        self._lua_value_type = wrap.LuaType('int')

    @property
    def value(self) -> int:
        return int(self._context.get('root.core.ort.property.samples_per_period.value'))

    @value.setter
    def value(self, new_val:int):
        self._context.set('root.core.ort.property.samples_per_period.value', int(new_val))


class RootCoreOrtPropertyAverage_periods(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.ort.property.average_periods'
        self._lua_value_type = wrap.LuaType('int')

    @property
    def value(self) -> int:
        return int(self._context.get('root.core.ort.property.average_periods.value'))

    @value.setter
    def value(self, new_val:int):
        self._context.set('root.core.ort.property.average_periods.value', int(new_val))


class RootCoreOrtPropertyAdhesion_position(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.ort.property.adhesion_position'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.core.ort.property.adhesion_position.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.core.ort.property.adhesion_position.value', float(new_val))


class RootCoreOrtPropertyBaseline_controller_enabled(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.ort.property.baseline_controller_enabled'
        self._lua_value_type = wrap.LuaType('bool')

    @property
    def value(self) -> bool:
        return bool(self._context.get('root.core.ort.property.baseline_controller_enabled.value'))

    @value.setter
    def value(self, new_val:bool):
        self._context.set('root.core.ort.property.baseline_controller_enabled.value', bool(new_val))


class RootCoreOrtPropertyCantilever_samples_per_period(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.ort.property.cantilever_samples_per_period'
        self._lua_value_type = wrap.LuaType('int')

    @property
    def value(self) -> int:
        return int(self._context.get('root.core.ort.property.cantilever_samples_per_period.value'))

    @value.setter
    def value(self, new_val:int):
        self._context.set('root.core.ort.property.cantilever_samples_per_period.value', int(new_val))


class RootCoreOrtProperty(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.ort.property'
        self.cantilever_samples_per_period = RootCoreOrtPropertyCantilever_samples_per_period(self._context)
        self.baseline_controller_enabled = RootCoreOrtPropertyBaseline_controller_enabled(self._context)
        self.adhesion_position = RootCoreOrtPropertyAdhesion_position(self._context)
        self.average_periods = RootCoreOrtPropertyAverage_periods(self._context)
        self.samples_per_period = RootCoreOrtPropertySamples_per_period(self._context)
        self.baseline_window_begin = RootCoreOrtPropertyBaseline_window_begin(self._context)
        self.amplitude_reduction = RootCoreOrtPropertyAmplitude_reduction(self._context)
        self.feedback_amplitude_position = RootCoreOrtPropertyFeedback_amplitude_position(self._context)
        self.excitation_enabled = RootCoreOrtPropertyExcitation_enabled(self._context)
        self.input_select = RootCoreOrtPropertyInput_select(self._context)
        self.adhesion_value = RootCoreOrtPropertyAdhesion_value(self._context)
        self.baseline_window_end = RootCoreOrtPropertyBaseline_window_end(self._context)
        self.baseline_value = RootCoreOrtPropertyBaseline_value(self._context)
        self.baseline_frequency = RootCoreOrtPropertyBaseline_frequency(self._context)


class RootCoreOrt(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.ort'
        self.property = RootCoreOrtProperty(self._context)

    def apply_samples_per_period(self, *args) -> Any:
        return self._context.call('root.core.ort.apply_samples_per_period', *args)

    def excitation_amplitude(self, *args) -> Any:
        return self._context.call('root.core.ort.excitation_amplitude', *args)

    def apply_samples_values(self, *args) -> Any:
        return self._context.call('root.core.ort.apply_samples_values', *args)

    def update_free_wave(self, *args) -> Any:
        return self._context.call('root.core.ort.update_free_wave', *args)

    def is_averaging(self, *args) -> Any:
        return self._context.call('root.core.ort.is_averaging', *args)

    def select_input(self, *args) -> Any:
        return self._context.call('root.core.ort.select_input', *args)


class RootCoreCore_environment(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.core_environment'


class RootCoreApproachPropertyDeflection_offset_voltage(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.approach.property.deflection_offset_voltage'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def unit(self) -> str:
        return str(self._context.get('root.core.approach.property.deflection_offset_voltage.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.core.approach.property.deflection_offset_voltage.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.core.approach.property.deflection_offset_voltage.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.core.approach.property.deflection_offset_voltage.value', float(new_val))


class RootCoreApproachPropertyMotor_source(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        Internal = 0
        External = 1

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.approach.property.motor_source'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value(self) -> ValueEnum:
        return RootCoreApproachPropertyMotor_source.ValueEnum(self._context.get('root.core.approach.property.motor_source.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.core.approach.property.motor_source.value_raw', new_val.value)

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.core.approach.property.motor_source.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.core.approach.property.motor_source.value_raw', int(new_val))

    @property
    def enum(self) -> list:
        return list(self._context.get('root.core.approach.property.motor_source.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.core.approach.property.motor_source.enum', list(new_val))


class RootCoreApproachPropertyStep_by_step_coarse_step_size_percentage(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.approach.property.step_by_step_coarse_step_size_percentage'
        self._lua_value_type = wrap.LuaType('int')

    @property
    def unit(self) -> str:
        return str(self._context.get('root.core.approach.property.step_by_step_coarse_step_size_percentage.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.core.approach.property.step_by_step_coarse_step_size_percentage.unit', str(new_val))

    @property
    def value(self) -> int:
        return int(self._context.get('root.core.approach.property.step_by_step_coarse_step_size_percentage.value'))

    @value.setter
    def value(self, new_val:int):
        self._context.set('root.core.approach.property.step_by_step_coarse_step_size_percentage.value', int(new_val))


class RootCoreApproachPropertyApproach_steps(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.approach.property.approach_steps'
        self._lua_value_type = wrap.LuaType('int')

    @property
    def value(self) -> int:
        return int(self._context.get('root.core.approach.property.approach_steps.value'))

    @value.setter
    def value(self, new_val:int):
        self._context.set('root.core.approach.property.approach_steps.value', int(new_val))


class RootCoreApproachPropertyStep_by_step_fine_step_size_percentage(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.approach.property.step_by_step_fine_step_size_percentage'
        self._lua_value_type = wrap.LuaType('int')

    @property
    def unit(self) -> str:
        return str(self._context.get('root.core.approach.property.step_by_step_fine_step_size_percentage.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.core.approach.property.step_by_step_fine_step_size_percentage.unit', str(new_val))

    @property
    def value(self) -> int:
        return int(self._context.get('root.core.approach.property.step_by_step_fine_step_size_percentage.value'))

    @value.setter
    def value(self, new_val:int):
        self._context.set('root.core.approach.property.step_by_step_fine_step_size_percentage.value', int(new_val))


class RootCoreApproachPropertyApproach_result(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.approach.property.approach_result'
        self._lua_value_type = wrap.LuaType('str')

    @property
    def value(self) -> str:
        return str(self._context.get('root.core.approach.property.approach_result.value'))

    @value.setter
    def value(self, new_val:str):
        self._context.set('root.core.approach.property.approach_result.value', str(new_val))


class RootCoreApproachPropertyStep_by_step_mode(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        Tip_Position_Ignored = 2
        Not_Controlled = 1
        Position_Controlled = 0

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.approach.property.step_by_step_mode'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value(self) -> ValueEnum:
        return RootCoreApproachPropertyStep_by_step_mode.ValueEnum(self._context.get('root.core.approach.property.step_by_step_mode.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.core.approach.property.step_by_step_mode.value_raw', new_val.value)

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.core.approach.property.step_by_step_mode.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.core.approach.property.step_by_step_mode.value_raw', int(new_val))

    @property
    def enum(self) -> list:
        return list(self._context.get('root.core.approach.property.step_by_step_mode.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.core.approach.property.step_by_step_mode.enum', list(new_val))


class RootCoreApproachPropertyStep_period(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.approach.property.step_period'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.core.approach.property.step_period.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.core.approach.property.step_period.value', float(new_val))


class RootCoreApproachPropertyStep_by_step_slope(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.approach.property.step_by_step_slope'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def unit(self) -> str:
        return str(self._context.get('root.core.approach.property.step_by_step_slope.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.core.approach.property.step_by_step_slope.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.core.approach.property.step_by_step_slope.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.core.approach.property.step_by_step_slope.value', float(new_val))


class RootCoreApproachPropertyApproach_mode(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        Continuous = 0
        Step_by_Step = 1

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.approach.property.approach_mode'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value(self) -> ValueEnum:
        return RootCoreApproachPropertyApproach_mode.ValueEnum(self._context.get('root.core.approach.property.approach_mode.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.core.approach.property.approach_mode.value_raw', new_val.value)

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.core.approach.property.approach_mode.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.core.approach.property.approach_mode.value_raw', int(new_val))

    @property
    def enum(self) -> list:
        return list(self._context.get('root.core.approach.property.approach_mode.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.core.approach.property.approach_mode.enum', list(new_val))


class RootCoreApproachPropertyWithdraw_steps(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.approach.property.withdraw_steps'
        self._lua_value_type = wrap.LuaType('int')

    @property
    def value(self) -> int:
        return int(self._context.get('root.core.approach.property.withdraw_steps.value'))

    @value.setter
    def value(self, new_val:int):
        self._context.set('root.core.approach.property.withdraw_steps.value', int(new_val))


class RootCoreApproachPropertyApproach_speed(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.approach.property.approach_speed'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def unit(self) -> str:
        return str(self._context.get('root.core.approach.property.approach_speed.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.core.approach.property.approach_speed.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.core.approach.property.approach_speed.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.core.approach.property.approach_speed.value', float(new_val))


class RootCoreApproachPropertyApproach_pos(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.approach.property.approach_pos'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def unit(self) -> str:
        return str(self._context.get('root.core.approach.property.approach_pos.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.core.approach.property.approach_pos.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.core.approach.property.approach_pos.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.core.approach.property.approach_pos.value', float(new_val))


class RootCoreApproachPropertyStep_by_step_time(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.approach.property.step_by_step_time'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.core.approach.property.step_by_step_time.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.core.approach.property.step_by_step_time.value', float(new_val))


class RootCoreApproachProperty(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.approach.property'
        self.step_by_step_time = RootCoreApproachPropertyStep_by_step_time(self._context)
        self.approach_pos = RootCoreApproachPropertyApproach_pos(self._context)
        self.approach_speed = RootCoreApproachPropertyApproach_speed(self._context)
        self.withdraw_steps = RootCoreApproachPropertyWithdraw_steps(self._context)
        self.approach_mode = RootCoreApproachPropertyApproach_mode(self._context)
        self.step_by_step_slope = RootCoreApproachPropertyStep_by_step_slope(self._context)
        self.step_period = RootCoreApproachPropertyStep_period(self._context)
        self.step_by_step_mode = RootCoreApproachPropertyStep_by_step_mode(self._context)
        self.approach_result = RootCoreApproachPropertyApproach_result(self._context)
        self.step_by_step_fine_step_size_percentage = RootCoreApproachPropertyStep_by_step_fine_step_size_percentage(self._context)
        self.approach_steps = RootCoreApproachPropertyApproach_steps(self._context)
        self.step_by_step_coarse_step_size_percentage = RootCoreApproachPropertyStep_by_step_coarse_step_size_percentage(self._context)
        self.motor_source = RootCoreApproachPropertyMotor_source(self._context)
        self.deflection_offset_voltage = RootCoreApproachPropertyDeflection_offset_voltage(self._context)


class RootCoreApproachSignalApproach_or_withdraw_done(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.approach.signal.approach_or_withdraw_done'

    def empty(self, *args) -> Any:
        return self._context.call('root.core.approach.signal.approach_or_withdraw_done.empty', *args)

    def call(self, *args) -> Any:
        return self._context.call('root.core.approach.signal.approach_or_withdraw_done.call', *args)

    def connect(self, *args) -> Any:
        return self._context.call('root.core.approach.signal.approach_or_withdraw_done.connect', *args)

    def connect_extended(self, *args) -> Any:
        return self._context.call('root.core.approach.signal.approach_or_withdraw_done.connect_extended', *args)


class RootCoreApproachSignal(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.approach.signal'
        self.approach_or_withdraw_done = RootCoreApproachSignalApproach_or_withdraw_done(self._context)


class RootCoreApproach(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.approach'
        self.signal = RootCoreApproachSignal(self._context)
        self.property = RootCoreApproachProperty(self._context)

    def withdraw(self, *args) -> Any:
        return self._context.call('root.core.approach.withdraw', *args)

    def approach(self, *args) -> Any:
        return self._context.call('root.core.approach.approach', *args)

    def abort(self, *args) -> Any:
        return self._context.call('root.core.approach.abort', *args)


class RootCoreOscilloscope(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.oscilloscope'


class RootCoreSpectroscopyPropertyBackward_datapoints(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.spectroscopy.property.backward_datapoints'
        self._lua_value_type = wrap.LuaType('int')

    @property
    def unit(self) -> str:
        return str(self._context.get('root.core.spectroscopy.property.backward_datapoints.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.core.spectroscopy.property.backward_datapoints.unit', str(new_val))

    @property
    def value(self) -> int:
        return int(self._context.get('root.core.spectroscopy.property.backward_datapoints.value'))

    @value.setter
    def value(self, new_val:int):
        self._context.set('root.core.spectroscopy.property.backward_datapoints.value', int(new_val))


class RootCoreSpectroscopyPropertyBackward_move_speed(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.spectroscopy.property.backward_move_speed'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def unit(self) -> str:
        return str(self._context.get('root.core.spectroscopy.property.backward_move_speed.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.core.spectroscopy.property.backward_move_speed.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.core.spectroscopy.property.backward_move_speed.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.core.spectroscopy.property.backward_move_speed.value', float(new_val))


class RootCoreSpectroscopyPropertyBackward_pause_mode(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        Z_Off = 0
        Z_On = 1

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.spectroscopy.property.backward_pause_mode'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value(self) -> ValueEnum:
        return RootCoreSpectroscopyPropertyBackward_pause_mode.ValueEnum(self._context.get('root.core.spectroscopy.property.backward_pause_mode.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.core.spectroscopy.property.backward_pause_mode.value_raw', new_val.value)

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.core.spectroscopy.property.backward_pause_mode.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.core.spectroscopy.property.backward_pause_mode.value_raw', int(new_val))

    @property
    def enum(self) -> list:
        return list(self._context.get('root.core.spectroscopy.property.backward_pause_mode.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.core.spectroscopy.property.backward_pause_mode.enum', list(new_val))


class RootCoreSpectroscopyPropertyForward_modulation_stop_value(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.spectroscopy.property.forward_modulation_stop_value'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def unit(self) -> str:
        return str(self._context.get('root.core.spectroscopy.property.forward_modulation_stop_value.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.core.spectroscopy.property.forward_modulation_stop_value.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.core.spectroscopy.property.forward_modulation_stop_value.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.core.spectroscopy.property.forward_modulation_stop_value.value', float(new_val))


class RootCoreSpectroscopyPropertyBackward_modulation_stop_mode(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        Is_Less_Than = 0
        Is_Greater_Than = 1

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.spectroscopy.property.backward_modulation_stop_mode'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value(self) -> ValueEnum:
        return RootCoreSpectroscopyPropertyBackward_modulation_stop_mode.ValueEnum(self._context.get('root.core.spectroscopy.property.backward_modulation_stop_mode.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.core.spectroscopy.property.backward_modulation_stop_mode.value_raw', new_val.value)

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.core.spectroscopy.property.backward_modulation_stop_mode.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.core.spectroscopy.property.backward_modulation_stop_mode.value_raw', int(new_val))

    @property
    def enum(self) -> list:
        return list(self._context.get('root.core.spectroscopy.property.backward_modulation_stop_mode.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.core.spectroscopy.property.backward_modulation_stop_mode.enum', list(new_val))


class RootCoreSpectroscopyPropertyForward_modulation_mode(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        Fixed_Length = 0
        Stop_by_Value = 1

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.spectroscopy.property.forward_modulation_mode'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value(self) -> ValueEnum:
        return RootCoreSpectroscopyPropertyForward_modulation_mode.ValueEnum(self._context.get('root.core.spectroscopy.property.forward_modulation_mode.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.core.spectroscopy.property.forward_modulation_mode.value_raw', new_val.value)

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.core.spectroscopy.property.forward_modulation_mode.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.core.spectroscopy.property.forward_modulation_mode.value_raw', int(new_val))

    @property
    def enum(self) -> list:
        return list(self._context.get('root.core.spectroscopy.property.forward_modulation_mode.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.core.spectroscopy.property.forward_modulation_mode.enum', list(new_val))


class RootCoreSpectroscopyPropertyForward_modulation_time(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.spectroscopy.property.forward_modulation_time'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def unit(self) -> str:
        return str(self._context.get('root.core.spectroscopy.property.forward_modulation_time.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.core.spectroscopy.property.forward_modulation_time.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.core.spectroscopy.property.forward_modulation_time.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.core.spectroscopy.property.forward_modulation_time.value', float(new_val))


class RootCoreSpectroscopyPropertyBackward_modulation_range(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.spectroscopy.property.backward_modulation_range'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def unit(self) -> str:
        return str(self._context.get('root.core.spectroscopy.property.backward_modulation_range.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.core.spectroscopy.property.backward_modulation_range.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.core.spectroscopy.property.backward_modulation_range.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.core.spectroscopy.property.backward_modulation_range.value', float(new_val))


class RootCoreSpectroscopyPropertyBackward_modulation_time(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.spectroscopy.property.backward_modulation_time'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def unit(self) -> str:
        return str(self._context.get('root.core.spectroscopy.property.backward_modulation_time.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.core.spectroscopy.property.backward_modulation_time.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.core.spectroscopy.property.backward_modulation_time.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.core.spectroscopy.property.backward_modulation_time.value', float(new_val))


class RootCoreSpectroscopyPropertyForward_modulation_range(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.spectroscopy.property.forward_modulation_range'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def unit(self) -> str:
        return str(self._context.get('root.core.spectroscopy.property.forward_modulation_range.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.core.spectroscopy.property.forward_modulation_range.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.core.spectroscopy.property.forward_modulation_range.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.core.spectroscopy.property.forward_modulation_range.value', float(new_val))


class RootCoreSpectroscopyPropertyForward_move_speed(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.spectroscopy.property.forward_move_speed'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def unit(self) -> str:
        return str(self._context.get('root.core.spectroscopy.property.forward_move_speed.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.core.spectroscopy.property.forward_move_speed.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.core.spectroscopy.property.forward_move_speed.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.core.spectroscopy.property.forward_move_speed.value', float(new_val))


class RootCoreSpectroscopyPropertyForward_pause_time(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.spectroscopy.property.forward_pause_time'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def unit(self) -> str:
        return str(self._context.get('root.core.spectroscopy.property.forward_pause_time.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.core.spectroscopy.property.forward_pause_time.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.core.spectroscopy.property.forward_pause_time.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.core.spectroscopy.property.forward_pause_time.value', float(new_val))


class RootCoreSpectroscopyPropertyBackward_pause_sampling_rate(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.spectroscopy.property.backward_pause_sampling_rate'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def unit(self) -> str:
        return str(self._context.get('root.core.spectroscopy.property.backward_pause_sampling_rate.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.core.spectroscopy.property.backward_pause_sampling_rate.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.core.spectroscopy.property.backward_pause_sampling_rate.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.core.spectroscopy.property.backward_pause_sampling_rate.value', float(new_val))


class RootCoreSpectroscopyPropertyModulation_output(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        Tip_Voltage = 1
        Position_Z = 0
        External_Z = 2

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.spectroscopy.property.modulation_output'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value(self) -> ValueEnum:
        return RootCoreSpectroscopyPropertyModulation_output.ValueEnum(self._context.get('root.core.spectroscopy.property.modulation_output.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.core.spectroscopy.property.modulation_output.value_raw', new_val.value)

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.core.spectroscopy.property.modulation_output.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.core.spectroscopy.property.modulation_output.value_raw', int(new_val))

    @property
    def enum(self) -> list:
        return list(self._context.get('root.core.spectroscopy.property.modulation_output.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.core.spectroscopy.property.modulation_output.enum', list(new_val))


class RootCoreSpectroscopyPropertySpec_end_mode(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        Keep_Last_Z_Position = 0
        Z_Controller_Active = 1

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.spectroscopy.property.spec_end_mode'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value(self) -> ValueEnum:
        return RootCoreSpectroscopyPropertySpec_end_mode.ValueEnum(self._context.get('root.core.spectroscopy.property.spec_end_mode.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.core.spectroscopy.property.spec_end_mode.value_raw', new_val.value)

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.core.spectroscopy.property.spec_end_mode.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.core.spectroscopy.property.spec_end_mode.value_raw', int(new_val))

    @property
    def enum(self) -> list:
        return list(self._context.get('root.core.spectroscopy.property.spec_end_mode.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.core.spectroscopy.property.spec_end_mode.enum', list(new_val))


class RootCoreSpectroscopyPropertyXy_move_speed(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.spectroscopy.property.xy_move_speed'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def unit(self) -> str:
        return str(self._context.get('root.core.spectroscopy.property.xy_move_speed.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.core.spectroscopy.property.xy_move_speed.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.core.spectroscopy.property.xy_move_speed.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.core.spectroscopy.property.xy_move_speed.value', float(new_val))


class RootCoreSpectroscopyPropertyStart_offset(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.spectroscopy.property.start_offset'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def unit(self) -> str:
        return str(self._context.get('root.core.spectroscopy.property.start_offset.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.core.spectroscopy.property.start_offset.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.core.spectroscopy.property.start_offset.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.core.spectroscopy.property.start_offset.value', float(new_val))


class RootCoreSpectroscopyPropertyForward_sampling_rate(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.spectroscopy.property.forward_sampling_rate'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def unit(self) -> str:
        return str(self._context.get('root.core.spectroscopy.property.forward_sampling_rate.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.core.spectroscopy.property.forward_sampling_rate.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.core.spectroscopy.property.forward_sampling_rate.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.core.spectroscopy.property.forward_sampling_rate.value', float(new_val))


class RootCoreSpectroscopyPropertyStart_offste_move_speed(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.spectroscopy.property.start_offste_move_speed'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def unit(self) -> str:
        return str(self._context.get('root.core.spectroscopy.property.start_offste_move_speed.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.core.spectroscopy.property.start_offste_move_speed.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.core.spectroscopy.property.start_offste_move_speed.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.core.spectroscopy.property.start_offste_move_speed.value', float(new_val))


class RootCoreSpectroscopyPropertyBackward_modulation_stop_value(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.spectroscopy.property.backward_modulation_stop_value'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def unit(self) -> str:
        return str(self._context.get('root.core.spectroscopy.property.backward_modulation_stop_value.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.core.spectroscopy.property.backward_modulation_stop_value.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.core.spectroscopy.property.backward_modulation_stop_value.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.core.spectroscopy.property.backward_modulation_stop_value.value', float(new_val))


class RootCoreSpectroscopyPropertyForward_datapoints(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.spectroscopy.property.forward_datapoints'
        self._lua_value_type = wrap.LuaType('int')

    @property
    def unit(self) -> str:
        return str(self._context.get('root.core.spectroscopy.property.forward_datapoints.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.core.spectroscopy.property.forward_datapoints.unit', str(new_val))

    @property
    def value(self) -> int:
        return int(self._context.get('root.core.spectroscopy.property.forward_datapoints.value'))

    @value.setter
    def value(self, new_val:int):
        self._context.set('root.core.spectroscopy.property.forward_datapoints.value', int(new_val))


class RootCoreSpectroscopyPropertyFeedback_active(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.spectroscopy.property.feedback_active'
        self._lua_value_type = wrap.LuaType('bool')

    @property
    def value(self) -> bool:
        return bool(self._context.get('root.core.spectroscopy.property.feedback_active.value'))

    @value.setter
    def value(self, new_val:bool):
        self._context.set('root.core.spectroscopy.property.feedback_active.value', bool(new_val))


class RootCoreSpectroscopyPropertyBackward_pause_time(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.spectroscopy.property.backward_pause_time'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def unit(self) -> str:
        return str(self._context.get('root.core.spectroscopy.property.backward_pause_time.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.core.spectroscopy.property.backward_pause_time.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.core.spectroscopy.property.backward_pause_time.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.core.spectroscopy.property.backward_pause_time.value', float(new_val))


class RootCoreSpectroscopyPropertyForward_pause_mode(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        Z_Off = 0
        Z_On = 1

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.spectroscopy.property.forward_pause_mode'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value(self) -> ValueEnum:
        return RootCoreSpectroscopyPropertyForward_pause_mode.ValueEnum(self._context.get('root.core.spectroscopy.property.forward_pause_mode.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.core.spectroscopy.property.forward_pause_mode.value_raw', new_val.value)

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.core.spectroscopy.property.forward_pause_mode.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.core.spectroscopy.property.forward_pause_mode.value_raw', int(new_val))

    @property
    def enum(self) -> list:
        return list(self._context.get('root.core.spectroscopy.property.forward_pause_mode.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.core.spectroscopy.property.forward_pause_mode.enum', list(new_val))


class RootCoreSpectroscopyPropertyAuto_recalibrate_probe_interval(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.spectroscopy.property.auto_recalibrate_probe_interval'
        self._lua_value_type = wrap.LuaType('int')

    @property
    def unit(self) -> str:
        return str(self._context.get('root.core.spectroscopy.property.auto_recalibrate_probe_interval.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.core.spectroscopy.property.auto_recalibrate_probe_interval.unit', str(new_val))

    @property
    def value(self) -> int:
        return int(self._context.get('root.core.spectroscopy.property.auto_recalibrate_probe_interval.value'))

    @value.setter
    def value(self, new_val:int):
        self._context.set('root.core.spectroscopy.property.auto_recalibrate_probe_interval.value', int(new_val))


class RootCoreSpectroscopyPropertyForward_modulation_stop_mode(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        Is_Less_Than = 0
        Is_Greater_Than = 1

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.spectroscopy.property.forward_modulation_stop_mode'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value(self) -> ValueEnum:
        return RootCoreSpectroscopyPropertyForward_modulation_stop_mode.ValueEnum(self._context.get('root.core.spectroscopy.property.forward_modulation_stop_mode.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.core.spectroscopy.property.forward_modulation_stop_mode.value_raw', new_val.value)

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.core.spectroscopy.property.forward_modulation_stop_mode.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.core.spectroscopy.property.forward_modulation_stop_mode.value_raw', int(new_val))

    @property
    def enum(self) -> list:
        return list(self._context.get('root.core.spectroscopy.property.forward_modulation_stop_mode.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.core.spectroscopy.property.forward_modulation_stop_mode.enum', list(new_val))


class RootCoreSpectroscopyPropertyModulation_relative_value(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.spectroscopy.property.modulation_relative_value'
        self._lua_value_type = wrap.LuaType('bool')

    @property
    def value(self) -> bool:
        return bool(self._context.get('root.core.spectroscopy.property.modulation_relative_value.value'))

    @value.setter
    def value(self, new_val:bool):
        self._context.set('root.core.spectroscopy.property.modulation_relative_value.value', bool(new_val))


class RootCoreSpectroscopyPropertyForward_pause_datapoints(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.spectroscopy.property.forward_pause_datapoints'
        self._lua_value_type = wrap.LuaType('int')

    @property
    def unit(self) -> str:
        return str(self._context.get('root.core.spectroscopy.property.forward_pause_datapoints.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.core.spectroscopy.property.forward_pause_datapoints.unit', str(new_val))

    @property
    def value(self) -> int:
        return int(self._context.get('root.core.spectroscopy.property.forward_pause_datapoints.value'))

    @value.setter
    def value(self, new_val:int):
        self._context.set('root.core.spectroscopy.property.forward_pause_datapoints.value', int(new_val))


class RootCoreSpectroscopyPropertyForward_pause_sampling_rate(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.spectroscopy.property.forward_pause_sampling_rate'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def unit(self) -> str:
        return str(self._context.get('root.core.spectroscopy.property.forward_pause_sampling_rate.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.core.spectroscopy.property.forward_pause_sampling_rate.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.core.spectroscopy.property.forward_pause_sampling_rate.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.core.spectroscopy.property.forward_pause_sampling_rate.value', float(new_val))


class RootCoreSpectroscopyPropertyBackward_pause_datapoints(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.spectroscopy.property.backward_pause_datapoints'
        self._lua_value_type = wrap.LuaType('int')

    @property
    def unit(self) -> str:
        return str(self._context.get('root.core.spectroscopy.property.backward_pause_datapoints.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.core.spectroscopy.property.backward_pause_datapoints.unit', str(new_val))

    @property
    def value(self) -> int:
        return int(self._context.get('root.core.spectroscopy.property.backward_pause_datapoints.value'))

    @value.setter
    def value(self, new_val:int):
        self._context.set('root.core.spectroscopy.property.backward_pause_datapoints.value', int(new_val))


class RootCoreSpectroscopyPropertyBackward_sampling_rate(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.spectroscopy.property.backward_sampling_rate'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def unit(self) -> str:
        return str(self._context.get('root.core.spectroscopy.property.backward_sampling_rate.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.core.spectroscopy.property.backward_sampling_rate.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.core.spectroscopy.property.backward_sampling_rate.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.core.spectroscopy.property.backward_sampling_rate.value', float(new_val))


class RootCoreSpectroscopyPropertyRepetition_count(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.spectroscopy.property.repetition_count'
        self._lua_value_type = wrap.LuaType('int')

    @property
    def unit(self) -> str:
        return str(self._context.get('root.core.spectroscopy.property.repetition_count.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.core.spectroscopy.property.repetition_count.unit', str(new_val))

    @property
    def value(self) -> int:
        return int(self._context.get('root.core.spectroscopy.property.repetition_count.value'))

    @value.setter
    def value(self, new_val:int):
        self._context.set('root.core.spectroscopy.property.repetition_count.value', int(new_val))


class RootCoreSpectroscopyPropertyBackward_modulation_mode(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        Fixed_Length = 0
        Stop_by_Value = 1

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.spectroscopy.property.backward_modulation_mode'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value(self) -> ValueEnum:
        return RootCoreSpectroscopyPropertyBackward_modulation_mode.ValueEnum(self._context.get('root.core.spectroscopy.property.backward_modulation_mode.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.core.spectroscopy.property.backward_modulation_mode.value_raw', new_val.value)

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.core.spectroscopy.property.backward_modulation_mode.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.core.spectroscopy.property.backward_modulation_mode.value_raw', int(new_val))

    @property
    def enum(self) -> list:
        return list(self._context.get('root.core.spectroscopy.property.backward_modulation_mode.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.core.spectroscopy.property.backward_modulation_mode.enum', list(new_val))


class RootCoreSpectroscopyProperty(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.spectroscopy.property'
        self.backward_modulation_mode = RootCoreSpectroscopyPropertyBackward_modulation_mode(self._context)
        self.repetition_count = RootCoreSpectroscopyPropertyRepetition_count(self._context)
        self.backward_sampling_rate = RootCoreSpectroscopyPropertyBackward_sampling_rate(self._context)
        self.backward_pause_datapoints = RootCoreSpectroscopyPropertyBackward_pause_datapoints(self._context)
        self.forward_pause_sampling_rate = RootCoreSpectroscopyPropertyForward_pause_sampling_rate(self._context)
        self.forward_pause_datapoints = RootCoreSpectroscopyPropertyForward_pause_datapoints(self._context)
        self.modulation_relative_value = RootCoreSpectroscopyPropertyModulation_relative_value(self._context)
        self.forward_modulation_stop_mode = RootCoreSpectroscopyPropertyForward_modulation_stop_mode(self._context)
        self.auto_recalibrate_probe_interval = RootCoreSpectroscopyPropertyAuto_recalibrate_probe_interval(self._context)
        self.forward_pause_mode = RootCoreSpectroscopyPropertyForward_pause_mode(self._context)
        self.backward_pause_time = RootCoreSpectroscopyPropertyBackward_pause_time(self._context)
        self.feedback_active = RootCoreSpectroscopyPropertyFeedback_active(self._context)
        self.forward_datapoints = RootCoreSpectroscopyPropertyForward_datapoints(self._context)
        self.backward_modulation_stop_value = RootCoreSpectroscopyPropertyBackward_modulation_stop_value(self._context)
        self.start_offste_move_speed = RootCoreSpectroscopyPropertyStart_offste_move_speed(self._context)
        self.forward_sampling_rate = RootCoreSpectroscopyPropertyForward_sampling_rate(self._context)
        self.start_offset = RootCoreSpectroscopyPropertyStart_offset(self._context)
        self.xy_move_speed = RootCoreSpectroscopyPropertyXy_move_speed(self._context)
        self.spec_end_mode = RootCoreSpectroscopyPropertySpec_end_mode(self._context)
        self.modulation_output = RootCoreSpectroscopyPropertyModulation_output(self._context)
        self.backward_pause_sampling_rate = RootCoreSpectroscopyPropertyBackward_pause_sampling_rate(self._context)
        self.forward_pause_time = RootCoreSpectroscopyPropertyForward_pause_time(self._context)
        self.forward_move_speed = RootCoreSpectroscopyPropertyForward_move_speed(self._context)
        self.forward_modulation_range = RootCoreSpectroscopyPropertyForward_modulation_range(self._context)
        self.backward_modulation_time = RootCoreSpectroscopyPropertyBackward_modulation_time(self._context)
        self.backward_modulation_range = RootCoreSpectroscopyPropertyBackward_modulation_range(self._context)
        self.forward_modulation_time = RootCoreSpectroscopyPropertyForward_modulation_time(self._context)
        self.forward_modulation_mode = RootCoreSpectroscopyPropertyForward_modulation_mode(self._context)
        self.backward_modulation_stop_mode = RootCoreSpectroscopyPropertyBackward_modulation_stop_mode(self._context)
        self.forward_modulation_stop_value = RootCoreSpectroscopyPropertyForward_modulation_stop_value(self._context)
        self.backward_pause_mode = RootCoreSpectroscopyPropertyBackward_pause_mode(self._context)
        self.backward_move_speed = RootCoreSpectroscopyPropertyBackward_move_speed(self._context)
        self.backward_datapoints = RootCoreSpectroscopyPropertyBackward_datapoints(self._context)


class RootCoreSpectroscopySignal(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.spectroscopy.signal'


class RootCoreSpectroscopy(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.spectroscopy'
        self.signal = RootCoreSpectroscopySignal(self._context)
        self.property = RootCoreSpectroscopyProperty(self._context)

    def start(self, *args) -> Any:
        return self._context.call('root.core.spectroscopy.start', *args)

    def abort(self, *args) -> Any:
        return self._context.call('root.core.spectroscopy.abort', *args)


class RootCoreCore_cantileverPropertyCurrent_cantilever_spring_constant(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.core_cantilever.property.current_cantilever_spring_constant'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def unit(self) -> str:
        return str(self._context.get('root.core.core_cantilever.property.current_cantilever_spring_constant.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.core.core_cantilever.property.current_cantilever_spring_constant.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.core.core_cantilever.property.current_cantilever_spring_constant.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.core.core_cantilever.property.current_cantilever_spring_constant.value', float(new_val))


class RootCoreCore_cantileverPropertyCurrent_cantilever_q_factor(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.core_cantilever.property.current_cantilever_q_factor'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def unit(self) -> str:
        return str(self._context.get('root.core.core_cantilever.property.current_cantilever_q_factor.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.core.core_cantilever.property.current_cantilever_q_factor.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.core.core_cantilever.property.current_cantilever_q_factor.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.core.core_cantilever.property.current_cantilever_q_factor.value', float(new_val))


class RootCoreCore_cantileverPropertyCurrent_cantilever_deflection_sensitivity(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.core_cantilever.property.current_cantilever_deflection_sensitivity'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def unit(self) -> str:
        return str(self._context.get('root.core.core_cantilever.property.current_cantilever_deflection_sensitivity.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.core.core_cantilever.property.current_cantilever_deflection_sensitivity.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.core.core_cantilever.property.current_cantilever_deflection_sensitivity.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.core.core_cantilever.property.current_cantilever_deflection_sensitivity.value', float(new_val))


class RootCoreCore_cantileverPropertyCurrent_cantilever_resonance_frequency(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.core_cantilever.property.current_cantilever_resonance_frequency'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def unit(self) -> str:
        return str(self._context.get('root.core.core_cantilever.property.current_cantilever_resonance_frequency.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.core.core_cantilever.property.current_cantilever_resonance_frequency.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.core.core_cantilever.property.current_cantilever_resonance_frequency.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.core.core_cantilever.property.current_cantilever_resonance_frequency.value', float(new_val))


class RootCoreCore_cantileverProperty(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.core_cantilever.property'
        self.current_cantilever_resonance_frequency = RootCoreCore_cantileverPropertyCurrent_cantilever_resonance_frequency(self._context)
        self.current_cantilever_deflection_sensitivity = RootCoreCore_cantileverPropertyCurrent_cantilever_deflection_sensitivity(self._context)
        self.current_cantilever_q_factor = RootCoreCore_cantileverPropertyCurrent_cantilever_q_factor(self._context)
        self.current_cantilever_spring_constant = RootCoreCore_cantileverPropertyCurrent_cantilever_spring_constant(self._context)


class RootCoreCore_cantilever(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.core_cantilever'
        self.property = RootCoreCore_cantileverProperty(self._context)

    def apply(self, *args) -> Any:
        return self._context.call('root.core.core_cantilever.apply', *args)

    def current_cantilever(self, *args) -> Any:
        return self._context.call('root.core.core_cantilever.current_cantilever', *args)


class RootCoreComp_dc(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.comp_dc'


class RootCoreImaging(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.imaging'


class RootCoreSignal_registration(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.signal_registration'


class RootCoreCore_options(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.core_options'


class RootCoreCore_monitoring(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.core_monitoring'


class RootCoreSampler(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.sampler'


class RootCoreLaser_align_drive_implPropertyMotor_laser_photodetector_y_position(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.laser_align_drive_impl.property.motor_laser_photodetector_y_position'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def unit(self) -> str:
        return str(self._context.get('root.core.laser_align_drive_impl.property.motor_laser_photodetector_y_position.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.core.laser_align_drive_impl.property.motor_laser_photodetector_y_position.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.core.laser_align_drive_impl.property.motor_laser_photodetector_y_position.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.core.laser_align_drive_impl.property.motor_laser_photodetector_y_position.value', float(new_val))


class RootCoreLaser_align_drive_implPropertyMotor_laser_clean_drive_y_position(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.laser_align_drive_impl.property.motor_laser_clean_drive_y_position'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def unit(self) -> str:
        return str(self._context.get('root.core.laser_align_drive_impl.property.motor_laser_clean_drive_y_position.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.core.laser_align_drive_impl.property.motor_laser_clean_drive_y_position.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.core.laser_align_drive_impl.property.motor_laser_clean_drive_y_position.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.core.laser_align_drive_impl.property.motor_laser_clean_drive_y_position.value', float(new_val))


class RootCoreLaser_align_drive_implPropertyMotor_laser_readout_x_position(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.laser_align_drive_impl.property.motor_laser_readout_x_position'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def unit(self) -> str:
        return str(self._context.get('root.core.laser_align_drive_impl.property.motor_laser_readout_x_position.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.core.laser_align_drive_impl.property.motor_laser_readout_x_position.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.core.laser_align_drive_impl.property.motor_laser_readout_x_position.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.core.laser_align_drive_impl.property.motor_laser_readout_x_position.value', float(new_val))


class RootCoreLaser_align_drive_implPropertyDeflection_lateral(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.laser_align_drive_impl.property.deflection_lateral'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def unit(self) -> str:
        return str(self._context.get('root.core.laser_align_drive_impl.property.deflection_lateral.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.core.laser_align_drive_impl.property.deflection_lateral.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.core.laser_align_drive_impl.property.deflection_lateral.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.core.laser_align_drive_impl.property.deflection_lateral.value', float(new_val))


class RootCoreLaser_align_drive_implPropertyLaser_readout_power(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.laser_align_drive_impl.property.laser_readout_power'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def unit(self) -> str:
        return str(self._context.get('root.core.laser_align_drive_impl.property.laser_readout_power.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.core.laser_align_drive_impl.property.laser_readout_power.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.core.laser_align_drive_impl.property.laser_readout_power.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.core.laser_align_drive_impl.property.laser_readout_power.value', float(new_val))


class RootCoreLaser_align_drive_implPropertyMotor_laser_readout_y_position(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.laser_align_drive_impl.property.motor_laser_readout_y_position'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def unit(self) -> str:
        return str(self._context.get('root.core.laser_align_drive_impl.property.motor_laser_readout_y_position.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.core.laser_align_drive_impl.property.motor_laser_readout_y_position.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.core.laser_align_drive_impl.property.motor_laser_readout_y_position.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.core.laser_align_drive_impl.property.motor_laser_readout_y_position.value', float(new_val))


class RootCoreLaser_align_drive_implPropertyDeflection_normal(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.laser_align_drive_impl.property.deflection_normal'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def unit(self) -> str:
        return str(self._context.get('root.core.laser_align_drive_impl.property.deflection_normal.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.core.laser_align_drive_impl.property.deflection_normal.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.core.laser_align_drive_impl.property.deflection_normal.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.core.laser_align_drive_impl.property.deflection_normal.value', float(new_val))


class RootCoreLaser_align_drive_implPropertyLaser_spot_intensity(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.laser_align_drive_impl.property.laser_spot_intensity'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def unit(self) -> str:
        return str(self._context.get('root.core.laser_align_drive_impl.property.laser_spot_intensity.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.core.laser_align_drive_impl.property.laser_spot_intensity.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.core.laser_align_drive_impl.property.laser_spot_intensity.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.core.laser_align_drive_impl.property.laser_spot_intensity.value', float(new_val))


class RootCoreLaser_align_drive_implPropertyLaser_clean_drive_power(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.laser_align_drive_impl.property.laser_clean_drive_power'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def unit(self) -> str:
        return str(self._context.get('root.core.laser_align_drive_impl.property.laser_clean_drive_power.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.core.laser_align_drive_impl.property.laser_clean_drive_power.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.core.laser_align_drive_impl.property.laser_clean_drive_power.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.core.laser_align_drive_impl.property.laser_clean_drive_power.value', float(new_val))


class RootCoreLaser_align_drive_implPropertyMotor_laser_photodetector_x_position(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.laser_align_drive_impl.property.motor_laser_photodetector_x_position'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def unit(self) -> str:
        return str(self._context.get('root.core.laser_align_drive_impl.property.motor_laser_photodetector_x_position.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.core.laser_align_drive_impl.property.motor_laser_photodetector_x_position.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.core.laser_align_drive_impl.property.motor_laser_photodetector_x_position.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.core.laser_align_drive_impl.property.motor_laser_photodetector_x_position.value', float(new_val))


class RootCoreLaser_align_drive_implPropertyMotor_speed_max_beam_shifter(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.laser_align_drive_impl.property.motor_speed_max_beam_shifter'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def unit(self) -> str:
        return str(self._context.get('root.core.laser_align_drive_impl.property.motor_speed_max_beam_shifter.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.core.laser_align_drive_impl.property.motor_speed_max_beam_shifter.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.core.laser_align_drive_impl.property.motor_speed_max_beam_shifter.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.core.laser_align_drive_impl.property.motor_speed_max_beam_shifter.value', float(new_val))


class RootCoreLaser_align_drive_implPropertyLaser_clean_drive_enabled(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.laser_align_drive_impl.property.laser_clean_drive_enabled'
        self._lua_value_type = wrap.LuaType('bool')

    @property
    def value(self) -> bool:
        return bool(self._context.get('root.core.laser_align_drive_impl.property.laser_clean_drive_enabled.value'))

    @value.setter
    def value(self, new_val:bool):
        self._context.set('root.core.laser_align_drive_impl.property.laser_clean_drive_enabled.value', bool(new_val))


class RootCoreLaser_align_drive_implPropertyScan_mode(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.laser_align_drive_impl.property.scan_mode'
        self._lua_value_type = wrap.LuaType('bool')

    @property
    def value(self) -> bool:
        return bool(self._context.get('root.core.laser_align_drive_impl.property.scan_mode.value'))

    @value.setter
    def value(self, new_val:bool):
        self._context.set('root.core.laser_align_drive_impl.property.scan_mode.value', bool(new_val))


class RootCoreLaser_align_drive_implPropertySensor_status(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        Ok = 2
        Undefined = 0
        Low = 1
        High = 3
        Fail = 4

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.laser_align_drive_impl.property.sensor_status'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value(self) -> ValueEnum:
        return RootCoreLaser_align_drive_implPropertySensor_status.ValueEnum(self._context.get('root.core.laser_align_drive_impl.property.sensor_status.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.core.laser_align_drive_impl.property.sensor_status.value_raw', new_val.value)

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.core.laser_align_drive_impl.property.sensor_status.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.core.laser_align_drive_impl.property.sensor_status.value_raw', int(new_val))

    @property
    def enum(self) -> list:
        return list(self._context.get('root.core.laser_align_drive_impl.property.sensor_status.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.core.laser_align_drive_impl.property.sensor_status.enum', list(new_val))


class RootCoreLaser_align_drive_implPropertyMotor_speed_max_laser_focus(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.laser_align_drive_impl.property.motor_speed_max_laser_focus'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def unit(self) -> str:
        return str(self._context.get('root.core.laser_align_drive_impl.property.motor_speed_max_laser_focus.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.core.laser_align_drive_impl.property.motor_speed_max_laser_focus.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.core.laser_align_drive_impl.property.motor_speed_max_laser_focus.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.core.laser_align_drive_impl.property.motor_speed_max_laser_focus.value', float(new_val))


class RootCoreLaser_align_drive_implPropertyMotor_speed_max_laser_motors(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.laser_align_drive_impl.property.motor_speed_max_laser_motors'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def unit(self) -> str:
        return str(self._context.get('root.core.laser_align_drive_impl.property.motor_speed_max_laser_motors.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.core.laser_align_drive_impl.property.motor_speed_max_laser_motors.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.core.laser_align_drive_impl.property.motor_speed_max_laser_motors.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.core.laser_align_drive_impl.property.motor_speed_max_laser_motors.value', float(new_val))


class RootCoreLaser_align_drive_implPropertyLaser_readout_enabled(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.laser_align_drive_impl.property.laser_readout_enabled'
        self._lua_value_type = wrap.LuaType('bool')

    @property
    def value(self) -> bool:
        return bool(self._context.get('root.core.laser_align_drive_impl.property.laser_readout_enabled.value'))

    @value.setter
    def value(self, new_val:bool):
        self._context.set('root.core.laser_align_drive_impl.property.laser_readout_enabled.value', bool(new_val))


class RootCoreLaser_align_drive_implPropertyMotor_speed_laser_motors(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.laser_align_drive_impl.property.motor_speed_laser_motors'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def unit(self) -> str:
        return str(self._context.get('root.core.laser_align_drive_impl.property.motor_speed_laser_motors.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.core.laser_align_drive_impl.property.motor_speed_laser_motors.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.core.laser_align_drive_impl.property.motor_speed_laser_motors.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.core.laser_align_drive_impl.property.motor_speed_laser_motors.value', float(new_val))


class RootCoreLaser_align_drive_implPropertyMotor_laser_clean_drive_x_position(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.laser_align_drive_impl.property.motor_laser_clean_drive_x_position'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def unit(self) -> str:
        return str(self._context.get('root.core.laser_align_drive_impl.property.motor_laser_clean_drive_x_position.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.core.laser_align_drive_impl.property.motor_laser_clean_drive_x_position.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.core.laser_align_drive_impl.property.motor_laser_clean_drive_x_position.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.core.laser_align_drive_impl.property.motor_laser_clean_drive_x_position.value', float(new_val))


class RootCoreLaser_align_drive_implPropertyDeflection_offset_calibration_status(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        Calibration_Error = 1
        Sensor_Signal_Failed = 2
        No_Error = 0

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.laser_align_drive_impl.property.deflection_offset_calibration_status'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value(self) -> ValueEnum:
        return RootCoreLaser_align_drive_implPropertyDeflection_offset_calibration_status.ValueEnum(self._context.get('root.core.laser_align_drive_impl.property.deflection_offset_calibration_status.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.core.laser_align_drive_impl.property.deflection_offset_calibration_status.value_raw', new_val.value)

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.core.laser_align_drive_impl.property.deflection_offset_calibration_status.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.core.laser_align_drive_impl.property.deflection_offset_calibration_status.value_raw', int(new_val))

    @property
    def enum(self) -> list:
        return list(self._context.get('root.core.laser_align_drive_impl.property.deflection_offset_calibration_status.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.core.laser_align_drive_impl.property.deflection_offset_calibration_status.enum', list(new_val))


class RootCoreLaser_align_drive_implPropertyMotor_beam_shifter_position(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.laser_align_drive_impl.property.motor_beam_shifter_position'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def unit(self) -> str:
        return str(self._context.get('root.core.laser_align_drive_impl.property.motor_beam_shifter_position.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.core.laser_align_drive_impl.property.motor_beam_shifter_position.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.core.laser_align_drive_impl.property.motor_beam_shifter_position.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.core.laser_align_drive_impl.property.motor_beam_shifter_position.value', float(new_val))


class RootCoreLaser_align_drive_implPropertyMotor_laser_focus_z_position(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.laser_align_drive_impl.property.motor_laser_focus_z_position'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def unit(self) -> str:
        return str(self._context.get('root.core.laser_align_drive_impl.property.motor_laser_focus_z_position.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.core.laser_align_drive_impl.property.motor_laser_focus_z_position.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.core.laser_align_drive_impl.property.motor_laser_focus_z_position.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.core.laser_align_drive_impl.property.motor_laser_focus_z_position.value', float(new_val))


class RootCoreLaser_align_drive_implPropertyLaser_clean_drive_amplitude(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.laser_align_drive_impl.property.laser_clean_drive_amplitude'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def unit(self) -> str:
        return str(self._context.get('root.core.laser_align_drive_impl.property.laser_clean_drive_amplitude.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.core.laser_align_drive_impl.property.laser_clean_drive_amplitude.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.core.laser_align_drive_impl.property.laser_clean_drive_amplitude.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.core.laser_align_drive_impl.property.laser_clean_drive_amplitude.value', float(new_val))


class RootCoreLaser_align_drive_implProperty(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.laser_align_drive_impl.property'
        self.laser_clean_drive_amplitude = RootCoreLaser_align_drive_implPropertyLaser_clean_drive_amplitude(self._context)
        self.motor_laser_focus_z_position = RootCoreLaser_align_drive_implPropertyMotor_laser_focus_z_position(self._context)
        self.motor_beam_shifter_position = RootCoreLaser_align_drive_implPropertyMotor_beam_shifter_position(self._context)
        self.deflection_offset_calibration_status = RootCoreLaser_align_drive_implPropertyDeflection_offset_calibration_status(self._context)
        self.motor_laser_clean_drive_x_position = RootCoreLaser_align_drive_implPropertyMotor_laser_clean_drive_x_position(self._context)
        self.motor_speed_laser_motors = RootCoreLaser_align_drive_implPropertyMotor_speed_laser_motors(self._context)
        self.laser_readout_enabled = RootCoreLaser_align_drive_implPropertyLaser_readout_enabled(self._context)
        self.motor_speed_max_laser_motors = RootCoreLaser_align_drive_implPropertyMotor_speed_max_laser_motors(self._context)
        self.motor_speed_max_laser_focus = RootCoreLaser_align_drive_implPropertyMotor_speed_max_laser_focus(self._context)
        self.sensor_status = RootCoreLaser_align_drive_implPropertySensor_status(self._context)
        self.scan_mode = RootCoreLaser_align_drive_implPropertyScan_mode(self._context)
        self.laser_clean_drive_enabled = RootCoreLaser_align_drive_implPropertyLaser_clean_drive_enabled(self._context)
        self.motor_speed_max_beam_shifter = RootCoreLaser_align_drive_implPropertyMotor_speed_max_beam_shifter(self._context)
        self.motor_laser_photodetector_x_position = RootCoreLaser_align_drive_implPropertyMotor_laser_photodetector_x_position(self._context)
        self.laser_clean_drive_power = RootCoreLaser_align_drive_implPropertyLaser_clean_drive_power(self._context)
        self.laser_spot_intensity = RootCoreLaser_align_drive_implPropertyLaser_spot_intensity(self._context)
        self.deflection_normal = RootCoreLaser_align_drive_implPropertyDeflection_normal(self._context)
        self.motor_laser_readout_y_position = RootCoreLaser_align_drive_implPropertyMotor_laser_readout_y_position(self._context)
        self.laser_readout_power = RootCoreLaser_align_drive_implPropertyLaser_readout_power(self._context)
        self.deflection_lateral = RootCoreLaser_align_drive_implPropertyDeflection_lateral(self._context)
        self.motor_laser_readout_x_position = RootCoreLaser_align_drive_implPropertyMotor_laser_readout_x_position(self._context)
        self.motor_laser_clean_drive_y_position = RootCoreLaser_align_drive_implPropertyMotor_laser_clean_drive_y_position(self._context)
        self.motor_laser_photodetector_y_position = RootCoreLaser_align_drive_implPropertyMotor_laser_photodetector_y_position(self._context)


class RootCoreLaser_align_drive_implSignalMotor_move_started(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.laser_align_drive_impl.signal.motor_move_started'

    def empty(self, *args) -> Any:
        return self._context.call('root.core.laser_align_drive_impl.signal.motor_move_started.empty', *args)

    def call(self, *args) -> Any:
        return self._context.call('root.core.laser_align_drive_impl.signal.motor_move_started.call', *args)

    def connect(self, *args) -> Any:
        return self._context.call('root.core.laser_align_drive_impl.signal.motor_move_started.connect', *args)

    def connect_extended(self, *args) -> Any:
        return self._context.call('root.core.laser_align_drive_impl.signal.motor_move_started.connect_extended', *args)


class RootCoreLaser_align_drive_implSignalProcedure_info(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.laser_align_drive_impl.signal.procedure_info'

    def empty(self, *args) -> Any:
        return self._context.call('root.core.laser_align_drive_impl.signal.procedure_info.empty', *args)

    def call(self, *args) -> Any:
        return self._context.call('root.core.laser_align_drive_impl.signal.procedure_info.call', *args)

    def connect(self, *args) -> Any:
        return self._context.call('root.core.laser_align_drive_impl.signal.procedure_info.connect', *args)

    def connect_extended(self, *args) -> Any:
        return self._context.call('root.core.laser_align_drive_impl.signal.procedure_info.connect_extended', *args)


class RootCoreLaser_align_drive_implSignalMotor_move_finished(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.laser_align_drive_impl.signal.motor_move_finished'

    def empty(self, *args) -> Any:
        return self._context.call('root.core.laser_align_drive_impl.signal.motor_move_finished.empty', *args)

    def call(self, *args) -> Any:
        return self._context.call('root.core.laser_align_drive_impl.signal.motor_move_finished.call', *args)

    def connect(self, *args) -> Any:
        return self._context.call('root.core.laser_align_drive_impl.signal.motor_move_finished.connect', *args)

    def connect_extended(self, *args) -> Any:
        return self._context.call('root.core.laser_align_drive_impl.signal.motor_move_finished.connect_extended', *args)


class RootCoreLaser_align_drive_implSignalCenter_detector_finished(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.laser_align_drive_impl.signal.center_detector_finished'

    def empty(self, *args) -> Any:
        return self._context.call('root.core.laser_align_drive_impl.signal.center_detector_finished.empty', *args)

    def call(self, *args) -> Any:
        return self._context.call('root.core.laser_align_drive_impl.signal.center_detector_finished.call', *args)

    def connect(self, *args) -> Any:
        return self._context.call('root.core.laser_align_drive_impl.signal.center_detector_finished.connect', *args)

    def connect_extended(self, *args) -> Any:
        return self._context.call('root.core.laser_align_drive_impl.signal.center_detector_finished.connect_extended', *args)


class RootCoreLaser_align_drive_implSignalAuto_align_finished(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.laser_align_drive_impl.signal.auto_align_finished'

    def empty(self, *args) -> Any:
        return self._context.call('root.core.laser_align_drive_impl.signal.auto_align_finished.empty', *args)

    def call(self, *args) -> Any:
        return self._context.call('root.core.laser_align_drive_impl.signal.auto_align_finished.call', *args)

    def connect(self, *args) -> Any:
        return self._context.call('root.core.laser_align_drive_impl.signal.auto_align_finished.connect', *args)

    def connect_extended(self, *args) -> Any:
        return self._context.call('root.core.laser_align_drive_impl.signal.auto_align_finished.connect_extended', *args)


class RootCoreLaser_align_drive_implSignalAuto_align_search_step_finished(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.laser_align_drive_impl.signal.auto_align_search_step_finished'

    def empty(self, *args) -> Any:
        return self._context.call('root.core.laser_align_drive_impl.signal.auto_align_search_step_finished.empty', *args)

    def call(self, *args) -> Any:
        return self._context.call('root.core.laser_align_drive_impl.signal.auto_align_search_step_finished.call', *args)

    def connect(self, *args) -> Any:
        return self._context.call('root.core.laser_align_drive_impl.signal.auto_align_search_step_finished.connect', *args)

    def connect_extended(self, *args) -> Any:
        return self._context.call('root.core.laser_align_drive_impl.signal.auto_align_search_step_finished.connect_extended', *args)


class RootCoreLaser_align_drive_implSignalAuto_align_pte_aligned(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.laser_align_drive_impl.signal.auto_align_pte_aligned'

    def empty(self, *args) -> Any:
        return self._context.call('root.core.laser_align_drive_impl.signal.auto_align_pte_aligned.empty', *args)

    def call(self, *args) -> Any:
        return self._context.call('root.core.laser_align_drive_impl.signal.auto_align_pte_aligned.call', *args)

    def connect(self, *args) -> Any:
        return self._context.call('root.core.laser_align_drive_impl.signal.auto_align_pte_aligned.connect', *args)

    def connect_extended(self, *args) -> Any:
        return self._context.call('root.core.laser_align_drive_impl.signal.auto_align_pte_aligned.connect_extended', *args)


class RootCoreLaser_align_drive_implSignal(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.laser_align_drive_impl.signal'
        self.auto_align_pte_aligned = RootCoreLaser_align_drive_implSignalAuto_align_pte_aligned(self._context)
        self.auto_align_search_step_finished = RootCoreLaser_align_drive_implSignalAuto_align_search_step_finished(self._context)
        self.auto_align_finished = RootCoreLaser_align_drive_implSignalAuto_align_finished(self._context)
        self.center_detector_finished = RootCoreLaser_align_drive_implSignalCenter_detector_finished(self._context)
        self.motor_move_finished = RootCoreLaser_align_drive_implSignalMotor_move_finished(self._context)
        self.procedure_info = RootCoreLaser_align_drive_implSignalProcedure_info(self._context)
        self.motor_move_started = RootCoreLaser_align_drive_implSignalMotor_move_started(self._context)


class RootCoreLaser_align_drive_impl(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.laser_align_drive_impl'
        self.signal = RootCoreLaser_align_drive_implSignal(self._context)
        self.property = RootCoreLaser_align_drive_implProperty(self._context)

    def start_updating_detector_status(self, *args) -> Any:
        return self._context.call('root.core.laser_align_drive_impl.start_updating_detector_status', *args)

    def center_detector(self, *args) -> Any:
        return self._context.call('root.core.laser_align_drive_impl.center_detector', *args)

    def start_moving_motors(self, *args) -> Any:
        return self._context.call('root.core.laser_align_drive_impl.start_moving_motors', *args)

    def zero_position(self, *args) -> Any:
        return self._context.call('root.core.laser_align_drive_impl.zero_position', *args)

    def stop_motors(self, *args) -> Any:
        return self._context.call('root.core.laser_align_drive_impl.stop_motors', *args)

    def start_move_to_optical_center(self, *args) -> Any:
        return self._context.call('root.core.laser_align_drive_impl.start_move_to_optical_center', *args)

    def move_motors_by_step(self, *args) -> Any:
        return self._context.call('root.core.laser_align_drive_impl.move_motors_by_step', *args)

    def reference_motor(self, *args) -> Any:
        return self._context.call('root.core.laser_align_drive_impl.reference_motor', *args)

    def start_search_algorithm(self, *args) -> Any:
        return self._context.call('root.core.laser_align_drive_impl.start_search_algorithm', *args)

    def abort_center_detector(self, *args) -> Any:
        return self._context.call('root.core.laser_align_drive_impl.abort_center_detector', *args)

    def start_optimizing(self, *args) -> Any:
        return self._context.call('root.core.laser_align_drive_impl.start_optimizing', *args)

    def auto_align(self, *args) -> Any:
        return self._context.call('root.core.laser_align_drive_impl.auto_align', *args)

    def stop_updating_detector_status(self, *args) -> Any:
        return self._context.call('root.core.laser_align_drive_impl.stop_updating_detector_status', *args)

    def abort_auto_align(self, *args) -> Any:
        return self._context.call('root.core.laser_align_drive_impl.abort_auto_align', *args)


class RootCoreThermal_tuneSignalData_invalidated(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.thermal_tune.signal.data_invalidated'

    def empty(self, *args) -> Any:
        return self._context.call('root.core.thermal_tune.signal.data_invalidated.empty', *args)

    def call(self, *args) -> Any:
        return self._context.call('root.core.thermal_tune.signal.data_invalidated.call', *args)

    def connect(self, *args) -> Any:
        return self._context.call('root.core.thermal_tune.signal.data_invalidated.connect', *args)

    def connect_extended(self, *args) -> Any:
        return self._context.call('root.core.thermal_tune.signal.data_invalidated.connect_extended', *args)


class RootCoreThermal_tuneSignalNew_average(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.thermal_tune.signal.new_average'

    def empty(self, *args) -> Any:
        return self._context.call('root.core.thermal_tune.signal.new_average.empty', *args)

    def call(self, *args) -> Any:
        return self._context.call('root.core.thermal_tune.signal.new_average.call', *args)

    def connect(self, *args) -> Any:
        return self._context.call('root.core.thermal_tune.signal.new_average.connect', *args)

    def connect_extended(self, *args) -> Any:
        return self._context.call('root.core.thermal_tune.signal.new_average.connect_extended', *args)


class RootCoreThermal_tuneSignalNew_fit(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.thermal_tune.signal.new_fit'

    def empty(self, *args) -> Any:
        return self._context.call('root.core.thermal_tune.signal.new_fit.empty', *args)

    def call(self, *args) -> Any:
        return self._context.call('root.core.thermal_tune.signal.new_fit.call', *args)

    def connect(self, *args) -> Any:
        return self._context.call('root.core.thermal_tune.signal.new_fit.connect', *args)

    def connect_extended(self, *args) -> Any:
        return self._context.call('root.core.thermal_tune.signal.new_fit.connect_extended', *args)


class RootCoreThermal_tuneSignalEnded(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.thermal_tune.signal.ended'

    def empty(self, *args) -> Any:
        return self._context.call('root.core.thermal_tune.signal.ended.empty', *args)

    def call(self, *args) -> Any:
        return self._context.call('root.core.thermal_tune.signal.ended.call', *args)

    def connect(self, *args) -> Any:
        return self._context.call('root.core.thermal_tune.signal.ended.connect', *args)

    def connect_extended(self, *args) -> Any:
        return self._context.call('root.core.thermal_tune.signal.ended.connect_extended', *args)


class RootCoreThermal_tuneSignalProcedure_info(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.thermal_tune.signal.procedure_info'

    def empty(self, *args) -> Any:
        return self._context.call('root.core.thermal_tune.signal.procedure_info.empty', *args)

    def call(self, *args) -> Any:
        return self._context.call('root.core.thermal_tune.signal.procedure_info.call', *args)

    def connect(self, *args) -> Any:
        return self._context.call('root.core.thermal_tune.signal.procedure_info.connect', *args)

    def connect_extended(self, *args) -> Any:
        return self._context.call('root.core.thermal_tune.signal.procedure_info.connect_extended', *args)


class RootCoreThermal_tuneSignalStarted(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.thermal_tune.signal.started'

    def empty(self, *args) -> Any:
        return self._context.call('root.core.thermal_tune.signal.started.empty', *args)

    def call(self, *args) -> Any:
        return self._context.call('root.core.thermal_tune.signal.started.call', *args)

    def connect(self, *args) -> Any:
        return self._context.call('root.core.thermal_tune.signal.started.connect', *args)

    def connect_extended(self, *args) -> Any:
        return self._context.call('root.core.thermal_tune.signal.started.connect_extended', *args)


class RootCoreThermal_tuneSignalNew_frequency_list(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.thermal_tune.signal.new_frequency_list'

    def empty(self, *args) -> Any:
        return self._context.call('root.core.thermal_tune.signal.new_frequency_list.empty', *args)

    def call(self, *args) -> Any:
        return self._context.call('root.core.thermal_tune.signal.new_frequency_list.call', *args)

    def connect(self, *args) -> Any:
        return self._context.call('root.core.thermal_tune.signal.new_frequency_list.connect', *args)

    def connect_extended(self, *args) -> Any:
        return self._context.call('root.core.thermal_tune.signal.new_frequency_list.connect_extended', *args)


class RootCoreThermal_tuneSignalProgress(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.thermal_tune.signal.progress'

    def empty(self, *args) -> Any:
        return self._context.call('root.core.thermal_tune.signal.progress.empty', *args)

    def call(self, *args) -> Any:
        return self._context.call('root.core.thermal_tune.signal.progress.call', *args)

    def connect(self, *args) -> Any:
        return self._context.call('root.core.thermal_tune.signal.progress.connect', *args)

    def connect_extended(self, *args) -> Any:
        return self._context.call('root.core.thermal_tune.signal.progress.connect_extended', *args)


class RootCoreThermal_tuneSignal(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.thermal_tune.signal'
        self.progress = RootCoreThermal_tuneSignalProgress(self._context)
        self.new_frequency_list = RootCoreThermal_tuneSignalNew_frequency_list(self._context)
        self.started = RootCoreThermal_tuneSignalStarted(self._context)
        self.procedure_info = RootCoreThermal_tuneSignalProcedure_info(self._context)
        self.ended = RootCoreThermal_tuneSignalEnded(self._context)
        self.new_fit = RootCoreThermal_tuneSignalNew_fit(self._context)
        self.new_average = RootCoreThermal_tuneSignalNew_average(self._context)
        self.data_invalidated = RootCoreThermal_tuneSignalData_invalidated(self._context)


class RootCoreThermal_tunePropertyFit_frequency_lower_bound(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.thermal_tune.property.fit_frequency_lower_bound'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def unit(self) -> str:
        return str(self._context.get('root.core.thermal_tune.property.fit_frequency_lower_bound.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.core.thermal_tune.property.fit_frequency_lower_bound.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.core.thermal_tune.property.fit_frequency_lower_bound.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.core.thermal_tune.property.fit_frequency_lower_bound.value', float(new_val))


class RootCoreThermal_tunePropertyTemperature(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.thermal_tune.property.temperature'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def unit(self) -> str:
        return str(self._context.get('root.core.thermal_tune.property.temperature.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.core.thermal_tune.property.temperature.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.core.thermal_tune.property.temperature.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.core.thermal_tune.property.temperature.value', float(new_val))


class RootCoreThermal_tunePropertyMax_frequency(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.thermal_tune.property.max_frequency'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def unit(self) -> str:
        return str(self._context.get('root.core.thermal_tune.property.max_frequency.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.core.thermal_tune.property.max_frequency.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.core.thermal_tune.property.max_frequency.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.core.thermal_tune.property.max_frequency.value', float(new_val))


class RootCoreThermal_tunePropertyMeasurement_environment(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        Air = 0
        Liquid = 1

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.thermal_tune.property.measurement_environment'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value(self) -> ValueEnum:
        return RootCoreThermal_tunePropertyMeasurement_environment.ValueEnum(self._context.get('root.core.thermal_tune.property.measurement_environment.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.core.thermal_tune.property.measurement_environment.value_raw', new_val.value)

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.core.thermal_tune.property.measurement_environment.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.core.thermal_tune.property.measurement_environment.value_raw', int(new_val))

    @property
    def enum(self) -> list:
        return list(self._context.get('root.core.thermal_tune.property.measurement_environment.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.core.thermal_tune.property.measurement_environment.enum', list(new_val))


class RootCoreThermal_tunePropertyFit_frequency_upper_bound(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.thermal_tune.property.fit_frequency_upper_bound'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def unit(self) -> str:
        return str(self._context.get('root.core.thermal_tune.property.fit_frequency_upper_bound.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.core.thermal_tune.property.fit_frequency_upper_bound.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.core.thermal_tune.property.fit_frequency_upper_bound.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.core.thermal_tune.property.fit_frequency_upper_bound.value', float(new_val))


class RootCoreThermal_tunePropertyIterations(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.thermal_tune.property.iterations'
        self._lua_value_type = wrap.LuaType('int')

    @property
    def value(self) -> int:
        return int(self._context.get('root.core.thermal_tune.property.iterations.value'))

    @value.setter
    def value(self, new_val:int):
        self._context.set('root.core.thermal_tune.property.iterations.value', int(new_val))


class RootCoreThermal_tunePropertyResolution(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.thermal_tune.property.resolution'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def unit(self) -> str:
        return str(self._context.get('root.core.thermal_tune.property.resolution.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.core.thermal_tune.property.resolution.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.core.thermal_tune.property.resolution.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.core.thermal_tune.property.resolution.value', float(new_val))


class RootCoreThermal_tuneProperty(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.thermal_tune.property'
        self.resolution = RootCoreThermal_tunePropertyResolution(self._context)
        self.iterations = RootCoreThermal_tunePropertyIterations(self._context)
        self.fit_frequency_upper_bound = RootCoreThermal_tunePropertyFit_frequency_upper_bound(self._context)
        self.measurement_environment = RootCoreThermal_tunePropertyMeasurement_environment(self._context)
        self.max_frequency = RootCoreThermal_tunePropertyMax_frequency(self._context)
        self.temperature = RootCoreThermal_tunePropertyTemperature(self._context)
        self.fit_frequency_lower_bound = RootCoreThermal_tunePropertyFit_frequency_lower_bound(self._context)


class RootCoreThermal_tune(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.thermal_tune'
        self.property = RootCoreThermal_tuneProperty(self._context)
        self.signal = RootCoreThermal_tuneSignal(self._context)

    def add_raw_data_to_fft_average_buffer(self, *args) -> Any:
        return self._context.call('root.core.thermal_tune.add_raw_data_to_fft_average_buffer', *args)

    def create_fit_from_fft_average_buffer(self, *args) -> Any:
        return self._context.call('root.core.thermal_tune.create_fit_from_fft_average_buffer', *args)

    def calculate_cantilever_calibration(self, *args) -> Any:
        return self._context.call('root.core.thermal_tune.calculate_cantilever_calibration', *args)

    def start(self, *args) -> Any:
        return self._context.call('root.core.thermal_tune.start', *args)

    def set_thermal_tune_parameters(self, *args) -> Any:
        return self._context.call('root.core.thermal_tune.set_thermal_tune_parameters', *args)

    def abort(self, *args) -> Any:
        return self._context.call('root.core.thermal_tune.abort', *args)

    def generate_frequency_list(self, *args) -> Any:
        return self._context.call('root.core.thermal_tune.generate_frequency_list', *args)


class RootCoreZ_controllerSignal(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.z_controller.signal'


class RootCoreZ_controllerPropertyI_gain(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.z_controller.property.i_gain'
        self._lua_value_type = wrap.LuaType('int')

    @property
    def value(self) -> int:
        return int(self._context.get('root.core.z_controller.property.i_gain.value'))

    @value.setter
    def value(self, new_val:int):
        self._context.set('root.core.z_controller.property.i_gain.value', int(new_val))


class RootCoreZ_controllerPropertyFeedback(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        Deflection = 0
        Dynamic_Mode_Amplitude_Reduction = 2
        WaveMode_Amplitude_Reduction = 1

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.z_controller.property.feedback'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value(self) -> ValueEnum:
        return RootCoreZ_controllerPropertyFeedback.ValueEnum(self._context.get('root.core.z_controller.property.feedback.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.core.z_controller.property.feedback.value_raw', new_val.value)

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.core.z_controller.property.feedback.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.core.z_controller.property.feedback.value_raw', int(new_val))

    @property
    def enum(self) -> list:
        return list(self._context.get('root.core.z_controller.property.feedback.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.core.z_controller.property.feedback.enum', list(new_val))


class RootCoreZ_controllerPropertyClosed_loop_i_gain(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.z_controller.property.closed_loop_i_gain'
        self._lua_value_type = wrap.LuaType('int')

    @property
    def value(self) -> int:
        return int(self._context.get('root.core.z_controller.property.closed_loop_i_gain.value'))

    @value.setter
    def value(self, new_val:int):
        self._context.set('root.core.z_controller.property.closed_loop_i_gain.value', int(new_val))


class RootCoreZ_controllerPropertyD_gain(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.z_controller.property.d_gain'
        self._lua_value_type = wrap.LuaType('int')

    @property
    def value(self) -> int:
        return int(self._context.get('root.core.z_controller.property.d_gain.value'))

    @value.setter
    def value(self, new_val:int):
        self._context.set('root.core.z_controller.property.d_gain.value', int(new_val))


class RootCoreZ_controllerPropertySetpoint(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.z_controller.property.setpoint'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def unit(self) -> str:
        return str(self._context.get('root.core.z_controller.property.setpoint.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.core.z_controller.property.setpoint.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.core.z_controller.property.setpoint.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.core.z_controller.property.setpoint.value', float(new_val))


class RootCoreZ_controllerPropertyActual_feedback_value(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.z_controller.property.actual_feedback_value'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def unit(self) -> str:
        return str(self._context.get('root.core.z_controller.property.actual_feedback_value.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.core.z_controller.property.actual_feedback_value.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.core.z_controller.property.actual_feedback_value.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.core.z_controller.property.actual_feedback_value.value', float(new_val))


class RootCoreZ_controllerPropertyClosed_loop_d_gain(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.z_controller.property.closed_loop_d_gain'
        self._lua_value_type = wrap.LuaType('int')

    @property
    def value(self) -> int:
        return int(self._context.get('root.core.z_controller.property.closed_loop_d_gain.value'))

    @value.setter
    def value(self, new_val:int):
        self._context.set('root.core.z_controller.property.closed_loop_d_gain.value', int(new_val))


class RootCoreZ_controllerPropertyBase_work_mode(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        Control_Z_by_Measurement_Mode = 2
        Drive_Z = 1
        Control_Z_by_Z_Sensor = 0

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.z_controller.property.base_work_mode'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value(self) -> ValueEnum:
        return RootCoreZ_controllerPropertyBase_work_mode.ValueEnum(self._context.get('root.core.z_controller.property.base_work_mode.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.core.z_controller.property.base_work_mode.value_raw', new_val.value)

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.core.z_controller.property.base_work_mode.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.core.z_controller.property.base_work_mode.value_raw', int(new_val))

    @property
    def enum(self) -> list:
        return list(self._context.get('root.core.z_controller.property.base_work_mode.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.core.z_controller.property.base_work_mode.enum', list(new_val))


class RootCoreZ_controllerPropertyActual_tip_position(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.z_controller.property.actual_tip_position'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def unit(self) -> str:
        return str(self._context.get('root.core.z_controller.property.actual_tip_position.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.core.z_controller.property.actual_tip_position.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.core.z_controller.property.actual_tip_position.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.core.z_controller.property.actual_tip_position.value', float(new_val))


class RootCoreZ_controllerPropertyClosed_loop_p_gain(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.z_controller.property.closed_loop_p_gain'
        self._lua_value_type = wrap.LuaType('int')

    @property
    def value(self) -> int:
        return int(self._context.get('root.core.z_controller.property.closed_loop_p_gain.value'))

    @value.setter
    def value(self, new_val:int):
        self._context.set('root.core.z_controller.property.closed_loop_p_gain.value', int(new_val))


class RootCoreZ_controllerPropertyP_gain(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.z_controller.property.p_gain'
        self._lua_value_type = wrap.LuaType('int')

    @property
    def value(self) -> int:
        return int(self._context.get('root.core.z_controller.property.p_gain.value'))

    @value.setter
    def value(self, new_val:int):
        self._context.set('root.core.z_controller.property.p_gain.value', int(new_val))


class RootCoreZ_controllerPropertyIdle_mode(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        Keep_Last_Z_Position = 2
        Enable_Z_Controller = 0
        Absolute_Z_Position = 3
        Retract_Tip = 1

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.z_controller.property.idle_mode'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value(self) -> ValueEnum:
        return RootCoreZ_controllerPropertyIdle_mode.ValueEnum(self._context.get('root.core.z_controller.property.idle_mode.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.core.z_controller.property.idle_mode.value_raw', new_val.value)

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.core.z_controller.property.idle_mode.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.core.z_controller.property.idle_mode.value_raw', int(new_val))

    @property
    def enum(self) -> list:
        return list(self._context.get('root.core.z_controller.property.idle_mode.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.core.z_controller.property.idle_mode.enum', list(new_val))


class RootCoreZ_controllerPropertyAbsolute_idle_position(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.z_controller.property.absolute_idle_position'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def unit(self) -> str:
        return str(self._context.get('root.core.z_controller.property.absolute_idle_position.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.core.z_controller.property.absolute_idle_position.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.core.z_controller.property.absolute_idle_position.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.core.z_controller.property.absolute_idle_position.value', float(new_val))


class RootCoreZ_controllerPropertyMin_z_value(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.z_controller.property.min_z_value'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def unit(self) -> str:
        return str(self._context.get('root.core.z_controller.property.min_z_value.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.core.z_controller.property.min_z_value.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.core.z_controller.property.min_z_value.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.core.z_controller.property.min_z_value.value', float(new_val))


class RootCoreZ_controllerPropertyFeedback_polarity(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        positive = 0
        negative = 1
        invalid = 2

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.z_controller.property.feedback_polarity'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value(self) -> ValueEnum:
        return RootCoreZ_controllerPropertyFeedback_polarity.ValueEnum(self._context.get('root.core.z_controller.property.feedback_polarity.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.core.z_controller.property.feedback_polarity.value_raw', new_val.value)

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.core.z_controller.property.feedback_polarity.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.core.z_controller.property.feedback_polarity.value_raw', int(new_val))

    @property
    def enum(self) -> list:
        return list(self._context.get('root.core.z_controller.property.feedback_polarity.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.core.z_controller.property.feedback_polarity.enum', list(new_val))


class RootCoreZ_controllerProperty(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.z_controller.property'
        self.feedback_polarity = RootCoreZ_controllerPropertyFeedback_polarity(self._context)
        self.min_z_value = RootCoreZ_controllerPropertyMin_z_value(self._context)
        self.absolute_idle_position = RootCoreZ_controllerPropertyAbsolute_idle_position(self._context)
        self.idle_mode = RootCoreZ_controllerPropertyIdle_mode(self._context)
        self.p_gain = RootCoreZ_controllerPropertyP_gain(self._context)
        self.closed_loop_p_gain = RootCoreZ_controllerPropertyClosed_loop_p_gain(self._context)
        self.actual_tip_position = RootCoreZ_controllerPropertyActual_tip_position(self._context)
        self.base_work_mode = RootCoreZ_controllerPropertyBase_work_mode(self._context)
        self.closed_loop_d_gain = RootCoreZ_controllerPropertyClosed_loop_d_gain(self._context)
        self.actual_feedback_value = RootCoreZ_controllerPropertyActual_feedback_value(self._context)
        self.setpoint = RootCoreZ_controllerPropertySetpoint(self._context)
        self.d_gain = RootCoreZ_controllerPropertyD_gain(self._context)
        self.closed_loop_i_gain = RootCoreZ_controllerPropertyClosed_loop_i_gain(self._context)
        self.feedback = RootCoreZ_controllerPropertyFeedback(self._context)
        self.i_gain = RootCoreZ_controllerPropertyI_gain(self._context)


class RootCoreZ_controller(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.z_controller'
        self.property = RootCoreZ_controllerProperty(self._context)
        self.signal = RootCoreZ_controllerSignal(self._context)

    def setpoint_upper_limit(self, *args) -> Any:
        return self._context.call('root.core.z_controller.setpoint_upper_limit', *args)

    def tip_position_lower_limit(self, *args) -> Any:
        return self._context.call('root.core.z_controller.tip_position_lower_limit', *args)

    def retract_tip(self, *args) -> Any:
        return self._context.call('root.core.z_controller.retract_tip', *args)

    def setpoint_limits_from_calibration(self, *args) -> Any:
        return self._context.call('root.core.z_controller.setpoint_limits_from_calibration', *args)


class RootCoreApproach_motors_driveSignalMotor_move_started(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.approach_motors_drive.signal.motor_move_started'

    def empty(self, *args) -> Any:
        return self._context.call('root.core.approach_motors_drive.signal.motor_move_started.empty', *args)

    def call(self, *args) -> Any:
        return self._context.call('root.core.approach_motors_drive.signal.motor_move_started.call', *args)

    def connect(self, *args) -> Any:
        return self._context.call('root.core.approach_motors_drive.signal.motor_move_started.connect', *args)

    def connect_extended(self, *args) -> Any:
        return self._context.call('root.core.approach_motors_drive.signal.motor_move_started.connect_extended', *args)


class RootCoreApproach_motors_driveSignalMotor_move_finished(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.approach_motors_drive.signal.motor_move_finished'

    def empty(self, *args) -> Any:
        return self._context.call('root.core.approach_motors_drive.signal.motor_move_finished.empty', *args)

    def call(self, *args) -> Any:
        return self._context.call('root.core.approach_motors_drive.signal.motor_move_finished.call', *args)

    def connect(self, *args) -> Any:
        return self._context.call('root.core.approach_motors_drive.signal.motor_move_finished.connect', *args)

    def connect_extended(self, *args) -> Any:
        return self._context.call('root.core.approach_motors_drive.signal.motor_move_finished.connect_extended', *args)


class RootCoreApproach_motors_driveSignal(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.approach_motors_drive.signal'
        self.motor_move_finished = RootCoreApproach_motors_driveSignalMotor_move_finished(self._context)
        self.motor_move_started = RootCoreApproach_motors_driveSignalMotor_move_started(self._context)


class RootCoreApproach_motors_drivePropertyMotor_left_position(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.approach_motors_drive.property.motor_left_position'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def unit(self) -> str:
        return str(self._context.get('root.core.approach_motors_drive.property.motor_left_position.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.core.approach_motors_drive.property.motor_left_position.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.core.approach_motors_drive.property.motor_left_position.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.core.approach_motors_drive.property.motor_left_position.value', float(new_val))


class RootCoreApproach_motors_drivePropertyMotor_speed(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.approach_motors_drive.property.motor_speed'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def unit(self) -> str:
        return str(self._context.get('root.core.approach_motors_drive.property.motor_speed.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.core.approach_motors_drive.property.motor_speed.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.core.approach_motors_drive.property.motor_speed.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.core.approach_motors_drive.property.motor_speed.value', float(new_val))


class RootCoreApproach_motors_drivePropertyMotor_right_position(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.approach_motors_drive.property.motor_right_position'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def unit(self) -> str:
        return str(self._context.get('root.core.approach_motors_drive.property.motor_right_position.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.core.approach_motors_drive.property.motor_right_position.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.core.approach_motors_drive.property.motor_right_position.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.core.approach_motors_drive.property.motor_right_position.value', float(new_val))


class RootCoreApproach_motors_drivePropertyRelative_tip_position(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.approach_motors_drive.property.relative_tip_position'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def unit(self) -> str:
        return str(self._context.get('root.core.approach_motors_drive.property.relative_tip_position.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.core.approach_motors_drive.property.relative_tip_position.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.core.approach_motors_drive.property.relative_tip_position.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.core.approach_motors_drive.property.relative_tip_position.value', float(new_val))


class RootCoreApproach_motors_drivePropertyMotor_speed_approach_motors(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.approach_motors_drive.property.motor_speed_approach_motors'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def unit(self) -> str:
        return str(self._context.get('root.core.approach_motors_drive.property.motor_speed_approach_motors.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.core.approach_motors_drive.property.motor_speed_approach_motors.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.core.approach_motors_drive.property.motor_speed_approach_motors.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.core.approach_motors_drive.property.motor_speed_approach_motors.value', float(new_val))


class RootCoreApproach_motors_drivePropertyMotor_speed_advance_retract(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.approach_motors_drive.property.motor_speed_advance_retract'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def unit(self) -> str:
        return str(self._context.get('root.core.approach_motors_drive.property.motor_speed_advance_retract.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.core.approach_motors_drive.property.motor_speed_advance_retract.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.core.approach_motors_drive.property.motor_speed_advance_retract.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.core.approach_motors_drive.property.motor_speed_advance_retract.value', float(new_val))


class RootCoreApproach_motors_drivePropertyMotor_front_position(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.approach_motors_drive.property.motor_front_position'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def unit(self) -> str:
        return str(self._context.get('root.core.approach_motors_drive.property.motor_front_position.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.core.approach_motors_drive.property.motor_front_position.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.core.approach_motors_drive.property.motor_front_position.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.core.approach_motors_drive.property.motor_front_position.value', float(new_val))


class RootCoreApproach_motors_driveProperty(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.approach_motors_drive.property'
        self.motor_front_position = RootCoreApproach_motors_drivePropertyMotor_front_position(self._context)
        self.motor_speed_advance_retract = RootCoreApproach_motors_drivePropertyMotor_speed_advance_retract(self._context)
        self.motor_speed_approach_motors = RootCoreApproach_motors_drivePropertyMotor_speed_approach_motors(self._context)
        self.relative_tip_position = RootCoreApproach_motors_drivePropertyRelative_tip_position(self._context)
        self.motor_right_position = RootCoreApproach_motors_drivePropertyMotor_right_position(self._context)
        self.motor_speed = RootCoreApproach_motors_drivePropertyMotor_speed(self._context)
        self.motor_left_position = RootCoreApproach_motors_drivePropertyMotor_left_position(self._context)


class RootCoreApproach_motors_drive(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.approach_motors_drive'
        self.property = RootCoreApproach_motors_driveProperty(self._context)
        self.signal = RootCoreApproach_motors_driveSignal(self._context)

    def reference_motors(self, *args) -> Any:
        return self._context.call('root.core.approach_motors_drive.reference_motors', *args)

    def zero_position(self, *args) -> Any:
        return self._context.call('root.core.approach_motors_drive.zero_position', *args)

    def start_moving_motors(self, *args) -> Any:
        return self._context.call('root.core.approach_motors_drive.start_moving_motors', *args)

    def stop_motors(self, *args) -> Any:
        return self._context.call('root.core.approach_motors_drive.stop_motors', *args)

    def move_motors_by_step(self, *args) -> Any:
        return self._context.call('root.core.approach_motors_drive.move_motors_by_step', *args)


class RootCoreAcquisition(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.acquisition'

    def lu_data_buffer_channel_range(self, *args) -> Any:
        return self._context.call('root.core.acquisition.lu_data_buffer_channel_range', *args)

    def reserve_lu_data_buffer(self, *args) -> Any:
        return self._context.call('root.core.acquisition.reserve_lu_data_buffer', *args)

    def lu_data_buffer_channel_data(self, *args) -> Any:
        return self._context.call('root.core.acquisition.lu_data_buffer_channel_data', *args)

    def trim_sampler_buffer(self, *args) -> Any:
        return self._context.call('root.core.acquisition.trim_sampler_buffer', *args)

    def lu_data_buffer_channel_unit(self, *args) -> Any:
        return self._context.call('root.core.acquisition.lu_data_buffer_channel_unit', *args)

    def lu_data_buffer_channel_name(self, *args) -> Any:
        return self._context.call('root.core.acquisition.lu_data_buffer_channel_name', *args)

    def erase_lu_data_buffer(self, *args) -> Any:
        return self._context.call('root.core.acquisition.erase_lu_data_buffer', *args)

    def write_data(self, *args) -> Any:
        return self._context.call('root.core.acquisition.write_data', *args)

    def lu_data_buffer_channel_count(self, *args) -> Any:
        return self._context.call('root.core.acquisition.lu_data_buffer_channel_count', *args)

    def lu_data_buffer_timestamp(self, *args) -> Any:
        return self._context.call('root.core.acquisition.lu_data_buffer_timestamp', *args)

    def synchronize_lu_data_buffer(self, *args) -> Any:
        return self._context.call('root.core.acquisition.synchronize_lu_data_buffer', *args)

    def lu_data_buffer_state(self, *args) -> Any:
        return self._context.call('root.core.acquisition.lu_data_buffer_state', *args)


class RootCoreHv_amp_control(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.hv_amp_control'


class RootCoreDirect_motor_control(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.direct_motor_control'


class RootCoreFrequency_sweepPropertyAnalyzer_demodulator_bandwidth(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        num_45_kHz = 12
        num_100_kHz = 13
        num_90_Hz = 3
        num_1500_Hz = 7
        num_360_Hz = 5
        num_23_kHz = 11
        num_500_kHz = 15
        num_3_kHz = 8
        num_750_Hz = 6
        num_230_kHz = 14
        num_12_kHz = 10
        num_180_Hz = 4
        num_6_kHz = 9

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.frequency_sweep.property.analyzer_demodulator_bandwidth'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value(self) -> ValueEnum:
        return RootCoreFrequency_sweepPropertyAnalyzer_demodulator_bandwidth.ValueEnum(self._context.get('root.core.frequency_sweep.property.analyzer_demodulator_bandwidth.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.core.frequency_sweep.property.analyzer_demodulator_bandwidth.value_raw', new_val.value)

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.core.frequency_sweep.property.analyzer_demodulator_bandwidth.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.core.frequency_sweep.property.analyzer_demodulator_bandwidth.value_raw', int(new_val))

    @property
    def enum(self) -> list:
        return list(self._context.get('root.core.frequency_sweep.property.analyzer_demodulator_bandwidth.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.core.frequency_sweep.property.analyzer_demodulator_bandwidth.enum', list(new_val))


class RootCoreFrequency_sweepPropertySweep_excitation_amplitude(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.frequency_sweep.property.sweep_excitation_amplitude'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def unit(self) -> str:
        return str(self._context.get('root.core.frequency_sweep.property.sweep_excitation_amplitude.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.core.frequency_sweep.property.sweep_excitation_amplitude.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.core.frequency_sweep.property.sweep_excitation_amplitude.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.core.frequency_sweep.property.sweep_excitation_amplitude.value', float(new_val))


class RootCoreFrequency_sweepPropertyFit_frequency_lower_bound(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.frequency_sweep.property.fit_frequency_lower_bound'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def unit(self) -> str:
        return str(self._context.get('root.core.frequency_sweep.property.fit_frequency_lower_bound.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.core.frequency_sweep.property.fit_frequency_lower_bound.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.core.frequency_sweep.property.fit_frequency_lower_bound.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.core.frequency_sweep.property.fit_frequency_lower_bound.value', float(new_val))


class RootCoreFrequency_sweepPropertyMeasurement_environment(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        Air = 0
        Liquid = 1

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.frequency_sweep.property.measurement_environment'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value(self) -> ValueEnum:
        return RootCoreFrequency_sweepPropertyMeasurement_environment.ValueEnum(self._context.get('root.core.frequency_sweep.property.measurement_environment.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.core.frequency_sweep.property.measurement_environment.value_raw', new_val.value)

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.core.frequency_sweep.property.measurement_environment.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.core.frequency_sweep.property.measurement_environment.value_raw', int(new_val))

    @property
    def enum(self) -> list:
        return list(self._context.get('root.core.frequency_sweep.property.measurement_environment.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.core.frequency_sweep.property.measurement_environment.enum', list(new_val))


class RootCoreFrequency_sweepPropertyNew_spring_constant(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.frequency_sweep.property.new_spring_constant'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def unit(self) -> str:
        return str(self._context.get('root.core.frequency_sweep.property.new_spring_constant.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.core.frequency_sweep.property.new_spring_constant.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.core.frequency_sweep.property.new_spring_constant.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.core.frequency_sweep.property.new_spring_constant.value', float(new_val))


class RootCoreFrequency_sweepPropertyAmplitude_unit(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        Meters_m_ = 0
        Volts_V_ = 1

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.frequency_sweep.property.amplitude_unit'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value(self) -> ValueEnum:
        return RootCoreFrequency_sweepPropertyAmplitude_unit.ValueEnum(self._context.get('root.core.frequency_sweep.property.amplitude_unit.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.core.frequency_sweep.property.amplitude_unit.value_raw', new_val.value)

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.core.frequency_sweep.property.amplitude_unit.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.core.frequency_sweep.property.amplitude_unit.value_raw', int(new_val))

    @property
    def enum(self) -> list:
        return list(self._context.get('root.core.frequency_sweep.property.amplitude_unit.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.core.frequency_sweep.property.amplitude_unit.enum', list(new_val))


class RootCoreFrequency_sweepPropertySweep_free_vibration_amplitude(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.frequency_sweep.property.sweep_free_vibration_amplitude'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def unit(self) -> str:
        return str(self._context.get('root.core.frequency_sweep.property.sweep_free_vibration_amplitude.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.core.frequency_sweep.property.sweep_free_vibration_amplitude.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.core.frequency_sweep.property.sweep_free_vibration_amplitude.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.core.frequency_sweep.property.sweep_free_vibration_amplitude.value', float(new_val))


class RootCoreFrequency_sweepPropertyAmplitude_reduction(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.frequency_sweep.property.amplitude_reduction'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def unit(self) -> str:
        return str(self._context.get('root.core.frequency_sweep.property.amplitude_reduction.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.core.frequency_sweep.property.amplitude_reduction.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.core.frequency_sweep.property.amplitude_reduction.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.core.frequency_sweep.property.amplitude_reduction.value', float(new_val))


class RootCoreFrequency_sweepPropertyFrequency_selection_criteria(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        Below_Peak = 0
        Above_Peak = 1

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.frequency_sweep.property.frequency_selection_criteria'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value(self) -> ValueEnum:
        return RootCoreFrequency_sweepPropertyFrequency_selection_criteria.ValueEnum(self._context.get('root.core.frequency_sweep.property.frequency_selection_criteria.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.core.frequency_sweep.property.frequency_selection_criteria.value_raw', new_val.value)

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.core.frequency_sweep.property.frequency_selection_criteria.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.core.frequency_sweep.property.frequency_selection_criteria.value_raw', int(new_val))

    @property
    def enum(self) -> list:
        return list(self._context.get('root.core.frequency_sweep.property.frequency_selection_criteria.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.core.frequency_sweep.property.frequency_selection_criteria.enum', list(new_val))


class RootCoreFrequency_sweepPropertySweep_data_points(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.frequency_sweep.property.sweep_data_points'
        self._lua_value_type = wrap.LuaType('int')

    @property
    def value(self) -> int:
        return int(self._context.get('root.core.frequency_sweep.property.sweep_data_points.value'))

    @value.setter
    def value(self, new_val:int):
        self._context.set('root.core.frequency_sweep.property.sweep_data_points.value', int(new_val))


class RootCoreFrequency_sweepPropertySweep_frequency_lower_bound(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.frequency_sweep.property.sweep_frequency_lower_bound'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def unit(self) -> str:
        return str(self._context.get('root.core.frequency_sweep.property.sweep_frequency_lower_bound.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.core.frequency_sweep.property.sweep_frequency_lower_bound.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.core.frequency_sweep.property.sweep_frequency_lower_bound.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.core.frequency_sweep.property.sweep_frequency_lower_bound.value', float(new_val))


class RootCoreFrequency_sweepPropertySweep_frequency_upper_bound(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.frequency_sweep.property.sweep_frequency_upper_bound'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def unit(self) -> str:
        return str(self._context.get('root.core.frequency_sweep.property.sweep_frequency_upper_bound.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.core.frequency_sweep.property.sweep_frequency_upper_bound.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.core.frequency_sweep.property.sweep_frequency_upper_bound.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.core.frequency_sweep.property.sweep_frequency_upper_bound.value', float(new_val))


class RootCoreFrequency_sweepPropertyFit_frequency_upper_bound(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.frequency_sweep.property.fit_frequency_upper_bound'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def unit(self) -> str:
        return str(self._context.get('root.core.frequency_sweep.property.fit_frequency_upper_bound.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.core.frequency_sweep.property.fit_frequency_upper_bound.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.core.frequency_sweep.property.fit_frequency_upper_bound.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.core.frequency_sweep.property.fit_frequency_upper_bound.value', float(new_val))


class RootCoreFrequency_sweepPropertyTemperature(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.frequency_sweep.property.temperature'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def unit(self) -> str:
        return str(self._context.get('root.core.frequency_sweep.property.temperature.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.core.frequency_sweep.property.temperature.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.core.frequency_sweep.property.temperature.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.core.frequency_sweep.property.temperature.value', float(new_val))


class RootCoreFrequency_sweepPropertyNew_excitation_frequency(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.frequency_sweep.property.new_excitation_frequency'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def unit(self) -> str:
        return str(self._context.get('root.core.frequency_sweep.property.new_excitation_frequency.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.core.frequency_sweep.property.new_excitation_frequency.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.core.frequency_sweep.property.new_excitation_frequency.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.core.frequency_sweep.property.new_excitation_frequency.value', float(new_val))


class RootCoreFrequency_sweepProperty(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.frequency_sweep.property'
        self.new_excitation_frequency = RootCoreFrequency_sweepPropertyNew_excitation_frequency(self._context)
        self.temperature = RootCoreFrequency_sweepPropertyTemperature(self._context)
        self.fit_frequency_upper_bound = RootCoreFrequency_sweepPropertyFit_frequency_upper_bound(self._context)
        self.sweep_frequency_upper_bound = RootCoreFrequency_sweepPropertySweep_frequency_upper_bound(self._context)
        self.sweep_frequency_lower_bound = RootCoreFrequency_sweepPropertySweep_frequency_lower_bound(self._context)
        self.sweep_data_points = RootCoreFrequency_sweepPropertySweep_data_points(self._context)
        self.frequency_selection_criteria = RootCoreFrequency_sweepPropertyFrequency_selection_criteria(self._context)
        self.amplitude_reduction = RootCoreFrequency_sweepPropertyAmplitude_reduction(self._context)
        self.sweep_free_vibration_amplitude = RootCoreFrequency_sweepPropertySweep_free_vibration_amplitude(self._context)
        self.amplitude_unit = RootCoreFrequency_sweepPropertyAmplitude_unit(self._context)
        self.new_spring_constant = RootCoreFrequency_sweepPropertyNew_spring_constant(self._context)
        self.measurement_environment = RootCoreFrequency_sweepPropertyMeasurement_environment(self._context)
        self.fit_frequency_lower_bound = RootCoreFrequency_sweepPropertyFit_frequency_lower_bound(self._context)
        self.sweep_excitation_amplitude = RootCoreFrequency_sweepPropertySweep_excitation_amplitude(self._context)
        self.analyzer_demodulator_bandwidth = RootCoreFrequency_sweepPropertyAnalyzer_demodulator_bandwidth(self._context)


class RootCoreFrequency_sweepSignalData_invalidated(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.frequency_sweep.signal.data_invalidated'

    def empty(self, *args) -> Any:
        return self._context.call('root.core.frequency_sweep.signal.data_invalidated.empty', *args)

    def call(self, *args) -> Any:
        return self._context.call('root.core.frequency_sweep.signal.data_invalidated.call', *args)

    def connect(self, *args) -> Any:
        return self._context.call('root.core.frequency_sweep.signal.data_invalidated.connect', *args)

    def connect_extended(self, *args) -> Any:
        return self._context.call('root.core.frequency_sweep.signal.data_invalidated.connect_extended', *args)


class RootCoreFrequency_sweepSignalSho_fit_failed(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.frequency_sweep.signal.sho_fit_failed'

    def empty(self, *args) -> Any:
        return self._context.call('root.core.frequency_sweep.signal.sho_fit_failed.empty', *args)

    def call(self, *args) -> Any:
        return self._context.call('root.core.frequency_sweep.signal.sho_fit_failed.call', *args)

    def connect(self, *args) -> Any:
        return self._context.call('root.core.frequency_sweep.signal.sho_fit_failed.connect', *args)

    def connect_extended(self, *args) -> Any:
        return self._context.call('root.core.frequency_sweep.signal.sho_fit_failed.connect_extended', *args)


class RootCoreFrequency_sweepSignalProcess_sweep_data(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.frequency_sweep.signal.process_sweep_data'

    def empty(self, *args) -> Any:
        return self._context.call('root.core.frequency_sweep.signal.process_sweep_data.empty', *args)

    def call(self, *args) -> Any:
        return self._context.call('root.core.frequency_sweep.signal.process_sweep_data.call', *args)

    def connect(self, *args) -> Any:
        return self._context.call('root.core.frequency_sweep.signal.process_sweep_data.connect', *args)

    def connect_extended(self, *args) -> Any:
        return self._context.call('root.core.frequency_sweep.signal.process_sweep_data.connect_extended', *args)


class RootCoreFrequency_sweepSignalNew_sweep_data(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.frequency_sweep.signal.new_sweep_data'

    def empty(self, *args) -> Any:
        return self._context.call('root.core.frequency_sweep.signal.new_sweep_data.empty', *args)

    def call(self, *args) -> Any:
        return self._context.call('root.core.frequency_sweep.signal.new_sweep_data.call', *args)

    def connect(self, *args) -> Any:
        return self._context.call('root.core.frequency_sweep.signal.new_sweep_data.connect', *args)

    def connect_extended(self, *args) -> Any:
        return self._context.call('root.core.frequency_sweep.signal.new_sweep_data.connect_extended', *args)


class RootCoreFrequency_sweepSignalNew_fit_data(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.frequency_sweep.signal.new_fit_data'

    def empty(self, *args) -> Any:
        return self._context.call('root.core.frequency_sweep.signal.new_fit_data.empty', *args)

    def call(self, *args) -> Any:
        return self._context.call('root.core.frequency_sweep.signal.new_fit_data.call', *args)

    def connect(self, *args) -> Any:
        return self._context.call('root.core.frequency_sweep.signal.new_fit_data.connect', *args)

    def connect_extended(self, *args) -> Any:
        return self._context.call('root.core.frequency_sweep.signal.new_fit_data.connect_extended', *args)


class RootCoreFrequency_sweepSignalSweep_progress(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.frequency_sweep.signal.sweep_progress'

    def empty(self, *args) -> Any:
        return self._context.call('root.core.frequency_sweep.signal.sweep_progress.empty', *args)

    def call(self, *args) -> Any:
        return self._context.call('root.core.frequency_sweep.signal.sweep_progress.call', *args)

    def connect(self, *args) -> Any:
        return self._context.call('root.core.frequency_sweep.signal.sweep_progress.connect', *args)

    def connect_extended(self, *args) -> Any:
        return self._context.call('root.core.frequency_sweep.signal.sweep_progress.connect_extended', *args)


class RootCoreFrequency_sweepSignalSweep_ended(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.frequency_sweep.signal.sweep_ended'

    def empty(self, *args) -> Any:
        return self._context.call('root.core.frequency_sweep.signal.sweep_ended.empty', *args)

    def call(self, *args) -> Any:
        return self._context.call('root.core.frequency_sweep.signal.sweep_ended.call', *args)

    def connect(self, *args) -> Any:
        return self._context.call('root.core.frequency_sweep.signal.sweep_ended.connect', *args)

    def connect_extended(self, *args) -> Any:
        return self._context.call('root.core.frequency_sweep.signal.sweep_ended.connect_extended', *args)


class RootCoreFrequency_sweepSignal(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.frequency_sweep.signal'
        self.sweep_ended = RootCoreFrequency_sweepSignalSweep_ended(self._context)
        self.sweep_progress = RootCoreFrequency_sweepSignalSweep_progress(self._context)
        self.new_fit_data = RootCoreFrequency_sweepSignalNew_fit_data(self._context)
        self.new_sweep_data = RootCoreFrequency_sweepSignalNew_sweep_data(self._context)
        self.process_sweep_data = RootCoreFrequency_sweepSignalProcess_sweep_data(self._context)
        self.sho_fit_failed = RootCoreFrequency_sweepSignalSho_fit_failed(self._context)
        self.data_invalidated = RootCoreFrequency_sweepSignalData_invalidated(self._context)


class RootCoreFrequency_sweep(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.frequency_sweep'
        self.signal = RootCoreFrequency_sweepSignal(self._context)
        self.property = RootCoreFrequency_sweepProperty(self._context)

    def start(self, *args) -> Any:
        return self._context.call('root.core.frequency_sweep.start', *args)

    def get_fit_amplitude(self, *args) -> Any:
        return self._context.call('root.core.frequency_sweep.get_fit_amplitude', *args)

    def set_expected_sho_parameters(self, *args) -> Any:
        return self._context.call('root.core.frequency_sweep.set_expected_sho_parameters', *args)

    def get_resonance_frequency(self, *args) -> Any:
        return self._context.call('root.core.frequency_sweep.get_resonance_frequency', *args)

    def do_sho_fit(self, *args) -> Any:
        return self._context.call('root.core.frequency_sweep.do_sho_fit', *args)

    def is_controller_simulated(self, *args) -> Any:
        return self._context.call('root.core.frequency_sweep.is_controller_simulated', *args)

    def invalidate_sweep_and_fit_data(self, *args) -> Any:
        return self._context.call('root.core.frequency_sweep.invalidate_sweep_and_fit_data', *args)

    def convert_and_emit_sweep_data(self, *args) -> Any:
        return self._context.call('root.core.frequency_sweep.convert_and_emit_sweep_data', *args)

    def set_sweep_parameters(self, *args) -> Any:
        return self._context.call('root.core.frequency_sweep.set_sweep_parameters', *args)

    def calculate_spring_constant(self, *args) -> Any:
        return self._context.call('root.core.frequency_sweep.calculate_spring_constant', *args)

    def abort(self, *args) -> Any:
        return self._context.call('root.core.frequency_sweep.abort', *args)

    def get_q_factor(self, *args) -> Any:
        return self._context.call('root.core.frequency_sweep.get_q_factor', *args)


class RootCoreSignal_store(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.signal_store'

    def get_signal_calibration_min_max(self, *args) -> Any:
        return self._context.call('root.core.signal_store.get_signal_calibration_min_max', *args)


class RootCoreCapture(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.capture'


class RootCoreSignal_analyzer1(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.signal_analyzer1'


class RootCore(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core'
        self.signal_analyzer1 = RootCoreSignal_analyzer1(self._context)
        self.capture = RootCoreCapture(self._context)
        self.signal_store = RootCoreSignal_store(self._context)
        self.frequency_sweep = RootCoreFrequency_sweep(self._context)
        self.direct_motor_control = RootCoreDirect_motor_control(self._context)
        self.hv_amp_control = RootCoreHv_amp_control(self._context)
        self.acquisition = RootCoreAcquisition(self._context)
        self.approach_motors_drive = RootCoreApproach_motors_drive(self._context)
        self.z_controller = RootCoreZ_controller(self._context)
        self.thermal_tune = RootCoreThermal_tune(self._context)
        self.laser_align_drive_impl = RootCoreLaser_align_drive_impl(self._context)
        self.sampler = RootCoreSampler(self._context)
        self.core_monitoring = RootCoreCore_monitoring(self._context)
        self.core_options = RootCoreCore_options(self._context)
        self.signal_registration = RootCoreSignal_registration(self._context)
        self.imaging = RootCoreImaging(self._context)
        self.comp_dc = RootCoreComp_dc(self._context)
        self.core_cantilever = RootCoreCore_cantilever(self._context)
        self.spectroscopy = RootCoreSpectroscopy(self._context)
        self.oscilloscope = RootCoreOscilloscope(self._context)
        self.approach = RootCoreApproach(self._context)
        self.core_environment = RootCoreCore_environment(self._context)
        self.ort = RootCoreOrt(self._context)
        self.position_control = RootCorePosition_control(self._context)
        self.scan_head_calibration = RootCoreScan_head_calibration(self._context)
        self.converter_channel_correction = RootCoreConverter_channel_correction(self._context)


class RootLuRamp_generatorPosition_wTrigger(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.position_w.trigger'

    def start(self) -> None:
        return self._context.call('root.lu.ramp_generator.position_w.trigger.start')

    def stop(self) -> None:
        return self._context.call('root.lu.ramp_generator.position_w.trigger.stop')

    def abort(self) -> None:
        return self._context.call('root.lu.ramp_generator.position_w.trigger.abort')

    def prepare(self) -> None:
        return self._context.call('root.lu.ramp_generator.position_w.trigger.prepare')


class RootLuRamp_generatorPosition_wAttributeMoving_time(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.position_w.attribute.moving_time'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.position_w.attribute.moving_time.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.ramp_generator.position_w.attribute.moving_time.value', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.position_w.attribute.moving_time.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.ramp_generator.position_w.attribute.moving_time.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.ramp_generator.position_w.attribute.moving_time.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.ramp_generator.position_w.attribute.moving_time.unit', str(new_val))

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.position_w.attribute.moving_time.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.ramp_generator.position_w.attribute.moving_time.min', float(new_val))


class RootLuRamp_generatorPosition_wAttributeCurrent_value(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.position_w.attribute.current_value'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.position_w.attribute.current_value.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.ramp_generator.position_w.attribute.current_value.value', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.position_w.attribute.current_value.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.ramp_generator.position_w.attribute.current_value.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.ramp_generator.position_w.attribute.current_value.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.ramp_generator.position_w.attribute.current_value.unit', str(new_val))

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.position_w.attribute.current_value.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.ramp_generator.position_w.attribute.current_value.min', float(new_val))


class RootLuRamp_generatorPosition_wAttributeUpper_limit(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.position_w.attribute.upper_limit'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.position_w.attribute.upper_limit.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.ramp_generator.position_w.attribute.upper_limit.value', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.position_w.attribute.upper_limit.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.ramp_generator.position_w.attribute.upper_limit.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.ramp_generator.position_w.attribute.upper_limit.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.ramp_generator.position_w.attribute.upper_limit.unit', str(new_val))

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.position_w.attribute.upper_limit.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.ramp_generator.position_w.attribute.upper_limit.min', float(new_val))


class RootLuRamp_generatorPosition_wAttributeMoving_speed(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.position_w.attribute.moving_speed'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.position_w.attribute.moving_speed.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.ramp_generator.position_w.attribute.moving_speed.value', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.position_w.attribute.moving_speed.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.ramp_generator.position_w.attribute.moving_speed.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.ramp_generator.position_w.attribute.moving_speed.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.ramp_generator.position_w.attribute.moving_speed.unit', str(new_val))

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.position_w.attribute.moving_speed.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.ramp_generator.position_w.attribute.moving_speed.min', float(new_val))


class RootLuRamp_generatorPosition_wAttributeEnd_value_absolute(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.position_w.attribute.end_value_absolute'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.position_w.attribute.end_value_absolute.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.ramp_generator.position_w.attribute.end_value_absolute.value', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.position_w.attribute.end_value_absolute.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.ramp_generator.position_w.attribute.end_value_absolute.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.ramp_generator.position_w.attribute.end_value_absolute.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.ramp_generator.position_w.attribute.end_value_absolute.unit', str(new_val))

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.position_w.attribute.end_value_absolute.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.ramp_generator.position_w.attribute.end_value_absolute.min', float(new_val))


class RootLuRamp_generatorPosition_wAttributeEnd_value_relative(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.position_w.attribute.end_value_relative'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.position_w.attribute.end_value_relative.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.ramp_generator.position_w.attribute.end_value_relative.value', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.position_w.attribute.end_value_relative.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.ramp_generator.position_w.attribute.end_value_relative.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.ramp_generator.position_w.attribute.end_value_relative.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.ramp_generator.position_w.attribute.end_value_relative.unit', str(new_val))

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.position_w.attribute.end_value_relative.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.ramp_generator.position_w.attribute.end_value_relative.min', float(new_val))


class RootLuRamp_generatorPosition_wAttributeEnd_value_mode(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        move_relative = 1
        move_to_absolute = 0

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.position_w.attribute.end_value_mode'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value(self) -> ValueEnum:
        return RootLuRamp_generatorPosition_wAttributeEnd_value_mode.ValueEnum(self._context.get('root.lu.ramp_generator.position_w.attribute.end_value_mode.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.lu.ramp_generator.position_w.attribute.end_value_mode.value_raw', new_val.value)

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.lu.ramp_generator.position_w.attribute.end_value_mode.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.lu.ramp_generator.position_w.attribute.end_value_mode.value_raw', int(new_val))

    @property
    def enum(self) -> list:
        return list(self._context.get('root.lu.ramp_generator.position_w.attribute.end_value_mode.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.lu.ramp_generator.position_w.attribute.end_value_mode.enum', list(new_val))


class RootLuRamp_generatorPosition_wAttributeMoving_mode(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        fix_time = 0
        fix_speed = 1

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.position_w.attribute.moving_mode'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value(self) -> ValueEnum:
        return RootLuRamp_generatorPosition_wAttributeMoving_mode.ValueEnum(self._context.get('root.lu.ramp_generator.position_w.attribute.moving_mode.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.lu.ramp_generator.position_w.attribute.moving_mode.value_raw', new_val.value)

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.lu.ramp_generator.position_w.attribute.moving_mode.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.lu.ramp_generator.position_w.attribute.moving_mode.value_raw', int(new_val))

    @property
    def enum(self) -> list:
        return list(self._context.get('root.lu.ramp_generator.position_w.attribute.moving_mode.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.lu.ramp_generator.position_w.attribute.moving_mode.enum', list(new_val))


class RootLuRamp_generatorPosition_wAttributeStatus(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        stopped_by_external_event = 4
        reached_endposition = 1
        is_moving = 0
        reached_upper_limit = 3
        reached_lower_limit = 2

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.position_w.attribute.status'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value(self) -> ValueEnum:
        return RootLuRamp_generatorPosition_wAttributeStatus.ValueEnum(self._context.get('root.lu.ramp_generator.position_w.attribute.status.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.lu.ramp_generator.position_w.attribute.status.value_raw', new_val.value)

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.lu.ramp_generator.position_w.attribute.status.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.lu.ramp_generator.position_w.attribute.status.value_raw', int(new_val))

    @property
    def enum(self) -> list:
        return list(self._context.get('root.lu.ramp_generator.position_w.attribute.status.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.lu.ramp_generator.position_w.attribute.status.enum', list(new_val))


class RootLuRamp_generatorPosition_wAttributeLower_limit(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.position_w.attribute.lower_limit'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.position_w.attribute.lower_limit.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.ramp_generator.position_w.attribute.lower_limit.value', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.position_w.attribute.lower_limit.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.ramp_generator.position_w.attribute.lower_limit.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.ramp_generator.position_w.attribute.lower_limit.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.ramp_generator.position_w.attribute.lower_limit.unit', str(new_val))

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.position_w.attribute.lower_limit.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.ramp_generator.position_w.attribute.lower_limit.min', float(new_val))


class RootLuRamp_generatorPosition_wAttribute(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.position_w.attribute'
        self.lower_limit = RootLuRamp_generatorPosition_wAttributeLower_limit(self._context)
        self.status = RootLuRamp_generatorPosition_wAttributeStatus(self._context)
        self.moving_mode = RootLuRamp_generatorPosition_wAttributeMoving_mode(self._context)
        self.end_value_mode = RootLuRamp_generatorPosition_wAttributeEnd_value_mode(self._context)
        self.end_value_relative = RootLuRamp_generatorPosition_wAttributeEnd_value_relative(self._context)
        self.end_value_absolute = RootLuRamp_generatorPosition_wAttributeEnd_value_absolute(self._context)
        self.moving_speed = RootLuRamp_generatorPosition_wAttributeMoving_speed(self._context)
        self.upper_limit = RootLuRamp_generatorPosition_wAttributeUpper_limit(self._context)
        self.current_value = RootLuRamp_generatorPosition_wAttributeCurrent_value(self._context)
        self.moving_time = RootLuRamp_generatorPosition_wAttributeMoving_time(self._context)


class RootLuRamp_generatorPosition_wBusy(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.position_w.busy'

    @property
    def is_moving(self) -> bool:
        return bool(self._context.call('root.lu.ramp_generator.position_w.busy.is_moving'))


class RootLuRamp_generatorPosition_w(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.position_w'
        self.busy = RootLuRamp_generatorPosition_wBusy(self._context)
        self.attribute = RootLuRamp_generatorPosition_wAttribute(self._context)
        self.trigger = RootLuRamp_generatorPosition_wTrigger(self._context)


class RootLuRamp_generatorPosition_yTrigger(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.position_y.trigger'

    def start(self) -> None:
        return self._context.call('root.lu.ramp_generator.position_y.trigger.start')

    def stop(self) -> None:
        return self._context.call('root.lu.ramp_generator.position_y.trigger.stop')

    def abort(self) -> None:
        return self._context.call('root.lu.ramp_generator.position_y.trigger.abort')

    def prepare(self) -> None:
        return self._context.call('root.lu.ramp_generator.position_y.trigger.prepare')


class RootLuRamp_generatorPosition_yAttributeMoving_time(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.position_y.attribute.moving_time'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.position_y.attribute.moving_time.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.ramp_generator.position_y.attribute.moving_time.value', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.position_y.attribute.moving_time.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.ramp_generator.position_y.attribute.moving_time.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.ramp_generator.position_y.attribute.moving_time.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.ramp_generator.position_y.attribute.moving_time.unit', str(new_val))

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.position_y.attribute.moving_time.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.ramp_generator.position_y.attribute.moving_time.min', float(new_val))


class RootLuRamp_generatorPosition_yAttributeCurrent_value(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.position_y.attribute.current_value'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.position_y.attribute.current_value.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.ramp_generator.position_y.attribute.current_value.value', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.position_y.attribute.current_value.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.ramp_generator.position_y.attribute.current_value.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.ramp_generator.position_y.attribute.current_value.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.ramp_generator.position_y.attribute.current_value.unit', str(new_val))

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.position_y.attribute.current_value.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.ramp_generator.position_y.attribute.current_value.min', float(new_val))


class RootLuRamp_generatorPosition_yAttributeUpper_limit(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.position_y.attribute.upper_limit'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.position_y.attribute.upper_limit.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.ramp_generator.position_y.attribute.upper_limit.value', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.position_y.attribute.upper_limit.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.ramp_generator.position_y.attribute.upper_limit.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.ramp_generator.position_y.attribute.upper_limit.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.ramp_generator.position_y.attribute.upper_limit.unit', str(new_val))

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.position_y.attribute.upper_limit.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.ramp_generator.position_y.attribute.upper_limit.min', float(new_val))


class RootLuRamp_generatorPosition_yAttributeMoving_speed(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.position_y.attribute.moving_speed'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.position_y.attribute.moving_speed.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.ramp_generator.position_y.attribute.moving_speed.value', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.position_y.attribute.moving_speed.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.ramp_generator.position_y.attribute.moving_speed.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.ramp_generator.position_y.attribute.moving_speed.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.ramp_generator.position_y.attribute.moving_speed.unit', str(new_val))

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.position_y.attribute.moving_speed.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.ramp_generator.position_y.attribute.moving_speed.min', float(new_val))


class RootLuRamp_generatorPosition_yAttributeEnd_value_absolute(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.position_y.attribute.end_value_absolute'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.position_y.attribute.end_value_absolute.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.ramp_generator.position_y.attribute.end_value_absolute.value', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.position_y.attribute.end_value_absolute.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.ramp_generator.position_y.attribute.end_value_absolute.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.ramp_generator.position_y.attribute.end_value_absolute.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.ramp_generator.position_y.attribute.end_value_absolute.unit', str(new_val))

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.position_y.attribute.end_value_absolute.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.ramp_generator.position_y.attribute.end_value_absolute.min', float(new_val))


class RootLuRamp_generatorPosition_yAttributeEnd_value_relative(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.position_y.attribute.end_value_relative'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.position_y.attribute.end_value_relative.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.ramp_generator.position_y.attribute.end_value_relative.value', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.position_y.attribute.end_value_relative.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.ramp_generator.position_y.attribute.end_value_relative.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.ramp_generator.position_y.attribute.end_value_relative.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.ramp_generator.position_y.attribute.end_value_relative.unit', str(new_val))

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.position_y.attribute.end_value_relative.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.ramp_generator.position_y.attribute.end_value_relative.min', float(new_val))


class RootLuRamp_generatorPosition_yAttributeEnd_value_mode(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        move_relative = 1
        move_to_absolute = 0

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.position_y.attribute.end_value_mode'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value(self) -> ValueEnum:
        return RootLuRamp_generatorPosition_yAttributeEnd_value_mode.ValueEnum(self._context.get('root.lu.ramp_generator.position_y.attribute.end_value_mode.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.lu.ramp_generator.position_y.attribute.end_value_mode.value_raw', new_val.value)

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.lu.ramp_generator.position_y.attribute.end_value_mode.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.lu.ramp_generator.position_y.attribute.end_value_mode.value_raw', int(new_val))

    @property
    def enum(self) -> list:
        return list(self._context.get('root.lu.ramp_generator.position_y.attribute.end_value_mode.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.lu.ramp_generator.position_y.attribute.end_value_mode.enum', list(new_val))


class RootLuRamp_generatorPosition_yAttributeMoving_mode(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        fix_time = 0
        fix_speed = 1

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.position_y.attribute.moving_mode'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value(self) -> ValueEnum:
        return RootLuRamp_generatorPosition_yAttributeMoving_mode.ValueEnum(self._context.get('root.lu.ramp_generator.position_y.attribute.moving_mode.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.lu.ramp_generator.position_y.attribute.moving_mode.value_raw', new_val.value)

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.lu.ramp_generator.position_y.attribute.moving_mode.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.lu.ramp_generator.position_y.attribute.moving_mode.value_raw', int(new_val))

    @property
    def enum(self) -> list:
        return list(self._context.get('root.lu.ramp_generator.position_y.attribute.moving_mode.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.lu.ramp_generator.position_y.attribute.moving_mode.enum', list(new_val))


class RootLuRamp_generatorPosition_yAttributeStatus(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        stopped_by_external_event = 4
        reached_endposition = 1
        is_moving = 0
        reached_upper_limit = 3
        reached_lower_limit = 2

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.position_y.attribute.status'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value(self) -> ValueEnum:
        return RootLuRamp_generatorPosition_yAttributeStatus.ValueEnum(self._context.get('root.lu.ramp_generator.position_y.attribute.status.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.lu.ramp_generator.position_y.attribute.status.value_raw', new_val.value)

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.lu.ramp_generator.position_y.attribute.status.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.lu.ramp_generator.position_y.attribute.status.value_raw', int(new_val))

    @property
    def enum(self) -> list:
        return list(self._context.get('root.lu.ramp_generator.position_y.attribute.status.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.lu.ramp_generator.position_y.attribute.status.enum', list(new_val))


class RootLuRamp_generatorPosition_yAttributeLower_limit(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.position_y.attribute.lower_limit'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.position_y.attribute.lower_limit.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.ramp_generator.position_y.attribute.lower_limit.value', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.position_y.attribute.lower_limit.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.ramp_generator.position_y.attribute.lower_limit.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.ramp_generator.position_y.attribute.lower_limit.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.ramp_generator.position_y.attribute.lower_limit.unit', str(new_val))

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.position_y.attribute.lower_limit.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.ramp_generator.position_y.attribute.lower_limit.min', float(new_val))


class RootLuRamp_generatorPosition_yAttribute(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.position_y.attribute'
        self.lower_limit = RootLuRamp_generatorPosition_yAttributeLower_limit(self._context)
        self.status = RootLuRamp_generatorPosition_yAttributeStatus(self._context)
        self.moving_mode = RootLuRamp_generatorPosition_yAttributeMoving_mode(self._context)
        self.end_value_mode = RootLuRamp_generatorPosition_yAttributeEnd_value_mode(self._context)
        self.end_value_relative = RootLuRamp_generatorPosition_yAttributeEnd_value_relative(self._context)
        self.end_value_absolute = RootLuRamp_generatorPosition_yAttributeEnd_value_absolute(self._context)
        self.moving_speed = RootLuRamp_generatorPosition_yAttributeMoving_speed(self._context)
        self.upper_limit = RootLuRamp_generatorPosition_yAttributeUpper_limit(self._context)
        self.current_value = RootLuRamp_generatorPosition_yAttributeCurrent_value(self._context)
        self.moving_time = RootLuRamp_generatorPosition_yAttributeMoving_time(self._context)


class RootLuRamp_generatorPosition_yBusy(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.position_y.busy'

    @property
    def is_moving(self) -> bool:
        return bool(self._context.call('root.lu.ramp_generator.position_y.busy.is_moving'))


class RootLuRamp_generatorPosition_y(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.position_y'
        self.busy = RootLuRamp_generatorPosition_yBusy(self._context)
        self.attribute = RootLuRamp_generatorPosition_yAttribute(self._context)
        self.trigger = RootLuRamp_generatorPosition_yTrigger(self._context)


class RootLuRamp_generatorTip_voltageTrigger(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.tip_voltage.trigger'

    def start(self) -> None:
        return self._context.call('root.lu.ramp_generator.tip_voltage.trigger.start')

    def stop(self) -> None:
        return self._context.call('root.lu.ramp_generator.tip_voltage.trigger.stop')

    def abort(self) -> None:
        return self._context.call('root.lu.ramp_generator.tip_voltage.trigger.abort')

    def prepare(self) -> None:
        return self._context.call('root.lu.ramp_generator.tip_voltage.trigger.prepare')


class RootLuRamp_generatorTip_voltageAttributeMoving_time(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.tip_voltage.attribute.moving_time'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.tip_voltage.attribute.moving_time.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.ramp_generator.tip_voltage.attribute.moving_time.value', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.tip_voltage.attribute.moving_time.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.ramp_generator.tip_voltage.attribute.moving_time.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.ramp_generator.tip_voltage.attribute.moving_time.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.ramp_generator.tip_voltage.attribute.moving_time.unit', str(new_val))

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.tip_voltage.attribute.moving_time.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.ramp_generator.tip_voltage.attribute.moving_time.min', float(new_val))


class RootLuRamp_generatorTip_voltageAttributeCurrent_value(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.tip_voltage.attribute.current_value'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.tip_voltage.attribute.current_value.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.ramp_generator.tip_voltage.attribute.current_value.value', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.tip_voltage.attribute.current_value.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.ramp_generator.tip_voltage.attribute.current_value.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.ramp_generator.tip_voltage.attribute.current_value.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.ramp_generator.tip_voltage.attribute.current_value.unit', str(new_val))

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.tip_voltage.attribute.current_value.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.ramp_generator.tip_voltage.attribute.current_value.min', float(new_val))


class RootLuRamp_generatorTip_voltageAttributeUpper_limit(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.tip_voltage.attribute.upper_limit'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.tip_voltage.attribute.upper_limit.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.ramp_generator.tip_voltage.attribute.upper_limit.value', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.tip_voltage.attribute.upper_limit.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.ramp_generator.tip_voltage.attribute.upper_limit.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.ramp_generator.tip_voltage.attribute.upper_limit.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.ramp_generator.tip_voltage.attribute.upper_limit.unit', str(new_val))

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.tip_voltage.attribute.upper_limit.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.ramp_generator.tip_voltage.attribute.upper_limit.min', float(new_val))


class RootLuRamp_generatorTip_voltageAttributeMoving_speed(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.tip_voltage.attribute.moving_speed'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.tip_voltage.attribute.moving_speed.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.ramp_generator.tip_voltage.attribute.moving_speed.value', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.tip_voltage.attribute.moving_speed.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.ramp_generator.tip_voltage.attribute.moving_speed.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.ramp_generator.tip_voltage.attribute.moving_speed.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.ramp_generator.tip_voltage.attribute.moving_speed.unit', str(new_val))

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.tip_voltage.attribute.moving_speed.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.ramp_generator.tip_voltage.attribute.moving_speed.min', float(new_val))


class RootLuRamp_generatorTip_voltageAttributeEnd_value_absolute(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.tip_voltage.attribute.end_value_absolute'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.tip_voltage.attribute.end_value_absolute.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.ramp_generator.tip_voltage.attribute.end_value_absolute.value', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.tip_voltage.attribute.end_value_absolute.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.ramp_generator.tip_voltage.attribute.end_value_absolute.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.ramp_generator.tip_voltage.attribute.end_value_absolute.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.ramp_generator.tip_voltage.attribute.end_value_absolute.unit', str(new_val))

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.tip_voltage.attribute.end_value_absolute.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.ramp_generator.tip_voltage.attribute.end_value_absolute.min', float(new_val))


class RootLuRamp_generatorTip_voltageAttributeEnd_value_relative(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.tip_voltage.attribute.end_value_relative'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.tip_voltage.attribute.end_value_relative.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.ramp_generator.tip_voltage.attribute.end_value_relative.value', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.tip_voltage.attribute.end_value_relative.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.ramp_generator.tip_voltage.attribute.end_value_relative.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.ramp_generator.tip_voltage.attribute.end_value_relative.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.ramp_generator.tip_voltage.attribute.end_value_relative.unit', str(new_val))

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.tip_voltage.attribute.end_value_relative.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.ramp_generator.tip_voltage.attribute.end_value_relative.min', float(new_val))


class RootLuRamp_generatorTip_voltageAttributeEnd_value_mode(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        move_relative = 1
        move_to_absolute = 0

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.tip_voltage.attribute.end_value_mode'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value(self) -> ValueEnum:
        return RootLuRamp_generatorTip_voltageAttributeEnd_value_mode.ValueEnum(self._context.get('root.lu.ramp_generator.tip_voltage.attribute.end_value_mode.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.lu.ramp_generator.tip_voltage.attribute.end_value_mode.value_raw', new_val.value)

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.lu.ramp_generator.tip_voltage.attribute.end_value_mode.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.lu.ramp_generator.tip_voltage.attribute.end_value_mode.value_raw', int(new_val))

    @property
    def enum(self) -> list:
        return list(self._context.get('root.lu.ramp_generator.tip_voltage.attribute.end_value_mode.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.lu.ramp_generator.tip_voltage.attribute.end_value_mode.enum', list(new_val))


class RootLuRamp_generatorTip_voltageAttributeMoving_mode(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        fix_time = 0
        fix_speed = 1

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.tip_voltage.attribute.moving_mode'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value(self) -> ValueEnum:
        return RootLuRamp_generatorTip_voltageAttributeMoving_mode.ValueEnum(self._context.get('root.lu.ramp_generator.tip_voltage.attribute.moving_mode.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.lu.ramp_generator.tip_voltage.attribute.moving_mode.value_raw', new_val.value)

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.lu.ramp_generator.tip_voltage.attribute.moving_mode.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.lu.ramp_generator.tip_voltage.attribute.moving_mode.value_raw', int(new_val))

    @property
    def enum(self) -> list:
        return list(self._context.get('root.lu.ramp_generator.tip_voltage.attribute.moving_mode.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.lu.ramp_generator.tip_voltage.attribute.moving_mode.enum', list(new_val))


class RootLuRamp_generatorTip_voltageAttributeStatus(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        stopped_by_external_event = 4
        reached_endposition = 1
        is_moving = 0
        reached_upper_limit = 3
        reached_lower_limit = 2

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.tip_voltage.attribute.status'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value(self) -> ValueEnum:
        return RootLuRamp_generatorTip_voltageAttributeStatus.ValueEnum(self._context.get('root.lu.ramp_generator.tip_voltage.attribute.status.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.lu.ramp_generator.tip_voltage.attribute.status.value_raw', new_val.value)

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.lu.ramp_generator.tip_voltage.attribute.status.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.lu.ramp_generator.tip_voltage.attribute.status.value_raw', int(new_val))

    @property
    def enum(self) -> list:
        return list(self._context.get('root.lu.ramp_generator.tip_voltage.attribute.status.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.lu.ramp_generator.tip_voltage.attribute.status.enum', list(new_val))


class RootLuRamp_generatorTip_voltageAttributeLower_limit(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.tip_voltage.attribute.lower_limit'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.tip_voltage.attribute.lower_limit.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.ramp_generator.tip_voltage.attribute.lower_limit.value', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.tip_voltage.attribute.lower_limit.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.ramp_generator.tip_voltage.attribute.lower_limit.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.ramp_generator.tip_voltage.attribute.lower_limit.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.ramp_generator.tip_voltage.attribute.lower_limit.unit', str(new_val))

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.tip_voltage.attribute.lower_limit.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.ramp_generator.tip_voltage.attribute.lower_limit.min', float(new_val))


class RootLuRamp_generatorTip_voltageAttribute(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.tip_voltage.attribute'
        self.lower_limit = RootLuRamp_generatorTip_voltageAttributeLower_limit(self._context)
        self.status = RootLuRamp_generatorTip_voltageAttributeStatus(self._context)
        self.moving_mode = RootLuRamp_generatorTip_voltageAttributeMoving_mode(self._context)
        self.end_value_mode = RootLuRamp_generatorTip_voltageAttributeEnd_value_mode(self._context)
        self.end_value_relative = RootLuRamp_generatorTip_voltageAttributeEnd_value_relative(self._context)
        self.end_value_absolute = RootLuRamp_generatorTip_voltageAttributeEnd_value_absolute(self._context)
        self.moving_speed = RootLuRamp_generatorTip_voltageAttributeMoving_speed(self._context)
        self.upper_limit = RootLuRamp_generatorTip_voltageAttributeUpper_limit(self._context)
        self.current_value = RootLuRamp_generatorTip_voltageAttributeCurrent_value(self._context)
        self.moving_time = RootLuRamp_generatorTip_voltageAttributeMoving_time(self._context)


class RootLuRamp_generatorTip_voltageBusy(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.tip_voltage.busy'

    @property
    def is_moving(self) -> bool:
        return bool(self._context.call('root.lu.ramp_generator.tip_voltage.busy.is_moving'))


class RootLuRamp_generatorTip_voltage(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.tip_voltage'
        self.busy = RootLuRamp_generatorTip_voltageBusy(self._context)
        self.attribute = RootLuRamp_generatorTip_voltageAttribute(self._context)
        self.trigger = RootLuRamp_generatorTip_voltageTrigger(self._context)


class RootLuRamp_generatorTestTrigger(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.test.trigger'

    def start(self) -> None:
        return self._context.call('root.lu.ramp_generator.test.trigger.start')

    def stop(self) -> None:
        return self._context.call('root.lu.ramp_generator.test.trigger.stop')

    def abort(self) -> None:
        return self._context.call('root.lu.ramp_generator.test.trigger.abort')

    def prepare(self) -> None:
        return self._context.call('root.lu.ramp_generator.test.trigger.prepare')


class RootLuRamp_generatorTestAttributeMoving_time(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.test.attribute.moving_time'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.test.attribute.moving_time.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.ramp_generator.test.attribute.moving_time.value', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.test.attribute.moving_time.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.ramp_generator.test.attribute.moving_time.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.ramp_generator.test.attribute.moving_time.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.ramp_generator.test.attribute.moving_time.unit', str(new_val))

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.test.attribute.moving_time.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.ramp_generator.test.attribute.moving_time.min', float(new_val))


class RootLuRamp_generatorTestAttributeCurrent_value(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.test.attribute.current_value'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.test.attribute.current_value.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.ramp_generator.test.attribute.current_value.value', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.test.attribute.current_value.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.ramp_generator.test.attribute.current_value.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.ramp_generator.test.attribute.current_value.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.ramp_generator.test.attribute.current_value.unit', str(new_val))

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.test.attribute.current_value.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.ramp_generator.test.attribute.current_value.min', float(new_val))


class RootLuRamp_generatorTestAttributeUpper_limit(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.test.attribute.upper_limit'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.test.attribute.upper_limit.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.ramp_generator.test.attribute.upper_limit.value', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.test.attribute.upper_limit.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.ramp_generator.test.attribute.upper_limit.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.ramp_generator.test.attribute.upper_limit.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.ramp_generator.test.attribute.upper_limit.unit', str(new_val))

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.test.attribute.upper_limit.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.ramp_generator.test.attribute.upper_limit.min', float(new_val))


class RootLuRamp_generatorTestAttributeMoving_speed(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.test.attribute.moving_speed'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.test.attribute.moving_speed.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.ramp_generator.test.attribute.moving_speed.value', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.test.attribute.moving_speed.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.ramp_generator.test.attribute.moving_speed.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.ramp_generator.test.attribute.moving_speed.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.ramp_generator.test.attribute.moving_speed.unit', str(new_val))

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.test.attribute.moving_speed.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.ramp_generator.test.attribute.moving_speed.min', float(new_val))


class RootLuRamp_generatorTestAttributeEnd_value_absolute(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.test.attribute.end_value_absolute'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.test.attribute.end_value_absolute.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.ramp_generator.test.attribute.end_value_absolute.value', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.test.attribute.end_value_absolute.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.ramp_generator.test.attribute.end_value_absolute.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.ramp_generator.test.attribute.end_value_absolute.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.ramp_generator.test.attribute.end_value_absolute.unit', str(new_val))

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.test.attribute.end_value_absolute.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.ramp_generator.test.attribute.end_value_absolute.min', float(new_val))


class RootLuRamp_generatorTestAttributeEnd_value_relative(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.test.attribute.end_value_relative'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.test.attribute.end_value_relative.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.ramp_generator.test.attribute.end_value_relative.value', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.test.attribute.end_value_relative.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.ramp_generator.test.attribute.end_value_relative.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.ramp_generator.test.attribute.end_value_relative.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.ramp_generator.test.attribute.end_value_relative.unit', str(new_val))

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.test.attribute.end_value_relative.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.ramp_generator.test.attribute.end_value_relative.min', float(new_val))


class RootLuRamp_generatorTestAttributeEnd_value_mode(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        move_relative = 1
        move_to_absolute = 0

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.test.attribute.end_value_mode'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value(self) -> ValueEnum:
        return RootLuRamp_generatorTestAttributeEnd_value_mode.ValueEnum(self._context.get('root.lu.ramp_generator.test.attribute.end_value_mode.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.lu.ramp_generator.test.attribute.end_value_mode.value_raw', new_val.value)

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.lu.ramp_generator.test.attribute.end_value_mode.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.lu.ramp_generator.test.attribute.end_value_mode.value_raw', int(new_val))

    @property
    def enum(self) -> list:
        return list(self._context.get('root.lu.ramp_generator.test.attribute.end_value_mode.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.lu.ramp_generator.test.attribute.end_value_mode.enum', list(new_val))


class RootLuRamp_generatorTestAttributeMoving_mode(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        fix_time = 0
        fix_speed = 1

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.test.attribute.moving_mode'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value(self) -> ValueEnum:
        return RootLuRamp_generatorTestAttributeMoving_mode.ValueEnum(self._context.get('root.lu.ramp_generator.test.attribute.moving_mode.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.lu.ramp_generator.test.attribute.moving_mode.value_raw', new_val.value)

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.lu.ramp_generator.test.attribute.moving_mode.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.lu.ramp_generator.test.attribute.moving_mode.value_raw', int(new_val))

    @property
    def enum(self) -> list:
        return list(self._context.get('root.lu.ramp_generator.test.attribute.moving_mode.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.lu.ramp_generator.test.attribute.moving_mode.enum', list(new_val))


class RootLuRamp_generatorTestAttributeStatus(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        stopped_by_external_event = 4
        reached_endposition = 1
        is_moving = 0
        reached_upper_limit = 3
        reached_lower_limit = 2

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.test.attribute.status'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value(self) -> ValueEnum:
        return RootLuRamp_generatorTestAttributeStatus.ValueEnum(self._context.get('root.lu.ramp_generator.test.attribute.status.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.lu.ramp_generator.test.attribute.status.value_raw', new_val.value)

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.lu.ramp_generator.test.attribute.status.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.lu.ramp_generator.test.attribute.status.value_raw', int(new_val))

    @property
    def enum(self) -> list:
        return list(self._context.get('root.lu.ramp_generator.test.attribute.status.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.lu.ramp_generator.test.attribute.status.enum', list(new_val))


class RootLuRamp_generatorTestAttributeLower_limit(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.test.attribute.lower_limit'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.test.attribute.lower_limit.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.ramp_generator.test.attribute.lower_limit.value', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.test.attribute.lower_limit.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.ramp_generator.test.attribute.lower_limit.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.ramp_generator.test.attribute.lower_limit.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.ramp_generator.test.attribute.lower_limit.unit', str(new_val))

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.test.attribute.lower_limit.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.ramp_generator.test.attribute.lower_limit.min', float(new_val))


class RootLuRamp_generatorTestAttribute(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.test.attribute'
        self.lower_limit = RootLuRamp_generatorTestAttributeLower_limit(self._context)
        self.status = RootLuRamp_generatorTestAttributeStatus(self._context)
        self.moving_mode = RootLuRamp_generatorTestAttributeMoving_mode(self._context)
        self.end_value_mode = RootLuRamp_generatorTestAttributeEnd_value_mode(self._context)
        self.end_value_relative = RootLuRamp_generatorTestAttributeEnd_value_relative(self._context)
        self.end_value_absolute = RootLuRamp_generatorTestAttributeEnd_value_absolute(self._context)
        self.moving_speed = RootLuRamp_generatorTestAttributeMoving_speed(self._context)
        self.upper_limit = RootLuRamp_generatorTestAttributeUpper_limit(self._context)
        self.current_value = RootLuRamp_generatorTestAttributeCurrent_value(self._context)
        self.moving_time = RootLuRamp_generatorTestAttributeMoving_time(self._context)


class RootLuRamp_generatorTestBusy(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.test.busy'

    @property
    def is_moving(self) -> bool:
        return bool(self._context.call('root.lu.ramp_generator.test.busy.is_moving'))


class RootLuRamp_generatorTest(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.test'
        self.busy = RootLuRamp_generatorTestBusy(self._context)
        self.attribute = RootLuRamp_generatorTestAttribute(self._context)
        self.trigger = RootLuRamp_generatorTestTrigger(self._context)


class RootLuRamp_generatorUser4Trigger(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.user4.trigger'

    def start(self) -> None:
        return self._context.call('root.lu.ramp_generator.user4.trigger.start')

    def stop(self) -> None:
        return self._context.call('root.lu.ramp_generator.user4.trigger.stop')

    def abort(self) -> None:
        return self._context.call('root.lu.ramp_generator.user4.trigger.abort')

    def prepare(self) -> None:
        return self._context.call('root.lu.ramp_generator.user4.trigger.prepare')


class RootLuRamp_generatorUser4AttributeMoving_time(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.user4.attribute.moving_time'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.user4.attribute.moving_time.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.ramp_generator.user4.attribute.moving_time.value', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.user4.attribute.moving_time.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.ramp_generator.user4.attribute.moving_time.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.ramp_generator.user4.attribute.moving_time.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.ramp_generator.user4.attribute.moving_time.unit', str(new_val))

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.user4.attribute.moving_time.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.ramp_generator.user4.attribute.moving_time.min', float(new_val))


class RootLuRamp_generatorUser4AttributeCurrent_value(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.user4.attribute.current_value'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.user4.attribute.current_value.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.ramp_generator.user4.attribute.current_value.value', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.user4.attribute.current_value.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.ramp_generator.user4.attribute.current_value.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.ramp_generator.user4.attribute.current_value.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.ramp_generator.user4.attribute.current_value.unit', str(new_val))

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.user4.attribute.current_value.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.ramp_generator.user4.attribute.current_value.min', float(new_val))


class RootLuRamp_generatorUser4AttributeUpper_limit(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.user4.attribute.upper_limit'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.user4.attribute.upper_limit.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.ramp_generator.user4.attribute.upper_limit.value', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.user4.attribute.upper_limit.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.ramp_generator.user4.attribute.upper_limit.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.ramp_generator.user4.attribute.upper_limit.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.ramp_generator.user4.attribute.upper_limit.unit', str(new_val))

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.user4.attribute.upper_limit.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.ramp_generator.user4.attribute.upper_limit.min', float(new_val))


class RootLuRamp_generatorUser4AttributeMoving_speed(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.user4.attribute.moving_speed'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.user4.attribute.moving_speed.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.ramp_generator.user4.attribute.moving_speed.value', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.user4.attribute.moving_speed.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.ramp_generator.user4.attribute.moving_speed.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.ramp_generator.user4.attribute.moving_speed.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.ramp_generator.user4.attribute.moving_speed.unit', str(new_val))

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.user4.attribute.moving_speed.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.ramp_generator.user4.attribute.moving_speed.min', float(new_val))


class RootLuRamp_generatorUser4AttributeEnd_value_absolute(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.user4.attribute.end_value_absolute'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.user4.attribute.end_value_absolute.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.ramp_generator.user4.attribute.end_value_absolute.value', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.user4.attribute.end_value_absolute.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.ramp_generator.user4.attribute.end_value_absolute.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.ramp_generator.user4.attribute.end_value_absolute.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.ramp_generator.user4.attribute.end_value_absolute.unit', str(new_val))

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.user4.attribute.end_value_absolute.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.ramp_generator.user4.attribute.end_value_absolute.min', float(new_val))


class RootLuRamp_generatorUser4AttributeEnd_value_relative(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.user4.attribute.end_value_relative'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.user4.attribute.end_value_relative.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.ramp_generator.user4.attribute.end_value_relative.value', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.user4.attribute.end_value_relative.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.ramp_generator.user4.attribute.end_value_relative.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.ramp_generator.user4.attribute.end_value_relative.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.ramp_generator.user4.attribute.end_value_relative.unit', str(new_val))

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.user4.attribute.end_value_relative.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.ramp_generator.user4.attribute.end_value_relative.min', float(new_val))


class RootLuRamp_generatorUser4AttributeEnd_value_mode(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        move_relative = 1
        move_to_absolute = 0

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.user4.attribute.end_value_mode'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value(self) -> ValueEnum:
        return RootLuRamp_generatorUser4AttributeEnd_value_mode.ValueEnum(self._context.get('root.lu.ramp_generator.user4.attribute.end_value_mode.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.lu.ramp_generator.user4.attribute.end_value_mode.value_raw', new_val.value)

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.lu.ramp_generator.user4.attribute.end_value_mode.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.lu.ramp_generator.user4.attribute.end_value_mode.value_raw', int(new_val))

    @property
    def enum(self) -> list:
        return list(self._context.get('root.lu.ramp_generator.user4.attribute.end_value_mode.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.lu.ramp_generator.user4.attribute.end_value_mode.enum', list(new_val))


class RootLuRamp_generatorUser4AttributeMoving_mode(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        fix_time = 0
        fix_speed = 1

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.user4.attribute.moving_mode'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value(self) -> ValueEnum:
        return RootLuRamp_generatorUser4AttributeMoving_mode.ValueEnum(self._context.get('root.lu.ramp_generator.user4.attribute.moving_mode.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.lu.ramp_generator.user4.attribute.moving_mode.value_raw', new_val.value)

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.lu.ramp_generator.user4.attribute.moving_mode.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.lu.ramp_generator.user4.attribute.moving_mode.value_raw', int(new_val))

    @property
    def enum(self) -> list:
        return list(self._context.get('root.lu.ramp_generator.user4.attribute.moving_mode.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.lu.ramp_generator.user4.attribute.moving_mode.enum', list(new_val))


class RootLuRamp_generatorUser4AttributeStatus(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        stopped_by_external_event = 4
        reached_endposition = 1
        is_moving = 0
        reached_upper_limit = 3
        reached_lower_limit = 2

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.user4.attribute.status'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value(self) -> ValueEnum:
        return RootLuRamp_generatorUser4AttributeStatus.ValueEnum(self._context.get('root.lu.ramp_generator.user4.attribute.status.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.lu.ramp_generator.user4.attribute.status.value_raw', new_val.value)

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.lu.ramp_generator.user4.attribute.status.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.lu.ramp_generator.user4.attribute.status.value_raw', int(new_val))

    @property
    def enum(self) -> list:
        return list(self._context.get('root.lu.ramp_generator.user4.attribute.status.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.lu.ramp_generator.user4.attribute.status.enum', list(new_val))


class RootLuRamp_generatorUser4AttributeLower_limit(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.user4.attribute.lower_limit'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.user4.attribute.lower_limit.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.ramp_generator.user4.attribute.lower_limit.value', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.user4.attribute.lower_limit.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.ramp_generator.user4.attribute.lower_limit.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.ramp_generator.user4.attribute.lower_limit.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.ramp_generator.user4.attribute.lower_limit.unit', str(new_val))

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.user4.attribute.lower_limit.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.ramp_generator.user4.attribute.lower_limit.min', float(new_val))


class RootLuRamp_generatorUser4Attribute(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.user4.attribute'
        self.lower_limit = RootLuRamp_generatorUser4AttributeLower_limit(self._context)
        self.status = RootLuRamp_generatorUser4AttributeStatus(self._context)
        self.moving_mode = RootLuRamp_generatorUser4AttributeMoving_mode(self._context)
        self.end_value_mode = RootLuRamp_generatorUser4AttributeEnd_value_mode(self._context)
        self.end_value_relative = RootLuRamp_generatorUser4AttributeEnd_value_relative(self._context)
        self.end_value_absolute = RootLuRamp_generatorUser4AttributeEnd_value_absolute(self._context)
        self.moving_speed = RootLuRamp_generatorUser4AttributeMoving_speed(self._context)
        self.upper_limit = RootLuRamp_generatorUser4AttributeUpper_limit(self._context)
        self.current_value = RootLuRamp_generatorUser4AttributeCurrent_value(self._context)
        self.moving_time = RootLuRamp_generatorUser4AttributeMoving_time(self._context)


class RootLuRamp_generatorUser4Busy(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.user4.busy'

    @property
    def is_moving(self) -> bool:
        return bool(self._context.call('root.lu.ramp_generator.user4.busy.is_moving'))


class RootLuRamp_generatorUser4(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.user4'
        self.busy = RootLuRamp_generatorUser4Busy(self._context)
        self.attribute = RootLuRamp_generatorUser4Attribute(self._context)
        self.trigger = RootLuRamp_generatorUser4Trigger(self._context)


class RootLuRamp_generatorApproachTrigger(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.approach.trigger'

    def start(self) -> None:
        return self._context.call('root.lu.ramp_generator.approach.trigger.start')

    def stop(self) -> None:
        return self._context.call('root.lu.ramp_generator.approach.trigger.stop')

    def abort(self) -> None:
        return self._context.call('root.lu.ramp_generator.approach.trigger.abort')

    def prepare(self) -> None:
        return self._context.call('root.lu.ramp_generator.approach.trigger.prepare')


class RootLuRamp_generatorApproachAttributeMoving_time(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.approach.attribute.moving_time'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.approach.attribute.moving_time.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.ramp_generator.approach.attribute.moving_time.value', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.approach.attribute.moving_time.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.ramp_generator.approach.attribute.moving_time.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.ramp_generator.approach.attribute.moving_time.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.ramp_generator.approach.attribute.moving_time.unit', str(new_val))

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.approach.attribute.moving_time.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.ramp_generator.approach.attribute.moving_time.min', float(new_val))


class RootLuRamp_generatorApproachAttributeCurrent_value(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.approach.attribute.current_value'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.approach.attribute.current_value.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.ramp_generator.approach.attribute.current_value.value', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.approach.attribute.current_value.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.ramp_generator.approach.attribute.current_value.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.ramp_generator.approach.attribute.current_value.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.ramp_generator.approach.attribute.current_value.unit', str(new_val))

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.approach.attribute.current_value.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.ramp_generator.approach.attribute.current_value.min', float(new_val))


class RootLuRamp_generatorApproachAttributeUpper_limit(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.approach.attribute.upper_limit'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.approach.attribute.upper_limit.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.ramp_generator.approach.attribute.upper_limit.value', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.approach.attribute.upper_limit.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.ramp_generator.approach.attribute.upper_limit.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.ramp_generator.approach.attribute.upper_limit.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.ramp_generator.approach.attribute.upper_limit.unit', str(new_val))

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.approach.attribute.upper_limit.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.ramp_generator.approach.attribute.upper_limit.min', float(new_val))


class RootLuRamp_generatorApproachAttributeMoving_speed(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.approach.attribute.moving_speed'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.approach.attribute.moving_speed.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.ramp_generator.approach.attribute.moving_speed.value', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.approach.attribute.moving_speed.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.ramp_generator.approach.attribute.moving_speed.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.ramp_generator.approach.attribute.moving_speed.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.ramp_generator.approach.attribute.moving_speed.unit', str(new_val))

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.approach.attribute.moving_speed.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.ramp_generator.approach.attribute.moving_speed.min', float(new_val))


class RootLuRamp_generatorApproachAttributeEnd_value_absolute(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.approach.attribute.end_value_absolute'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.approach.attribute.end_value_absolute.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.ramp_generator.approach.attribute.end_value_absolute.value', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.approach.attribute.end_value_absolute.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.ramp_generator.approach.attribute.end_value_absolute.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.ramp_generator.approach.attribute.end_value_absolute.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.ramp_generator.approach.attribute.end_value_absolute.unit', str(new_val))

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.approach.attribute.end_value_absolute.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.ramp_generator.approach.attribute.end_value_absolute.min', float(new_val))


class RootLuRamp_generatorApproachAttributeEnd_value_relative(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.approach.attribute.end_value_relative'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.approach.attribute.end_value_relative.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.ramp_generator.approach.attribute.end_value_relative.value', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.approach.attribute.end_value_relative.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.ramp_generator.approach.attribute.end_value_relative.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.ramp_generator.approach.attribute.end_value_relative.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.ramp_generator.approach.attribute.end_value_relative.unit', str(new_val))

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.approach.attribute.end_value_relative.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.ramp_generator.approach.attribute.end_value_relative.min', float(new_val))


class RootLuRamp_generatorApproachAttributeEnd_value_mode(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        move_relative = 1
        move_to_absolute = 0

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.approach.attribute.end_value_mode'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value(self) -> ValueEnum:
        return RootLuRamp_generatorApproachAttributeEnd_value_mode.ValueEnum(self._context.get('root.lu.ramp_generator.approach.attribute.end_value_mode.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.lu.ramp_generator.approach.attribute.end_value_mode.value_raw', new_val.value)

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.lu.ramp_generator.approach.attribute.end_value_mode.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.lu.ramp_generator.approach.attribute.end_value_mode.value_raw', int(new_val))

    @property
    def enum(self) -> list:
        return list(self._context.get('root.lu.ramp_generator.approach.attribute.end_value_mode.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.lu.ramp_generator.approach.attribute.end_value_mode.enum', list(new_val))


class RootLuRamp_generatorApproachAttributeMoving_mode(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        fix_time = 0
        fix_speed = 1

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.approach.attribute.moving_mode'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value(self) -> ValueEnum:
        return RootLuRamp_generatorApproachAttributeMoving_mode.ValueEnum(self._context.get('root.lu.ramp_generator.approach.attribute.moving_mode.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.lu.ramp_generator.approach.attribute.moving_mode.value_raw', new_val.value)

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.lu.ramp_generator.approach.attribute.moving_mode.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.lu.ramp_generator.approach.attribute.moving_mode.value_raw', int(new_val))

    @property
    def enum(self) -> list:
        return list(self._context.get('root.lu.ramp_generator.approach.attribute.moving_mode.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.lu.ramp_generator.approach.attribute.moving_mode.enum', list(new_val))


class RootLuRamp_generatorApproachAttributeStatus(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        stopped_by_external_event = 4
        reached_endposition = 1
        is_moving = 0
        reached_upper_limit = 3
        reached_lower_limit = 2

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.approach.attribute.status'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value(self) -> ValueEnum:
        return RootLuRamp_generatorApproachAttributeStatus.ValueEnum(self._context.get('root.lu.ramp_generator.approach.attribute.status.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.lu.ramp_generator.approach.attribute.status.value_raw', new_val.value)

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.lu.ramp_generator.approach.attribute.status.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.lu.ramp_generator.approach.attribute.status.value_raw', int(new_val))

    @property
    def enum(self) -> list:
        return list(self._context.get('root.lu.ramp_generator.approach.attribute.status.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.lu.ramp_generator.approach.attribute.status.enum', list(new_val))


class RootLuRamp_generatorApproachAttributeLower_limit(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.approach.attribute.lower_limit'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.approach.attribute.lower_limit.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.ramp_generator.approach.attribute.lower_limit.value', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.approach.attribute.lower_limit.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.ramp_generator.approach.attribute.lower_limit.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.ramp_generator.approach.attribute.lower_limit.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.ramp_generator.approach.attribute.lower_limit.unit', str(new_val))

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.approach.attribute.lower_limit.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.ramp_generator.approach.attribute.lower_limit.min', float(new_val))


class RootLuRamp_generatorApproachAttribute(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.approach.attribute'
        self.lower_limit = RootLuRamp_generatorApproachAttributeLower_limit(self._context)
        self.status = RootLuRamp_generatorApproachAttributeStatus(self._context)
        self.moving_mode = RootLuRamp_generatorApproachAttributeMoving_mode(self._context)
        self.end_value_mode = RootLuRamp_generatorApproachAttributeEnd_value_mode(self._context)
        self.end_value_relative = RootLuRamp_generatorApproachAttributeEnd_value_relative(self._context)
        self.end_value_absolute = RootLuRamp_generatorApproachAttributeEnd_value_absolute(self._context)
        self.moving_speed = RootLuRamp_generatorApproachAttributeMoving_speed(self._context)
        self.upper_limit = RootLuRamp_generatorApproachAttributeUpper_limit(self._context)
        self.current_value = RootLuRamp_generatorApproachAttributeCurrent_value(self._context)
        self.moving_time = RootLuRamp_generatorApproachAttributeMoving_time(self._context)


class RootLuRamp_generatorApproachBusy(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.approach.busy'

    @property
    def is_moving(self) -> bool:
        return bool(self._context.call('root.lu.ramp_generator.approach.busy.is_moving'))


class RootLuRamp_generatorApproach(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.approach'
        self.busy = RootLuRamp_generatorApproachBusy(self._context)
        self.attribute = RootLuRamp_generatorApproachAttribute(self._context)
        self.trigger = RootLuRamp_generatorApproachTrigger(self._context)


class RootLuRamp_generatorVirtual0Trigger(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.virtual0.trigger'

    def start(self) -> None:
        return self._context.call('root.lu.ramp_generator.virtual0.trigger.start')

    def stop(self) -> None:
        return self._context.call('root.lu.ramp_generator.virtual0.trigger.stop')

    def abort(self) -> None:
        return self._context.call('root.lu.ramp_generator.virtual0.trigger.abort')

    def prepare(self) -> None:
        return self._context.call('root.lu.ramp_generator.virtual0.trigger.prepare')


class RootLuRamp_generatorVirtual0AttributeMoving_time(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.virtual0.attribute.moving_time'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.virtual0.attribute.moving_time.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.ramp_generator.virtual0.attribute.moving_time.value', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.virtual0.attribute.moving_time.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.ramp_generator.virtual0.attribute.moving_time.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.ramp_generator.virtual0.attribute.moving_time.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.ramp_generator.virtual0.attribute.moving_time.unit', str(new_val))

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.virtual0.attribute.moving_time.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.ramp_generator.virtual0.attribute.moving_time.min', float(new_val))


class RootLuRamp_generatorVirtual0AttributeCurrent_value(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.virtual0.attribute.current_value'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.virtual0.attribute.current_value.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.ramp_generator.virtual0.attribute.current_value.value', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.virtual0.attribute.current_value.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.ramp_generator.virtual0.attribute.current_value.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.ramp_generator.virtual0.attribute.current_value.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.ramp_generator.virtual0.attribute.current_value.unit', str(new_val))

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.virtual0.attribute.current_value.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.ramp_generator.virtual0.attribute.current_value.min', float(new_val))


class RootLuRamp_generatorVirtual0AttributeUpper_limit(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.virtual0.attribute.upper_limit'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.virtual0.attribute.upper_limit.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.ramp_generator.virtual0.attribute.upper_limit.value', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.virtual0.attribute.upper_limit.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.ramp_generator.virtual0.attribute.upper_limit.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.ramp_generator.virtual0.attribute.upper_limit.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.ramp_generator.virtual0.attribute.upper_limit.unit', str(new_val))

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.virtual0.attribute.upper_limit.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.ramp_generator.virtual0.attribute.upper_limit.min', float(new_val))


class RootLuRamp_generatorVirtual0AttributeMoving_speed(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.virtual0.attribute.moving_speed'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.virtual0.attribute.moving_speed.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.ramp_generator.virtual0.attribute.moving_speed.value', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.virtual0.attribute.moving_speed.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.ramp_generator.virtual0.attribute.moving_speed.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.ramp_generator.virtual0.attribute.moving_speed.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.ramp_generator.virtual0.attribute.moving_speed.unit', str(new_val))

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.virtual0.attribute.moving_speed.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.ramp_generator.virtual0.attribute.moving_speed.min', float(new_val))


class RootLuRamp_generatorVirtual0AttributeEnd_value_absolute(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.virtual0.attribute.end_value_absolute'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.virtual0.attribute.end_value_absolute.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.ramp_generator.virtual0.attribute.end_value_absolute.value', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.virtual0.attribute.end_value_absolute.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.ramp_generator.virtual0.attribute.end_value_absolute.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.ramp_generator.virtual0.attribute.end_value_absolute.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.ramp_generator.virtual0.attribute.end_value_absolute.unit', str(new_val))

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.virtual0.attribute.end_value_absolute.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.ramp_generator.virtual0.attribute.end_value_absolute.min', float(new_val))


class RootLuRamp_generatorVirtual0AttributeEnd_value_relative(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.virtual0.attribute.end_value_relative'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.virtual0.attribute.end_value_relative.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.ramp_generator.virtual0.attribute.end_value_relative.value', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.virtual0.attribute.end_value_relative.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.ramp_generator.virtual0.attribute.end_value_relative.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.ramp_generator.virtual0.attribute.end_value_relative.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.ramp_generator.virtual0.attribute.end_value_relative.unit', str(new_val))

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.virtual0.attribute.end_value_relative.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.ramp_generator.virtual0.attribute.end_value_relative.min', float(new_val))


class RootLuRamp_generatorVirtual0AttributeEnd_value_mode(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        move_relative = 1
        move_to_absolute = 0

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.virtual0.attribute.end_value_mode'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value(self) -> ValueEnum:
        return RootLuRamp_generatorVirtual0AttributeEnd_value_mode.ValueEnum(self._context.get('root.lu.ramp_generator.virtual0.attribute.end_value_mode.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.lu.ramp_generator.virtual0.attribute.end_value_mode.value_raw', new_val.value)

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.lu.ramp_generator.virtual0.attribute.end_value_mode.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.lu.ramp_generator.virtual0.attribute.end_value_mode.value_raw', int(new_val))

    @property
    def enum(self) -> list:
        return list(self._context.get('root.lu.ramp_generator.virtual0.attribute.end_value_mode.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.lu.ramp_generator.virtual0.attribute.end_value_mode.enum', list(new_val))


class RootLuRamp_generatorVirtual0AttributeMoving_mode(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        fix_time = 0
        fix_speed = 1

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.virtual0.attribute.moving_mode'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value(self) -> ValueEnum:
        return RootLuRamp_generatorVirtual0AttributeMoving_mode.ValueEnum(self._context.get('root.lu.ramp_generator.virtual0.attribute.moving_mode.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.lu.ramp_generator.virtual0.attribute.moving_mode.value_raw', new_val.value)

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.lu.ramp_generator.virtual0.attribute.moving_mode.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.lu.ramp_generator.virtual0.attribute.moving_mode.value_raw', int(new_val))

    @property
    def enum(self) -> list:
        return list(self._context.get('root.lu.ramp_generator.virtual0.attribute.moving_mode.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.lu.ramp_generator.virtual0.attribute.moving_mode.enum', list(new_val))


class RootLuRamp_generatorVirtual0AttributeStatus(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        stopped_by_external_event = 4
        reached_endposition = 1
        is_moving = 0
        reached_upper_limit = 3
        reached_lower_limit = 2

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.virtual0.attribute.status'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value(self) -> ValueEnum:
        return RootLuRamp_generatorVirtual0AttributeStatus.ValueEnum(self._context.get('root.lu.ramp_generator.virtual0.attribute.status.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.lu.ramp_generator.virtual0.attribute.status.value_raw', new_val.value)

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.lu.ramp_generator.virtual0.attribute.status.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.lu.ramp_generator.virtual0.attribute.status.value_raw', int(new_val))

    @property
    def enum(self) -> list:
        return list(self._context.get('root.lu.ramp_generator.virtual0.attribute.status.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.lu.ramp_generator.virtual0.attribute.status.enum', list(new_val))


class RootLuRamp_generatorVirtual0AttributeLower_limit(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.virtual0.attribute.lower_limit'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.virtual0.attribute.lower_limit.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.ramp_generator.virtual0.attribute.lower_limit.value', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.virtual0.attribute.lower_limit.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.ramp_generator.virtual0.attribute.lower_limit.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.ramp_generator.virtual0.attribute.lower_limit.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.ramp_generator.virtual0.attribute.lower_limit.unit', str(new_val))

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.virtual0.attribute.lower_limit.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.ramp_generator.virtual0.attribute.lower_limit.min', float(new_val))


class RootLuRamp_generatorVirtual0Attribute(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.virtual0.attribute'
        self.lower_limit = RootLuRamp_generatorVirtual0AttributeLower_limit(self._context)
        self.status = RootLuRamp_generatorVirtual0AttributeStatus(self._context)
        self.moving_mode = RootLuRamp_generatorVirtual0AttributeMoving_mode(self._context)
        self.end_value_mode = RootLuRamp_generatorVirtual0AttributeEnd_value_mode(self._context)
        self.end_value_relative = RootLuRamp_generatorVirtual0AttributeEnd_value_relative(self._context)
        self.end_value_absolute = RootLuRamp_generatorVirtual0AttributeEnd_value_absolute(self._context)
        self.moving_speed = RootLuRamp_generatorVirtual0AttributeMoving_speed(self._context)
        self.upper_limit = RootLuRamp_generatorVirtual0AttributeUpper_limit(self._context)
        self.current_value = RootLuRamp_generatorVirtual0AttributeCurrent_value(self._context)
        self.moving_time = RootLuRamp_generatorVirtual0AttributeMoving_time(self._context)


class RootLuRamp_generatorVirtual0Busy(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.virtual0.busy'

    @property
    def is_moving(self) -> bool:
        return bool(self._context.call('root.lu.ramp_generator.virtual0.busy.is_moving'))


class RootLuRamp_generatorVirtual0(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.virtual0'
        self.busy = RootLuRamp_generatorVirtual0Busy(self._context)
        self.attribute = RootLuRamp_generatorVirtual0Attribute(self._context)
        self.trigger = RootLuRamp_generatorVirtual0Trigger(self._context)


class RootLuRamp_generatorVirtual1Trigger(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.virtual1.trigger'

    def start(self) -> None:
        return self._context.call('root.lu.ramp_generator.virtual1.trigger.start')

    def stop(self) -> None:
        return self._context.call('root.lu.ramp_generator.virtual1.trigger.stop')

    def abort(self) -> None:
        return self._context.call('root.lu.ramp_generator.virtual1.trigger.abort')

    def prepare(self) -> None:
        return self._context.call('root.lu.ramp_generator.virtual1.trigger.prepare')


class RootLuRamp_generatorVirtual1AttributeMoving_time(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.virtual1.attribute.moving_time'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.virtual1.attribute.moving_time.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.ramp_generator.virtual1.attribute.moving_time.value', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.virtual1.attribute.moving_time.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.ramp_generator.virtual1.attribute.moving_time.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.ramp_generator.virtual1.attribute.moving_time.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.ramp_generator.virtual1.attribute.moving_time.unit', str(new_val))

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.virtual1.attribute.moving_time.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.ramp_generator.virtual1.attribute.moving_time.min', float(new_val))


class RootLuRamp_generatorVirtual1AttributeCurrent_value(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.virtual1.attribute.current_value'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.virtual1.attribute.current_value.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.ramp_generator.virtual1.attribute.current_value.value', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.virtual1.attribute.current_value.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.ramp_generator.virtual1.attribute.current_value.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.ramp_generator.virtual1.attribute.current_value.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.ramp_generator.virtual1.attribute.current_value.unit', str(new_val))

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.virtual1.attribute.current_value.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.ramp_generator.virtual1.attribute.current_value.min', float(new_val))


class RootLuRamp_generatorVirtual1AttributeUpper_limit(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.virtual1.attribute.upper_limit'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.virtual1.attribute.upper_limit.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.ramp_generator.virtual1.attribute.upper_limit.value', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.virtual1.attribute.upper_limit.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.ramp_generator.virtual1.attribute.upper_limit.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.ramp_generator.virtual1.attribute.upper_limit.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.ramp_generator.virtual1.attribute.upper_limit.unit', str(new_val))

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.virtual1.attribute.upper_limit.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.ramp_generator.virtual1.attribute.upper_limit.min', float(new_val))


class RootLuRamp_generatorVirtual1AttributeMoving_speed(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.virtual1.attribute.moving_speed'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.virtual1.attribute.moving_speed.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.ramp_generator.virtual1.attribute.moving_speed.value', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.virtual1.attribute.moving_speed.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.ramp_generator.virtual1.attribute.moving_speed.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.ramp_generator.virtual1.attribute.moving_speed.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.ramp_generator.virtual1.attribute.moving_speed.unit', str(new_val))

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.virtual1.attribute.moving_speed.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.ramp_generator.virtual1.attribute.moving_speed.min', float(new_val))


class RootLuRamp_generatorVirtual1AttributeEnd_value_absolute(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.virtual1.attribute.end_value_absolute'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.virtual1.attribute.end_value_absolute.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.ramp_generator.virtual1.attribute.end_value_absolute.value', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.virtual1.attribute.end_value_absolute.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.ramp_generator.virtual1.attribute.end_value_absolute.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.ramp_generator.virtual1.attribute.end_value_absolute.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.ramp_generator.virtual1.attribute.end_value_absolute.unit', str(new_val))

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.virtual1.attribute.end_value_absolute.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.ramp_generator.virtual1.attribute.end_value_absolute.min', float(new_val))


class RootLuRamp_generatorVirtual1AttributeEnd_value_relative(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.virtual1.attribute.end_value_relative'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.virtual1.attribute.end_value_relative.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.ramp_generator.virtual1.attribute.end_value_relative.value', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.virtual1.attribute.end_value_relative.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.ramp_generator.virtual1.attribute.end_value_relative.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.ramp_generator.virtual1.attribute.end_value_relative.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.ramp_generator.virtual1.attribute.end_value_relative.unit', str(new_val))

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.virtual1.attribute.end_value_relative.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.ramp_generator.virtual1.attribute.end_value_relative.min', float(new_val))


class RootLuRamp_generatorVirtual1AttributeEnd_value_mode(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        move_relative = 1
        move_to_absolute = 0

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.virtual1.attribute.end_value_mode'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value(self) -> ValueEnum:
        return RootLuRamp_generatorVirtual1AttributeEnd_value_mode.ValueEnum(self._context.get('root.lu.ramp_generator.virtual1.attribute.end_value_mode.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.lu.ramp_generator.virtual1.attribute.end_value_mode.value_raw', new_val.value)

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.lu.ramp_generator.virtual1.attribute.end_value_mode.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.lu.ramp_generator.virtual1.attribute.end_value_mode.value_raw', int(new_val))

    @property
    def enum(self) -> list:
        return list(self._context.get('root.lu.ramp_generator.virtual1.attribute.end_value_mode.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.lu.ramp_generator.virtual1.attribute.end_value_mode.enum', list(new_val))


class RootLuRamp_generatorVirtual1AttributeMoving_mode(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        fix_time = 0
        fix_speed = 1

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.virtual1.attribute.moving_mode'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value(self) -> ValueEnum:
        return RootLuRamp_generatorVirtual1AttributeMoving_mode.ValueEnum(self._context.get('root.lu.ramp_generator.virtual1.attribute.moving_mode.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.lu.ramp_generator.virtual1.attribute.moving_mode.value_raw', new_val.value)

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.lu.ramp_generator.virtual1.attribute.moving_mode.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.lu.ramp_generator.virtual1.attribute.moving_mode.value_raw', int(new_val))

    @property
    def enum(self) -> list:
        return list(self._context.get('root.lu.ramp_generator.virtual1.attribute.moving_mode.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.lu.ramp_generator.virtual1.attribute.moving_mode.enum', list(new_val))


class RootLuRamp_generatorVirtual1AttributeStatus(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        stopped_by_external_event = 4
        reached_endposition = 1
        is_moving = 0
        reached_upper_limit = 3
        reached_lower_limit = 2

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.virtual1.attribute.status'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value(self) -> ValueEnum:
        return RootLuRamp_generatorVirtual1AttributeStatus.ValueEnum(self._context.get('root.lu.ramp_generator.virtual1.attribute.status.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.lu.ramp_generator.virtual1.attribute.status.value_raw', new_val.value)

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.lu.ramp_generator.virtual1.attribute.status.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.lu.ramp_generator.virtual1.attribute.status.value_raw', int(new_val))

    @property
    def enum(self) -> list:
        return list(self._context.get('root.lu.ramp_generator.virtual1.attribute.status.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.lu.ramp_generator.virtual1.attribute.status.enum', list(new_val))


class RootLuRamp_generatorVirtual1AttributeLower_limit(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.virtual1.attribute.lower_limit'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.virtual1.attribute.lower_limit.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.ramp_generator.virtual1.attribute.lower_limit.value', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.virtual1.attribute.lower_limit.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.ramp_generator.virtual1.attribute.lower_limit.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.ramp_generator.virtual1.attribute.lower_limit.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.ramp_generator.virtual1.attribute.lower_limit.unit', str(new_val))

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.virtual1.attribute.lower_limit.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.ramp_generator.virtual1.attribute.lower_limit.min', float(new_val))


class RootLuRamp_generatorVirtual1Attribute(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.virtual1.attribute'
        self.lower_limit = RootLuRamp_generatorVirtual1AttributeLower_limit(self._context)
        self.status = RootLuRamp_generatorVirtual1AttributeStatus(self._context)
        self.moving_mode = RootLuRamp_generatorVirtual1AttributeMoving_mode(self._context)
        self.end_value_mode = RootLuRamp_generatorVirtual1AttributeEnd_value_mode(self._context)
        self.end_value_relative = RootLuRamp_generatorVirtual1AttributeEnd_value_relative(self._context)
        self.end_value_absolute = RootLuRamp_generatorVirtual1AttributeEnd_value_absolute(self._context)
        self.moving_speed = RootLuRamp_generatorVirtual1AttributeMoving_speed(self._context)
        self.upper_limit = RootLuRamp_generatorVirtual1AttributeUpper_limit(self._context)
        self.current_value = RootLuRamp_generatorVirtual1AttributeCurrent_value(self._context)
        self.moving_time = RootLuRamp_generatorVirtual1AttributeMoving_time(self._context)


class RootLuRamp_generatorVirtual1Busy(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.virtual1.busy'

    @property
    def is_moving(self) -> bool:
        return bool(self._context.call('root.lu.ramp_generator.virtual1.busy.is_moving'))


class RootLuRamp_generatorVirtual1(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.virtual1'
        self.busy = RootLuRamp_generatorVirtual1Busy(self._context)
        self.attribute = RootLuRamp_generatorVirtual1Attribute(self._context)
        self.trigger = RootLuRamp_generatorVirtual1Trigger(self._context)


class RootLuRamp_generatorUser2Trigger(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.user2.trigger'

    def start(self) -> None:
        return self._context.call('root.lu.ramp_generator.user2.trigger.start')

    def stop(self) -> None:
        return self._context.call('root.lu.ramp_generator.user2.trigger.stop')

    def abort(self) -> None:
        return self._context.call('root.lu.ramp_generator.user2.trigger.abort')

    def prepare(self) -> None:
        return self._context.call('root.lu.ramp_generator.user2.trigger.prepare')


class RootLuRamp_generatorUser2AttributeMoving_time(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.user2.attribute.moving_time'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.user2.attribute.moving_time.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.ramp_generator.user2.attribute.moving_time.value', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.user2.attribute.moving_time.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.ramp_generator.user2.attribute.moving_time.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.ramp_generator.user2.attribute.moving_time.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.ramp_generator.user2.attribute.moving_time.unit', str(new_val))

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.user2.attribute.moving_time.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.ramp_generator.user2.attribute.moving_time.min', float(new_val))


class RootLuRamp_generatorUser2AttributeCurrent_value(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.user2.attribute.current_value'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.user2.attribute.current_value.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.ramp_generator.user2.attribute.current_value.value', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.user2.attribute.current_value.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.ramp_generator.user2.attribute.current_value.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.ramp_generator.user2.attribute.current_value.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.ramp_generator.user2.attribute.current_value.unit', str(new_val))

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.user2.attribute.current_value.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.ramp_generator.user2.attribute.current_value.min', float(new_val))


class RootLuRamp_generatorUser2AttributeUpper_limit(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.user2.attribute.upper_limit'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.user2.attribute.upper_limit.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.ramp_generator.user2.attribute.upper_limit.value', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.user2.attribute.upper_limit.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.ramp_generator.user2.attribute.upper_limit.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.ramp_generator.user2.attribute.upper_limit.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.ramp_generator.user2.attribute.upper_limit.unit', str(new_val))

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.user2.attribute.upper_limit.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.ramp_generator.user2.attribute.upper_limit.min', float(new_val))


class RootLuRamp_generatorUser2AttributeMoving_speed(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.user2.attribute.moving_speed'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.user2.attribute.moving_speed.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.ramp_generator.user2.attribute.moving_speed.value', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.user2.attribute.moving_speed.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.ramp_generator.user2.attribute.moving_speed.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.ramp_generator.user2.attribute.moving_speed.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.ramp_generator.user2.attribute.moving_speed.unit', str(new_val))

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.user2.attribute.moving_speed.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.ramp_generator.user2.attribute.moving_speed.min', float(new_val))


class RootLuRamp_generatorUser2AttributeEnd_value_absolute(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.user2.attribute.end_value_absolute'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.user2.attribute.end_value_absolute.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.ramp_generator.user2.attribute.end_value_absolute.value', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.user2.attribute.end_value_absolute.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.ramp_generator.user2.attribute.end_value_absolute.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.ramp_generator.user2.attribute.end_value_absolute.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.ramp_generator.user2.attribute.end_value_absolute.unit', str(new_val))

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.user2.attribute.end_value_absolute.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.ramp_generator.user2.attribute.end_value_absolute.min', float(new_val))


class RootLuRamp_generatorUser2AttributeEnd_value_relative(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.user2.attribute.end_value_relative'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.user2.attribute.end_value_relative.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.ramp_generator.user2.attribute.end_value_relative.value', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.user2.attribute.end_value_relative.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.ramp_generator.user2.attribute.end_value_relative.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.ramp_generator.user2.attribute.end_value_relative.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.ramp_generator.user2.attribute.end_value_relative.unit', str(new_val))

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.user2.attribute.end_value_relative.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.ramp_generator.user2.attribute.end_value_relative.min', float(new_val))


class RootLuRamp_generatorUser2AttributeEnd_value_mode(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        move_relative = 1
        move_to_absolute = 0

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.user2.attribute.end_value_mode'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value(self) -> ValueEnum:
        return RootLuRamp_generatorUser2AttributeEnd_value_mode.ValueEnum(self._context.get('root.lu.ramp_generator.user2.attribute.end_value_mode.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.lu.ramp_generator.user2.attribute.end_value_mode.value_raw', new_val.value)

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.lu.ramp_generator.user2.attribute.end_value_mode.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.lu.ramp_generator.user2.attribute.end_value_mode.value_raw', int(new_val))

    @property
    def enum(self) -> list:
        return list(self._context.get('root.lu.ramp_generator.user2.attribute.end_value_mode.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.lu.ramp_generator.user2.attribute.end_value_mode.enum', list(new_val))


class RootLuRamp_generatorUser2AttributeMoving_mode(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        fix_time = 0
        fix_speed = 1

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.user2.attribute.moving_mode'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value(self) -> ValueEnum:
        return RootLuRamp_generatorUser2AttributeMoving_mode.ValueEnum(self._context.get('root.lu.ramp_generator.user2.attribute.moving_mode.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.lu.ramp_generator.user2.attribute.moving_mode.value_raw', new_val.value)

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.lu.ramp_generator.user2.attribute.moving_mode.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.lu.ramp_generator.user2.attribute.moving_mode.value_raw', int(new_val))

    @property
    def enum(self) -> list:
        return list(self._context.get('root.lu.ramp_generator.user2.attribute.moving_mode.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.lu.ramp_generator.user2.attribute.moving_mode.enum', list(new_val))


class RootLuRamp_generatorUser2AttributeStatus(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        stopped_by_external_event = 4
        reached_endposition = 1
        is_moving = 0
        reached_upper_limit = 3
        reached_lower_limit = 2

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.user2.attribute.status'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value(self) -> ValueEnum:
        return RootLuRamp_generatorUser2AttributeStatus.ValueEnum(self._context.get('root.lu.ramp_generator.user2.attribute.status.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.lu.ramp_generator.user2.attribute.status.value_raw', new_val.value)

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.lu.ramp_generator.user2.attribute.status.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.lu.ramp_generator.user2.attribute.status.value_raw', int(new_val))

    @property
    def enum(self) -> list:
        return list(self._context.get('root.lu.ramp_generator.user2.attribute.status.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.lu.ramp_generator.user2.attribute.status.enum', list(new_val))


class RootLuRamp_generatorUser2AttributeLower_limit(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.user2.attribute.lower_limit'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.user2.attribute.lower_limit.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.ramp_generator.user2.attribute.lower_limit.value', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.user2.attribute.lower_limit.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.ramp_generator.user2.attribute.lower_limit.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.ramp_generator.user2.attribute.lower_limit.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.ramp_generator.user2.attribute.lower_limit.unit', str(new_val))

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.user2.attribute.lower_limit.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.ramp_generator.user2.attribute.lower_limit.min', float(new_val))


class RootLuRamp_generatorUser2Attribute(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.user2.attribute'
        self.lower_limit = RootLuRamp_generatorUser2AttributeLower_limit(self._context)
        self.status = RootLuRamp_generatorUser2AttributeStatus(self._context)
        self.moving_mode = RootLuRamp_generatorUser2AttributeMoving_mode(self._context)
        self.end_value_mode = RootLuRamp_generatorUser2AttributeEnd_value_mode(self._context)
        self.end_value_relative = RootLuRamp_generatorUser2AttributeEnd_value_relative(self._context)
        self.end_value_absolute = RootLuRamp_generatorUser2AttributeEnd_value_absolute(self._context)
        self.moving_speed = RootLuRamp_generatorUser2AttributeMoving_speed(self._context)
        self.upper_limit = RootLuRamp_generatorUser2AttributeUpper_limit(self._context)
        self.current_value = RootLuRamp_generatorUser2AttributeCurrent_value(self._context)
        self.moving_time = RootLuRamp_generatorUser2AttributeMoving_time(self._context)


class RootLuRamp_generatorUser2Busy(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.user2.busy'

    @property
    def is_moving(self) -> bool:
        return bool(self._context.call('root.lu.ramp_generator.user2.busy.is_moving'))


class RootLuRamp_generatorUser2(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.user2'
        self.busy = RootLuRamp_generatorUser2Busy(self._context)
        self.attribute = RootLuRamp_generatorUser2Attribute(self._context)
        self.trigger = RootLuRamp_generatorUser2Trigger(self._context)


class RootLuRamp_generatorUser1Trigger(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.user1.trigger'

    def start(self) -> None:
        return self._context.call('root.lu.ramp_generator.user1.trigger.start')

    def stop(self) -> None:
        return self._context.call('root.lu.ramp_generator.user1.trigger.stop')

    def abort(self) -> None:
        return self._context.call('root.lu.ramp_generator.user1.trigger.abort')

    def prepare(self) -> None:
        return self._context.call('root.lu.ramp_generator.user1.trigger.prepare')


class RootLuRamp_generatorUser1AttributeMoving_time(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.user1.attribute.moving_time'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.user1.attribute.moving_time.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.ramp_generator.user1.attribute.moving_time.value', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.user1.attribute.moving_time.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.ramp_generator.user1.attribute.moving_time.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.ramp_generator.user1.attribute.moving_time.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.ramp_generator.user1.attribute.moving_time.unit', str(new_val))

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.user1.attribute.moving_time.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.ramp_generator.user1.attribute.moving_time.min', float(new_val))


class RootLuRamp_generatorUser1AttributeCurrent_value(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.user1.attribute.current_value'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.user1.attribute.current_value.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.ramp_generator.user1.attribute.current_value.value', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.user1.attribute.current_value.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.ramp_generator.user1.attribute.current_value.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.ramp_generator.user1.attribute.current_value.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.ramp_generator.user1.attribute.current_value.unit', str(new_val))

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.user1.attribute.current_value.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.ramp_generator.user1.attribute.current_value.min', float(new_val))


class RootLuRamp_generatorUser1AttributeUpper_limit(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.user1.attribute.upper_limit'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.user1.attribute.upper_limit.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.ramp_generator.user1.attribute.upper_limit.value', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.user1.attribute.upper_limit.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.ramp_generator.user1.attribute.upper_limit.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.ramp_generator.user1.attribute.upper_limit.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.ramp_generator.user1.attribute.upper_limit.unit', str(new_val))

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.user1.attribute.upper_limit.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.ramp_generator.user1.attribute.upper_limit.min', float(new_val))


class RootLuRamp_generatorUser1AttributeMoving_speed(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.user1.attribute.moving_speed'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.user1.attribute.moving_speed.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.ramp_generator.user1.attribute.moving_speed.value', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.user1.attribute.moving_speed.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.ramp_generator.user1.attribute.moving_speed.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.ramp_generator.user1.attribute.moving_speed.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.ramp_generator.user1.attribute.moving_speed.unit', str(new_val))

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.user1.attribute.moving_speed.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.ramp_generator.user1.attribute.moving_speed.min', float(new_val))


class RootLuRamp_generatorUser1AttributeEnd_value_absolute(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.user1.attribute.end_value_absolute'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.user1.attribute.end_value_absolute.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.ramp_generator.user1.attribute.end_value_absolute.value', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.user1.attribute.end_value_absolute.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.ramp_generator.user1.attribute.end_value_absolute.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.ramp_generator.user1.attribute.end_value_absolute.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.ramp_generator.user1.attribute.end_value_absolute.unit', str(new_val))

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.user1.attribute.end_value_absolute.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.ramp_generator.user1.attribute.end_value_absolute.min', float(new_val))


class RootLuRamp_generatorUser1AttributeEnd_value_relative(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.user1.attribute.end_value_relative'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.user1.attribute.end_value_relative.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.ramp_generator.user1.attribute.end_value_relative.value', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.user1.attribute.end_value_relative.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.ramp_generator.user1.attribute.end_value_relative.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.ramp_generator.user1.attribute.end_value_relative.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.ramp_generator.user1.attribute.end_value_relative.unit', str(new_val))

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.user1.attribute.end_value_relative.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.ramp_generator.user1.attribute.end_value_relative.min', float(new_val))


class RootLuRamp_generatorUser1AttributeEnd_value_mode(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        move_relative = 1
        move_to_absolute = 0

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.user1.attribute.end_value_mode'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value(self) -> ValueEnum:
        return RootLuRamp_generatorUser1AttributeEnd_value_mode.ValueEnum(self._context.get('root.lu.ramp_generator.user1.attribute.end_value_mode.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.lu.ramp_generator.user1.attribute.end_value_mode.value_raw', new_val.value)

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.lu.ramp_generator.user1.attribute.end_value_mode.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.lu.ramp_generator.user1.attribute.end_value_mode.value_raw', int(new_val))

    @property
    def enum(self) -> list:
        return list(self._context.get('root.lu.ramp_generator.user1.attribute.end_value_mode.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.lu.ramp_generator.user1.attribute.end_value_mode.enum', list(new_val))


class RootLuRamp_generatorUser1AttributeMoving_mode(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        fix_time = 0
        fix_speed = 1

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.user1.attribute.moving_mode'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value(self) -> ValueEnum:
        return RootLuRamp_generatorUser1AttributeMoving_mode.ValueEnum(self._context.get('root.lu.ramp_generator.user1.attribute.moving_mode.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.lu.ramp_generator.user1.attribute.moving_mode.value_raw', new_val.value)

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.lu.ramp_generator.user1.attribute.moving_mode.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.lu.ramp_generator.user1.attribute.moving_mode.value_raw', int(new_val))

    @property
    def enum(self) -> list:
        return list(self._context.get('root.lu.ramp_generator.user1.attribute.moving_mode.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.lu.ramp_generator.user1.attribute.moving_mode.enum', list(new_val))


class RootLuRamp_generatorUser1AttributeStatus(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        stopped_by_external_event = 4
        reached_endposition = 1
        is_moving = 0
        reached_upper_limit = 3
        reached_lower_limit = 2

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.user1.attribute.status'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value(self) -> ValueEnum:
        return RootLuRamp_generatorUser1AttributeStatus.ValueEnum(self._context.get('root.lu.ramp_generator.user1.attribute.status.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.lu.ramp_generator.user1.attribute.status.value_raw', new_val.value)

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.lu.ramp_generator.user1.attribute.status.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.lu.ramp_generator.user1.attribute.status.value_raw', int(new_val))

    @property
    def enum(self) -> list:
        return list(self._context.get('root.lu.ramp_generator.user1.attribute.status.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.lu.ramp_generator.user1.attribute.status.enum', list(new_val))


class RootLuRamp_generatorUser1AttributeLower_limit(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.user1.attribute.lower_limit'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.user1.attribute.lower_limit.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.ramp_generator.user1.attribute.lower_limit.value', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.user1.attribute.lower_limit.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.ramp_generator.user1.attribute.lower_limit.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.ramp_generator.user1.attribute.lower_limit.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.ramp_generator.user1.attribute.lower_limit.unit', str(new_val))

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.user1.attribute.lower_limit.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.ramp_generator.user1.attribute.lower_limit.min', float(new_val))


class RootLuRamp_generatorUser1Attribute(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.user1.attribute'
        self.lower_limit = RootLuRamp_generatorUser1AttributeLower_limit(self._context)
        self.status = RootLuRamp_generatorUser1AttributeStatus(self._context)
        self.moving_mode = RootLuRamp_generatorUser1AttributeMoving_mode(self._context)
        self.end_value_mode = RootLuRamp_generatorUser1AttributeEnd_value_mode(self._context)
        self.end_value_relative = RootLuRamp_generatorUser1AttributeEnd_value_relative(self._context)
        self.end_value_absolute = RootLuRamp_generatorUser1AttributeEnd_value_absolute(self._context)
        self.moving_speed = RootLuRamp_generatorUser1AttributeMoving_speed(self._context)
        self.upper_limit = RootLuRamp_generatorUser1AttributeUpper_limit(self._context)
        self.current_value = RootLuRamp_generatorUser1AttributeCurrent_value(self._context)
        self.moving_time = RootLuRamp_generatorUser1AttributeMoving_time(self._context)


class RootLuRamp_generatorUser1Busy(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.user1.busy'

    @property
    def is_moving(self) -> bool:
        return bool(self._context.call('root.lu.ramp_generator.user1.busy.is_moving'))


class RootLuRamp_generatorUser1(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.user1'
        self.busy = RootLuRamp_generatorUser1Busy(self._context)
        self.attribute = RootLuRamp_generatorUser1Attribute(self._context)
        self.trigger = RootLuRamp_generatorUser1Trigger(self._context)


class RootLuRamp_generatorVirtual2Trigger(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.virtual2.trigger'

    def start(self) -> None:
        return self._context.call('root.lu.ramp_generator.virtual2.trigger.start')

    def stop(self) -> None:
        return self._context.call('root.lu.ramp_generator.virtual2.trigger.stop')

    def abort(self) -> None:
        return self._context.call('root.lu.ramp_generator.virtual2.trigger.abort')

    def prepare(self) -> None:
        return self._context.call('root.lu.ramp_generator.virtual2.trigger.prepare')


class RootLuRamp_generatorVirtual2AttributeMoving_time(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.virtual2.attribute.moving_time'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.virtual2.attribute.moving_time.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.ramp_generator.virtual2.attribute.moving_time.value', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.virtual2.attribute.moving_time.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.ramp_generator.virtual2.attribute.moving_time.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.ramp_generator.virtual2.attribute.moving_time.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.ramp_generator.virtual2.attribute.moving_time.unit', str(new_val))

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.virtual2.attribute.moving_time.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.ramp_generator.virtual2.attribute.moving_time.min', float(new_val))


class RootLuRamp_generatorVirtual2AttributeCurrent_value(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.virtual2.attribute.current_value'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.virtual2.attribute.current_value.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.ramp_generator.virtual2.attribute.current_value.value', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.virtual2.attribute.current_value.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.ramp_generator.virtual2.attribute.current_value.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.ramp_generator.virtual2.attribute.current_value.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.ramp_generator.virtual2.attribute.current_value.unit', str(new_val))

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.virtual2.attribute.current_value.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.ramp_generator.virtual2.attribute.current_value.min', float(new_val))


class RootLuRamp_generatorVirtual2AttributeUpper_limit(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.virtual2.attribute.upper_limit'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.virtual2.attribute.upper_limit.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.ramp_generator.virtual2.attribute.upper_limit.value', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.virtual2.attribute.upper_limit.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.ramp_generator.virtual2.attribute.upper_limit.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.ramp_generator.virtual2.attribute.upper_limit.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.ramp_generator.virtual2.attribute.upper_limit.unit', str(new_val))

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.virtual2.attribute.upper_limit.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.ramp_generator.virtual2.attribute.upper_limit.min', float(new_val))


class RootLuRamp_generatorVirtual2AttributeMoving_speed(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.virtual2.attribute.moving_speed'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.virtual2.attribute.moving_speed.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.ramp_generator.virtual2.attribute.moving_speed.value', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.virtual2.attribute.moving_speed.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.ramp_generator.virtual2.attribute.moving_speed.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.ramp_generator.virtual2.attribute.moving_speed.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.ramp_generator.virtual2.attribute.moving_speed.unit', str(new_val))

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.virtual2.attribute.moving_speed.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.ramp_generator.virtual2.attribute.moving_speed.min', float(new_val))


class RootLuRamp_generatorVirtual2AttributeEnd_value_absolute(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.virtual2.attribute.end_value_absolute'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.virtual2.attribute.end_value_absolute.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.ramp_generator.virtual2.attribute.end_value_absolute.value', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.virtual2.attribute.end_value_absolute.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.ramp_generator.virtual2.attribute.end_value_absolute.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.ramp_generator.virtual2.attribute.end_value_absolute.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.ramp_generator.virtual2.attribute.end_value_absolute.unit', str(new_val))

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.virtual2.attribute.end_value_absolute.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.ramp_generator.virtual2.attribute.end_value_absolute.min', float(new_val))


class RootLuRamp_generatorVirtual2AttributeEnd_value_relative(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.virtual2.attribute.end_value_relative'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.virtual2.attribute.end_value_relative.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.ramp_generator.virtual2.attribute.end_value_relative.value', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.virtual2.attribute.end_value_relative.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.ramp_generator.virtual2.attribute.end_value_relative.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.ramp_generator.virtual2.attribute.end_value_relative.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.ramp_generator.virtual2.attribute.end_value_relative.unit', str(new_val))

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.virtual2.attribute.end_value_relative.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.ramp_generator.virtual2.attribute.end_value_relative.min', float(new_val))


class RootLuRamp_generatorVirtual2AttributeEnd_value_mode(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        move_relative = 1
        move_to_absolute = 0

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.virtual2.attribute.end_value_mode'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value(self) -> ValueEnum:
        return RootLuRamp_generatorVirtual2AttributeEnd_value_mode.ValueEnum(self._context.get('root.lu.ramp_generator.virtual2.attribute.end_value_mode.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.lu.ramp_generator.virtual2.attribute.end_value_mode.value_raw', new_val.value)

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.lu.ramp_generator.virtual2.attribute.end_value_mode.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.lu.ramp_generator.virtual2.attribute.end_value_mode.value_raw', int(new_val))

    @property
    def enum(self) -> list:
        return list(self._context.get('root.lu.ramp_generator.virtual2.attribute.end_value_mode.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.lu.ramp_generator.virtual2.attribute.end_value_mode.enum', list(new_val))


class RootLuRamp_generatorVirtual2AttributeMoving_mode(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        fix_time = 0
        fix_speed = 1

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.virtual2.attribute.moving_mode'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value(self) -> ValueEnum:
        return RootLuRamp_generatorVirtual2AttributeMoving_mode.ValueEnum(self._context.get('root.lu.ramp_generator.virtual2.attribute.moving_mode.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.lu.ramp_generator.virtual2.attribute.moving_mode.value_raw', new_val.value)

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.lu.ramp_generator.virtual2.attribute.moving_mode.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.lu.ramp_generator.virtual2.attribute.moving_mode.value_raw', int(new_val))

    @property
    def enum(self) -> list:
        return list(self._context.get('root.lu.ramp_generator.virtual2.attribute.moving_mode.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.lu.ramp_generator.virtual2.attribute.moving_mode.enum', list(new_val))


class RootLuRamp_generatorVirtual2AttributeStatus(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        stopped_by_external_event = 4
        reached_endposition = 1
        is_moving = 0
        reached_upper_limit = 3
        reached_lower_limit = 2

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.virtual2.attribute.status'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value(self) -> ValueEnum:
        return RootLuRamp_generatorVirtual2AttributeStatus.ValueEnum(self._context.get('root.lu.ramp_generator.virtual2.attribute.status.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.lu.ramp_generator.virtual2.attribute.status.value_raw', new_val.value)

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.lu.ramp_generator.virtual2.attribute.status.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.lu.ramp_generator.virtual2.attribute.status.value_raw', int(new_val))

    @property
    def enum(self) -> list:
        return list(self._context.get('root.lu.ramp_generator.virtual2.attribute.status.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.lu.ramp_generator.virtual2.attribute.status.enum', list(new_val))


class RootLuRamp_generatorVirtual2AttributeLower_limit(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.virtual2.attribute.lower_limit'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.virtual2.attribute.lower_limit.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.ramp_generator.virtual2.attribute.lower_limit.value', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.virtual2.attribute.lower_limit.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.ramp_generator.virtual2.attribute.lower_limit.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.ramp_generator.virtual2.attribute.lower_limit.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.ramp_generator.virtual2.attribute.lower_limit.unit', str(new_val))

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.virtual2.attribute.lower_limit.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.ramp_generator.virtual2.attribute.lower_limit.min', float(new_val))


class RootLuRamp_generatorVirtual2Attribute(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.virtual2.attribute'
        self.lower_limit = RootLuRamp_generatorVirtual2AttributeLower_limit(self._context)
        self.status = RootLuRamp_generatorVirtual2AttributeStatus(self._context)
        self.moving_mode = RootLuRamp_generatorVirtual2AttributeMoving_mode(self._context)
        self.end_value_mode = RootLuRamp_generatorVirtual2AttributeEnd_value_mode(self._context)
        self.end_value_relative = RootLuRamp_generatorVirtual2AttributeEnd_value_relative(self._context)
        self.end_value_absolute = RootLuRamp_generatorVirtual2AttributeEnd_value_absolute(self._context)
        self.moving_speed = RootLuRamp_generatorVirtual2AttributeMoving_speed(self._context)
        self.upper_limit = RootLuRamp_generatorVirtual2AttributeUpper_limit(self._context)
        self.current_value = RootLuRamp_generatorVirtual2AttributeCurrent_value(self._context)
        self.moving_time = RootLuRamp_generatorVirtual2AttributeMoving_time(self._context)


class RootLuRamp_generatorVirtual2Busy(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.virtual2.busy'

    @property
    def is_moving(self) -> bool:
        return bool(self._context.call('root.lu.ramp_generator.virtual2.busy.is_moving'))


class RootLuRamp_generatorVirtual2(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.virtual2'
        self.busy = RootLuRamp_generatorVirtual2Busy(self._context)
        self.attribute = RootLuRamp_generatorVirtual2Attribute(self._context)
        self.trigger = RootLuRamp_generatorVirtual2Trigger(self._context)


class RootLuRamp_generatorPlane_zTrigger(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.plane_z.trigger'

    def start(self) -> None:
        return self._context.call('root.lu.ramp_generator.plane_z.trigger.start')

    def stop(self) -> None:
        return self._context.call('root.lu.ramp_generator.plane_z.trigger.stop')

    def abort(self) -> None:
        return self._context.call('root.lu.ramp_generator.plane_z.trigger.abort')

    def prepare(self) -> None:
        return self._context.call('root.lu.ramp_generator.plane_z.trigger.prepare')


class RootLuRamp_generatorPlane_zAttributeMoving_time(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.plane_z.attribute.moving_time'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.plane_z.attribute.moving_time.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.ramp_generator.plane_z.attribute.moving_time.value', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.plane_z.attribute.moving_time.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.ramp_generator.plane_z.attribute.moving_time.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.ramp_generator.plane_z.attribute.moving_time.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.ramp_generator.plane_z.attribute.moving_time.unit', str(new_val))

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.plane_z.attribute.moving_time.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.ramp_generator.plane_z.attribute.moving_time.min', float(new_val))


class RootLuRamp_generatorPlane_zAttributeCurrent_value(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.plane_z.attribute.current_value'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.plane_z.attribute.current_value.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.ramp_generator.plane_z.attribute.current_value.value', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.plane_z.attribute.current_value.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.ramp_generator.plane_z.attribute.current_value.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.ramp_generator.plane_z.attribute.current_value.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.ramp_generator.plane_z.attribute.current_value.unit', str(new_val))

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.plane_z.attribute.current_value.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.ramp_generator.plane_z.attribute.current_value.min', float(new_val))


class RootLuRamp_generatorPlane_zAttributeUpper_limit(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.plane_z.attribute.upper_limit'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.plane_z.attribute.upper_limit.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.ramp_generator.plane_z.attribute.upper_limit.value', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.plane_z.attribute.upper_limit.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.ramp_generator.plane_z.attribute.upper_limit.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.ramp_generator.plane_z.attribute.upper_limit.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.ramp_generator.plane_z.attribute.upper_limit.unit', str(new_val))

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.plane_z.attribute.upper_limit.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.ramp_generator.plane_z.attribute.upper_limit.min', float(new_val))


class RootLuRamp_generatorPlane_zAttributeMoving_speed(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.plane_z.attribute.moving_speed'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.plane_z.attribute.moving_speed.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.ramp_generator.plane_z.attribute.moving_speed.value', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.plane_z.attribute.moving_speed.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.ramp_generator.plane_z.attribute.moving_speed.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.ramp_generator.plane_z.attribute.moving_speed.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.ramp_generator.plane_z.attribute.moving_speed.unit', str(new_val))

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.plane_z.attribute.moving_speed.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.ramp_generator.plane_z.attribute.moving_speed.min', float(new_val))


class RootLuRamp_generatorPlane_zAttributeEnd_value_absolute(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.plane_z.attribute.end_value_absolute'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.plane_z.attribute.end_value_absolute.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.ramp_generator.plane_z.attribute.end_value_absolute.value', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.plane_z.attribute.end_value_absolute.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.ramp_generator.plane_z.attribute.end_value_absolute.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.ramp_generator.plane_z.attribute.end_value_absolute.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.ramp_generator.plane_z.attribute.end_value_absolute.unit', str(new_val))

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.plane_z.attribute.end_value_absolute.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.ramp_generator.plane_z.attribute.end_value_absolute.min', float(new_val))


class RootLuRamp_generatorPlane_zAttributeEnd_value_relative(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.plane_z.attribute.end_value_relative'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.plane_z.attribute.end_value_relative.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.ramp_generator.plane_z.attribute.end_value_relative.value', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.plane_z.attribute.end_value_relative.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.ramp_generator.plane_z.attribute.end_value_relative.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.ramp_generator.plane_z.attribute.end_value_relative.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.ramp_generator.plane_z.attribute.end_value_relative.unit', str(new_val))

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.plane_z.attribute.end_value_relative.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.ramp_generator.plane_z.attribute.end_value_relative.min', float(new_val))


class RootLuRamp_generatorPlane_zAttributeEnd_value_mode(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        move_relative = 1
        move_to_absolute = 0

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.plane_z.attribute.end_value_mode'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value(self) -> ValueEnum:
        return RootLuRamp_generatorPlane_zAttributeEnd_value_mode.ValueEnum(self._context.get('root.lu.ramp_generator.plane_z.attribute.end_value_mode.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.lu.ramp_generator.plane_z.attribute.end_value_mode.value_raw', new_val.value)

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.lu.ramp_generator.plane_z.attribute.end_value_mode.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.lu.ramp_generator.plane_z.attribute.end_value_mode.value_raw', int(new_val))

    @property
    def enum(self) -> list:
        return list(self._context.get('root.lu.ramp_generator.plane_z.attribute.end_value_mode.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.lu.ramp_generator.plane_z.attribute.end_value_mode.enum', list(new_val))


class RootLuRamp_generatorPlane_zAttributeMoving_mode(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        fix_time = 0
        fix_speed = 1

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.plane_z.attribute.moving_mode'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value(self) -> ValueEnum:
        return RootLuRamp_generatorPlane_zAttributeMoving_mode.ValueEnum(self._context.get('root.lu.ramp_generator.plane_z.attribute.moving_mode.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.lu.ramp_generator.plane_z.attribute.moving_mode.value_raw', new_val.value)

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.lu.ramp_generator.plane_z.attribute.moving_mode.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.lu.ramp_generator.plane_z.attribute.moving_mode.value_raw', int(new_val))

    @property
    def enum(self) -> list:
        return list(self._context.get('root.lu.ramp_generator.plane_z.attribute.moving_mode.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.lu.ramp_generator.plane_z.attribute.moving_mode.enum', list(new_val))


class RootLuRamp_generatorPlane_zAttributeStatus(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        stopped_by_external_event = 4
        reached_endposition = 1
        is_moving = 0
        reached_upper_limit = 3
        reached_lower_limit = 2

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.plane_z.attribute.status'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value(self) -> ValueEnum:
        return RootLuRamp_generatorPlane_zAttributeStatus.ValueEnum(self._context.get('root.lu.ramp_generator.plane_z.attribute.status.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.lu.ramp_generator.plane_z.attribute.status.value_raw', new_val.value)

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.lu.ramp_generator.plane_z.attribute.status.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.lu.ramp_generator.plane_z.attribute.status.value_raw', int(new_val))

    @property
    def enum(self) -> list:
        return list(self._context.get('root.lu.ramp_generator.plane_z.attribute.status.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.lu.ramp_generator.plane_z.attribute.status.enum', list(new_val))


class RootLuRamp_generatorPlane_zAttributeLower_limit(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.plane_z.attribute.lower_limit'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.plane_z.attribute.lower_limit.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.ramp_generator.plane_z.attribute.lower_limit.value', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.plane_z.attribute.lower_limit.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.ramp_generator.plane_z.attribute.lower_limit.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.ramp_generator.plane_z.attribute.lower_limit.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.ramp_generator.plane_z.attribute.lower_limit.unit', str(new_val))

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.plane_z.attribute.lower_limit.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.ramp_generator.plane_z.attribute.lower_limit.min', float(new_val))


class RootLuRamp_generatorPlane_zAttribute(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.plane_z.attribute'
        self.lower_limit = RootLuRamp_generatorPlane_zAttributeLower_limit(self._context)
        self.status = RootLuRamp_generatorPlane_zAttributeStatus(self._context)
        self.moving_mode = RootLuRamp_generatorPlane_zAttributeMoving_mode(self._context)
        self.end_value_mode = RootLuRamp_generatorPlane_zAttributeEnd_value_mode(self._context)
        self.end_value_relative = RootLuRamp_generatorPlane_zAttributeEnd_value_relative(self._context)
        self.end_value_absolute = RootLuRamp_generatorPlane_zAttributeEnd_value_absolute(self._context)
        self.moving_speed = RootLuRamp_generatorPlane_zAttributeMoving_speed(self._context)
        self.upper_limit = RootLuRamp_generatorPlane_zAttributeUpper_limit(self._context)
        self.current_value = RootLuRamp_generatorPlane_zAttributeCurrent_value(self._context)
        self.moving_time = RootLuRamp_generatorPlane_zAttributeMoving_time(self._context)


class RootLuRamp_generatorPlane_zBusy(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.plane_z.busy'

    @property
    def is_moving(self) -> bool:
        return bool(self._context.call('root.lu.ramp_generator.plane_z.busy.is_moving'))


class RootLuRamp_generatorPlane_z(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.plane_z'
        self.busy = RootLuRamp_generatorPlane_zBusy(self._context)
        self.attribute = RootLuRamp_generatorPlane_zAttribute(self._context)
        self.trigger = RootLuRamp_generatorPlane_zTrigger(self._context)


class RootLuRamp_generatorAlternate_zTrigger(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.alternate_z.trigger'

    def start(self) -> None:
        return self._context.call('root.lu.ramp_generator.alternate_z.trigger.start')

    def stop(self) -> None:
        return self._context.call('root.lu.ramp_generator.alternate_z.trigger.stop')

    def abort(self) -> None:
        return self._context.call('root.lu.ramp_generator.alternate_z.trigger.abort')

    def prepare(self) -> None:
        return self._context.call('root.lu.ramp_generator.alternate_z.trigger.prepare')


class RootLuRamp_generatorAlternate_zAttributeMoving_time(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.alternate_z.attribute.moving_time'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.alternate_z.attribute.moving_time.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.ramp_generator.alternate_z.attribute.moving_time.value', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.alternate_z.attribute.moving_time.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.ramp_generator.alternate_z.attribute.moving_time.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.ramp_generator.alternate_z.attribute.moving_time.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.ramp_generator.alternate_z.attribute.moving_time.unit', str(new_val))

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.alternate_z.attribute.moving_time.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.ramp_generator.alternate_z.attribute.moving_time.min', float(new_val))


class RootLuRamp_generatorAlternate_zAttributeCurrent_value(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.alternate_z.attribute.current_value'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.alternate_z.attribute.current_value.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.ramp_generator.alternate_z.attribute.current_value.value', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.alternate_z.attribute.current_value.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.ramp_generator.alternate_z.attribute.current_value.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.ramp_generator.alternate_z.attribute.current_value.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.ramp_generator.alternate_z.attribute.current_value.unit', str(new_val))

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.alternate_z.attribute.current_value.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.ramp_generator.alternate_z.attribute.current_value.min', float(new_val))


class RootLuRamp_generatorAlternate_zAttributeUpper_limit(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.alternate_z.attribute.upper_limit'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.alternate_z.attribute.upper_limit.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.ramp_generator.alternate_z.attribute.upper_limit.value', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.alternate_z.attribute.upper_limit.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.ramp_generator.alternate_z.attribute.upper_limit.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.ramp_generator.alternate_z.attribute.upper_limit.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.ramp_generator.alternate_z.attribute.upper_limit.unit', str(new_val))

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.alternate_z.attribute.upper_limit.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.ramp_generator.alternate_z.attribute.upper_limit.min', float(new_val))


class RootLuRamp_generatorAlternate_zAttributeMoving_speed(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.alternate_z.attribute.moving_speed'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.alternate_z.attribute.moving_speed.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.ramp_generator.alternate_z.attribute.moving_speed.value', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.alternate_z.attribute.moving_speed.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.ramp_generator.alternate_z.attribute.moving_speed.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.ramp_generator.alternate_z.attribute.moving_speed.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.ramp_generator.alternate_z.attribute.moving_speed.unit', str(new_val))

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.alternate_z.attribute.moving_speed.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.ramp_generator.alternate_z.attribute.moving_speed.min', float(new_val))


class RootLuRamp_generatorAlternate_zAttributeEnd_value_absolute(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.alternate_z.attribute.end_value_absolute'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.alternate_z.attribute.end_value_absolute.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.ramp_generator.alternate_z.attribute.end_value_absolute.value', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.alternate_z.attribute.end_value_absolute.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.ramp_generator.alternate_z.attribute.end_value_absolute.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.ramp_generator.alternate_z.attribute.end_value_absolute.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.ramp_generator.alternate_z.attribute.end_value_absolute.unit', str(new_val))

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.alternate_z.attribute.end_value_absolute.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.ramp_generator.alternate_z.attribute.end_value_absolute.min', float(new_val))


class RootLuRamp_generatorAlternate_zAttributeEnd_value_relative(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.alternate_z.attribute.end_value_relative'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.alternate_z.attribute.end_value_relative.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.ramp_generator.alternate_z.attribute.end_value_relative.value', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.alternate_z.attribute.end_value_relative.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.ramp_generator.alternate_z.attribute.end_value_relative.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.ramp_generator.alternate_z.attribute.end_value_relative.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.ramp_generator.alternate_z.attribute.end_value_relative.unit', str(new_val))

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.alternate_z.attribute.end_value_relative.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.ramp_generator.alternate_z.attribute.end_value_relative.min', float(new_val))


class RootLuRamp_generatorAlternate_zAttributeEnd_value_mode(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        move_relative = 1
        move_to_absolute = 0

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.alternate_z.attribute.end_value_mode'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value(self) -> ValueEnum:
        return RootLuRamp_generatorAlternate_zAttributeEnd_value_mode.ValueEnum(self._context.get('root.lu.ramp_generator.alternate_z.attribute.end_value_mode.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.lu.ramp_generator.alternate_z.attribute.end_value_mode.value_raw', new_val.value)

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.lu.ramp_generator.alternate_z.attribute.end_value_mode.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.lu.ramp_generator.alternate_z.attribute.end_value_mode.value_raw', int(new_val))

    @property
    def enum(self) -> list:
        return list(self._context.get('root.lu.ramp_generator.alternate_z.attribute.end_value_mode.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.lu.ramp_generator.alternate_z.attribute.end_value_mode.enum', list(new_val))


class RootLuRamp_generatorAlternate_zAttributeMoving_mode(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        fix_time = 0
        fix_speed = 1

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.alternate_z.attribute.moving_mode'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value(self) -> ValueEnum:
        return RootLuRamp_generatorAlternate_zAttributeMoving_mode.ValueEnum(self._context.get('root.lu.ramp_generator.alternate_z.attribute.moving_mode.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.lu.ramp_generator.alternate_z.attribute.moving_mode.value_raw', new_val.value)

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.lu.ramp_generator.alternate_z.attribute.moving_mode.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.lu.ramp_generator.alternate_z.attribute.moving_mode.value_raw', int(new_val))

    @property
    def enum(self) -> list:
        return list(self._context.get('root.lu.ramp_generator.alternate_z.attribute.moving_mode.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.lu.ramp_generator.alternate_z.attribute.moving_mode.enum', list(new_val))


class RootLuRamp_generatorAlternate_zAttributeStatus(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        stopped_by_external_event = 4
        reached_endposition = 1
        is_moving = 0
        reached_upper_limit = 3
        reached_lower_limit = 2

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.alternate_z.attribute.status'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value(self) -> ValueEnum:
        return RootLuRamp_generatorAlternate_zAttributeStatus.ValueEnum(self._context.get('root.lu.ramp_generator.alternate_z.attribute.status.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.lu.ramp_generator.alternate_z.attribute.status.value_raw', new_val.value)

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.lu.ramp_generator.alternate_z.attribute.status.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.lu.ramp_generator.alternate_z.attribute.status.value_raw', int(new_val))

    @property
    def enum(self) -> list:
        return list(self._context.get('root.lu.ramp_generator.alternate_z.attribute.status.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.lu.ramp_generator.alternate_z.attribute.status.enum', list(new_val))


class RootLuRamp_generatorAlternate_zAttributeLower_limit(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.alternate_z.attribute.lower_limit'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.alternate_z.attribute.lower_limit.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.ramp_generator.alternate_z.attribute.lower_limit.value', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.alternate_z.attribute.lower_limit.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.ramp_generator.alternate_z.attribute.lower_limit.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.ramp_generator.alternate_z.attribute.lower_limit.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.ramp_generator.alternate_z.attribute.lower_limit.unit', str(new_val))

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.alternate_z.attribute.lower_limit.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.ramp_generator.alternate_z.attribute.lower_limit.min', float(new_val))


class RootLuRamp_generatorAlternate_zAttribute(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.alternate_z.attribute'
        self.lower_limit = RootLuRamp_generatorAlternate_zAttributeLower_limit(self._context)
        self.status = RootLuRamp_generatorAlternate_zAttributeStatus(self._context)
        self.moving_mode = RootLuRamp_generatorAlternate_zAttributeMoving_mode(self._context)
        self.end_value_mode = RootLuRamp_generatorAlternate_zAttributeEnd_value_mode(self._context)
        self.end_value_relative = RootLuRamp_generatorAlternate_zAttributeEnd_value_relative(self._context)
        self.end_value_absolute = RootLuRamp_generatorAlternate_zAttributeEnd_value_absolute(self._context)
        self.moving_speed = RootLuRamp_generatorAlternate_zAttributeMoving_speed(self._context)
        self.upper_limit = RootLuRamp_generatorAlternate_zAttributeUpper_limit(self._context)
        self.current_value = RootLuRamp_generatorAlternate_zAttributeCurrent_value(self._context)
        self.moving_time = RootLuRamp_generatorAlternate_zAttributeMoving_time(self._context)


class RootLuRamp_generatorAlternate_zBusy(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.alternate_z.busy'

    @property
    def is_moving(self) -> bool:
        return bool(self._context.call('root.lu.ramp_generator.alternate_z.busy.is_moving'))


class RootLuRamp_generatorAlternate_z(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.alternate_z'
        self.busy = RootLuRamp_generatorAlternate_zBusy(self._context)
        self.attribute = RootLuRamp_generatorAlternate_zAttribute(self._context)
        self.trigger = RootLuRamp_generatorAlternate_zTrigger(self._context)


class RootLuRamp_generatorCtrl_zTrigger(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.ctrl_z.trigger'

    def start(self) -> None:
        return self._context.call('root.lu.ramp_generator.ctrl_z.trigger.start')

    def stop(self) -> None:
        return self._context.call('root.lu.ramp_generator.ctrl_z.trigger.stop')

    def abort(self) -> None:
        return self._context.call('root.lu.ramp_generator.ctrl_z.trigger.abort')

    def prepare(self) -> None:
        return self._context.call('root.lu.ramp_generator.ctrl_z.trigger.prepare')


class RootLuRamp_generatorCtrl_zAttributeMoving_time(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.ctrl_z.attribute.moving_time'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.ctrl_z.attribute.moving_time.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.ramp_generator.ctrl_z.attribute.moving_time.value', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.ctrl_z.attribute.moving_time.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.ramp_generator.ctrl_z.attribute.moving_time.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.ramp_generator.ctrl_z.attribute.moving_time.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.ramp_generator.ctrl_z.attribute.moving_time.unit', str(new_val))

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.ctrl_z.attribute.moving_time.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.ramp_generator.ctrl_z.attribute.moving_time.min', float(new_val))


class RootLuRamp_generatorCtrl_zAttributeCurrent_value(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.ctrl_z.attribute.current_value'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.ctrl_z.attribute.current_value.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.ramp_generator.ctrl_z.attribute.current_value.value', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.ctrl_z.attribute.current_value.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.ramp_generator.ctrl_z.attribute.current_value.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.ramp_generator.ctrl_z.attribute.current_value.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.ramp_generator.ctrl_z.attribute.current_value.unit', str(new_val))

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.ctrl_z.attribute.current_value.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.ramp_generator.ctrl_z.attribute.current_value.min', float(new_val))


class RootLuRamp_generatorCtrl_zAttributeUpper_limit(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.ctrl_z.attribute.upper_limit'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.ctrl_z.attribute.upper_limit.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.ramp_generator.ctrl_z.attribute.upper_limit.value', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.ctrl_z.attribute.upper_limit.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.ramp_generator.ctrl_z.attribute.upper_limit.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.ramp_generator.ctrl_z.attribute.upper_limit.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.ramp_generator.ctrl_z.attribute.upper_limit.unit', str(new_val))

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.ctrl_z.attribute.upper_limit.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.ramp_generator.ctrl_z.attribute.upper_limit.min', float(new_val))


class RootLuRamp_generatorCtrl_zAttributeMoving_speed(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.ctrl_z.attribute.moving_speed'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.ctrl_z.attribute.moving_speed.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.ramp_generator.ctrl_z.attribute.moving_speed.value', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.ctrl_z.attribute.moving_speed.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.ramp_generator.ctrl_z.attribute.moving_speed.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.ramp_generator.ctrl_z.attribute.moving_speed.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.ramp_generator.ctrl_z.attribute.moving_speed.unit', str(new_val))

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.ctrl_z.attribute.moving_speed.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.ramp_generator.ctrl_z.attribute.moving_speed.min', float(new_val))


class RootLuRamp_generatorCtrl_zAttributeEnd_value_absolute(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.ctrl_z.attribute.end_value_absolute'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.ctrl_z.attribute.end_value_absolute.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.ramp_generator.ctrl_z.attribute.end_value_absolute.value', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.ctrl_z.attribute.end_value_absolute.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.ramp_generator.ctrl_z.attribute.end_value_absolute.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.ramp_generator.ctrl_z.attribute.end_value_absolute.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.ramp_generator.ctrl_z.attribute.end_value_absolute.unit', str(new_val))

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.ctrl_z.attribute.end_value_absolute.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.ramp_generator.ctrl_z.attribute.end_value_absolute.min', float(new_val))


class RootLuRamp_generatorCtrl_zAttributeEnd_value_relative(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.ctrl_z.attribute.end_value_relative'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.ctrl_z.attribute.end_value_relative.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.ramp_generator.ctrl_z.attribute.end_value_relative.value', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.ctrl_z.attribute.end_value_relative.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.ramp_generator.ctrl_z.attribute.end_value_relative.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.ramp_generator.ctrl_z.attribute.end_value_relative.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.ramp_generator.ctrl_z.attribute.end_value_relative.unit', str(new_val))

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.ctrl_z.attribute.end_value_relative.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.ramp_generator.ctrl_z.attribute.end_value_relative.min', float(new_val))


class RootLuRamp_generatorCtrl_zAttributeEnd_value_mode(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        move_relative = 1
        move_to_absolute = 0

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.ctrl_z.attribute.end_value_mode'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value(self) -> ValueEnum:
        return RootLuRamp_generatorCtrl_zAttributeEnd_value_mode.ValueEnum(self._context.get('root.lu.ramp_generator.ctrl_z.attribute.end_value_mode.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.lu.ramp_generator.ctrl_z.attribute.end_value_mode.value_raw', new_val.value)

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.lu.ramp_generator.ctrl_z.attribute.end_value_mode.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.lu.ramp_generator.ctrl_z.attribute.end_value_mode.value_raw', int(new_val))

    @property
    def enum(self) -> list:
        return list(self._context.get('root.lu.ramp_generator.ctrl_z.attribute.end_value_mode.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.lu.ramp_generator.ctrl_z.attribute.end_value_mode.enum', list(new_val))


class RootLuRamp_generatorCtrl_zAttributeMoving_mode(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        fix_time = 0
        fix_speed = 1

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.ctrl_z.attribute.moving_mode'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value(self) -> ValueEnum:
        return RootLuRamp_generatorCtrl_zAttributeMoving_mode.ValueEnum(self._context.get('root.lu.ramp_generator.ctrl_z.attribute.moving_mode.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.lu.ramp_generator.ctrl_z.attribute.moving_mode.value_raw', new_val.value)

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.lu.ramp_generator.ctrl_z.attribute.moving_mode.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.lu.ramp_generator.ctrl_z.attribute.moving_mode.value_raw', int(new_val))

    @property
    def enum(self) -> list:
        return list(self._context.get('root.lu.ramp_generator.ctrl_z.attribute.moving_mode.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.lu.ramp_generator.ctrl_z.attribute.moving_mode.enum', list(new_val))


class RootLuRamp_generatorCtrl_zAttributeStatus(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        stopped_by_external_event = 4
        reached_endposition = 1
        is_moving = 0
        reached_upper_limit = 3
        reached_lower_limit = 2

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.ctrl_z.attribute.status'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value(self) -> ValueEnum:
        return RootLuRamp_generatorCtrl_zAttributeStatus.ValueEnum(self._context.get('root.lu.ramp_generator.ctrl_z.attribute.status.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.lu.ramp_generator.ctrl_z.attribute.status.value_raw', new_val.value)

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.lu.ramp_generator.ctrl_z.attribute.status.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.lu.ramp_generator.ctrl_z.attribute.status.value_raw', int(new_val))

    @property
    def enum(self) -> list:
        return list(self._context.get('root.lu.ramp_generator.ctrl_z.attribute.status.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.lu.ramp_generator.ctrl_z.attribute.status.enum', list(new_val))


class RootLuRamp_generatorCtrl_zAttributeLower_limit(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.ctrl_z.attribute.lower_limit'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.ctrl_z.attribute.lower_limit.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.ramp_generator.ctrl_z.attribute.lower_limit.value', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.ctrl_z.attribute.lower_limit.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.ramp_generator.ctrl_z.attribute.lower_limit.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.ramp_generator.ctrl_z.attribute.lower_limit.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.ramp_generator.ctrl_z.attribute.lower_limit.unit', str(new_val))

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.ctrl_z.attribute.lower_limit.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.ramp_generator.ctrl_z.attribute.lower_limit.min', float(new_val))


class RootLuRamp_generatorCtrl_zAttribute(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.ctrl_z.attribute'
        self.lower_limit = RootLuRamp_generatorCtrl_zAttributeLower_limit(self._context)
        self.status = RootLuRamp_generatorCtrl_zAttributeStatus(self._context)
        self.moving_mode = RootLuRamp_generatorCtrl_zAttributeMoving_mode(self._context)
        self.end_value_mode = RootLuRamp_generatorCtrl_zAttributeEnd_value_mode(self._context)
        self.end_value_relative = RootLuRamp_generatorCtrl_zAttributeEnd_value_relative(self._context)
        self.end_value_absolute = RootLuRamp_generatorCtrl_zAttributeEnd_value_absolute(self._context)
        self.moving_speed = RootLuRamp_generatorCtrl_zAttributeMoving_speed(self._context)
        self.upper_limit = RootLuRamp_generatorCtrl_zAttributeUpper_limit(self._context)
        self.current_value = RootLuRamp_generatorCtrl_zAttributeCurrent_value(self._context)
        self.moving_time = RootLuRamp_generatorCtrl_zAttributeMoving_time(self._context)


class RootLuRamp_generatorCtrl_zBusy(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.ctrl_z.busy'

    @property
    def is_moving(self) -> bool:
        return bool(self._context.call('root.lu.ramp_generator.ctrl_z.busy.is_moving'))


class RootLuRamp_generatorCtrl_z(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.ctrl_z'
        self.busy = RootLuRamp_generatorCtrl_zBusy(self._context)
        self.attribute = RootLuRamp_generatorCtrl_zAttribute(self._context)
        self.trigger = RootLuRamp_generatorCtrl_zTrigger(self._context)


class RootLuRamp_generatorPosition_xTrigger(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.position_x.trigger'

    def start(self) -> None:
        return self._context.call('root.lu.ramp_generator.position_x.trigger.start')

    def stop(self) -> None:
        return self._context.call('root.lu.ramp_generator.position_x.trigger.stop')

    def abort(self) -> None:
        return self._context.call('root.lu.ramp_generator.position_x.trigger.abort')

    def prepare(self) -> None:
        return self._context.call('root.lu.ramp_generator.position_x.trigger.prepare')


class RootLuRamp_generatorPosition_xAttributeMoving_time(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.position_x.attribute.moving_time'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.position_x.attribute.moving_time.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.ramp_generator.position_x.attribute.moving_time.value', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.position_x.attribute.moving_time.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.ramp_generator.position_x.attribute.moving_time.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.ramp_generator.position_x.attribute.moving_time.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.ramp_generator.position_x.attribute.moving_time.unit', str(new_val))

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.position_x.attribute.moving_time.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.ramp_generator.position_x.attribute.moving_time.min', float(new_val))


class RootLuRamp_generatorPosition_xAttributeCurrent_value(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.position_x.attribute.current_value'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.position_x.attribute.current_value.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.ramp_generator.position_x.attribute.current_value.value', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.position_x.attribute.current_value.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.ramp_generator.position_x.attribute.current_value.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.ramp_generator.position_x.attribute.current_value.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.ramp_generator.position_x.attribute.current_value.unit', str(new_val))

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.position_x.attribute.current_value.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.ramp_generator.position_x.attribute.current_value.min', float(new_val))


class RootLuRamp_generatorPosition_xAttributeUpper_limit(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.position_x.attribute.upper_limit'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.position_x.attribute.upper_limit.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.ramp_generator.position_x.attribute.upper_limit.value', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.position_x.attribute.upper_limit.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.ramp_generator.position_x.attribute.upper_limit.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.ramp_generator.position_x.attribute.upper_limit.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.ramp_generator.position_x.attribute.upper_limit.unit', str(new_val))

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.position_x.attribute.upper_limit.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.ramp_generator.position_x.attribute.upper_limit.min', float(new_val))


class RootLuRamp_generatorPosition_xAttributeMoving_speed(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.position_x.attribute.moving_speed'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.position_x.attribute.moving_speed.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.ramp_generator.position_x.attribute.moving_speed.value', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.position_x.attribute.moving_speed.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.ramp_generator.position_x.attribute.moving_speed.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.ramp_generator.position_x.attribute.moving_speed.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.ramp_generator.position_x.attribute.moving_speed.unit', str(new_val))

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.position_x.attribute.moving_speed.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.ramp_generator.position_x.attribute.moving_speed.min', float(new_val))


class RootLuRamp_generatorPosition_xAttributeEnd_value_absolute(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.position_x.attribute.end_value_absolute'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.position_x.attribute.end_value_absolute.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.ramp_generator.position_x.attribute.end_value_absolute.value', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.position_x.attribute.end_value_absolute.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.ramp_generator.position_x.attribute.end_value_absolute.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.ramp_generator.position_x.attribute.end_value_absolute.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.ramp_generator.position_x.attribute.end_value_absolute.unit', str(new_val))

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.position_x.attribute.end_value_absolute.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.ramp_generator.position_x.attribute.end_value_absolute.min', float(new_val))


class RootLuRamp_generatorPosition_xAttributeEnd_value_relative(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.position_x.attribute.end_value_relative'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.position_x.attribute.end_value_relative.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.ramp_generator.position_x.attribute.end_value_relative.value', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.position_x.attribute.end_value_relative.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.ramp_generator.position_x.attribute.end_value_relative.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.ramp_generator.position_x.attribute.end_value_relative.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.ramp_generator.position_x.attribute.end_value_relative.unit', str(new_val))

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.position_x.attribute.end_value_relative.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.ramp_generator.position_x.attribute.end_value_relative.min', float(new_val))


class RootLuRamp_generatorPosition_xAttributeEnd_value_mode(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        move_relative = 1
        move_to_absolute = 0

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.position_x.attribute.end_value_mode'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value(self) -> ValueEnum:
        return RootLuRamp_generatorPosition_xAttributeEnd_value_mode.ValueEnum(self._context.get('root.lu.ramp_generator.position_x.attribute.end_value_mode.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.lu.ramp_generator.position_x.attribute.end_value_mode.value_raw', new_val.value)

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.lu.ramp_generator.position_x.attribute.end_value_mode.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.lu.ramp_generator.position_x.attribute.end_value_mode.value_raw', int(new_val))

    @property
    def enum(self) -> list:
        return list(self._context.get('root.lu.ramp_generator.position_x.attribute.end_value_mode.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.lu.ramp_generator.position_x.attribute.end_value_mode.enum', list(new_val))


class RootLuRamp_generatorPosition_xAttributeMoving_mode(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        fix_time = 0
        fix_speed = 1

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.position_x.attribute.moving_mode'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value(self) -> ValueEnum:
        return RootLuRamp_generatorPosition_xAttributeMoving_mode.ValueEnum(self._context.get('root.lu.ramp_generator.position_x.attribute.moving_mode.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.lu.ramp_generator.position_x.attribute.moving_mode.value_raw', new_val.value)

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.lu.ramp_generator.position_x.attribute.moving_mode.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.lu.ramp_generator.position_x.attribute.moving_mode.value_raw', int(new_val))

    @property
    def enum(self) -> list:
        return list(self._context.get('root.lu.ramp_generator.position_x.attribute.moving_mode.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.lu.ramp_generator.position_x.attribute.moving_mode.enum', list(new_val))


class RootLuRamp_generatorPosition_xAttributeStatus(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        stopped_by_external_event = 4
        reached_endposition = 1
        is_moving = 0
        reached_upper_limit = 3
        reached_lower_limit = 2

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.position_x.attribute.status'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value(self) -> ValueEnum:
        return RootLuRamp_generatorPosition_xAttributeStatus.ValueEnum(self._context.get('root.lu.ramp_generator.position_x.attribute.status.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.lu.ramp_generator.position_x.attribute.status.value_raw', new_val.value)

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.lu.ramp_generator.position_x.attribute.status.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.lu.ramp_generator.position_x.attribute.status.value_raw', int(new_val))

    @property
    def enum(self) -> list:
        return list(self._context.get('root.lu.ramp_generator.position_x.attribute.status.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.lu.ramp_generator.position_x.attribute.status.enum', list(new_val))


class RootLuRamp_generatorPosition_xAttributeLower_limit(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.position_x.attribute.lower_limit'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.position_x.attribute.lower_limit.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.ramp_generator.position_x.attribute.lower_limit.value', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.position_x.attribute.lower_limit.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.ramp_generator.position_x.attribute.lower_limit.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.ramp_generator.position_x.attribute.lower_limit.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.ramp_generator.position_x.attribute.lower_limit.unit', str(new_val))

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.position_x.attribute.lower_limit.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.ramp_generator.position_x.attribute.lower_limit.min', float(new_val))


class RootLuRamp_generatorPosition_xAttribute(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.position_x.attribute'
        self.lower_limit = RootLuRamp_generatorPosition_xAttributeLower_limit(self._context)
        self.status = RootLuRamp_generatorPosition_xAttributeStatus(self._context)
        self.moving_mode = RootLuRamp_generatorPosition_xAttributeMoving_mode(self._context)
        self.end_value_mode = RootLuRamp_generatorPosition_xAttributeEnd_value_mode(self._context)
        self.end_value_relative = RootLuRamp_generatorPosition_xAttributeEnd_value_relative(self._context)
        self.end_value_absolute = RootLuRamp_generatorPosition_xAttributeEnd_value_absolute(self._context)
        self.moving_speed = RootLuRamp_generatorPosition_xAttributeMoving_speed(self._context)
        self.upper_limit = RootLuRamp_generatorPosition_xAttributeUpper_limit(self._context)
        self.current_value = RootLuRamp_generatorPosition_xAttributeCurrent_value(self._context)
        self.moving_time = RootLuRamp_generatorPosition_xAttributeMoving_time(self._context)


class RootLuRamp_generatorPosition_xBusy(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.position_x.busy'

    @property
    def is_moving(self) -> bool:
        return bool(self._context.call('root.lu.ramp_generator.position_x.busy.is_moving'))


class RootLuRamp_generatorPosition_x(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.position_x'
        self.busy = RootLuRamp_generatorPosition_xBusy(self._context)
        self.attribute = RootLuRamp_generatorPosition_xAttribute(self._context)
        self.trigger = RootLuRamp_generatorPosition_xTrigger(self._context)


class RootLuRamp_generator(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator'
        self.position_x = RootLuRamp_generatorPosition_x(self._context)
        self.ctrl_z = RootLuRamp_generatorCtrl_z(self._context)
        self.alternate_z = RootLuRamp_generatorAlternate_z(self._context)
        self.plane_z = RootLuRamp_generatorPlane_z(self._context)
        self.virtual2 = RootLuRamp_generatorVirtual2(self._context)
        self.user1 = RootLuRamp_generatorUser1(self._context)
        self.user2 = RootLuRamp_generatorUser2(self._context)
        self.virtual1 = RootLuRamp_generatorVirtual1(self._context)
        self.virtual0 = RootLuRamp_generatorVirtual0(self._context)
        self.approach = RootLuRamp_generatorApproach(self._context)
        self.user4 = RootLuRamp_generatorUser4(self._context)
        self.test = RootLuRamp_generatorTest(self._context)
        self.tip_voltage = RootLuRamp_generatorTip_voltage(self._context)
        self.position_y = RootLuRamp_generatorPosition_y(self._context)
        self.position_w = RootLuRamp_generatorPosition_w(self._context)


class RootLuFrequency_sweep_genInstanceTrigger(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.frequency_sweep_gen.instance.trigger'

    def start_set_reference_amplitude(self) -> None:
        return self._context.call('root.lu.frequency_sweep_gen.instance.trigger.start_set_reference_amplitude')

    def user_abort(self) -> None:
        return self._context.call('root.lu.frequency_sweep_gen.instance.trigger.user_abort')

    def start_set_sensor_amplitude(self) -> None:
        return self._context.call('root.lu.frequency_sweep_gen.instance.trigger.start_set_sensor_amplitude')

    def start_frequency_sweep(self) -> None:
        return self._context.call('root.lu.frequency_sweep_gen.instance.trigger.start_frequency_sweep')


class RootLuFrequency_sweep_genInstanceAttributeEnd_frequency(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.frequency_sweep_gen.instance.attribute.end_frequency'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.frequency_sweep_gen.instance.attribute.end_frequency.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.frequency_sweep_gen.instance.attribute.end_frequency.value', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.frequency_sweep_gen.instance.attribute.end_frequency.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.frequency_sweep_gen.instance.attribute.end_frequency.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.frequency_sweep_gen.instance.attribute.end_frequency.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.frequency_sweep_gen.instance.attribute.end_frequency.unit', str(new_val))

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.frequency_sweep_gen.instance.attribute.end_frequency.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.frequency_sweep_gen.instance.attribute.end_frequency.min', float(new_val))


class RootLuFrequency_sweep_genInstanceAttributeSensor_amplitude(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.frequency_sweep_gen.instance.attribute.sensor_amplitude'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.frequency_sweep_gen.instance.attribute.sensor_amplitude.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.frequency_sweep_gen.instance.attribute.sensor_amplitude.value', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.frequency_sweep_gen.instance.attribute.sensor_amplitude.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.frequency_sweep_gen.instance.attribute.sensor_amplitude.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.frequency_sweep_gen.instance.attribute.sensor_amplitude.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.frequency_sweep_gen.instance.attribute.sensor_amplitude.unit', str(new_val))

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.frequency_sweep_gen.instance.attribute.sensor_amplitude.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.frequency_sweep_gen.instance.attribute.sensor_amplitude.min', float(new_val))


class RootLuFrequency_sweep_genInstanceAttributeSweep_amplitude(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.frequency_sweep_gen.instance.attribute.sweep_amplitude'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.frequency_sweep_gen.instance.attribute.sweep_amplitude.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.frequency_sweep_gen.instance.attribute.sweep_amplitude.value', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.frequency_sweep_gen.instance.attribute.sweep_amplitude.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.frequency_sweep_gen.instance.attribute.sweep_amplitude.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.frequency_sweep_gen.instance.attribute.sweep_amplitude.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.frequency_sweep_gen.instance.attribute.sweep_amplitude.unit', str(new_val))

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.frequency_sweep_gen.instance.attribute.sweep_amplitude.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.frequency_sweep_gen.instance.attribute.sweep_amplitude.min', float(new_val))


class RootLuFrequency_sweep_genInstanceAttributeStep_time(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.frequency_sweep_gen.instance.attribute.step_time'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.frequency_sweep_gen.instance.attribute.step_time.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.frequency_sweep_gen.instance.attribute.step_time.value', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.frequency_sweep_gen.instance.attribute.step_time.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.frequency_sweep_gen.instance.attribute.step_time.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.frequency_sweep_gen.instance.attribute.step_time.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.frequency_sweep_gen.instance.attribute.step_time.unit', str(new_val))

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.frequency_sweep_gen.instance.attribute.step_time.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.frequency_sweep_gen.instance.attribute.step_time.min', float(new_val))


class RootLuFrequency_sweep_genInstanceAttributeReference_amplitude(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.frequency_sweep_gen.instance.attribute.reference_amplitude'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.frequency_sweep_gen.instance.attribute.reference_amplitude.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.frequency_sweep_gen.instance.attribute.reference_amplitude.value', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.frequency_sweep_gen.instance.attribute.reference_amplitude.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.frequency_sweep_gen.instance.attribute.reference_amplitude.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.frequency_sweep_gen.instance.attribute.reference_amplitude.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.frequency_sweep_gen.instance.attribute.reference_amplitude.unit', str(new_val))

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.frequency_sweep_gen.instance.attribute.reference_amplitude.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.frequency_sweep_gen.instance.attribute.reference_amplitude.min', float(new_val))


class RootLuFrequency_sweep_genInstanceAttributeLu_sig_analyzer_inst_no(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        inst1 = 0
        inst2 = 1

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.frequency_sweep_gen.instance.attribute.lu_sig_analyzer_inst_no'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value(self) -> ValueEnum:
        return RootLuFrequency_sweep_genInstanceAttributeLu_sig_analyzer_inst_no.ValueEnum(self._context.get('root.lu.frequency_sweep_gen.instance.attribute.lu_sig_analyzer_inst_no.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.lu.frequency_sweep_gen.instance.attribute.lu_sig_analyzer_inst_no.value_raw', new_val.value)

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.lu.frequency_sweep_gen.instance.attribute.lu_sig_analyzer_inst_no.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.lu.frequency_sweep_gen.instance.attribute.lu_sig_analyzer_inst_no.value_raw', int(new_val))

    @property
    def enum(self) -> list:
        return list(self._context.get('root.lu.frequency_sweep_gen.instance.attribute.lu_sig_analyzer_inst_no.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.lu.frequency_sweep_gen.instance.attribute.lu_sig_analyzer_inst_no.enum', list(new_val))


class RootLuFrequency_sweep_genInstanceAttributeData_group_id(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.frequency_sweep_gen.instance.attribute.data_group_id'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.frequency_sweep_gen.instance.attribute.data_group_id.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.frequency_sweep_gen.instance.attribute.data_group_id.value', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.frequency_sweep_gen.instance.attribute.data_group_id.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.frequency_sweep_gen.instance.attribute.data_group_id.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.frequency_sweep_gen.instance.attribute.data_group_id.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.frequency_sweep_gen.instance.attribute.data_group_id.unit', str(new_val))

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.frequency_sweep_gen.instance.attribute.data_group_id.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.frequency_sweep_gen.instance.attribute.data_group_id.min', float(new_val))


class RootLuFrequency_sweep_genInstanceAttributeSettle_time(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.frequency_sweep_gen.instance.attribute.settle_time'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.frequency_sweep_gen.instance.attribute.settle_time.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.frequency_sweep_gen.instance.attribute.settle_time.value', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.frequency_sweep_gen.instance.attribute.settle_time.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.frequency_sweep_gen.instance.attribute.settle_time.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.frequency_sweep_gen.instance.attribute.settle_time.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.frequency_sweep_gen.instance.attribute.settle_time.unit', str(new_val))

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.frequency_sweep_gen.instance.attribute.settle_time.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.frequency_sweep_gen.instance.attribute.settle_time.min', float(new_val))


class RootLuFrequency_sweep_genInstanceAttributeStart_frequency(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.frequency_sweep_gen.instance.attribute.start_frequency'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.frequency_sweep_gen.instance.attribute.start_frequency.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.frequency_sweep_gen.instance.attribute.start_frequency.value', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.frequency_sweep_gen.instance.attribute.start_frequency.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.frequency_sweep_gen.instance.attribute.start_frequency.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.frequency_sweep_gen.instance.attribute.start_frequency.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.frequency_sweep_gen.instance.attribute.start_frequency.unit', str(new_val))

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.frequency_sweep_gen.instance.attribute.start_frequency.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.frequency_sweep_gen.instance.attribute.start_frequency.min', float(new_val))


class RootLuFrequency_sweep_genInstanceAttributeData_points(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.frequency_sweep_gen.instance.attribute.data_points'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.frequency_sweep_gen.instance.attribute.data_points.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.frequency_sweep_gen.instance.attribute.data_points.value', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.frequency_sweep_gen.instance.attribute.data_points.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.frequency_sweep_gen.instance.attribute.data_points.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.frequency_sweep_gen.instance.attribute.data_points.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.frequency_sweep_gen.instance.attribute.data_points.unit', str(new_val))

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.frequency_sweep_gen.instance.attribute.data_points.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.frequency_sweep_gen.instance.attribute.data_points.min', float(new_val))


class RootLuFrequency_sweep_genInstanceAttribute(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.frequency_sweep_gen.instance.attribute'
        self.data_points = RootLuFrequency_sweep_genInstanceAttributeData_points(self._context)
        self.start_frequency = RootLuFrequency_sweep_genInstanceAttributeStart_frequency(self._context)
        self.settle_time = RootLuFrequency_sweep_genInstanceAttributeSettle_time(self._context)
        self.data_group_id = RootLuFrequency_sweep_genInstanceAttributeData_group_id(self._context)
        self.lu_sig_analyzer_inst_no = RootLuFrequency_sweep_genInstanceAttributeLu_sig_analyzer_inst_no(self._context)
        self.reference_amplitude = RootLuFrequency_sweep_genInstanceAttributeReference_amplitude(self._context)
        self.step_time = RootLuFrequency_sweep_genInstanceAttributeStep_time(self._context)
        self.sweep_amplitude = RootLuFrequency_sweep_genInstanceAttributeSweep_amplitude(self._context)
        self.sensor_amplitude = RootLuFrequency_sweep_genInstanceAttributeSensor_amplitude(self._context)
        self.end_frequency = RootLuFrequency_sweep_genInstanceAttributeEnd_frequency(self._context)


class RootLuFrequency_sweep_genInstanceBusy(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.frequency_sweep_gen.instance.busy'


class RootLuFrequency_sweep_genInstance(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.frequency_sweep_gen.instance'
        self.busy = RootLuFrequency_sweep_genInstanceBusy(self._context)
        self.attribute = RootLuFrequency_sweep_genInstanceAttribute(self._context)
        self.trigger = RootLuFrequency_sweep_genInstanceTrigger(self._context)


class RootLuFrequency_sweep_gen(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.frequency_sweep_gen'
        self.instance = RootLuFrequency_sweep_genInstance(self._context)


class RootLuMainboard_relaysInstanceTrigger(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.mainboard_relays.instance.trigger'


class RootLuMainboard_relaysInstanceAttributeSet_state_mask(wrap.CmdTreeProp):

    class ValueMask(enum.IntEnum):
        hires_in_user3 = 64
        hires_out_user4 = 8
        hires_in_user2 = 32
        none = 0
        all = 4095
        hires_in_user1 = 16
        hires_out_user3 = 4
        hi_res_in6 = 1024
        hires_out_user1 = 1
        fast_out_user = 256
        dummy0 = 2048
        hires_out_user2 = 2
        fast_in_user = 512
        hires_in_user4 = 128

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.mainboard_relays.instance.attribute.set_state_mask'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value(self) -> int:
        return int(self._context.get('root.lu.mainboard_relays.instance.attribute.set_state_mask.value_raw'))

    @value.setter
    def value(self, new_val:int):
        self._context.set('root.lu.mainboard_relays.instance.attribute.set_state_mask.value_raw', int(new_val))

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.lu.mainboard_relays.instance.attribute.set_state_mask.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.lu.mainboard_relays.instance.attribute.set_state_mask.value_raw', int(new_val))

    @property
    def enum(self) -> list:
        return list(self._context.get('root.lu.mainboard_relays.instance.attribute.set_state_mask.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.lu.mainboard_relays.instance.attribute.set_state_mask.enum', list(new_val))


class RootLuMainboard_relaysInstanceAttribute(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.mainboard_relays.instance.attribute'
        self.set_state_mask = RootLuMainboard_relaysInstanceAttributeSet_state_mask(self._context)


class RootLuMainboard_relaysInstanceBusy(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.mainboard_relays.instance.busy'


class RootLuMainboard_relaysInstance(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.mainboard_relays.instance'
        self.busy = RootLuMainboard_relaysInstanceBusy(self._context)
        self.attribute = RootLuMainboard_relaysInstanceAttribute(self._context)
        self.trigger = RootLuMainboard_relaysInstanceTrigger(self._context)


class RootLuMainboard_relays(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.mainboard_relays'
        self.instance = RootLuMainboard_relaysInstance(self._context)


class RootLuOscilloscopeInstanceTrigger(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.oscilloscope.instance.trigger'

    def start(self) -> None:
        return self._context.call('root.lu.oscilloscope.instance.trigger.start')

    def stop(self) -> None:
        return self._context.call('root.lu.oscilloscope.instance.trigger.stop')


class RootLuOscilloscopeInstanceAttributeCapture_duration(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.oscilloscope.instance.attribute.capture_duration'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.oscilloscope.instance.attribute.capture_duration.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.oscilloscope.instance.attribute.capture_duration.value', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.oscilloscope.instance.attribute.capture_duration.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.oscilloscope.instance.attribute.capture_duration.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.oscilloscope.instance.attribute.capture_duration.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.oscilloscope.instance.attribute.capture_duration.unit', str(new_val))

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.oscilloscope.instance.attribute.capture_duration.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.oscilloscope.instance.attribute.capture_duration.min', float(new_val))


class RootLuOscilloscopeInstanceAttributeCapture_period(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.oscilloscope.instance.attribute.capture_period'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.oscilloscope.instance.attribute.capture_period.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.oscilloscope.instance.attribute.capture_period.value', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.oscilloscope.instance.attribute.capture_period.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.oscilloscope.instance.attribute.capture_period.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.oscilloscope.instance.attribute.capture_period.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.oscilloscope.instance.attribute.capture_period.unit', str(new_val))

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.oscilloscope.instance.attribute.capture_period.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.oscilloscope.instance.attribute.capture_period.min', float(new_val))


class RootLuOscilloscopeInstanceAttribute(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.oscilloscope.instance.attribute'
        self.capture_period = RootLuOscilloscopeInstanceAttributeCapture_period(self._context)
        self.capture_duration = RootLuOscilloscopeInstanceAttributeCapture_duration(self._context)


class RootLuOscilloscopeInstanceBusy(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.oscilloscope.instance.busy'

    @property
    def is_busy(self) -> bool:
        return bool(self._context.call('root.lu.oscilloscope.instance.busy.is_busy'))


class RootLuOscilloscopeInstance(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.oscilloscope.instance'
        self.busy = RootLuOscilloscopeInstanceBusy(self._context)
        self.attribute = RootLuOscilloscopeInstanceAttribute(self._context)
        self.trigger = RootLuOscilloscopeInstanceTrigger(self._context)


class RootLuOscilloscope(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.oscilloscope'
        self.instance = RootLuOscilloscopeInstance(self._context)


class RootLuComparatorComparator1Trigger(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.comparator.comparator1.trigger'


class RootLuComparatorComparator1AttributeFilter_enable(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        enabled = 1
        disabled = 0

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.comparator.comparator1.attribute.filter_enable'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value(self) -> ValueEnum:
        return RootLuComparatorComparator1AttributeFilter_enable.ValueEnum(self._context.get('root.lu.comparator.comparator1.attribute.filter_enable.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.lu.comparator.comparator1.attribute.filter_enable.value_raw', new_val.value)

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.lu.comparator.comparator1.attribute.filter_enable.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.lu.comparator.comparator1.attribute.filter_enable.value_raw', int(new_val))

    @property
    def enum(self) -> list:
        return list(self._context.get('root.lu.comparator.comparator1.attribute.filter_enable.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.lu.comparator.comparator1.attribute.filter_enable.enum', list(new_val))


class RootLuComparatorComparator1AttributeSource(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        in_lateral = 1
        ctrl_z_nominal = 15
        ctrl_w_out = 43
        ctrl_z_out = 14
        memory_gen_drive_z = 56
        ort_adhesion_value = 49
        ramp_gen_plane_z = 36
        fast_in2 = 62
        analyzer1_y = 19
        ramp_gen_position_x = 34
        fast_in_deflection = 61
        ctrl_user2_out = 45
        ort_excitation = 66
        analyzer2_x = 24
        ctrl_z_pid_command = 39
        ctrl_x_out = 41
        in_detector_sum = 10
        gen_test_dynamic = 31
        ort_adhesion_position = 50
        ort_baseline = 46
        static = 30
        ctrl_z_sum = 40
        memory_gen_position_y = 53
        analyzer1_reference = 64
        ramp_gen_approach = 33
        analyzer2_y = 25
        in_user2 = 6
        ort_baseline_corrected = 47
        ctrl_z_in = 12
        analyzer1_ctrl_amplitude = 20
        ramp_gen_position_y = 35
        memory_gen_position_x = 51
        analyzer1_ctrl_delta_f = 21
        memory_gen_drive_y = 54
        analyzer1_amplitude = 16
        memory_gen_out8 = 58
        memory_gen_out7 = 57
        memory_gen_drive_x = 52
        ramp_gen_ctrl_z = 37
        ctrl_z_error = 13
        in_position_x = 2
        fast_in_user = 63
        in_position_y = 3
        analyzer1_phase = 17
        analyzer2_ctrl_amplitude = 26
        analyzer2_ctrl_delta_f = 27
        in_user1 = 5
        in_deflection = 0
        ort_free_wave = 67
        ctrl_user1_out = 44
        ramp_gen_tip_voltage = 28
        analyzer2_phase = 23
        ramp_gen_test = 32
        analyzer2_reference = 65
        ramp_gen_alternate_z = 29
        ramp_gen_position_w = 60
        ramp_gen_max_z = 38
        ramp_gen_user4 = 59
        in_user4 = 8
        analyzer2_amplitude = 22
        ctrl_y_out = 42
        memory_gen_position_z = 55
        ort_amplitude_reduction = 48
        in_user3 = 7
        in_tip_current = 9
        in_position_z = 4
        in6 = 11
        analyzer1_x = 18

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.comparator.comparator1.attribute.source'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value(self) -> ValueEnum:
        return RootLuComparatorComparator1AttributeSource.ValueEnum(self._context.get('root.lu.comparator.comparator1.attribute.source.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.lu.comparator.comparator1.attribute.source.value_raw', new_val.value)

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.lu.comparator.comparator1.attribute.source.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.lu.comparator.comparator1.attribute.source.value_raw', int(new_val))

    @property
    def enum(self) -> list:
        return list(self._context.get('root.lu.comparator.comparator1.attribute.source.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.lu.comparator.comparator1.attribute.source.enum', list(new_val))


class RootLuComparatorComparator1AttributeLevel(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.comparator.comparator1.attribute.level'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.comparator.comparator1.attribute.level.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.comparator.comparator1.attribute.level.value', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.comparator.comparator1.attribute.level.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.comparator.comparator1.attribute.level.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.comparator.comparator1.attribute.level.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.comparator.comparator1.attribute.level.unit', str(new_val))

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.comparator.comparator1.attribute.level.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.comparator.comparator1.attribute.level.min', float(new_val))


class RootLuComparatorComparator1AttributeFilter_coeff_vec(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.comparator.comparator1.attribute.filter_coeff_vec'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def vector(self) -> list:
        return list(self._context.get('root.lu.comparator.comparator1.attribute.filter_coeff_vec.vector'))

    @vector.setter
    def vector(self, new_val:list):
        self._context.set('root.lu.comparator.comparator1.attribute.filter_coeff_vec.vector', list(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.comparator.comparator1.attribute.filter_coeff_vec.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.comparator.comparator1.attribute.filter_coeff_vec.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.comparator.comparator1.attribute.filter_coeff_vec.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.comparator.comparator1.attribute.filter_coeff_vec.unit', str(new_val))

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.comparator.comparator1.attribute.filter_coeff_vec.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.comparator.comparator1.attribute.filter_coeff_vec.min', float(new_val))


class RootLuComparatorComparator1AttributePolarity(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        equal_or_higher_than = 1
        equal_or_lower_than = 0

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.comparator.comparator1.attribute.polarity'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value(self) -> ValueEnum:
        return RootLuComparatorComparator1AttributePolarity.ValueEnum(self._context.get('root.lu.comparator.comparator1.attribute.polarity.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.lu.comparator.comparator1.attribute.polarity.value_raw', new_val.value)

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.lu.comparator.comparator1.attribute.polarity.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.lu.comparator.comparator1.attribute.polarity.value_raw', int(new_val))

    @property
    def enum(self) -> list:
        return list(self._context.get('root.lu.comparator.comparator1.attribute.polarity.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.lu.comparator.comparator1.attribute.polarity.enum', list(new_val))


class RootLuComparatorComparator1Attribute(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.comparator.comparator1.attribute'
        self.polarity = RootLuComparatorComparator1AttributePolarity(self._context)
        self.filter_coeff_vec = RootLuComparatorComparator1AttributeFilter_coeff_vec(self._context)
        self.level = RootLuComparatorComparator1AttributeLevel(self._context)
        self.source = RootLuComparatorComparator1AttributeSource(self._context)
        self.filter_enable = RootLuComparatorComparator1AttributeFilter_enable(self._context)


class RootLuComparatorComparator1Busy(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.comparator.comparator1.busy'


class RootLuComparatorComparator1(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.comparator.comparator1'
        self.busy = RootLuComparatorComparator1Busy(self._context)
        self.attribute = RootLuComparatorComparator1Attribute(self._context)
        self.trigger = RootLuComparatorComparator1Trigger(self._context)


class RootLuComparatorComparator3Trigger(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.comparator.comparator3.trigger'


class RootLuComparatorComparator3AttributeFilter_enable(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        enabled = 1
        disabled = 0

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.comparator.comparator3.attribute.filter_enable'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value(self) -> ValueEnum:
        return RootLuComparatorComparator3AttributeFilter_enable.ValueEnum(self._context.get('root.lu.comparator.comparator3.attribute.filter_enable.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.lu.comparator.comparator3.attribute.filter_enable.value_raw', new_val.value)

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.lu.comparator.comparator3.attribute.filter_enable.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.lu.comparator.comparator3.attribute.filter_enable.value_raw', int(new_val))

    @property
    def enum(self) -> list:
        return list(self._context.get('root.lu.comparator.comparator3.attribute.filter_enable.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.lu.comparator.comparator3.attribute.filter_enable.enum', list(new_val))


class RootLuComparatorComparator3AttributeSource(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        in_lateral = 1
        ctrl_z_nominal = 15
        ctrl_w_out = 43
        ctrl_z_out = 14
        memory_gen_drive_z = 56
        ort_adhesion_value = 49
        ramp_gen_plane_z = 36
        fast_in2 = 62
        analyzer1_y = 19
        ramp_gen_position_x = 34
        fast_in_deflection = 61
        ctrl_user2_out = 45
        ort_excitation = 66
        analyzer2_x = 24
        ctrl_z_pid_command = 39
        ctrl_x_out = 41
        in_detector_sum = 10
        gen_test_dynamic = 31
        ort_adhesion_position = 50
        ort_baseline = 46
        static = 30
        ctrl_z_sum = 40
        memory_gen_position_y = 53
        analyzer1_reference = 64
        ramp_gen_approach = 33
        analyzer2_y = 25
        in_user2 = 6
        ort_baseline_corrected = 47
        ctrl_z_in = 12
        analyzer1_ctrl_amplitude = 20
        ramp_gen_position_y = 35
        memory_gen_position_x = 51
        analyzer1_ctrl_delta_f = 21
        memory_gen_drive_y = 54
        analyzer1_amplitude = 16
        memory_gen_out8 = 58
        memory_gen_out7 = 57
        memory_gen_drive_x = 52
        ramp_gen_ctrl_z = 37
        ctrl_z_error = 13
        in_position_x = 2
        fast_in_user = 63
        in_position_y = 3
        analyzer1_phase = 17
        analyzer2_ctrl_amplitude = 26
        analyzer2_ctrl_delta_f = 27
        in_user1 = 5
        in_deflection = 0
        ort_free_wave = 67
        ctrl_user1_out = 44
        ramp_gen_tip_voltage = 28
        analyzer2_phase = 23
        ramp_gen_test = 32
        analyzer2_reference = 65
        ramp_gen_alternate_z = 29
        ramp_gen_position_w = 60
        ramp_gen_max_z = 38
        ramp_gen_user4 = 59
        in_user4 = 8
        analyzer2_amplitude = 22
        ctrl_y_out = 42
        memory_gen_position_z = 55
        ort_amplitude_reduction = 48
        in_user3 = 7
        in_tip_current = 9
        in_position_z = 4
        in6 = 11
        analyzer1_x = 18

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.comparator.comparator3.attribute.source'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value(self) -> ValueEnum:
        return RootLuComparatorComparator3AttributeSource.ValueEnum(self._context.get('root.lu.comparator.comparator3.attribute.source.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.lu.comparator.comparator3.attribute.source.value_raw', new_val.value)

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.lu.comparator.comparator3.attribute.source.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.lu.comparator.comparator3.attribute.source.value_raw', int(new_val))

    @property
    def enum(self) -> list:
        return list(self._context.get('root.lu.comparator.comparator3.attribute.source.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.lu.comparator.comparator3.attribute.source.enum', list(new_val))


class RootLuComparatorComparator3AttributeLevel(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.comparator.comparator3.attribute.level'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.comparator.comparator3.attribute.level.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.comparator.comparator3.attribute.level.value', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.comparator.comparator3.attribute.level.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.comparator.comparator3.attribute.level.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.comparator.comparator3.attribute.level.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.comparator.comparator3.attribute.level.unit', str(new_val))

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.comparator.comparator3.attribute.level.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.comparator.comparator3.attribute.level.min', float(new_val))


class RootLuComparatorComparator3AttributeFilter_coeff_vec(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.comparator.comparator3.attribute.filter_coeff_vec'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def vector(self) -> list:
        return list(self._context.get('root.lu.comparator.comparator3.attribute.filter_coeff_vec.vector'))

    @vector.setter
    def vector(self, new_val:list):
        self._context.set('root.lu.comparator.comparator3.attribute.filter_coeff_vec.vector', list(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.comparator.comparator3.attribute.filter_coeff_vec.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.comparator.comparator3.attribute.filter_coeff_vec.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.comparator.comparator3.attribute.filter_coeff_vec.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.comparator.comparator3.attribute.filter_coeff_vec.unit', str(new_val))

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.comparator.comparator3.attribute.filter_coeff_vec.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.comparator.comparator3.attribute.filter_coeff_vec.min', float(new_val))


class RootLuComparatorComparator3AttributePolarity(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        equal_or_higher_than = 1
        equal_or_lower_than = 0

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.comparator.comparator3.attribute.polarity'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value(self) -> ValueEnum:
        return RootLuComparatorComparator3AttributePolarity.ValueEnum(self._context.get('root.lu.comparator.comparator3.attribute.polarity.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.lu.comparator.comparator3.attribute.polarity.value_raw', new_val.value)

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.lu.comparator.comparator3.attribute.polarity.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.lu.comparator.comparator3.attribute.polarity.value_raw', int(new_val))

    @property
    def enum(self) -> list:
        return list(self._context.get('root.lu.comparator.comparator3.attribute.polarity.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.lu.comparator.comparator3.attribute.polarity.enum', list(new_val))


class RootLuComparatorComparator3Attribute(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.comparator.comparator3.attribute'
        self.polarity = RootLuComparatorComparator3AttributePolarity(self._context)
        self.filter_coeff_vec = RootLuComparatorComparator3AttributeFilter_coeff_vec(self._context)
        self.level = RootLuComparatorComparator3AttributeLevel(self._context)
        self.source = RootLuComparatorComparator3AttributeSource(self._context)
        self.filter_enable = RootLuComparatorComparator3AttributeFilter_enable(self._context)


class RootLuComparatorComparator3Busy(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.comparator.comparator3.busy'


class RootLuComparatorComparator3(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.comparator.comparator3'
        self.busy = RootLuComparatorComparator3Busy(self._context)
        self.attribute = RootLuComparatorComparator3Attribute(self._context)
        self.trigger = RootLuComparatorComparator3Trigger(self._context)


class RootLuComparatorComparator2Trigger(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.comparator.comparator2.trigger'


class RootLuComparatorComparator2AttributeFilter_enable(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        enabled = 1
        disabled = 0

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.comparator.comparator2.attribute.filter_enable'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value(self) -> ValueEnum:
        return RootLuComparatorComparator2AttributeFilter_enable.ValueEnum(self._context.get('root.lu.comparator.comparator2.attribute.filter_enable.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.lu.comparator.comparator2.attribute.filter_enable.value_raw', new_val.value)

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.lu.comparator.comparator2.attribute.filter_enable.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.lu.comparator.comparator2.attribute.filter_enable.value_raw', int(new_val))

    @property
    def enum(self) -> list:
        return list(self._context.get('root.lu.comparator.comparator2.attribute.filter_enable.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.lu.comparator.comparator2.attribute.filter_enable.enum', list(new_val))


class RootLuComparatorComparator2AttributeSource(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        in_lateral = 1
        ctrl_z_nominal = 15
        ctrl_w_out = 43
        ctrl_z_out = 14
        memory_gen_drive_z = 56
        ort_adhesion_value = 49
        ramp_gen_plane_z = 36
        fast_in2 = 62
        analyzer1_y = 19
        ramp_gen_position_x = 34
        fast_in_deflection = 61
        ctrl_user2_out = 45
        ort_excitation = 66
        analyzer2_x = 24
        ctrl_z_pid_command = 39
        ctrl_x_out = 41
        in_detector_sum = 10
        gen_test_dynamic = 31
        ort_adhesion_position = 50
        ort_baseline = 46
        static = 30
        ctrl_z_sum = 40
        memory_gen_position_y = 53
        analyzer1_reference = 64
        ramp_gen_approach = 33
        analyzer2_y = 25
        in_user2 = 6
        ort_baseline_corrected = 47
        ctrl_z_in = 12
        analyzer1_ctrl_amplitude = 20
        ramp_gen_position_y = 35
        memory_gen_position_x = 51
        analyzer1_ctrl_delta_f = 21
        memory_gen_drive_y = 54
        analyzer1_amplitude = 16
        memory_gen_out8 = 58
        memory_gen_out7 = 57
        memory_gen_drive_x = 52
        ramp_gen_ctrl_z = 37
        ctrl_z_error = 13
        in_position_x = 2
        fast_in_user = 63
        in_position_y = 3
        analyzer1_phase = 17
        analyzer2_ctrl_amplitude = 26
        analyzer2_ctrl_delta_f = 27
        in_user1 = 5
        in_deflection = 0
        ort_free_wave = 67
        ctrl_user1_out = 44
        ramp_gen_tip_voltage = 28
        analyzer2_phase = 23
        ramp_gen_test = 32
        analyzer2_reference = 65
        ramp_gen_alternate_z = 29
        ramp_gen_position_w = 60
        ramp_gen_max_z = 38
        ramp_gen_user4 = 59
        in_user4 = 8
        analyzer2_amplitude = 22
        ctrl_y_out = 42
        memory_gen_position_z = 55
        ort_amplitude_reduction = 48
        in_user3 = 7
        in_tip_current = 9
        in_position_z = 4
        in6 = 11
        analyzer1_x = 18

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.comparator.comparator2.attribute.source'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value(self) -> ValueEnum:
        return RootLuComparatorComparator2AttributeSource.ValueEnum(self._context.get('root.lu.comparator.comparator2.attribute.source.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.lu.comparator.comparator2.attribute.source.value_raw', new_val.value)

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.lu.comparator.comparator2.attribute.source.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.lu.comparator.comparator2.attribute.source.value_raw', int(new_val))

    @property
    def enum(self) -> list:
        return list(self._context.get('root.lu.comparator.comparator2.attribute.source.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.lu.comparator.comparator2.attribute.source.enum', list(new_val))


class RootLuComparatorComparator2AttributeLevel(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.comparator.comparator2.attribute.level'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.comparator.comparator2.attribute.level.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.comparator.comparator2.attribute.level.value', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.comparator.comparator2.attribute.level.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.comparator.comparator2.attribute.level.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.comparator.comparator2.attribute.level.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.comparator.comparator2.attribute.level.unit', str(new_val))

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.comparator.comparator2.attribute.level.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.comparator.comparator2.attribute.level.min', float(new_val))


class RootLuComparatorComparator2AttributeFilter_coeff_vec(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.comparator.comparator2.attribute.filter_coeff_vec'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def vector(self) -> list:
        return list(self._context.get('root.lu.comparator.comparator2.attribute.filter_coeff_vec.vector'))

    @vector.setter
    def vector(self, new_val:list):
        self._context.set('root.lu.comparator.comparator2.attribute.filter_coeff_vec.vector', list(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.comparator.comparator2.attribute.filter_coeff_vec.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.comparator.comparator2.attribute.filter_coeff_vec.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.comparator.comparator2.attribute.filter_coeff_vec.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.comparator.comparator2.attribute.filter_coeff_vec.unit', str(new_val))

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.comparator.comparator2.attribute.filter_coeff_vec.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.comparator.comparator2.attribute.filter_coeff_vec.min', float(new_val))


class RootLuComparatorComparator2AttributePolarity(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        equal_or_higher_than = 1
        equal_or_lower_than = 0

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.comparator.comparator2.attribute.polarity'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value(self) -> ValueEnum:
        return RootLuComparatorComparator2AttributePolarity.ValueEnum(self._context.get('root.lu.comparator.comparator2.attribute.polarity.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.lu.comparator.comparator2.attribute.polarity.value_raw', new_val.value)

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.lu.comparator.comparator2.attribute.polarity.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.lu.comparator.comparator2.attribute.polarity.value_raw', int(new_val))

    @property
    def enum(self) -> list:
        return list(self._context.get('root.lu.comparator.comparator2.attribute.polarity.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.lu.comparator.comparator2.attribute.polarity.enum', list(new_val))


class RootLuComparatorComparator2Attribute(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.comparator.comparator2.attribute'
        self.polarity = RootLuComparatorComparator2AttributePolarity(self._context)
        self.filter_coeff_vec = RootLuComparatorComparator2AttributeFilter_coeff_vec(self._context)
        self.level = RootLuComparatorComparator2AttributeLevel(self._context)
        self.source = RootLuComparatorComparator2AttributeSource(self._context)
        self.filter_enable = RootLuComparatorComparator2AttributeFilter_enable(self._context)


class RootLuComparatorComparator2Busy(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.comparator.comparator2.busy'


class RootLuComparatorComparator2(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.comparator.comparator2'
        self.busy = RootLuComparatorComparator2Busy(self._context)
        self.attribute = RootLuComparatorComparator2Attribute(self._context)
        self.trigger = RootLuComparatorComparator2Trigger(self._context)


class RootLuComparator(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.comparator'
        self.comparator2 = RootLuComparatorComparator2(self._context)
        self.comparator3 = RootLuComparatorComparator3(self._context)
        self.comparator1 = RootLuComparatorComparator1(self._context)


class RootLuRescanInstanceTrigger(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.rescan.instance.trigger'


class RootLuRescanInstanceAttributeLine_repetition_max_count(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.rescan.instance.attribute.line_repetition_max_count'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.rescan.instance.attribute.line_repetition_max_count.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.rescan.instance.attribute.line_repetition_max_count.value', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.rescan.instance.attribute.line_repetition_max_count.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.rescan.instance.attribute.line_repetition_max_count.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.rescan.instance.attribute.line_repetition_max_count.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.rescan.instance.attribute.line_repetition_max_count.unit', str(new_val))

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.rescan.instance.attribute.line_repetition_max_count.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.rescan.instance.attribute.line_repetition_max_count.min', float(new_val))


class RootLuRescanInstanceAttributeLine_repetition_count(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.rescan.instance.attribute.line_repetition_count'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.rescan.instance.attribute.line_repetition_count.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.rescan.instance.attribute.line_repetition_count.value', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.rescan.instance.attribute.line_repetition_count.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.rescan.instance.attribute.line_repetition_count.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.rescan.instance.attribute.line_repetition_count.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.rescan.instance.attribute.line_repetition_count.unit', str(new_val))

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.rescan.instance.attribute.line_repetition_count.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.rescan.instance.attribute.line_repetition_count.min', float(new_val))


class RootLuRescanInstanceAttributeLine_repetition_max(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.rescan.instance.attribute.line_repetition_max'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.rescan.instance.attribute.line_repetition_max.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.rescan.instance.attribute.line_repetition_max.value', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.rescan.instance.attribute.line_repetition_max.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.rescan.instance.attribute.line_repetition_max.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.rescan.instance.attribute.line_repetition_max.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.rescan.instance.attribute.line_repetition_max.unit', str(new_val))

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.rescan.instance.attribute.line_repetition_max.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.rescan.instance.attribute.line_repetition_max.min', float(new_val))


class RootLuRescanInstanceAttributeEnable(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.rescan.instance.attribute.enable'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.rescan.instance.attribute.enable.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.rescan.instance.attribute.enable.value', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.rescan.instance.attribute.enable.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.rescan.instance.attribute.enable.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.rescan.instance.attribute.enable.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.rescan.instance.attribute.enable.unit', str(new_val))

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.rescan.instance.attribute.enable.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.rescan.instance.attribute.enable.min', float(new_val))


class RootLuRescanInstanceAttribute(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.rescan.instance.attribute'
        self.enable = RootLuRescanInstanceAttributeEnable(self._context)
        self.line_repetition_max = RootLuRescanInstanceAttributeLine_repetition_max(self._context)
        self.line_repetition_count = RootLuRescanInstanceAttributeLine_repetition_count(self._context)
        self.line_repetition_max_count = RootLuRescanInstanceAttributeLine_repetition_max_count(self._context)


class RootLuRescanInstanceBusy(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.rescan.instance.busy'


class RootLuRescanInstance(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.rescan.instance'
        self.busy = RootLuRescanInstanceBusy(self._context)
        self.attribute = RootLuRescanInstanceAttribute(self._context)
        self.trigger = RootLuRescanInstanceTrigger(self._context)


class RootLuRescan(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.rescan'
        self.instance = RootLuRescanInstance(self._context)


class RootLuScanheadInstanceTrigger(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.scanhead.instance.trigger'

    def disable_piezo_electric_excitation(self) -> None:
        return self._context.call('root.lu.scanhead.instance.trigger.disable_piezo_electric_excitation')

    def enable_electro_thermal_excitation(self) -> None:
        return self._context.call('root.lu.scanhead.instance.trigger.enable_electro_thermal_excitation')

    def apply_tilt_mode(self) -> None:
        return self._context.call('root.lu.scanhead.instance.trigger.apply_tilt_mode')

    def disable_readout_laser(self) -> None:
        return self._context.call('root.lu.scanhead.instance.trigger.disable_readout_laser')

    def disable_electro_thermal_excitation(self) -> None:
        return self._context.call('root.lu.scanhead.instance.trigger.disable_electro_thermal_excitation')

    def enable_readout_laser(self) -> None:
        return self._context.call('root.lu.scanhead.instance.trigger.enable_readout_laser')

    def enable_pte_laser(self) -> None:
        return self._context.call('root.lu.scanhead.instance.trigger.enable_pte_laser')

    def enable_piezo_electric_excitation(self) -> None:
        return self._context.call('root.lu.scanhead.instance.trigger.enable_piezo_electric_excitation')

    def disable_pte_laser(self) -> None:
        return self._context.call('root.lu.scanhead.instance.trigger.disable_pte_laser')


class RootLuScanheadInstanceAttributePte_laser_power_monitor(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.scanhead.instance.attribute.pte_laser_power_monitor'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.scanhead.instance.attribute.pte_laser_power_monitor.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.scanhead.instance.attribute.pte_laser_power_monitor.value', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.scanhead.instance.attribute.pte_laser_power_monitor.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.scanhead.instance.attribute.pte_laser_power_monitor.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.scanhead.instance.attribute.pte_laser_power_monitor.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.scanhead.instance.attribute.pte_laser_power_monitor.unit', str(new_val))

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.scanhead.instance.attribute.pte_laser_power_monitor.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.scanhead.instance.attribute.pte_laser_power_monitor.min', float(new_val))


class RootLuScanheadInstanceAttributeReadout_laser_setpoint(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.scanhead.instance.attribute.readout_laser_setpoint'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.scanhead.instance.attribute.readout_laser_setpoint.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.scanhead.instance.attribute.readout_laser_setpoint.value', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.scanhead.instance.attribute.readout_laser_setpoint.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.scanhead.instance.attribute.readout_laser_setpoint.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.scanhead.instance.attribute.readout_laser_setpoint.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.scanhead.instance.attribute.readout_laser_setpoint.unit', str(new_val))

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.scanhead.instance.attribute.readout_laser_setpoint.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.scanhead.instance.attribute.readout_laser_setpoint.min', float(new_val))


class RootLuScanheadInstanceAttributeTilt_angle_x(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.scanhead.instance.attribute.tilt_angle_x'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.scanhead.instance.attribute.tilt_angle_x.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.scanhead.instance.attribute.tilt_angle_x.value', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.scanhead.instance.attribute.tilt_angle_x.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.scanhead.instance.attribute.tilt_angle_x.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.scanhead.instance.attribute.tilt_angle_x.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.scanhead.instance.attribute.tilt_angle_x.unit', str(new_val))

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.scanhead.instance.attribute.tilt_angle_x.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.scanhead.instance.attribute.tilt_angle_x.min', float(new_val))


class RootLuScanheadInstanceAttributeHas_xy_sensor(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        yes = 1
        no = 0

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.scanhead.instance.attribute.has_xy_sensor'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value(self) -> ValueEnum:
        return RootLuScanheadInstanceAttributeHas_xy_sensor.ValueEnum(self._context.get('root.lu.scanhead.instance.attribute.has_xy_sensor.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.lu.scanhead.instance.attribute.has_xy_sensor.value_raw', new_val.value)

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.lu.scanhead.instance.attribute.has_xy_sensor.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.lu.scanhead.instance.attribute.has_xy_sensor.value_raw', int(new_val))

    @property
    def enum(self) -> list:
        return list(self._context.get('root.lu.scanhead.instance.attribute.has_xy_sensor.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.lu.scanhead.instance.attribute.has_xy_sensor.enum', list(new_val))


class RootLuScanheadInstanceAttributeTilt_mode(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        measured = 1
        override = 0

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.scanhead.instance.attribute.tilt_mode'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value(self) -> ValueEnum:
        return RootLuScanheadInstanceAttributeTilt_mode.ValueEnum(self._context.get('root.lu.scanhead.instance.attribute.tilt_mode.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.lu.scanhead.instance.attribute.tilt_mode.value_raw', new_val.value)

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.lu.scanhead.instance.attribute.tilt_mode.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.lu.scanhead.instance.attribute.tilt_mode.value_raw', int(new_val))

    @property
    def enum(self) -> list:
        return list(self._context.get('root.lu.scanhead.instance.attribute.tilt_mode.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.lu.scanhead.instance.attribute.tilt_mode.enum', list(new_val))


class RootLuScanheadInstanceAttributeTilt_angle_y(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.scanhead.instance.attribute.tilt_angle_y'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.scanhead.instance.attribute.tilt_angle_y.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.scanhead.instance.attribute.tilt_angle_y.value', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.scanhead.instance.attribute.tilt_angle_y.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.scanhead.instance.attribute.tilt_angle_y.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.scanhead.instance.attribute.tilt_angle_y.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.scanhead.instance.attribute.tilt_angle_y.unit', str(new_val))

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.scanhead.instance.attribute.tilt_angle_y.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.scanhead.instance.attribute.tilt_angle_y.min', float(new_val))


class RootLuScanheadInstanceAttributeReadout_laser_power_monitor(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.scanhead.instance.attribute.readout_laser_power_monitor'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.scanhead.instance.attribute.readout_laser_power_monitor.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.scanhead.instance.attribute.readout_laser_power_monitor.value', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.scanhead.instance.attribute.readout_laser_power_monitor.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.scanhead.instance.attribute.readout_laser_power_monitor.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.scanhead.instance.attribute.readout_laser_power_monitor.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.scanhead.instance.attribute.readout_laser_power_monitor.unit', str(new_val))

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.scanhead.instance.attribute.readout_laser_power_monitor.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.scanhead.instance.attribute.readout_laser_power_monitor.min', float(new_val))


class RootLuScanheadInstanceAttributeFast_in2_channel(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        addon_in = 1
        pte_monitor = 2
        friction_channel = 0

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.scanhead.instance.attribute.fast_in2_channel'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value(self) -> ValueEnum:
        return RootLuScanheadInstanceAttributeFast_in2_channel.ValueEnum(self._context.get('root.lu.scanhead.instance.attribute.fast_in2_channel.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.lu.scanhead.instance.attribute.fast_in2_channel.value_raw', new_val.value)

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.lu.scanhead.instance.attribute.fast_in2_channel.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.lu.scanhead.instance.attribute.fast_in2_channel.value_raw', int(new_val))

    @property
    def enum(self) -> list:
        return list(self._context.get('root.lu.scanhead.instance.attribute.fast_in2_channel.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.lu.scanhead.instance.attribute.fast_in2_channel.enum', list(new_val))


class RootLuScanheadInstanceAttributeType(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        core_afm = 19
        dummy6 = 6
        dummy4 = 4
        dummy11 = 11
        dummy8 = 8
        lens_afm = 15
        nanite_afm = 12
        arac = 17
        p6 = 18
        cytomass = 20
        e_stm = 2
        unknown = 1
        semafm = 16
        p6_mount = 21
        e_afm = 9
        dummy7 = 7
        dummy10 = 10
        flex_afm = 14
        afsem = 13
        not_connected = 0
        dummy5 = 5
        dummy3 = 3

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.scanhead.instance.attribute.type'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value(self) -> ValueEnum:
        return RootLuScanheadInstanceAttributeType.ValueEnum(self._context.get('root.lu.scanhead.instance.attribute.type.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.lu.scanhead.instance.attribute.type.value_raw', new_val.value)

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.lu.scanhead.instance.attribute.type.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.lu.scanhead.instance.attribute.type.value_raw', int(new_val))

    @property
    def enum(self) -> list:
        return list(self._context.get('root.lu.scanhead.instance.attribute.type.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.lu.scanhead.instance.attribute.type.enum', list(new_val))


class RootLuScanheadInstanceAttributeHas_z_sensor(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        yes = 1
        no = 0

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.scanhead.instance.attribute.has_z_sensor'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value(self) -> ValueEnum:
        return RootLuScanheadInstanceAttributeHas_z_sensor.ValueEnum(self._context.get('root.lu.scanhead.instance.attribute.has_z_sensor.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.lu.scanhead.instance.attribute.has_z_sensor.value_raw', new_val.value)

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.lu.scanhead.instance.attribute.has_z_sensor.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.lu.scanhead.instance.attribute.has_z_sensor.value_raw', int(new_val))

    @property
    def enum(self) -> list:
        return list(self._context.get('root.lu.scanhead.instance.attribute.has_z_sensor.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.lu.scanhead.instance.attribute.has_z_sensor.enum', list(new_val))


class RootLuScanheadInstanceAttributePte_laser_setpoint(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.scanhead.instance.attribute.pte_laser_setpoint'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.scanhead.instance.attribute.pte_laser_setpoint.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.scanhead.instance.attribute.pte_laser_setpoint.value', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.scanhead.instance.attribute.pte_laser_setpoint.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.scanhead.instance.attribute.pte_laser_setpoint.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.scanhead.instance.attribute.pte_laser_setpoint.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.scanhead.instance.attribute.pte_laser_setpoint.unit', str(new_val))

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.scanhead.instance.attribute.pte_laser_setpoint.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.scanhead.instance.attribute.pte_laser_setpoint.min', float(new_val))


class RootLuScanheadInstanceAttribute(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.scanhead.instance.attribute'
        self.pte_laser_setpoint = RootLuScanheadInstanceAttributePte_laser_setpoint(self._context)
        self.has_z_sensor = RootLuScanheadInstanceAttributeHas_z_sensor(self._context)
        self.type = RootLuScanheadInstanceAttributeType(self._context)
        self.fast_in2_channel = RootLuScanheadInstanceAttributeFast_in2_channel(self._context)
        self.readout_laser_power_monitor = RootLuScanheadInstanceAttributeReadout_laser_power_monitor(self._context)
        self.tilt_angle_y = RootLuScanheadInstanceAttributeTilt_angle_y(self._context)
        self.tilt_mode = RootLuScanheadInstanceAttributeTilt_mode(self._context)
        self.has_xy_sensor = RootLuScanheadInstanceAttributeHas_xy_sensor(self._context)
        self.tilt_angle_x = RootLuScanheadInstanceAttributeTilt_angle_x(self._context)
        self.readout_laser_setpoint = RootLuScanheadInstanceAttributeReadout_laser_setpoint(self._context)
        self.pte_laser_power_monitor = RootLuScanheadInstanceAttributePte_laser_power_monitor(self._context)


class RootLuScanheadInstanceBusy(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.scanhead.instance.busy'


class RootLuScanheadInstance(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.scanhead.instance'
        self.busy = RootLuScanheadInstanceBusy(self._context)
        self.attribute = RootLuScanheadInstanceAttribute(self._context)
        self.trigger = RootLuScanheadInstanceTrigger(self._context)


class RootLuScanhead(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.scanhead'
        self.instance = RootLuScanheadInstance(self._context)


class RootLuSensor_controlInstanceTrigger(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.sensor_control.instance.trigger'

    def start_deflection_offset_calibration(self) -> None:
        return self._context.call('root.lu.sensor_control.instance.trigger.start_deflection_offset_calibration')

    def deflection_offset_calibration_with_retract(self) -> None:
        return self._context.call('root.lu.sensor_control.instance.trigger.deflection_offset_calibration_with_retract')

    def start_sensor_calibration(self) -> None:
        return self._context.call('root.lu.sensor_control.instance.trigger.start_sensor_calibration')

    def start_set_dynamic_amplitude(self) -> None:
        return self._context.call('root.lu.sensor_control.instance.trigger.start_set_dynamic_amplitude')

    def user_abort(self) -> None:
        return self._context.call('root.lu.sensor_control.instance.trigger.user_abort')

    def start_update_laser_spot_on_detector_status(self) -> None:
        return self._context.call('root.lu.sensor_control.instance.trigger.start_update_laser_spot_on_detector_status')

    def deflection_offset_calibration(self) -> None:
        return self._context.call('root.lu.sensor_control.instance.trigger.deflection_offset_calibration')

    def update_laser_spot_on_detector_status(self) -> None:
        return self._context.call('root.lu.sensor_control.instance.trigger.update_laser_spot_on_detector_status')

    def start_detector_auto_adjustment(self) -> None:
        return self._context.call('root.lu.sensor_control.instance.trigger.start_detector_auto_adjustment')


class RootLuSensor_controlInstanceAttributeOffset_calib_i_gain_mode(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        auto_from_head_typ = 1
        fix_from_attr = 0

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.sensor_control.instance.attribute.offset_calib_i_gain_mode'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value(self) -> ValueEnum:
        return RootLuSensor_controlInstanceAttributeOffset_calib_i_gain_mode.ValueEnum(self._context.get('root.lu.sensor_control.instance.attribute.offset_calib_i_gain_mode.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.lu.sensor_control.instance.attribute.offset_calib_i_gain_mode.value_raw', new_val.value)

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.lu.sensor_control.instance.attribute.offset_calib_i_gain_mode.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.lu.sensor_control.instance.attribute.offset_calib_i_gain_mode.value_raw', int(new_val))

    @property
    def enum(self) -> list:
        return list(self._context.get('root.lu.sensor_control.instance.attribute.offset_calib_i_gain_mode.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.lu.sensor_control.instance.attribute.offset_calib_i_gain_mode.enum', list(new_val))


class RootLuSensor_controlInstanceAttributeSensor_amplitude(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.sensor_control.instance.attribute.sensor_amplitude'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.sensor_control.instance.attribute.sensor_amplitude.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.sensor_control.instance.attribute.sensor_amplitude.value', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.sensor_control.instance.attribute.sensor_amplitude.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.sensor_control.instance.attribute.sensor_amplitude.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.sensor_control.instance.attribute.sensor_amplitude.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.sensor_control.instance.attribute.sensor_amplitude.unit', str(new_val))

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.sensor_control.instance.attribute.sensor_amplitude.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.sensor_control.instance.attribute.sensor_amplitude.min', float(new_val))


class RootLuSensor_controlInstanceAttributeOffset_calib_mode(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        auto_calibrate_deflection = 1
        no_auto_calibration = 0
        auto_calibrate_z_ctrl_input = 2

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.sensor_control.instance.attribute.offset_calib_mode'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value(self) -> ValueEnum:
        return RootLuSensor_controlInstanceAttributeOffset_calib_mode.ValueEnum(self._context.get('root.lu.sensor_control.instance.attribute.offset_calib_mode.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.lu.sensor_control.instance.attribute.offset_calib_mode.value_raw', new_val.value)

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.lu.sensor_control.instance.attribute.offset_calib_mode.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.lu.sensor_control.instance.attribute.offset_calib_mode.value_raw', int(new_val))

    @property
    def enum(self) -> list:
        return list(self._context.get('root.lu.sensor_control.instance.attribute.offset_calib_mode.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.lu.sensor_control.instance.attribute.offset_calib_mode.enum', list(new_val))


class RootLuSensor_controlInstanceAttributeOffset_calib_i_gain(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.sensor_control.instance.attribute.offset_calib_i_gain'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.sensor_control.instance.attribute.offset_calib_i_gain.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.sensor_control.instance.attribute.offset_calib_i_gain.value', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.sensor_control.instance.attribute.offset_calib_i_gain.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.sensor_control.instance.attribute.offset_calib_i_gain.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.sensor_control.instance.attribute.offset_calib_i_gain.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.sensor_control.instance.attribute.offset_calib_i_gain.unit', str(new_val))

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.sensor_control.instance.attribute.offset_calib_i_gain.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.sensor_control.instance.attribute.offset_calib_i_gain.min', float(new_val))


class RootLuSensor_controlInstanceAttributeDetector_adjustment_tolerance(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.sensor_control.instance.attribute.detector_adjustment_tolerance'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.sensor_control.instance.attribute.detector_adjustment_tolerance.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.sensor_control.instance.attribute.detector_adjustment_tolerance.value', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.sensor_control.instance.attribute.detector_adjustment_tolerance.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.sensor_control.instance.attribute.detector_adjustment_tolerance.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.sensor_control.instance.attribute.detector_adjustment_tolerance.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.sensor_control.instance.attribute.detector_adjustment_tolerance.unit', str(new_val))

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.sensor_control.instance.attribute.detector_adjustment_tolerance.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.sensor_control.instance.attribute.detector_adjustment_tolerance.min', float(new_val))


class RootLuSensor_controlInstanceAttributeDeflection_offset_calibration_status(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        calibration_error = 1
        no_error = 0
        sensor_signal_failed = 2

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.sensor_control.instance.attribute.deflection_offset_calibration_status'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value(self) -> ValueEnum:
        return RootLuSensor_controlInstanceAttributeDeflection_offset_calibration_status.ValueEnum(self._context.get('root.lu.sensor_control.instance.attribute.deflection_offset_calibration_status.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.lu.sensor_control.instance.attribute.deflection_offset_calibration_status.value_raw', new_val.value)

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.lu.sensor_control.instance.attribute.deflection_offset_calibration_status.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.lu.sensor_control.instance.attribute.deflection_offset_calibration_status.value_raw', int(new_val))

    @property
    def enum(self) -> list:
        return list(self._context.get('root.lu.sensor_control.instance.attribute.deflection_offset_calibration_status.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.lu.sensor_control.instance.attribute.deflection_offset_calibration_status.enum', list(new_val))


class RootLuSensor_controlInstanceAttributeDetector_auto_adjustment_status(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        idle = 0
        failed = 2
        running = 1

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.sensor_control.instance.attribute.detector_auto_adjustment_status'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value(self) -> ValueEnum:
        return RootLuSensor_controlInstanceAttributeDetector_auto_adjustment_status.ValueEnum(self._context.get('root.lu.sensor_control.instance.attribute.detector_auto_adjustment_status.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.lu.sensor_control.instance.attribute.detector_auto_adjustment_status.value_raw', new_val.value)

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.lu.sensor_control.instance.attribute.detector_auto_adjustment_status.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.lu.sensor_control.instance.attribute.detector_auto_adjustment_status.value_raw', int(new_val))

    @property
    def enum(self) -> list:
        return list(self._context.get('root.lu.sensor_control.instance.attribute.detector_auto_adjustment_status.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.lu.sensor_control.instance.attribute.detector_auto_adjustment_status.enum', list(new_val))


class RootLuSensor_controlInstanceAttributeEnable10_hz_update_laser_spot_on_detector_status(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.sensor_control.instance.attribute.enable10_hz_update_laser_spot_on_detector_status'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.sensor_control.instance.attribute.enable10_hz_update_laser_spot_on_detector_status.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.sensor_control.instance.attribute.enable10_hz_update_laser_spot_on_detector_status.value', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.sensor_control.instance.attribute.enable10_hz_update_laser_spot_on_detector_status.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.sensor_control.instance.attribute.enable10_hz_update_laser_spot_on_detector_status.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.sensor_control.instance.attribute.enable10_hz_update_laser_spot_on_detector_status.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.sensor_control.instance.attribute.enable10_hz_update_laser_spot_on_detector_status.unit', str(new_val))

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.sensor_control.instance.attribute.enable10_hz_update_laser_spot_on_detector_status.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.sensor_control.instance.attribute.enable10_hz_update_laser_spot_on_detector_status.min', float(new_val))


class RootLuSensor_controlInstanceAttributeDetector_adjustment_duration_limit(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.sensor_control.instance.attribute.detector_adjustment_duration_limit'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.sensor_control.instance.attribute.detector_adjustment_duration_limit.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.sensor_control.instance.attribute.detector_adjustment_duration_limit.value', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.sensor_control.instance.attribute.detector_adjustment_duration_limit.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.sensor_control.instance.attribute.detector_adjustment_duration_limit.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.sensor_control.instance.attribute.detector_adjustment_duration_limit.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.sensor_control.instance.attribute.detector_adjustment_duration_limit.unit', str(new_val))

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.sensor_control.instance.attribute.detector_adjustment_duration_limit.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.sensor_control.instance.attribute.detector_adjustment_duration_limit.min', float(new_val))


class RootLuSensor_controlInstanceAttribute(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.sensor_control.instance.attribute'
        self.detector_adjustment_duration_limit = RootLuSensor_controlInstanceAttributeDetector_adjustment_duration_limit(self._context)
        self.enable10_hz_update_laser_spot_on_detector_status = RootLuSensor_controlInstanceAttributeEnable10_hz_update_laser_spot_on_detector_status(self._context)
        self.detector_auto_adjustment_status = RootLuSensor_controlInstanceAttributeDetector_auto_adjustment_status(self._context)
        self.deflection_offset_calibration_status = RootLuSensor_controlInstanceAttributeDeflection_offset_calibration_status(self._context)
        self.detector_adjustment_tolerance = RootLuSensor_controlInstanceAttributeDetector_adjustment_tolerance(self._context)
        self.offset_calib_i_gain = RootLuSensor_controlInstanceAttributeOffset_calib_i_gain(self._context)
        self.offset_calib_mode = RootLuSensor_controlInstanceAttributeOffset_calib_mode(self._context)
        self.sensor_amplitude = RootLuSensor_controlInstanceAttributeSensor_amplitude(self._context)
        self.offset_calib_i_gain_mode = RootLuSensor_controlInstanceAttributeOffset_calib_i_gain_mode(self._context)


class RootLuSensor_controlInstanceBusy(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.sensor_control.instance.busy'


class RootLuSensor_controlInstance(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.sensor_control.instance'
        self.busy = RootLuSensor_controlInstanceBusy(self._context)
        self.attribute = RootLuSensor_controlInstanceAttribute(self._context)
        self.trigger = RootLuSensor_controlInstanceTrigger(self._context)


class RootLuSensor_control(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.sensor_control'
        self.instance = RootLuSensor_controlInstance(self._context)


class RootLuComp_dcInstanceTrigger(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.comp_dc.instance.trigger'

    def apply_new_nonlinear_configuration(self) -> None:
        return self._context.call('root.lu.comp_dc.instance.trigger.apply_new_nonlinear_configuration')

    def start_comp_dc_calibration(self) -> None:
        return self._context.call('root.lu.comp_dc.instance.trigger.start_comp_dc_calibration')

    def apply_new_configuration(self) -> None:
        return self._context.call('root.lu.comp_dc.instance.trigger.apply_new_configuration')

    def read_current_configuration(self) -> None:
        return self._context.call('root.lu.comp_dc.instance.trigger.read_current_configuration')

    def user_abort(self) -> None:
        return self._context.call('root.lu.comp_dc.instance.trigger.user_abort')


class RootLuComp_dcInstanceAttributeComp_dc_gain_x(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.comp_dc.instance.attribute.comp_dc_gain_x'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.comp_dc.instance.attribute.comp_dc_gain_x.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.comp_dc.instance.attribute.comp_dc_gain_x.value', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.comp_dc.instance.attribute.comp_dc_gain_x.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.comp_dc.instance.attribute.comp_dc_gain_x.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.comp_dc.instance.attribute.comp_dc_gain_x.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.comp_dc.instance.attribute.comp_dc_gain_x.unit', str(new_val))

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.comp_dc.instance.attribute.comp_dc_gain_x.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.comp_dc.instance.attribute.comp_dc_gain_x.min', float(new_val))


class RootLuComp_dcInstanceAttributeComp_dc_gain_w(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.comp_dc.instance.attribute.comp_dc_gain_w'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.comp_dc.instance.attribute.comp_dc_gain_w.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.comp_dc.instance.attribute.comp_dc_gain_w.value', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.comp_dc.instance.attribute.comp_dc_gain_w.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.comp_dc.instance.attribute.comp_dc_gain_w.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.comp_dc.instance.attribute.comp_dc_gain_w.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.comp_dc.instance.attribute.comp_dc_gain_w.unit', str(new_val))

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.comp_dc.instance.attribute.comp_dc_gain_w.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.comp_dc.instance.attribute.comp_dc_gain_w.min', float(new_val))


class RootLuComp_dcInstanceAttributeComp_dc_gain_y(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.comp_dc.instance.attribute.comp_dc_gain_y'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.comp_dc.instance.attribute.comp_dc_gain_y.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.comp_dc.instance.attribute.comp_dc_gain_y.value', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.comp_dc.instance.attribute.comp_dc_gain_y.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.comp_dc.instance.attribute.comp_dc_gain_y.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.comp_dc.instance.attribute.comp_dc_gain_y.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.comp_dc.instance.attribute.comp_dc_gain_y.unit', str(new_val))

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.comp_dc.instance.attribute.comp_dc_gain_y.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.comp_dc.instance.attribute.comp_dc_gain_y.min', float(new_val))


class RootLuComp_dcInstanceAttributeComp_dc_gain_z(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.comp_dc.instance.attribute.comp_dc_gain_z'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.comp_dc.instance.attribute.comp_dc_gain_z.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.comp_dc.instance.attribute.comp_dc_gain_z.value', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.comp_dc.instance.attribute.comp_dc_gain_z.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.comp_dc.instance.attribute.comp_dc_gain_z.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.comp_dc.instance.attribute.comp_dc_gain_z.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.comp_dc.instance.attribute.comp_dc_gain_z.unit', str(new_val))

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.comp_dc.instance.attribute.comp_dc_gain_z.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.comp_dc.instance.attribute.comp_dc_gain_z.min', float(new_val))


class RootLuComp_dcInstanceAttributeCoefficient_index(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.comp_dc.instance.attribute.coefficient_index'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.comp_dc.instance.attribute.coefficient_index.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.comp_dc.instance.attribute.coefficient_index.value', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.comp_dc.instance.attribute.coefficient_index.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.comp_dc.instance.attribute.coefficient_index.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.comp_dc.instance.attribute.coefficient_index.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.comp_dc.instance.attribute.coefficient_index.unit', str(new_val))

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.comp_dc.instance.attribute.coefficient_index.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.comp_dc.instance.attribute.coefficient_index.min', float(new_val))


class RootLuComp_dcInstanceAttribute(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.comp_dc.instance.attribute'
        self.coefficient_index = RootLuComp_dcInstanceAttributeCoefficient_index(self._context)
        self.comp_dc_gain_z = RootLuComp_dcInstanceAttributeComp_dc_gain_z(self._context)
        self.comp_dc_gain_y = RootLuComp_dcInstanceAttributeComp_dc_gain_y(self._context)
        self.comp_dc_gain_w = RootLuComp_dcInstanceAttributeComp_dc_gain_w(self._context)
        self.comp_dc_gain_x = RootLuComp_dcInstanceAttributeComp_dc_gain_x(self._context)


class RootLuComp_dcInstanceBusy(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.comp_dc.instance.busy'


class RootLuComp_dcInstance(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.comp_dc.instance'
        self.busy = RootLuComp_dcInstanceBusy(self._context)
        self.attribute = RootLuComp_dcInstanceAttribute(self._context)
        self.trigger = RootLuComp_dcInstanceTrigger(self._context)


class RootLuComp_dc(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.comp_dc'
        self.instance = RootLuComp_dcInstance(self._context)


class RootLuSequencerInstanceTrigger(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.sequencer.instance.trigger'

    def start(self) -> None:
        return self._context.call('root.lu.sequencer.instance.trigger.start')

    def abort(self) -> None:
        return self._context.call('root.lu.sequencer.instance.trigger.abort')

    def step(self) -> None:
        return self._context.call('root.lu.sequencer.instance.trigger.step')


class RootLuSequencerInstanceAttributeInstruction_pointer(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.sequencer.instance.attribute.instruction_pointer'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.sequencer.instance.attribute.instruction_pointer.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.sequencer.instance.attribute.instruction_pointer.value', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.sequencer.instance.attribute.instruction_pointer.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.sequencer.instance.attribute.instruction_pointer.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.sequencer.instance.attribute.instruction_pointer.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.sequencer.instance.attribute.instruction_pointer.unit', str(new_val))

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.sequencer.instance.attribute.instruction_pointer.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.sequencer.instance.attribute.instruction_pointer.min', float(new_val))


class RootLuSequencerInstanceAttributeMemory_vec(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.sequencer.instance.attribute.memory_vec'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def vector(self) -> list:
        return list(self._context.get('root.lu.sequencer.instance.attribute.memory_vec.vector'))

    @vector.setter
    def vector(self, new_val:list):
        self._context.set('root.lu.sequencer.instance.attribute.memory_vec.vector', list(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.sequencer.instance.attribute.memory_vec.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.sequencer.instance.attribute.memory_vec.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.sequencer.instance.attribute.memory_vec.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.sequencer.instance.attribute.memory_vec.unit', str(new_val))

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.sequencer.instance.attribute.memory_vec.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.sequencer.instance.attribute.memory_vec.min', float(new_val))


class RootLuSequencerInstanceAttributeStatus(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.sequencer.instance.attribute.status'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.sequencer.instance.attribute.status.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.sequencer.instance.attribute.status.value', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.sequencer.instance.attribute.status.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.sequencer.instance.attribute.status.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.sequencer.instance.attribute.status.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.sequencer.instance.attribute.status.unit', str(new_val))

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.sequencer.instance.attribute.status.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.sequencer.instance.attribute.status.min', float(new_val))


class RootLuSequencerInstanceAttribute(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.sequencer.instance.attribute'
        self.status = RootLuSequencerInstanceAttributeStatus(self._context)
        self.memory_vec = RootLuSequencerInstanceAttributeMemory_vec(self._context)
        self.instruction_pointer = RootLuSequencerInstanceAttributeInstruction_pointer(self._context)


class RootLuSequencerInstanceBusy(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.sequencer.instance.busy'

    @property
    def is_running(self) -> bool:
        return bool(self._context.call('root.lu.sequencer.instance.busy.is_running'))


class RootLuSequencerInstance(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.sequencer.instance'
        self.busy = RootLuSequencerInstanceBusy(self._context)
        self.attribute = RootLuSequencerInstanceAttribute(self._context)
        self.trigger = RootLuSequencerInstanceTrigger(self._context)


class RootLuSequencer(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.sequencer'
        self.instance = RootLuSequencerInstance(self._context)


class RootLuAnalog_hi_res_inDetector_sumTrigger(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.detector_sum.trigger'


class RootLuAnalog_hi_res_inDetector_sumAttributeCross_coupling_axis_id(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        position_x = 0
        position_w = 3
        self = 4
        position_y = 1
        position_z = 2

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.detector_sum.attribute.cross_coupling_axis_id'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value(self) -> ValueEnum:
        return RootLuAnalog_hi_res_inDetector_sumAttributeCross_coupling_axis_id.ValueEnum(self._context.get('root.lu.analog_hi_res_in.detector_sum.attribute.cross_coupling_axis_id.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.lu.analog_hi_res_in.detector_sum.attribute.cross_coupling_axis_id.value_raw', new_val.value)

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.lu.analog_hi_res_in.detector_sum.attribute.cross_coupling_axis_id.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.lu.analog_hi_res_in.detector_sum.attribute.cross_coupling_axis_id.value_raw', int(new_val))

    @property
    def enum(self) -> list:
        return list(self._context.get('root.lu.analog_hi_res_in.detector_sum.attribute.cross_coupling_axis_id.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.lu.analog_hi_res_in.detector_sum.attribute.cross_coupling_axis_id.enum', list(new_val))


class RootLuAnalog_hi_res_inDetector_sumAttributeFilter_mode(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        low_pass_filter = 1
        no_filter = 0

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.detector_sum.attribute.filter_mode'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value(self) -> ValueEnum:
        return RootLuAnalog_hi_res_inDetector_sumAttributeFilter_mode.ValueEnum(self._context.get('root.lu.analog_hi_res_in.detector_sum.attribute.filter_mode.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.lu.analog_hi_res_in.detector_sum.attribute.filter_mode.value_raw', new_val.value)

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.lu.analog_hi_res_in.detector_sum.attribute.filter_mode.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.lu.analog_hi_res_in.detector_sum.attribute.filter_mode.value_raw', int(new_val))

    @property
    def enum(self) -> list:
        return list(self._context.get('root.lu.analog_hi_res_in.detector_sum.attribute.filter_mode.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.lu.analog_hi_res_in.detector_sum.attribute.filter_mode.enum', list(new_val))


class RootLuAnalog_hi_res_inDetector_sumAttributeCross_coupling_axis_coefficient_vec(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.detector_sum.attribute.cross_coupling_axis_coefficient_vec'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def vector(self) -> list:
        return list(self._context.get('root.lu.analog_hi_res_in.detector_sum.attribute.cross_coupling_axis_coefficient_vec.vector'))

    @vector.setter
    def vector(self, new_val:list):
        self._context.set('root.lu.analog_hi_res_in.detector_sum.attribute.cross_coupling_axis_coefficient_vec.vector', list(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.detector_sum.attribute.cross_coupling_axis_coefficient_vec.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.detector_sum.attribute.cross_coupling_axis_coefficient_vec.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.analog_hi_res_in.detector_sum.attribute.cross_coupling_axis_coefficient_vec.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.analog_hi_res_in.detector_sum.attribute.cross_coupling_axis_coefficient_vec.unit', str(new_val))

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.detector_sum.attribute.cross_coupling_axis_coefficient_vec.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.detector_sum.attribute.cross_coupling_axis_coefficient_vec.min', float(new_val))


class RootLuAnalog_hi_res_inDetector_sumAttributeInput_gain(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.detector_sum.attribute.input_gain'


class RootLuAnalog_hi_res_inDetector_sumAttributeCurrent_input_value(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.detector_sum.attribute.current_input_value'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.detector_sum.attribute.current_input_value.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.detector_sum.attribute.current_input_value.value', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.detector_sum.attribute.current_input_value.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.detector_sum.attribute.current_input_value.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.analog_hi_res_in.detector_sum.attribute.current_input_value.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.analog_hi_res_in.detector_sum.attribute.current_input_value.unit', str(new_val))

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.detector_sum.attribute.current_input_value.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.detector_sum.attribute.current_input_value.min', float(new_val))


class RootLuAnalog_hi_res_inDetector_sumAttributeFilter_coeff_vec(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.detector_sum.attribute.filter_coeff_vec'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def vector(self) -> list:
        return list(self._context.get('root.lu.analog_hi_res_in.detector_sum.attribute.filter_coeff_vec.vector'))

    @vector.setter
    def vector(self, new_val:list):
        self._context.set('root.lu.analog_hi_res_in.detector_sum.attribute.filter_coeff_vec.vector', list(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.detector_sum.attribute.filter_coeff_vec.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.detector_sum.attribute.filter_coeff_vec.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.analog_hi_res_in.detector_sum.attribute.filter_coeff_vec.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.analog_hi_res_in.detector_sum.attribute.filter_coeff_vec.unit', str(new_val))

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.detector_sum.attribute.filter_coeff_vec.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.detector_sum.attribute.filter_coeff_vec.min', float(new_val))


class RootLuAnalog_hi_res_inDetector_sumAttributeInput_offset(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.detector_sum.attribute.input_offset'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.detector_sum.attribute.input_offset.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.detector_sum.attribute.input_offset.value', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.detector_sum.attribute.input_offset.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.detector_sum.attribute.input_offset.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.analog_hi_res_in.detector_sum.attribute.input_offset.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.analog_hi_res_in.detector_sum.attribute.input_offset.unit', str(new_val))

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.detector_sum.attribute.input_offset.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.detector_sum.attribute.input_offset.min', float(new_val))


class RootLuAnalog_hi_res_inDetector_sumAttributeCalib_polarity(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        negative = 1
        positive = 0

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.detector_sum.attribute.calib_polarity'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value(self) -> ValueEnum:
        return RootLuAnalog_hi_res_inDetector_sumAttributeCalib_polarity.ValueEnum(self._context.get('root.lu.analog_hi_res_in.detector_sum.attribute.calib_polarity.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.lu.analog_hi_res_in.detector_sum.attribute.calib_polarity.value_raw', new_val.value)

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.lu.analog_hi_res_in.detector_sum.attribute.calib_polarity.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.lu.analog_hi_res_in.detector_sum.attribute.calib_polarity.value_raw', int(new_val))

    @property
    def enum(self) -> list:
        return list(self._context.get('root.lu.analog_hi_res_in.detector_sum.attribute.calib_polarity.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.lu.analog_hi_res_in.detector_sum.attribute.calib_polarity.enum', list(new_val))


class RootLuAnalog_hi_res_inDetector_sumAttributeCalib_offset(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.detector_sum.attribute.calib_offset'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.detector_sum.attribute.calib_offset.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.detector_sum.attribute.calib_offset.value', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.detector_sum.attribute.calib_offset.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.detector_sum.attribute.calib_offset.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.analog_hi_res_in.detector_sum.attribute.calib_offset.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.analog_hi_res_in.detector_sum.attribute.calib_offset.unit', str(new_val))

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.detector_sum.attribute.calib_offset.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.detector_sum.attribute.calib_offset.min', float(new_val))


class RootLuAnalog_hi_res_inDetector_sumAttributeFilter_number(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.detector_sum.attribute.filter_number'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.detector_sum.attribute.filter_number.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.detector_sum.attribute.filter_number.value', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.detector_sum.attribute.filter_number.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.detector_sum.attribute.filter_number.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.analog_hi_res_in.detector_sum.attribute.filter_number.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.analog_hi_res_in.detector_sum.attribute.filter_number.unit', str(new_val))

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.detector_sum.attribute.filter_number.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.detector_sum.attribute.filter_number.min', float(new_val))


class RootLuAnalog_hi_res_inDetector_sumAttributeCalib_gain(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.detector_sum.attribute.calib_gain'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.detector_sum.attribute.calib_gain.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.detector_sum.attribute.calib_gain.value', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.detector_sum.attribute.calib_gain.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.detector_sum.attribute.calib_gain.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.analog_hi_res_in.detector_sum.attribute.calib_gain.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.analog_hi_res_in.detector_sum.attribute.calib_gain.unit', str(new_val))

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.detector_sum.attribute.calib_gain.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.detector_sum.attribute.calib_gain.min', float(new_val))


class RootLuAnalog_hi_res_inDetector_sumAttribute(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.detector_sum.attribute'
        self.calib_gain = RootLuAnalog_hi_res_inDetector_sumAttributeCalib_gain(self._context)
        self.filter_number = RootLuAnalog_hi_res_inDetector_sumAttributeFilter_number(self._context)
        self.calib_offset = RootLuAnalog_hi_res_inDetector_sumAttributeCalib_offset(self._context)
        self.calib_polarity = RootLuAnalog_hi_res_inDetector_sumAttributeCalib_polarity(self._context)
        self.input_offset = RootLuAnalog_hi_res_inDetector_sumAttributeInput_offset(self._context)
        self.filter_coeff_vec = RootLuAnalog_hi_res_inDetector_sumAttributeFilter_coeff_vec(self._context)
        self.current_input_value = RootLuAnalog_hi_res_inDetector_sumAttributeCurrent_input_value(self._context)
        self.input_gain = RootLuAnalog_hi_res_inDetector_sumAttributeInput_gain(self._context)
        self.cross_coupling_axis_coefficient_vec = RootLuAnalog_hi_res_inDetector_sumAttributeCross_coupling_axis_coefficient_vec(self._context)
        self.filter_mode = RootLuAnalog_hi_res_inDetector_sumAttributeFilter_mode(self._context)
        self.cross_coupling_axis_id = RootLuAnalog_hi_res_inDetector_sumAttributeCross_coupling_axis_id(self._context)


class RootLuAnalog_hi_res_inDetector_sumBusy(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.detector_sum.busy'


class RootLuAnalog_hi_res_inDetector_sum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.detector_sum'
        self.busy = RootLuAnalog_hi_res_inDetector_sumBusy(self._context)
        self.attribute = RootLuAnalog_hi_res_inDetector_sumAttribute(self._context)
        self.trigger = RootLuAnalog_hi_res_inDetector_sumTrigger(self._context)


class RootLuAnalog_hi_res_inIn6Trigger(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.in6.trigger'


class RootLuAnalog_hi_res_inIn6AttributeCross_coupling_axis_id(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        position_x = 0
        position_w = 3
        self = 4
        position_y = 1
        position_z = 2

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.in6.attribute.cross_coupling_axis_id'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value(self) -> ValueEnum:
        return RootLuAnalog_hi_res_inIn6AttributeCross_coupling_axis_id.ValueEnum(self._context.get('root.lu.analog_hi_res_in.in6.attribute.cross_coupling_axis_id.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.lu.analog_hi_res_in.in6.attribute.cross_coupling_axis_id.value_raw', new_val.value)

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.lu.analog_hi_res_in.in6.attribute.cross_coupling_axis_id.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.lu.analog_hi_res_in.in6.attribute.cross_coupling_axis_id.value_raw', int(new_val))

    @property
    def enum(self) -> list:
        return list(self._context.get('root.lu.analog_hi_res_in.in6.attribute.cross_coupling_axis_id.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.lu.analog_hi_res_in.in6.attribute.cross_coupling_axis_id.enum', list(new_val))


class RootLuAnalog_hi_res_inIn6AttributeFilter_mode(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        low_pass_filter = 1
        no_filter = 0

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.in6.attribute.filter_mode'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value(self) -> ValueEnum:
        return RootLuAnalog_hi_res_inIn6AttributeFilter_mode.ValueEnum(self._context.get('root.lu.analog_hi_res_in.in6.attribute.filter_mode.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.lu.analog_hi_res_in.in6.attribute.filter_mode.value_raw', new_val.value)

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.lu.analog_hi_res_in.in6.attribute.filter_mode.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.lu.analog_hi_res_in.in6.attribute.filter_mode.value_raw', int(new_val))

    @property
    def enum(self) -> list:
        return list(self._context.get('root.lu.analog_hi_res_in.in6.attribute.filter_mode.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.lu.analog_hi_res_in.in6.attribute.filter_mode.enum', list(new_val))


class RootLuAnalog_hi_res_inIn6AttributeCross_coupling_axis_coefficient_vec(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.in6.attribute.cross_coupling_axis_coefficient_vec'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def vector(self) -> list:
        return list(self._context.get('root.lu.analog_hi_res_in.in6.attribute.cross_coupling_axis_coefficient_vec.vector'))

    @vector.setter
    def vector(self, new_val:list):
        self._context.set('root.lu.analog_hi_res_in.in6.attribute.cross_coupling_axis_coefficient_vec.vector', list(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.in6.attribute.cross_coupling_axis_coefficient_vec.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.in6.attribute.cross_coupling_axis_coefficient_vec.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.analog_hi_res_in.in6.attribute.cross_coupling_axis_coefficient_vec.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.analog_hi_res_in.in6.attribute.cross_coupling_axis_coefficient_vec.unit', str(new_val))

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.in6.attribute.cross_coupling_axis_coefficient_vec.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.in6.attribute.cross_coupling_axis_coefficient_vec.min', float(new_val))


class RootLuAnalog_hi_res_inIn6AttributeInput_gain(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.in6.attribute.input_gain'


class RootLuAnalog_hi_res_inIn6AttributeCurrent_input_value(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.in6.attribute.current_input_value'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.in6.attribute.current_input_value.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.in6.attribute.current_input_value.value', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.in6.attribute.current_input_value.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.in6.attribute.current_input_value.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.analog_hi_res_in.in6.attribute.current_input_value.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.analog_hi_res_in.in6.attribute.current_input_value.unit', str(new_val))

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.in6.attribute.current_input_value.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.in6.attribute.current_input_value.min', float(new_val))


class RootLuAnalog_hi_res_inIn6AttributeFilter_coeff_vec(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.in6.attribute.filter_coeff_vec'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def vector(self) -> list:
        return list(self._context.get('root.lu.analog_hi_res_in.in6.attribute.filter_coeff_vec.vector'))

    @vector.setter
    def vector(self, new_val:list):
        self._context.set('root.lu.analog_hi_res_in.in6.attribute.filter_coeff_vec.vector', list(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.in6.attribute.filter_coeff_vec.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.in6.attribute.filter_coeff_vec.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.analog_hi_res_in.in6.attribute.filter_coeff_vec.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.analog_hi_res_in.in6.attribute.filter_coeff_vec.unit', str(new_val))

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.in6.attribute.filter_coeff_vec.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.in6.attribute.filter_coeff_vec.min', float(new_val))


class RootLuAnalog_hi_res_inIn6AttributeInput_offset(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.in6.attribute.input_offset'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.in6.attribute.input_offset.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.in6.attribute.input_offset.value', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.in6.attribute.input_offset.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.in6.attribute.input_offset.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.analog_hi_res_in.in6.attribute.input_offset.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.analog_hi_res_in.in6.attribute.input_offset.unit', str(new_val))

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.in6.attribute.input_offset.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.in6.attribute.input_offset.min', float(new_val))


class RootLuAnalog_hi_res_inIn6AttributeCalib_polarity(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        negative = 1
        positive = 0

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.in6.attribute.calib_polarity'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value(self) -> ValueEnum:
        return RootLuAnalog_hi_res_inIn6AttributeCalib_polarity.ValueEnum(self._context.get('root.lu.analog_hi_res_in.in6.attribute.calib_polarity.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.lu.analog_hi_res_in.in6.attribute.calib_polarity.value_raw', new_val.value)

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.lu.analog_hi_res_in.in6.attribute.calib_polarity.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.lu.analog_hi_res_in.in6.attribute.calib_polarity.value_raw', int(new_val))

    @property
    def enum(self) -> list:
        return list(self._context.get('root.lu.analog_hi_res_in.in6.attribute.calib_polarity.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.lu.analog_hi_res_in.in6.attribute.calib_polarity.enum', list(new_val))


class RootLuAnalog_hi_res_inIn6AttributeCalib_offset(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.in6.attribute.calib_offset'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.in6.attribute.calib_offset.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.in6.attribute.calib_offset.value', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.in6.attribute.calib_offset.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.in6.attribute.calib_offset.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.analog_hi_res_in.in6.attribute.calib_offset.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.analog_hi_res_in.in6.attribute.calib_offset.unit', str(new_val))

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.in6.attribute.calib_offset.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.in6.attribute.calib_offset.min', float(new_val))


class RootLuAnalog_hi_res_inIn6AttributeFilter_number(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.in6.attribute.filter_number'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.in6.attribute.filter_number.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.in6.attribute.filter_number.value', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.in6.attribute.filter_number.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.in6.attribute.filter_number.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.analog_hi_res_in.in6.attribute.filter_number.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.analog_hi_res_in.in6.attribute.filter_number.unit', str(new_val))

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.in6.attribute.filter_number.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.in6.attribute.filter_number.min', float(new_val))


class RootLuAnalog_hi_res_inIn6AttributeCalib_gain(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.in6.attribute.calib_gain'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.in6.attribute.calib_gain.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.in6.attribute.calib_gain.value', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.in6.attribute.calib_gain.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.in6.attribute.calib_gain.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.analog_hi_res_in.in6.attribute.calib_gain.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.analog_hi_res_in.in6.attribute.calib_gain.unit', str(new_val))

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.in6.attribute.calib_gain.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.in6.attribute.calib_gain.min', float(new_val))


class RootLuAnalog_hi_res_inIn6Attribute(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.in6.attribute'
        self.calib_gain = RootLuAnalog_hi_res_inIn6AttributeCalib_gain(self._context)
        self.filter_number = RootLuAnalog_hi_res_inIn6AttributeFilter_number(self._context)
        self.calib_offset = RootLuAnalog_hi_res_inIn6AttributeCalib_offset(self._context)
        self.calib_polarity = RootLuAnalog_hi_res_inIn6AttributeCalib_polarity(self._context)
        self.input_offset = RootLuAnalog_hi_res_inIn6AttributeInput_offset(self._context)
        self.filter_coeff_vec = RootLuAnalog_hi_res_inIn6AttributeFilter_coeff_vec(self._context)
        self.current_input_value = RootLuAnalog_hi_res_inIn6AttributeCurrent_input_value(self._context)
        self.input_gain = RootLuAnalog_hi_res_inIn6AttributeInput_gain(self._context)
        self.cross_coupling_axis_coefficient_vec = RootLuAnalog_hi_res_inIn6AttributeCross_coupling_axis_coefficient_vec(self._context)
        self.filter_mode = RootLuAnalog_hi_res_inIn6AttributeFilter_mode(self._context)
        self.cross_coupling_axis_id = RootLuAnalog_hi_res_inIn6AttributeCross_coupling_axis_id(self._context)


class RootLuAnalog_hi_res_inIn6Busy(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.in6.busy'


class RootLuAnalog_hi_res_inIn6(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.in6'
        self.busy = RootLuAnalog_hi_res_inIn6Busy(self._context)
        self.attribute = RootLuAnalog_hi_res_inIn6Attribute(self._context)
        self.trigger = RootLuAnalog_hi_res_inIn6Trigger(self._context)


class RootLuAnalog_hi_res_inMain2AttributeCross_coupling_axis_idEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.main2.attribute.cross_coupling_axis_id.enum'

    @property
    def position_x(self) -> int:
        return int(self._context.get('root.lu.analog_hi_res_in.main2.attribute.cross_coupling_axis_id.enum.position_x'))

    @position_x.setter
    def position_x(self, new_val:int):
        self._context.set('root.lu.analog_hi_res_in.main2.attribute.cross_coupling_axis_id.enum.position_x', int(new_val))

    @property
    def position_w(self) -> int:
        return int(self._context.get('root.lu.analog_hi_res_in.main2.attribute.cross_coupling_axis_id.enum.position_w'))

    @position_w.setter
    def position_w(self, new_val:int):
        self._context.set('root.lu.analog_hi_res_in.main2.attribute.cross_coupling_axis_id.enum.position_w', int(new_val))

    @property
    def self(self) -> int:
        return int(self._context.get('root.lu.analog_hi_res_in.main2.attribute.cross_coupling_axis_id.enum.self'))

    @self.setter
    def self(self, new_val:int):
        self._context.set('root.lu.analog_hi_res_in.main2.attribute.cross_coupling_axis_id.enum.self', int(new_val))

    @property
    def position_y(self) -> int:
        return int(self._context.get('root.lu.analog_hi_res_in.main2.attribute.cross_coupling_axis_id.enum.position_y'))

    @position_y.setter
    def position_y(self, new_val:int):
        self._context.set('root.lu.analog_hi_res_in.main2.attribute.cross_coupling_axis_id.enum.position_y', int(new_val))

    @property
    def position_z(self) -> int:
        return int(self._context.get('root.lu.analog_hi_res_in.main2.attribute.cross_coupling_axis_id.enum.position_z'))

    @position_z.setter
    def position_z(self, new_val:int):
        self._context.set('root.lu.analog_hi_res_in.main2.attribute.cross_coupling_axis_id.enum.position_z', int(new_val))


class RootLuAnalog_hi_res_inMain2AttributeCross_coupling_axis_id(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.main2.attribute.cross_coupling_axis_id'
        self.enum = RootLuAnalog_hi_res_inMain2AttributeCross_coupling_axis_idEnum(self._context)


class RootLuAnalog_hi_res_inMain2AttributeFilter_modeEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.main2.attribute.filter_mode.enum'

    @property
    def low_pass_filter(self) -> int:
        return int(self._context.get('root.lu.analog_hi_res_in.main2.attribute.filter_mode.enum.low_pass_filter'))

    @low_pass_filter.setter
    def low_pass_filter(self, new_val:int):
        self._context.set('root.lu.analog_hi_res_in.main2.attribute.filter_mode.enum.low_pass_filter', int(new_val))

    @property
    def no_filter(self) -> int:
        return int(self._context.get('root.lu.analog_hi_res_in.main2.attribute.filter_mode.enum.no_filter'))

    @no_filter.setter
    def no_filter(self, new_val:int):
        self._context.set('root.lu.analog_hi_res_in.main2.attribute.filter_mode.enum.no_filter', int(new_val))


class RootLuAnalog_hi_res_inMain2AttributeFilter_mode(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.main2.attribute.filter_mode'
        self.enum = RootLuAnalog_hi_res_inMain2AttributeFilter_modeEnum(self._context)


class RootLuAnalog_hi_res_inMain2AttributeCross_coupling_axis_coefficient_vec(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.main2.attribute.cross_coupling_axis_coefficient_vec'


class RootLuAnalog_hi_res_inMain2AttributeInput_gain(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.main2.attribute.input_gain'


class RootLuAnalog_hi_res_inMain2AttributeCurrent_input_value(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.main2.attribute.current_input_value'


class RootLuAnalog_hi_res_inMain2AttributeFilter_coeff_vec(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.main2.attribute.filter_coeff_vec'


class RootLuAnalog_hi_res_inMain2AttributeInput_offset(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.main2.attribute.input_offset'


class RootLuAnalog_hi_res_inMain2AttributeCalib_polarityEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.main2.attribute.calib_polarity.enum'

    @property
    def negative(self) -> int:
        return int(self._context.get('root.lu.analog_hi_res_in.main2.attribute.calib_polarity.enum.negative'))

    @negative.setter
    def negative(self, new_val:int):
        self._context.set('root.lu.analog_hi_res_in.main2.attribute.calib_polarity.enum.negative', int(new_val))

    @property
    def positive(self) -> int:
        return int(self._context.get('root.lu.analog_hi_res_in.main2.attribute.calib_polarity.enum.positive'))

    @positive.setter
    def positive(self, new_val:int):
        self._context.set('root.lu.analog_hi_res_in.main2.attribute.calib_polarity.enum.positive', int(new_val))


class RootLuAnalog_hi_res_inMain2AttributeCalib_polarity(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.main2.attribute.calib_polarity'
        self.enum = RootLuAnalog_hi_res_inMain2AttributeCalib_polarityEnum(self._context)


class RootLuAnalog_hi_res_inMain2AttributeCalib_offset(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.main2.attribute.calib_offset'


class RootLuAnalog_hi_res_inMain2AttributeFilter_number(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.main2.attribute.filter_number'


class RootLuAnalog_hi_res_inMain2AttributeCalib_gain(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.main2.attribute.calib_gain'


class RootLuAnalog_hi_res_inMain2Attribute(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.main2.attribute'
        self.calib_gain = RootLuAnalog_hi_res_inMain2AttributeCalib_gain(self._context)
        self.filter_number = RootLuAnalog_hi_res_inMain2AttributeFilter_number(self._context)
        self.calib_offset = RootLuAnalog_hi_res_inMain2AttributeCalib_offset(self._context)
        self.calib_polarity = RootLuAnalog_hi_res_inMain2AttributeCalib_polarity(self._context)
        self.input_offset = RootLuAnalog_hi_res_inMain2AttributeInput_offset(self._context)
        self.filter_coeff_vec = RootLuAnalog_hi_res_inMain2AttributeFilter_coeff_vec(self._context)
        self.current_input_value = RootLuAnalog_hi_res_inMain2AttributeCurrent_input_value(self._context)
        self.input_gain = RootLuAnalog_hi_res_inMain2AttributeInput_gain(self._context)
        self.cross_coupling_axis_coefficient_vec = RootLuAnalog_hi_res_inMain2AttributeCross_coupling_axis_coefficient_vec(self._context)
        self.filter_mode = RootLuAnalog_hi_res_inMain2AttributeFilter_mode(self._context)
        self.cross_coupling_axis_id = RootLuAnalog_hi_res_inMain2AttributeCross_coupling_axis_id(self._context)


class RootLuAnalog_hi_res_inMain2Trigger(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.main2.trigger'


class RootLuAnalog_hi_res_inMain2(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.main2'
        self.trigger = RootLuAnalog_hi_res_inMain2Trigger(self._context)
        self.attribute = RootLuAnalog_hi_res_inMain2Attribute(self._context)


class RootLuAnalog_hi_res_inPosition_yTrigger(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.position_y.trigger'


class RootLuAnalog_hi_res_inPosition_yAttributeCross_coupling_axis_id(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        position_x = 0
        position_w = 3
        self = 4
        position_y = 1
        position_z = 2

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.position_y.attribute.cross_coupling_axis_id'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value(self) -> ValueEnum:
        return RootLuAnalog_hi_res_inPosition_yAttributeCross_coupling_axis_id.ValueEnum(self._context.get('root.lu.analog_hi_res_in.position_y.attribute.cross_coupling_axis_id.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.lu.analog_hi_res_in.position_y.attribute.cross_coupling_axis_id.value_raw', new_val.value)

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.lu.analog_hi_res_in.position_y.attribute.cross_coupling_axis_id.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.lu.analog_hi_res_in.position_y.attribute.cross_coupling_axis_id.value_raw', int(new_val))

    @property
    def enum(self) -> list:
        return list(self._context.get('root.lu.analog_hi_res_in.position_y.attribute.cross_coupling_axis_id.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.lu.analog_hi_res_in.position_y.attribute.cross_coupling_axis_id.enum', list(new_val))


class RootLuAnalog_hi_res_inPosition_yAttributeFilter_mode(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        low_pass_filter = 1
        no_filter = 0

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.position_y.attribute.filter_mode'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value(self) -> ValueEnum:
        return RootLuAnalog_hi_res_inPosition_yAttributeFilter_mode.ValueEnum(self._context.get('root.lu.analog_hi_res_in.position_y.attribute.filter_mode.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.lu.analog_hi_res_in.position_y.attribute.filter_mode.value_raw', new_val.value)

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.lu.analog_hi_res_in.position_y.attribute.filter_mode.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.lu.analog_hi_res_in.position_y.attribute.filter_mode.value_raw', int(new_val))

    @property
    def enum(self) -> list:
        return list(self._context.get('root.lu.analog_hi_res_in.position_y.attribute.filter_mode.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.lu.analog_hi_res_in.position_y.attribute.filter_mode.enum', list(new_val))


class RootLuAnalog_hi_res_inPosition_yAttributeCross_coupling_axis_coefficient_vec(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.position_y.attribute.cross_coupling_axis_coefficient_vec'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def vector(self) -> list:
        return list(self._context.get('root.lu.analog_hi_res_in.position_y.attribute.cross_coupling_axis_coefficient_vec.vector'))

    @vector.setter
    def vector(self, new_val:list):
        self._context.set('root.lu.analog_hi_res_in.position_y.attribute.cross_coupling_axis_coefficient_vec.vector', list(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.position_y.attribute.cross_coupling_axis_coefficient_vec.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.position_y.attribute.cross_coupling_axis_coefficient_vec.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.analog_hi_res_in.position_y.attribute.cross_coupling_axis_coefficient_vec.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.analog_hi_res_in.position_y.attribute.cross_coupling_axis_coefficient_vec.unit', str(new_val))

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.position_y.attribute.cross_coupling_axis_coefficient_vec.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.position_y.attribute.cross_coupling_axis_coefficient_vec.min', float(new_val))


class RootLuAnalog_hi_res_inPosition_yAttributeInput_gain(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.position_y.attribute.input_gain'


class RootLuAnalog_hi_res_inPosition_yAttributeCurrent_input_value(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.position_y.attribute.current_input_value'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.position_y.attribute.current_input_value.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.position_y.attribute.current_input_value.value', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.position_y.attribute.current_input_value.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.position_y.attribute.current_input_value.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.analog_hi_res_in.position_y.attribute.current_input_value.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.analog_hi_res_in.position_y.attribute.current_input_value.unit', str(new_val))

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.position_y.attribute.current_input_value.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.position_y.attribute.current_input_value.min', float(new_val))


class RootLuAnalog_hi_res_inPosition_yAttributeFilter_coeff_vec(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.position_y.attribute.filter_coeff_vec'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def vector(self) -> list:
        return list(self._context.get('root.lu.analog_hi_res_in.position_y.attribute.filter_coeff_vec.vector'))

    @vector.setter
    def vector(self, new_val:list):
        self._context.set('root.lu.analog_hi_res_in.position_y.attribute.filter_coeff_vec.vector', list(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.position_y.attribute.filter_coeff_vec.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.position_y.attribute.filter_coeff_vec.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.analog_hi_res_in.position_y.attribute.filter_coeff_vec.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.analog_hi_res_in.position_y.attribute.filter_coeff_vec.unit', str(new_val))

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.position_y.attribute.filter_coeff_vec.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.position_y.attribute.filter_coeff_vec.min', float(new_val))


class RootLuAnalog_hi_res_inPosition_yAttributeInput_offset(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.position_y.attribute.input_offset'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.position_y.attribute.input_offset.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.position_y.attribute.input_offset.value', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.position_y.attribute.input_offset.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.position_y.attribute.input_offset.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.analog_hi_res_in.position_y.attribute.input_offset.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.analog_hi_res_in.position_y.attribute.input_offset.unit', str(new_val))

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.position_y.attribute.input_offset.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.position_y.attribute.input_offset.min', float(new_val))


class RootLuAnalog_hi_res_inPosition_yAttributeCalib_polarity(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        negative = 1
        positive = 0

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.position_y.attribute.calib_polarity'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value(self) -> ValueEnum:
        return RootLuAnalog_hi_res_inPosition_yAttributeCalib_polarity.ValueEnum(self._context.get('root.lu.analog_hi_res_in.position_y.attribute.calib_polarity.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.lu.analog_hi_res_in.position_y.attribute.calib_polarity.value_raw', new_val.value)

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.lu.analog_hi_res_in.position_y.attribute.calib_polarity.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.lu.analog_hi_res_in.position_y.attribute.calib_polarity.value_raw', int(new_val))

    @property
    def enum(self) -> list:
        return list(self._context.get('root.lu.analog_hi_res_in.position_y.attribute.calib_polarity.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.lu.analog_hi_res_in.position_y.attribute.calib_polarity.enum', list(new_val))


class RootLuAnalog_hi_res_inPosition_yAttributeCalib_offset(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.position_y.attribute.calib_offset'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.position_y.attribute.calib_offset.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.position_y.attribute.calib_offset.value', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.position_y.attribute.calib_offset.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.position_y.attribute.calib_offset.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.analog_hi_res_in.position_y.attribute.calib_offset.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.analog_hi_res_in.position_y.attribute.calib_offset.unit', str(new_val))

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.position_y.attribute.calib_offset.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.position_y.attribute.calib_offset.min', float(new_val))


class RootLuAnalog_hi_res_inPosition_yAttributeFilter_number(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.position_y.attribute.filter_number'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.position_y.attribute.filter_number.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.position_y.attribute.filter_number.value', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.position_y.attribute.filter_number.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.position_y.attribute.filter_number.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.analog_hi_res_in.position_y.attribute.filter_number.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.analog_hi_res_in.position_y.attribute.filter_number.unit', str(new_val))

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.position_y.attribute.filter_number.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.position_y.attribute.filter_number.min', float(new_val))


class RootLuAnalog_hi_res_inPosition_yAttributeCalib_gain(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.position_y.attribute.calib_gain'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.position_y.attribute.calib_gain.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.position_y.attribute.calib_gain.value', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.position_y.attribute.calib_gain.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.position_y.attribute.calib_gain.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.analog_hi_res_in.position_y.attribute.calib_gain.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.analog_hi_res_in.position_y.attribute.calib_gain.unit', str(new_val))

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.position_y.attribute.calib_gain.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.position_y.attribute.calib_gain.min', float(new_val))


class RootLuAnalog_hi_res_inPosition_yAttribute(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.position_y.attribute'
        self.calib_gain = RootLuAnalog_hi_res_inPosition_yAttributeCalib_gain(self._context)
        self.filter_number = RootLuAnalog_hi_res_inPosition_yAttributeFilter_number(self._context)
        self.calib_offset = RootLuAnalog_hi_res_inPosition_yAttributeCalib_offset(self._context)
        self.calib_polarity = RootLuAnalog_hi_res_inPosition_yAttributeCalib_polarity(self._context)
        self.input_offset = RootLuAnalog_hi_res_inPosition_yAttributeInput_offset(self._context)
        self.filter_coeff_vec = RootLuAnalog_hi_res_inPosition_yAttributeFilter_coeff_vec(self._context)
        self.current_input_value = RootLuAnalog_hi_res_inPosition_yAttributeCurrent_input_value(self._context)
        self.input_gain = RootLuAnalog_hi_res_inPosition_yAttributeInput_gain(self._context)
        self.cross_coupling_axis_coefficient_vec = RootLuAnalog_hi_res_inPosition_yAttributeCross_coupling_axis_coefficient_vec(self._context)
        self.filter_mode = RootLuAnalog_hi_res_inPosition_yAttributeFilter_mode(self._context)
        self.cross_coupling_axis_id = RootLuAnalog_hi_res_inPosition_yAttributeCross_coupling_axis_id(self._context)


class RootLuAnalog_hi_res_inPosition_yBusy(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.position_y.busy'


class RootLuAnalog_hi_res_inPosition_y(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.position_y'
        self.busy = RootLuAnalog_hi_res_inPosition_yBusy(self._context)
        self.attribute = RootLuAnalog_hi_res_inPosition_yAttribute(self._context)
        self.trigger = RootLuAnalog_hi_res_inPosition_yTrigger(self._context)


class RootLuAnalog_hi_res_inLateralTrigger(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.lateral.trigger'


class RootLuAnalog_hi_res_inLateralAttributeCross_coupling_axis_id(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        position_x = 0
        position_w = 3
        self = 4
        position_y = 1
        position_z = 2

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.lateral.attribute.cross_coupling_axis_id'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value(self) -> ValueEnum:
        return RootLuAnalog_hi_res_inLateralAttributeCross_coupling_axis_id.ValueEnum(self._context.get('root.lu.analog_hi_res_in.lateral.attribute.cross_coupling_axis_id.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.lu.analog_hi_res_in.lateral.attribute.cross_coupling_axis_id.value_raw', new_val.value)

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.lu.analog_hi_res_in.lateral.attribute.cross_coupling_axis_id.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.lu.analog_hi_res_in.lateral.attribute.cross_coupling_axis_id.value_raw', int(new_val))

    @property
    def enum(self) -> list:
        return list(self._context.get('root.lu.analog_hi_res_in.lateral.attribute.cross_coupling_axis_id.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.lu.analog_hi_res_in.lateral.attribute.cross_coupling_axis_id.enum', list(new_val))


class RootLuAnalog_hi_res_inLateralAttributeFilter_mode(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        low_pass_filter = 1
        no_filter = 0

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.lateral.attribute.filter_mode'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value(self) -> ValueEnum:
        return RootLuAnalog_hi_res_inLateralAttributeFilter_mode.ValueEnum(self._context.get('root.lu.analog_hi_res_in.lateral.attribute.filter_mode.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.lu.analog_hi_res_in.lateral.attribute.filter_mode.value_raw', new_val.value)

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.lu.analog_hi_res_in.lateral.attribute.filter_mode.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.lu.analog_hi_res_in.lateral.attribute.filter_mode.value_raw', int(new_val))

    @property
    def enum(self) -> list:
        return list(self._context.get('root.lu.analog_hi_res_in.lateral.attribute.filter_mode.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.lu.analog_hi_res_in.lateral.attribute.filter_mode.enum', list(new_val))


class RootLuAnalog_hi_res_inLateralAttributeCross_coupling_axis_coefficient_vec(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.lateral.attribute.cross_coupling_axis_coefficient_vec'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def vector(self) -> list:
        return list(self._context.get('root.lu.analog_hi_res_in.lateral.attribute.cross_coupling_axis_coefficient_vec.vector'))

    @vector.setter
    def vector(self, new_val:list):
        self._context.set('root.lu.analog_hi_res_in.lateral.attribute.cross_coupling_axis_coefficient_vec.vector', list(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.lateral.attribute.cross_coupling_axis_coefficient_vec.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.lateral.attribute.cross_coupling_axis_coefficient_vec.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.analog_hi_res_in.lateral.attribute.cross_coupling_axis_coefficient_vec.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.analog_hi_res_in.lateral.attribute.cross_coupling_axis_coefficient_vec.unit', str(new_val))

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.lateral.attribute.cross_coupling_axis_coefficient_vec.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.lateral.attribute.cross_coupling_axis_coefficient_vec.min', float(new_val))


class RootLuAnalog_hi_res_inLateralAttributeInput_gain(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.lateral.attribute.input_gain'


class RootLuAnalog_hi_res_inLateralAttributeCurrent_input_value(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.lateral.attribute.current_input_value'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.lateral.attribute.current_input_value.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.lateral.attribute.current_input_value.value', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.lateral.attribute.current_input_value.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.lateral.attribute.current_input_value.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.analog_hi_res_in.lateral.attribute.current_input_value.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.analog_hi_res_in.lateral.attribute.current_input_value.unit', str(new_val))

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.lateral.attribute.current_input_value.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.lateral.attribute.current_input_value.min', float(new_val))


class RootLuAnalog_hi_res_inLateralAttributeFilter_coeff_vec(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.lateral.attribute.filter_coeff_vec'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def vector(self) -> list:
        return list(self._context.get('root.lu.analog_hi_res_in.lateral.attribute.filter_coeff_vec.vector'))

    @vector.setter
    def vector(self, new_val:list):
        self._context.set('root.lu.analog_hi_res_in.lateral.attribute.filter_coeff_vec.vector', list(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.lateral.attribute.filter_coeff_vec.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.lateral.attribute.filter_coeff_vec.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.analog_hi_res_in.lateral.attribute.filter_coeff_vec.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.analog_hi_res_in.lateral.attribute.filter_coeff_vec.unit', str(new_val))

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.lateral.attribute.filter_coeff_vec.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.lateral.attribute.filter_coeff_vec.min', float(new_val))


class RootLuAnalog_hi_res_inLateralAttributeInput_offset(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.lateral.attribute.input_offset'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.lateral.attribute.input_offset.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.lateral.attribute.input_offset.value', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.lateral.attribute.input_offset.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.lateral.attribute.input_offset.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.analog_hi_res_in.lateral.attribute.input_offset.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.analog_hi_res_in.lateral.attribute.input_offset.unit', str(new_val))

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.lateral.attribute.input_offset.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.lateral.attribute.input_offset.min', float(new_val))


class RootLuAnalog_hi_res_inLateralAttributeCalib_polarity(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        negative = 1
        positive = 0

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.lateral.attribute.calib_polarity'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value(self) -> ValueEnum:
        return RootLuAnalog_hi_res_inLateralAttributeCalib_polarity.ValueEnum(self._context.get('root.lu.analog_hi_res_in.lateral.attribute.calib_polarity.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.lu.analog_hi_res_in.lateral.attribute.calib_polarity.value_raw', new_val.value)

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.lu.analog_hi_res_in.lateral.attribute.calib_polarity.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.lu.analog_hi_res_in.lateral.attribute.calib_polarity.value_raw', int(new_val))

    @property
    def enum(self) -> list:
        return list(self._context.get('root.lu.analog_hi_res_in.lateral.attribute.calib_polarity.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.lu.analog_hi_res_in.lateral.attribute.calib_polarity.enum', list(new_val))


class RootLuAnalog_hi_res_inLateralAttributeCalib_offset(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.lateral.attribute.calib_offset'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.lateral.attribute.calib_offset.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.lateral.attribute.calib_offset.value', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.lateral.attribute.calib_offset.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.lateral.attribute.calib_offset.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.analog_hi_res_in.lateral.attribute.calib_offset.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.analog_hi_res_in.lateral.attribute.calib_offset.unit', str(new_val))

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.lateral.attribute.calib_offset.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.lateral.attribute.calib_offset.min', float(new_val))


class RootLuAnalog_hi_res_inLateralAttributeFilter_number(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.lateral.attribute.filter_number'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.lateral.attribute.filter_number.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.lateral.attribute.filter_number.value', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.lateral.attribute.filter_number.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.lateral.attribute.filter_number.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.analog_hi_res_in.lateral.attribute.filter_number.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.analog_hi_res_in.lateral.attribute.filter_number.unit', str(new_val))

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.lateral.attribute.filter_number.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.lateral.attribute.filter_number.min', float(new_val))


class RootLuAnalog_hi_res_inLateralAttributeCalib_gain(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.lateral.attribute.calib_gain'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.lateral.attribute.calib_gain.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.lateral.attribute.calib_gain.value', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.lateral.attribute.calib_gain.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.lateral.attribute.calib_gain.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.analog_hi_res_in.lateral.attribute.calib_gain.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.analog_hi_res_in.lateral.attribute.calib_gain.unit', str(new_val))

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.lateral.attribute.calib_gain.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.lateral.attribute.calib_gain.min', float(new_val))


class RootLuAnalog_hi_res_inLateralAttribute(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.lateral.attribute'
        self.calib_gain = RootLuAnalog_hi_res_inLateralAttributeCalib_gain(self._context)
        self.filter_number = RootLuAnalog_hi_res_inLateralAttributeFilter_number(self._context)
        self.calib_offset = RootLuAnalog_hi_res_inLateralAttributeCalib_offset(self._context)
        self.calib_polarity = RootLuAnalog_hi_res_inLateralAttributeCalib_polarity(self._context)
        self.input_offset = RootLuAnalog_hi_res_inLateralAttributeInput_offset(self._context)
        self.filter_coeff_vec = RootLuAnalog_hi_res_inLateralAttributeFilter_coeff_vec(self._context)
        self.current_input_value = RootLuAnalog_hi_res_inLateralAttributeCurrent_input_value(self._context)
        self.input_gain = RootLuAnalog_hi_res_inLateralAttributeInput_gain(self._context)
        self.cross_coupling_axis_coefficient_vec = RootLuAnalog_hi_res_inLateralAttributeCross_coupling_axis_coefficient_vec(self._context)
        self.filter_mode = RootLuAnalog_hi_res_inLateralAttributeFilter_mode(self._context)
        self.cross_coupling_axis_id = RootLuAnalog_hi_res_inLateralAttributeCross_coupling_axis_id(self._context)


class RootLuAnalog_hi_res_inLateralBusy(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.lateral.busy'


class RootLuAnalog_hi_res_inLateral(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.lateral'
        self.busy = RootLuAnalog_hi_res_inLateralBusy(self._context)
        self.attribute = RootLuAnalog_hi_res_inLateralAttribute(self._context)
        self.trigger = RootLuAnalog_hi_res_inLateralTrigger(self._context)


class RootLuAnalog_hi_res_inTip_currentTrigger(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.tip_current.trigger'


class RootLuAnalog_hi_res_inTip_currentAttributeCross_coupling_axis_id(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        position_x = 0
        position_w = 3
        self = 4
        position_y = 1
        position_z = 2

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.tip_current.attribute.cross_coupling_axis_id'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value(self) -> ValueEnum:
        return RootLuAnalog_hi_res_inTip_currentAttributeCross_coupling_axis_id.ValueEnum(self._context.get('root.lu.analog_hi_res_in.tip_current.attribute.cross_coupling_axis_id.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.lu.analog_hi_res_in.tip_current.attribute.cross_coupling_axis_id.value_raw', new_val.value)

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.lu.analog_hi_res_in.tip_current.attribute.cross_coupling_axis_id.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.lu.analog_hi_res_in.tip_current.attribute.cross_coupling_axis_id.value_raw', int(new_val))

    @property
    def enum(self) -> list:
        return list(self._context.get('root.lu.analog_hi_res_in.tip_current.attribute.cross_coupling_axis_id.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.lu.analog_hi_res_in.tip_current.attribute.cross_coupling_axis_id.enum', list(new_val))


class RootLuAnalog_hi_res_inTip_currentAttributeFilter_mode(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        low_pass_filter = 1
        no_filter = 0

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.tip_current.attribute.filter_mode'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value(self) -> ValueEnum:
        return RootLuAnalog_hi_res_inTip_currentAttributeFilter_mode.ValueEnum(self._context.get('root.lu.analog_hi_res_in.tip_current.attribute.filter_mode.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.lu.analog_hi_res_in.tip_current.attribute.filter_mode.value_raw', new_val.value)

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.lu.analog_hi_res_in.tip_current.attribute.filter_mode.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.lu.analog_hi_res_in.tip_current.attribute.filter_mode.value_raw', int(new_val))

    @property
    def enum(self) -> list:
        return list(self._context.get('root.lu.analog_hi_res_in.tip_current.attribute.filter_mode.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.lu.analog_hi_res_in.tip_current.attribute.filter_mode.enum', list(new_val))


class RootLuAnalog_hi_res_inTip_currentAttributeCross_coupling_axis_coefficient_vec(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.tip_current.attribute.cross_coupling_axis_coefficient_vec'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def vector(self) -> list:
        return list(self._context.get('root.lu.analog_hi_res_in.tip_current.attribute.cross_coupling_axis_coefficient_vec.vector'))

    @vector.setter
    def vector(self, new_val:list):
        self._context.set('root.lu.analog_hi_res_in.tip_current.attribute.cross_coupling_axis_coefficient_vec.vector', list(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.tip_current.attribute.cross_coupling_axis_coefficient_vec.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.tip_current.attribute.cross_coupling_axis_coefficient_vec.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.analog_hi_res_in.tip_current.attribute.cross_coupling_axis_coefficient_vec.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.analog_hi_res_in.tip_current.attribute.cross_coupling_axis_coefficient_vec.unit', str(new_val))

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.tip_current.attribute.cross_coupling_axis_coefficient_vec.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.tip_current.attribute.cross_coupling_axis_coefficient_vec.min', float(new_val))


class RootLuAnalog_hi_res_inTip_currentAttributeInput_gain(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.tip_current.attribute.input_gain'


class RootLuAnalog_hi_res_inTip_currentAttributeCurrent_input_value(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.tip_current.attribute.current_input_value'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.tip_current.attribute.current_input_value.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.tip_current.attribute.current_input_value.value', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.tip_current.attribute.current_input_value.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.tip_current.attribute.current_input_value.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.analog_hi_res_in.tip_current.attribute.current_input_value.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.analog_hi_res_in.tip_current.attribute.current_input_value.unit', str(new_val))

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.tip_current.attribute.current_input_value.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.tip_current.attribute.current_input_value.min', float(new_val))


class RootLuAnalog_hi_res_inTip_currentAttributeFilter_coeff_vec(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.tip_current.attribute.filter_coeff_vec'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def vector(self) -> list:
        return list(self._context.get('root.lu.analog_hi_res_in.tip_current.attribute.filter_coeff_vec.vector'))

    @vector.setter
    def vector(self, new_val:list):
        self._context.set('root.lu.analog_hi_res_in.tip_current.attribute.filter_coeff_vec.vector', list(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.tip_current.attribute.filter_coeff_vec.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.tip_current.attribute.filter_coeff_vec.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.analog_hi_res_in.tip_current.attribute.filter_coeff_vec.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.analog_hi_res_in.tip_current.attribute.filter_coeff_vec.unit', str(new_val))

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.tip_current.attribute.filter_coeff_vec.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.tip_current.attribute.filter_coeff_vec.min', float(new_val))


class RootLuAnalog_hi_res_inTip_currentAttributeInput_offset(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.tip_current.attribute.input_offset'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.tip_current.attribute.input_offset.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.tip_current.attribute.input_offset.value', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.tip_current.attribute.input_offset.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.tip_current.attribute.input_offset.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.analog_hi_res_in.tip_current.attribute.input_offset.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.analog_hi_res_in.tip_current.attribute.input_offset.unit', str(new_val))

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.tip_current.attribute.input_offset.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.tip_current.attribute.input_offset.min', float(new_val))


class RootLuAnalog_hi_res_inTip_currentAttributeCalib_polarity(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        negative = 1
        positive = 0

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.tip_current.attribute.calib_polarity'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value(self) -> ValueEnum:
        return RootLuAnalog_hi_res_inTip_currentAttributeCalib_polarity.ValueEnum(self._context.get('root.lu.analog_hi_res_in.tip_current.attribute.calib_polarity.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.lu.analog_hi_res_in.tip_current.attribute.calib_polarity.value_raw', new_val.value)

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.lu.analog_hi_res_in.tip_current.attribute.calib_polarity.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.lu.analog_hi_res_in.tip_current.attribute.calib_polarity.value_raw', int(new_val))

    @property
    def enum(self) -> list:
        return list(self._context.get('root.lu.analog_hi_res_in.tip_current.attribute.calib_polarity.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.lu.analog_hi_res_in.tip_current.attribute.calib_polarity.enum', list(new_val))


class RootLuAnalog_hi_res_inTip_currentAttributeCalib_offset(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.tip_current.attribute.calib_offset'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.tip_current.attribute.calib_offset.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.tip_current.attribute.calib_offset.value', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.tip_current.attribute.calib_offset.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.tip_current.attribute.calib_offset.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.analog_hi_res_in.tip_current.attribute.calib_offset.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.analog_hi_res_in.tip_current.attribute.calib_offset.unit', str(new_val))

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.tip_current.attribute.calib_offset.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.tip_current.attribute.calib_offset.min', float(new_val))


class RootLuAnalog_hi_res_inTip_currentAttributeFilter_number(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.tip_current.attribute.filter_number'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.tip_current.attribute.filter_number.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.tip_current.attribute.filter_number.value', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.tip_current.attribute.filter_number.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.tip_current.attribute.filter_number.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.analog_hi_res_in.tip_current.attribute.filter_number.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.analog_hi_res_in.tip_current.attribute.filter_number.unit', str(new_val))

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.tip_current.attribute.filter_number.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.tip_current.attribute.filter_number.min', float(new_val))


class RootLuAnalog_hi_res_inTip_currentAttributeCalib_gain(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.tip_current.attribute.calib_gain'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.tip_current.attribute.calib_gain.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.tip_current.attribute.calib_gain.value', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.tip_current.attribute.calib_gain.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.tip_current.attribute.calib_gain.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.analog_hi_res_in.tip_current.attribute.calib_gain.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.analog_hi_res_in.tip_current.attribute.calib_gain.unit', str(new_val))

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.tip_current.attribute.calib_gain.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.tip_current.attribute.calib_gain.min', float(new_val))


class RootLuAnalog_hi_res_inTip_currentAttribute(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.tip_current.attribute'
        self.calib_gain = RootLuAnalog_hi_res_inTip_currentAttributeCalib_gain(self._context)
        self.filter_number = RootLuAnalog_hi_res_inTip_currentAttributeFilter_number(self._context)
        self.calib_offset = RootLuAnalog_hi_res_inTip_currentAttributeCalib_offset(self._context)
        self.calib_polarity = RootLuAnalog_hi_res_inTip_currentAttributeCalib_polarity(self._context)
        self.input_offset = RootLuAnalog_hi_res_inTip_currentAttributeInput_offset(self._context)
        self.filter_coeff_vec = RootLuAnalog_hi_res_inTip_currentAttributeFilter_coeff_vec(self._context)
        self.current_input_value = RootLuAnalog_hi_res_inTip_currentAttributeCurrent_input_value(self._context)
        self.input_gain = RootLuAnalog_hi_res_inTip_currentAttributeInput_gain(self._context)
        self.cross_coupling_axis_coefficient_vec = RootLuAnalog_hi_res_inTip_currentAttributeCross_coupling_axis_coefficient_vec(self._context)
        self.filter_mode = RootLuAnalog_hi_res_inTip_currentAttributeFilter_mode(self._context)
        self.cross_coupling_axis_id = RootLuAnalog_hi_res_inTip_currentAttributeCross_coupling_axis_id(self._context)


class RootLuAnalog_hi_res_inTip_currentBusy(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.tip_current.busy'


class RootLuAnalog_hi_res_inTip_current(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.tip_current'
        self.busy = RootLuAnalog_hi_res_inTip_currentBusy(self._context)
        self.attribute = RootLuAnalog_hi_res_inTip_currentAttribute(self._context)
        self.trigger = RootLuAnalog_hi_res_inTip_currentTrigger(self._context)


class RootLuAnalog_hi_res_inUser1Trigger(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.user1.trigger'


class RootLuAnalog_hi_res_inUser1AttributeCross_coupling_axis_id(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        position_x = 0
        position_w = 3
        self = 4
        position_y = 1
        position_z = 2

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.user1.attribute.cross_coupling_axis_id'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value(self) -> ValueEnum:
        return RootLuAnalog_hi_res_inUser1AttributeCross_coupling_axis_id.ValueEnum(self._context.get('root.lu.analog_hi_res_in.user1.attribute.cross_coupling_axis_id.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.lu.analog_hi_res_in.user1.attribute.cross_coupling_axis_id.value_raw', new_val.value)

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.lu.analog_hi_res_in.user1.attribute.cross_coupling_axis_id.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.lu.analog_hi_res_in.user1.attribute.cross_coupling_axis_id.value_raw', int(new_val))

    @property
    def enum(self) -> list:
        return list(self._context.get('root.lu.analog_hi_res_in.user1.attribute.cross_coupling_axis_id.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.lu.analog_hi_res_in.user1.attribute.cross_coupling_axis_id.enum', list(new_val))


class RootLuAnalog_hi_res_inUser1AttributeFilter_mode(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        low_pass_filter = 1
        no_filter = 0

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.user1.attribute.filter_mode'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value(self) -> ValueEnum:
        return RootLuAnalog_hi_res_inUser1AttributeFilter_mode.ValueEnum(self._context.get('root.lu.analog_hi_res_in.user1.attribute.filter_mode.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.lu.analog_hi_res_in.user1.attribute.filter_mode.value_raw', new_val.value)

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.lu.analog_hi_res_in.user1.attribute.filter_mode.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.lu.analog_hi_res_in.user1.attribute.filter_mode.value_raw', int(new_val))

    @property
    def enum(self) -> list:
        return list(self._context.get('root.lu.analog_hi_res_in.user1.attribute.filter_mode.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.lu.analog_hi_res_in.user1.attribute.filter_mode.enum', list(new_val))


class RootLuAnalog_hi_res_inUser1AttributeCross_coupling_axis_coefficient_vec(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.user1.attribute.cross_coupling_axis_coefficient_vec'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def vector(self) -> list:
        return list(self._context.get('root.lu.analog_hi_res_in.user1.attribute.cross_coupling_axis_coefficient_vec.vector'))

    @vector.setter
    def vector(self, new_val:list):
        self._context.set('root.lu.analog_hi_res_in.user1.attribute.cross_coupling_axis_coefficient_vec.vector', list(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.user1.attribute.cross_coupling_axis_coefficient_vec.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.user1.attribute.cross_coupling_axis_coefficient_vec.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.analog_hi_res_in.user1.attribute.cross_coupling_axis_coefficient_vec.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.analog_hi_res_in.user1.attribute.cross_coupling_axis_coefficient_vec.unit', str(new_val))

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.user1.attribute.cross_coupling_axis_coefficient_vec.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.user1.attribute.cross_coupling_axis_coefficient_vec.min', float(new_val))


class RootLuAnalog_hi_res_inUser1AttributeInput_gain(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.user1.attribute.input_gain'


class RootLuAnalog_hi_res_inUser1AttributeCurrent_input_value(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.user1.attribute.current_input_value'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.user1.attribute.current_input_value.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.user1.attribute.current_input_value.value', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.user1.attribute.current_input_value.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.user1.attribute.current_input_value.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.analog_hi_res_in.user1.attribute.current_input_value.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.analog_hi_res_in.user1.attribute.current_input_value.unit', str(new_val))

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.user1.attribute.current_input_value.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.user1.attribute.current_input_value.min', float(new_val))


class RootLuAnalog_hi_res_inUser1AttributeFilter_coeff_vec(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.user1.attribute.filter_coeff_vec'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def vector(self) -> list:
        return list(self._context.get('root.lu.analog_hi_res_in.user1.attribute.filter_coeff_vec.vector'))

    @vector.setter
    def vector(self, new_val:list):
        self._context.set('root.lu.analog_hi_res_in.user1.attribute.filter_coeff_vec.vector', list(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.user1.attribute.filter_coeff_vec.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.user1.attribute.filter_coeff_vec.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.analog_hi_res_in.user1.attribute.filter_coeff_vec.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.analog_hi_res_in.user1.attribute.filter_coeff_vec.unit', str(new_val))

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.user1.attribute.filter_coeff_vec.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.user1.attribute.filter_coeff_vec.min', float(new_val))


class RootLuAnalog_hi_res_inUser1AttributeInput_offset(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.user1.attribute.input_offset'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.user1.attribute.input_offset.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.user1.attribute.input_offset.value', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.user1.attribute.input_offset.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.user1.attribute.input_offset.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.analog_hi_res_in.user1.attribute.input_offset.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.analog_hi_res_in.user1.attribute.input_offset.unit', str(new_val))

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.user1.attribute.input_offset.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.user1.attribute.input_offset.min', float(new_val))


class RootLuAnalog_hi_res_inUser1AttributeCalib_polarity(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        negative = 1
        positive = 0

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.user1.attribute.calib_polarity'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value(self) -> ValueEnum:
        return RootLuAnalog_hi_res_inUser1AttributeCalib_polarity.ValueEnum(self._context.get('root.lu.analog_hi_res_in.user1.attribute.calib_polarity.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.lu.analog_hi_res_in.user1.attribute.calib_polarity.value_raw', new_val.value)

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.lu.analog_hi_res_in.user1.attribute.calib_polarity.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.lu.analog_hi_res_in.user1.attribute.calib_polarity.value_raw', int(new_val))

    @property
    def enum(self) -> list:
        return list(self._context.get('root.lu.analog_hi_res_in.user1.attribute.calib_polarity.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.lu.analog_hi_res_in.user1.attribute.calib_polarity.enum', list(new_val))


class RootLuAnalog_hi_res_inUser1AttributeCalib_offset(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.user1.attribute.calib_offset'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.user1.attribute.calib_offset.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.user1.attribute.calib_offset.value', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.user1.attribute.calib_offset.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.user1.attribute.calib_offset.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.analog_hi_res_in.user1.attribute.calib_offset.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.analog_hi_res_in.user1.attribute.calib_offset.unit', str(new_val))

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.user1.attribute.calib_offset.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.user1.attribute.calib_offset.min', float(new_val))


class RootLuAnalog_hi_res_inUser1AttributeFilter_number(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.user1.attribute.filter_number'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.user1.attribute.filter_number.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.user1.attribute.filter_number.value', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.user1.attribute.filter_number.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.user1.attribute.filter_number.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.analog_hi_res_in.user1.attribute.filter_number.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.analog_hi_res_in.user1.attribute.filter_number.unit', str(new_val))

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.user1.attribute.filter_number.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.user1.attribute.filter_number.min', float(new_val))


class RootLuAnalog_hi_res_inUser1AttributeCalib_gain(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.user1.attribute.calib_gain'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.user1.attribute.calib_gain.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.user1.attribute.calib_gain.value', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.user1.attribute.calib_gain.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.user1.attribute.calib_gain.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.analog_hi_res_in.user1.attribute.calib_gain.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.analog_hi_res_in.user1.attribute.calib_gain.unit', str(new_val))

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.user1.attribute.calib_gain.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.user1.attribute.calib_gain.min', float(new_val))


class RootLuAnalog_hi_res_inUser1Attribute(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.user1.attribute'
        self.calib_gain = RootLuAnalog_hi_res_inUser1AttributeCalib_gain(self._context)
        self.filter_number = RootLuAnalog_hi_res_inUser1AttributeFilter_number(self._context)
        self.calib_offset = RootLuAnalog_hi_res_inUser1AttributeCalib_offset(self._context)
        self.calib_polarity = RootLuAnalog_hi_res_inUser1AttributeCalib_polarity(self._context)
        self.input_offset = RootLuAnalog_hi_res_inUser1AttributeInput_offset(self._context)
        self.filter_coeff_vec = RootLuAnalog_hi_res_inUser1AttributeFilter_coeff_vec(self._context)
        self.current_input_value = RootLuAnalog_hi_res_inUser1AttributeCurrent_input_value(self._context)
        self.input_gain = RootLuAnalog_hi_res_inUser1AttributeInput_gain(self._context)
        self.cross_coupling_axis_coefficient_vec = RootLuAnalog_hi_res_inUser1AttributeCross_coupling_axis_coefficient_vec(self._context)
        self.filter_mode = RootLuAnalog_hi_res_inUser1AttributeFilter_mode(self._context)
        self.cross_coupling_axis_id = RootLuAnalog_hi_res_inUser1AttributeCross_coupling_axis_id(self._context)


class RootLuAnalog_hi_res_inUser1Busy(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.user1.busy'


class RootLuAnalog_hi_res_inUser1(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.user1'
        self.busy = RootLuAnalog_hi_res_inUser1Busy(self._context)
        self.attribute = RootLuAnalog_hi_res_inUser1Attribute(self._context)
        self.trigger = RootLuAnalog_hi_res_inUser1Trigger(self._context)


class RootLuAnalog_hi_res_inDeflectionTrigger(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.deflection.trigger'


class RootLuAnalog_hi_res_inDeflectionAttributeCross_coupling_axis_id(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        position_x = 0
        position_w = 3
        self = 4
        position_y = 1
        position_z = 2

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.deflection.attribute.cross_coupling_axis_id'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value(self) -> ValueEnum:
        return RootLuAnalog_hi_res_inDeflectionAttributeCross_coupling_axis_id.ValueEnum(self._context.get('root.lu.analog_hi_res_in.deflection.attribute.cross_coupling_axis_id.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.lu.analog_hi_res_in.deflection.attribute.cross_coupling_axis_id.value_raw', new_val.value)

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.lu.analog_hi_res_in.deflection.attribute.cross_coupling_axis_id.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.lu.analog_hi_res_in.deflection.attribute.cross_coupling_axis_id.value_raw', int(new_val))

    @property
    def enum(self) -> list:
        return list(self._context.get('root.lu.analog_hi_res_in.deflection.attribute.cross_coupling_axis_id.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.lu.analog_hi_res_in.deflection.attribute.cross_coupling_axis_id.enum', list(new_val))


class RootLuAnalog_hi_res_inDeflectionAttributeFilter_mode(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        low_pass_filter = 1
        no_filter = 0

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.deflection.attribute.filter_mode'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value(self) -> ValueEnum:
        return RootLuAnalog_hi_res_inDeflectionAttributeFilter_mode.ValueEnum(self._context.get('root.lu.analog_hi_res_in.deflection.attribute.filter_mode.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.lu.analog_hi_res_in.deflection.attribute.filter_mode.value_raw', new_val.value)

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.lu.analog_hi_res_in.deflection.attribute.filter_mode.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.lu.analog_hi_res_in.deflection.attribute.filter_mode.value_raw', int(new_val))

    @property
    def enum(self) -> list:
        return list(self._context.get('root.lu.analog_hi_res_in.deflection.attribute.filter_mode.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.lu.analog_hi_res_in.deflection.attribute.filter_mode.enum', list(new_val))


class RootLuAnalog_hi_res_inDeflectionAttributeCross_coupling_axis_coefficient_vec(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.deflection.attribute.cross_coupling_axis_coefficient_vec'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def vector(self) -> list:
        return list(self._context.get('root.lu.analog_hi_res_in.deflection.attribute.cross_coupling_axis_coefficient_vec.vector'))

    @vector.setter
    def vector(self, new_val:list):
        self._context.set('root.lu.analog_hi_res_in.deflection.attribute.cross_coupling_axis_coefficient_vec.vector', list(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.deflection.attribute.cross_coupling_axis_coefficient_vec.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.deflection.attribute.cross_coupling_axis_coefficient_vec.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.analog_hi_res_in.deflection.attribute.cross_coupling_axis_coefficient_vec.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.analog_hi_res_in.deflection.attribute.cross_coupling_axis_coefficient_vec.unit', str(new_val))

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.deflection.attribute.cross_coupling_axis_coefficient_vec.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.deflection.attribute.cross_coupling_axis_coefficient_vec.min', float(new_val))


class RootLuAnalog_hi_res_inDeflectionAttributeInput_gain(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.deflection.attribute.input_gain'


class RootLuAnalog_hi_res_inDeflectionAttributeCurrent_input_value(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.deflection.attribute.current_input_value'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.deflection.attribute.current_input_value.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.deflection.attribute.current_input_value.value', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.deflection.attribute.current_input_value.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.deflection.attribute.current_input_value.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.analog_hi_res_in.deflection.attribute.current_input_value.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.analog_hi_res_in.deflection.attribute.current_input_value.unit', str(new_val))

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.deflection.attribute.current_input_value.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.deflection.attribute.current_input_value.min', float(new_val))


class RootLuAnalog_hi_res_inDeflectionAttributeFilter_coeff_vec(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.deflection.attribute.filter_coeff_vec'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def vector(self) -> list:
        return list(self._context.get('root.lu.analog_hi_res_in.deflection.attribute.filter_coeff_vec.vector'))

    @vector.setter
    def vector(self, new_val:list):
        self._context.set('root.lu.analog_hi_res_in.deflection.attribute.filter_coeff_vec.vector', list(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.deflection.attribute.filter_coeff_vec.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.deflection.attribute.filter_coeff_vec.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.analog_hi_res_in.deflection.attribute.filter_coeff_vec.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.analog_hi_res_in.deflection.attribute.filter_coeff_vec.unit', str(new_val))

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.deflection.attribute.filter_coeff_vec.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.deflection.attribute.filter_coeff_vec.min', float(new_val))


class RootLuAnalog_hi_res_inDeflectionAttributeInput_offset(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.deflection.attribute.input_offset'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.deflection.attribute.input_offset.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.deflection.attribute.input_offset.value', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.deflection.attribute.input_offset.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.deflection.attribute.input_offset.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.analog_hi_res_in.deflection.attribute.input_offset.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.analog_hi_res_in.deflection.attribute.input_offset.unit', str(new_val))

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.deflection.attribute.input_offset.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.deflection.attribute.input_offset.min', float(new_val))


class RootLuAnalog_hi_res_inDeflectionAttributeCalib_polarity(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        negative = 1
        positive = 0

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.deflection.attribute.calib_polarity'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value(self) -> ValueEnum:
        return RootLuAnalog_hi_res_inDeflectionAttributeCalib_polarity.ValueEnum(self._context.get('root.lu.analog_hi_res_in.deflection.attribute.calib_polarity.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.lu.analog_hi_res_in.deflection.attribute.calib_polarity.value_raw', new_val.value)

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.lu.analog_hi_res_in.deflection.attribute.calib_polarity.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.lu.analog_hi_res_in.deflection.attribute.calib_polarity.value_raw', int(new_val))

    @property
    def enum(self) -> list:
        return list(self._context.get('root.lu.analog_hi_res_in.deflection.attribute.calib_polarity.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.lu.analog_hi_res_in.deflection.attribute.calib_polarity.enum', list(new_val))


class RootLuAnalog_hi_res_inDeflectionAttributeCalib_offset(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.deflection.attribute.calib_offset'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.deflection.attribute.calib_offset.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.deflection.attribute.calib_offset.value', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.deflection.attribute.calib_offset.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.deflection.attribute.calib_offset.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.analog_hi_res_in.deflection.attribute.calib_offset.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.analog_hi_res_in.deflection.attribute.calib_offset.unit', str(new_val))

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.deflection.attribute.calib_offset.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.deflection.attribute.calib_offset.min', float(new_val))


class RootLuAnalog_hi_res_inDeflectionAttributeFilter_number(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.deflection.attribute.filter_number'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.deflection.attribute.filter_number.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.deflection.attribute.filter_number.value', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.deflection.attribute.filter_number.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.deflection.attribute.filter_number.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.analog_hi_res_in.deflection.attribute.filter_number.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.analog_hi_res_in.deflection.attribute.filter_number.unit', str(new_val))

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.deflection.attribute.filter_number.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.deflection.attribute.filter_number.min', float(new_val))


class RootLuAnalog_hi_res_inDeflectionAttributeCalib_gain(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.deflection.attribute.calib_gain'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.deflection.attribute.calib_gain.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.deflection.attribute.calib_gain.value', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.deflection.attribute.calib_gain.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.deflection.attribute.calib_gain.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.analog_hi_res_in.deflection.attribute.calib_gain.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.analog_hi_res_in.deflection.attribute.calib_gain.unit', str(new_val))

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.deflection.attribute.calib_gain.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.deflection.attribute.calib_gain.min', float(new_val))


class RootLuAnalog_hi_res_inDeflectionAttribute(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.deflection.attribute'
        self.calib_gain = RootLuAnalog_hi_res_inDeflectionAttributeCalib_gain(self._context)
        self.filter_number = RootLuAnalog_hi_res_inDeflectionAttributeFilter_number(self._context)
        self.calib_offset = RootLuAnalog_hi_res_inDeflectionAttributeCalib_offset(self._context)
        self.calib_polarity = RootLuAnalog_hi_res_inDeflectionAttributeCalib_polarity(self._context)
        self.input_offset = RootLuAnalog_hi_res_inDeflectionAttributeInput_offset(self._context)
        self.filter_coeff_vec = RootLuAnalog_hi_res_inDeflectionAttributeFilter_coeff_vec(self._context)
        self.current_input_value = RootLuAnalog_hi_res_inDeflectionAttributeCurrent_input_value(self._context)
        self.input_gain = RootLuAnalog_hi_res_inDeflectionAttributeInput_gain(self._context)
        self.cross_coupling_axis_coefficient_vec = RootLuAnalog_hi_res_inDeflectionAttributeCross_coupling_axis_coefficient_vec(self._context)
        self.filter_mode = RootLuAnalog_hi_res_inDeflectionAttributeFilter_mode(self._context)
        self.cross_coupling_axis_id = RootLuAnalog_hi_res_inDeflectionAttributeCross_coupling_axis_id(self._context)


class RootLuAnalog_hi_res_inDeflectionBusy(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.deflection.busy'


class RootLuAnalog_hi_res_inDeflection(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.deflection'
        self.busy = RootLuAnalog_hi_res_inDeflectionBusy(self._context)
        self.attribute = RootLuAnalog_hi_res_inDeflectionAttribute(self._context)
        self.trigger = RootLuAnalog_hi_res_inDeflectionTrigger(self._context)


class RootLuAnalog_hi_res_inUser2Trigger(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.user2.trigger'


class RootLuAnalog_hi_res_inUser2AttributeCross_coupling_axis_id(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        position_x = 0
        position_w = 3
        self = 4
        position_y = 1
        position_z = 2

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.user2.attribute.cross_coupling_axis_id'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value(self) -> ValueEnum:
        return RootLuAnalog_hi_res_inUser2AttributeCross_coupling_axis_id.ValueEnum(self._context.get('root.lu.analog_hi_res_in.user2.attribute.cross_coupling_axis_id.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.lu.analog_hi_res_in.user2.attribute.cross_coupling_axis_id.value_raw', new_val.value)

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.lu.analog_hi_res_in.user2.attribute.cross_coupling_axis_id.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.lu.analog_hi_res_in.user2.attribute.cross_coupling_axis_id.value_raw', int(new_val))

    @property
    def enum(self) -> list:
        return list(self._context.get('root.lu.analog_hi_res_in.user2.attribute.cross_coupling_axis_id.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.lu.analog_hi_res_in.user2.attribute.cross_coupling_axis_id.enum', list(new_val))


class RootLuAnalog_hi_res_inUser2AttributeFilter_mode(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        low_pass_filter = 1
        no_filter = 0

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.user2.attribute.filter_mode'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value(self) -> ValueEnum:
        return RootLuAnalog_hi_res_inUser2AttributeFilter_mode.ValueEnum(self._context.get('root.lu.analog_hi_res_in.user2.attribute.filter_mode.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.lu.analog_hi_res_in.user2.attribute.filter_mode.value_raw', new_val.value)

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.lu.analog_hi_res_in.user2.attribute.filter_mode.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.lu.analog_hi_res_in.user2.attribute.filter_mode.value_raw', int(new_val))

    @property
    def enum(self) -> list:
        return list(self._context.get('root.lu.analog_hi_res_in.user2.attribute.filter_mode.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.lu.analog_hi_res_in.user2.attribute.filter_mode.enum', list(new_val))


class RootLuAnalog_hi_res_inUser2AttributeCross_coupling_axis_coefficient_vec(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.user2.attribute.cross_coupling_axis_coefficient_vec'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def vector(self) -> list:
        return list(self._context.get('root.lu.analog_hi_res_in.user2.attribute.cross_coupling_axis_coefficient_vec.vector'))

    @vector.setter
    def vector(self, new_val:list):
        self._context.set('root.lu.analog_hi_res_in.user2.attribute.cross_coupling_axis_coefficient_vec.vector', list(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.user2.attribute.cross_coupling_axis_coefficient_vec.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.user2.attribute.cross_coupling_axis_coefficient_vec.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.analog_hi_res_in.user2.attribute.cross_coupling_axis_coefficient_vec.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.analog_hi_res_in.user2.attribute.cross_coupling_axis_coefficient_vec.unit', str(new_val))

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.user2.attribute.cross_coupling_axis_coefficient_vec.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.user2.attribute.cross_coupling_axis_coefficient_vec.min', float(new_val))


class RootLuAnalog_hi_res_inUser2AttributeInput_gain(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.user2.attribute.input_gain'


class RootLuAnalog_hi_res_inUser2AttributeCurrent_input_value(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.user2.attribute.current_input_value'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.user2.attribute.current_input_value.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.user2.attribute.current_input_value.value', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.user2.attribute.current_input_value.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.user2.attribute.current_input_value.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.analog_hi_res_in.user2.attribute.current_input_value.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.analog_hi_res_in.user2.attribute.current_input_value.unit', str(new_val))

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.user2.attribute.current_input_value.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.user2.attribute.current_input_value.min', float(new_val))


class RootLuAnalog_hi_res_inUser2AttributeFilter_coeff_vec(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.user2.attribute.filter_coeff_vec'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def vector(self) -> list:
        return list(self._context.get('root.lu.analog_hi_res_in.user2.attribute.filter_coeff_vec.vector'))

    @vector.setter
    def vector(self, new_val:list):
        self._context.set('root.lu.analog_hi_res_in.user2.attribute.filter_coeff_vec.vector', list(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.user2.attribute.filter_coeff_vec.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.user2.attribute.filter_coeff_vec.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.analog_hi_res_in.user2.attribute.filter_coeff_vec.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.analog_hi_res_in.user2.attribute.filter_coeff_vec.unit', str(new_val))

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.user2.attribute.filter_coeff_vec.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.user2.attribute.filter_coeff_vec.min', float(new_val))


class RootLuAnalog_hi_res_inUser2AttributeInput_offset(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.user2.attribute.input_offset'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.user2.attribute.input_offset.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.user2.attribute.input_offset.value', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.user2.attribute.input_offset.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.user2.attribute.input_offset.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.analog_hi_res_in.user2.attribute.input_offset.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.analog_hi_res_in.user2.attribute.input_offset.unit', str(new_val))

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.user2.attribute.input_offset.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.user2.attribute.input_offset.min', float(new_val))


class RootLuAnalog_hi_res_inUser2AttributeCalib_polarity(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        negative = 1
        positive = 0

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.user2.attribute.calib_polarity'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value(self) -> ValueEnum:
        return RootLuAnalog_hi_res_inUser2AttributeCalib_polarity.ValueEnum(self._context.get('root.lu.analog_hi_res_in.user2.attribute.calib_polarity.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.lu.analog_hi_res_in.user2.attribute.calib_polarity.value_raw', new_val.value)

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.lu.analog_hi_res_in.user2.attribute.calib_polarity.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.lu.analog_hi_res_in.user2.attribute.calib_polarity.value_raw', int(new_val))

    @property
    def enum(self) -> list:
        return list(self._context.get('root.lu.analog_hi_res_in.user2.attribute.calib_polarity.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.lu.analog_hi_res_in.user2.attribute.calib_polarity.enum', list(new_val))


class RootLuAnalog_hi_res_inUser2AttributeCalib_offset(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.user2.attribute.calib_offset'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.user2.attribute.calib_offset.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.user2.attribute.calib_offset.value', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.user2.attribute.calib_offset.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.user2.attribute.calib_offset.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.analog_hi_res_in.user2.attribute.calib_offset.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.analog_hi_res_in.user2.attribute.calib_offset.unit', str(new_val))

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.user2.attribute.calib_offset.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.user2.attribute.calib_offset.min', float(new_val))


class RootLuAnalog_hi_res_inUser2AttributeFilter_number(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.user2.attribute.filter_number'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.user2.attribute.filter_number.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.user2.attribute.filter_number.value', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.user2.attribute.filter_number.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.user2.attribute.filter_number.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.analog_hi_res_in.user2.attribute.filter_number.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.analog_hi_res_in.user2.attribute.filter_number.unit', str(new_val))

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.user2.attribute.filter_number.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.user2.attribute.filter_number.min', float(new_val))


class RootLuAnalog_hi_res_inUser2AttributeCalib_gain(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.user2.attribute.calib_gain'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.user2.attribute.calib_gain.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.user2.attribute.calib_gain.value', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.user2.attribute.calib_gain.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.user2.attribute.calib_gain.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.analog_hi_res_in.user2.attribute.calib_gain.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.analog_hi_res_in.user2.attribute.calib_gain.unit', str(new_val))

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.user2.attribute.calib_gain.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.user2.attribute.calib_gain.min', float(new_val))


class RootLuAnalog_hi_res_inUser2Attribute(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.user2.attribute'
        self.calib_gain = RootLuAnalog_hi_res_inUser2AttributeCalib_gain(self._context)
        self.filter_number = RootLuAnalog_hi_res_inUser2AttributeFilter_number(self._context)
        self.calib_offset = RootLuAnalog_hi_res_inUser2AttributeCalib_offset(self._context)
        self.calib_polarity = RootLuAnalog_hi_res_inUser2AttributeCalib_polarity(self._context)
        self.input_offset = RootLuAnalog_hi_res_inUser2AttributeInput_offset(self._context)
        self.filter_coeff_vec = RootLuAnalog_hi_res_inUser2AttributeFilter_coeff_vec(self._context)
        self.current_input_value = RootLuAnalog_hi_res_inUser2AttributeCurrent_input_value(self._context)
        self.input_gain = RootLuAnalog_hi_res_inUser2AttributeInput_gain(self._context)
        self.cross_coupling_axis_coefficient_vec = RootLuAnalog_hi_res_inUser2AttributeCross_coupling_axis_coefficient_vec(self._context)
        self.filter_mode = RootLuAnalog_hi_res_inUser2AttributeFilter_mode(self._context)
        self.cross_coupling_axis_id = RootLuAnalog_hi_res_inUser2AttributeCross_coupling_axis_id(self._context)


class RootLuAnalog_hi_res_inUser2Busy(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.user2.busy'


class RootLuAnalog_hi_res_inUser2(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.user2'
        self.busy = RootLuAnalog_hi_res_inUser2Busy(self._context)
        self.attribute = RootLuAnalog_hi_res_inUser2Attribute(self._context)
        self.trigger = RootLuAnalog_hi_res_inUser2Trigger(self._context)


class RootLuAnalog_hi_res_inPosition_zTrigger(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.position_z.trigger'


class RootLuAnalog_hi_res_inPosition_zAttributeCross_coupling_axis_id(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        position_x = 0
        position_w = 3
        self = 4
        position_y = 1
        position_z = 2

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.position_z.attribute.cross_coupling_axis_id'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value(self) -> ValueEnum:
        return RootLuAnalog_hi_res_inPosition_zAttributeCross_coupling_axis_id.ValueEnum(self._context.get('root.lu.analog_hi_res_in.position_z.attribute.cross_coupling_axis_id.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.lu.analog_hi_res_in.position_z.attribute.cross_coupling_axis_id.value_raw', new_val.value)

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.lu.analog_hi_res_in.position_z.attribute.cross_coupling_axis_id.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.lu.analog_hi_res_in.position_z.attribute.cross_coupling_axis_id.value_raw', int(new_val))

    @property
    def enum(self) -> list:
        return list(self._context.get('root.lu.analog_hi_res_in.position_z.attribute.cross_coupling_axis_id.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.lu.analog_hi_res_in.position_z.attribute.cross_coupling_axis_id.enum', list(new_val))


class RootLuAnalog_hi_res_inPosition_zAttributeFilter_mode(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        low_pass_filter = 1
        no_filter = 0

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.position_z.attribute.filter_mode'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value(self) -> ValueEnum:
        return RootLuAnalog_hi_res_inPosition_zAttributeFilter_mode.ValueEnum(self._context.get('root.lu.analog_hi_res_in.position_z.attribute.filter_mode.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.lu.analog_hi_res_in.position_z.attribute.filter_mode.value_raw', new_val.value)

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.lu.analog_hi_res_in.position_z.attribute.filter_mode.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.lu.analog_hi_res_in.position_z.attribute.filter_mode.value_raw', int(new_val))

    @property
    def enum(self) -> list:
        return list(self._context.get('root.lu.analog_hi_res_in.position_z.attribute.filter_mode.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.lu.analog_hi_res_in.position_z.attribute.filter_mode.enum', list(new_val))


class RootLuAnalog_hi_res_inPosition_zAttributeCross_coupling_axis_coefficient_vec(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.position_z.attribute.cross_coupling_axis_coefficient_vec'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def vector(self) -> list:
        return list(self._context.get('root.lu.analog_hi_res_in.position_z.attribute.cross_coupling_axis_coefficient_vec.vector'))

    @vector.setter
    def vector(self, new_val:list):
        self._context.set('root.lu.analog_hi_res_in.position_z.attribute.cross_coupling_axis_coefficient_vec.vector', list(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.position_z.attribute.cross_coupling_axis_coefficient_vec.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.position_z.attribute.cross_coupling_axis_coefficient_vec.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.analog_hi_res_in.position_z.attribute.cross_coupling_axis_coefficient_vec.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.analog_hi_res_in.position_z.attribute.cross_coupling_axis_coefficient_vec.unit', str(new_val))

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.position_z.attribute.cross_coupling_axis_coefficient_vec.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.position_z.attribute.cross_coupling_axis_coefficient_vec.min', float(new_val))


class RootLuAnalog_hi_res_inPosition_zAttributeInput_gain(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.position_z.attribute.input_gain'


class RootLuAnalog_hi_res_inPosition_zAttributeCurrent_input_value(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.position_z.attribute.current_input_value'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.position_z.attribute.current_input_value.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.position_z.attribute.current_input_value.value', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.position_z.attribute.current_input_value.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.position_z.attribute.current_input_value.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.analog_hi_res_in.position_z.attribute.current_input_value.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.analog_hi_res_in.position_z.attribute.current_input_value.unit', str(new_val))

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.position_z.attribute.current_input_value.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.position_z.attribute.current_input_value.min', float(new_val))


class RootLuAnalog_hi_res_inPosition_zAttributeFilter_coeff_vec(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.position_z.attribute.filter_coeff_vec'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def vector(self) -> list:
        return list(self._context.get('root.lu.analog_hi_res_in.position_z.attribute.filter_coeff_vec.vector'))

    @vector.setter
    def vector(self, new_val:list):
        self._context.set('root.lu.analog_hi_res_in.position_z.attribute.filter_coeff_vec.vector', list(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.position_z.attribute.filter_coeff_vec.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.position_z.attribute.filter_coeff_vec.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.analog_hi_res_in.position_z.attribute.filter_coeff_vec.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.analog_hi_res_in.position_z.attribute.filter_coeff_vec.unit', str(new_val))

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.position_z.attribute.filter_coeff_vec.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.position_z.attribute.filter_coeff_vec.min', float(new_val))


class RootLuAnalog_hi_res_inPosition_zAttributeInput_offset(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.position_z.attribute.input_offset'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.position_z.attribute.input_offset.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.position_z.attribute.input_offset.value', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.position_z.attribute.input_offset.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.position_z.attribute.input_offset.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.analog_hi_res_in.position_z.attribute.input_offset.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.analog_hi_res_in.position_z.attribute.input_offset.unit', str(new_val))

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.position_z.attribute.input_offset.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.position_z.attribute.input_offset.min', float(new_val))


class RootLuAnalog_hi_res_inPosition_zAttributeCalib_polarity(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        negative = 1
        positive = 0

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.position_z.attribute.calib_polarity'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value(self) -> ValueEnum:
        return RootLuAnalog_hi_res_inPosition_zAttributeCalib_polarity.ValueEnum(self._context.get('root.lu.analog_hi_res_in.position_z.attribute.calib_polarity.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.lu.analog_hi_res_in.position_z.attribute.calib_polarity.value_raw', new_val.value)

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.lu.analog_hi_res_in.position_z.attribute.calib_polarity.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.lu.analog_hi_res_in.position_z.attribute.calib_polarity.value_raw', int(new_val))

    @property
    def enum(self) -> list:
        return list(self._context.get('root.lu.analog_hi_res_in.position_z.attribute.calib_polarity.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.lu.analog_hi_res_in.position_z.attribute.calib_polarity.enum', list(new_val))


class RootLuAnalog_hi_res_inPosition_zAttributeCalib_offset(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.position_z.attribute.calib_offset'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.position_z.attribute.calib_offset.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.position_z.attribute.calib_offset.value', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.position_z.attribute.calib_offset.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.position_z.attribute.calib_offset.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.analog_hi_res_in.position_z.attribute.calib_offset.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.analog_hi_res_in.position_z.attribute.calib_offset.unit', str(new_val))

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.position_z.attribute.calib_offset.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.position_z.attribute.calib_offset.min', float(new_val))


class RootLuAnalog_hi_res_inPosition_zAttributeFilter_number(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.position_z.attribute.filter_number'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.position_z.attribute.filter_number.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.position_z.attribute.filter_number.value', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.position_z.attribute.filter_number.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.position_z.attribute.filter_number.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.analog_hi_res_in.position_z.attribute.filter_number.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.analog_hi_res_in.position_z.attribute.filter_number.unit', str(new_val))

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.position_z.attribute.filter_number.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.position_z.attribute.filter_number.min', float(new_val))


class RootLuAnalog_hi_res_inPosition_zAttributeCalib_gain(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.position_z.attribute.calib_gain'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.position_z.attribute.calib_gain.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.position_z.attribute.calib_gain.value', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.position_z.attribute.calib_gain.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.position_z.attribute.calib_gain.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.analog_hi_res_in.position_z.attribute.calib_gain.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.analog_hi_res_in.position_z.attribute.calib_gain.unit', str(new_val))

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.position_z.attribute.calib_gain.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.position_z.attribute.calib_gain.min', float(new_val))


class RootLuAnalog_hi_res_inPosition_zAttribute(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.position_z.attribute'
        self.calib_gain = RootLuAnalog_hi_res_inPosition_zAttributeCalib_gain(self._context)
        self.filter_number = RootLuAnalog_hi_res_inPosition_zAttributeFilter_number(self._context)
        self.calib_offset = RootLuAnalog_hi_res_inPosition_zAttributeCalib_offset(self._context)
        self.calib_polarity = RootLuAnalog_hi_res_inPosition_zAttributeCalib_polarity(self._context)
        self.input_offset = RootLuAnalog_hi_res_inPosition_zAttributeInput_offset(self._context)
        self.filter_coeff_vec = RootLuAnalog_hi_res_inPosition_zAttributeFilter_coeff_vec(self._context)
        self.current_input_value = RootLuAnalog_hi_res_inPosition_zAttributeCurrent_input_value(self._context)
        self.input_gain = RootLuAnalog_hi_res_inPosition_zAttributeInput_gain(self._context)
        self.cross_coupling_axis_coefficient_vec = RootLuAnalog_hi_res_inPosition_zAttributeCross_coupling_axis_coefficient_vec(self._context)
        self.filter_mode = RootLuAnalog_hi_res_inPosition_zAttributeFilter_mode(self._context)
        self.cross_coupling_axis_id = RootLuAnalog_hi_res_inPosition_zAttributeCross_coupling_axis_id(self._context)


class RootLuAnalog_hi_res_inPosition_zBusy(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.position_z.busy'


class RootLuAnalog_hi_res_inPosition_z(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.position_z'
        self.busy = RootLuAnalog_hi_res_inPosition_zBusy(self._context)
        self.attribute = RootLuAnalog_hi_res_inPosition_zAttribute(self._context)
        self.trigger = RootLuAnalog_hi_res_inPosition_zTrigger(self._context)


class RootLuAnalog_hi_res_inUser4Trigger(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.user4.trigger'


class RootLuAnalog_hi_res_inUser4AttributeCross_coupling_axis_id(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        position_x = 0
        position_w = 3
        self = 4
        position_y = 1
        position_z = 2

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.user4.attribute.cross_coupling_axis_id'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value(self) -> ValueEnum:
        return RootLuAnalog_hi_res_inUser4AttributeCross_coupling_axis_id.ValueEnum(self._context.get('root.lu.analog_hi_res_in.user4.attribute.cross_coupling_axis_id.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.lu.analog_hi_res_in.user4.attribute.cross_coupling_axis_id.value_raw', new_val.value)

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.lu.analog_hi_res_in.user4.attribute.cross_coupling_axis_id.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.lu.analog_hi_res_in.user4.attribute.cross_coupling_axis_id.value_raw', int(new_val))

    @property
    def enum(self) -> list:
        return list(self._context.get('root.lu.analog_hi_res_in.user4.attribute.cross_coupling_axis_id.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.lu.analog_hi_res_in.user4.attribute.cross_coupling_axis_id.enum', list(new_val))


class RootLuAnalog_hi_res_inUser4AttributeFilter_mode(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        low_pass_filter = 1
        no_filter = 0

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.user4.attribute.filter_mode'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value(self) -> ValueEnum:
        return RootLuAnalog_hi_res_inUser4AttributeFilter_mode.ValueEnum(self._context.get('root.lu.analog_hi_res_in.user4.attribute.filter_mode.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.lu.analog_hi_res_in.user4.attribute.filter_mode.value_raw', new_val.value)

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.lu.analog_hi_res_in.user4.attribute.filter_mode.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.lu.analog_hi_res_in.user4.attribute.filter_mode.value_raw', int(new_val))

    @property
    def enum(self) -> list:
        return list(self._context.get('root.lu.analog_hi_res_in.user4.attribute.filter_mode.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.lu.analog_hi_res_in.user4.attribute.filter_mode.enum', list(new_val))


class RootLuAnalog_hi_res_inUser4AttributeCross_coupling_axis_coefficient_vec(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.user4.attribute.cross_coupling_axis_coefficient_vec'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def vector(self) -> list:
        return list(self._context.get('root.lu.analog_hi_res_in.user4.attribute.cross_coupling_axis_coefficient_vec.vector'))

    @vector.setter
    def vector(self, new_val:list):
        self._context.set('root.lu.analog_hi_res_in.user4.attribute.cross_coupling_axis_coefficient_vec.vector', list(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.user4.attribute.cross_coupling_axis_coefficient_vec.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.user4.attribute.cross_coupling_axis_coefficient_vec.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.analog_hi_res_in.user4.attribute.cross_coupling_axis_coefficient_vec.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.analog_hi_res_in.user4.attribute.cross_coupling_axis_coefficient_vec.unit', str(new_val))

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.user4.attribute.cross_coupling_axis_coefficient_vec.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.user4.attribute.cross_coupling_axis_coefficient_vec.min', float(new_val))


class RootLuAnalog_hi_res_inUser4AttributeInput_gain(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.user4.attribute.input_gain'


class RootLuAnalog_hi_res_inUser4AttributeCurrent_input_value(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.user4.attribute.current_input_value'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.user4.attribute.current_input_value.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.user4.attribute.current_input_value.value', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.user4.attribute.current_input_value.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.user4.attribute.current_input_value.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.analog_hi_res_in.user4.attribute.current_input_value.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.analog_hi_res_in.user4.attribute.current_input_value.unit', str(new_val))

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.user4.attribute.current_input_value.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.user4.attribute.current_input_value.min', float(new_val))


class RootLuAnalog_hi_res_inUser4AttributeFilter_coeff_vec(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.user4.attribute.filter_coeff_vec'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def vector(self) -> list:
        return list(self._context.get('root.lu.analog_hi_res_in.user4.attribute.filter_coeff_vec.vector'))

    @vector.setter
    def vector(self, new_val:list):
        self._context.set('root.lu.analog_hi_res_in.user4.attribute.filter_coeff_vec.vector', list(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.user4.attribute.filter_coeff_vec.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.user4.attribute.filter_coeff_vec.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.analog_hi_res_in.user4.attribute.filter_coeff_vec.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.analog_hi_res_in.user4.attribute.filter_coeff_vec.unit', str(new_val))

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.user4.attribute.filter_coeff_vec.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.user4.attribute.filter_coeff_vec.min', float(new_val))


class RootLuAnalog_hi_res_inUser4AttributeInput_offset(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.user4.attribute.input_offset'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.user4.attribute.input_offset.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.user4.attribute.input_offset.value', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.user4.attribute.input_offset.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.user4.attribute.input_offset.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.analog_hi_res_in.user4.attribute.input_offset.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.analog_hi_res_in.user4.attribute.input_offset.unit', str(new_val))

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.user4.attribute.input_offset.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.user4.attribute.input_offset.min', float(new_val))


class RootLuAnalog_hi_res_inUser4AttributeCalib_polarity(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        negative = 1
        positive = 0

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.user4.attribute.calib_polarity'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value(self) -> ValueEnum:
        return RootLuAnalog_hi_res_inUser4AttributeCalib_polarity.ValueEnum(self._context.get('root.lu.analog_hi_res_in.user4.attribute.calib_polarity.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.lu.analog_hi_res_in.user4.attribute.calib_polarity.value_raw', new_val.value)

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.lu.analog_hi_res_in.user4.attribute.calib_polarity.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.lu.analog_hi_res_in.user4.attribute.calib_polarity.value_raw', int(new_val))

    @property
    def enum(self) -> list:
        return list(self._context.get('root.lu.analog_hi_res_in.user4.attribute.calib_polarity.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.lu.analog_hi_res_in.user4.attribute.calib_polarity.enum', list(new_val))


class RootLuAnalog_hi_res_inUser4AttributeCalib_offset(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.user4.attribute.calib_offset'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.user4.attribute.calib_offset.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.user4.attribute.calib_offset.value', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.user4.attribute.calib_offset.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.user4.attribute.calib_offset.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.analog_hi_res_in.user4.attribute.calib_offset.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.analog_hi_res_in.user4.attribute.calib_offset.unit', str(new_val))

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.user4.attribute.calib_offset.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.user4.attribute.calib_offset.min', float(new_val))


class RootLuAnalog_hi_res_inUser4AttributeFilter_number(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.user4.attribute.filter_number'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.user4.attribute.filter_number.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.user4.attribute.filter_number.value', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.user4.attribute.filter_number.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.user4.attribute.filter_number.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.analog_hi_res_in.user4.attribute.filter_number.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.analog_hi_res_in.user4.attribute.filter_number.unit', str(new_val))

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.user4.attribute.filter_number.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.user4.attribute.filter_number.min', float(new_val))


class RootLuAnalog_hi_res_inUser4AttributeCalib_gain(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.user4.attribute.calib_gain'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.user4.attribute.calib_gain.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.user4.attribute.calib_gain.value', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.user4.attribute.calib_gain.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.user4.attribute.calib_gain.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.analog_hi_res_in.user4.attribute.calib_gain.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.analog_hi_res_in.user4.attribute.calib_gain.unit', str(new_val))

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.user4.attribute.calib_gain.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.user4.attribute.calib_gain.min', float(new_val))


class RootLuAnalog_hi_res_inUser4Attribute(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.user4.attribute'
        self.calib_gain = RootLuAnalog_hi_res_inUser4AttributeCalib_gain(self._context)
        self.filter_number = RootLuAnalog_hi_res_inUser4AttributeFilter_number(self._context)
        self.calib_offset = RootLuAnalog_hi_res_inUser4AttributeCalib_offset(self._context)
        self.calib_polarity = RootLuAnalog_hi_res_inUser4AttributeCalib_polarity(self._context)
        self.input_offset = RootLuAnalog_hi_res_inUser4AttributeInput_offset(self._context)
        self.filter_coeff_vec = RootLuAnalog_hi_res_inUser4AttributeFilter_coeff_vec(self._context)
        self.current_input_value = RootLuAnalog_hi_res_inUser4AttributeCurrent_input_value(self._context)
        self.input_gain = RootLuAnalog_hi_res_inUser4AttributeInput_gain(self._context)
        self.cross_coupling_axis_coefficient_vec = RootLuAnalog_hi_res_inUser4AttributeCross_coupling_axis_coefficient_vec(self._context)
        self.filter_mode = RootLuAnalog_hi_res_inUser4AttributeFilter_mode(self._context)
        self.cross_coupling_axis_id = RootLuAnalog_hi_res_inUser4AttributeCross_coupling_axis_id(self._context)


class RootLuAnalog_hi_res_inUser4Busy(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.user4.busy'


class RootLuAnalog_hi_res_inUser4(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.user4'
        self.busy = RootLuAnalog_hi_res_inUser4Busy(self._context)
        self.attribute = RootLuAnalog_hi_res_inUser4Attribute(self._context)
        self.trigger = RootLuAnalog_hi_res_inUser4Trigger(self._context)


class RootLuAnalog_hi_res_inUser3Trigger(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.user3.trigger'


class RootLuAnalog_hi_res_inUser3AttributeCross_coupling_axis_id(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        position_x = 0
        position_w = 3
        self = 4
        position_y = 1
        position_z = 2

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.user3.attribute.cross_coupling_axis_id'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value(self) -> ValueEnum:
        return RootLuAnalog_hi_res_inUser3AttributeCross_coupling_axis_id.ValueEnum(self._context.get('root.lu.analog_hi_res_in.user3.attribute.cross_coupling_axis_id.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.lu.analog_hi_res_in.user3.attribute.cross_coupling_axis_id.value_raw', new_val.value)

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.lu.analog_hi_res_in.user3.attribute.cross_coupling_axis_id.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.lu.analog_hi_res_in.user3.attribute.cross_coupling_axis_id.value_raw', int(new_val))

    @property
    def enum(self) -> list:
        return list(self._context.get('root.lu.analog_hi_res_in.user3.attribute.cross_coupling_axis_id.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.lu.analog_hi_res_in.user3.attribute.cross_coupling_axis_id.enum', list(new_val))


class RootLuAnalog_hi_res_inUser3AttributeFilter_mode(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        low_pass_filter = 1
        no_filter = 0

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.user3.attribute.filter_mode'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value(self) -> ValueEnum:
        return RootLuAnalog_hi_res_inUser3AttributeFilter_mode.ValueEnum(self._context.get('root.lu.analog_hi_res_in.user3.attribute.filter_mode.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.lu.analog_hi_res_in.user3.attribute.filter_mode.value_raw', new_val.value)

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.lu.analog_hi_res_in.user3.attribute.filter_mode.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.lu.analog_hi_res_in.user3.attribute.filter_mode.value_raw', int(new_val))

    @property
    def enum(self) -> list:
        return list(self._context.get('root.lu.analog_hi_res_in.user3.attribute.filter_mode.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.lu.analog_hi_res_in.user3.attribute.filter_mode.enum', list(new_val))


class RootLuAnalog_hi_res_inUser3AttributeCross_coupling_axis_coefficient_vec(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.user3.attribute.cross_coupling_axis_coefficient_vec'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def vector(self) -> list:
        return list(self._context.get('root.lu.analog_hi_res_in.user3.attribute.cross_coupling_axis_coefficient_vec.vector'))

    @vector.setter
    def vector(self, new_val:list):
        self._context.set('root.lu.analog_hi_res_in.user3.attribute.cross_coupling_axis_coefficient_vec.vector', list(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.user3.attribute.cross_coupling_axis_coefficient_vec.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.user3.attribute.cross_coupling_axis_coefficient_vec.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.analog_hi_res_in.user3.attribute.cross_coupling_axis_coefficient_vec.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.analog_hi_res_in.user3.attribute.cross_coupling_axis_coefficient_vec.unit', str(new_val))

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.user3.attribute.cross_coupling_axis_coefficient_vec.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.user3.attribute.cross_coupling_axis_coefficient_vec.min', float(new_val))


class RootLuAnalog_hi_res_inUser3AttributeInput_gain(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.user3.attribute.input_gain'


class RootLuAnalog_hi_res_inUser3AttributeCurrent_input_value(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.user3.attribute.current_input_value'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.user3.attribute.current_input_value.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.user3.attribute.current_input_value.value', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.user3.attribute.current_input_value.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.user3.attribute.current_input_value.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.analog_hi_res_in.user3.attribute.current_input_value.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.analog_hi_res_in.user3.attribute.current_input_value.unit', str(new_val))

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.user3.attribute.current_input_value.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.user3.attribute.current_input_value.min', float(new_val))


class RootLuAnalog_hi_res_inUser3AttributeFilter_coeff_vec(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.user3.attribute.filter_coeff_vec'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def vector(self) -> list:
        return list(self._context.get('root.lu.analog_hi_res_in.user3.attribute.filter_coeff_vec.vector'))

    @vector.setter
    def vector(self, new_val:list):
        self._context.set('root.lu.analog_hi_res_in.user3.attribute.filter_coeff_vec.vector', list(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.user3.attribute.filter_coeff_vec.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.user3.attribute.filter_coeff_vec.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.analog_hi_res_in.user3.attribute.filter_coeff_vec.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.analog_hi_res_in.user3.attribute.filter_coeff_vec.unit', str(new_val))

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.user3.attribute.filter_coeff_vec.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.user3.attribute.filter_coeff_vec.min', float(new_val))


class RootLuAnalog_hi_res_inUser3AttributeInput_offset(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.user3.attribute.input_offset'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.user3.attribute.input_offset.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.user3.attribute.input_offset.value', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.user3.attribute.input_offset.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.user3.attribute.input_offset.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.analog_hi_res_in.user3.attribute.input_offset.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.analog_hi_res_in.user3.attribute.input_offset.unit', str(new_val))

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.user3.attribute.input_offset.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.user3.attribute.input_offset.min', float(new_val))


class RootLuAnalog_hi_res_inUser3AttributeCalib_polarity(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        negative = 1
        positive = 0

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.user3.attribute.calib_polarity'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value(self) -> ValueEnum:
        return RootLuAnalog_hi_res_inUser3AttributeCalib_polarity.ValueEnum(self._context.get('root.lu.analog_hi_res_in.user3.attribute.calib_polarity.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.lu.analog_hi_res_in.user3.attribute.calib_polarity.value_raw', new_val.value)

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.lu.analog_hi_res_in.user3.attribute.calib_polarity.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.lu.analog_hi_res_in.user3.attribute.calib_polarity.value_raw', int(new_val))

    @property
    def enum(self) -> list:
        return list(self._context.get('root.lu.analog_hi_res_in.user3.attribute.calib_polarity.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.lu.analog_hi_res_in.user3.attribute.calib_polarity.enum', list(new_val))


class RootLuAnalog_hi_res_inUser3AttributeCalib_offset(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.user3.attribute.calib_offset'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.user3.attribute.calib_offset.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.user3.attribute.calib_offset.value', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.user3.attribute.calib_offset.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.user3.attribute.calib_offset.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.analog_hi_res_in.user3.attribute.calib_offset.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.analog_hi_res_in.user3.attribute.calib_offset.unit', str(new_val))

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.user3.attribute.calib_offset.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.user3.attribute.calib_offset.min', float(new_val))


class RootLuAnalog_hi_res_inUser3AttributeFilter_number(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.user3.attribute.filter_number'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.user3.attribute.filter_number.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.user3.attribute.filter_number.value', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.user3.attribute.filter_number.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.user3.attribute.filter_number.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.analog_hi_res_in.user3.attribute.filter_number.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.analog_hi_res_in.user3.attribute.filter_number.unit', str(new_val))

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.user3.attribute.filter_number.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.user3.attribute.filter_number.min', float(new_val))


class RootLuAnalog_hi_res_inUser3AttributeCalib_gain(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.user3.attribute.calib_gain'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.user3.attribute.calib_gain.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.user3.attribute.calib_gain.value', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.user3.attribute.calib_gain.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.user3.attribute.calib_gain.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.analog_hi_res_in.user3.attribute.calib_gain.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.analog_hi_res_in.user3.attribute.calib_gain.unit', str(new_val))

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.user3.attribute.calib_gain.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.user3.attribute.calib_gain.min', float(new_val))


class RootLuAnalog_hi_res_inUser3Attribute(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.user3.attribute'
        self.calib_gain = RootLuAnalog_hi_res_inUser3AttributeCalib_gain(self._context)
        self.filter_number = RootLuAnalog_hi_res_inUser3AttributeFilter_number(self._context)
        self.calib_offset = RootLuAnalog_hi_res_inUser3AttributeCalib_offset(self._context)
        self.calib_polarity = RootLuAnalog_hi_res_inUser3AttributeCalib_polarity(self._context)
        self.input_offset = RootLuAnalog_hi_res_inUser3AttributeInput_offset(self._context)
        self.filter_coeff_vec = RootLuAnalog_hi_res_inUser3AttributeFilter_coeff_vec(self._context)
        self.current_input_value = RootLuAnalog_hi_res_inUser3AttributeCurrent_input_value(self._context)
        self.input_gain = RootLuAnalog_hi_res_inUser3AttributeInput_gain(self._context)
        self.cross_coupling_axis_coefficient_vec = RootLuAnalog_hi_res_inUser3AttributeCross_coupling_axis_coefficient_vec(self._context)
        self.filter_mode = RootLuAnalog_hi_res_inUser3AttributeFilter_mode(self._context)
        self.cross_coupling_axis_id = RootLuAnalog_hi_res_inUser3AttributeCross_coupling_axis_id(self._context)


class RootLuAnalog_hi_res_inUser3Busy(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.user3.busy'


class RootLuAnalog_hi_res_inUser3(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.user3'
        self.busy = RootLuAnalog_hi_res_inUser3Busy(self._context)
        self.attribute = RootLuAnalog_hi_res_inUser3Attribute(self._context)
        self.trigger = RootLuAnalog_hi_res_inUser3Trigger(self._context)


class RootLuAnalog_hi_res_inPosition_xTrigger(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.position_x.trigger'


class RootLuAnalog_hi_res_inPosition_xAttributeCross_coupling_axis_id(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        position_x = 0
        position_w = 3
        self = 4
        position_y = 1
        position_z = 2

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.position_x.attribute.cross_coupling_axis_id'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value(self) -> ValueEnum:
        return RootLuAnalog_hi_res_inPosition_xAttributeCross_coupling_axis_id.ValueEnum(self._context.get('root.lu.analog_hi_res_in.position_x.attribute.cross_coupling_axis_id.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.lu.analog_hi_res_in.position_x.attribute.cross_coupling_axis_id.value_raw', new_val.value)

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.lu.analog_hi_res_in.position_x.attribute.cross_coupling_axis_id.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.lu.analog_hi_res_in.position_x.attribute.cross_coupling_axis_id.value_raw', int(new_val))

    @property
    def enum(self) -> list:
        return list(self._context.get('root.lu.analog_hi_res_in.position_x.attribute.cross_coupling_axis_id.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.lu.analog_hi_res_in.position_x.attribute.cross_coupling_axis_id.enum', list(new_val))


class RootLuAnalog_hi_res_inPosition_xAttributeFilter_mode(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        low_pass_filter = 1
        no_filter = 0

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.position_x.attribute.filter_mode'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value(self) -> ValueEnum:
        return RootLuAnalog_hi_res_inPosition_xAttributeFilter_mode.ValueEnum(self._context.get('root.lu.analog_hi_res_in.position_x.attribute.filter_mode.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.lu.analog_hi_res_in.position_x.attribute.filter_mode.value_raw', new_val.value)

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.lu.analog_hi_res_in.position_x.attribute.filter_mode.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.lu.analog_hi_res_in.position_x.attribute.filter_mode.value_raw', int(new_val))

    @property
    def enum(self) -> list:
        return list(self._context.get('root.lu.analog_hi_res_in.position_x.attribute.filter_mode.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.lu.analog_hi_res_in.position_x.attribute.filter_mode.enum', list(new_val))


class RootLuAnalog_hi_res_inPosition_xAttributeCross_coupling_axis_coefficient_vec(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.position_x.attribute.cross_coupling_axis_coefficient_vec'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def vector(self) -> list:
        return list(self._context.get('root.lu.analog_hi_res_in.position_x.attribute.cross_coupling_axis_coefficient_vec.vector'))

    @vector.setter
    def vector(self, new_val:list):
        self._context.set('root.lu.analog_hi_res_in.position_x.attribute.cross_coupling_axis_coefficient_vec.vector', list(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.position_x.attribute.cross_coupling_axis_coefficient_vec.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.position_x.attribute.cross_coupling_axis_coefficient_vec.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.analog_hi_res_in.position_x.attribute.cross_coupling_axis_coefficient_vec.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.analog_hi_res_in.position_x.attribute.cross_coupling_axis_coefficient_vec.unit', str(new_val))

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.position_x.attribute.cross_coupling_axis_coefficient_vec.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.position_x.attribute.cross_coupling_axis_coefficient_vec.min', float(new_val))


class RootLuAnalog_hi_res_inPosition_xAttributeInput_gain(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.position_x.attribute.input_gain'


class RootLuAnalog_hi_res_inPosition_xAttributeCurrent_input_value(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.position_x.attribute.current_input_value'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.position_x.attribute.current_input_value.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.position_x.attribute.current_input_value.value', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.position_x.attribute.current_input_value.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.position_x.attribute.current_input_value.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.analog_hi_res_in.position_x.attribute.current_input_value.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.analog_hi_res_in.position_x.attribute.current_input_value.unit', str(new_val))

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.position_x.attribute.current_input_value.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.position_x.attribute.current_input_value.min', float(new_val))


class RootLuAnalog_hi_res_inPosition_xAttributeFilter_coeff_vec(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.position_x.attribute.filter_coeff_vec'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def vector(self) -> list:
        return list(self._context.get('root.lu.analog_hi_res_in.position_x.attribute.filter_coeff_vec.vector'))

    @vector.setter
    def vector(self, new_val:list):
        self._context.set('root.lu.analog_hi_res_in.position_x.attribute.filter_coeff_vec.vector', list(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.position_x.attribute.filter_coeff_vec.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.position_x.attribute.filter_coeff_vec.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.analog_hi_res_in.position_x.attribute.filter_coeff_vec.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.analog_hi_res_in.position_x.attribute.filter_coeff_vec.unit', str(new_val))

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.position_x.attribute.filter_coeff_vec.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.position_x.attribute.filter_coeff_vec.min', float(new_val))


class RootLuAnalog_hi_res_inPosition_xAttributeInput_offset(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.position_x.attribute.input_offset'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.position_x.attribute.input_offset.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.position_x.attribute.input_offset.value', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.position_x.attribute.input_offset.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.position_x.attribute.input_offset.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.analog_hi_res_in.position_x.attribute.input_offset.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.analog_hi_res_in.position_x.attribute.input_offset.unit', str(new_val))

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.position_x.attribute.input_offset.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.position_x.attribute.input_offset.min', float(new_val))


class RootLuAnalog_hi_res_inPosition_xAttributeCalib_polarity(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        negative = 1
        positive = 0

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.position_x.attribute.calib_polarity'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value(self) -> ValueEnum:
        return RootLuAnalog_hi_res_inPosition_xAttributeCalib_polarity.ValueEnum(self._context.get('root.lu.analog_hi_res_in.position_x.attribute.calib_polarity.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.lu.analog_hi_res_in.position_x.attribute.calib_polarity.value_raw', new_val.value)

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.lu.analog_hi_res_in.position_x.attribute.calib_polarity.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.lu.analog_hi_res_in.position_x.attribute.calib_polarity.value_raw', int(new_val))

    @property
    def enum(self) -> list:
        return list(self._context.get('root.lu.analog_hi_res_in.position_x.attribute.calib_polarity.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.lu.analog_hi_res_in.position_x.attribute.calib_polarity.enum', list(new_val))


class RootLuAnalog_hi_res_inPosition_xAttributeCalib_offset(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.position_x.attribute.calib_offset'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.position_x.attribute.calib_offset.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.position_x.attribute.calib_offset.value', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.position_x.attribute.calib_offset.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.position_x.attribute.calib_offset.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.analog_hi_res_in.position_x.attribute.calib_offset.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.analog_hi_res_in.position_x.attribute.calib_offset.unit', str(new_val))

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.position_x.attribute.calib_offset.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.position_x.attribute.calib_offset.min', float(new_val))


class RootLuAnalog_hi_res_inPosition_xAttributeFilter_number(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.position_x.attribute.filter_number'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.position_x.attribute.filter_number.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.position_x.attribute.filter_number.value', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.position_x.attribute.filter_number.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.position_x.attribute.filter_number.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.analog_hi_res_in.position_x.attribute.filter_number.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.analog_hi_res_in.position_x.attribute.filter_number.unit', str(new_val))

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.position_x.attribute.filter_number.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.position_x.attribute.filter_number.min', float(new_val))


class RootLuAnalog_hi_res_inPosition_xAttributeCalib_gain(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.position_x.attribute.calib_gain'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.position_x.attribute.calib_gain.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.position_x.attribute.calib_gain.value', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.position_x.attribute.calib_gain.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.position_x.attribute.calib_gain.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.analog_hi_res_in.position_x.attribute.calib_gain.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.analog_hi_res_in.position_x.attribute.calib_gain.unit', str(new_val))

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.position_x.attribute.calib_gain.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.position_x.attribute.calib_gain.min', float(new_val))


class RootLuAnalog_hi_res_inPosition_xAttribute(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.position_x.attribute'
        self.calib_gain = RootLuAnalog_hi_res_inPosition_xAttributeCalib_gain(self._context)
        self.filter_number = RootLuAnalog_hi_res_inPosition_xAttributeFilter_number(self._context)
        self.calib_offset = RootLuAnalog_hi_res_inPosition_xAttributeCalib_offset(self._context)
        self.calib_polarity = RootLuAnalog_hi_res_inPosition_xAttributeCalib_polarity(self._context)
        self.input_offset = RootLuAnalog_hi_res_inPosition_xAttributeInput_offset(self._context)
        self.filter_coeff_vec = RootLuAnalog_hi_res_inPosition_xAttributeFilter_coeff_vec(self._context)
        self.current_input_value = RootLuAnalog_hi_res_inPosition_xAttributeCurrent_input_value(self._context)
        self.input_gain = RootLuAnalog_hi_res_inPosition_xAttributeInput_gain(self._context)
        self.cross_coupling_axis_coefficient_vec = RootLuAnalog_hi_res_inPosition_xAttributeCross_coupling_axis_coefficient_vec(self._context)
        self.filter_mode = RootLuAnalog_hi_res_inPosition_xAttributeFilter_mode(self._context)
        self.cross_coupling_axis_id = RootLuAnalog_hi_res_inPosition_xAttributeCross_coupling_axis_id(self._context)


class RootLuAnalog_hi_res_inPosition_xBusy(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.position_x.busy'


class RootLuAnalog_hi_res_inPosition_x(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.position_x'
        self.busy = RootLuAnalog_hi_res_inPosition_xBusy(self._context)
        self.attribute = RootLuAnalog_hi_res_inPosition_xAttribute(self._context)
        self.trigger = RootLuAnalog_hi_res_inPosition_xTrigger(self._context)


class RootLuAnalog_hi_res_in(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in'
        self.position_x = RootLuAnalog_hi_res_inPosition_x(self._context)
        self.user3 = RootLuAnalog_hi_res_inUser3(self._context)
        self.user4 = RootLuAnalog_hi_res_inUser4(self._context)
        self.position_z = RootLuAnalog_hi_res_inPosition_z(self._context)
        self.user2 = RootLuAnalog_hi_res_inUser2(self._context)
        self.deflection = RootLuAnalog_hi_res_inDeflection(self._context)
        self.user1 = RootLuAnalog_hi_res_inUser1(self._context)
        self.tip_current = RootLuAnalog_hi_res_inTip_current(self._context)
        self.lateral = RootLuAnalog_hi_res_inLateral(self._context)
        self.position_y = RootLuAnalog_hi_res_inPosition_y(self._context)
        self.main2 = RootLuAnalog_hi_res_inMain2(self._context)
        self.in6 = RootLuAnalog_hi_res_inIn6(self._context)
        self.detector_sum = RootLuAnalog_hi_res_inDetector_sum(self._context)


class RootLuOrtInstanceTrigger(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ort.instance.trigger'

    def apply_samples_per_period(self) -> None:
        return self._context.call('root.lu.ort.instance.trigger.apply_samples_per_period')

    def update_free_wave(self) -> None:
        return self._context.call('root.lu.ort.instance.trigger.update_free_wave')

    def transfer_free_wave_data(self) -> None:
        return self._context.call('root.lu.ort.instance.trigger.transfer_free_wave_data')

    def apply_samples_values(self) -> None:
        return self._context.call('root.lu.ort.instance.trigger.apply_samples_values')


class RootLuOrtInstanceAttributeCantilever_samples_per_period(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        enabled = 1
        disabled = 0

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ort.instance.attribute.cantilever_samples_per_period'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> ValueEnum:
        return RootLuOrtInstanceAttributeCantilever_samples_per_period.ValueEnum(self._context.get('root.lu.ort.instance.attribute.cantilever_samples_per_period.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.lu.ort.instance.attribute.cantilever_samples_per_period.value_raw', new_val.value)

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.ort.instance.attribute.cantilever_samples_per_period.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.ort.instance.attribute.cantilever_samples_per_period.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.ort.instance.attribute.cantilever_samples_per_period.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.ort.instance.attribute.cantilever_samples_per_period.unit', str(new_val))

    @property
    def enum(self) -> list:
        return list(self._context.get('root.lu.ort.instance.attribute.cantilever_samples_per_period.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.lu.ort.instance.attribute.cantilever_samples_per_period.enum', list(new_val))

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.ort.instance.attribute.cantilever_samples_per_period.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.ort.instance.attribute.cantilever_samples_per_period.min', float(new_val))


class RootLuOrtInstanceAttributeExcitation_amplitude(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ort.instance.attribute.excitation_amplitude'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.ort.instance.attribute.excitation_amplitude.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.ort.instance.attribute.excitation_amplitude.value', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.ort.instance.attribute.excitation_amplitude.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.ort.instance.attribute.excitation_amplitude.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.ort.instance.attribute.excitation_amplitude.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.ort.instance.attribute.excitation_amplitude.unit', str(new_val))

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.ort.instance.attribute.excitation_amplitude.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.ort.instance.attribute.excitation_amplitude.min', float(new_val))


class RootLuOrtInstanceAttributeFree_wave_output_state(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        enabled = 1
        disabled = 0

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ort.instance.attribute.free_wave_output_state'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value(self) -> ValueEnum:
        return RootLuOrtInstanceAttributeFree_wave_output_state.ValueEnum(self._context.get('root.lu.ort.instance.attribute.free_wave_output_state.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.lu.ort.instance.attribute.free_wave_output_state.value_raw', new_val.value)

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.lu.ort.instance.attribute.free_wave_output_state.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.lu.ort.instance.attribute.free_wave_output_state.value_raw', int(new_val))

    @property
    def enum(self) -> list:
        return list(self._context.get('root.lu.ort.instance.attribute.free_wave_output_state.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.lu.ort.instance.attribute.free_wave_output_state.enum', list(new_val))


class RootLuOrtInstanceAttributeBaseline_window_end(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ort.instance.attribute.baseline_window_end'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.ort.instance.attribute.baseline_window_end.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.ort.instance.attribute.baseline_window_end.value', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.ort.instance.attribute.baseline_window_end.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.ort.instance.attribute.baseline_window_end.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.ort.instance.attribute.baseline_window_end.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.ort.instance.attribute.baseline_window_end.unit', str(new_val))

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.ort.instance.attribute.baseline_window_end.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.ort.instance.attribute.baseline_window_end.min', float(new_val))


class RootLuOrtInstanceAttributeInput_select(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        hi_res_in_user1 = 3
        hi_res_in_deflection = 1
        fast_in_user = 2
        fast_in_deflection = 0

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ort.instance.attribute.input_select'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value(self) -> ValueEnum:
        return RootLuOrtInstanceAttributeInput_select.ValueEnum(self._context.get('root.lu.ort.instance.attribute.input_select.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.lu.ort.instance.attribute.input_select.value_raw', new_val.value)

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.lu.ort.instance.attribute.input_select.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.lu.ort.instance.attribute.input_select.value_raw', int(new_val))

    @property
    def enum(self) -> list:
        return list(self._context.get('root.lu.ort.instance.attribute.input_select.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.lu.ort.instance.attribute.input_select.enum', list(new_val))


class RootLuOrtInstanceAttributeFree_wave_delay(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ort.instance.attribute.free_wave_delay'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.ort.instance.attribute.free_wave_delay.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.ort.instance.attribute.free_wave_delay.value', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.ort.instance.attribute.free_wave_delay.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.ort.instance.attribute.free_wave_delay.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.ort.instance.attribute.free_wave_delay.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.ort.instance.attribute.free_wave_delay.unit', str(new_val))

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.ort.instance.attribute.free_wave_delay.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.ort.instance.attribute.free_wave_delay.min', float(new_val))


class RootLuOrtInstanceAttributeFeedback_amplitude_position(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ort.instance.attribute.feedback_amplitude_position'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.ort.instance.attribute.feedback_amplitude_position.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.ort.instance.attribute.feedback_amplitude_position.value', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.ort.instance.attribute.feedback_amplitude_position.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.ort.instance.attribute.feedback_amplitude_position.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.ort.instance.attribute.feedback_amplitude_position.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.ort.instance.attribute.feedback_amplitude_position.unit', str(new_val))

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.ort.instance.attribute.feedback_amplitude_position.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.ort.instance.attribute.feedback_amplitude_position.min', float(new_val))


class RootLuOrtInstanceAttributeAmplitude_reduction(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ort.instance.attribute.amplitude_reduction'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.ort.instance.attribute.amplitude_reduction.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.ort.instance.attribute.amplitude_reduction.value', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.ort.instance.attribute.amplitude_reduction.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.ort.instance.attribute.amplitude_reduction.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.ort.instance.attribute.amplitude_reduction.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.ort.instance.attribute.amplitude_reduction.unit', str(new_val))

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.ort.instance.attribute.amplitude_reduction.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.ort.instance.attribute.amplitude_reduction.min', float(new_val))


class RootLuOrtInstanceAttributeBaseline_window_begin(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ort.instance.attribute.baseline_window_begin'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.ort.instance.attribute.baseline_window_begin.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.ort.instance.attribute.baseline_window_begin.value', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.ort.instance.attribute.baseline_window_begin.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.ort.instance.attribute.baseline_window_begin.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.ort.instance.attribute.baseline_window_begin.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.ort.instance.attribute.baseline_window_begin.unit', str(new_val))

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.ort.instance.attribute.baseline_window_begin.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.ort.instance.attribute.baseline_window_begin.min', float(new_val))


class RootLuOrtInstanceAttributeMin_position(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ort.instance.attribute.min_position'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.ort.instance.attribute.min_position.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.ort.instance.attribute.min_position.value', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.ort.instance.attribute.min_position.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.ort.instance.attribute.min_position.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.ort.instance.attribute.min_position.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.ort.instance.attribute.min_position.unit', str(new_val))

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.ort.instance.attribute.min_position.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.ort.instance.attribute.min_position.min', float(new_val))


class RootLuOrtInstanceAttributeMin_value(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ort.instance.attribute.min_value'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.ort.instance.attribute.min_value.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.ort.instance.attribute.min_value.value', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.ort.instance.attribute.min_value.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.ort.instance.attribute.min_value.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.ort.instance.attribute.min_value.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.ort.instance.attribute.min_value.unit', str(new_val))

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.ort.instance.attribute.min_value.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.ort.instance.attribute.min_value.min', float(new_val))


class RootLuOrtInstanceAttributeAverage_periods(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ort.instance.attribute.average_periods'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.ort.instance.attribute.average_periods.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.ort.instance.attribute.average_periods.value', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.ort.instance.attribute.average_periods.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.ort.instance.attribute.average_periods.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.ort.instance.attribute.average_periods.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.ort.instance.attribute.average_periods.unit', str(new_val))

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.ort.instance.attribute.average_periods.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.ort.instance.attribute.average_periods.min', float(new_val))


class RootLuOrtInstanceAttributeSamples_per_period(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ort.instance.attribute.samples_per_period'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.ort.instance.attribute.samples_per_period.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.ort.instance.attribute.samples_per_period.value', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.ort.instance.attribute.samples_per_period.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.ort.instance.attribute.samples_per_period.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.ort.instance.attribute.samples_per_period.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.ort.instance.attribute.samples_per_period.unit', str(new_val))

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.ort.instance.attribute.samples_per_period.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.ort.instance.attribute.samples_per_period.min', float(new_val))


class RootLuOrtInstanceAttributeBaseline_frequency(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ort.instance.attribute.baseline_frequency'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.ort.instance.attribute.baseline_frequency.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.ort.instance.attribute.baseline_frequency.value', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.ort.instance.attribute.baseline_frequency.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.ort.instance.attribute.baseline_frequency.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.ort.instance.attribute.baseline_frequency.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.ort.instance.attribute.baseline_frequency.unit', str(new_val))

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.ort.instance.attribute.baseline_frequency.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.ort.instance.attribute.baseline_frequency.min', float(new_val))


class RootLuOrtInstanceAttributeBaseline_controller_state(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        enabled = 1
        disabled = 0

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ort.instance.attribute.baseline_controller_state'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value(self) -> ValueEnum:
        return RootLuOrtInstanceAttributeBaseline_controller_state.ValueEnum(self._context.get('root.lu.ort.instance.attribute.baseline_controller_state.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.lu.ort.instance.attribute.baseline_controller_state.value_raw', new_val.value)

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.lu.ort.instance.attribute.baseline_controller_state.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.lu.ort.instance.attribute.baseline_controller_state.value_raw', int(new_val))

    @property
    def enum(self) -> list:
        return list(self._context.get('root.lu.ort.instance.attribute.baseline_controller_state.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.lu.ort.instance.attribute.baseline_controller_state.enum', list(new_val))


class RootLuOrtInstanceAttribute(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ort.instance.attribute'
        self.baseline_controller_state = RootLuOrtInstanceAttributeBaseline_controller_state(self._context)
        self.baseline_frequency = RootLuOrtInstanceAttributeBaseline_frequency(self._context)
        self.samples_per_period = RootLuOrtInstanceAttributeSamples_per_period(self._context)
        self.average_periods = RootLuOrtInstanceAttributeAverage_periods(self._context)
        self.min_value = RootLuOrtInstanceAttributeMin_value(self._context)
        self.min_position = RootLuOrtInstanceAttributeMin_position(self._context)
        self.baseline_window_begin = RootLuOrtInstanceAttributeBaseline_window_begin(self._context)
        self.amplitude_reduction = RootLuOrtInstanceAttributeAmplitude_reduction(self._context)
        self.feedback_amplitude_position = RootLuOrtInstanceAttributeFeedback_amplitude_position(self._context)
        self.free_wave_delay = RootLuOrtInstanceAttributeFree_wave_delay(self._context)
        self.input_select = RootLuOrtInstanceAttributeInput_select(self._context)
        self.baseline_window_end = RootLuOrtInstanceAttributeBaseline_window_end(self._context)
        self.free_wave_output_state = RootLuOrtInstanceAttributeFree_wave_output_state(self._context)
        self.excitation_amplitude = RootLuOrtInstanceAttributeExcitation_amplitude(self._context)
        self.cantilever_samples_per_period = RootLuOrtInstanceAttributeCantilever_samples_per_period(self._context)


class RootLuOrtInstanceBusy(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ort.instance.busy'

    @property
    def is_averaging(self) -> bool:
        return bool(self._context.call('root.lu.ort.instance.busy.is_averaging'))


class RootLuOrtInstance(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ort.instance'
        self.busy = RootLuOrtInstanceBusy(self._context)
        self.attribute = RootLuOrtInstanceAttribute(self._context)
        self.trigger = RootLuOrtInstanceTrigger(self._context)


class RootLuOrt(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ort'
        self.instance = RootLuOrtInstance(self._context)


class RootLuSignal_analyzerInst2Trigger(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.signal_analyzer.inst2.trigger'

    def start_kpfm_phase_calibration(self) -> None:
        return self._context.call('root.lu.signal_analyzer.inst2.trigger.start_kpfm_phase_calibration')

    def start_phase_zero_calibration(self) -> None:
        return self._context.call('root.lu.signal_analyzer.inst2.trigger.start_phase_zero_calibration')

    def user_abort(self) -> None:
        return self._context.call('root.lu.signal_analyzer.inst2.trigger.user_abort')

    def start_switch_to_target_amplitude_ctrl_set_point(self) -> None:
        return self._context.call('root.lu.signal_analyzer.inst2.trigger.start_switch_to_target_amplitude_ctrl_set_point')

    def start_update_current_free_amplitude(self) -> None:
        return self._context.call('root.lu.signal_analyzer.inst2.trigger.start_update_current_free_amplitude')

    def start_switch_to_target_amplitude_ctrl_mode(self) -> None:
        return self._context.call('root.lu.signal_analyzer.inst2.trigger.start_switch_to_target_amplitude_ctrl_mode')

    def switch_to_target_amplitude_ctrl_mode(self) -> None:
        return self._context.call('root.lu.signal_analyzer.inst2.trigger.switch_to_target_amplitude_ctrl_mode')

    def kpfm_phase_calibration(self) -> None:
        return self._context.call('root.lu.signal_analyzer.inst2.trigger.kpfm_phase_calibration')

    def switch_to_target_amplitude_ctrl_set_point(self) -> None:
        return self._context.call('root.lu.signal_analyzer.inst2.trigger.switch_to_target_amplitude_ctrl_set_point')


class RootLuSignal_analyzerInst2AttributePll_unlocked(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.signal_analyzer.inst2.attribute.pll_unlocked'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.signal_analyzer.inst2.attribute.pll_unlocked.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.signal_analyzer.inst2.attribute.pll_unlocked.value', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.signal_analyzer.inst2.attribute.pll_unlocked.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.signal_analyzer.inst2.attribute.pll_unlocked.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.signal_analyzer.inst2.attribute.pll_unlocked.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.signal_analyzer.inst2.attribute.pll_unlocked.unit', str(new_val))

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.signal_analyzer.inst2.attribute.pll_unlocked.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.signal_analyzer.inst2.attribute.pll_unlocked.min', float(new_val))


class RootLuSignal_analyzerInst2AttributeDelay_comp(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.signal_analyzer.inst2.attribute.delay_comp'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.signal_analyzer.inst2.attribute.delay_comp.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.signal_analyzer.inst2.attribute.delay_comp.value', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.signal_analyzer.inst2.attribute.delay_comp.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.signal_analyzer.inst2.attribute.delay_comp.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.signal_analyzer.inst2.attribute.delay_comp.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.signal_analyzer.inst2.attribute.delay_comp.unit', str(new_val))

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.signal_analyzer.inst2.attribute.delay_comp.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.signal_analyzer.inst2.attribute.delay_comp.min', float(new_val))


class RootLuSignal_analyzerInst2AttributeEnable_dc_block(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        enabled = 1
        disabled = 0

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.signal_analyzer.inst2.attribute.enable_dc_block'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value(self) -> ValueEnum:
        return RootLuSignal_analyzerInst2AttributeEnable_dc_block.ValueEnum(self._context.get('root.lu.signal_analyzer.inst2.attribute.enable_dc_block.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.lu.signal_analyzer.inst2.attribute.enable_dc_block.value_raw', new_val.value)

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.lu.signal_analyzer.inst2.attribute.enable_dc_block.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.lu.signal_analyzer.inst2.attribute.enable_dc_block.value_raw', int(new_val))

    @property
    def enum(self) -> list:
        return list(self._context.get('root.lu.signal_analyzer.inst2.attribute.enable_dc_block.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.lu.signal_analyzer.inst2.attribute.enable_dc_block.enum', list(new_val))


class RootLuSignal_analyzerInst2AttributeDisplay_df_range(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.signal_analyzer.inst2.attribute.display_df_range'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.signal_analyzer.inst2.attribute.display_df_range.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.signal_analyzer.inst2.attribute.display_df_range.value', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.signal_analyzer.inst2.attribute.display_df_range.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.signal_analyzer.inst2.attribute.display_df_range.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.signal_analyzer.inst2.attribute.display_df_range.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.signal_analyzer.inst2.attribute.display_df_range.unit', str(new_val))

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.signal_analyzer.inst2.attribute.display_df_range.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.signal_analyzer.inst2.attribute.display_df_range.min', float(new_val))


class RootLuSignal_analyzerInst2AttributeCurrent_amplitude_ctrl_set_point(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.signal_analyzer.inst2.attribute.current_amplitude_ctrl_set_point'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.signal_analyzer.inst2.attribute.current_amplitude_ctrl_set_point.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.signal_analyzer.inst2.attribute.current_amplitude_ctrl_set_point.value', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.signal_analyzer.inst2.attribute.current_amplitude_ctrl_set_point.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.signal_analyzer.inst2.attribute.current_amplitude_ctrl_set_point.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.signal_analyzer.inst2.attribute.current_amplitude_ctrl_set_point.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.signal_analyzer.inst2.attribute.current_amplitude_ctrl_set_point.unit', str(new_val))

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.signal_analyzer.inst2.attribute.current_amplitude_ctrl_set_point.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.signal_analyzer.inst2.attribute.current_amplitude_ctrl_set_point.min', float(new_val))


class RootLuSignal_analyzerInst2AttributePhase_lock_range(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.signal_analyzer.inst2.attribute.phase_lock_range'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.signal_analyzer.inst2.attribute.phase_lock_range.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.signal_analyzer.inst2.attribute.phase_lock_range.value', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.signal_analyzer.inst2.attribute.phase_lock_range.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.signal_analyzer.inst2.attribute.phase_lock_range.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.signal_analyzer.inst2.attribute.phase_lock_range.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.signal_analyzer.inst2.attribute.phase_lock_range.unit', str(new_val))

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.signal_analyzer.inst2.attribute.phase_lock_range.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.signal_analyzer.inst2.attribute.phase_lock_range.min', float(new_val))


class RootLuSignal_analyzerInst2AttributeCurrent_ctrl_amplitude(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.signal_analyzer.inst2.attribute.current_ctrl_amplitude'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.signal_analyzer.inst2.attribute.current_ctrl_amplitude.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.signal_analyzer.inst2.attribute.current_ctrl_amplitude.value', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.signal_analyzer.inst2.attribute.current_ctrl_amplitude.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.signal_analyzer.inst2.attribute.current_ctrl_amplitude.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.signal_analyzer.inst2.attribute.current_ctrl_amplitude.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.signal_analyzer.inst2.attribute.current_ctrl_amplitude.unit', str(new_val))

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.signal_analyzer.inst2.attribute.current_ctrl_amplitude.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.signal_analyzer.inst2.attribute.current_ctrl_amplitude.min', float(new_val))


class RootLuSignal_analyzerInst2AttributeAmplitude_modulation(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        enabled = 1
        disabled = 0

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.signal_analyzer.inst2.attribute.amplitude_modulation'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value(self) -> ValueEnum:
        return RootLuSignal_analyzerInst2AttributeAmplitude_modulation.ValueEnum(self._context.get('root.lu.signal_analyzer.inst2.attribute.amplitude_modulation.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.lu.signal_analyzer.inst2.attribute.amplitude_modulation.value_raw', new_val.value)

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.lu.signal_analyzer.inst2.attribute.amplitude_modulation.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.lu.signal_analyzer.inst2.attribute.amplitude_modulation.value_raw', int(new_val))

    @property
    def enum(self) -> list:
        return list(self._context.get('root.lu.signal_analyzer.inst2.attribute.amplitude_modulation.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.lu.signal_analyzer.inst2.attribute.amplitude_modulation.enum', list(new_val))


class RootLuSignal_analyzerInst2AttributeCurrent_phase(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.signal_analyzer.inst2.attribute.current_phase'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.signal_analyzer.inst2.attribute.current_phase.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.signal_analyzer.inst2.attribute.current_phase.value', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.signal_analyzer.inst2.attribute.current_phase.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.signal_analyzer.inst2.attribute.current_phase.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.signal_analyzer.inst2.attribute.current_phase.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.signal_analyzer.inst2.attribute.current_phase.unit', str(new_val))

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.signal_analyzer.inst2.attribute.current_phase.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.signal_analyzer.inst2.attribute.current_phase.min', float(new_val))


class RootLuSignal_analyzerInst2AttributeCurrent_ctrl_delta_f(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.signal_analyzer.inst2.attribute.current_ctrl_delta_f'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.signal_analyzer.inst2.attribute.current_ctrl_delta_f.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.signal_analyzer.inst2.attribute.current_ctrl_delta_f.value', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.signal_analyzer.inst2.attribute.current_ctrl_delta_f.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.signal_analyzer.inst2.attribute.current_ctrl_delta_f.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.signal_analyzer.inst2.attribute.current_ctrl_delta_f.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.signal_analyzer.inst2.attribute.current_ctrl_delta_f.unit', str(new_val))

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.signal_analyzer.inst2.attribute.current_ctrl_delta_f.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.signal_analyzer.inst2.attribute.current_ctrl_delta_f.min', float(new_val))


class RootLuSignal_analyzerInst2AttributeCurrent_amplitude_ctrl_mode(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        const_drive = 0
        const_amplitude = 1
        free_vibration = 2

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.signal_analyzer.inst2.attribute.current_amplitude_ctrl_mode'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value(self) -> ValueEnum:
        return RootLuSignal_analyzerInst2AttributeCurrent_amplitude_ctrl_mode.ValueEnum(self._context.get('root.lu.signal_analyzer.inst2.attribute.current_amplitude_ctrl_mode.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.lu.signal_analyzer.inst2.attribute.current_amplitude_ctrl_mode.value_raw', new_val.value)

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.lu.signal_analyzer.inst2.attribute.current_amplitude_ctrl_mode.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.lu.signal_analyzer.inst2.attribute.current_amplitude_ctrl_mode.value_raw', int(new_val))

    @property
    def enum(self) -> list:
        return list(self._context.get('root.lu.signal_analyzer.inst2.attribute.current_amplitude_ctrl_mode.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.lu.signal_analyzer.inst2.attribute.current_amplitude_ctrl_mode.enum', list(new_val))


class RootLuSignal_analyzerInst2AttributeCurrent_y_binary(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.signal_analyzer.inst2.attribute.current_y_binary'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.signal_analyzer.inst2.attribute.current_y_binary.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.signal_analyzer.inst2.attribute.current_y_binary.value', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.signal_analyzer.inst2.attribute.current_y_binary.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.signal_analyzer.inst2.attribute.current_y_binary.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.signal_analyzer.inst2.attribute.current_y_binary.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.signal_analyzer.inst2.attribute.current_y_binary.unit', str(new_val))

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.signal_analyzer.inst2.attribute.current_y_binary.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.signal_analyzer.inst2.attribute.current_y_binary.min', float(new_val))


class RootLuSignal_analyzerInst2AttributeAmplitude_ctrl_set_point_calib_result(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        no_error = 0
        amplitude_calibration_error = 1

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.signal_analyzer.inst2.attribute.amplitude_ctrl_set_point_calib_result'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value(self) -> ValueEnum:
        return RootLuSignal_analyzerInst2AttributeAmplitude_ctrl_set_point_calib_result.ValueEnum(self._context.get('root.lu.signal_analyzer.inst2.attribute.amplitude_ctrl_set_point_calib_result.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.lu.signal_analyzer.inst2.attribute.amplitude_ctrl_set_point_calib_result.value_raw', new_val.value)

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.lu.signal_analyzer.inst2.attribute.amplitude_ctrl_set_point_calib_result.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.lu.signal_analyzer.inst2.attribute.amplitude_ctrl_set_point_calib_result.value_raw', int(new_val))

    @property
    def enum(self) -> list:
        return list(self._context.get('root.lu.signal_analyzer.inst2.attribute.amplitude_ctrl_set_point_calib_result.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.lu.signal_analyzer.inst2.attribute.amplitude_ctrl_set_point_calib_result.enum', list(new_val))


class RootLuSignal_analyzerInst2AttributeReference_frequency(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.signal_analyzer.inst2.attribute.reference_frequency'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.signal_analyzer.inst2.attribute.reference_frequency.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.signal_analyzer.inst2.attribute.reference_frequency.value', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.signal_analyzer.inst2.attribute.reference_frequency.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.signal_analyzer.inst2.attribute.reference_frequency.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.signal_analyzer.inst2.attribute.reference_frequency.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.signal_analyzer.inst2.attribute.reference_frequency.unit', str(new_val))

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.signal_analyzer.inst2.attribute.reference_frequency.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.signal_analyzer.inst2.attribute.reference_frequency.min', float(new_val))


class RootLuSignal_analyzerInst2AttributeReference_amplitude(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.signal_analyzer.inst2.attribute.reference_amplitude'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.signal_analyzer.inst2.attribute.reference_amplitude.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.signal_analyzer.inst2.attribute.reference_amplitude.value', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.signal_analyzer.inst2.attribute.reference_amplitude.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.signal_analyzer.inst2.attribute.reference_amplitude.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.signal_analyzer.inst2.attribute.reference_amplitude.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.signal_analyzer.inst2.attribute.reference_amplitude.unit', str(new_val))

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.signal_analyzer.inst2.attribute.reference_amplitude.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.signal_analyzer.inst2.attribute.reference_amplitude.min', float(new_val))


class RootLuSignal_analyzerInst2AttributeTarget_amplitude_ctrl_set_point(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.signal_analyzer.inst2.attribute.target_amplitude_ctrl_set_point'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.signal_analyzer.inst2.attribute.target_amplitude_ctrl_set_point.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.signal_analyzer.inst2.attribute.target_amplitude_ctrl_set_point.value', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.signal_analyzer.inst2.attribute.target_amplitude_ctrl_set_point.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.signal_analyzer.inst2.attribute.target_amplitude_ctrl_set_point.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.signal_analyzer.inst2.attribute.target_amplitude_ctrl_set_point.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.signal_analyzer.inst2.attribute.target_amplitude_ctrl_set_point.unit', str(new_val))

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.signal_analyzer.inst2.attribute.target_amplitude_ctrl_set_point.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.signal_analyzer.inst2.attribute.target_amplitude_ctrl_set_point.min', float(new_val))


class RootLuSignal_analyzerInst2AttributeReset_flag_pll_unlocked(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.signal_analyzer.inst2.attribute.reset_flag_pll_unlocked'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.signal_analyzer.inst2.attribute.reset_flag_pll_unlocked.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.signal_analyzer.inst2.attribute.reset_flag_pll_unlocked.value', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.signal_analyzer.inst2.attribute.reset_flag_pll_unlocked.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.signal_analyzer.inst2.attribute.reset_flag_pll_unlocked.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.signal_analyzer.inst2.attribute.reset_flag_pll_unlocked.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.signal_analyzer.inst2.attribute.reset_flag_pll_unlocked.unit', str(new_val))

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.signal_analyzer.inst2.attribute.reset_flag_pll_unlocked.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.signal_analyzer.inst2.attribute.reset_flag_pll_unlocked.min', float(new_val))


class RootLuSignal_analyzerInst2AttributePhase_ctrl_i_gain(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.signal_analyzer.inst2.attribute.phase_ctrl_i_gain'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.signal_analyzer.inst2.attribute.phase_ctrl_i_gain.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.signal_analyzer.inst2.attribute.phase_ctrl_i_gain.value', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.signal_analyzer.inst2.attribute.phase_ctrl_i_gain.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.signal_analyzer.inst2.attribute.phase_ctrl_i_gain.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.signal_analyzer.inst2.attribute.phase_ctrl_i_gain.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.signal_analyzer.inst2.attribute.phase_ctrl_i_gain.unit', str(new_val))

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.signal_analyzer.inst2.attribute.phase_ctrl_i_gain.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.signal_analyzer.inst2.attribute.phase_ctrl_i_gain.min', float(new_val))


class RootLuSignal_analyzerInst2AttributeReference_amplitude_factor(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.signal_analyzer.inst2.attribute.reference_amplitude_factor'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.signal_analyzer.inst2.attribute.reference_amplitude_factor.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.signal_analyzer.inst2.attribute.reference_amplitude_factor.value', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.signal_analyzer.inst2.attribute.reference_amplitude_factor.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.signal_analyzer.inst2.attribute.reference_amplitude_factor.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.signal_analyzer.inst2.attribute.reference_amplitude_factor.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.signal_analyzer.inst2.attribute.reference_amplitude_factor.unit', str(new_val))

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.signal_analyzer.inst2.attribute.reference_amplitude_factor.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.signal_analyzer.inst2.attribute.reference_amplitude_factor.min', float(new_val))


class RootLuSignal_analyzerInst2AttributeAmplitude_ctrl_i_gain(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.signal_analyzer.inst2.attribute.amplitude_ctrl_i_gain'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.signal_analyzer.inst2.attribute.amplitude_ctrl_i_gain.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.signal_analyzer.inst2.attribute.amplitude_ctrl_i_gain.value', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.signal_analyzer.inst2.attribute.amplitude_ctrl_i_gain.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.signal_analyzer.inst2.attribute.amplitude_ctrl_i_gain.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.signal_analyzer.inst2.attribute.amplitude_ctrl_i_gain.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.signal_analyzer.inst2.attribute.amplitude_ctrl_i_gain.unit', str(new_val))

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.signal_analyzer.inst2.attribute.amplitude_ctrl_i_gain.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.signal_analyzer.inst2.attribute.amplitude_ctrl_i_gain.min', float(new_val))


class RootLuSignal_analyzerInst2AttributeCurrent_x(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.signal_analyzer.inst2.attribute.current_x'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.signal_analyzer.inst2.attribute.current_x.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.signal_analyzer.inst2.attribute.current_x.value', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.signal_analyzer.inst2.attribute.current_x.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.signal_analyzer.inst2.attribute.current_x.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.signal_analyzer.inst2.attribute.current_x.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.signal_analyzer.inst2.attribute.current_x.unit', str(new_val))

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.signal_analyzer.inst2.attribute.current_x.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.signal_analyzer.inst2.attribute.current_x.min', float(new_val))


class RootLuSignal_analyzerInst2AttributeInput(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        in_lateral = 3
        ctrl_z_nominal = 46
        ctrl_w_out = 49
        ctrl_z_out = 17
        memory_gen_drive_z = 29
        ort_adhesion_value = 65
        ramp_gen_plane_z = 39
        fast_in2 = 1
        analyzer1_y = 55
        ramp_gen_position_x = 33
        fast_in_deflection = 0
        ctrl_user2_out = 51
        ort_excitation = 69
        analyzer2_x = 60
        ctrl_z_pid_command = 44
        ctrl_x_out = 47
        in_detector_sum = 22
        gen_test_dynamic = 19
        ort_adhesion_position = 66
        ort_baseline = 62
        static = 18
        ctrl_z_sum = 45
        memory_gen_position_y = 26
        analyzer1_reference = 67
        ramp_gen_approach = 32
        analyzer2_y = 61
        in_user2 = 5
        ort_baseline_corrected = 63
        ctrl_z_in = 42
        analyzer1_ctrl_amplitude = 52
        ramp_gen_position_y = 34
        memory_gen_position_x = 24
        analyzer1_ctrl_delta_f = 16
        memory_gen_drive_y = 27
        analyzer1_amplitude = 15
        memory_gen_out8 = 31
        memory_gen_out7 = 30
        memory_gen_drive_x = 25
        ramp_gen_ctrl_z = 40
        ctrl_z_error = 43
        in_position_x = 12
        fast_in_user = 2
        in_position_y = 13
        analyzer1_phase = 53
        analyzer2_ctrl_amplitude = 57
        analyzer2_ctrl_delta_f = 56
        test_tip_voltage = 11
        test_ref = 10
        ramp_gen_position_w = 35
        in_user1 = 4
        in_deflection = 21
        ort_free_wave = 70
        ctrl_user1_out = 50
        ramp_gen_tip_voltage = 36
        analyzer2_phase = 58
        ramp_gen_test = 20
        analyzer2_reference = 68
        ramp_gen_alternate_z = 37
        test_ana_gnd = 9
        ramp_gen_max_z = 41
        ramp_gen_user4 = 38
        in_user4 = 7
        analyzer2_amplitude = 59
        ctrl_y_out = 48
        memory_gen_position_z = 28
        ort_amplitude_reduction = 64
        in_user3 = 6
        in_tip_current = 8
        in_position_z = 14
        in6 = 23
        analyzer1_x = 54

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.signal_analyzer.inst2.attribute.input'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value(self) -> ValueEnum:
        return RootLuSignal_analyzerInst2AttributeInput.ValueEnum(self._context.get('root.lu.signal_analyzer.inst2.attribute.input.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.lu.signal_analyzer.inst2.attribute.input.value_raw', new_val.value)

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.lu.signal_analyzer.inst2.attribute.input.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.lu.signal_analyzer.inst2.attribute.input.value_raw', int(new_val))

    @property
    def enum(self) -> list:
        return list(self._context.get('root.lu.signal_analyzer.inst2.attribute.input.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.lu.signal_analyzer.inst2.attribute.input.enum', list(new_val))


class RootLuSignal_analyzerInst2AttributeReference_phase(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.signal_analyzer.inst2.attribute.reference_phase'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.signal_analyzer.inst2.attribute.reference_phase.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.signal_analyzer.inst2.attribute.reference_phase.value', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.signal_analyzer.inst2.attribute.reference_phase.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.signal_analyzer.inst2.attribute.reference_phase.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.signal_analyzer.inst2.attribute.reference_phase.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.signal_analyzer.inst2.attribute.reference_phase.unit', str(new_val))

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.signal_analyzer.inst2.attribute.reference_phase.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.signal_analyzer.inst2.attribute.reference_phase.min', float(new_val))


class RootLuSignal_analyzerInst2AttributeTarget_amplitude_ctrl_mode(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        const_drive = 0
        const_amplitude = 1
        free_vibration = 2

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.signal_analyzer.inst2.attribute.target_amplitude_ctrl_mode'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value(self) -> ValueEnum:
        return RootLuSignal_analyzerInst2AttributeTarget_amplitude_ctrl_mode.ValueEnum(self._context.get('root.lu.signal_analyzer.inst2.attribute.target_amplitude_ctrl_mode.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.lu.signal_analyzer.inst2.attribute.target_amplitude_ctrl_mode.value_raw', new_val.value)

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.lu.signal_analyzer.inst2.attribute.target_amplitude_ctrl_mode.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.lu.signal_analyzer.inst2.attribute.target_amplitude_ctrl_mode.value_raw', int(new_val))

    @property
    def enum(self) -> list:
        return list(self._context.get('root.lu.signal_analyzer.inst2.attribute.target_amplitude_ctrl_mode.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.lu.signal_analyzer.inst2.attribute.target_amplitude_ctrl_mode.enum', list(new_val))


class RootLuSignal_analyzerInst2AttributePhase_ctrl_p_gain(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.signal_analyzer.inst2.attribute.phase_ctrl_p_gain'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.signal_analyzer.inst2.attribute.phase_ctrl_p_gain.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.signal_analyzer.inst2.attribute.phase_ctrl_p_gain.value', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.signal_analyzer.inst2.attribute.phase_ctrl_p_gain.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.signal_analyzer.inst2.attribute.phase_ctrl_p_gain.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.signal_analyzer.inst2.attribute.phase_ctrl_p_gain.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.signal_analyzer.inst2.attribute.phase_ctrl_p_gain.unit', str(new_val))

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.signal_analyzer.inst2.attribute.phase_ctrl_p_gain.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.signal_analyzer.inst2.attribute.phase_ctrl_p_gain.min', float(new_val))


class RootLuSignal_analyzerInst2AttributeCurrent_x_binary(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.signal_analyzer.inst2.attribute.current_x_binary'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.signal_analyzer.inst2.attribute.current_x_binary.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.signal_analyzer.inst2.attribute.current_x_binary.value', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.signal_analyzer.inst2.attribute.current_x_binary.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.signal_analyzer.inst2.attribute.current_x_binary.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.signal_analyzer.inst2.attribute.current_x_binary.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.signal_analyzer.inst2.attribute.current_x_binary.unit', str(new_val))

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.signal_analyzer.inst2.attribute.current_x_binary.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.signal_analyzer.inst2.attribute.current_x_binary.min', float(new_val))


class RootLuSignal_analyzerInst2AttributeCurrent_y(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.signal_analyzer.inst2.attribute.current_y'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.signal_analyzer.inst2.attribute.current_y.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.signal_analyzer.inst2.attribute.current_y.value', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.signal_analyzer.inst2.attribute.current_y.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.signal_analyzer.inst2.attribute.current_y.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.signal_analyzer.inst2.attribute.current_y.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.signal_analyzer.inst2.attribute.current_y.unit', str(new_val))

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.signal_analyzer.inst2.attribute.current_y.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.signal_analyzer.inst2.attribute.current_y.min', float(new_val))


class RootLuSignal_analyzerInst2AttributeCurrent_amplitude_binary(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.signal_analyzer.inst2.attribute.current_amplitude_binary'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.signal_analyzer.inst2.attribute.current_amplitude_binary.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.signal_analyzer.inst2.attribute.current_amplitude_binary.value', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.signal_analyzer.inst2.attribute.current_amplitude_binary.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.signal_analyzer.inst2.attribute.current_amplitude_binary.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.signal_analyzer.inst2.attribute.current_amplitude_binary.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.signal_analyzer.inst2.attribute.current_amplitude_binary.unit', str(new_val))

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.signal_analyzer.inst2.attribute.current_amplitude_binary.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.signal_analyzer.inst2.attribute.current_amplitude_binary.min', float(new_val))


class RootLuSignal_analyzerInst2AttributeCurrent_amplitude(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.signal_analyzer.inst2.attribute.current_amplitude'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.signal_analyzer.inst2.attribute.current_amplitude.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.signal_analyzer.inst2.attribute.current_amplitude.value', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.signal_analyzer.inst2.attribute.current_amplitude.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.signal_analyzer.inst2.attribute.current_amplitude.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.signal_analyzer.inst2.attribute.current_amplitude.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.signal_analyzer.inst2.attribute.current_amplitude.unit', str(new_val))

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.signal_analyzer.inst2.attribute.current_amplitude.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.signal_analyzer.inst2.attribute.current_amplitude.min', float(new_val))


class RootLuSignal_analyzerInst2AttributeDemodulator_bw(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        bw_23_k_hz = 11
        bw_45_k_hz = 12
        bw_1500_hz = 7
        bw_500_k_hz = 15
        bw_90_hz = 3
        bw_360_hz = 5
        bw_230_k_hz = 14
        bw_12_k_hz = 10
        bw_750_hz = 6
        bw_100_k_hz = 13
        bw_23_hz = 1
        bw_180_hz = 4
        bw_6_k_hz = 9
        bw_45_hz = 2
        bw_3_k_hz = 8

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.signal_analyzer.inst2.attribute.demodulator_bw'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value(self) -> ValueEnum:
        return RootLuSignal_analyzerInst2AttributeDemodulator_bw.ValueEnum(self._context.get('root.lu.signal_analyzer.inst2.attribute.demodulator_bw.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.lu.signal_analyzer.inst2.attribute.demodulator_bw.value_raw', new_val.value)

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.lu.signal_analyzer.inst2.attribute.demodulator_bw.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.lu.signal_analyzer.inst2.attribute.demodulator_bw.value_raw', int(new_val))

    @property
    def enum(self) -> list:
        return list(self._context.get('root.lu.signal_analyzer.inst2.attribute.demodulator_bw.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.lu.signal_analyzer.inst2.attribute.demodulator_bw.enum', list(new_val))


class RootLuSignal_analyzerInst2AttributeOperating_mode(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        pll = 1
        lock_in = 0
        kpfm = 2

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.signal_analyzer.inst2.attribute.operating_mode'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value(self) -> ValueEnum:
        return RootLuSignal_analyzerInst2AttributeOperating_mode.ValueEnum(self._context.get('root.lu.signal_analyzer.inst2.attribute.operating_mode.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.lu.signal_analyzer.inst2.attribute.operating_mode.value_raw', new_val.value)

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.lu.signal_analyzer.inst2.attribute.operating_mode.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.lu.signal_analyzer.inst2.attribute.operating_mode.value_raw', int(new_val))

    @property
    def enum(self) -> list:
        return list(self._context.get('root.lu.signal_analyzer.inst2.attribute.operating_mode.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.lu.signal_analyzer.inst2.attribute.operating_mode.enum', list(new_val))


class RootLuSignal_analyzerInst2AttributeLock_in_calc_phase(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.signal_analyzer.inst2.attribute.lock_in_calc_phase'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.signal_analyzer.inst2.attribute.lock_in_calc_phase.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.signal_analyzer.inst2.attribute.lock_in_calc_phase.value', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.signal_analyzer.inst2.attribute.lock_in_calc_phase.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.signal_analyzer.inst2.attribute.lock_in_calc_phase.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.signal_analyzer.inst2.attribute.lock_in_calc_phase.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.signal_analyzer.inst2.attribute.lock_in_calc_phase.unit', str(new_val))

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.signal_analyzer.inst2.attribute.lock_in_calc_phase.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.signal_analyzer.inst2.attribute.lock_in_calc_phase.min', float(new_val))


class RootLuSignal_analyzerInst2AttributeCurrent_phase_binary(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.signal_analyzer.inst2.attribute.current_phase_binary'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.signal_analyzer.inst2.attribute.current_phase_binary.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.signal_analyzer.inst2.attribute.current_phase_binary.value', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.signal_analyzer.inst2.attribute.current_phase_binary.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.signal_analyzer.inst2.attribute.current_phase_binary.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.signal_analyzer.inst2.attribute.current_phase_binary.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.signal_analyzer.inst2.attribute.current_phase_binary.unit', str(new_val))

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.signal_analyzer.inst2.attribute.current_phase_binary.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.signal_analyzer.inst2.attribute.current_phase_binary.min', float(new_val))


class RootLuSignal_analyzerInst2AttributeReference_source(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        harmonic1 = 1
        harmonic3 = 3
        own = 0
        harmonic2 = 2

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.signal_analyzer.inst2.attribute.reference_source'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value(self) -> ValueEnum:
        return RootLuSignal_analyzerInst2AttributeReference_source.ValueEnum(self._context.get('root.lu.signal_analyzer.inst2.attribute.reference_source.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.lu.signal_analyzer.inst2.attribute.reference_source.value_raw', new_val.value)

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.lu.signal_analyzer.inst2.attribute.reference_source.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.lu.signal_analyzer.inst2.attribute.reference_source.value_raw', int(new_val))

    @property
    def enum(self) -> list:
        return list(self._context.get('root.lu.signal_analyzer.inst2.attribute.reference_source.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.lu.signal_analyzer.inst2.attribute.reference_source.enum', list(new_val))


class RootLuSignal_analyzerInst2AttributeHarmonic_source(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        analyzer1 = 0
        analyzer2 = 1

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.signal_analyzer.inst2.attribute.harmonic_source'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value(self) -> ValueEnum:
        return RootLuSignal_analyzerInst2AttributeHarmonic_source.ValueEnum(self._context.get('root.lu.signal_analyzer.inst2.attribute.harmonic_source.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.lu.signal_analyzer.inst2.attribute.harmonic_source.value_raw', new_val.value)

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.lu.signal_analyzer.inst2.attribute.harmonic_source.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.lu.signal_analyzer.inst2.attribute.harmonic_source.value_raw', int(new_val))

    @property
    def enum(self) -> list:
        return list(self._context.get('root.lu.signal_analyzer.inst2.attribute.harmonic_source.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.lu.signal_analyzer.inst2.attribute.harmonic_source.enum', list(new_val))


class RootLuSignal_analyzerInst2AttributeCurrent_reference_amplitude(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.signal_analyzer.inst2.attribute.current_reference_amplitude'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.signal_analyzer.inst2.attribute.current_reference_amplitude.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.signal_analyzer.inst2.attribute.current_reference_amplitude.value', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.signal_analyzer.inst2.attribute.current_reference_amplitude.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.signal_analyzer.inst2.attribute.current_reference_amplitude.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.signal_analyzer.inst2.attribute.current_reference_amplitude.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.signal_analyzer.inst2.attribute.current_reference_amplitude.unit', str(new_val))

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.signal_analyzer.inst2.attribute.current_reference_amplitude.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.signal_analyzer.inst2.attribute.current_reference_amplitude.min', float(new_val))


class RootLuSignal_analyzerInst2AttributeLock_in_calc_amplitude(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.signal_analyzer.inst2.attribute.lock_in_calc_amplitude'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.signal_analyzer.inst2.attribute.lock_in_calc_amplitude.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.signal_analyzer.inst2.attribute.lock_in_calc_amplitude.value', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.signal_analyzer.inst2.attribute.lock_in_calc_amplitude.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.signal_analyzer.inst2.attribute.lock_in_calc_amplitude.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.signal_analyzer.inst2.attribute.lock_in_calc_amplitude.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.signal_analyzer.inst2.attribute.lock_in_calc_amplitude.unit', str(new_val))

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.signal_analyzer.inst2.attribute.lock_in_calc_amplitude.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.signal_analyzer.inst2.attribute.lock_in_calc_amplitude.min', float(new_val))


class RootLuSignal_analyzerInst2AttributeAmplitude_ctrl_p_gain(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.signal_analyzer.inst2.attribute.amplitude_ctrl_p_gain'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.signal_analyzer.inst2.attribute.amplitude_ctrl_p_gain.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.signal_analyzer.inst2.attribute.amplitude_ctrl_p_gain.value', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.signal_analyzer.inst2.attribute.amplitude_ctrl_p_gain.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.signal_analyzer.inst2.attribute.amplitude_ctrl_p_gain.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.signal_analyzer.inst2.attribute.amplitude_ctrl_p_gain.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.signal_analyzer.inst2.attribute.amplitude_ctrl_p_gain.unit', str(new_val))

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.signal_analyzer.inst2.attribute.amplitude_ctrl_p_gain.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.signal_analyzer.inst2.attribute.amplitude_ctrl_p_gain.min', float(new_val))


class RootLuSignal_analyzerInst2Attribute(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.signal_analyzer.inst2.attribute'
        self.amplitude_ctrl_p_gain = RootLuSignal_analyzerInst2AttributeAmplitude_ctrl_p_gain(self._context)
        self.lock_in_calc_amplitude = RootLuSignal_analyzerInst2AttributeLock_in_calc_amplitude(self._context)
        self.current_reference_amplitude = RootLuSignal_analyzerInst2AttributeCurrent_reference_amplitude(self._context)
        self.harmonic_source = RootLuSignal_analyzerInst2AttributeHarmonic_source(self._context)
        self.reference_source = RootLuSignal_analyzerInst2AttributeReference_source(self._context)
        self.current_phase_binary = RootLuSignal_analyzerInst2AttributeCurrent_phase_binary(self._context)
        self.lock_in_calc_phase = RootLuSignal_analyzerInst2AttributeLock_in_calc_phase(self._context)
        self.operating_mode = RootLuSignal_analyzerInst2AttributeOperating_mode(self._context)
        self.demodulator_bw = RootLuSignal_analyzerInst2AttributeDemodulator_bw(self._context)
        self.current_amplitude = RootLuSignal_analyzerInst2AttributeCurrent_amplitude(self._context)
        self.current_amplitude_binary = RootLuSignal_analyzerInst2AttributeCurrent_amplitude_binary(self._context)
        self.current_y = RootLuSignal_analyzerInst2AttributeCurrent_y(self._context)
        self.current_x_binary = RootLuSignal_analyzerInst2AttributeCurrent_x_binary(self._context)
        self.phase_ctrl_p_gain = RootLuSignal_analyzerInst2AttributePhase_ctrl_p_gain(self._context)
        self.target_amplitude_ctrl_mode = RootLuSignal_analyzerInst2AttributeTarget_amplitude_ctrl_mode(self._context)
        self.reference_phase = RootLuSignal_analyzerInst2AttributeReference_phase(self._context)
        self.input = RootLuSignal_analyzerInst2AttributeInput(self._context)
        self.current_x = RootLuSignal_analyzerInst2AttributeCurrent_x(self._context)
        self.amplitude_ctrl_i_gain = RootLuSignal_analyzerInst2AttributeAmplitude_ctrl_i_gain(self._context)
        self.reference_amplitude_factor = RootLuSignal_analyzerInst2AttributeReference_amplitude_factor(self._context)
        self.phase_ctrl_i_gain = RootLuSignal_analyzerInst2AttributePhase_ctrl_i_gain(self._context)
        self.reset_flag_pll_unlocked = RootLuSignal_analyzerInst2AttributeReset_flag_pll_unlocked(self._context)
        self.target_amplitude_ctrl_set_point = RootLuSignal_analyzerInst2AttributeTarget_amplitude_ctrl_set_point(self._context)
        self.reference_amplitude = RootLuSignal_analyzerInst2AttributeReference_amplitude(self._context)
        self.reference_frequency = RootLuSignal_analyzerInst2AttributeReference_frequency(self._context)
        self.amplitude_ctrl_set_point_calib_result = RootLuSignal_analyzerInst2AttributeAmplitude_ctrl_set_point_calib_result(self._context)
        self.current_y_binary = RootLuSignal_analyzerInst2AttributeCurrent_y_binary(self._context)
        self.current_amplitude_ctrl_mode = RootLuSignal_analyzerInst2AttributeCurrent_amplitude_ctrl_mode(self._context)
        self.current_ctrl_delta_f = RootLuSignal_analyzerInst2AttributeCurrent_ctrl_delta_f(self._context)
        self.current_phase = RootLuSignal_analyzerInst2AttributeCurrent_phase(self._context)
        self.amplitude_modulation = RootLuSignal_analyzerInst2AttributeAmplitude_modulation(self._context)
        self.current_ctrl_amplitude = RootLuSignal_analyzerInst2AttributeCurrent_ctrl_amplitude(self._context)
        self.phase_lock_range = RootLuSignal_analyzerInst2AttributePhase_lock_range(self._context)
        self.current_amplitude_ctrl_set_point = RootLuSignal_analyzerInst2AttributeCurrent_amplitude_ctrl_set_point(self._context)
        self.display_df_range = RootLuSignal_analyzerInst2AttributeDisplay_df_range(self._context)
        self.enable_dc_block = RootLuSignal_analyzerInst2AttributeEnable_dc_block(self._context)
        self.delay_comp = RootLuSignal_analyzerInst2AttributeDelay_comp(self._context)
        self.pll_unlocked = RootLuSignal_analyzerInst2AttributePll_unlocked(self._context)


class RootLuSignal_analyzerInst2Busy(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.signal_analyzer.inst2.busy'


class RootLuSignal_analyzerInst2(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.signal_analyzer.inst2'
        self.busy = RootLuSignal_analyzerInst2Busy(self._context)
        self.attribute = RootLuSignal_analyzerInst2Attribute(self._context)
        self.trigger = RootLuSignal_analyzerInst2Trigger(self._context)


class RootLuSignal_analyzerInst1Trigger(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.signal_analyzer.inst1.trigger'

    def start_kpfm_phase_calibration(self) -> None:
        return self._context.call('root.lu.signal_analyzer.inst1.trigger.start_kpfm_phase_calibration')

    def start_phase_zero_calibration(self) -> None:
        return self._context.call('root.lu.signal_analyzer.inst1.trigger.start_phase_zero_calibration')

    def user_abort(self) -> None:
        return self._context.call('root.lu.signal_analyzer.inst1.trigger.user_abort')

    def start_switch_to_target_amplitude_ctrl_set_point(self) -> None:
        return self._context.call('root.lu.signal_analyzer.inst1.trigger.start_switch_to_target_amplitude_ctrl_set_point')

    def start_update_current_free_amplitude(self) -> None:
        return self._context.call('root.lu.signal_analyzer.inst1.trigger.start_update_current_free_amplitude')

    def start_switch_to_target_amplitude_ctrl_mode(self) -> None:
        return self._context.call('root.lu.signal_analyzer.inst1.trigger.start_switch_to_target_amplitude_ctrl_mode')

    def switch_to_target_amplitude_ctrl_mode(self) -> None:
        return self._context.call('root.lu.signal_analyzer.inst1.trigger.switch_to_target_amplitude_ctrl_mode')

    def kpfm_phase_calibration(self) -> None:
        return self._context.call('root.lu.signal_analyzer.inst1.trigger.kpfm_phase_calibration')

    def switch_to_target_amplitude_ctrl_set_point(self) -> None:
        return self._context.call('root.lu.signal_analyzer.inst1.trigger.switch_to_target_amplitude_ctrl_set_point')


class RootLuSignal_analyzerInst1AttributePll_unlocked(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.signal_analyzer.inst1.attribute.pll_unlocked'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.signal_analyzer.inst1.attribute.pll_unlocked.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.signal_analyzer.inst1.attribute.pll_unlocked.value', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.signal_analyzer.inst1.attribute.pll_unlocked.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.signal_analyzer.inst1.attribute.pll_unlocked.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.signal_analyzer.inst1.attribute.pll_unlocked.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.signal_analyzer.inst1.attribute.pll_unlocked.unit', str(new_val))

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.signal_analyzer.inst1.attribute.pll_unlocked.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.signal_analyzer.inst1.attribute.pll_unlocked.min', float(new_val))


class RootLuSignal_analyzerInst1AttributeDelay_comp(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.signal_analyzer.inst1.attribute.delay_comp'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.signal_analyzer.inst1.attribute.delay_comp.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.signal_analyzer.inst1.attribute.delay_comp.value', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.signal_analyzer.inst1.attribute.delay_comp.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.signal_analyzer.inst1.attribute.delay_comp.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.signal_analyzer.inst1.attribute.delay_comp.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.signal_analyzer.inst1.attribute.delay_comp.unit', str(new_val))

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.signal_analyzer.inst1.attribute.delay_comp.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.signal_analyzer.inst1.attribute.delay_comp.min', float(new_val))


class RootLuSignal_analyzerInst1AttributeEnable_dc_block(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        enabled = 1
        disabled = 0

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.signal_analyzer.inst1.attribute.enable_dc_block'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value(self) -> ValueEnum:
        return RootLuSignal_analyzerInst1AttributeEnable_dc_block.ValueEnum(self._context.get('root.lu.signal_analyzer.inst1.attribute.enable_dc_block.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.lu.signal_analyzer.inst1.attribute.enable_dc_block.value_raw', new_val.value)

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.lu.signal_analyzer.inst1.attribute.enable_dc_block.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.lu.signal_analyzer.inst1.attribute.enable_dc_block.value_raw', int(new_val))

    @property
    def enum(self) -> list:
        return list(self._context.get('root.lu.signal_analyzer.inst1.attribute.enable_dc_block.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.lu.signal_analyzer.inst1.attribute.enable_dc_block.enum', list(new_val))


class RootLuSignal_analyzerInst1AttributeDisplay_df_range(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.signal_analyzer.inst1.attribute.display_df_range'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.signal_analyzer.inst1.attribute.display_df_range.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.signal_analyzer.inst1.attribute.display_df_range.value', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.signal_analyzer.inst1.attribute.display_df_range.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.signal_analyzer.inst1.attribute.display_df_range.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.signal_analyzer.inst1.attribute.display_df_range.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.signal_analyzer.inst1.attribute.display_df_range.unit', str(new_val))

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.signal_analyzer.inst1.attribute.display_df_range.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.signal_analyzer.inst1.attribute.display_df_range.min', float(new_val))


class RootLuSignal_analyzerInst1AttributeCurrent_amplitude_ctrl_set_point(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.signal_analyzer.inst1.attribute.current_amplitude_ctrl_set_point'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.signal_analyzer.inst1.attribute.current_amplitude_ctrl_set_point.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.signal_analyzer.inst1.attribute.current_amplitude_ctrl_set_point.value', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.signal_analyzer.inst1.attribute.current_amplitude_ctrl_set_point.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.signal_analyzer.inst1.attribute.current_amplitude_ctrl_set_point.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.signal_analyzer.inst1.attribute.current_amplitude_ctrl_set_point.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.signal_analyzer.inst1.attribute.current_amplitude_ctrl_set_point.unit', str(new_val))

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.signal_analyzer.inst1.attribute.current_amplitude_ctrl_set_point.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.signal_analyzer.inst1.attribute.current_amplitude_ctrl_set_point.min', float(new_val))


class RootLuSignal_analyzerInst1AttributePhase_lock_range(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.signal_analyzer.inst1.attribute.phase_lock_range'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.signal_analyzer.inst1.attribute.phase_lock_range.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.signal_analyzer.inst1.attribute.phase_lock_range.value', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.signal_analyzer.inst1.attribute.phase_lock_range.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.signal_analyzer.inst1.attribute.phase_lock_range.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.signal_analyzer.inst1.attribute.phase_lock_range.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.signal_analyzer.inst1.attribute.phase_lock_range.unit', str(new_val))

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.signal_analyzer.inst1.attribute.phase_lock_range.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.signal_analyzer.inst1.attribute.phase_lock_range.min', float(new_val))


class RootLuSignal_analyzerInst1AttributeCurrent_ctrl_amplitude(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.signal_analyzer.inst1.attribute.current_ctrl_amplitude'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.signal_analyzer.inst1.attribute.current_ctrl_amplitude.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.signal_analyzer.inst1.attribute.current_ctrl_amplitude.value', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.signal_analyzer.inst1.attribute.current_ctrl_amplitude.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.signal_analyzer.inst1.attribute.current_ctrl_amplitude.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.signal_analyzer.inst1.attribute.current_ctrl_amplitude.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.signal_analyzer.inst1.attribute.current_ctrl_amplitude.unit', str(new_val))

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.signal_analyzer.inst1.attribute.current_ctrl_amplitude.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.signal_analyzer.inst1.attribute.current_ctrl_amplitude.min', float(new_val))


class RootLuSignal_analyzerInst1AttributeAmplitude_modulation(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        enabled = 1
        disabled = 0

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.signal_analyzer.inst1.attribute.amplitude_modulation'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value(self) -> ValueEnum:
        return RootLuSignal_analyzerInst1AttributeAmplitude_modulation.ValueEnum(self._context.get('root.lu.signal_analyzer.inst1.attribute.amplitude_modulation.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.lu.signal_analyzer.inst1.attribute.amplitude_modulation.value_raw', new_val.value)

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.lu.signal_analyzer.inst1.attribute.amplitude_modulation.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.lu.signal_analyzer.inst1.attribute.amplitude_modulation.value_raw', int(new_val))

    @property
    def enum(self) -> list:
        return list(self._context.get('root.lu.signal_analyzer.inst1.attribute.amplitude_modulation.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.lu.signal_analyzer.inst1.attribute.amplitude_modulation.enum', list(new_val))


class RootLuSignal_analyzerInst1AttributeCurrent_phase(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.signal_analyzer.inst1.attribute.current_phase'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.signal_analyzer.inst1.attribute.current_phase.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.signal_analyzer.inst1.attribute.current_phase.value', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.signal_analyzer.inst1.attribute.current_phase.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.signal_analyzer.inst1.attribute.current_phase.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.signal_analyzer.inst1.attribute.current_phase.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.signal_analyzer.inst1.attribute.current_phase.unit', str(new_val))

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.signal_analyzer.inst1.attribute.current_phase.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.signal_analyzer.inst1.attribute.current_phase.min', float(new_val))


class RootLuSignal_analyzerInst1AttributeCurrent_ctrl_delta_f(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.signal_analyzer.inst1.attribute.current_ctrl_delta_f'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.signal_analyzer.inst1.attribute.current_ctrl_delta_f.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.signal_analyzer.inst1.attribute.current_ctrl_delta_f.value', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.signal_analyzer.inst1.attribute.current_ctrl_delta_f.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.signal_analyzer.inst1.attribute.current_ctrl_delta_f.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.signal_analyzer.inst1.attribute.current_ctrl_delta_f.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.signal_analyzer.inst1.attribute.current_ctrl_delta_f.unit', str(new_val))

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.signal_analyzer.inst1.attribute.current_ctrl_delta_f.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.signal_analyzer.inst1.attribute.current_ctrl_delta_f.min', float(new_val))


class RootLuSignal_analyzerInst1AttributeCurrent_amplitude_ctrl_mode(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        const_drive = 0
        const_amplitude = 1
        free_vibration = 2

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.signal_analyzer.inst1.attribute.current_amplitude_ctrl_mode'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value(self) -> ValueEnum:
        return RootLuSignal_analyzerInst1AttributeCurrent_amplitude_ctrl_mode.ValueEnum(self._context.get('root.lu.signal_analyzer.inst1.attribute.current_amplitude_ctrl_mode.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.lu.signal_analyzer.inst1.attribute.current_amplitude_ctrl_mode.value_raw', new_val.value)

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.lu.signal_analyzer.inst1.attribute.current_amplitude_ctrl_mode.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.lu.signal_analyzer.inst1.attribute.current_amplitude_ctrl_mode.value_raw', int(new_val))

    @property
    def enum(self) -> list:
        return list(self._context.get('root.lu.signal_analyzer.inst1.attribute.current_amplitude_ctrl_mode.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.lu.signal_analyzer.inst1.attribute.current_amplitude_ctrl_mode.enum', list(new_val))


class RootLuSignal_analyzerInst1AttributeCurrent_y_binary(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.signal_analyzer.inst1.attribute.current_y_binary'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.signal_analyzer.inst1.attribute.current_y_binary.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.signal_analyzer.inst1.attribute.current_y_binary.value', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.signal_analyzer.inst1.attribute.current_y_binary.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.signal_analyzer.inst1.attribute.current_y_binary.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.signal_analyzer.inst1.attribute.current_y_binary.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.signal_analyzer.inst1.attribute.current_y_binary.unit', str(new_val))

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.signal_analyzer.inst1.attribute.current_y_binary.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.signal_analyzer.inst1.attribute.current_y_binary.min', float(new_val))


class RootLuSignal_analyzerInst1AttributeAmplitude_ctrl_set_point_calib_result(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        no_error = 0
        amplitude_calibration_error = 1

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.signal_analyzer.inst1.attribute.amplitude_ctrl_set_point_calib_result'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value(self) -> ValueEnum:
        return RootLuSignal_analyzerInst1AttributeAmplitude_ctrl_set_point_calib_result.ValueEnum(self._context.get('root.lu.signal_analyzer.inst1.attribute.amplitude_ctrl_set_point_calib_result.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.lu.signal_analyzer.inst1.attribute.amplitude_ctrl_set_point_calib_result.value_raw', new_val.value)

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.lu.signal_analyzer.inst1.attribute.amplitude_ctrl_set_point_calib_result.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.lu.signal_analyzer.inst1.attribute.amplitude_ctrl_set_point_calib_result.value_raw', int(new_val))

    @property
    def enum(self) -> list:
        return list(self._context.get('root.lu.signal_analyzer.inst1.attribute.amplitude_ctrl_set_point_calib_result.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.lu.signal_analyzer.inst1.attribute.amplitude_ctrl_set_point_calib_result.enum', list(new_val))


class RootLuSignal_analyzerInst1AttributeReference_frequency(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.signal_analyzer.inst1.attribute.reference_frequency'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.signal_analyzer.inst1.attribute.reference_frequency.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.signal_analyzer.inst1.attribute.reference_frequency.value', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.signal_analyzer.inst1.attribute.reference_frequency.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.signal_analyzer.inst1.attribute.reference_frequency.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.signal_analyzer.inst1.attribute.reference_frequency.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.signal_analyzer.inst1.attribute.reference_frequency.unit', str(new_val))

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.signal_analyzer.inst1.attribute.reference_frequency.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.signal_analyzer.inst1.attribute.reference_frequency.min', float(new_val))


class RootLuSignal_analyzerInst1AttributeReference_amplitude(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.signal_analyzer.inst1.attribute.reference_amplitude'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.signal_analyzer.inst1.attribute.reference_amplitude.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.signal_analyzer.inst1.attribute.reference_amplitude.value', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.signal_analyzer.inst1.attribute.reference_amplitude.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.signal_analyzer.inst1.attribute.reference_amplitude.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.signal_analyzer.inst1.attribute.reference_amplitude.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.signal_analyzer.inst1.attribute.reference_amplitude.unit', str(new_val))

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.signal_analyzer.inst1.attribute.reference_amplitude.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.signal_analyzer.inst1.attribute.reference_amplitude.min', float(new_val))


class RootLuSignal_analyzerInst1AttributeTarget_amplitude_ctrl_set_point(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.signal_analyzer.inst1.attribute.target_amplitude_ctrl_set_point'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.signal_analyzer.inst1.attribute.target_amplitude_ctrl_set_point.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.signal_analyzer.inst1.attribute.target_amplitude_ctrl_set_point.value', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.signal_analyzer.inst1.attribute.target_amplitude_ctrl_set_point.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.signal_analyzer.inst1.attribute.target_amplitude_ctrl_set_point.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.signal_analyzer.inst1.attribute.target_amplitude_ctrl_set_point.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.signal_analyzer.inst1.attribute.target_amplitude_ctrl_set_point.unit', str(new_val))

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.signal_analyzer.inst1.attribute.target_amplitude_ctrl_set_point.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.signal_analyzer.inst1.attribute.target_amplitude_ctrl_set_point.min', float(new_val))


class RootLuSignal_analyzerInst1AttributeReset_flag_pll_unlocked(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.signal_analyzer.inst1.attribute.reset_flag_pll_unlocked'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.signal_analyzer.inst1.attribute.reset_flag_pll_unlocked.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.signal_analyzer.inst1.attribute.reset_flag_pll_unlocked.value', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.signal_analyzer.inst1.attribute.reset_flag_pll_unlocked.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.signal_analyzer.inst1.attribute.reset_flag_pll_unlocked.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.signal_analyzer.inst1.attribute.reset_flag_pll_unlocked.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.signal_analyzer.inst1.attribute.reset_flag_pll_unlocked.unit', str(new_val))

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.signal_analyzer.inst1.attribute.reset_flag_pll_unlocked.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.signal_analyzer.inst1.attribute.reset_flag_pll_unlocked.min', float(new_val))


class RootLuSignal_analyzerInst1AttributePhase_ctrl_i_gain(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.signal_analyzer.inst1.attribute.phase_ctrl_i_gain'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.signal_analyzer.inst1.attribute.phase_ctrl_i_gain.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.signal_analyzer.inst1.attribute.phase_ctrl_i_gain.value', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.signal_analyzer.inst1.attribute.phase_ctrl_i_gain.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.signal_analyzer.inst1.attribute.phase_ctrl_i_gain.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.signal_analyzer.inst1.attribute.phase_ctrl_i_gain.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.signal_analyzer.inst1.attribute.phase_ctrl_i_gain.unit', str(new_val))

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.signal_analyzer.inst1.attribute.phase_ctrl_i_gain.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.signal_analyzer.inst1.attribute.phase_ctrl_i_gain.min', float(new_val))


class RootLuSignal_analyzerInst1AttributeReference_amplitude_factor(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.signal_analyzer.inst1.attribute.reference_amplitude_factor'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.signal_analyzer.inst1.attribute.reference_amplitude_factor.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.signal_analyzer.inst1.attribute.reference_amplitude_factor.value', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.signal_analyzer.inst1.attribute.reference_amplitude_factor.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.signal_analyzer.inst1.attribute.reference_amplitude_factor.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.signal_analyzer.inst1.attribute.reference_amplitude_factor.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.signal_analyzer.inst1.attribute.reference_amplitude_factor.unit', str(new_val))

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.signal_analyzer.inst1.attribute.reference_amplitude_factor.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.signal_analyzer.inst1.attribute.reference_amplitude_factor.min', float(new_val))


class RootLuSignal_analyzerInst1AttributeAmplitude_ctrl_i_gain(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.signal_analyzer.inst1.attribute.amplitude_ctrl_i_gain'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.signal_analyzer.inst1.attribute.amplitude_ctrl_i_gain.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.signal_analyzer.inst1.attribute.amplitude_ctrl_i_gain.value', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.signal_analyzer.inst1.attribute.amplitude_ctrl_i_gain.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.signal_analyzer.inst1.attribute.amplitude_ctrl_i_gain.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.signal_analyzer.inst1.attribute.amplitude_ctrl_i_gain.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.signal_analyzer.inst1.attribute.amplitude_ctrl_i_gain.unit', str(new_val))

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.signal_analyzer.inst1.attribute.amplitude_ctrl_i_gain.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.signal_analyzer.inst1.attribute.amplitude_ctrl_i_gain.min', float(new_val))


class RootLuSignal_analyzerInst1AttributeCurrent_x(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.signal_analyzer.inst1.attribute.current_x'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.signal_analyzer.inst1.attribute.current_x.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.signal_analyzer.inst1.attribute.current_x.value', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.signal_analyzer.inst1.attribute.current_x.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.signal_analyzer.inst1.attribute.current_x.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.signal_analyzer.inst1.attribute.current_x.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.signal_analyzer.inst1.attribute.current_x.unit', str(new_val))

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.signal_analyzer.inst1.attribute.current_x.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.signal_analyzer.inst1.attribute.current_x.min', float(new_val))


class RootLuSignal_analyzerInst1AttributeInput(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        in_lateral = 3
        ctrl_z_nominal = 46
        ctrl_w_out = 49
        ctrl_z_out = 17
        memory_gen_drive_z = 29
        ort_adhesion_value = 65
        ramp_gen_plane_z = 39
        fast_in2 = 1
        analyzer1_y = 55
        ramp_gen_position_x = 33
        fast_in_deflection = 0
        ctrl_user2_out = 51
        ort_excitation = 69
        analyzer2_x = 60
        ctrl_z_pid_command = 44
        ctrl_x_out = 47
        in_detector_sum = 22
        gen_test_dynamic = 19
        ort_adhesion_position = 66
        ort_baseline = 62
        static = 18
        ctrl_z_sum = 45
        memory_gen_position_y = 26
        analyzer1_reference = 67
        ramp_gen_approach = 32
        analyzer2_y = 61
        in_user2 = 5
        ort_baseline_corrected = 63
        ctrl_z_in = 42
        analyzer1_ctrl_amplitude = 52
        ramp_gen_position_y = 34
        memory_gen_position_x = 24
        analyzer1_ctrl_delta_f = 16
        memory_gen_drive_y = 27
        analyzer1_amplitude = 15
        memory_gen_out8 = 31
        memory_gen_out7 = 30
        memory_gen_drive_x = 25
        ramp_gen_ctrl_z = 40
        ctrl_z_error = 43
        in_position_x = 12
        fast_in_user = 2
        in_position_y = 13
        analyzer1_phase = 53
        analyzer2_ctrl_amplitude = 57
        analyzer2_ctrl_delta_f = 56
        test_tip_voltage = 11
        test_ref = 10
        ramp_gen_position_w = 35
        in_user1 = 4
        in_deflection = 21
        ort_free_wave = 70
        ctrl_user1_out = 50
        ramp_gen_tip_voltage = 36
        analyzer2_phase = 58
        ramp_gen_test = 20
        analyzer2_reference = 68
        ramp_gen_alternate_z = 37
        test_ana_gnd = 9
        ramp_gen_max_z = 41
        ramp_gen_user4 = 38
        in_user4 = 7
        analyzer2_amplitude = 59
        ctrl_y_out = 48
        memory_gen_position_z = 28
        ort_amplitude_reduction = 64
        in_user3 = 6
        in_tip_current = 8
        in_position_z = 14
        in6 = 23
        analyzer1_x = 54

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.signal_analyzer.inst1.attribute.input'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value(self) -> ValueEnum:
        return RootLuSignal_analyzerInst1AttributeInput.ValueEnum(self._context.get('root.lu.signal_analyzer.inst1.attribute.input.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.lu.signal_analyzer.inst1.attribute.input.value_raw', new_val.value)

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.lu.signal_analyzer.inst1.attribute.input.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.lu.signal_analyzer.inst1.attribute.input.value_raw', int(new_val))

    @property
    def enum(self) -> list:
        return list(self._context.get('root.lu.signal_analyzer.inst1.attribute.input.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.lu.signal_analyzer.inst1.attribute.input.enum', list(new_val))


class RootLuSignal_analyzerInst1AttributeReference_phase(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.signal_analyzer.inst1.attribute.reference_phase'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.signal_analyzer.inst1.attribute.reference_phase.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.signal_analyzer.inst1.attribute.reference_phase.value', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.signal_analyzer.inst1.attribute.reference_phase.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.signal_analyzer.inst1.attribute.reference_phase.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.signal_analyzer.inst1.attribute.reference_phase.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.signal_analyzer.inst1.attribute.reference_phase.unit', str(new_val))

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.signal_analyzer.inst1.attribute.reference_phase.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.signal_analyzer.inst1.attribute.reference_phase.min', float(new_val))


class RootLuSignal_analyzerInst1AttributeTarget_amplitude_ctrl_mode(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        const_drive = 0
        const_amplitude = 1
        free_vibration = 2

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.signal_analyzer.inst1.attribute.target_amplitude_ctrl_mode'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value(self) -> ValueEnum:
        return RootLuSignal_analyzerInst1AttributeTarget_amplitude_ctrl_mode.ValueEnum(self._context.get('root.lu.signal_analyzer.inst1.attribute.target_amplitude_ctrl_mode.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.lu.signal_analyzer.inst1.attribute.target_amplitude_ctrl_mode.value_raw', new_val.value)

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.lu.signal_analyzer.inst1.attribute.target_amplitude_ctrl_mode.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.lu.signal_analyzer.inst1.attribute.target_amplitude_ctrl_mode.value_raw', int(new_val))

    @property
    def enum(self) -> list:
        return list(self._context.get('root.lu.signal_analyzer.inst1.attribute.target_amplitude_ctrl_mode.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.lu.signal_analyzer.inst1.attribute.target_amplitude_ctrl_mode.enum', list(new_val))


class RootLuSignal_analyzerInst1AttributePhase_ctrl_p_gain(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.signal_analyzer.inst1.attribute.phase_ctrl_p_gain'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.signal_analyzer.inst1.attribute.phase_ctrl_p_gain.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.signal_analyzer.inst1.attribute.phase_ctrl_p_gain.value', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.signal_analyzer.inst1.attribute.phase_ctrl_p_gain.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.signal_analyzer.inst1.attribute.phase_ctrl_p_gain.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.signal_analyzer.inst1.attribute.phase_ctrl_p_gain.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.signal_analyzer.inst1.attribute.phase_ctrl_p_gain.unit', str(new_val))

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.signal_analyzer.inst1.attribute.phase_ctrl_p_gain.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.signal_analyzer.inst1.attribute.phase_ctrl_p_gain.min', float(new_val))


class RootLuSignal_analyzerInst1AttributeCurrent_x_binary(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.signal_analyzer.inst1.attribute.current_x_binary'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.signal_analyzer.inst1.attribute.current_x_binary.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.signal_analyzer.inst1.attribute.current_x_binary.value', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.signal_analyzer.inst1.attribute.current_x_binary.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.signal_analyzer.inst1.attribute.current_x_binary.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.signal_analyzer.inst1.attribute.current_x_binary.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.signal_analyzer.inst1.attribute.current_x_binary.unit', str(new_val))

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.signal_analyzer.inst1.attribute.current_x_binary.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.signal_analyzer.inst1.attribute.current_x_binary.min', float(new_val))


class RootLuSignal_analyzerInst1AttributeCurrent_y(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.signal_analyzer.inst1.attribute.current_y'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.signal_analyzer.inst1.attribute.current_y.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.signal_analyzer.inst1.attribute.current_y.value', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.signal_analyzer.inst1.attribute.current_y.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.signal_analyzer.inst1.attribute.current_y.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.signal_analyzer.inst1.attribute.current_y.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.signal_analyzer.inst1.attribute.current_y.unit', str(new_val))

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.signal_analyzer.inst1.attribute.current_y.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.signal_analyzer.inst1.attribute.current_y.min', float(new_val))


class RootLuSignal_analyzerInst1AttributeCurrent_amplitude_binary(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.signal_analyzer.inst1.attribute.current_amplitude_binary'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.signal_analyzer.inst1.attribute.current_amplitude_binary.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.signal_analyzer.inst1.attribute.current_amplitude_binary.value', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.signal_analyzer.inst1.attribute.current_amplitude_binary.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.signal_analyzer.inst1.attribute.current_amplitude_binary.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.signal_analyzer.inst1.attribute.current_amplitude_binary.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.signal_analyzer.inst1.attribute.current_amplitude_binary.unit', str(new_val))

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.signal_analyzer.inst1.attribute.current_amplitude_binary.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.signal_analyzer.inst1.attribute.current_amplitude_binary.min', float(new_val))


class RootLuSignal_analyzerInst1AttributeCurrent_amplitude(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.signal_analyzer.inst1.attribute.current_amplitude'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.signal_analyzer.inst1.attribute.current_amplitude.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.signal_analyzer.inst1.attribute.current_amplitude.value', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.signal_analyzer.inst1.attribute.current_amplitude.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.signal_analyzer.inst1.attribute.current_amplitude.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.signal_analyzer.inst1.attribute.current_amplitude.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.signal_analyzer.inst1.attribute.current_amplitude.unit', str(new_val))

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.signal_analyzer.inst1.attribute.current_amplitude.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.signal_analyzer.inst1.attribute.current_amplitude.min', float(new_val))


class RootLuSignal_analyzerInst1AttributeDemodulator_bw(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        bw_23_k_hz = 11
        bw_45_k_hz = 12
        bw_1500_hz = 7
        bw_500_k_hz = 15
        bw_90_hz = 3
        bw_360_hz = 5
        bw_230_k_hz = 14
        bw_12_k_hz = 10
        bw_750_hz = 6
        bw_100_k_hz = 13
        bw_23_hz = 1
        bw_180_hz = 4
        bw_6_k_hz = 9
        bw_45_hz = 2
        bw_3_k_hz = 8

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.signal_analyzer.inst1.attribute.demodulator_bw'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value(self) -> ValueEnum:
        return RootLuSignal_analyzerInst1AttributeDemodulator_bw.ValueEnum(self._context.get('root.lu.signal_analyzer.inst1.attribute.demodulator_bw.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.lu.signal_analyzer.inst1.attribute.demodulator_bw.value_raw', new_val.value)

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.lu.signal_analyzer.inst1.attribute.demodulator_bw.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.lu.signal_analyzer.inst1.attribute.demodulator_bw.value_raw', int(new_val))

    @property
    def enum(self) -> list:
        return list(self._context.get('root.lu.signal_analyzer.inst1.attribute.demodulator_bw.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.lu.signal_analyzer.inst1.attribute.demodulator_bw.enum', list(new_val))


class RootLuSignal_analyzerInst1AttributeOperating_mode(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        pll = 1
        lock_in = 0
        kpfm = 2

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.signal_analyzer.inst1.attribute.operating_mode'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value(self) -> ValueEnum:
        return RootLuSignal_analyzerInst1AttributeOperating_mode.ValueEnum(self._context.get('root.lu.signal_analyzer.inst1.attribute.operating_mode.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.lu.signal_analyzer.inst1.attribute.operating_mode.value_raw', new_val.value)

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.lu.signal_analyzer.inst1.attribute.operating_mode.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.lu.signal_analyzer.inst1.attribute.operating_mode.value_raw', int(new_val))

    @property
    def enum(self) -> list:
        return list(self._context.get('root.lu.signal_analyzer.inst1.attribute.operating_mode.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.lu.signal_analyzer.inst1.attribute.operating_mode.enum', list(new_val))


class RootLuSignal_analyzerInst1AttributeLock_in_calc_phase(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.signal_analyzer.inst1.attribute.lock_in_calc_phase'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.signal_analyzer.inst1.attribute.lock_in_calc_phase.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.signal_analyzer.inst1.attribute.lock_in_calc_phase.value', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.signal_analyzer.inst1.attribute.lock_in_calc_phase.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.signal_analyzer.inst1.attribute.lock_in_calc_phase.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.signal_analyzer.inst1.attribute.lock_in_calc_phase.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.signal_analyzer.inst1.attribute.lock_in_calc_phase.unit', str(new_val))

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.signal_analyzer.inst1.attribute.lock_in_calc_phase.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.signal_analyzer.inst1.attribute.lock_in_calc_phase.min', float(new_val))


class RootLuSignal_analyzerInst1AttributeCurrent_phase_binary(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.signal_analyzer.inst1.attribute.current_phase_binary'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.signal_analyzer.inst1.attribute.current_phase_binary.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.signal_analyzer.inst1.attribute.current_phase_binary.value', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.signal_analyzer.inst1.attribute.current_phase_binary.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.signal_analyzer.inst1.attribute.current_phase_binary.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.signal_analyzer.inst1.attribute.current_phase_binary.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.signal_analyzer.inst1.attribute.current_phase_binary.unit', str(new_val))

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.signal_analyzer.inst1.attribute.current_phase_binary.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.signal_analyzer.inst1.attribute.current_phase_binary.min', float(new_val))


class RootLuSignal_analyzerInst1AttributeReference_source(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        harmonic1 = 1
        harmonic3 = 3
        own = 0
        harmonic2 = 2

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.signal_analyzer.inst1.attribute.reference_source'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value(self) -> ValueEnum:
        return RootLuSignal_analyzerInst1AttributeReference_source.ValueEnum(self._context.get('root.lu.signal_analyzer.inst1.attribute.reference_source.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.lu.signal_analyzer.inst1.attribute.reference_source.value_raw', new_val.value)

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.lu.signal_analyzer.inst1.attribute.reference_source.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.lu.signal_analyzer.inst1.attribute.reference_source.value_raw', int(new_val))

    @property
    def enum(self) -> list:
        return list(self._context.get('root.lu.signal_analyzer.inst1.attribute.reference_source.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.lu.signal_analyzer.inst1.attribute.reference_source.enum', list(new_val))


class RootLuSignal_analyzerInst1AttributeHarmonic_source(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        analyzer1 = 0
        analyzer2 = 1

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.signal_analyzer.inst1.attribute.harmonic_source'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value(self) -> ValueEnum:
        return RootLuSignal_analyzerInst1AttributeHarmonic_source.ValueEnum(self._context.get('root.lu.signal_analyzer.inst1.attribute.harmonic_source.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.lu.signal_analyzer.inst1.attribute.harmonic_source.value_raw', new_val.value)

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.lu.signal_analyzer.inst1.attribute.harmonic_source.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.lu.signal_analyzer.inst1.attribute.harmonic_source.value_raw', int(new_val))

    @property
    def enum(self) -> list:
        return list(self._context.get('root.lu.signal_analyzer.inst1.attribute.harmonic_source.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.lu.signal_analyzer.inst1.attribute.harmonic_source.enum', list(new_val))


class RootLuSignal_analyzerInst1AttributeCurrent_reference_amplitude(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.signal_analyzer.inst1.attribute.current_reference_amplitude'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.signal_analyzer.inst1.attribute.current_reference_amplitude.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.signal_analyzer.inst1.attribute.current_reference_amplitude.value', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.signal_analyzer.inst1.attribute.current_reference_amplitude.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.signal_analyzer.inst1.attribute.current_reference_amplitude.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.signal_analyzer.inst1.attribute.current_reference_amplitude.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.signal_analyzer.inst1.attribute.current_reference_amplitude.unit', str(new_val))

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.signal_analyzer.inst1.attribute.current_reference_amplitude.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.signal_analyzer.inst1.attribute.current_reference_amplitude.min', float(new_val))


class RootLuSignal_analyzerInst1AttributeLock_in_calc_amplitude(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.signal_analyzer.inst1.attribute.lock_in_calc_amplitude'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.signal_analyzer.inst1.attribute.lock_in_calc_amplitude.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.signal_analyzer.inst1.attribute.lock_in_calc_amplitude.value', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.signal_analyzer.inst1.attribute.lock_in_calc_amplitude.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.signal_analyzer.inst1.attribute.lock_in_calc_amplitude.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.signal_analyzer.inst1.attribute.lock_in_calc_amplitude.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.signal_analyzer.inst1.attribute.lock_in_calc_amplitude.unit', str(new_val))

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.signal_analyzer.inst1.attribute.lock_in_calc_amplitude.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.signal_analyzer.inst1.attribute.lock_in_calc_amplitude.min', float(new_val))


class RootLuSignal_analyzerInst1AttributeAmplitude_ctrl_p_gain(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.signal_analyzer.inst1.attribute.amplitude_ctrl_p_gain'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.signal_analyzer.inst1.attribute.amplitude_ctrl_p_gain.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.signal_analyzer.inst1.attribute.amplitude_ctrl_p_gain.value', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.signal_analyzer.inst1.attribute.amplitude_ctrl_p_gain.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.signal_analyzer.inst1.attribute.amplitude_ctrl_p_gain.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.signal_analyzer.inst1.attribute.amplitude_ctrl_p_gain.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.signal_analyzer.inst1.attribute.amplitude_ctrl_p_gain.unit', str(new_val))

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.signal_analyzer.inst1.attribute.amplitude_ctrl_p_gain.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.signal_analyzer.inst1.attribute.amplitude_ctrl_p_gain.min', float(new_val))


class RootLuSignal_analyzerInst1Attribute(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.signal_analyzer.inst1.attribute'
        self.amplitude_ctrl_p_gain = RootLuSignal_analyzerInst1AttributeAmplitude_ctrl_p_gain(self._context)
        self.lock_in_calc_amplitude = RootLuSignal_analyzerInst1AttributeLock_in_calc_amplitude(self._context)
        self.current_reference_amplitude = RootLuSignal_analyzerInst1AttributeCurrent_reference_amplitude(self._context)
        self.harmonic_source = RootLuSignal_analyzerInst1AttributeHarmonic_source(self._context)
        self.reference_source = RootLuSignal_analyzerInst1AttributeReference_source(self._context)
        self.current_phase_binary = RootLuSignal_analyzerInst1AttributeCurrent_phase_binary(self._context)
        self.lock_in_calc_phase = RootLuSignal_analyzerInst1AttributeLock_in_calc_phase(self._context)
        self.operating_mode = RootLuSignal_analyzerInst1AttributeOperating_mode(self._context)
        self.demodulator_bw = RootLuSignal_analyzerInst1AttributeDemodulator_bw(self._context)
        self.current_amplitude = RootLuSignal_analyzerInst1AttributeCurrent_amplitude(self._context)
        self.current_amplitude_binary = RootLuSignal_analyzerInst1AttributeCurrent_amplitude_binary(self._context)
        self.current_y = RootLuSignal_analyzerInst1AttributeCurrent_y(self._context)
        self.current_x_binary = RootLuSignal_analyzerInst1AttributeCurrent_x_binary(self._context)
        self.phase_ctrl_p_gain = RootLuSignal_analyzerInst1AttributePhase_ctrl_p_gain(self._context)
        self.target_amplitude_ctrl_mode = RootLuSignal_analyzerInst1AttributeTarget_amplitude_ctrl_mode(self._context)
        self.reference_phase = RootLuSignal_analyzerInst1AttributeReference_phase(self._context)
        self.input = RootLuSignal_analyzerInst1AttributeInput(self._context)
        self.current_x = RootLuSignal_analyzerInst1AttributeCurrent_x(self._context)
        self.amplitude_ctrl_i_gain = RootLuSignal_analyzerInst1AttributeAmplitude_ctrl_i_gain(self._context)
        self.reference_amplitude_factor = RootLuSignal_analyzerInst1AttributeReference_amplitude_factor(self._context)
        self.phase_ctrl_i_gain = RootLuSignal_analyzerInst1AttributePhase_ctrl_i_gain(self._context)
        self.reset_flag_pll_unlocked = RootLuSignal_analyzerInst1AttributeReset_flag_pll_unlocked(self._context)
        self.target_amplitude_ctrl_set_point = RootLuSignal_analyzerInst1AttributeTarget_amplitude_ctrl_set_point(self._context)
        self.reference_amplitude = RootLuSignal_analyzerInst1AttributeReference_amplitude(self._context)
        self.reference_frequency = RootLuSignal_analyzerInst1AttributeReference_frequency(self._context)
        self.amplitude_ctrl_set_point_calib_result = RootLuSignal_analyzerInst1AttributeAmplitude_ctrl_set_point_calib_result(self._context)
        self.current_y_binary = RootLuSignal_analyzerInst1AttributeCurrent_y_binary(self._context)
        self.current_amplitude_ctrl_mode = RootLuSignal_analyzerInst1AttributeCurrent_amplitude_ctrl_mode(self._context)
        self.current_ctrl_delta_f = RootLuSignal_analyzerInst1AttributeCurrent_ctrl_delta_f(self._context)
        self.current_phase = RootLuSignal_analyzerInst1AttributeCurrent_phase(self._context)
        self.amplitude_modulation = RootLuSignal_analyzerInst1AttributeAmplitude_modulation(self._context)
        self.current_ctrl_amplitude = RootLuSignal_analyzerInst1AttributeCurrent_ctrl_amplitude(self._context)
        self.phase_lock_range = RootLuSignal_analyzerInst1AttributePhase_lock_range(self._context)
        self.current_amplitude_ctrl_set_point = RootLuSignal_analyzerInst1AttributeCurrent_amplitude_ctrl_set_point(self._context)
        self.display_df_range = RootLuSignal_analyzerInst1AttributeDisplay_df_range(self._context)
        self.enable_dc_block = RootLuSignal_analyzerInst1AttributeEnable_dc_block(self._context)
        self.delay_comp = RootLuSignal_analyzerInst1AttributeDelay_comp(self._context)
        self.pll_unlocked = RootLuSignal_analyzerInst1AttributePll_unlocked(self._context)


class RootLuSignal_analyzerInst1Busy(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.signal_analyzer.inst1.busy'


class RootLuSignal_analyzerInst1(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.signal_analyzer.inst1'
        self.busy = RootLuSignal_analyzerInst1Busy(self._context)
        self.attribute = RootLuSignal_analyzerInst1Attribute(self._context)
        self.trigger = RootLuSignal_analyzerInst1Trigger(self._context)


class RootLuSignal_analyzer(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.signal_analyzer'
        self.inst1 = RootLuSignal_analyzerInst1(self._context)
        self.inst2 = RootLuSignal_analyzerInst2(self._context)


class RootLuData_acquisitionInstanceTrigger(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.data_acquisition.instance.trigger'

    def sampler_set_start_time(self) -> None:
        return self._context.call('root.lu.data_acquisition.instance.trigger.sampler_set_start_time')

    def capture_trim_data_storage(self) -> None:
        return self._context.call('root.lu.data_acquisition.instance.trigger.capture_trim_data_storage')

    def sampler_start(self) -> None:
        return self._context.call('root.lu.data_acquisition.instance.trigger.sampler_start')

    def sampler_trim_data_storage(self) -> None:
        return self._context.call('root.lu.data_acquisition.instance.trigger.sampler_trim_data_storage')

    def capture_set_start_time(self) -> None:
        return self._context.call('root.lu.data_acquisition.instance.trigger.capture_set_start_time')

    def capture_prepare(self) -> None:
        return self._context.call('root.lu.data_acquisition.instance.trigger.capture_prepare')

    def capture_start(self) -> None:
        return self._context.call('root.lu.data_acquisition.instance.trigger.capture_start')

    def background_sampler_start(self) -> None:
        return self._context.call('root.lu.data_acquisition.instance.trigger.background_sampler_start')

    def background_capture_start(self) -> None:
        return self._context.call('root.lu.data_acquisition.instance.trigger.background_capture_start')

    def abort_all(self) -> None:
        return self._context.call('root.lu.data_acquisition.instance.trigger.abort_all')

    def sampler_prepare(self) -> None:
        return self._context.call('root.lu.data_acquisition.instance.trigger.sampler_prepare')

    def sampler_init_phase_mode(self) -> None:
        return self._context.call('root.lu.data_acquisition.instance.trigger.sampler_init_phase_mode')


class RootLuData_acquisitionInstanceAttributeSampler_hi_res_ch2_input(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        in_lateral = 1
        ctrl_z_nominal = 15
        ctrl_w_out = 43
        ctrl_z_out = 14
        memory_gen_drive_z = 56
        ort_adhesion_value = 49
        ramp_gen_plane_z = 36
        fast_in2 = 62
        analyzer1_y = 19
        ramp_gen_position_x = 34
        fast_in_deflection = 61
        ctrl_user2_out = 45
        ort_excitation = 66
        analyzer2_x = 24
        ctrl_z_pid_command = 39
        ctrl_x_out = 41
        in_detector_sum = 10
        gen_test_dynamic = 31
        ort_adhesion_position = 50
        ort_baseline = 46
        static = 30
        ctrl_z_sum = 40
        memory_gen_position_y = 53
        analyzer1_reference = 64
        ramp_gen_approach = 33
        analyzer2_y = 25
        in_user2 = 6
        ort_baseline_corrected = 47
        ctrl_z_in = 12
        analyzer1_ctrl_amplitude = 20
        ramp_gen_position_y = 35
        memory_gen_position_x = 51
        analyzer1_ctrl_delta_f = 21
        memory_gen_drive_y = 54
        analyzer1_amplitude = 16
        memory_gen_out8 = 58
        memory_gen_out7 = 57
        memory_gen_drive_x = 52
        ramp_gen_ctrl_z = 37
        ctrl_z_error = 13
        in_position_x = 2
        fast_in_user = 63
        in_position_y = 3
        analyzer1_phase = 17
        analyzer2_ctrl_amplitude = 26
        analyzer2_ctrl_delta_f = 27
        in_user1 = 5
        in_deflection = 0
        ort_free_wave = 67
        ctrl_user1_out = 44
        ramp_gen_tip_voltage = 28
        analyzer2_phase = 23
        ramp_gen_test = 32
        analyzer2_reference = 65
        ramp_gen_alternate_z = 29
        ramp_gen_position_w = 60
        ramp_gen_max_z = 38
        ramp_gen_user4 = 59
        in_user4 = 8
        analyzer2_amplitude = 22
        ctrl_y_out = 42
        memory_gen_position_z = 55
        ort_amplitude_reduction = 48
        in_user3 = 7
        in_tip_current = 9
        in_position_z = 4
        in6 = 11
        analyzer1_x = 18

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch2_input'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value(self) -> ValueEnum:
        return RootLuData_acquisitionInstanceAttributeSampler_hi_res_ch2_input.ValueEnum(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch2_input.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch2_input.value_raw', new_val.value)

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch2_input.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch2_input.value_raw', int(new_val))

    @property
    def enum(self) -> list:
        return list(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch2_input.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch2_input.enum', list(new_val))


class RootLuData_acquisitionInstanceAttributeCapture_hi_res_ch1_input(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        in_lateral = 1
        ctrl_z_nominal = 15
        ctrl_w_out = 43
        ctrl_z_out = 14
        memory_gen_drive_z = 56
        ort_adhesion_value = 49
        ramp_gen_plane_z = 36
        fast_in2 = 62
        analyzer1_y = 19
        ramp_gen_position_x = 34
        fast_in_deflection = 61
        ctrl_user2_out = 45
        ort_excitation = 66
        analyzer2_x = 24
        ctrl_z_pid_command = 39
        ctrl_x_out = 41
        in_detector_sum = 10
        gen_test_dynamic = 31
        ort_adhesion_position = 50
        ort_baseline = 46
        static = 30
        ctrl_z_sum = 40
        memory_gen_position_y = 53
        analyzer1_reference = 64
        ramp_gen_approach = 33
        analyzer2_y = 25
        in_user2 = 6
        ort_baseline_corrected = 47
        ctrl_z_in = 12
        analyzer1_ctrl_amplitude = 20
        ramp_gen_position_y = 35
        memory_gen_position_x = 51
        analyzer1_ctrl_delta_f = 21
        memory_gen_drive_y = 54
        analyzer1_amplitude = 16
        memory_gen_out8 = 58
        memory_gen_out7 = 57
        memory_gen_drive_x = 52
        ramp_gen_ctrl_z = 37
        ctrl_z_error = 13
        in_position_x = 2
        fast_in_user = 63
        in_position_y = 3
        analyzer1_phase = 17
        analyzer2_ctrl_amplitude = 26
        analyzer2_ctrl_delta_f = 27
        in_user1 = 5
        in_deflection = 0
        ort_free_wave = 67
        ctrl_user1_out = 44
        ramp_gen_tip_voltage = 28
        analyzer2_phase = 23
        ramp_gen_test = 32
        analyzer2_reference = 65
        ramp_gen_alternate_z = 29
        ramp_gen_position_w = 60
        ramp_gen_max_z = 38
        ramp_gen_user4 = 59
        in_user4 = 8
        analyzer2_amplitude = 22
        ctrl_y_out = 42
        memory_gen_position_z = 55
        ort_amplitude_reduction = 48
        in_user3 = 7
        in_tip_current = 9
        in_position_z = 4
        in6 = 11
        analyzer1_x = 18

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.data_acquisition.instance.attribute.capture_hi_res_ch1_input'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value(self) -> ValueEnum:
        return RootLuData_acquisitionInstanceAttributeCapture_hi_res_ch1_input.ValueEnum(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch1_input.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch1_input.value_raw', new_val.value)

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch1_input.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch1_input.value_raw', int(new_val))

    @property
    def enum(self) -> list:
        return list(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch1_input.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch1_input.enum', list(new_val))


class RootLuData_acquisitionInstanceAttributeNumber_of_capture_sets(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.data_acquisition.instance.attribute.number_of_capture_sets'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.data_acquisition.instance.attribute.number_of_capture_sets.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.data_acquisition.instance.attribute.number_of_capture_sets.value', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.data_acquisition.instance.attribute.number_of_capture_sets.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.data_acquisition.instance.attribute.number_of_capture_sets.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.data_acquisition.instance.attribute.number_of_capture_sets.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.data_acquisition.instance.attribute.number_of_capture_sets.unit', str(new_val))

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.data_acquisition.instance.attribute.number_of_capture_sets.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.data_acquisition.instance.attribute.number_of_capture_sets.min', float(new_val))


class RootLuData_acquisitionInstanceAttributeCapture_hi_res_ch7_input(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        in_lateral = 1
        ctrl_z_nominal = 15
        ctrl_w_out = 43
        ctrl_z_out = 14
        memory_gen_drive_z = 56
        ort_adhesion_value = 49
        ramp_gen_plane_z = 36
        fast_in2 = 62
        analyzer1_y = 19
        ramp_gen_position_x = 34
        fast_in_deflection = 61
        ctrl_user2_out = 45
        ort_excitation = 66
        analyzer2_x = 24
        ctrl_z_pid_command = 39
        ctrl_x_out = 41
        in_detector_sum = 10
        gen_test_dynamic = 31
        ort_adhesion_position = 50
        ort_baseline = 46
        static = 30
        ctrl_z_sum = 40
        memory_gen_position_y = 53
        analyzer1_reference = 64
        ramp_gen_approach = 33
        analyzer2_y = 25
        in_user2 = 6
        ort_baseline_corrected = 47
        ctrl_z_in = 12
        analyzer1_ctrl_amplitude = 20
        ramp_gen_position_y = 35
        memory_gen_position_x = 51
        analyzer1_ctrl_delta_f = 21
        memory_gen_drive_y = 54
        analyzer1_amplitude = 16
        memory_gen_out8 = 58
        memory_gen_out7 = 57
        memory_gen_drive_x = 52
        ramp_gen_ctrl_z = 37
        ctrl_z_error = 13
        in_position_x = 2
        fast_in_user = 63
        in_position_y = 3
        analyzer1_phase = 17
        analyzer2_ctrl_amplitude = 26
        analyzer2_ctrl_delta_f = 27
        in_user1 = 5
        in_deflection = 0
        ort_free_wave = 67
        ctrl_user1_out = 44
        ramp_gen_tip_voltage = 28
        analyzer2_phase = 23
        ramp_gen_test = 32
        analyzer2_reference = 65
        ramp_gen_alternate_z = 29
        ramp_gen_position_w = 60
        ramp_gen_max_z = 38
        ramp_gen_user4 = 59
        in_user4 = 8
        analyzer2_amplitude = 22
        ctrl_y_out = 42
        memory_gen_position_z = 55
        ort_amplitude_reduction = 48
        in_user3 = 7
        in_tip_current = 9
        in_position_z = 4
        in6 = 11
        analyzer1_x = 18

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.data_acquisition.instance.attribute.capture_hi_res_ch7_input'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value(self) -> ValueEnum:
        return RootLuData_acquisitionInstanceAttributeCapture_hi_res_ch7_input.ValueEnum(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch7_input.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch7_input.value_raw', new_val.value)

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch7_input.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch7_input.value_raw', int(new_val))

    @property
    def enum(self) -> list:
        return list(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch7_input.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch7_input.enum', list(new_val))


class RootLuData_acquisitionInstanceAttributeCapture_hi_res_group_id(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.data_acquisition.instance.attribute.capture_hi_res_group_id'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_group_id.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_group_id.value', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_group_id.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_group_id.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_group_id.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_group_id.unit', str(new_val))

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_group_id.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_group_id.min', float(new_val))


class RootLuData_acquisitionInstanceAttributeCapture_hi_res_datapoints(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.data_acquisition.instance.attribute.capture_hi_res_datapoints'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_datapoints.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_datapoints.value', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_datapoints.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_datapoints.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_datapoints.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_datapoints.unit', str(new_val))

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_datapoints.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_datapoints.min', float(new_val))


class RootLuData_acquisitionInstanceAttributeCapture_hi_res_ch_input_vec(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        in_lateral = 1
        ctrl_z_nominal = 15
        ctrl_w_out = 43
        ctrl_z_out = 14
        memory_gen_drive_z = 56
        ort_adhesion_value = 49
        ramp_gen_plane_z = 36
        fast_in2 = 62
        analyzer1_y = 19
        ramp_gen_position_x = 34
        fast_in_deflection = 61
        ctrl_user2_out = 45
        ort_excitation = 66
        analyzer2_x = 24
        ctrl_z_pid_command = 39
        ctrl_x_out = 41
        in_detector_sum = 10
        gen_test_dynamic = 31
        ort_adhesion_position = 50
        ort_baseline = 46
        static = 30
        ctrl_z_sum = 40
        memory_gen_position_y = 53
        analyzer1_reference = 64
        ramp_gen_approach = 33
        analyzer2_y = 25
        in_user2 = 6
        ort_baseline_corrected = 47
        ctrl_z_in = 12
        analyzer1_ctrl_amplitude = 20
        ramp_gen_position_y = 35
        memory_gen_position_x = 51
        analyzer1_ctrl_delta_f = 21
        memory_gen_drive_y = 54
        analyzer1_amplitude = 16
        memory_gen_out8 = 58
        memory_gen_out7 = 57
        memory_gen_drive_x = 52
        ramp_gen_ctrl_z = 37
        ctrl_z_error = 13
        in_position_x = 2
        fast_in_user = 63
        in_position_y = 3
        analyzer1_phase = 17
        analyzer2_ctrl_amplitude = 26
        analyzer2_ctrl_delta_f = 27
        in_user1 = 5
        in_deflection = 0
        ort_free_wave = 67
        ctrl_user1_out = 44
        ramp_gen_tip_voltage = 28
        analyzer2_phase = 23
        ramp_gen_test = 32
        analyzer2_reference = 65
        ramp_gen_alternate_z = 29
        ramp_gen_position_w = 60
        ramp_gen_max_z = 38
        ramp_gen_user4 = 59
        in_user4 = 8
        analyzer2_amplitude = 22
        ctrl_y_out = 42
        memory_gen_position_z = 55
        ort_amplitude_reduction = 48
        in_user3 = 7
        in_tip_current = 9
        in_position_z = 4
        in6 = 11
        analyzer1_x = 18

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.data_acquisition.instance.attribute.capture_hi_res_ch_input_vec'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def vector(self) -> list:
        return list(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch_input_vec.vector'))

    @vector.setter
    def vector(self, new_val:list):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch_input_vec.vector', list(new_val))

    @property
    def enum(self) -> list:
        return list(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch_input_vec.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch_input_vec.enum', list(new_val))


class RootLuData_acquisitionInstanceAttributeSampler_hi_res_ch6_input(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        in_lateral = 1
        ctrl_z_nominal = 15
        ctrl_w_out = 43
        ctrl_z_out = 14
        memory_gen_drive_z = 56
        ort_adhesion_value = 49
        ramp_gen_plane_z = 36
        fast_in2 = 62
        analyzer1_y = 19
        ramp_gen_position_x = 34
        fast_in_deflection = 61
        ctrl_user2_out = 45
        ort_excitation = 66
        analyzer2_x = 24
        ctrl_z_pid_command = 39
        ctrl_x_out = 41
        in_detector_sum = 10
        gen_test_dynamic = 31
        ort_adhesion_position = 50
        ort_baseline = 46
        static = 30
        ctrl_z_sum = 40
        memory_gen_position_y = 53
        analyzer1_reference = 64
        ramp_gen_approach = 33
        analyzer2_y = 25
        in_user2 = 6
        ort_baseline_corrected = 47
        ctrl_z_in = 12
        analyzer1_ctrl_amplitude = 20
        ramp_gen_position_y = 35
        memory_gen_position_x = 51
        analyzer1_ctrl_delta_f = 21
        memory_gen_drive_y = 54
        analyzer1_amplitude = 16
        memory_gen_out8 = 58
        memory_gen_out7 = 57
        memory_gen_drive_x = 52
        ramp_gen_ctrl_z = 37
        ctrl_z_error = 13
        in_position_x = 2
        fast_in_user = 63
        in_position_y = 3
        analyzer1_phase = 17
        analyzer2_ctrl_amplitude = 26
        analyzer2_ctrl_delta_f = 27
        in_user1 = 5
        in_deflection = 0
        ort_free_wave = 67
        ctrl_user1_out = 44
        ramp_gen_tip_voltage = 28
        analyzer2_phase = 23
        ramp_gen_test = 32
        analyzer2_reference = 65
        ramp_gen_alternate_z = 29
        ramp_gen_position_w = 60
        ramp_gen_max_z = 38
        ramp_gen_user4 = 59
        in_user4 = 8
        analyzer2_amplitude = 22
        ctrl_y_out = 42
        memory_gen_position_z = 55
        ort_amplitude_reduction = 48
        in_user3 = 7
        in_tip_current = 9
        in_position_z = 4
        in6 = 11
        analyzer1_x = 18

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch6_input'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value(self) -> ValueEnum:
        return RootLuData_acquisitionInstanceAttributeSampler_hi_res_ch6_input.ValueEnum(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch6_input.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch6_input.value_raw', new_val.value)

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch6_input.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch6_input.value_raw', int(new_val))

    @property
    def enum(self) -> list:
        return list(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch6_input.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch6_input.enum', list(new_val))


class RootLuData_acquisitionInstanceAttributePhase_sampler_data_rate_vec(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.data_acquisition.instance.attribute.phase_sampler_data_rate_vec'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def vector(self) -> list:
        return list(self._context.get('root.lu.data_acquisition.instance.attribute.phase_sampler_data_rate_vec.vector'))

    @vector.setter
    def vector(self, new_val:list):
        self._context.set('root.lu.data_acquisition.instance.attribute.phase_sampler_data_rate_vec.vector', list(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.data_acquisition.instance.attribute.phase_sampler_data_rate_vec.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.data_acquisition.instance.attribute.phase_sampler_data_rate_vec.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.data_acquisition.instance.attribute.phase_sampler_data_rate_vec.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.data_acquisition.instance.attribute.phase_sampler_data_rate_vec.unit', str(new_val))

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.data_acquisition.instance.attribute.phase_sampler_data_rate_vec.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.data_acquisition.instance.attribu