"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const cdk = require("aws-cdk-lib");
const aws_kms_1 = require("aws-cdk-lib/aws-kms");
const aws_s3_1 = require("aws-cdk-lib/aws-s3");
const dsf = require("../../index");
class ExampleDataCatalogDatabaseCrawlerStack extends cdk.Stack {
    constructor(scope, id) {
        super(scope, id);
        const bucket = new aws_s3_1.Bucket(this, 'DataCatalogBucket');
        /// !show
        const encryptionKey = new aws_kms_1.Key(this, 'CrawlerLogEncryptionKey');
        new dsf.governance.DataCatalogDatabase(this, 'DataCatalogDatabase', {
            locationBucket: bucket,
            locationPrefix: '/databasePath',
            name: 'example-db',
            autoCrawl: true,
            autoCrawlSchedule: {
                scheduleExpression: 'cron(1 0 * * ? *)',
            },
            crawlerLogEncryptionKey: encryptionKey,
            crawlerTableLevelDepth: 3,
        });
        /// !hide
    }
}
const app = new cdk.App();
new ExampleDataCatalogDatabaseCrawlerStack(app, 'ExampleDataCatalogDatabaseCrawlerStack');
//# sourceMappingURL=data:application/json;base64,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