"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const cdk = require("aws-cdk-lib");
const aws_s3_1 = require("aws-cdk-lib/aws-s3");
const dsf = require("../../index");
/// !show
class ExampleDefaultDataCatalogDatabaseStack extends cdk.Stack {
    constructor(scope, id) {
        super(scope, id);
        const bucket = new aws_s3_1.Bucket(this, 'DataCatalogBucket');
        new dsf.governance.DataCatalogDatabase(this, 'DataCatalogDatabase', {
            locationBucket: bucket,
            locationPrefix: '/databasePath',
            name: 'example-db',
        });
    }
}
/// !hide
const app = new cdk.App();
new ExampleDefaultDataCatalogDatabaseStack(app, 'ExampleDefaultDataCatalogDatabaseStack');
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiZGF0YS1jYXRhbG9nLWRhdGFiYXNlLWRlZmF1bHQubGl0LmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiLi4vLi4vLi4vc3JjL2dvdmVybmFuY2UvZXhhbXBsZXMvZGF0YS1jYXRhbG9nLWRhdGFiYXNlLWRlZmF1bHQubGl0LnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7O0FBQUEsbUNBQW1DO0FBQ25DLCtDQUE0QztBQUU1QyxtQ0FBbUM7QUFFbkMsU0FBUztBQUNULE1BQU0sc0NBQXVDLFNBQVEsR0FBRyxDQUFDLEtBQUs7SUFDMUQsWUFBWSxLQUFnQixFQUFFLEVBQVU7UUFDcEMsS0FBSyxDQUFDLEtBQUssRUFBRSxFQUFFLENBQUMsQ0FBQztRQUNqQixNQUFNLE1BQU0sR0FBRyxJQUFJLGVBQU0sQ0FBQyxJQUFJLEVBQUUsbUJBQW1CLENBQUMsQ0FBQztRQUVyRCxJQUFJLEdBQUcsQ0FBQyxVQUFVLENBQUMsbUJBQW1CLENBQUMsSUFBSSxFQUFFLHFCQUFxQixFQUFFO1lBQ2hFLGNBQWMsRUFBRSxNQUFNO1lBQ3RCLGNBQWMsRUFBRSxlQUFlO1lBQy9CLElBQUksRUFBRSxZQUFZO1NBQ3JCLENBQUMsQ0FBQztJQUNQLENBQUM7Q0FDSjtBQUNELFNBQVM7QUFFVCxNQUFNLEdBQUcsR0FBRyxJQUFJLEdBQUcsQ0FBQyxHQUFHLEVBQUUsQ0FBQztBQUMxQixJQUFJLHNDQUFzQyxDQUFDLEdBQUcsRUFBRSx3Q0FBd0MsQ0FBQyxDQUFDIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0ICogYXMgY2RrIGZyb20gJ2F3cy1jZGstbGliJztcbmltcG9ydCB7IEJ1Y2tldCB9IGZyb20gJ2F3cy1jZGstbGliL2F3cy1zMyc7XG5pbXBvcnQgeyBDb25zdHJ1Y3QgfSBmcm9tICdjb25zdHJ1Y3RzJztcbmltcG9ydCAqIGFzIGRzZiBmcm9tICcuLi8uLi9pbmRleCc7XG5cbi8vLyAhc2hvd1xuY2xhc3MgRXhhbXBsZURlZmF1bHREYXRhQ2F0YWxvZ0RhdGFiYXNlU3RhY2sgZXh0ZW5kcyBjZGsuU3RhY2sge1xuICAgIGNvbnN0cnVjdG9yKHNjb3BlOiBDb25zdHJ1Y3QsIGlkOiBzdHJpbmcpIHtcbiAgICAgICAgc3VwZXIoc2NvcGUsIGlkKTtcbiAgICAgICAgY29uc3QgYnVja2V0ID0gbmV3IEJ1Y2tldCh0aGlzLCAnRGF0YUNhdGFsb2dCdWNrZXQnKTtcblxuICAgICAgICBuZXcgZHNmLmdvdmVybmFuY2UuRGF0YUNhdGFsb2dEYXRhYmFzZSh0aGlzLCAnRGF0YUNhdGFsb2dEYXRhYmFzZScsIHtcbiAgICAgICAgICAgIGxvY2F0aW9uQnVja2V0OiBidWNrZXQsXG4gICAgICAgICAgICBsb2NhdGlvblByZWZpeDogJy9kYXRhYmFzZVBhdGgnLFxuICAgICAgICAgICAgbmFtZTogJ2V4YW1wbGUtZGInLFxuICAgICAgICB9KTtcbiAgICB9XG59XG4vLy8gIWhpZGVcblxuY29uc3QgYXBwID0gbmV3IGNkay5BcHAoKTtcbm5ldyBFeGFtcGxlRGVmYXVsdERhdGFDYXRhbG9nRGF0YWJhc2VTdGFjayhhcHAsICdFeGFtcGxlRGVmYXVsdERhdGFDYXRhbG9nRGF0YWJhc2VTdGFjaycpOyJdfQ==