"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const cdk = require("aws-cdk-lib");
const aws_kms_1 = require("aws-cdk-lib/aws-kms");
const dsf = require("../../index");
class ExampleDefaultDataLakeCatalogStack extends cdk.Stack {
    constructor(scope, id) {
        super(scope, id);
        const storage = new dsf.storage.DataLakeStorage(this, 'MyDataLakeStorage');
        /// !show
        const encryptionKey = new aws_kms_1.Key(this, 'CrawlerLogEncryptionKey');
        new dsf.governance.DataLakeCatalog(this, 'DataCatalog', {
            dataLakeStorage: storage,
            autoCrawl: true,
            autoCrawlSchedule: {
                scheduleExpression: 'cron(1 0 * * ? *)',
            },
            crawlerLogEncryptionKey: encryptionKey,
            crawlerTableLevelDepth: 3,
        });
        /// !hide
    }
}
const app = new cdk.App();
new ExampleDefaultDataLakeCatalogStack(app, 'ExampleDefaultDataLakeCatalogStack');
//# sourceMappingURL=data:application/json;base64,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