"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const cdk = require("aws-cdk-lib");
const dsf = require("../../index");
/// !show
class ExampleDefaultDataLakeCatalogStack extends cdk.Stack {
    constructor(scope, id) {
        super(scope, id);
        const storage = new dsf.storage.DataLakeStorage(this, 'MyDataLakeStorage');
        new dsf.governance.DataLakeCatalog(this, 'DataCatalog', {
            dataLakeStorage: storage,
        });
    }
}
/// !hide
const app = new cdk.App();
new ExampleDefaultDataLakeCatalogStack(app, 'ExampleDefaultDataLakeCatalogStack');
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiZGF0YS1sYWtlLWNhdGFsb2ctZGVmYXVsdC5saXQuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyIuLi8uLi8uLi9zcmMvZ292ZXJuYW5jZS9leGFtcGxlcy9kYXRhLWxha2UtY2F0YWxvZy1kZWZhdWx0LmxpdC50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOztBQUFBLG1DQUFtQztBQUVuQyxtQ0FBbUM7QUFFbkMsU0FBUztBQUNULE1BQU0sa0NBQW1DLFNBQVEsR0FBRyxDQUFDLEtBQUs7SUFDdEQsWUFBWSxLQUFnQixFQUFFLEVBQVU7UUFDcEMsS0FBSyxDQUFDLEtBQUssRUFBRSxFQUFFLENBQUMsQ0FBQztRQUNqQixNQUFNLE9BQU8sR0FBRyxJQUFJLEdBQUcsQ0FBQyxPQUFPLENBQUMsZUFBZSxDQUFDLElBQUksRUFBRSxtQkFBbUIsQ0FBQyxDQUFDO1FBRTNFLElBQUksR0FBRyxDQUFDLFVBQVUsQ0FBQyxlQUFlLENBQUMsSUFBSSxFQUFFLGFBQWEsRUFBRTtZQUNwRCxlQUFlLEVBQUUsT0FBTztTQUMzQixDQUFDLENBQUM7SUFDUCxDQUFDO0NBQ0o7QUFDRCxTQUFTO0FBRVQsTUFBTSxHQUFHLEdBQUcsSUFBSSxHQUFHLENBQUMsR0FBRyxFQUFFLENBQUM7QUFDMUIsSUFBSSxrQ0FBa0MsQ0FBQyxHQUFHLEVBQUUsb0NBQW9DLENBQUMsQ0FBQyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCAqIGFzIGNkayBmcm9tICdhd3MtY2RrLWxpYic7XG5pbXBvcnQgeyBDb25zdHJ1Y3QgfSBmcm9tICdjb25zdHJ1Y3RzJztcbmltcG9ydCAqIGFzIGRzZiBmcm9tICcuLi8uLi9pbmRleCc7XG5cbi8vLyAhc2hvd1xuY2xhc3MgRXhhbXBsZURlZmF1bHREYXRhTGFrZUNhdGFsb2dTdGFjayBleHRlbmRzIGNkay5TdGFjayB7XG4gICAgY29uc3RydWN0b3Ioc2NvcGU6IENvbnN0cnVjdCwgaWQ6IHN0cmluZykge1xuICAgICAgICBzdXBlcihzY29wZSwgaWQpO1xuICAgICAgICBjb25zdCBzdG9yYWdlID0gbmV3IGRzZi5zdG9yYWdlLkRhdGFMYWtlU3RvcmFnZSh0aGlzLCAnTXlEYXRhTGFrZVN0b3JhZ2UnKTtcblxuICAgICAgICBuZXcgZHNmLmdvdmVybmFuY2UuRGF0YUxha2VDYXRhbG9nKHRoaXMsICdEYXRhQ2F0YWxvZycsIHtcbiAgICAgICAgICAgIGRhdGFMYWtlU3RvcmFnZTogc3RvcmFnZSxcbiAgICAgICAgfSk7XG4gICAgfVxufVxuLy8vICFoaWRlXG5cbmNvbnN0IGFwcCA9IG5ldyBjZGsuQXBwKCk7XG5uZXcgRXhhbXBsZURlZmF1bHREYXRhTGFrZUNhdGFsb2dTdGFjayhhcHAsICdFeGFtcGxlRGVmYXVsdERhdGFMYWtlQ2F0YWxvZ1N0YWNrJyk7Il19