import { CfnCrawler, CfnDatabase, CfnSecurityConfiguration } from 'aws-cdk-lib/aws-glue';
import { AddToPrincipalPolicyResult, IPrincipal, IRole } from 'aws-cdk-lib/aws-iam';
import { IKey } from 'aws-cdk-lib/aws-kms';
import { Construct } from 'constructs';
import { DataCatalogDatabaseProps } from './data-catalog-database-props';
import { TrackedConstruct } from '../../utils';
/**
 * An AWS Glue Data Catalog Database configured with the location and a crawler.
 * @see https://awslabs.github.io/data-solutions-framework-on-aws/docs/constructs/library/data-catalog-database
 *
 * @example
 * import { Bucket } from 'aws-cdk-lib/aws-s3';
 *
 * new dsf.governance.DataCatalogDatabase(this, 'ExampleDatabase', {
 *    locationBucket: new Bucket(scope, 'LocationBucket'),
 *    locationPrefix: '/databasePath',
 *    name: 'example-db'
 * });
 */
export declare class DataCatalogDatabase extends TrackedConstruct {
    /**
     * The Glue Crawler that is automatically created when `autoCrawl` is set to `true` (default value). This property can be undefined if `autoCrawl` is set to `false`.
     */
    readonly crawler?: CfnCrawler;
    /**
     * The Glue security configuration used by the Glue Crawler when created.
     */
    readonly crawlerSecurityConfiguration?: CfnSecurityConfiguration;
    /**
     * The IAM role used by the Glue crawler when created.
     */
    readonly crawlerRole?: IRole;
    /**
     * The Glue database that's created
     */
    readonly database: CfnDatabase;
    /**
     * The Glue database name with the randomized suffix to prevent name collisions in the catalog
     */
    readonly databaseName: string;
    /**
     * KMS encryption key used by the Crawler
     */
    readonly crawlerLogEncryptionKey?: IKey;
    /**
     * Caching constructor properties for internal reuse by constructor methods
     */
    private dataCatalogDatabaseProps;
    constructor(scope: Construct, id: string, props: DataCatalogDatabaseProps);
    /**
     * Grants read access via identity based policy to the principal. This would attach an IAM policy to the principal allowing read access to the database and all its tables.
     * @param principal Principal to attach the database read access to
     * @returns `AddToPrincipalPolicyResult`
     */
    grantReadOnlyAccess(principal: IPrincipal): AddToPrincipalPolicyResult;
    private calculateDefaultTableLevelDepth;
}
