import { IKey } from 'aws-cdk-lib/aws-kms';
import { Construct } from 'constructs';
import { DataCatalogDatabase } from './data-catalog-database';
import { DataLakeCatalogProps } from './data-lake-catalog-props';
import { TrackedConstruct } from '../../utils';
/**
* Creates AWS Glue Catalog Database for each storage layer. Composed of 3 {@link DataCatalogDatabase} for Bronze, Silver, and Gold data.
* @see https://awslabs.github.io/data-solutions-framework-on-aws/docs/constructs/library/data-lake-catalog
 *
* @example
* import { Key } from 'aws-cdk-lib/aws-kms';
*
* const logEncryptionKey = new Key(this, 'LogEncryptionKey');
* const storage = new dsf.storage.DataLakeStorage(this, "ExampleStorage");
* const dataLakeCatalog = new dsf.governance.DataLakeCatalog(this, "ExampleDataLakeCatalog", {
*   dataLakeStorage: storage,
*   databaseName: "exampledb",
*   crawlerLogEncryptionKey: logEncryptionKey
* })
*/
export declare class DataLakeCatalog extends TrackedConstruct {
    /**
     * The Glue Database for Bronze bucket
     */
    readonly bronzeCatalogDatabase: DataCatalogDatabase;
    /**
     * The Glue Database for Silver bucket
     */
    readonly silverCatalogDatabase: DataCatalogDatabase;
    /**
     * The Glue Database for Gold bucket
     */
    readonly goldCatalogDatabase: DataCatalogDatabase;
    /**
     * The KMS Key used to encrypt the crawler logs.
     */
    readonly crawlerLogEncryptionKey?: IKey;
    /**
     * Constructs a new instance of DataLakeCatalog
     * @param {Construct} scope the Scope of the CDK Construct
     * @param {string} id the ID of the CDK Construct
     * @param {DataLakeCatalogProps} props the DataLakeCatalog properties
     */
    constructor(scope: Construct, id: string, props: DataLakeCatalogProps);
    /**
     * Extract the bucket prefix from the {@link AnalyticsBucket} bucket name.
     * @param {AnalyticsBucket} bucket
     * @returns
     */
    private extractBucketName;
}
