"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.EmrApplicationStack = exports.EmrApplicationStackFactory = void 0;
const cdk = require("aws-cdk-lib");
const dsf = require("../../index");
/// !show
class EmrApplicationStackFactory extends dsf.utils.ApplicationStackFactory {
    createStack(scope, stage) {
        return new EmrApplicationStack(scope, 'EmrApplicationStack', stage);
    }
}
exports.EmrApplicationStackFactory = EmrApplicationStackFactory;
class EmrApplicationStack extends cdk.Stack {
    constructor(scope, id, stage) {
        super(scope, id);
        // DEFINE YOUR APPLICATION STACK HERE
        // USE STAGE PARAMETER TO CUSTOMIZE THE STACK BEHAVIOR
        if (stage == dsf.utils.CICDStage.PROD) {
            // prod only
        }
    }
}
exports.EmrApplicationStack = EmrApplicationStack;
/// !hide
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiY2ljZC1hcHBsaWNhdGlvbi1zdGFjay5saXQuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyIuLi8uLi8uLi9zcmMvcHJvY2Vzc2luZy9leGFtcGxlcy9jaWNkLWFwcGxpY2F0aW9uLXN0YWNrLmxpdC50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7QUFBQSxtQ0FBbUM7QUFFbkMsbUNBQW1DO0FBRW5DLFNBQVM7QUFDVCxNQUFhLDBCQUEyQixTQUFRLEdBQUcsQ0FBQyxLQUFLLENBQUMsdUJBQXVCO0lBQzdFLFdBQVcsQ0FBQyxLQUFnQixFQUFFLEtBQTBCO1FBQ3BELE9BQU8sSUFBSSxtQkFBbUIsQ0FBQyxLQUFLLEVBQUUscUJBQXFCLEVBQUUsS0FBSyxDQUFDLENBQUM7SUFDeEUsQ0FBQztDQUNKO0FBSkQsZ0VBSUM7QUFFRCxNQUFhLG1CQUFvQixTQUFRLEdBQUcsQ0FBQyxLQUFLO0lBQzlDLFlBQVksS0FBZ0IsRUFBRSxFQUFVLEVBQUUsS0FBMEI7UUFDaEUsS0FBSyxDQUFDLEtBQUssRUFBRSxFQUFFLENBQUMsQ0FBQztRQUVqQixxQ0FBcUM7UUFDckMsc0RBQXNEO1FBRXRELElBQUksS0FBSyxJQUFJLEdBQUcsQ0FBQyxLQUFLLENBQUMsU0FBUyxDQUFDLElBQUksRUFBRTtZQUNuQyxZQUFZO1NBQ2Y7SUFDTCxDQUFDO0NBQ0o7QUFYRCxrREFXQztBQUNELFNBQVMiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgKiBhcyBjZGsgZnJvbSAnYXdzLWNkay1saWInO1xuaW1wb3J0IHsgQ29uc3RydWN0IH0gZnJvbSAnY29uc3RydWN0cyc7XG5pbXBvcnQgKiBhcyBkc2YgZnJvbSAnLi4vLi4vaW5kZXgnO1xuXG4vLy8gIXNob3dcbmV4cG9ydCBjbGFzcyBFbXJBcHBsaWNhdGlvblN0YWNrRmFjdG9yeSBleHRlbmRzIGRzZi51dGlscy5BcHBsaWNhdGlvblN0YWNrRmFjdG9yeSB7XG4gICAgY3JlYXRlU3RhY2soc2NvcGU6IENvbnN0cnVjdCwgc3RhZ2U6IGRzZi51dGlscy5DSUNEU3RhZ2UpOiBjZGsuU3RhY2sge1xuICAgICAgICByZXR1cm4gbmV3IEVtckFwcGxpY2F0aW9uU3RhY2soc2NvcGUsICdFbXJBcHBsaWNhdGlvblN0YWNrJywgc3RhZ2UpO1xuICAgIH1cbn1cblxuZXhwb3J0IGNsYXNzIEVtckFwcGxpY2F0aW9uU3RhY2sgZXh0ZW5kcyBjZGsuU3RhY2sge1xuICAgIGNvbnN0cnVjdG9yKHNjb3BlOiBDb25zdHJ1Y3QsIGlkOiBzdHJpbmcsIHN0YWdlOiBkc2YudXRpbHMuQ0lDRFN0YWdlKSB7XG4gICAgICAgIHN1cGVyKHNjb3BlLCBpZCk7XG5cbiAgICAgICAgLy8gREVGSU5FIFlPVVIgQVBQTElDQVRJT04gU1RBQ0sgSEVSRVxuICAgICAgICAvLyBVU0UgU1RBR0UgUEFSQU1FVEVSIFRPIENVU1RPTUlaRSBUSEUgU1RBQ0sgQkVIQVZJT1JcblxuICAgICAgICBpZiAoc3RhZ2UgPT0gZHNmLnV0aWxzLkNJQ0RTdGFnZS5QUk9EKSB7XG4gICAgICAgICAgICAvLyBwcm9kIG9ubHlcbiAgICAgICAgfVxuICAgIH1cbn1cbi8vLyAhaGlkZSJdfQ==