"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.CICDPipelineStack = void 0;
const cdk = require("aws-cdk-lib");
const aws_iam_1 = require("aws-cdk-lib/aws-iam");
const cicd_application_stack_lit_1 = require("./cicd-application-stack.lit");
const dsf = require("../../index");
class CICDPipelineStack extends cdk.Stack {
    constructor(scope, id) {
        super(scope, id);
        /// !show
        new dsf.processing.SparkEmrCICDPipeline(this, 'SparkCICDPipeline', {
            sparkApplicationName: 'SparkTest',
            applicationStackFactory: new cicd_application_stack_lit_1.EmrApplicationStackFactory(),
            integTestScript: 'spark/integ.sh',
            integTestEnv: {
                STEP_FUNCTION_ARN: 'ProcessingStateMachineArn',
            },
            integTestPermissions: [
                new aws_iam_1.PolicyStatement({
                    actions: [
                        'states:StartExecution',
                        'states:DescribeExecution',
                    ],
                    resources: ['*'],
                }),
            ],
        });
        /// !hide
    }
}
exports.CICDPipelineStack = CICDPipelineStack;
const app = new cdk.App();
new CICDPipelineStack(app, 'CICDPipelineStack');
//# sourceMappingURL=data:application/json;base64,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