"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.CICDPipelineStack = void 0;
const cdk = require("aws-cdk-lib");
const cicd_application_stack_lit_1 = require("./cicd-application-stack.lit");
const dsf = require("../../index");
/// !show
class CICDPipelineStack extends cdk.Stack {
    constructor(scope, id) {
        super(scope, id);
        new dsf.processing.SparkEmrCICDPipeline(this, 'SparkCICDPipeline', {
            sparkApplicationName: 'SparkTest',
            applicationStackFactory: new cicd_application_stack_lit_1.EmrApplicationStackFactory(),
        });
    }
}
exports.CICDPipelineStack = CICDPipelineStack;
/// !hide
const app = new cdk.App();
new CICDPipelineStack(app, 'CICDPipelineStack');
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiY2ljZC1waXBlbGluZS1zdGFjay5saXQuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyIuLi8uLi8uLi9zcmMvcHJvY2Vzc2luZy9leGFtcGxlcy9jaWNkLXBpcGVsaW5lLXN0YWNrLmxpdC50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7QUFBQSxtQ0FBbUM7QUFFbkMsNkVBQTBFO0FBQzFFLG1DQUFtQztBQUVuQyxTQUFTO0FBQ1QsTUFBYSxpQkFBa0IsU0FBUSxHQUFHLENBQUMsS0FBSztJQUM1QyxZQUFZLEtBQWdCLEVBQUUsRUFBVTtRQUNwQyxLQUFLLENBQUMsS0FBSyxFQUFFLEVBQUUsQ0FBQyxDQUFDO1FBQ2pCLElBQUksR0FBRyxDQUFDLFVBQVUsQ0FBQyxvQkFBb0IsQ0FBQyxJQUFJLEVBQUUsbUJBQW1CLEVBQUU7WUFDL0Qsb0JBQW9CLEVBQUUsV0FBVztZQUNqQyx1QkFBdUIsRUFBRSxJQUFJLHVEQUEwQixFQUFFO1NBQzVELENBQUMsQ0FBQztJQUNQLENBQUM7Q0FDSjtBQVJELDhDQVFDO0FBQ0QsU0FBUztBQUVULE1BQU0sR0FBRyxHQUFHLElBQUksR0FBRyxDQUFDLEdBQUcsRUFBRSxDQUFDO0FBQzFCLElBQUksaUJBQWlCLENBQUMsR0FBRyxFQUFFLG1CQUFtQixDQUFDLENBQUMiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgKiBhcyBjZGsgZnJvbSAnYXdzLWNkay1saWInO1xuaW1wb3J0IHsgQ29uc3RydWN0IH0gZnJvbSAnY29uc3RydWN0cyc7XG5pbXBvcnQgeyBFbXJBcHBsaWNhdGlvblN0YWNrRmFjdG9yeSB9IGZyb20gJy4vY2ljZC1hcHBsaWNhdGlvbi1zdGFjay5saXQnO1xuaW1wb3J0ICogYXMgZHNmIGZyb20gJy4uLy4uL2luZGV4JztcblxuLy8vICFzaG93XG5leHBvcnQgY2xhc3MgQ0lDRFBpcGVsaW5lU3RhY2sgZXh0ZW5kcyBjZGsuU3RhY2sge1xuICAgIGNvbnN0cnVjdG9yKHNjb3BlOiBDb25zdHJ1Y3QsIGlkOiBzdHJpbmcpIHtcbiAgICAgICAgc3VwZXIoc2NvcGUsIGlkKTtcbiAgICAgICAgbmV3IGRzZi5wcm9jZXNzaW5nLlNwYXJrRW1yQ0lDRFBpcGVsaW5lKHRoaXMsICdTcGFya0NJQ0RQaXBlbGluZScsIHtcbiAgICAgICAgICAgIHNwYXJrQXBwbGljYXRpb25OYW1lOiAnU3BhcmtUZXN0JyxcbiAgICAgICAgICAgIGFwcGxpY2F0aW9uU3RhY2tGYWN0b3J5OiBuZXcgRW1yQXBwbGljYXRpb25TdGFja0ZhY3RvcnkoKSxcbiAgICAgICAgfSk7XG4gICAgfVxufVxuLy8vICFoaWRlXG5cbmNvbnN0IGFwcCA9IG5ldyBjZGsuQXBwKCk7XG5uZXcgQ0lDRFBpcGVsaW5lU3RhY2soYXBwLCAnQ0lDRFBpcGVsaW5lU3RhY2snKTsiXX0=