"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const cdk = require("aws-cdk-lib");
const aws_iam_1 = require("aws-cdk-lib/aws-iam");
const dsf = require("../../index");
class ExampleSparkJobEmrServerlessStack extends cdk.Stack {
    constructor(scope, id) {
        super(scope, id);
        /// !show
        const runtime = new dsf.processing.SparkEmrServerlessRuntime(this, 'SparkRuntime', {
            name: 'mySparkRuntime',
        });
        /// !hide
        const s3ReadPolicy = new aws_iam_1.PolicyDocument({
            statements: [
                aws_iam_1.PolicyStatement.fromJson({
                    actions: ['s3:GetObject'],
                    resources: ['arn:aws:s3:::bucket_name', 'arn:aws:s3:::bucket_name/*'],
                }),
            ],
        });
        const executionRole = dsf.processing.SparkEmrServerlessRuntime.createExecutionRole(this, 'EmrServerlessExecutionRole', s3ReadPolicy);
        /// !show
        const applicationPackage = new dsf.processing.PySparkApplicationPackage(this, 'PySparkApplicationPackage', {
            applicationName: 'nightly-job-aggregation',
            entrypointPath: './../spark/src/entrypoint.py',
            dependenciesFolder: './../spark',
            venvArchivePath: '/venv-package/pyspark-env.tar.gz',
        });
        new dsf.processing.SparkEmrServerlessJob(this, 'SparkNightlyJob', {
            applicationId: runtime.application.attrApplicationId,
            name: 'nightly_job',
            executionRoleArn: executionRole.roleArn,
            executionTimeoutMinutes: 30,
            s3LogUri: 's3://emr-job-logs-EXAMPLE/logs',
            sparkSubmitEntryPoint: applicationPackage.entrypointS3Uri,
            sparkSubmitParameters: '--conf spark.executor.instances=2 --conf spark.executor.memory=2G --conf spark.driver.memory=2G --conf spark.executor.cores=2 {sparkEnvConf}',
        });
        /// !hide
    }
}
const app = new cdk.App();
new ExampleSparkJobEmrServerlessStack(app, 'ExampleSparkJobEmrServerlessStack');
//# sourceMappingURL=data:application/json;base64,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