"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const cdk = require("aws-cdk-lib");
const dsf = require("../../index");
class ExamplePySparkApplicationPackageStack extends cdk.Stack {
    constructor(scope, id) {
        super(scope, id);
        /// !show
        new dsf.processing.PySparkApplicationPackage(this, 'PySparkApplicationPackage', {
            applicationName: 'nightly-job-aggregation',
            entrypointPath: './../spark/src/entrypoint.py',
            dependenciesFolder: './../spark',
            venvArchivePath: '/venv-package/pyspark-env.tar.gz',
        });
        /// !hide
    }
}
const app = new cdk.App();
new ExamplePySparkApplicationPackageStack(app, 'ExamplePySparkApplicationPackageStack');
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoicHlzcGFyay1hcHBsaWNhdGlvbi1wYWNrYWdlLmxpdC5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbIi4uLy4uLy4uL3NyYy9wcm9jZXNzaW5nL2V4YW1wbGVzL3B5c3BhcmstYXBwbGljYXRpb24tcGFja2FnZS5saXQudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7QUFBQSxtQ0FBbUM7QUFFbkMsbUNBQW1DO0FBRW5DLE1BQU0scUNBQXNDLFNBQVEsR0FBRyxDQUFDLEtBQUs7SUFDekQsWUFBWSxLQUFnQixFQUFFLEVBQVU7UUFDcEMsS0FBSyxDQUFDLEtBQUssRUFBRSxFQUFFLENBQUMsQ0FBQztRQUV6QixTQUFTO1FBQ0QsSUFBSSxHQUFHLENBQUMsVUFBVSxDQUFDLHlCQUF5QixDQUFDLElBQUksRUFBRSwyQkFBMkIsRUFBRTtZQUM1RSxlQUFlLEVBQUUseUJBQXlCO1lBQzFDLGNBQWMsRUFBRSw4QkFBOEI7WUFDOUMsa0JBQWtCLEVBQUUsWUFBWTtZQUNoQyxlQUFlLEVBQUUsa0NBQWtDO1NBQ3RELENBQUMsQ0FBQztRQUNYLFNBQVM7SUFDTCxDQUFDO0NBQ0o7QUFFRCxNQUFNLEdBQUcsR0FBRyxJQUFJLEdBQUcsQ0FBQyxHQUFHLEVBQUUsQ0FBQztBQUMxQixJQUFJLHFDQUFxQyxDQUFDLEdBQUcsRUFBRSx1Q0FBdUMsQ0FBQyxDQUFDIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0ICogYXMgY2RrIGZyb20gJ2F3cy1jZGstbGliJztcbmltcG9ydCB7IENvbnN0cnVjdCB9IGZyb20gJ2NvbnN0cnVjdHMnO1xuaW1wb3J0ICogYXMgZHNmIGZyb20gJy4uLy4uL2luZGV4JztcblxuY2xhc3MgRXhhbXBsZVB5U3BhcmtBcHBsaWNhdGlvblBhY2thZ2VTdGFjayBleHRlbmRzIGNkay5TdGFjayB7XG4gICAgY29uc3RydWN0b3Ioc2NvcGU6IENvbnN0cnVjdCwgaWQ6IHN0cmluZykge1xuICAgICAgICBzdXBlcihzY29wZSwgaWQpO1xuXG4vLy8gIXNob3dcbiAgICAgICAgbmV3IGRzZi5wcm9jZXNzaW5nLlB5U3BhcmtBcHBsaWNhdGlvblBhY2thZ2UodGhpcywgJ1B5U3BhcmtBcHBsaWNhdGlvblBhY2thZ2UnLCB7XG4gICAgICAgICAgICBhcHBsaWNhdGlvbk5hbWU6ICduaWdodGx5LWpvYi1hZ2dyZWdhdGlvbicsXG4gICAgICAgICAgICBlbnRyeXBvaW50UGF0aDogJy4vLi4vc3Bhcmsvc3JjL2VudHJ5cG9pbnQucHknLFxuICAgICAgICAgICAgZGVwZW5kZW5jaWVzRm9sZGVyOiAnLi8uLi9zcGFyaycsXG4gICAgICAgICAgICB2ZW52QXJjaGl2ZVBhdGg6ICcvdmVudi1wYWNrYWdlL3B5c3BhcmstZW52LnRhci5neicsXG4gICAgICAgIH0pO1xuLy8vICFoaWRlXG4gICAgfVxufVxuXG5jb25zdCBhcHAgPSBuZXcgY2RrLkFwcCgpO1xubmV3IEV4YW1wbGVQeVNwYXJrQXBwbGljYXRpb25QYWNrYWdlU3RhY2soYXBwLCAnRXhhbXBsZVB5U3BhcmtBcHBsaWNhdGlvblBhY2thZ2VTdGFjaycpO1xuIl19