"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const cdk = require("aws-cdk-lib");
const aws_iam_1 = require("aws-cdk-lib/aws-iam");
const lib_1 = require("../lib");
const lambda_layer_kubectl_v27_1 = require("@aws-cdk/lambda-layer-kubectl-v27");
/// !show
class ExampleSparkEmrContainersStack extends cdk.Stack {
    constructor(scope, id) {
        super(scope, id);
        //Layer must be changed according to the Kubernetes version used
        const kubectlLayer = new lambda_layer_kubectl_v27_1.KubectlV27Layer(this, 'kubectlLayer');
        // creation of the construct(s) under test
        const emrEksCluster = lib_1.SparkEmrContainersRuntime.getOrCreate(this, {
            eksAdminRole: aws_iam_1.Role.fromRoleArn(this, 'EksAdminRole', 'arn:aws:iam::12345678912:role/role-name-with-path'),
            publicAccessCIDRs: ['10.0.0.0/32'],
            createEmrOnEksServiceLinkedRole: true,
            kubectlLambdaLayer: kubectlLayer,
        });
        const s3Read = new aws_iam_1.PolicyDocument({
            statements: [new aws_iam_1.PolicyStatement({
                    actions: [
                        's3:GetObject',
                    ],
                    resources: ['arn:aws:s3:::aws-data-analytics-workshop'],
                })],
        });
        const s3ReadPolicy = new aws_iam_1.ManagedPolicy(this, 's3ReadPolicy', {
            document: s3Read,
        });
        const virtualCluster = emrEksCluster.addEmrVirtualCluster(this, {
            name: 'e2e',
            createNamespace: true,
            eksNamespace: 'e2ens',
        });
        const execRole = emrEksCluster.createExecutionRole(this, 'ExecRole', s3ReadPolicy, 'e2ens', 's3ReadExecRole');
        new cdk.CfnOutput(this, 'virtualClusterArn', {
            value: virtualCluster.attrArn,
        });
        new cdk.CfnOutput(this, 'execRoleArn', {
            value: execRole.roleArn,
        });
    }
}
/// !hide
const app = new cdk.App();
new ExampleSparkEmrContainersStack(app, 'ExampleSparkEmrServerlessStack');
//# sourceMappingURL=data:application/json;base64,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