"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const cdk = require("aws-cdk-lib");
const aws_iam_1 = require("aws-cdk-lib/aws-iam");
const dsf = require("../../index");
/// !show
class ExampleSparkEmrServerlessStack extends cdk.Stack {
    constructor(scope, id) {
        super(scope, id);
        const runtimeServerless = new dsf.processing.SparkEmrServerlessRuntime(this, 'SparkRuntimeServerless', {
            name: 'spark-serverless-demo',
        });
        const s3ReadPolicyDocument = new aws_iam_1.PolicyDocument({
            statements: [
                aws_iam_1.PolicyStatement.fromJson({
                    actions: ['s3:GetObject'],
                    resources: ['arn:aws:s3:::bucket_name'],
                }),
            ],
        });
        // The IAM role that will trigger the Job start and will monitor it
        const jobTrigger = new aws_iam_1.Role(this, 'EMRServerlessExecutionRole', {
            assumedBy: new aws_iam_1.ServicePrincipal('lambda.amazonaws.com'),
        });
        const executionRole = dsf.processing.SparkEmrServerlessRuntime.createExecutionRole(this, 'EmrServerlessExecutionRole', s3ReadPolicyDocument);
        runtimeServerless.grantStartExecution(jobTrigger, executionRole.roleArn);
        new cdk.CfnOutput(this, 'SparkRuntimeServerlessStackApplicationArn', {
            value: runtimeServerless.application.attrArn,
        });
    }
}
/// !hide
const app = new cdk.App();
new ExampleSparkEmrServerlessStack(app, 'ExampleSparkEmrServerlessStack');
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoic3BhcmstZW1yLXJ1bnRpbWUtc2VydmVybGVzcy1kZWZhdWx0LmxpdC5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbIi4uLy4uLy4uL3NyYy9wcm9jZXNzaW5nL2V4YW1wbGVzL3NwYXJrLWVtci1ydW50aW1lLXNlcnZlcmxlc3MtZGVmYXVsdC5saXQudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7QUFBQSxtQ0FBbUM7QUFDbkMsaURBQThGO0FBRTlGLG1DQUFtQztBQUVuQyxTQUFTO0FBQ1QsTUFBTSw4QkFBK0IsU0FBUSxHQUFHLENBQUMsS0FBSztJQUNsRCxZQUFZLEtBQWdCLEVBQUUsRUFBVTtRQUNwQyxLQUFLLENBQUMsS0FBSyxFQUFFLEVBQUUsQ0FBQyxDQUFDO1FBRWpCLE1BQU0saUJBQWlCLEdBQUcsSUFBSSxHQUFHLENBQUMsVUFBVSxDQUFDLHlCQUF5QixDQUFDLElBQUksRUFBRSx3QkFBd0IsRUFBRTtZQUNuRyxJQUFJLEVBQUUsdUJBQXVCO1NBQ2hDLENBQUMsQ0FBQztRQUVILE1BQU0sb0JBQW9CLEdBQUcsSUFBSSx3QkFBYyxDQUFDO1lBQzVDLFVBQVUsRUFBRTtnQkFDUix5QkFBZSxDQUFDLFFBQVEsQ0FBQztvQkFDckIsT0FBTyxFQUFFLENBQUMsY0FBYyxDQUFDO29CQUN6QixTQUFTLEVBQUUsQ0FBQywwQkFBMEIsQ0FBQztpQkFDMUMsQ0FBQzthQUNMO1NBQ0osQ0FBQyxDQUFDO1FBRUgsbUVBQW1FO1FBQ25FLE1BQU0sVUFBVSxHQUFHLElBQUksY0FBSSxDQUFDLElBQUksRUFBRSw0QkFBNEIsRUFBRTtZQUM1RCxTQUFTLEVBQUUsSUFBSSwwQkFBZ0IsQ0FBQyxzQkFBc0IsQ0FBQztTQUMxRCxDQUFDLENBQUM7UUFFSCxNQUFNLGFBQWEsR0FBRyxHQUFHLENBQUMsVUFBVSxDQUFDLHlCQUF5QixDQUFDLG1CQUFtQixDQUFDLElBQUksRUFBRSw0QkFBNEIsRUFBRSxvQkFBb0IsQ0FBQyxDQUFDO1FBRTdJLGlCQUFpQixDQUFDLG1CQUFtQixDQUFDLFVBQVUsRUFBRSxhQUFhLENBQUMsT0FBTyxDQUFDLENBQUM7UUFFekUsSUFBSSxHQUFHLENBQUMsU0FBUyxDQUFDLElBQUksRUFBRSwyQ0FBMkMsRUFBRTtZQUNqRSxLQUFLLEVBQUUsaUJBQWlCLENBQUMsV0FBVyxDQUFDLE9BQU87U0FDL0MsQ0FBQyxDQUFDO0lBQ1AsQ0FBQztDQUNKO0FBQ0QsU0FBUztBQUVULE1BQU0sR0FBRyxHQUFHLElBQUksR0FBRyxDQUFDLEdBQUcsRUFBRSxDQUFDO0FBQzFCLElBQUksOEJBQThCLENBQUMsR0FBRyxFQUFFLGdDQUFnQyxDQUFDLENBQUMiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgKiBhcyBjZGsgZnJvbSAnYXdzLWNkay1saWInO1xuaW1wb3J0IHsgUG9saWN5RG9jdW1lbnQsIFBvbGljeVN0YXRlbWVudCwgUm9sZSwgU2VydmljZVByaW5jaXBhbCB9IGZyb20gJ2F3cy1jZGstbGliL2F3cy1pYW0nO1xuaW1wb3J0IHsgQ29uc3RydWN0IH0gZnJvbSAnY29uc3RydWN0cyc7XG5pbXBvcnQgKiBhcyBkc2YgZnJvbSAnLi4vLi4vaW5kZXgnO1xuXG4vLy8gIXNob3dcbmNsYXNzIEV4YW1wbGVTcGFya0VtclNlcnZlcmxlc3NTdGFjayBleHRlbmRzIGNkay5TdGFjayB7XG4gICAgY29uc3RydWN0b3Ioc2NvcGU6IENvbnN0cnVjdCwgaWQ6IHN0cmluZykge1xuICAgICAgICBzdXBlcihzY29wZSwgaWQpO1xuXG4gICAgICAgIGNvbnN0IHJ1bnRpbWVTZXJ2ZXJsZXNzID0gbmV3IGRzZi5wcm9jZXNzaW5nLlNwYXJrRW1yU2VydmVybGVzc1J1bnRpbWUodGhpcywgJ1NwYXJrUnVudGltZVNlcnZlcmxlc3MnLCB7XG4gICAgICAgICAgICBuYW1lOiAnc3Bhcmstc2VydmVybGVzcy1kZW1vJyxcbiAgICAgICAgfSk7XG5cbiAgICAgICAgY29uc3QgczNSZWFkUG9saWN5RG9jdW1lbnQgPSBuZXcgUG9saWN5RG9jdW1lbnQoe1xuICAgICAgICAgICAgc3RhdGVtZW50czogW1xuICAgICAgICAgICAgICAgIFBvbGljeVN0YXRlbWVudC5mcm9tSnNvbih7XG4gICAgICAgICAgICAgICAgICAgIGFjdGlvbnM6IFsnczM6R2V0T2JqZWN0J10sXG4gICAgICAgICAgICAgICAgICAgIHJlc291cmNlczogWydhcm46YXdzOnMzOjo6YnVja2V0X25hbWUnXSxcbiAgICAgICAgICAgICAgICB9KSxcbiAgICAgICAgICAgIF0sXG4gICAgICAgIH0pO1xuXG4gICAgICAgIC8vIFRoZSBJQU0gcm9sZSB0aGF0IHdpbGwgdHJpZ2dlciB0aGUgSm9iIHN0YXJ0IGFuZCB3aWxsIG1vbml0b3IgaXRcbiAgICAgICAgY29uc3Qgam9iVHJpZ2dlciA9IG5ldyBSb2xlKHRoaXMsICdFTVJTZXJ2ZXJsZXNzRXhlY3V0aW9uUm9sZScsIHtcbiAgICAgICAgICAgIGFzc3VtZWRCeTogbmV3IFNlcnZpY2VQcmluY2lwYWwoJ2xhbWJkYS5hbWF6b25hd3MuY29tJyksXG4gICAgICAgIH0pO1xuXG4gICAgICAgIGNvbnN0IGV4ZWN1dGlvblJvbGUgPSBkc2YucHJvY2Vzc2luZy5TcGFya0VtclNlcnZlcmxlc3NSdW50aW1lLmNyZWF0ZUV4ZWN1dGlvblJvbGUodGhpcywgJ0VtclNlcnZlcmxlc3NFeGVjdXRpb25Sb2xlJywgczNSZWFkUG9saWN5RG9jdW1lbnQpO1xuXG4gICAgICAgIHJ1bnRpbWVTZXJ2ZXJsZXNzLmdyYW50U3RhcnRFeGVjdXRpb24oam9iVHJpZ2dlciwgZXhlY3V0aW9uUm9sZS5yb2xlQXJuKTtcblxuICAgICAgICBuZXcgY2RrLkNmbk91dHB1dCh0aGlzLCAnU3BhcmtSdW50aW1lU2VydmVybGVzc1N0YWNrQXBwbGljYXRpb25Bcm4nLCB7XG4gICAgICAgICAgICB2YWx1ZTogcnVudGltZVNlcnZlcmxlc3MuYXBwbGljYXRpb24uYXR0ckFybixcbiAgICAgICAgfSk7XG4gICAgfVxufVxuLy8vICFoaWRlXG5cbmNvbnN0IGFwcCA9IG5ldyBjZGsuQXBwKCk7XG5uZXcgRXhhbXBsZVNwYXJrRW1yU2VydmVybGVzc1N0YWNrKGFwcCwgJ0V4YW1wbGVTcGFya0VtclNlcnZlcmxlc3NTdGFjaycpOyJdfQ==