"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const cdk = require("aws-cdk-lib");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const dsf = require("../../index");
/// !show
class ExampleSparkJobEmrEksStack extends cdk.Stack {
    constructor(scope, id) {
        super(scope, id);
        const dailyJob = new dsf.processing.SparkEmrEksJob(this, 'SparkNightlyJob', {
            name: 'daily_job',
            virtualClusterId: 'exampleId123',
            executionRoleArn: 'arn:aws:iam::123456789012:role/role',
            executionTimeoutMinutes: 30,
            s3LogUri: 's3://emr-job-logs-EXAMPLE/logs',
            sparkSubmitEntryPoint: 'local:///usr/lib/spark/examples/src/main/python/pi.py',
            sparkSubmitParameters: '--conf spark.executor.instances=2 --conf spark.executor.memory=2G --conf spark.driver.memory=2G --conf spark.executor.cores=4',
        });
        new aws_cdk_lib_1.CfnOutput(this, 'daily-job-state-machine', {
            value: dailyJob.stateMachine.stateMachineArn,
        });
    }
}
/// !hide
const app = new cdk.App();
new ExampleSparkJobEmrEksStack(app, 'ExampleSparkJobEmrEksStack');
//# sourceMappingURL=data:application/json;base64,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