"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const cdk = require("aws-cdk-lib");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const aws_iam_1 = require("aws-cdk-lib/aws-iam");
const dsf = require("../../index");
/// !show
class ExampleSparkJobEmrServerlessStack extends cdk.Stack {
    constructor(scope, id) {
        super(scope, id);
        const runtime = new dsf.processing.SparkEmrServerlessRuntime(this, 'SparkRuntime', {
            name: 'mySparkRuntime',
        });
        const s3ReadPolicy = new aws_iam_1.PolicyDocument({
            statements: [
                aws_iam_1.PolicyStatement.fromJson({
                    actions: ['s3:GetObject'],
                    resources: ['arn:aws:s3:::bucket_name', 'arn:aws:s3:::bucket_name/*'],
                }),
            ],
        });
        const executionRole = dsf.processing.SparkEmrServerlessRuntime.createExecutionRole(this, 'EmrServerlessExecutionRole', s3ReadPolicy);
        const nightJob = new dsf.processing.SparkEmrServerlessJob(this, 'SparkNightlyJob', {
            applicationId: runtime.application.attrApplicationId,
            name: 'nightly_job',
            executionRoleArn: executionRole.roleArn,
            executionTimeoutMinutes: 30,
            s3LogUri: 's3://emr-job-logs-EXAMPLE/logs',
            sparkSubmitEntryPoint: 'local:///usr/lib/spark/examples/src/main/python/pi.py',
            sparkSubmitParameters: '--conf spark.executor.instances=2 --conf spark.executor.memory=2G --conf spark.driver.memory=2G --conf spark.executor.cores=4',
        });
        new aws_cdk_lib_1.CfnOutput(this, 'job-state-machine', {
            value: nightJob.stateMachine.stateMachineArn,
        });
    }
}
/// !hide
const app = new cdk.App();
new ExampleSparkJobEmrServerlessStack(app, 'ExampleSparkJobEmrServerlessStack');
//# sourceMappingURL=data:application/json;base64,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