"use strict";
// Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
// SPDX-License-Identifier: MIT-0
Object.defineProperty(exports, "__esModule", { value: true });
exports.DEFAULT_SPARK_IMAGE = exports.EMR_DEFAULT_VERSION = exports.SparkImage = exports.EmrRuntimeVersion = void 0;
/**
 * Enum defining the EMR version as defined [here](https://docs.aws.amazon.com/emr/latest/ReleaseGuide/emr-release-6x.html)
 */
var EmrRuntimeVersion;
(function (EmrRuntimeVersion) {
    EmrRuntimeVersion["V6_12"] = "emr-6.12.0";
    EmrRuntimeVersion["V6_11_1"] = "emr-6.11.1";
    EmrRuntimeVersion["V6_11"] = "emr-6.11.0";
    EmrRuntimeVersion["V6_10_1"] = "emr-6.10.1";
    EmrRuntimeVersion["V6_10"] = "emr-6.10.0";
    EmrRuntimeVersion["V6_9"] = "emr-6.9.0";
    EmrRuntimeVersion["V6_8"] = "emr-6.8.0";
    EmrRuntimeVersion["V6_7"] = "emr-6.7.0";
    EmrRuntimeVersion["V6_6"] = "emr-6.6.0";
    EmrRuntimeVersion["V6_5"] = "emr-6.5.0";
    EmrRuntimeVersion["V6_4"] = "emr-6.4.0";
    EmrRuntimeVersion["V6_3"] = "emr-6.3.0";
    EmrRuntimeVersion["V6_2"] = "emr-6.2.0";
    EmrRuntimeVersion["V5_33"] = "emr-5.33.0";
    EmrRuntimeVersion["V5_32"] = "emr-5.32.0";
})(EmrRuntimeVersion = exports.EmrRuntimeVersion || (exports.EmrRuntimeVersion = {}));
const EMR_EKS_IMAGE_URL = 'public.ecr.aws/emr-on-eks/spark/';
/**
 * The list of supported Spark images to use in the SparkCICDPipeline.
 */
var SparkImage;
(function (SparkImage) {
    SparkImage["EMR_6_12"] = "public.ecr.aws/emr-on-eks/spark/emr-6.12.0:latest";
    SparkImage["EMR_6_11"] = "public.ecr.aws/emr-on-eks/spark/emr-6.11.0:latest";
    SparkImage["EMR_6_10"] = "public.ecr.aws/emr-on-eks/spark/emr-6.10.0:latest";
    SparkImage["EMR_6_9"] = "public.ecr.aws/emr-on-eks/spark/emr-6.9.0:latest";
})(SparkImage = exports.SparkImage || (exports.SparkImage = {}));
exports.EMR_DEFAULT_VERSION = EmrRuntimeVersion.V6_12;
/**
 * The default Spark image to run the unit tests
 */
exports.DEFAULT_SPARK_IMAGE = SparkImage.EMR_6_12;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiZW1yLXJlbGVhc2VzLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiLi4vLi4vLi4vc3JjL3Byb2Nlc3NpbmcvbGliL2Vtci1yZWxlYXNlcy50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiO0FBQUEscUVBQXFFO0FBQ3JFLGlDQUFpQzs7O0FBRWpDOztHQUVHO0FBRUgsSUFBWSxpQkFnQlg7QUFoQkQsV0FBWSxpQkFBaUI7SUFDM0IseUNBQW9CLENBQUE7SUFDcEIsMkNBQXNCLENBQUE7SUFDdEIseUNBQW9CLENBQUE7SUFDcEIsMkNBQXNCLENBQUE7SUFDdEIseUNBQW9CLENBQUE7SUFDcEIsdUNBQWtCLENBQUE7SUFDbEIsdUNBQWtCLENBQUE7SUFDbEIsdUNBQWtCLENBQUE7SUFDbEIsdUNBQWtCLENBQUE7SUFDbEIsdUNBQWtCLENBQUE7SUFDbEIsdUNBQWtCLENBQUE7SUFDbEIsdUNBQWtCLENBQUE7SUFDbEIsdUNBQWtCLENBQUE7SUFDbEIseUNBQW9CLENBQUE7SUFDcEIseUNBQW9CLENBQUE7QUFDdEIsQ0FBQyxFQWhCVyxpQkFBaUIsR0FBakIseUJBQWlCLEtBQWpCLHlCQUFpQixRQWdCNUI7QUFFRCxNQUFNLGlCQUFpQixHQUFHLGtDQUFrQyxDQUFDO0FBRTdEOztHQUVHO0FBQ0gsSUFBWSxVQUtYO0FBTEQsV0FBWSxVQUFVO0lBQ3BCLDRFQUFrRSxDQUFBO0lBQ2xFLDRFQUFrRSxDQUFBO0lBQ2xFLDRFQUFrRSxDQUFBO0lBQ2xFLDBFQUFnRSxDQUFBO0FBQ2xFLENBQUMsRUFMVyxVQUFVLEdBQVYsa0JBQVUsS0FBVixrQkFBVSxRQUtyQjtBQUVZLFFBQUEsbUJBQW1CLEdBQXNCLGlCQUFpQixDQUFDLEtBQUssQ0FBQztBQUU5RTs7R0FFRztBQUNVLFFBQUEsbUJBQW1CLEdBQWUsVUFBVSxDQUFDLFFBQVEsQ0FBQyIsInNvdXJjZXNDb250ZW50IjpbIi8vIENvcHlyaWdodCBBbWF6b24uY29tLCBJbmMuIG9yIGl0cyBhZmZpbGlhdGVzLiBBbGwgUmlnaHRzIFJlc2VydmVkLlxuLy8gU1BEWC1MaWNlbnNlLUlkZW50aWZpZXI6IE1JVC0wXG5cbi8qKlxuICogRW51bSBkZWZpbmluZyB0aGUgRU1SIHZlcnNpb24gYXMgZGVmaW5lZCBbaGVyZV0oaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2Vtci9sYXRlc3QvUmVsZWFzZUd1aWRlL2Vtci1yZWxlYXNlLTZ4Lmh0bWwpXG4gKi9cblxuZXhwb3J0IGVudW0gRW1yUnVudGltZVZlcnNpb24ge1xuICBWNl8xMiA9ICdlbXItNi4xMi4wJyxcbiAgVjZfMTFfMSA9ICdlbXItNi4xMS4xJyxcbiAgVjZfMTEgPSAnZW1yLTYuMTEuMCcsXG4gIFY2XzEwXzEgPSAnZW1yLTYuMTAuMScsXG4gIFY2XzEwID0gJ2Vtci02LjEwLjAnLFxuICBWNl85ID0gJ2Vtci02LjkuMCcsXG4gIFY2XzggPSAnZW1yLTYuOC4wJyxcbiAgVjZfNyA9ICdlbXItNi43LjAnLFxuICBWNl82ID0gJ2Vtci02LjYuMCcsXG4gIFY2XzUgPSAnZW1yLTYuNS4wJyxcbiAgVjZfNCA9ICdlbXItNi40LjAnLFxuICBWNl8zID0gJ2Vtci02LjMuMCcsXG4gIFY2XzIgPSAnZW1yLTYuMi4wJyxcbiAgVjVfMzMgPSAnZW1yLTUuMzMuMCcsXG4gIFY1XzMyID0gJ2Vtci01LjMyLjAnLFxufVxuXG5jb25zdCBFTVJfRUtTX0lNQUdFX1VSTCA9ICdwdWJsaWMuZWNyLmF3cy9lbXItb24tZWtzL3NwYXJrLyc7XG5cbi8qKlxuICogVGhlIGxpc3Qgb2Ygc3VwcG9ydGVkIFNwYXJrIGltYWdlcyB0byB1c2UgaW4gdGhlIFNwYXJrQ0lDRFBpcGVsaW5lLlxuICovXG5leHBvcnQgZW51bSBTcGFya0ltYWdlIHtcbiAgRU1SXzZfMTIgPSBFTVJfRUtTX0lNQUdFX1VSTCArIEVtclJ1bnRpbWVWZXJzaW9uLlY2XzEyICsgJzpsYXRlc3QnLFxuICBFTVJfNl8xMSA9IEVNUl9FS1NfSU1BR0VfVVJMICsgRW1yUnVudGltZVZlcnNpb24uVjZfMTEgKyAnOmxhdGVzdCcsXG4gIEVNUl82XzEwID0gRU1SX0VLU19JTUFHRV9VUkwgKyBFbXJSdW50aW1lVmVyc2lvbi5WNl8xMCArICc6bGF0ZXN0JyxcbiAgRU1SXzZfOSA9IEVNUl9FS1NfSU1BR0VfVVJMICsgRW1yUnVudGltZVZlcnNpb24uVjZfOSArICc6bGF0ZXN0Jyxcbn1cblxuZXhwb3J0IGNvbnN0IEVNUl9ERUZBVUxUX1ZFUlNJT046IEVtclJ1bnRpbWVWZXJzaW9uID0gRW1yUnVudGltZVZlcnNpb24uVjZfMTI7XG5cbi8qKlxuICogVGhlIGRlZmF1bHQgU3BhcmsgaW1hZ2UgdG8gcnVuIHRoZSB1bml0IHRlc3RzXG4gKi9cbmV4cG9ydCBjb25zdCBERUZBVUxUX1NQQVJLX0lNQUdFOiBTcGFya0ltYWdlID0gU3BhcmtJbWFnZS5FTVJfNl8xMjsiXX0=