import { SparkJobProps } from './spark-job-props';
/**
 * Simplified configuration for the EMR Serverless Job.
 * @param name Spark job name @default Autogenerated
 * @param virtualClusterId EMR Serverless application ID
 * @param releaseLabel the EMR runtime to use @default EMR_DEFAULT_VERSION
 * @param executionRoleArn EMR on EKS execution role ARN
 * @param sparkSubmitEntryPoint The entry point for the Spark submit job run. @see @link(https://docs.aws.amazon.com/emr-on-eks/latest/APIReference/API_StartJobRun.html)
 * @param sparkSubmitEntryPointArguments The arguments for the Spark submit job run. @see @link(https://docs.aws.amazon.com/emr-on-eks/latest/APIReference/API_StartJobRun.html)
 * @param sparkSubmitParameters The parameters for the Spark submit job run. @see @link(https://docs.aws.amazon.com/emr-on-eks/latest/APIReference/API_StartJobRun.html)
 * @param applicationConfiguration The override configurations for the application. @see @link(https://docs.aws.amazon.com/emr-on-eks/latest/APIReference/API_ConfigurationOverrides.html#emroneks-Type-ConfigurationOverrides-applicationConfiguration)
 * @param executionTimeoutMinutes Job execution timeout in minutes. @default 30
 * @param maxRetries The maximum number of attempts on the job's driver.
 * @param s3LogUri The Amazon S3 destination URI for log publishing. @default Create new bucket. @see @link(https://docs.aws.amazon.com/emr-on-eks/latest/APIReference/API_S3MonitoringConfiguration.html#emroneks-Type-S3MonitoringConfiguration-logUri)
 * @param cloudWatchLogGroupName CloudWatch log group name for job monitoring.  @see @link(https://docs.aws.amazon.com/emr-on-eks/latest/APIReference/API_CloudWatchMonitoringConfiguration.html#emroneks-Type-CloudWatchMonitoringConfiguration-logGroupName)
 * @param cloudWatchLogGroupStreamPrefix CloudWatch log group stream prefix. @default The name of the spark job. @see @link(https://docs.aws.amazon.com/emr-on-eks/latest/APIReference/API_CloudWatchMonitoringConfiguration.html#emroneks-Type-CloudWatchMonitoringConfiguration-logGroupName)
 * @param tags Tags to be added to the EMR Serverless job. @see @link(https://docs.aws.amazon.com/emr-on-eks/latest/APIReference/API_StartJobRun.html#emroneks-StartJobRun-request-tags)
 */
export interface SparkEmrEksJobProps extends SparkJobProps {
    readonly name: string;
    readonly virtualClusterId: string;
    readonly releaseLabel?: string;
    readonly executionRoleArn: string;
    readonly sparkSubmitEntryPoint: string;
    readonly sparkSubmitEntryPointArguments?: string[];
    readonly sparkSubmitParameters?: string;
    readonly applicationConfiguration?: {
        [key: string]: any;
    };
    readonly executionTimeoutMinutes?: number;
    readonly maxRetries?: number;
    readonly s3LogUri?: string;
    readonly cloudWatchLogGroupName?: string;
    readonly cloudWatchLogGroupStreamPrefix?: string;
    readonly tags?: {
        [key: string]: any;
    };
}
/**
 * Configuration for the EMR on EKS job.
 * Use this interface when EmrOnEksSparkJobProps doesn't give you access to the configuration parameters you need.
 * @param jobConfig The job configuration. @link[https://docs.aws.amazon.com/emr-on-eks/latest/APIReference/API_StartJobRun.html]
 */
export interface SparkEmrEksJobApiProps extends SparkJobProps {
    /**
     * Job execution timeout in minutes. @default 30
     */
    readonly executionTimeoutMinutes?: number;
    /**
     * EMR on EKS Job Configuration.
     * @link[https://docs.aws.amazon.com/emr-on-eks/latest/APIReference/API_StartJobRun.html]
     */
    readonly jobConfig: {
        [key: string]: any;
    };
}
