import { RemovalPolicy } from 'aws-cdk-lib';
import { Schedule } from 'aws-cdk-lib/aws-events';
/**
 * Properties for the SparkJob construct.
 */
export interface SparkJobProps {
    /**
     * The removal policy when deleting the CDK resource.
     * If DESTROY is selected, context value `@data-solutions-framework-on-aws/removeDataOnDestroy` needs to be set to true.
     * Otherwise the removalPolicy is reverted to RETAIN.
     * @default - The resources are not deleted (`RemovalPolicy.RETAIN`).
     */
    readonly removalPolicy?: RemovalPolicy;
    /**
     * Schedule to run the Step Functions state machine.
     * @see Schedule @link[https://docs.aws.amazon.com/cdk/api/v2/docs/aws-cdk-lib.aws_events.Schedule.html]
     */
    readonly schedule?: Schedule;
}
