import { Cluster, KubernetesManifest, KubernetesVersion, ICluster } from 'aws-cdk-lib/aws-eks';
import { IRole } from 'aws-cdk-lib/aws-iam';
import { Construct } from 'constructs';
/**
 * @internal
 * Configure the EBS CSI driver on an Amazon EKS cluster
 * @param {Construct} scope the CDK scope to create resources in
 * @param {ICluster} cluster the EKS cluster to install the CSI driver in
 * @param {KubernetesVersion} eksClusterK8sVersion the Kubernetes version of the EKS cluster
 * @return {IRole} the IAM role used by the CSI driver
 */
export declare function ebsCsiDriverSetup(scope: Construct, cluster: ICluster, eksClusterK8sVersion: KubernetesVersion): IRole;
/**
 * @internal
 * Configure the IAM role used by the aws-node pod following AWS best practice not to use the EC2 instance role
 * @param {Construct} scope the CDK scope to create resources in
 * @param {ICluster} cluster the EKS cluster to configure the aws-node pod in
 * @return {IRole} the IAM role used by the aws-node pod
 */
export declare function awsNodeRoleSetup(scope: Construct, cluster: ICluster): IRole;
/**
 * @internal
 * Method to setup a managed nodegroup to bootstrap all cluster vital componenets like
 * core dns, karpenter, ebs csi driver.
 * @param {Construct} scope the CDK scope to create the nodegroup in
 * @param {Cluster} cluster the EKS cluster to create the nodegroup in
 * @param {IRole} nodeRole the IAM role to use for the nodegroup
 */
export declare function toolingManagedNodegroupSetup(scope: Construct, cluster: Cluster, nodeRole: IRole): void;
/**
 * @internal
 * Create a namespace with a predefined baseline
 *  * Create namespace
 *  * Define a Network Policy
 * @param {ICluster} cluster the EKS cluster to create the namespace in
 * @param {string} namespace the namespace to create
 * @return {KubernetesManifest} the Kubernetes manifest for the namespace
 */
export declare function createNamespace(cluster: ICluster, namespace: string): KubernetesManifest;
