"use strict";
// Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
// SPDX-License-Identifier: MIT-0
Object.defineProperty(exports, "__esModule", { value: true });
exports.CERTMANAGER_HELM_CHART_VERSION = exports.EBS_CSI_DRIVER_ADDON_VERSION = void 0;
const aws_eks_1 = require("aws-cdk-lib/aws-eks");
/**
 * @internal
 * The version mapping can be taken from here
 * aws eks describe-addon-versions --addon-name aws-ebs-csi-driver
 */
exports.EBS_CSI_DRIVER_ADDON_VERSION = new Map([
    [aws_eks_1.KubernetesVersion.V1_24, 'v1.24.1-eksbuild.1'],
    [aws_eks_1.KubernetesVersion.V1_25, 'v1.24.1-eksbuild.1'],
    [aws_eks_1.KubernetesVersion.V1_26, 'v1.24.1-eksbuild.1'],
    [aws_eks_1.KubernetesVersion.V1_27, 'v1.24.1-eksbuild.1'],
]);
/**
 * @internal
 * The version mapping can be taken from here
 * https://cert-manager.io/docs/releases/
 */
exports.CERTMANAGER_HELM_CHART_VERSION = new Map([
    [aws_eks_1.KubernetesVersion.V1_24, '1.13.2'],
    [aws_eks_1.KubernetesVersion.V1_25, '1.13.2'],
    [aws_eks_1.KubernetesVersion.V1_26, '1.13.2'],
    [aws_eks_1.KubernetesVersion.V1_27, '1.13.2'],
]);
//# sourceMappingURL=data:application/json;base64,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