import { RemovalPolicy } from 'aws-cdk-lib';
import { ISubnet, ISecurityGroup } from 'aws-cdk-lib/aws-ec2';
import { HelmChart, ICluster } from 'aws-cdk-lib/aws-eks';
import { IRule } from 'aws-cdk-lib/aws-events';
import { CfnInstanceProfile, IRole } from 'aws-cdk-lib/aws-iam';
import { IQueue } from 'aws-cdk-lib/aws-sqs';
import { Construct } from 'constructs';
import { SparkEmrContainersRuntime } from './spark-emr-containers-runtime';
import { KarpenterVersion } from '../../karpenter-releases';
/**
 * @internal
 * Method to add the default Karpenter provisioners for Spark workloads
 * @param {Cluster} cluster the EMR on EKS cluster to configure the Karpenter provisioners in
 * @param {KarpenterVersion} karpenterVersion the Karpenter version to use for the provisioners
 * @param {IRole} nodeRole the IAM role to use for the provisioners
 */
export declare function setDefaultKarpenterProvisioners(cluster: SparkEmrContainersRuntime, karpenterVersion: KarpenterVersion, nodeRole: IRole): void;
/**
   * @internal
   * Method to generate the Karpenter manifests from templates and targeted to the specific EKS cluster
   * @param {ICluster} cluster the name of the EKS cluster to target the manifests to
   * @param {string} path the path to the manifest template
   * @param {ISubnet} subnet the subnet to target the manifests to
   * @param {IRole} nodeRole the IAM role to use for the manifests
   * @return {any} the Kubernetes manifest for Karpenter provisioned
   */
export declare function karpenterManifestSetup(cluster: ICluster, path: string, subnet: ISubnet, nodeRole: IRole): any;
/**
   * @internal
   * Install all the required configurations of Karpenter SQS and Event rules to handle spot and unhealthy instance termination
   * Create a security group to be used by nodes created with karpenter
   * Tags the subnets and VPC to be used by karpenter
   * create a tooling provisioner that will deploy in each of the AZs, one per AZ
   * @param {Cluster} cluster the EKS cluster to configure the Karpenter provisioners in
   * @param {string} clusterName the name of the EKS cluster to target the manifests to
   * @param {CfnInstanceProfile} instanceProfile the IAM instance profile to use for the Karpenter nodes
   * @param {IRole} nodeRole the IAM role to use for the Karpenter nodes
   * @param {KarpenterVersion} karpenterVersion the Karpenter version to use for the provisioners
   * @return {[HelmChart, IRole, IQueue, Array<IRule>]} the Helm chart to install, the IAM Role for service account, the SQS queue and the EventBridge rules for Karpenter
   */
export declare function karpenterSetup(cluster: ICluster, clusterName: string, scope: Construct, instanceProfile: CfnInstanceProfile, nodeRole: IRole, karpenterRemovalPolicy: RemovalPolicy, karpenterVersion?: KarpenterVersion): [HelmChart, IRole, IQueue, ISecurityGroup, Array<IRule>];
