"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const cdk = require("aws-cdk-lib");
const dsf = require("../../index");
class ExampleAccessLogsBucketNamingStack extends cdk.Stack {
    constructor(scope, id) {
        super(scope, id);
        /// !show
        new dsf.storage.AccessLogsBucket(this, 'MyAccessLogs', {
            bucketName: dsf.utils.BucketUtils.generateUniqueBucketName(this, 'MyAccessLogs', 'my-custom-name')
        });
        /// !hide
    }
}
const app = new cdk.App();
new ExampleAccessLogsBucketNamingStack(app, 'ExampleAccessLogsBucketNaming');
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiYWNjZXNzLWxvZ3MtYnVja2V0LW5hbWluZy5saXQuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyIuLi8uLi8uLi9zcmMvc3RvcmFnZS9leGFtcGxlcy9hY2Nlc3MtbG9ncy1idWNrZXQtbmFtaW5nLmxpdC50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOztBQUFBLG1DQUFtQztBQUVuQyxtQ0FBbUM7QUFFbkMsTUFBTSxrQ0FBbUMsU0FBUSxHQUFHLENBQUMsS0FBSztJQUN4RCxZQUFZLEtBQWdCLEVBQUUsRUFBVTtRQUN0QyxLQUFLLENBQUMsS0FBSyxFQUFFLEVBQUUsQ0FBQyxDQUFDO1FBQ3JCLFNBQVM7UUFDTCxJQUFJLEdBQUcsQ0FBQyxPQUFPLENBQUMsZ0JBQWdCLENBQUMsSUFBSSxFQUFFLGNBQWMsRUFBRTtZQUNuRCxVQUFVLEVBQUUsR0FBRyxDQUFDLEtBQUssQ0FBQyxXQUFXLENBQUMsd0JBQXdCLENBQUMsSUFBSSxFQUFFLGNBQWMsRUFBRSxnQkFBZ0IsQ0FBQztTQUNyRyxDQUFDLENBQUM7UUFDUCxTQUFTO0lBQ1AsQ0FBQztDQUNGO0FBRUQsTUFBTSxHQUFHLEdBQUcsSUFBSSxHQUFHLENBQUMsR0FBRyxFQUFFLENBQUM7QUFDMUIsSUFBSSxrQ0FBa0MsQ0FBQyxHQUFHLEVBQUUsK0JBQStCLENBQUMsQ0FBQyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCAqIGFzIGNkayBmcm9tICdhd3MtY2RrLWxpYic7XG5pbXBvcnQgeyBDb25zdHJ1Y3QgfSBmcm9tICdjb25zdHJ1Y3RzJztcbmltcG9ydCAqIGFzIGRzZiBmcm9tICcuLi8uLi9pbmRleCc7XG5cbmNsYXNzIEV4YW1wbGVBY2Nlc3NMb2dzQnVja2V0TmFtaW5nU3RhY2sgZXh0ZW5kcyBjZGsuU3RhY2sge1xuICBjb25zdHJ1Y3RvcihzY29wZTogQ29uc3RydWN0LCBpZDogc3RyaW5nKSB7XG4gICAgc3VwZXIoc2NvcGUsIGlkKTtcbi8vLyAhc2hvd1xuICAgIG5ldyBkc2Yuc3RvcmFnZS5BY2Nlc3NMb2dzQnVja2V0KHRoaXMsICdNeUFjY2Vzc0xvZ3MnLCB7XG4gICAgICAgIGJ1Y2tldE5hbWU6IGRzZi51dGlscy5CdWNrZXRVdGlscy5nZW5lcmF0ZVVuaXF1ZUJ1Y2tldE5hbWUodGhpcywgJ015QWNjZXNzTG9ncycsICdteS1jdXN0b20tbmFtZScpXG4gICAgfSk7XG4vLy8gIWhpZGVcbiAgfVxufVxuXG5jb25zdCBhcHAgPSBuZXcgY2RrLkFwcCgpO1xubmV3IEV4YW1wbGVBY2Nlc3NMb2dzQnVja2V0TmFtaW5nU3RhY2soYXBwLCAnRXhhbXBsZUFjY2Vzc0xvZ3NCdWNrZXROYW1pbmcnKTsiXX0=