"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const cdk = require("aws-cdk-lib");
const aws_kms_1 = require("aws-cdk-lib/aws-kms");
const dsf = require("../../index");
/// !show
class ExampleDefaultAnalyticsBucketStack extends cdk.Stack {
    constructor(scope, id) {
        super(scope, id);
        const key = new aws_kms_1.Key(this, 'DataKey', {
            enableKeyRotation: true
        });
        new dsf.storage.AnalyticsBucket(this, 'AnalyticsBucket', {
            encryptionKey: key
        });
    }
}
/// !hide
const app = new cdk.App();
new ExampleDefaultAnalyticsBucketStack(app, 'ExampleDefaultDataLakeStorage');
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiYW5hbHl0aWNzLWJ1Y2tldC1kZWZhdWx0LmxpdC5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbIi4uLy4uLy4uL3NyYy9zdG9yYWdlL2V4YW1wbGVzL2FuYWx5dGljcy1idWNrZXQtZGVmYXVsdC5saXQudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7QUFBQSxtQ0FBbUM7QUFDbkMsaURBQTBDO0FBRTFDLG1DQUFtQztBQUVuQyxTQUFTO0FBQ1QsTUFBTSxrQ0FBbUMsU0FBUSxHQUFHLENBQUMsS0FBSztJQUN0RCxZQUFZLEtBQWdCLEVBQUUsRUFBVTtRQUNwQyxLQUFLLENBQUMsS0FBSyxFQUFFLEVBQUUsQ0FBQyxDQUFDO1FBQ2pCLE1BQU0sR0FBRyxHQUFHLElBQUksYUFBRyxDQUFDLElBQUksRUFBRSxTQUFTLEVBQUU7WUFDakMsaUJBQWlCLEVBQUUsSUFBSTtTQUMxQixDQUFDLENBQUM7UUFFSCxJQUFJLEdBQUcsQ0FBQyxPQUFPLENBQUMsZUFBZSxDQUFDLElBQUksRUFBRSxpQkFBaUIsRUFBRTtZQUNyRCxhQUFhLEVBQUUsR0FBRztTQUNyQixDQUFDLENBQUM7SUFDUCxDQUFDO0NBQ0o7QUFDRCxTQUFTO0FBRVQsTUFBTSxHQUFHLEdBQUcsSUFBSSxHQUFHLENBQUMsR0FBRyxFQUFFLENBQUM7QUFDMUIsSUFBSSxrQ0FBa0MsQ0FBQyxHQUFHLEVBQUUsK0JBQStCLENBQUMsQ0FBQyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCAqIGFzIGNkayBmcm9tICdhd3MtY2RrLWxpYic7XG5pbXBvcnQgeyBLZXkgfSBmcm9tICdhd3MtY2RrLWxpYi9hd3Mta21zJztcbmltcG9ydCB7IENvbnN0cnVjdCB9IGZyb20gJ2NvbnN0cnVjdHMnO1xuaW1wb3J0ICogYXMgZHNmIGZyb20gJy4uLy4uL2luZGV4JztcblxuLy8vICFzaG93XG5jbGFzcyBFeGFtcGxlRGVmYXVsdEFuYWx5dGljc0J1Y2tldFN0YWNrIGV4dGVuZHMgY2RrLlN0YWNrIHtcbiAgICBjb25zdHJ1Y3RvcihzY29wZTogQ29uc3RydWN0LCBpZDogc3RyaW5nKSB7XG4gICAgICAgIHN1cGVyKHNjb3BlLCBpZCk7XG4gICAgICAgIGNvbnN0IGtleSA9IG5ldyBLZXkodGhpcywgJ0RhdGFLZXknLCB7XG4gICAgICAgICAgICBlbmFibGVLZXlSb3RhdGlvbjogdHJ1ZVxuICAgICAgICB9KTtcblxuICAgICAgICBuZXcgZHNmLnN0b3JhZ2UuQW5hbHl0aWNzQnVja2V0KHRoaXMsICdBbmFseXRpY3NCdWNrZXQnLCB7XG4gICAgICAgICAgICBlbmNyeXB0aW9uS2V5OiBrZXlcbiAgICAgICAgfSk7XG4gICAgfVxufVxuLy8vICFoaWRlXG5cbmNvbnN0IGFwcCA9IG5ldyBjZGsuQXBwKCk7XG5uZXcgRXhhbXBsZURlZmF1bHRBbmFseXRpY3NCdWNrZXRTdGFjayhhcHAsICdFeGFtcGxlRGVmYXVsdERhdGFMYWtlU3RvcmFnZScpOyJdfQ==