"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const cdk = require("aws-cdk-lib");
const aws_kms_1 = require("aws-cdk-lib/aws-kms");
const dsf = require("../../index");
class ExampleAnalyticsBucketNamingStack extends cdk.Stack {
    constructor(scope, id) {
        super(scope, id);
        const key = new aws_kms_1.Key(this, 'DataKey', {
            enableKeyRotation: true,
        });
        /// !show
        new dsf.storage.AnalyticsBucket(this, 'AnalyticsBucket', {
            bucketName: dsf.utils.BucketUtils.generateUniqueBucketName(this, 'AnalyticsBucket', 'my-custom-name'),
            encryptionKey: key
        });
        /// !hide
    }
}
const app = new cdk.App();
new ExampleAnalyticsBucketNamingStack(app, 'ExampleAnalyticsBucketNamingStack');
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiYW5hbHl0aWNzLWJ1Y2tldC1uYW1pbmcubGl0LmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiLi4vLi4vLi4vc3JjL3N0b3JhZ2UvZXhhbXBsZXMvYW5hbHl0aWNzLWJ1Y2tldC1uYW1pbmcubGl0LnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7O0FBQUEsbUNBQW1DO0FBQ25DLGlEQUEwQztBQUUxQyxtQ0FBbUM7QUFFbkMsTUFBTSxpQ0FBa0MsU0FBUSxHQUFHLENBQUMsS0FBSztJQUN2RCxZQUFZLEtBQWdCLEVBQUUsRUFBVTtRQUN0QyxLQUFLLENBQUMsS0FBSyxFQUFFLEVBQUUsQ0FBQyxDQUFDO1FBQ2pCLE1BQU0sR0FBRyxHQUFHLElBQUksYUFBRyxDQUFDLElBQUksRUFBRSxTQUFTLEVBQUU7WUFDbkMsaUJBQWlCLEVBQUUsSUFBSTtTQUN4QixDQUFDLENBQUM7UUFFUCxTQUFTO1FBQ0wsSUFBSSxHQUFHLENBQUMsT0FBTyxDQUFDLGVBQWUsQ0FBQyxJQUFJLEVBQUUsaUJBQWlCLEVBQUU7WUFDckQsVUFBVSxFQUFFLEdBQUcsQ0FBQyxLQUFLLENBQUMsV0FBVyxDQUFDLHdCQUF3QixDQUFDLElBQUksRUFBRSxpQkFBaUIsRUFBRSxnQkFBZ0IsQ0FBQztZQUNyRyxhQUFhLEVBQUUsR0FBRztTQUNyQixDQUFDLENBQUM7UUFDUCxTQUFTO0lBQ1AsQ0FBQztDQUNGO0FBRUQsTUFBTSxHQUFHLEdBQUcsSUFBSSxHQUFHLENBQUMsR0FBRyxFQUFFLENBQUM7QUFDMUIsSUFBSSxpQ0FBaUMsQ0FBQyxHQUFHLEVBQUUsbUNBQW1DLENBQUMsQ0FBQyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCAqIGFzIGNkayBmcm9tICdhd3MtY2RrLWxpYic7XG5pbXBvcnQgeyBLZXkgfSBmcm9tICdhd3MtY2RrLWxpYi9hd3Mta21zJztcbmltcG9ydCB7IENvbnN0cnVjdCB9IGZyb20gJ2NvbnN0cnVjdHMnO1xuaW1wb3J0ICogYXMgZHNmIGZyb20gJy4uLy4uL2luZGV4JztcblxuY2xhc3MgRXhhbXBsZUFuYWx5dGljc0J1Y2tldE5hbWluZ1N0YWNrIGV4dGVuZHMgY2RrLlN0YWNrIHtcbiAgY29uc3RydWN0b3Ioc2NvcGU6IENvbnN0cnVjdCwgaWQ6IHN0cmluZykge1xuICAgIHN1cGVyKHNjb3BlLCBpZCk7XG4gICAgY29uc3Qga2V5ID0gbmV3IEtleSh0aGlzLCAnRGF0YUtleScsIHtcbiAgICAgIGVuYWJsZUtleVJvdGF0aW9uOiB0cnVlLFxuICAgIH0pO1xuXG4vLy8gIXNob3dcbiAgICBuZXcgZHNmLnN0b3JhZ2UuQW5hbHl0aWNzQnVja2V0KHRoaXMsICdBbmFseXRpY3NCdWNrZXQnLCB7XG4gICAgICAgIGJ1Y2tldE5hbWU6IGRzZi51dGlscy5CdWNrZXRVdGlscy5nZW5lcmF0ZVVuaXF1ZUJ1Y2tldE5hbWUodGhpcywgJ0FuYWx5dGljc0J1Y2tldCcsICdteS1jdXN0b20tbmFtZScpLFxuICAgICAgICBlbmNyeXB0aW9uS2V5OiBrZXlcbiAgICB9KTtcbi8vLyAhaGlkZVxuICB9XG59XG5cbmNvbnN0IGFwcCA9IG5ldyBjZGsuQXBwKCk7XG5uZXcgRXhhbXBsZUFuYWx5dGljc0J1Y2tldE5hbWluZ1N0YWNrKGFwcCwgJ0V4YW1wbGVBbmFseXRpY3NCdWNrZXROYW1pbmdTdGFjaycpOyJdfQ==