"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const cdk = require("aws-cdk-lib");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const aws_kms_1 = require("aws-cdk-lib/aws-kms");
const dsf = require("../../index");
class ExampleAnalyticsBucketObjectRemovalStack extends cdk.Stack {
    constructor(scope, id) {
        super(scope, id);
        /// !show
        // Set context value for global data removal policy
        this.node.setContext('@data-solutions-framework-on-aws/removeDataOnDestroy', true);
        /// !hide
        /// You will also need to set removal policy
        /// !show
        const key = new aws_kms_1.Key(this, 'DataKey', {
            enableKeyRotation: true,
            removalPolicy: aws_cdk_lib_1.RemovalPolicy.DESTROY
        });
        new dsf.storage.AnalyticsBucket(this, 'AnalyticsBucket', {
            encryptionKey: key,
            removalPolicy: aws_cdk_lib_1.RemovalPolicy.DESTROY
        });
        /// !hide
    }
}
const app = new cdk.App();
new ExampleAnalyticsBucketObjectRemovalStack(app, 'ExampleAnalyticsBucketObjectRemovalStack');
//# sourceMappingURL=data:application/json;base64,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