"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const cdk = require("aws-cdk-lib");
const dsf = require("../../index");
class ExampleDefaultDataLakeStorageStack extends cdk.Stack {
    constructor(scope, id) {
        super(scope, id);
        /// !show
        new dsf.storage.DataLakeStorage(this, 'MyDataLakeStorage', {
            bronzeBucketInfrequentAccessDelay: 90,
            bronzeBucketArchiveDelay: 180,
            silverBucketInfrequentAccessDelay: 180,
            silverBucketArchiveDelay: 360,
            goldBucketInfrequentAccessDelay: 180,
            goldBucketArchiveDelay: 360,
        });
        /// !hide
    }
}
const app = new cdk.App();
new ExampleDefaultDataLakeStorageStack(app, 'ExampleDefaultDataLakeStorage');
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiZGF0YS1sYWtlLXN0b3JhZ2UtbGlmZWN5Y2xlLmxpdC5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbIi4uLy4uLy4uL3NyYy9zdG9yYWdlL2V4YW1wbGVzL2RhdGEtbGFrZS1zdG9yYWdlLWxpZmVjeWNsZS5saXQudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7QUFBQSxtQ0FBbUM7QUFFbkMsbUNBQW1DO0FBRW5DLE1BQU0sa0NBQW1DLFNBQVEsR0FBRyxDQUFDLEtBQUs7SUFDeEQsWUFBWSxLQUFnQixFQUFFLEVBQVU7UUFDdEMsS0FBSyxDQUFDLEtBQUssRUFBRSxFQUFFLENBQUMsQ0FBQztRQUNyQixTQUFTO1FBQ0wsSUFBSSxHQUFHLENBQUMsT0FBTyxDQUFDLGVBQWUsQ0FBQyxJQUFJLEVBQUUsbUJBQW1CLEVBQUU7WUFDdkQsaUNBQWlDLEVBQUUsRUFBRTtZQUNyQyx3QkFBd0IsRUFBRSxHQUFHO1lBQzdCLGlDQUFpQyxFQUFFLEdBQUc7WUFDdEMsd0JBQXdCLEVBQUUsR0FBRztZQUM3QiwrQkFBK0IsRUFBRSxHQUFHO1lBQ3BDLHNCQUFzQixFQUFFLEdBQUc7U0FDOUIsQ0FBQyxDQUFDO1FBQ1AsU0FBUztJQUNQLENBQUM7Q0FDRjtBQUVELE1BQU0sR0FBRyxHQUFHLElBQUksR0FBRyxDQUFDLEdBQUcsRUFBRSxDQUFDO0FBQzFCLElBQUksa0NBQWtDLENBQUMsR0FBRyxFQUFFLCtCQUErQixDQUFDLENBQUMiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgKiBhcyBjZGsgZnJvbSAnYXdzLWNkay1saWInO1xuaW1wb3J0IHsgQ29uc3RydWN0IH0gZnJvbSAnY29uc3RydWN0cyc7XG5pbXBvcnQgKiBhcyBkc2YgZnJvbSAnLi4vLi4vaW5kZXgnO1xuXG5jbGFzcyBFeGFtcGxlRGVmYXVsdERhdGFMYWtlU3RvcmFnZVN0YWNrIGV4dGVuZHMgY2RrLlN0YWNrIHtcbiAgY29uc3RydWN0b3Ioc2NvcGU6IENvbnN0cnVjdCwgaWQ6IHN0cmluZykge1xuICAgIHN1cGVyKHNjb3BlLCBpZCk7XG4vLy8gIXNob3dcbiAgICBuZXcgZHNmLnN0b3JhZ2UuRGF0YUxha2VTdG9yYWdlKHRoaXMsICdNeURhdGFMYWtlU3RvcmFnZScsIHtcbiAgICAgICAgYnJvbnplQnVja2V0SW5mcmVxdWVudEFjY2Vzc0RlbGF5OiA5MCxcbiAgICAgICAgYnJvbnplQnVja2V0QXJjaGl2ZURlbGF5OiAxODAsXG4gICAgICAgIHNpbHZlckJ1Y2tldEluZnJlcXVlbnRBY2Nlc3NEZWxheTogMTgwLFxuICAgICAgICBzaWx2ZXJCdWNrZXRBcmNoaXZlRGVsYXk6IDM2MCxcbiAgICAgICAgZ29sZEJ1Y2tldEluZnJlcXVlbnRBY2Nlc3NEZWxheTogMTgwLFxuICAgICAgICBnb2xkQnVja2V0QXJjaGl2ZURlbGF5OiAzNjAsXG4gICAgfSk7XG4vLy8gIWhpZGVcbiAgfVxufVxuXG5jb25zdCBhcHAgPSBuZXcgY2RrLkFwcCgpO1xubmV3IEV4YW1wbGVEZWZhdWx0RGF0YUxha2VTdG9yYWdlU3RhY2soYXBwLCAnRXhhbXBsZURlZmF1bHREYXRhTGFrZVN0b3JhZ2UnKTsiXX0=