"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const cdk = require("aws-cdk-lib");
const dsf = require("../../index");
class ExampleDataLakeStorageNamingStack extends cdk.Stack {
    constructor(scope, id) {
        super(scope, id);
        /// !show
        new dsf.storage.DataLakeStorage(this, 'MyDataLakeStorage', {
            bronzeBucketName: dsf.utils.BucketUtils.generateUniqueBucketName(this, 'MyDataLakeStorage', 'custom-bronze-name')
        });
        /// !hide
    }
}
const app = new cdk.App();
new ExampleDataLakeStorageNamingStack(app, 'ExampleDataLakeStorageNamingStack');
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiZGF0YS1sYWtlLXN0b3JhZ2UtbmFtaW5nLmxpdC5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbIi4uLy4uLy4uL3NyYy9zdG9yYWdlL2V4YW1wbGVzL2RhdGEtbGFrZS1zdG9yYWdlLW5hbWluZy5saXQudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7QUFBQSxtQ0FBbUM7QUFFbkMsbUNBQW1DO0FBRW5DLE1BQU0saUNBQWtDLFNBQVEsR0FBRyxDQUFDLEtBQUs7SUFDdkQsWUFBWSxLQUFnQixFQUFFLEVBQVU7UUFDdEMsS0FBSyxDQUFDLEtBQUssRUFBRSxFQUFFLENBQUMsQ0FBQztRQUNyQixTQUFTO1FBQ0wsSUFBSSxHQUFHLENBQUMsT0FBTyxDQUFDLGVBQWUsQ0FBQyxJQUFJLEVBQUUsbUJBQW1CLEVBQUU7WUFDdkQsZ0JBQWdCLEVBQUUsR0FBRyxDQUFDLEtBQUssQ0FBQyxXQUFXLENBQUMsd0JBQXdCLENBQUMsSUFBSSxFQUFFLG1CQUFtQixFQUFFLG9CQUFvQixDQUFDO1NBQ3BILENBQUMsQ0FBQztRQUNQLFNBQVM7SUFDUCxDQUFDO0NBQ0Y7QUFFRCxNQUFNLEdBQUcsR0FBRyxJQUFJLEdBQUcsQ0FBQyxHQUFHLEVBQUUsQ0FBQztBQUMxQixJQUFJLGlDQUFpQyxDQUFDLEdBQUcsRUFBRSxtQ0FBbUMsQ0FBQyxDQUFDIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0ICogYXMgY2RrIGZyb20gJ2F3cy1jZGstbGliJztcbmltcG9ydCB7IENvbnN0cnVjdCB9IGZyb20gJ2NvbnN0cnVjdHMnO1xuaW1wb3J0ICogYXMgZHNmIGZyb20gJy4uLy4uL2luZGV4JztcblxuY2xhc3MgRXhhbXBsZURhdGFMYWtlU3RvcmFnZU5hbWluZ1N0YWNrIGV4dGVuZHMgY2RrLlN0YWNrIHtcbiAgY29uc3RydWN0b3Ioc2NvcGU6IENvbnN0cnVjdCwgaWQ6IHN0cmluZykge1xuICAgIHN1cGVyKHNjb3BlLCBpZCk7XG4vLy8gIXNob3dcbiAgICBuZXcgZHNmLnN0b3JhZ2UuRGF0YUxha2VTdG9yYWdlKHRoaXMsICdNeURhdGFMYWtlU3RvcmFnZScsIHtcbiAgICAgICAgYnJvbnplQnVja2V0TmFtZTogZHNmLnV0aWxzLkJ1Y2tldFV0aWxzLmdlbmVyYXRlVW5pcXVlQnVja2V0TmFtZSh0aGlzLCAnTXlEYXRhTGFrZVN0b3JhZ2UnLCAnY3VzdG9tLWJyb256ZS1uYW1lJylcbiAgICB9KTtcbi8vLyAhaGlkZVxuICB9XG59XG5cbmNvbnN0IGFwcCA9IG5ldyBjZGsuQXBwKCk7XG5uZXcgRXhhbXBsZURhdGFMYWtlU3RvcmFnZU5hbWluZ1N0YWNrKGFwcCwgJ0V4YW1wbGVEYXRhTGFrZVN0b3JhZ2VOYW1pbmdTdGFjaycpOyJdfQ==