"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const cdk = require("aws-cdk-lib");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const dsf = require("../../index");
class ExampleDataLakeStorageObjectRemovalStack extends cdk.Stack {
    constructor(scope, id) {
        super(scope, id);
        /// !show
        // Set context value for global data removal policy
        this.node.setContext('@data-solutions-framework-on-aws/removeDataOnDestroy', true);
        /// !hide
        /// You will also need to set removal policy for the `DataLakeStorage` construct:
        /// !show
        new dsf.storage.DataLakeStorage(this, 'DataLakeStorage', {
            removalPolicy: aws_cdk_lib_1.RemovalPolicy.DESTROY
        });
        /// !hide
    }
}
const app = new cdk.App();
new ExampleDataLakeStorageObjectRemovalStack(app, 'ExampleDataLakeStorageObjectRemovalStack');
//# sourceMappingURL=data:application/json;base64,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