import { Bucket, BucketProps } from 'aws-cdk-lib/aws-s3';
import { Construct } from 'constructs';
/**
 * Amazon S3 Bucket configured with best-practices and smart defaults for storing S3 access logs.
 * Default bucket name is `accesslogs-<AWS_ACCOUNT_ID>-<AWS_REGION>-<UNIQUE_ID>`
 * @see https://awslabs.github.io/data-solutions-framework-on-aws/docs/constructs/library/access-logs-bucket
 *
 * @example
 * const bucket = new dsf.storage.AccessLogsBucket(this, 'AccessLogsBucket', {
 *  removalPolicy: cdk.RemovalPolicy.DESTROY,
 * })
 *
 */
export declare class AccessLogsBucket extends Bucket {
    constructor(scope: Construct, id: string, props?: BucketProps);
}
