"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.AccessLogsBucket = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
// Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
// SPDX-License-Identifier: MIT-0
const aws_cdk_lib_1 = require("aws-cdk-lib");
const aws_s3_1 = require("aws-cdk-lib/aws-s3");
const utils_1 = require("../../utils");
/**
 * Amazon S3 Bucket configured with best-practices and smart defaults for storing S3 access logs.
 * Default bucket name is `accesslogs-<AWS_ACCOUNT_ID>-<AWS_REGION>-<UNIQUE_ID>`
 * @see https://awslabs.github.io/data-solutions-framework-on-aws/docs/constructs/library/access-logs-bucket
 *
 * @example
 * const bucket = new dsf.storage.AccessLogsBucket(this, 'AccessLogsBucket', {
 *  removalPolicy: cdk.RemovalPolicy.DESTROY,
 * })
 *
 */
class AccessLogsBucket extends aws_s3_1.Bucket {
    constructor(scope, id, props) {
        const bucketName = props?.bucketName || utils_1.BucketUtils.generateUniqueBucketName(scope, id, 'accesslogs');
        const removalPolicy = utils_1.Context.revertRemovalPolicy(scope, props?.removalPolicy);
        const autoDeleteObjects = removalPolicy == aws_cdk_lib_1.RemovalPolicy.DESTROY;
        super(scope, id, {
            ...props,
            bucketName: bucketName,
            encryption: props?.encryption || aws_s3_1.BucketEncryption.S3_MANAGED,
            enforceSSL: props?.enforceSSL || true,
            blockPublicAccess: props?.blockPublicAccess || aws_s3_1.BlockPublicAccess.BLOCK_ALL,
            removalPolicy,
            autoDeleteObjects,
        });
    }
}
_a = JSII_RTTI_SYMBOL_1;
AccessLogsBucket[_a] = { fqn: "aws-dsf.storage.AccessLogsBucket", version: "1.0.0-rc.3" };
exports.AccessLogsBucket = AccessLogsBucket;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiYWNjZXNzLWxvZ3MtYnVja2V0LmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiLi4vLi4vLi4vc3JjL3N0b3JhZ2UvbGliL2FjY2Vzcy1sb2dzLWJ1Y2tldC50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7OztBQUFBLHFFQUFxRTtBQUNyRSxpQ0FBaUM7QUFHakMsNkNBQTRDO0FBQzVDLCtDQUE4RjtBQUU5Rix1Q0FBbUQ7QUFFbkQ7Ozs7Ozs7Ozs7R0FVRztBQUNILE1BQWEsZ0JBQWlCLFNBQVEsZUFBTTtJQUMxQyxZQUFZLEtBQWdCLEVBQUUsRUFBVSxFQUFFLEtBQW1CO1FBRTNELE1BQU0sVUFBVSxHQUFHLEtBQUssRUFBRSxVQUFVLElBQUksbUJBQVcsQ0FBQyx3QkFBd0IsQ0FBQyxLQUFLLEVBQUUsRUFBRSxFQUFFLFlBQVksQ0FBQyxDQUFDO1FBQ3RHLE1BQU0sYUFBYSxHQUFHLGVBQU8sQ0FBQyxtQkFBbUIsQ0FBQyxLQUFLLEVBQUUsS0FBSyxFQUFFLGFBQWEsQ0FBQyxDQUFDO1FBQy9FLE1BQU0saUJBQWlCLEdBQUcsYUFBYSxJQUFJLDJCQUFhLENBQUMsT0FBTyxDQUFDO1FBRWpFLEtBQUssQ0FBQyxLQUFLLEVBQUUsRUFBRSxFQUFFO1lBQ2YsR0FBRyxLQUFLO1lBQ1IsVUFBVSxFQUFFLFVBQVU7WUFDdEIsVUFBVSxFQUFFLEtBQUssRUFBRSxVQUFVLElBQUkseUJBQWdCLENBQUMsVUFBVTtZQUM1RCxVQUFVLEVBQUUsS0FBSyxFQUFFLFVBQVUsSUFBSSxJQUFJO1lBQ3JDLGlCQUFpQixFQUFFLEtBQUssRUFBRSxpQkFBaUIsSUFBSSwwQkFBaUIsQ0FBQyxTQUFTO1lBQzFFLGFBQWE7WUFDYixpQkFBaUI7U0FDbEIsQ0FBQyxDQUFDO0lBQ0wsQ0FBQzs7OztBQWhCVSw0Q0FBZ0IiLCJzb3VyY2VzQ29udGVudCI6WyIvLyBDb3B5cmlnaHQgQW1hem9uLmNvbSwgSW5jLiBvciBpdHMgYWZmaWxpYXRlcy4gQWxsIFJpZ2h0cyBSZXNlcnZlZC5cbi8vIFNQRFgtTGljZW5zZS1JZGVudGlmaWVyOiBNSVQtMFxuXG5cbmltcG9ydCB7IFJlbW92YWxQb2xpY3kgfSBmcm9tICdhd3MtY2RrLWxpYic7XG5pbXBvcnQgeyBCdWNrZXQsIEJ1Y2tldFByb3BzLCBCdWNrZXRFbmNyeXB0aW9uLCBCbG9ja1B1YmxpY0FjY2VzcyB9IGZyb20gJ2F3cy1jZGstbGliL2F3cy1zMyc7XG5pbXBvcnQgeyBDb25zdHJ1Y3QgfSBmcm9tICdjb25zdHJ1Y3RzJztcbmltcG9ydCB7IEJ1Y2tldFV0aWxzLCBDb250ZXh0IH0gZnJvbSAnLi4vLi4vdXRpbHMnO1xuXG4vKipcbiAqIEFtYXpvbiBTMyBCdWNrZXQgY29uZmlndXJlZCB3aXRoIGJlc3QtcHJhY3RpY2VzIGFuZCBzbWFydCBkZWZhdWx0cyBmb3Igc3RvcmluZyBTMyBhY2Nlc3MgbG9ncy5cbiAqIERlZmF1bHQgYnVja2V0IG5hbWUgaXMgYGFjY2Vzc2xvZ3MtPEFXU19BQ0NPVU5UX0lEPi08QVdTX1JFR0lPTj4tPFVOSVFVRV9JRD5gXG4gKiBAc2VlIGh0dHBzOi8vYXdzbGFicy5naXRodWIuaW8vZGF0YS1zb2x1dGlvbnMtZnJhbWV3b3JrLW9uLWF3cy9kb2NzL2NvbnN0cnVjdHMvbGlicmFyeS9hY2Nlc3MtbG9ncy1idWNrZXRcbiAqXG4gKiBAZXhhbXBsZVxuICogY29uc3QgYnVja2V0ID0gbmV3IGRzZi5zdG9yYWdlLkFjY2Vzc0xvZ3NCdWNrZXQodGhpcywgJ0FjY2Vzc0xvZ3NCdWNrZXQnLCB7XG4gKiAgcmVtb3ZhbFBvbGljeTogY2RrLlJlbW92YWxQb2xpY3kuREVTVFJPWSxcbiAqIH0pXG4gKlxuICovXG5leHBvcnQgY2xhc3MgQWNjZXNzTG9nc0J1Y2tldCBleHRlbmRzIEJ1Y2tldCB7XG4gIGNvbnN0cnVjdG9yKHNjb3BlOiBDb25zdHJ1Y3QsIGlkOiBzdHJpbmcsIHByb3BzPzogQnVja2V0UHJvcHMpIHtcblxuICAgIGNvbnN0IGJ1Y2tldE5hbWUgPSBwcm9wcz8uYnVja2V0TmFtZSB8fCBCdWNrZXRVdGlscy5nZW5lcmF0ZVVuaXF1ZUJ1Y2tldE5hbWUoc2NvcGUsIGlkLCAnYWNjZXNzbG9ncycpO1xuICAgIGNvbnN0IHJlbW92YWxQb2xpY3kgPSBDb250ZXh0LnJldmVydFJlbW92YWxQb2xpY3koc2NvcGUsIHByb3BzPy5yZW1vdmFsUG9saWN5KTtcbiAgICBjb25zdCBhdXRvRGVsZXRlT2JqZWN0cyA9IHJlbW92YWxQb2xpY3kgPT0gUmVtb3ZhbFBvbGljeS5ERVNUUk9ZO1xuXG4gICAgc3VwZXIoc2NvcGUsIGlkLCB7XG4gICAgICAuLi5wcm9wcyxcbiAgICAgIGJ1Y2tldE5hbWU6IGJ1Y2tldE5hbWUsXG4gICAgICBlbmNyeXB0aW9uOiBwcm9wcz8uZW5jcnlwdGlvbiB8fCBCdWNrZXRFbmNyeXB0aW9uLlMzX01BTkFHRUQsXG4gICAgICBlbmZvcmNlU1NMOiBwcm9wcz8uZW5mb3JjZVNTTCB8fCB0cnVlLFxuICAgICAgYmxvY2tQdWJsaWNBY2Nlc3M6IHByb3BzPy5ibG9ja1B1YmxpY0FjY2VzcyB8fCBCbG9ja1B1YmxpY0FjY2Vzcy5CTE9DS19BTEwsXG4gICAgICByZW1vdmFsUG9saWN5LFxuICAgICAgYXV0b0RlbGV0ZU9iamVjdHMsXG4gICAgfSk7XG4gIH1cbn0iXX0=