import { Bucket } from 'aws-cdk-lib/aws-s3';
import { Construct } from 'constructs';
import { AnalyticsBucketProps } from './analytics-bucket-props';
/**
* Amazon S3 Bucket configured with best-practices and defaults for analytics.
* The default bucket name is `analytics-<AWS_ACCOUNT_ID>-<AWS_REGION>-<UNIQUE_ID>`
* @see https://awslabs.github.io/data-solutions-framework-on-aws/docs/constructs/library/analytics-bucket
*
* @example
* import { Key } from 'aws-cdk-lib/aws-kms';
*
* // Set context value for global data removal policy (or set in cdk.json).
* this.node.setContext('@data-solutions-framework-on-aws/removeDataOnDestroy', true);
*
* const encryptionKey = new Key(this, 'DataKey', {
*  removalPolicy: cdk.RemovalPolicy.DESTROY,
*  enableKeyRotation: true,
* });
*
* new dsf.storage.AnalyticsBucket(this, 'MyAnalyticsBucket', {
*  encryptionKey,
*  removalPolicy: cdk.RemovalPolicy.DESTROY,
* });
*/
export declare class AnalyticsBucket extends Bucket {
    private static LIFECYCLE_RULE;
    constructor(scope: Construct, id: string, props: AnalyticsBucketProps);
}
