"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const cdk = require("aws-cdk-lib");
const dsf = require("../../index");
class ExampleCustomizationL1Stack extends cdk.Stack {
    constructor(scope, id) {
        super(scope, id);
        /// !show
        // Create a data lake using DSF on AWS L3 construct
        const storage = new dsf.storage.DataLakeStorage(this, 'MyDataLakeStorage');
        // Access the CDK L1 Bucket construct exposed by the L3 construct
        const cfnBucket = storage.goldBucket.node.defaultChild;
        // Override the CloudFormation property for transfer acceleration
        cfnBucket.addOverride('Properties.AccelerateConfiguration.AccelerationStatus', 'Enabled');
        /// !hide
    }
}
const app = new cdk.App();
new ExampleCustomizationL1Stack(app, 'ExampleCustomizationL1Stack');
//# sourceMappingURL=data:application/json;base64,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