"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const cdk = require("aws-cdk-lib");
const dsf = require("../../index");
class ExampleCustomizationL1Stack extends cdk.Stack {
    constructor(scope, id) {
        super(scope, id);
        /// !show
        // Create a data lake using DSF on AWS L3 construct
        const storage = new dsf.storage.DataLakeStorage(this, 'MyDataLakeStorage');
        // Access the CDK L1 Bucket construct exposed by the L3 construct
        const cfnBucket = storage.goldBucket.node.defaultChild;
        // Override the CDK L1 property for transfer acceleration
        cfnBucket.accelerateConfiguration = {
            accelerationStatus: 'Enabled',
        };
        /// !hide
    }
}
const app = new cdk.App();
new ExampleCustomizationL1Stack(app, 'ExampleCustomizationL1Stack');
//# sourceMappingURL=data:application/json;base64,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