"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const cdk = require("aws-cdk-lib");
const dsf = require("../../index");
const aws_cdk_lib_1 = require("aws-cdk-lib");
class ExampleCustomizationL2Stack extends cdk.Stack {
    constructor(scope, id) {
        super(scope, id);
        /// !show
        // Create a data lake using DSF on AWS L3 construct
        const storage = new dsf.storage.DataLakeStorage(this, 'MyDataLakeStorage');
        // Access the CDK L2 Bucket construct exposed by the L3 construct
        const goldBucket = storage.goldBucket;
        // Use the Bucket CDK API to modify the Bucket Policy and add cross account write access
        goldBucket.addToResourcePolicy(new aws_cdk_lib_1.aws_iam.PolicyStatement({
            actions: [
                's3:GetObject',
                's3:PutObject',
                's3:DeleteObject',
                's3:ListBucketMultipartUploads',
                's3:ListMultipartUploadParts',
                's3:AbortMultipartUpload',
                's3:ListBucket',
            ],
            effect: aws_cdk_lib_1.aws_iam.Effect.ALLOW,
            principals: [new aws_cdk_lib_1.aws_iam.AccountPrincipal('123456789012')]
        }));
        /// !hide
    }
}
const app = new cdk.App();
new ExampleCustomizationL2Stack(app, 'ExampleCustomizationL2Stack');
//# sourceMappingURL=data:application/json;base64,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