"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ApplicationStackFactory = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/**
 * Abstract class that needs to be implemented to pass the application Stack to the CICD pipeline.
 *
 * @exampleMetadata fixture=imports-only
 * @example
 * interface MyApplicationStackProps extends cdk.StackProps {
 *   readonly stage: dsf.utils.CICDStage;
 * }
 *
 * class MyApplicationStack extends cdk.Stack {
 *   constructor(scope: Construct, id: string, props?: MyApplicationStackProps) {
 *     super(scope, id, props);
 *     // stack logic goes here... and can be customized using props.stage
 *   }
 * }
 *
 * class MyApplicationStackFactory extends dsf.utils.ApplicationStackFactory {
 *   createStack(scope: Construct, stage: dsf.utils.CICDStage): cdk.Stack {
 *     return new MyApplicationStack(scope, 'MyApplication', {
 *       stage: stage
 *     } as MyApplicationStackProps);
 *   }
 * }
 */
class ApplicationStackFactory {
}
_a = JSII_RTTI_SYMBOL_1;
ApplicationStackFactory[_a] = { fqn: "aws-dsf.utils.ApplicationStackFactory", version: "1.0.0-rc.3" };
exports.ApplicationStackFactory = ApplicationStackFactory;
//# sourceMappingURL=data:application/json;base64,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