import { CfnOutput, Stage, StageProps } from 'aws-cdk-lib';
import { Construct } from 'constructs';
import { ApplicationStackFactory } from './application-stack-factory';
/**
 * The list of CICD Stages to deploy the SparkCICDStack.
 */
export declare enum CICDStage {
    STAGING = "staging",
    PROD = "prod"
}
/**
 * Properties for SparkCICDStage class.
 */
export interface ApplicationStageProps extends StageProps {
    /**
     * The application Stack to deploy in the different CDK Pipelines Stages
     */
    readonly applicationStackFactory: ApplicationStackFactory;
    /**
     * The list of values to create CfnOutputs
     * @default - No CfnOutputs are created
     */
    readonly outputsEnv?: Record<string, string>;
    /**
     * The Stage to deploy the SparkCICDStack in
     * @default - No stage is passed to the application stack
     */
    readonly stage: CICDStage;
}
/**
 * ApplicationStage class that creates a CDK Pipelines Stage from an ApplicationStackFactory.
 *
 */
export declare class ApplicationStage extends Stage {
    /**
     * The list of CfnOutputs created by the CDK Stack
     */
    readonly stackOutputsEnv?: Record<string, CfnOutput>;
    /**
     * Construct a new instance of the SparkCICDStage class.
     * @param {Construct} scope the Scope of the CDK Construct
     * @param {string} id the ID of the CDK Construct
     * @param {ApplicationStageProps} props the ApplicationStage properties
     */
    constructor(scope: Construct, id: string, props: ApplicationStageProps);
}
